# -*- Mode: Java; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*-
# This Source Code Form is subject to the terms of the Mozilla Public
# License, v. 2.0. If a copy of the MPL was not distributed with this
# file, You can obtain one at http://mozilla.org/MPL/2.0/.

      <menugroup id="context-navigation">
        <menuitem id="context-back"
                  class="menuitem-iconic"
                  tooltiptext="&backButton.tooltip;"
                  aria-label="&backCmd.label;"
                  command="Browser:BackOrBackDuplicate"
                  accesskey="&backCmd.accesskey;"
                  onclick="checkForMiddleClick(this, event);"/>
        <menuitem id="context-forward"
                  class="menuitem-iconic"
                  tooltiptext="&forwardButton.tooltip;"
                  aria-label="&forwardCmd.label;"
                  command="Browser:ForwardOrForwardDuplicate"
                  accesskey="&forwardCmd.accesskey;"
                  onclick="checkForMiddleClick(this, event);"/>
        <menuitem id="context-reload"
                  class="menuitem-iconic"
                  tooltip="dynamic-shortcut-tooltip"
                  aria-label="&reloadCmd.label;"
                  oncommand="gContextMenu.reload(event);"
                  accesskey="&reloadCmd.accesskey;"
                  onclick="checkForMiddleClick(this, event);"/>
        <menuitem id="context-stop"
                  class="menuitem-iconic"
                  tooltip="dynamic-shortcut-tooltip"
                  aria-label="&stopCmd.label;"
                  accesskey="&stopCmd.accesskey;"
                  command="Browser:Stop"/>
        <menuitem id="context-bookmarkpage"
                  class="menuitem-iconic"
                  aria-label="&bookmarkPageCmd2.label;"
                  accesskey="&bookmarkPageCmd2.accesskey;"
                  oncommand="gContextMenu.bookmarkThisPage();"/>
      </menugroup>
      <menuseparator id="context-sep-navigation"/>
      <menuseparator id="page-menu-separator"/>
      <menuitem id="spell-no-suggestions"
                disabled="true"
                label="&spellNoSuggestions.label;"/>
      <menuitem id="spell-add-to-dictionary"
                label="&spellAddToDictionary.label;"
                accesskey="&spellAddToDictionary.accesskey;"
                oncommand="InlineSpellCheckerUI.addToDictionary();"/>
      <menuitem id="spell-undo-add-to-dictionary"
                label="&spellUndoAddToDictionary.label;"
                accesskey="&spellUndoAddToDictionary.accesskey;"
                oncommand="InlineSpellCheckerUI.undoAddToDictionary();" />
      <menuseparator id="spell-suggestions-separator"/>
      <menuitem id="context-openlinkincurrent"
                label="&openLinkCmdInCurrent.label;"
                accesskey="&openLinkCmdInCurrent.accesskey;"
                oncommand="gContextMenu.openLinkInCurrent();"/>
# label and data-usercontextid are dynamically set.
      <menuitem id="context-openlinkincontainertab"
                accesskey="&openLinkCmdInTab.accesskey;"
                oncommand="gContextMenu.openLinkInTab(event);"/>
      <menuitem id="context-openlinkintab"
                label="&openLinkCmdInTab.label;"
                accesskey="&openLinkCmdInTab.accesskey;"
                data-usercontextid="0"
                oncommand="gContextMenu.openLinkInTab(event);"/>

      <menu id="context-openlinkinusercontext-menu"
            label="&openLinkCmdInContainerTab.label;"
            accesskey="&openLinkCmdInContainerTab.accesskey;"
            hidden="true">
        <menupopup oncommand="gContextMenu.openLinkInTab(event);"
                   onpopupshowing="return gContextMenu.createContainerMenu(event);" />
      </menu>

      <menuitem id="context-openlink"
                label="&openLinkCmd.label;"
                accesskey="&openLinkCmd.accesskey;"
                oncommand="gContextMenu.openLink();"/>
      <menuitem id="context-openlinkprivate"
                label="&openLinkInPrivateWindowCmd.label;"
                accesskey="&openLinkInPrivateWindowCmd.accesskey;"
                oncommand="gContextMenu.openLinkInPrivateWindow();"/>
      <menuseparator id="context-sep-open"/>
      <menuitem id="context-bookmarklink"
                label="&bookmarkThisLinkCmd.label;"
                accesskey="&bookmarkThisLinkCmd.accesskey;"
                oncommand="gContextMenu.bookmarkLink();"/>
      <menuitem id="context-savelink"
                label="&saveLinkCmd.label;"
                accesskey="&saveLinkCmd.accesskey;"
                oncommand="gContextMenu.saveLink();"/>
      <menuitem id="context-copyemail"
                label="&copyEmailCmd.label;"
                accesskey="&copyEmailCmd.accesskey;"
                oncommand="gContextMenu.copyEmail();"/>
      <menuitem id="context-copylink"
                label="&copyLinkCmd.label;"
                accesskey="&copyLinkCmd.accesskey;"
                oncommand="gContextMenu.copyLink();"/>
      <menuseparator id="context-sep-copylink"/>
      <menuitem id="context-media-play"
                label="&mediaPlay.label;"
                accesskey="&mediaPlay.accesskey;"
                oncommand="gContextMenu.mediaCommand('play');"/>
      <menuitem id="context-media-pause"
                label="&mediaPause.label;"
                accesskey="&mediaPause.accesskey;"
                oncommand="gContextMenu.mediaCommand('pause');"/>
      <menuitem id="context-media-mute"
                label="&mediaMute.label;"
                accesskey="&mediaMute.accesskey;"
                oncommand="gContextMenu.mediaCommand('mute');"/>
      <menuitem id="context-media-unmute"
                label="&mediaUnmute.label;"
                accesskey="&mediaUnmute.accesskey;"
                oncommand="gContextMenu.mediaCommand('unmute');"/>
      <menu id="context-media-playbackrate" label="&mediaPlaybackRate2.label;" accesskey="&mediaPlaybackRate2.accesskey;">
        <menupopup>
          <menuitem id="context-media-playbackrate-050x"
                    label="&mediaPlaybackRate050x2.label;"
                    accesskey="&mediaPlaybackRate050x2.accesskey;"
                    type="radio"
                    name="playbackrate"
                    oncommand="gContextMenu.mediaCommand('playbackRate', 0.5);"/>
          <menuitem id="context-media-playbackrate-100x"
                    label="&mediaPlaybackRate100x2.label;"
                    accesskey="&mediaPlaybackRate100x2.accesskey;"
                    type="radio"
                    name="playbackrate"
                    checked="true"
                    oncommand="gContextMenu.mediaCommand('playbackRate', 1.0);"/>
          <menuitem id="context-media-playbackrate-125x"
                    label="&mediaPlaybackRate125x2.label;"
                    accesskey="&mediaPlaybackRate125x2.accesskey;"
                    type="radio"
                    name="playbackrate"
                    oncommand="gContextMenu.mediaCommand('playbackRate', 1.25);"/>
          <menuitem id="context-media-playbackrate-150x"
                    label="&mediaPlaybackRate150x2.label;"
                    accesskey="&mediaPlaybackRate150x2.accesskey;"
                    type="radio"
                    name="playbackrate"
                    oncommand="gContextMenu.mediaCommand('playbackRate', 1.5);"/>
          <menuitem id="context-media-playbackrate-200x"
                    label="&mediaPlaybackRate200x2.label;"
                    accesskey="&mediaPlaybackRate200x2.accesskey;"
                    type="radio"
                    name="playbackrate"
                    oncommand="gContextMenu.mediaCommand('playbackRate', 2.0);"/>
        </menupopup>
      </menu>
      <menuitem id="context-media-loop"
                label="&mediaLoop.label;"
                accesskey="&mediaLoop.accesskey;"
                type="checkbox"
                oncommand="gContextMenu.mediaCommand('loop');"/>
      <menuitem id="context-media-showcontrols"
                label="&mediaShowControls.label;"
                accesskey="&mediaShowControls.accesskey;"
                oncommand="gContextMenu.mediaCommand('showcontrols');"/>
      <menuitem id="context-media-hidecontrols"
                label="&mediaHideControls.label;"
                accesskey="&mediaHideControls.accesskey;"
                oncommand="gContextMenu.mediaCommand('hidecontrols');"/>
      <menuitem id="context-video-fullscreen"
                accesskey="&videoFullScreen.accesskey;"
                label="&videoFullScreen.label;"
                oncommand="gContextMenu.mediaCommand('fullscreen');"/>
      <menuitem id="context-leave-dom-fullscreen"
                accesskey="&leaveDOMFullScreen.accesskey;"
                label="&leaveDOMFullScreen.label;"
                oncommand="gContextMenu.leaveDOMFullScreen();"/>
      <menuseparator id="context-media-sep-commands"/>
      <menuitem id="context-reloadimage"
                label="&reloadImageCmd.label;"
                accesskey="&reloadImageCmd.accesskey;"
                oncommand="gContextMenu.reloadImage();"/>
      <menuitem id="context-viewimage"
                label="&viewImageCmd.label;"
                accesskey="&viewImageCmd.accesskey;"
                oncommand="gContextMenu.viewMedia(event);"
                onclick="checkForMiddleClick(this, event);"/>
      <menuitem id="context-viewvideo"
                label="&viewVideoCmd.label;"
                accesskey="&viewVideoCmd.accesskey;"
                oncommand="gContextMenu.viewMedia(event);"
                onclick="checkForMiddleClick(this, event);"/>
#ifdef CONTEXT_COPY_IMAGE_CONTENTS
      <menuitem id="context-copyimage-contents"
                label="&copyImageContentsCmd.label;"
                accesskey="&copyImageContentsCmd.accesskey;"
                oncommand="goDoCommand('cmd_copyImage');"/>
#endif
      <menuitem id="context-copyimage"
                label="&copyImageCmd.label;"
                accesskey="&copyImageCmd.accesskey;"
                oncommand="gContextMenu.copyMediaLocation();"/>
      <menuitem id="context-copyvideourl"
                label="&copyVideoURLCmd.label;"
                accesskey="&copyVideoURLCmd.accesskey;"
                oncommand="gContextMenu.copyMediaLocation();"/>
      <menuitem id="context-copyaudiourl"
                label="&copyAudioURLCmd.label;"
                accesskey="&copyAudioURLCmd.accesskey;"
                oncommand="gContextMenu.copyMediaLocation();"/>
      <menuseparator id="context-sep-copyimage"/>
      <menuitem id="context-saveimage"
                label="&saveImageCmd.label;"
                accesskey="&saveImageCmd.accesskey;"
                oncommand="gContextMenu.saveMedia();"/>
      <menuitem id="context-sendimage"
                label="&emailImageCmd.label;"
                accesskey="&emailImageCmd.accesskey;"
                oncommand="gContextMenu.sendMedia();"/>
      <menuitem id="context-setDesktopBackground"
                label="&setDesktopBackgroundCmd.label;"
                accesskey="&setDesktopBackgroundCmd.accesskey;"
                oncommand="gContextMenu.setDesktopBackground();"/>
      <menuitem id="context-viewimageinfo"
                label="&viewImageInfoCmd.label;"
                accesskey="&viewImageInfoCmd.accesskey;"
                oncommand="gContextMenu.viewImageInfo();"/>
      <menuitem id="context-viewimagedesc"
                label="&viewImageDescCmd.label;"
                accesskey="&viewImageDescCmd.accesskey;"
                oncommand="gContextMenu.viewImageDesc(event);"
                onclick="checkForMiddleClick(this, event);"/>
      <menuitem id="context-savevideo"
                label="&saveVideoCmd.label;"
                accesskey="&saveVideoCmd.accesskey;"
                oncommand="gContextMenu.saveMedia();"/>
      <menuitem id="context-saveaudio"
                label="&saveAudioCmd.label;"
                accesskey="&saveAudioCmd.accesskey;"
                oncommand="gContextMenu.saveMedia();"/>
      <menuitem id="context-video-saveimage"
                accesskey="&videoSaveImage.accesskey;"
                label="&videoSaveImage.label;"
                oncommand="gContextMenu.saveVideoFrameAsImage();"/>
      <menuitem id="context-sendvideo"
                label="&emailVideoCmd.label;"
                accesskey="&emailVideoCmd.accesskey;"
                oncommand="gContextMenu.sendMedia();"/>
      <menuitem id="context-sendaudio"
                label="&emailAudioCmd.label;"
                accesskey="&emailAudioCmd.accesskey;"
                oncommand="gContextMenu.sendMedia();"/>
      <menuitem id="context-ctp-play"
                label="&playPluginCmd.label;"
                accesskey="&playPluginCmd.accesskey;"
                oncommand="gContextMenu.playPlugin();"/>
      <menuitem id="context-ctp-hide"
                label="&hidePluginCmd.label;"
                accesskey="&hidePluginCmd.accesskey;"
                oncommand="gContextMenu.hidePlugin();"/>
      <menuseparator id="context-sep-ctp"/>
      <menuitem id="context-savepage"
                label="&savePageCmd.label;"
                accesskey="&savePageCmd.accesskey2;"
                oncommand="gContextMenu.savePageAs();"/>
      <menuseparator id="context-sep-sendpagetodevice" class="sync-ui-item"
                     hidden="true"/>
      <menu id="context-sendpagetodevice"
            class="sync-ui-item"
            label="&sendPageToDevice.label;"
            accesskey="&sendPageToDevice.accesskey;"
            hidden="true">
        <menupopup id="context-sendpagetodevice-popup"
                   onpopupshowing="(() => { gSync.populateSendTabToDevicesMenu(event.target, gBrowser.currentURI.spec, gBrowser.contentTitle); })()"/>
      </menu>
      <menuseparator id="context-sep-viewbgimage"/>
      <menuitem id="context-viewbgimage"
                label="&viewBGImageCmd.label;"
                accesskey="&viewBGImageCmd.accesskey;"
                oncommand="gContextMenu.viewBGImage(event);"
                onclick="checkForMiddleClick(this, event);"/>
      <menuitem id="context-undo"
                label="&undoCmd.label;"
                accesskey="&undoCmd.accesskey;"
                command="cmd_undo"/>
      <menuseparator id="context-sep-undo"/>
      <menuitem id="context-cut"
                label="&cutCmd.label;"
                accesskey="&cutCmd.accesskey;"
                command="cmd_cut"/>
      <menuitem id="context-copy"
                label="&copyCmd.label;"
                accesskey="&copyCmd.accesskey;"
                command="cmd_copy"/>
      <menuitem id="context-paste"
                label="&pasteCmd.label;"
                accesskey="&pasteCmd.accesskey;"
                command="cmd_paste"/>
      <menuitem id="context-delete"
                label="&deleteCmd.label;"
                accesskey="&deleteCmd.accesskey;"
                command="cmd_delete"/>
      <menuseparator id="context-sep-paste"/>
      <menuitem id="context-selectall"
                label="&selectAllCmd.label;"
                accesskey="&selectAllCmd.accesskey;"
                command="cmd_selectAll"/>
      <menuseparator id="context-sep-selectall"/>
      <menuitem id="context-keywordfield"
                label="&keywordfield.label;"
                accesskey="&keywordfield.accesskey;"
                oncommand="AddKeywordForSearchField();"/>
      <menuitem id="context-searchselect"
                oncommand="BrowserSearch.loadSearchFromContext(this.searchTerms, this.principal);"/>
      <menuseparator id="context-sep-sendlinktodevice" class="sync-ui-item"
                     hidden="true"/>
      <menu id="context-sendlinktodevice"
            class="sync-ui-item"
            label="&sendLinkToDevice.label;"
            accesskey="&sendLinkToDevice.accesskey;"
            hidden="true">
        <menupopup id="context-sendlinktodevice-popup"
                   onpopupshowing="gSync.populateSendTabToDevicesMenu(event.target, gContextMenu.linkURL, gContextMenu.linkTextStr);"/>
      </menu>
      <menuseparator id="frame-sep"/>
      <menu id="frame" label="&thisFrameMenu.label;" accesskey="&thisFrameMenu.accesskey;">
        <menupopup>
          <menuitem id="context-showonlythisframe"
                    label="&showOnlyThisFrameCmd.label;"
                    accesskey="&showOnlyThisFrameCmd.accesskey;"
                    oncommand="gContextMenu.showOnlyThisFrame();"/>
          <menuitem id="context-openframeintab"
                    label="&openFrameCmdInTab.label;"
                    accesskey="&openFrameCmdInTab.accesskey;"
                    oncommand="gContextMenu.openFrameInTab();"/>
          <menuitem id="context-openframe"
                    label="&openFrameCmd.label;"
                    accesskey="&openFrameCmd.accesskey;"
                    oncommand="gContextMenu.openFrame();"/>
          <menuseparator id="open-frame-sep"/>
          <menuitem id="context-reloadframe"
                    label="&reloadFrameCmd.label;"
                    accesskey="&reloadFrameCmd.accesskey;"
                    oncommand="gContextMenu.reloadFrame(event);"/>
          <menuseparator/>
          <menuitem id="context-bookmarkframe"
                    label="&bookmarkThisFrameCmd.label;"
                    accesskey="&bookmarkThisFrameCmd.accesskey;"
                    oncommand="gContextMenu.addBookmarkForFrame();"/>
          <menuitem id="context-saveframe"
                    label="&saveFrameCmd.label;"
                    accesskey="&saveFrameCmd.accesskey;"
                    oncommand="gContextMenu.saveFrame();"/>
          <menuseparator/>
          <menuitem id="context-printframe"
                    label="&printFrameCmd.label;"
                    accesskey="&printFrameCmd.accesskey;"
                    oncommand="gContextMenu.printFrame();"/>
          <menuseparator/>
          <menuitem id="context-viewframesource"
                    label="&viewFrameSourceCmd.label;"
                    accesskey="&viewFrameSourceCmd.accesskey;"
                    oncommand="gContextMenu.viewFrameSource();"
                    observes="isFrameImage"/>
          <menuitem id="context-viewframeinfo"
                    label="&viewFrameInfoCmd.label;"
                    accesskey="&viewFrameInfoCmd.accesskey;"
                    oncommand="gContextMenu.viewFrameInfo();"/>
        </menupopup>
      </menu>
      <menuitem id="context-viewpartialsource-selection"
                label="&viewPartialSourceForSelectionCmd.label;"
                accesskey="&viewPartialSourceCmd.accesskey;"
                oncommand="gContextMenu.viewPartialSource();"
                observes="isImage"/>
      <menuseparator id="context-sep-viewsource"/>
      <menuitem id="context-viewsource"
                label="&viewPageSourceCmd.label;"
                accesskey="&viewPageSourceCmd.accesskey;"
                oncommand="BrowserViewSource(gContextMenu.browser);"
                observes="canViewSource"/>
      <menuitem id="context-viewinfo"
                label="&viewPageInfoCmd.label;"
                accesskey="&viewPageInfoCmd.accesskey;"
                oncommand="gContextMenu.viewInfo();"/>
      <menuseparator id="spell-separator"/>
      <menuitem id="spell-check-enabled"
                label="&spellCheckToggle.label;"
                type="checkbox"
                accesskey="&spellCheckToggle.accesskey;"
                oncommand="InlineSpellCheckerUI.toggleEnabled(window);"/>
      <menuitem id="spell-add-dictionaries-main"
                label="&spellAddDictionaries.label;"
                accesskey="&spellAddDictionaries.accesskey;"
                oncommand="gContextMenu.addDictionaries();"/>
      <menu id="spell-dictionaries"
            label="&spellDictionaries.label;"
            accesskey="&spellDictionaries.accesskey;">
          <menupopup id="spell-dictionaries-menu">
              <menuseparator id="spell-language-separator"/>
              <menuitem id="spell-add-dictionaries"
                        label="&spellAddDictionaries.label;"
                        accesskey="&spellAddDictionaries.accesskey;"
                        oncommand="gContextMenu.addDictionaries();"/>
          </menupopup>
      </menu>
      <menuseparator hidden="true" id="context-sep-bidi"/>
      <menuitem hidden="true" id="context-bidi-text-direction-toggle"
                label="&bidiSwitchTextDirectionItem.label;"
                accesskey="&bidiSwitchTextDirectionItem.accesskey;"
                command="cmd_switchTextDirection"/>
      <menuitem hidden="true" id="context-bidi-page-direction-toggle"
                label="&bidiSwitchPageDirectionItem.label;"
                accesskey="&bidiSwitchPageDirectionItem.accesskey;"
                oncommand="gContextMenu.switchPageDirection();"/>
      <menuseparator id="fill-login-separator" hidden="true"/>
      <menu id="fill-login"
            label="&fillLoginMenu.label;"
            label-login="&fillLoginMenu.label;"
            label-password="&fillPasswordMenu.label;"
            label-username="&fillUsernameMenu.label;"
            accesskey="&fillLoginMenu.accesskey;"
            accesskey-login="&fillLoginMenu.accesskey;"
            accesskey-password="&fillPasswordMenu.accesskey;"
            accesskey-username="&fillUsernameMenu.accesskey;"
            hidden="true">
        <menupopup id="fill-login-popup">
          <menuitem id="fill-login-no-logins"
                    label="&noLoginSuggestions.label;"
                    disabled="true"
                    hidden="true"/>
          <menuseparator id="saved-logins-separator"/>
          <menuitem id="fill-login-saved-passwords"
                    label="&viewSavedLogins.label;"
                    oncommand="gContextMenu.openPasswordManager();"/>
        </menupopup>
      </menu>
      <menuseparator id="inspect-separator" hidden="true"/>
      <menuitem id="context-inspect"
                hidden="true"
                label="&inspectContextMenu.label;"
                accesskey="&inspectContextMenu.accesskey;"
                oncommand="gContextMenu.inspectNode();"/>
      <menuitem id="context-inspect-a11y"
                hidden="true"
                label="&inspectA11YContextMenu.label;"
                oncommand="gContextMenu.inspectA11Y();"/>
      <menuseparator id="context-media-eme-separator" hidden="true"/>
      <menuitem id="context-media-eme-learnmore"
                class="menuitem-iconic"
                hidden="true"
                label="&emeLearnMoreContextMenu.label;"
                accesskey="&emeLearnMoreContextMenu.accesskey;"
                oncommand="gContextMenu.drmLearnMore(event);"
                onclick="checkForMiddleClick(this, event);"/>
