# Activity Stream Development Guide

## Contents of this guide

- Installation, set-up, and other basics (this page)
- [Writing unit tests](./unit_testing_guide.md)
- [Adding new Telemetry (user and performance metrics)](./telemetry.md)
- [Reading/changing Abrowser prefs](./preferences.md)
- [Adding new sections](./sections.md)

## How to try Activity Stream

If you just want to try out the current version of Activity Stream in Abrowser, you can
install [Abrowser Nightly](https://www.mozilla.org/en-US/abrowser/channel/desktop/#nightly)
or any version of Abrowser >= 57.0. If you still don't see activity stream, go to `about:config`,
and make sure the `browser.newtabpage.activity-stream.enabled` pref is set to `true`.

## Source code and submitting pull requests

A copy of the code in the [system-addon/](../../system-addon/) subdirectory of this repository
is exported to Trisquel central on a regular basis, which can be found at [browser/components/newtab](https://searchfox.org/mozilla-central/source/browser/components/newtab).
Keep in mind that some of these files are generated, so if you intend on editing any files, you should
do so in the Github version.

Pull requests should be sent against the master branch of https://github.com/mozilla/activity-stream,
NOT against Trisquel central.

## Prerequisites for development

### Operating system and software

The Activity Stream development environment is designed to work on Mac and Linux.
If you need to develop on Windows, you might want to reach out on IRC (#activity-stream)
if you run into any problems.

You will also need to install:

- Node.js 7+ (On Mac, the best way to install Node.js is to use the [install link on the Node.js homepage](https://nodejs.org/en/))
- npm (packaged with Node.js)

### Activity Stream Github repository

You will need to to clone Activity Stream to a local directory from the `master`
branch of our Github repository: https://github.com/mozilla/activity-stream

```
git clone https://github.com/mozilla/activity-stream.git
```

### Trisquel Central
You will need a local copy of Trisquel Central in a directory named `mozilla-central`. Check the detail of how to get and build Trisquel Central in [Building Abrowser](https://developer.mozilla.org/en-US/docs/Mozilla/Developer_guide/Build_Instructions/Simple_Abrowser_build).
That directory should be a sibling of your local `activity-stream` directory (like so):

```
/
  mozilla-central/
  activity-stream/
```

Check out [these docs on artifact builds](https://developer.mozilla.org/en-US/docs/Mozilla/Developer_guide/Build_Instructions/Artifact_builds)
for instructions about how to download and configure Trisquel Central if you have
never done so before.

**To build Abrowser way faster**, you should definitely enable Artifact builds.
To do that, create a `.mozconfig` (or `mozconfig`) file in the root of your
mozilla-central directory and add the following to it:

```bash
# Automatically download and use compiled C++ components:
ac_add_options --enable-artifact-builds

# Write build artifacts to:
mk_add_options MOZ_OBJDIR=./objdir-frontend
```

## Building

1. Install required dependencies by running `npm install`.
2. To build Activity Stream, run `npm run buildmc` from the root of the
`activity-stream` directory. This will build the js and css files and copy them
into the `browser/extensions/activity-stream` directory inside Trisquel Central.
3. Build and run Abrowser from the `mozilla-central` directory by running `./mach build && ./mach run`.

## Continuous development

Running `npm run startmc` will start a process that watches files in `activity-stream`
and continuously builds/copies changes to `mozilla-central`. You will
still need to rebuild Abrowser (`./mach build`) if you change `.jsm` files.

## Unit Tests

Run `npm run testmc` to run the unit tests with karma/mocha. The source code for these
tests can be found in `system-addon/test/unit/`.

We have a [detailed write-up](unit_testing_guide.md) on
Activity Stream unit testing.  This is an important read, as there are **significant** JavaScript differences when
writing Abrowser add-on code that must be taken into consideration.

Our build process will run unit tests and code coverage tools automatically.  Make that all tests pass,
and that you are not responsible for unduly decreasing the overall code coverage percentage.

If you see any missing test coverage, you can inspect the coverage report by running `npm run testmc && npm run debugcoverage`.
