/* -*- indent-tabs-mode: nil; js-indent-level: 2 -*- */
/* vim: set ft=javascript ts=2 et sw=2 tw=80: */
/* Any copyright is dedicated to the Public Domain.
 * http://creativecommons.org/publicdomain/zero/1.0/ */

/**
 * Check target-scoped actor lifetimes.
 */

const ACTORS_URL = CHROME_URL + "testactors.js";
const TAB_URL = EXAMPLE_URL + "doc_empty-tab-01.html";

add_task(async function test() {
  await addTab(TAB_URL);

  DebuggerServer.init();
  DebuggerServer.registerAllActors();

  await registerActorInContentProcess(ACTORS_URL, {
    prefix: "testOne",
    constructor: "TestActor1",
    type: { target: true },
  });

  const transport = DebuggerServer.connectPipe();
  const client = new DebuggerClient(transport);
  const [ type ] = await client.connect();
  is(type, "browser", "Root actor should identify itself as a browser.");

  const [ grip ] = await attachTargetActorForUrl(client, TAB_URL);
  await testTargetScopedActor(client, grip);
  await removeTab(gBrowser.selectedTab);
  await client.close();
});

async function testTargetScopedActor(client, grip) {
  ok(grip.testOneActor,
    "Found the test target-scoped actor.");
  ok(grip.testOneActor.includes("testOne"),
    "testOneActor's actorPrefix should be used.");

  const response = await client.request({ to: grip.testOneActor, type: "ping" });
  is(response.pong, "pong", "Actor should respond to requests.");
}
