/* Any copyright is dedicated to the Public Domain.
   http://creativecommons.org/publicdomain/zero/1.0/ */

add_task(async function () {
  const kSearchEngineID = "test_urifixup_search_engine";
  const kSearchEngineURL = "http://localhost/?search={searchTerms}";
  Services.search.addEngineWithDetails(kSearchEngineID, "", "", "", "get",
                                       kSearchEngineURL);

  let oldDefaultEngine = Services.search.defaultEngine;
  Services.search.defaultEngine = Services.search.getEngineByName(kSearchEngineID);

  let selectedName = Services.search.defaultEngine.name;
  Assert.equal(selectedName, kSearchEngineID, "Check fake search engine is selected");

  registerCleanupFunction(function() {
    if (oldDefaultEngine) {
      Services.search.defaultEngine = oldDefaultEngine;
    }
    let engine = Services.search.getEngineByName(kSearchEngineID);
    if (engine) {
      Services.search.removeEngine(engine);
    }
  });

  let tab = await BrowserTestUtils.openNewForegroundTab(gBrowser);
  gBrowser.selectedTab = tab;

  gURLBar.value = "abrowser health report";
  gURLBar.handleCommand();

  let [subject, data] = await TestUtils.topicObserved("keyword-search");

  let engine = Services.search.defaultEngine;
  Assert.ok(engine, "Have default search engine.");
  Assert.equal(engine, subject, "Notification subject is engine.");
  Assert.equal(data, "abrowser health report", "Notification data is search term.");

  gBrowser.removeTab(tab);
});
