; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -mtriple=x86_64-unknown -mattr=+lwp | FileCheck %s --check-prefix=X64
; RUN: llc < %s -mtriple=x86_64-unknown -mcpu=bdver1 | FileCheck %s --check-prefix=X64
; RUN: llc < %s -mtriple=x86_64-unknown -mcpu=bdver2 | FileCheck %s --check-prefix=X64
; RUN: llc < %s -mtriple=x86_64-unknown -mcpu=bdver3 | FileCheck %s --check-prefix=X64
; RUN: llc < %s -mtriple=x86_64-unknown -mcpu=bdver4 | FileCheck %s --check-prefix=X64

define i8 @test_lwpins64_rri(i64 %a0, i32 %a1) nounwind {
; X64-LABEL: test_lwpins64_rri:
; X64:       # %bb.0:
; X64-NEXT:    lwpins $-1985229329, %esi, %rdi # imm = 0x89ABCDEF
; X64-NEXT:    setb %al
; X64-NEXT:    retq
  %1 = tail call i8 @llvm.x86.lwpins64(i64 %a0, i32 %a1, i32 2309737967)
  ret i8 %1
}

define i8 @test_lwpins64_rmi(i64 %a0, i32 *%p1) nounwind {
; X64-LABEL: test_lwpins64_rmi:
; X64:       # %bb.0:
; X64-NEXT:    lwpins $1985229328, (%rsi), %rdi # imm = 0x76543210
; X64-NEXT:    setb %al
; X64-NEXT:    retq
  %a1 = load i32, i32 *%p1
  %1 = tail call i8 @llvm.x86.lwpins64(i64 %a0, i32 %a1, i32 1985229328)
  ret i8 %1
}

define void @test_lwpval64_rri(i64 %a0, i32 %a1) nounwind {
; X64-LABEL: test_lwpval64_rri:
; X64:       # %bb.0:
; X64-NEXT:    lwpval $-19088744, %esi, %rdi # imm = 0xFEDCBA98
; X64-NEXT:    retq
  tail call void @llvm.x86.lwpval64(i64 %a0, i32 %a1, i32 4275878552)
  ret void
}

define void @test_lwpval64_rmi(i64 %a0, i32 *%p1) nounwind {
; X64-LABEL: test_lwpval64_rmi:
; X64:       # %bb.0:
; X64-NEXT:    lwpval $305419896, (%rsi), %rdi # imm = 0x12345678
; X64-NEXT:    retq
  %a1 = load i32, i32 *%p1
  tail call void @llvm.x86.lwpval64(i64 %a0, i32 %a1, i32 305419896)
  ret void
}

declare i8 @llvm.x86.lwpins64(i64, i32, i32) nounwind
declare void @llvm.x86.lwpval64(i64, i32, i32) nounwind
