/*
 * C11 <time.h> implementation
 *
 * (C) Copyright yohhoy 2012.
 * Copyright 2022 Yonggang Luo
 * Distributed under the Boost Software License, Version 1.0.
 *
 * Permission is hereby granted, free of charge, to any person or organization
 * obtaining a copy of the software and accompanying documentation covered by
 * this license (the "Software") to use, reproduce, display, distribute,
 * execute, and transmit the Software, and to prepare [[derivative work]]s of the
 * Software, and to permit third-parties to whom the Software is furnished to
 * do so, all subject to the following:
 *
 * The copyright notices in the Software and this entire statement, including
 * the above license grant, this restriction and the following disclaimer,
 * must be included in all copies of the Software, in whole or in part, and
 * all derivative works of the Software, unless such copies or derivative
 * works are solely in the form of machine-executable object code generated by
 * a source language processor.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE, TITLE AND NON-INFRINGEMENT. IN NO EVENT
 * SHALL THE COPYRIGHT HOLDERS OR ANYONE DISTRIBUTING THE SOFTWARE BE LIABLE
 * FOR ANY DAMAGES OR OTHER LIABILITY, WHETHER IN CONTRACT, TORT OR OTHERWISE,
 * ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 */

#include "c11/time.h"

#ifndef HAVE_TIMESPEC_GET

#if defined(_WIN32) && !defined(__CYGWIN__)

#ifndef WIN32_LEAN_AND_MEAN
#define WIN32_LEAN_AND_MEAN 1
#endif
#include <windows.h>

int
timespec_get(struct timespec *ts, int base)
{
/* difference between 1970 and 1601 */
#define _TIMESPEC_IMPL_UNIX_EPOCH_IN_TICKS 116444736000000000ull
/* 1 tick is 100 nanoseconds */
#define _TIMESPEC_IMPL_TICKS_PER_SECONDS 10000000ull
    if (!ts)
        return 0;
    if (base == TIME_UTC) {
        FILETIME ft;
        ULARGE_INTEGER date;
        LONGLONG ticks;

        GetSystemTimeAsFileTime(&ft);
        date.HighPart = ft.dwHighDateTime;
        date.LowPart = ft.dwLowDateTime;
        ticks = (LONGLONG)(date.QuadPart - _TIMESPEC_IMPL_UNIX_EPOCH_IN_TICKS);
        ts->tv_sec = ticks / _TIMESPEC_IMPL_TICKS_PER_SECONDS;
        ts->tv_nsec = (ticks % _TIMESPEC_IMPL_TICKS_PER_SECONDS) * 100;
        return base;
    }
    return 0;
#undef _TIMESPEC_IMPL_UNIX_EPOCH_IN_TICKS
#undef _TIMESPEC_IMPL_TICKS_PER_SECONDS
}

#else

int
timespec_get(struct timespec *ts, int base)
{
    if (!ts)
        return 0;
    if (base == TIME_UTC) {
        clock_gettime(CLOCK_REALTIME, ts);
        return base;
    }
    return 0;
}
#endif

#endif /* !HAVE_TIMESPEC_GET */
