set( MIRALL_VERSION_MAJOR 3 )
set( MIRALL_VERSION_MINOR 12 )
set( MIRALL_VERSION_PATCH 1 )
set( MIRALL_VERSION_YEAR  2024 )
set( MIRALL_SOVERSION 0 )

# Minimum supported server version according to https://docs.nextcloud.com/server/latest/admin_manual/release_schedule.html
set(NEXTCLOUD_SERVER_VERSION_MIN_SUPPORTED_MAJOR 16)
set(NEXTCLOUD_SERVER_VERSION_MIN_SUPPORTED_MINOR 0)
set(NEXTCLOUD_SERVER_VERSION_MIN_SUPPORTED_PATCH 0)

set(NEXTCLOUD_SERVER_VERSION_SECURE_FILEDROP_MIN_SUPPORTED_MAJOR 26)
set(NEXTCLOUD_SERVER_VERSION_SECURE_FILEDROP_MIN_SUPPORTED_MINOR 0)
set(NEXTCLOUD_SERVER_VERSION_SECURE_FILEDROP_MIN_SUPPORTED_PATCH 0)

# Composite defines
# Used e.g. for libraries Keep at x.y.z.
set( MIRALL_VERSION "${MIRALL_VERSION_MAJOR}.${MIRALL_VERSION_MINOR}.${MIRALL_VERSION_PATCH}" )

if( NOT DEFINED MIRALL_VERSION_BUILD )
    set( MIRALL_VERSION_BUILD "0" ) # Integer ID. Generated by the build system
endif( NOT DEFINED MIRALL_VERSION_BUILD )

# Version with Build ID. Used in the installer
set( MIRALL_VERSION_FULL "${MIRALL_VERSION}.${MIRALL_VERSION_BUILD}" )

# External version or version with suffix
if ( NOT DEFINED EXTERNAL_VERSION )
    if ( NOT DEFINED MIRALL_VERSION_SUFFIX )
        set ( MIRALL_VERSION_SUFFIX "git") #e.g. beta1, beta2, rc1
    endif( NOT DEFINED MIRALL_VERSION_SUFFIX )
    include(GetGitRevisionDescription)
    get_git_head_revision(GIT_REFSPEC GIT_SHA1)
    # if we cannot get it from git, directly try .tag (packages)
    # this will work if the tar balls have been properly created
    # via git-archive.
    if ("${GIT_SHA1}" STREQUAL "GITDIR-NOTFOUND")
        file (READ ${CMAKE_SOURCE_DIR}/.tag sha1_candidate)
        string(REPLACE "\n" "" sha1_candidate ${sha1_candidate})
        if (NOT ${sha1_candidate} STREQUAL "$Format:%H$")
            message("sha1_candidate:${sha1_candidate}")
            set (GIT_SHA1 "${sha1_candidate}")
        endif (NOT ${sha1_candidate} STREQUAL "$Format:%H$")
    endif ( "${GIT_SHA1}" STREQUAL "GITDIR-NOTFOUND" )
    message(STATUS "GIT_SHA1 ${GIT_SHA1}")
    set ( MIRALL_VERSION_STRING "${MIRALL_VERSION}${MIRALL_VERSION_SUFFIX}" )
else ( NOT DEFINED EXTERNAL_VERSION )
    set ( MIRALL_VERSION_STRING "${EXTERNAL_VERSION}" )
endif ( NOT DEFINED EXTERNAL_VERSION )

if( MIRALL_VERSION_BUILD )
    set( MIRALL_VERSION_STRING "${MIRALL_VERSION_STRING} (build ${MIRALL_VERSION_BUILD})" )
endif( MIRALL_VERSION_BUILD )
