// Copyright 2014 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef COMPONENTS_CONTENT_SETTINGS_CORE_COMMON_PREF_NAMES_H_
#define COMPONENTS_CONTENT_SETTINGS_CORE_COMMON_PREF_NAMES_H_

#include "build/build_config.h"

namespace prefs {

// NOTE: This file does not contain all content settings related pref names as
// some of these are generated by WebsiteSettingsInfo from content settings
// names.

// CookieControlsMode enum value that decides when the cookie controls UI is
// enabled. This will block third-party cookies similar to
// kBlockThirdPartyCookies but with a new UI.
inline constexpr char kCookieControlsMode[] = "profile.cookie_controls_mode";

// Version of the pattern format used to define content settings.
inline constexpr char kContentSettingsVersion[] =
    "profile.content_settings.pref_version";

// Preferences that are exclusively used to store managed values for default
// content settings.
inline constexpr char kManagedDefaultAdsSetting[] =
    "profile.managed_default_content_settings.ads";
inline constexpr char kManagedDefaultClipboardSetting[] =
    "profile.managed_default_content_settings.clipboard";
inline constexpr char kManagedDefaultCookiesSetting[] =
    "profile.managed_default_content_settings.cookies";
inline constexpr char kManagedDefaultGeolocationSetting[] =
    "profile.managed_default_content_settings.geolocation";
inline constexpr char kManagedDefaultImagesSetting[] =
    "profile.managed_default_content_settings.images";
inline constexpr char kManagedDefaultInsecureContentSetting[] =
    "profile.managed_default_content_settings.insecure_content";
inline constexpr char kManagedDefaultJavaScriptSetting[] =
    "profile.managed_default_content_settings.javascript";
inline constexpr char kManagedDefaultNotificationsSetting[] =
    "profile.managed_default_content_settings.notifications";
inline constexpr char kManagedDefaultMediaStreamSetting[] =
    "profile.managed_default_content_settings.media_stream";
inline constexpr char kManagedDefaultPopupsSetting[] =
    "profile.managed_default_content_settings.popups";
inline constexpr char kManagedDefaultSensorsSetting[] =
    "profile.managed_default_content_settings.sensors";
inline constexpr char kManagedDefaultWebBluetoothGuardSetting[] =
    "profile.managed_default_content_settings.web_bluetooth_guard";
inline constexpr char kManagedDefaultWebUsbGuardSetting[] =
    "profile.managed_default_content_settings.web_usb_guard";
inline constexpr char kManagedDefaultFileSystemReadGuardSetting[] =
    "profile.managed_default_content_settings.file_system_read_guard";
inline constexpr char kManagedDefaultFileSystemWriteGuardSetting[] =
    "profile.managed_default_content_settings.file_system_write_guard";
inline constexpr char kManagedDefaultSerialGuardSetting[] =
    "profile.managed_default_content_settings.serial_guard";
inline constexpr char kManagedDefaultJavaScriptJitSetting[] =
    "profile.managed_default_content_settings.javascript_jit";
inline constexpr char kManagedDefaultJavaScriptOptimizerSetting[] =
    "profile.managed_default_content_settings.javascript_optimizer";
inline constexpr char kManagedDefaultWebHidGuardSetting[] =
    "profile.managed_default_content_settings.web_hid_guard";
inline constexpr char kManagedDefaultWindowManagementSetting[] =
    "profile.managed_default_content_settings.window_management";
inline constexpr char kManagedDefaultLocalFontsSetting[] =
    "profile.managed_default_content_settings.local_fonts";
inline constexpr char kManagedDefaultThirdPartyStoragePartitioningSetting[] =
    "profile.managed_default_content_settings.third_party_storage_partitioning";
inline constexpr char kManagedDefaultWebPrintingSetting[] =
    "profile.managed_default_content_settings.web_printing";
inline constexpr char kManagedDefaultDirectSocketsSetting[] =
    "profile.managed_default_content_settings.direct_sockets";
inline constexpr char
    kManagedDefaultDirectSocketsPrivateNetworkAccessSetting[] =
        "profile.managed_default_content_settings.direct_sockets_pna";
inline constexpr char kManagedDefaultLegacyCookieScope[] =
    "profile.managed_default_content_settings.legacy_cookie_scope";
inline constexpr char kManagedDefaultControlledFrameSetting[] =
    "profile.managed_default_content_settings.controlled_frame";
#if BUILDFLAG(IS_CHROMEOS)
inline constexpr char kManagedDefaultSmartCardConnectSetting[] =
    "profile.managed_default_content_settings.smart_card_connect";
inline constexpr char kManagedDefaultDeviceAttributesSetting[] =
    "profile.managed_default_content_settings.device_attributes";
#endif  // BUILDFLAG(IS_CHROMEOS)

// Preferences that are exclusively used to store managed content settings
// patterns.
inline constexpr char kManagedAutomaticFullscreenAllowedForUrls[] =
    "profile.managed_automatic_fullscreen_allowed_for_urls";
inline constexpr char kManagedAutomaticFullscreenBlockedForUrls[] =
    "profile.managed_automatic_fullscreen_blocked_for_urls";
inline constexpr char kManagedAutoSelectCertificateForUrls[] =
    "profile.managed_auto_select_certificate_for_urls";
inline constexpr char kManagedClipboardAllowedForUrls[] =
    "profile.managed_clipboard_allowed_for_urls";
inline constexpr char kManagedClipboardBlockedForUrls[] =
    "profile.managed_clipboard_blocked_for_urls";
inline constexpr char kManagedCookiesAllowedForUrls[] =
    "profile.managed_cookies_allowed_for_urls";
inline constexpr char kManagedCookiesBlockedForUrls[] =
    "profile.managed_cookies_blocked_for_urls";
inline constexpr char kManagedCookiesSessionOnlyForUrls[] =
    "profile.managed_cookies_sessiononly_for_urls";
inline constexpr char
    kManagedAccessToGetAllScreensMediaInSessionAllowedForUrls[] =
        "profile.managed_access_to_get_all_screens_media_in_session_allowed_"
        "for_urls";
inline constexpr char kManagedImagesAllowedForUrls[] =
    "profile.managed_images_allowed_for_urls";
inline constexpr char kManagedImagesBlockedForUrls[] =
    "profile.managed_images_blocked_for_urls";
inline constexpr char kManagedInsecureContentAllowedForUrls[] =
    "profile.managed_insecure_content_allowed_for_urls";
inline constexpr char kManagedInsecureContentBlockedForUrls[] =
    "profile.managed_insecure_content_blocked_for_urls";
inline constexpr char kManagedJavaScriptAllowedForUrls[] =
    "profile.managed_javascript_allowed_for_urls";
inline constexpr char kManagedJavaScriptBlockedForUrls[] =
    "profile.managed_javascript_blocked_for_urls";
inline constexpr char kManagedNotificationsAllowedForUrls[] =
    "profile.managed_notifications_allowed_for_urls";
inline constexpr char kManagedNotificationsBlockedForUrls[] =
    "profile.managed_notifications_blocked_for_urls";
inline constexpr char kManagedPopupsAllowedForUrls[] =
    "profile.managed_popups_allowed_for_urls";
inline constexpr char kManagedPopupsBlockedForUrls[] =
    "profile.managed_popups_blocked_for_urls";
inline constexpr char kManagedSensorsAllowedForUrls[] =
    "profile.managed_sensors_allowed_for_urls";
inline constexpr char kManagedSensorsBlockedForUrls[] =
    "profile.managed_sensors_blocked_for_urls";
inline constexpr char kManagedWebUsbAllowDevicesForUrls[] =
    "profile.managed_web_usb_allow_devices_for_urls";
inline constexpr char kManagedWebUsbAskForUrls[] =
    "profile.managed_web_usb_ask_for_urls";
inline constexpr char kManagedWebUsbBlockedForUrls[] =
    "profile.managed_web_usb_blocked_for_urls";
inline constexpr char kManagedFileSystemReadAskForUrls[] =
    "profile.managed_file_system_read_ask_for_urls";
inline constexpr char kManagedFileSystemReadBlockedForUrls[] =
    "profile.managed_file_system_read_blocked_for_urls";
inline constexpr char kManagedFileSystemWriteAskForUrls[] =
    "profile.managed_file_system_write_ask_for_urls";
inline constexpr char kManagedFileSystemWriteBlockedForUrls[] =
    "profile.managed_file_system_write_blocked_for_urls";
inline constexpr char kManagedLegacyCookieAccessAllowedForDomains[] =
    "profile.managed_legacy_cookie_access_allowed_for_domains";
inline constexpr char kManagedSerialAskForUrls[] =
    "profile.managed_serial_ask_for_urls";
inline constexpr char kManagedSerialBlockedForUrls[] =
    "profile.managed_serial_blocked_for_urls";
inline constexpr char kManagedJavaScriptJitAllowedForSites[] =
    "profile.managed_javascript_jit_allowed_for_sites";
inline constexpr char kManagedJavaScriptJitBlockedForSites[] =
    "profile.managed_javascript_jit_blocked_for_sites";
inline constexpr char kManagedJavaScriptOptimizerAllowedForSites[] =
    "profile.managed_javascript_optimizer_allowed_for_sites";
inline constexpr char kManagedJavaScriptOptimizerBlockedForSites[] =
    "profile.managed_javascript_optimizer_blocked_for_sites";
inline constexpr char kManagedWebHidAskForUrls[] =
    "profile.managed_web_hid_ask_for_urls";
inline constexpr char kManagedWebHidBlockedForUrls[] =
    "profile.managed_web_hid_blocked_for_urls";
inline constexpr char kManagedWindowManagementAllowedForUrls[] =
    "profile.managed_window_management_allowed_for_urls";
inline constexpr char kManagedWindowManagementBlockedForUrls[] =
    "profile.managed_window_management_blocked_for_urls";
inline constexpr char kManagedLocalFontsAllowedForUrls[] =
    "profile.managed_local_fonts_allowed_for_urls";
inline constexpr char kManagedLocalFontsBlockedForUrls[] =
    "profile.managed_local_fonts_blocked_for_urls";
inline constexpr char kManagedThirdPartyStoragePartitioningBlockedForOrigins[] =
    "profile.managed_third_party_storage_partitioning_blocked_for_origins";
inline constexpr char kManagedWebPrintingAllowedForUrls[] =
    "profile.managed_web_printing_allowed_for_urls";
inline constexpr char kManagedWebPrintingBlockedForUrls[] =
    "profile.managed_web_printing_blocked_for_urls";
inline constexpr char kManagedDirectSocketsAllowedForUrls[] =
    "profile.managed_direct_sockets_allowed_for_urls";
inline constexpr char kManagedDirectSocketsBlockedForUrls[] =
    "profile.managed_direct_sockets_blocked_for_urls";
inline constexpr char
    kManagedDirectSocketsPrivateNetworkAccessAllowedForUrls[] =
        "profile.managed_direct_sockets_pna_allowed_for_urls";
inline constexpr char
    kManagedDirectSocketsPrivateNetworkAccessBlockedForUrls[] =
        "profile.managed_direct_sockets_pna_blocked_for_urls";
inline constexpr char kManagedLegacyCookieScopeForDomains[] =
    "profile.managed_legacy_cookie_scope_for_domains";
#if BUILDFLAG(IS_CHROMEOS)
inline constexpr char kManagedSmartCardConnectAllowedForUrls[] =
    "profile.managed_smart_card_connect_allowed_for_urls";
inline constexpr char kManagedSmartCardConnectBlockedForUrls[] =
    "profile.managed_smart_card_connect_blocked_for_urls";
inline constexpr char kManagedDeviceAttributesAllowedForOrigins[] =
    "profile.managed_device_attributes_allowed_for_origins";
inline constexpr char kManagedDeviceAttributesBlockedForOrigins[] =
    "profile.managed_device_attributes_blocked_for_origins";
#endif
inline constexpr char kManagedControlledFrameAllowedForUrls[] =
    "profile.managed_controlled_frame_allowed_for_urls";
inline constexpr char kManagedControlledFrameBlockedForUrls[] =
    "profile.managed_controlled_frame_blocked_for_urls";

inline constexpr char kManagedLocalNetworkAccessAllowedForUrls[] =
    "profile.managed_local_network_access_allowed_for_urls";
inline constexpr char kManagedLocalNetworkAccessBlockedForUrls[] =
    "profile.managed_local_network_access_blocked_for_urls";

// Boolean indicating whether the quiet UI is enabled for notification
// permission requests. This and kEnableNotificationCPSS can't both be true
// at the same time.
inline constexpr char kEnableQuietNotificationPermissionUi[] =
    "profile.content_settings.enable_quiet_permission_ui.notifications";

// Boolean indicating whether the quiet UI is enabled for geolocation
// permission requests. This and kEnableGeolocationCPSS can't both be true at
// the same time.
inline constexpr char kEnableQuietGeolocationPermissionUi[] =
    "profile.content_settings.enable_quiet_permission_ui.geolocation";

// Boolean indicating whether the users who have quiet notifications enabled
// adaptively have to be migrated to CPSS.
inline constexpr char kDidMigrateAdaptiveNotifiationQuietingToCPSS[] =
    "profile.content_settings.did_migrate_adaptive_notification_quieting_to_"
    "cpss";

// Boolean indicating whether CPSS is enabled for notification permissions.
// This and kEnableQuietNotificationPermissionUi can't both be true at the same
// time.
inline constexpr char kEnableNotificationCPSS[] =
    "profile.content_settings.enable_cpss.notifications";

// Boolean indicating whether CPSS is enabled for geolocation permissions.
// This and kEnableQuietGeolocationPermissionUi can't both be true at the same
// time.
inline constexpr char kEnableGeolocationCPSS[] =
    "profile.content_settings.enable_cpss.geolocation";

// Time value indicating when the quiet notification UI was last disabled by the
// user. Only permission action history after this point is taken into account
// for adaptive quiet UI activation.
inline constexpr char kQuietNotificationPermissionUiDisabledTime[] =
    "profile.content_settings.disable_quiet_permission_ui_time.notifications";

// Boolean that indicates whether the user has ever opened any of the in-context
// cookie controls, i.e. the Page Info cookies subpage, or ChromeGuard.
inline constexpr char kInContextCookieControlsOpened[] =
    "profile.content_settings.in_content_cookies_controls_opened";

#if BUILDFLAG(IS_ANDROID)
// Enable vibration for web notifications.
inline constexpr char kNotificationsVibrateEnabled[] =
    "notifications.vibrate_enabled";

// Boolean that indicates whether the desktop site global setting was enabled by
// the user.
inline constexpr char kRequestDesktopSiteGlobalSettingUserEnabled[] =
    "Chrome.RequestDesktopSiteGlobalSetting.UserEnabled";

// Window setting for request desktop site. When enabled, we will request
// mobile site if the window is narrow.
inline constexpr char kDesktopSiteWindowSettingEnabled[] =
    "desktop_site.window_setting";
#endif

}  // namespace prefs

#endif  // COMPONENTS_CONTENT_SETTINGS_CORE_COMMON_PREF_NAMES_H_
