// Copyright (c) 2020 The ungoogled-chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef CHROME_BROWSER_UNGOOGLED_FLAG_CHOICES_H_
#define CHROME_BROWSER_UNGOOGLED_FLAG_CHOICES_H_
const FeatureEntry::Choice kExtensionHandlingChoices[] = {
    {flags_ui::kGenericExperimentChoiceDefault, "", ""},
    {"Download as regular file",
     "extension-mime-request-handling",
     "download-as-regular-file"},
    {"Always prompt for install",
     "extension-mime-request-handling",
     "always-prompt-for-install"},
};
const FeatureEntry::Choice kShowAvatarButtonChoices[] = {
    {flags_ui::kGenericExperimentChoiceDefault, "", ""},
    {"Always",
     "show-avatar-button",
     "always"},
    {"Incognito and Guest",
     "show-avatar-button",
     "incognito-and-guest"},
    {"Never",
     "show-avatar-button",
     "never"}
};
const FeatureEntry::Choice kScrollEventChangesTab[] = {
    {flags_ui::kGenericExperimentChoiceDefault, "", ""},
    {"Always",
     "scroll-tabs",
     "always"},
    {"Never",
     "scroll-tabs",
     "never"}
};
const FeatureEntry::Choice kBookmarkBarNewTab[] = {
    {flags_ui::kGenericExperimentChoiceDefault, "", ""},
    {"Never",
     "bookmark-bar-ntp",
     "never"},
};
#endif  // CHROME_BROWSER_UNGOOGLED_FLAG_CHOICES_H_
