// Copyright (c) 2020 The ungoogled-chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef CHROME_BROWSER_UNGOOGLED_FLAG_ENTRIES_H_
#define CHROME_BROWSER_UNGOOGLED_FLAG_ENTRIES_H_
    {"set-ipv6-probe-false",
     "SetIpv6ProbeFalse",
     "Forces the result of the browser's IPv6 probing (i.e. IPv6 connectivity test) to be unsuccessful. This causes IPv4 addresses to be prioritized over IPv6 addresses. Without this flag, the probing result is set to be successful, which causes IPv6 to be used over IPv4 when possible. ungoogled-chromium flag.",
     kOsAll, FEATURE_VALUE_TYPE(net::features::kSetIpv6ProbeFalse)},
    {"extension-mime-request-handling",
     "Handling of extension MIME type requests",
     "Used when deciding how to handle a request for a CRX or User Script MIME type. ungoogled-chromium flag.",
     kOsAll, MULTI_VALUE_TYPE(kExtensionHandlingChoices)},
    {"disable-search-engine-collection",
     "Disable search engine collection",
     "Prevents search engines from being added automatically. ungoogled-chromium flag.",
     kOsAll, SINGLE_VALUE_TYPE("disable-search-engine-collection")},
    {"disable-beforeunload",
     "Disable beforeunload",
     "Disables JavaScript dialog boxes triggered by beforeunload. ungoogled-chromium flag.",
     kOsAll, SINGLE_VALUE_TYPE("disable-beforeunload")},
    {"force-punycode-hostnames",
     "Force punycode hostnames",
     "Force punycode in hostnames instead of Unicode when displaying Internationalized Domain Names (IDNs). ungoogled-chromium flag.",
     kOsAll, SINGLE_VALUE_TYPE("force-punycode-hostnames")},
#endif  // CHROME_BROWSER_UNGOOGLED_FLAG_ENTRIES_H_
