#!/bin/sh

sed -i 's:/archive.trisquel.info/:/es.archive.trisquel.info/:g; s/extras//g;' /etc/apt/sources.list

[ -f /boot/grub/menu.lst ] && sed 's/Trisquel.*,/Trisquel 5.5,/g' /boot/grub/menu.lst -i

if ! [ -f /etc/grub.d/01_PASSWORD ]; then
cat << EOF > /etc/grub.d/01_PASSWORD
#! /bin/sh -e
# Trisquel enables a random password to grub during install
# Comment this file to remove the password.
# This file should only be readable by root.

echo set superusers=grub
echo password grub $(bash -c 'echo $RANDOM')
EOF
fi
chmod 700 /etc/grub.d/01_PASSWORD

# Let's do some extra purging
export DEBIAN_FRONTEND=noninteractive
apt-get -y --force-yes remove gnome-session gnome-shell abrowser-globalmenu appmenu-gtk3 appmenu-gtk
dpkg -l trisquel |grep ii -q && apt-get -y --force-yes install trisquel-recommended
dpkg -l trisquel-mini |grep ii -q && apt-get -y --force-yes install trisquel-mini-recommended

update-initramfs -u
update-grub
