#!/bin/sh

#This loop takes back the panel configuration to the default settings
export LANG=C
for user in root $(grep /home /etc/passwd |egrep -v '(false|nologin)$'| cut -d: -f1)
do
    if [ -f /home/$user/.dbus/session-bus/$(cat /var/lib/dbus/machine-id)-0 ]
    then
        DBUS_SESSION=$(grep -v "^#" /home/$user/.dbus/session-bus/$(cat /var/lib/dbus/machine-id)-0)
        sudo -u $user $DBUS_SESSION gconftool --recursive-unset /apps/panel 2>&1 | grep -q "Connection refused"
        if [ $? = 0 ]
        then
            sudo -u $user gconftool --recursive-unset /apps/panel
            sudo -u $user gconftool --shutdown
        fi
    else
        sudo -u $user gconftool --recursive-unset /apps/panel
        sudo -u $user gconftool --shutdown
    fi
done

sed -i 's:/archive.trisquel.info/:/es.archive.trisquel.info/:g; s/extras//g;' /etc/apt/sources.list
apt-get update
for i in trisquel-usplash-theme lubuntu-plymouth-theme usb-creator usb-creator-common usb-creator-gtk
do
apt-get remove --purge --force-yes -y $i
done

apt-get install --force-yes -y trisquel-recommended

sudo -u gdm gconftool-2 --set --type string --set /apps/gdm/simple-greeter/logo_icon_name trisquel
sudo -u gdm gconftool-2 --set --type string --set /desktop/gnome/interface/gtk_theme Trisquel
sudo -u gdm gconftool-2 --set --type string --set /desktop/gnome/interface/icon_theme Trisquel
sudo -u gdm gconftool-2 --set --type string --set /desktop/gnome/background/picture_filename /usr/share/backgrounds/taranis.jpg
sudo -u gdm gconftool-2 --set --type string --set /desktop/gnome/background/picture_options stretched

[ -f /boot/grub/menu.lst ] && sed 's/Trisquel 3.5,/Trisquel 4.0,/g' /boot/grub/menu.lst -i

cat << EOF > /etc/grub.d/01_PASSWORD
#! /bin/sh -e
# Trisquel enables a random password to grub during install
# Comment this file to remove the password.
# This file should only be readable by root.

echo set superusers=grub
echo password grub $(bash -c 'echo $RANDOM')
EOF

update-initramfs -u
update-grub
