// |reftest| skip -- Temporal is not supported
// Copyright (C) 2022 Igalia, S.L. All rights reserved.
// This code is governed by the BSD license found in the LICENSE file.

/*---
esid: sec-temporal.zoneddatetime
description: >
  A Temporal.TimeZone instance passed to new ZonedDateTime() does not have
  its 'timeZone' property observably checked
features: [Temporal]
---*/

const timeZone = new Temporal.TimeZone("UTC");
Object.defineProperty(timeZone, "timeZone", {
  get() {
    throw new Test262Error("timeZone.timeZone should not be accessed");
  },
});

new Temporal.ZonedDateTime(0n, timeZone);
new Temporal.ZonedDateTime(0n, { timeZone });

reportCompare(0, 0);
