{ -*- buffer-read-only: t -*-

  Copyright 2015-2021 Michalis Kamburelis.

  This file is part of "Castle Game Engine".

  "Castle Game Engine" is free software; see the file COPYING.txt,
  included in this distribution, for details about the copyright.

  "Castle Game Engine" is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

  ----------------------------------------------------------------------------
}

{ Automatically generated node properties.

  Do not edit this file manually!
  To add new properties:
  - add them to the text files in tools/internal/x3d-nodes-to-pascal/nodes-specification/ ,
  - and regenerate include files by running x3d-nodes-to-pascal .

  The documentation for properties should go to x3dnodes_documentation.txt . }

{$ifdef read_interface}

  strict private
    function GetDescription: String;
    procedure SetDescription(const Value: String);
    function GetPitch: Single;
    procedure SetPitch(const Value: Single);
  public
    { X3D field "description". } { }
    property Description: String read GetDescription write SetDescription;
    { X3D field "pitch". } { }
    property Pitch: Single read GetPitch write SetPitch;

{$endif read_interface}

{$ifdef read_implementation}

{ TAbstractSoundSourceNode ----------------------------------------------- }

function TAbstractSoundSourceNode.GetDescription: String;
begin
  Result := FdDescription.Value;
end;

procedure TAbstractSoundSourceNode.SetDescription(const Value: String);
begin
  FdDescription.Send(Value);
end;

function TAbstractSoundSourceNode.GetPitch: Single;
begin
  Result := FdPitch.Value;
end;

procedure TAbstractSoundSourceNode.SetPitch(const Value: Single);
begin
  FdPitch.Send(Value);
end;

{$endif read_implementation}
