#!/usr/bin/env python
# Copyright 2014 Hewlett-Packard Development Company, L.P.
#
# Author: Kiall Mac Innes <kiall@hp.com>
#
# Licensed under the Apache License, Version 2.0 (the "License"); you may
# not use this file except in compliance with the License. You may obtain
# a copy of the License at
#
#      http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
# WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
# License for the specific language governing permissions and limitations
# under the License.
import binascii

import dns
import dns.message
import dns.rdatatype


# Prepare a Packet
request = dns.message.make_query(
    qname='example.com.',
    rdtype=dns.rdatatype.A,
)
request.set_opcode(dns.opcode.UPDATE)

# Print the hex representation of the Request
print(binascii.b2a_hex(request.to_wire()))
