/*
 * Decompiled with CFR 0.152.
 */
package dumphd.gui;

import dumphd.core.DiscSet;
import java.util.ArrayList;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.table.AbstractTableModel;

public class FileTableModel
extends AbstractTableModel {
    private DiscSet ds = null;
    private TreeMap<Integer, Integer> streamSetOffsets = new TreeMap();
    private int fileSetOffset = 0;

    public FileTableModel() {
    }

    public FileTableModel(DiscSet ds) {
        this.ds = ds;
        if (ds != null) {
            this.calculateOffsets();
        }
    }

    public DiscSet getData() {
        return this.ds;
    }

    public void setData(DiscSet ds) {
        this.ds = ds;
        if (ds != null) {
            this.calculateOffsets();
        }
        this.fireTableDataChanged();
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        return String.class;
    }

    @Override
    public String getColumnName(int columnIndex) {
        return "File";
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return false;
    }

    @Override
    public int getColumnCount() {
        return 1;
    }

    @Override
    public int getRowCount() {
        if (this.ds != null) {
            return this.fileSetOffset + this.ds.fileSet.size();
        }
        return 0;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        if (this.ds != null) {
            if (rowIndex < this.fileSetOffset) {
                int offset = 0;
                for (Map.Entry<Integer, Integer> entry : this.streamSetOffsets.entrySet()) {
                    if (rowIndex < entry.getKey()) {
                        return this.ds.streamSets.get(entry.getValue()).get(rowIndex - offset);
                    }
                    offset = entry.getValue();
                }
                return "";
            }
            return this.ds.fileSet.get(rowIndex - this.fileSetOffset);
        }
        return "";
    }

    private void calculateOffsets() {
        this.fileSetOffset = 0;
        for (Map.Entry<Integer, ArrayList<String>> entry : this.ds.streamSets.entrySet()) {
            this.fileSetOffset += entry.getValue().size();
            this.streamSetOffsets.put(this.fileSetOffset, entry.getKey());
        }
    }
}

