/*
 * Decompiled with CFR 0.152.
 */
package friendless.games.filler;

import java.util.ResourceBundle;

public class EloRating {
    public static String NOVICE;
    public static String CLASSA;
    public static String CLASSB;
    public static String CLASSC;
    public static String CLASSD;
    public static String EXPERT;
    public static String MASTER;
    public static String INTLMASTER;
    public static String GRANDMASTER;
    public static String SUPERGRANDMASTER;
    public static String WORLDCHAMPION;
    public static String[] TITLES;
    public static final int[] RATINGS;
    public static final int INITIAL = 1600;
    public static final int PROVISIONAL = 20;
    public static int K;
    static ResourceBundle resources;

    static void setResources(ResourceBundle resourceBundle) {
        resources = resourceBundle;
        NOVICE = resourceBundle.getString("filler.ranking.NOVICE");
        CLASSA = resourceBundle.getString("filler.ranking.CLASSA");
        CLASSB = resourceBundle.getString("filler.ranking.CLASSB");
        CLASSC = resourceBundle.getString("filler.ranking.CLASSC");
        CLASSD = resourceBundle.getString("filler.ranking.CLASSD");
        EXPERT = resourceBundle.getString("filler.ranking.EXPERT");
        MASTER = resourceBundle.getString("filler.ranking.MASTER");
        INTLMASTER = resourceBundle.getString("filler.ranking.INTLMASTER");
        GRANDMASTER = resourceBundle.getString("filler.ranking.GRANDMASTER");
        SUPERGRANDMASTER = resourceBundle.getString("filler.ranking.SUPERGRANDMASTER");
        WORLDCHAMPION = resourceBundle.getString("filler.ranking.WORLDCHAMPION");
        TITLES = new String[]{NOVICE, CLASSA, CLASSB, CLASSC, CLASSD, EXPERT, MASTER, INTLMASTER, GRANDMASTER, SUPERGRANDMASTER, WORLDCHAMPION};
    }

    public static double expectancy(int[] nArray) {
        int n = nArray[0] - nArray[1];
        return 1.0 / (1.0 + Math.pow(10.0, (double)n / 400.0));
    }

    public static int[] expectedWinnings(int[] nArray) {
        double d = EloRating.expectancy(nArray);
        int[] nArray2 = new int[]{(int)((double)K * d), (int)((double)K * (1.0 - d))};
        return nArray2;
    }

    public static int adjust(int[] nArray, int n) {
        double d = EloRating.expectancy(nArray);
        int n2 = 0;
        if (n == 0) {
            n2 = (int)((double)K * d);
            nArray[0] = nArray[0] + n2;
            nArray[1] = nArray[1] - n2;
        } else {
            n2 = (int)((double)K * (1.0 - d));
            nArray[0] = nArray[0] - n2;
            nArray[1] = nArray[1] + n2;
        }
        return n2;
    }

    public static String getLabel(int n) {
        String string = null;
        int n2 = 0;
        while (n2 < RATINGS.length) {
            if (n <= RATINGS[n2]) break;
            string = TITLES[n2];
            ++n2;
        }
        return string;
    }

    static {
        RATINGS = new int[]{0, 800, 1000, 1200, 1400, 1600, 1800, 2000, 2200, 2400, 2600};
        K = 32;
    }
}

