static const char* op_c_source =
"/* This file is an image processing operation for GEGL                        \n"
" *                                                                            \n"
" * GEGL is free software; you can redistribute it and/or                      \n"
" * modify it under the terms of the GNU Lesser General Public                 \n"
" * License as published by the Free Software Foundation; either               \n"
" * version 3 of the License, or (at your option) any later version.           \n"
" *                                                                            \n"
" * GEGL is distributed in the hope that it will be useful,                    \n"
" * but WITHOUT ANY WARRANTY; without even the implied warranty of             \n"
" * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU          \n"
" * Lesser General Public License for more details.                            \n"
" *                                                                            \n"
" * You should have received a copy of the GNU Lesser General Public           \n"
" * License along with GEGL; if not, see <http://www.gnu.org/licenses/>.       \n"
" *                                                                            \n"
" * Copyright 2006 Øyvind Kolås <pippin@gimp.org>                            \n"
" */                                                                           \n"
"                                                                              \n"
"#include \"config.h\"                                                         \n"
"#include <glib/gi18n-lib.h>                                                   \n"
"                                                                              \n"
"                                                                              \n"
"#ifdef GEGL_PROPERTIES                                                        \n"
"                                                                              \n"
"property_string (path, _(\"File\"), \"/tmp/test.raw\")                        \n"
"   description (_(\"Path of file to load.\"))                                 \n"
"                                                                              \n"
"#else                                                                         \n"
"                                                                              \n"
"#define GEGL_OP_SOURCE                                                        \n"
"#define GEGL_OP_C_SOURCE rawbayer-load.c                                      \n"
"                                                                              \n"
"#include \"gegl-op.h\"                                                        \n"
"#include <unistd.h>                                                           \n"
"#include <string.h>                                                           \n"
"#include <stdio.h>                                                            \n"
"#include <stdlib.h>                                                           \n"
"                                                                              \n"
"#define PIPE_MODE \"r\"                                                       \n"
"#define MAX_SAMPLE 65535                                                      \n"
"#define ERROR -1                                                              \n"
"                                                                              \n"
"static void                                                                   \n"
"load_buffer (GeglProperties *op_raw_load)                                     \n"
"{                                                                             \n"
"  if (!op_raw_load->user_data)                                                \n"
"    {                                                                         \n"
"      FILE  *pfp;                                                             \n"
"      gchar *command;                                                         \n"
"                                                                              \n"
"      gint width, height, val_max;                                            \n"
"      char newline;                                                           \n"
"                                                                              \n"
"      command = g_strdup_printf (\"dcraw -j -d -4 -c '%s'\\n\", op_raw_load->path);\n"
"      pfp = popen (command, PIPE_MODE);                                       \n"
"      g_free (command);                                                       \n"
"                                                                              \n"
"      if (fscanf (pfp, \"P6 %d %d %d %c\",                                    \n"
"                  &width, &height, &val_max, &newline) != 4)                  \n"
"        {                                                                     \n"
"          pclose (pfp);                                                       \n"
"          g_warning (\"not able to aquire raw data\");                        \n"
"          return;                                                             \n"
"        }                                                                     \n"
"                                                                              \n"
"      {                                                                       \n"
"        GeglRectangle extent = { 0, 0, width, height };                       \n"
"        op_raw_load->user_data = (void*)gegl_buffer_new (&extent, babl_format (\"Y u16\"));\n"
"      }                                                                       \n"
"         {                                                                    \n"
"           guchar *buf = g_new (guchar, width * height * 3 * 2);              \n"
"           fread (buf, 1, width * height * 3 * 2, pfp);                       \n"
"           if(strstr (op_raw_load->path, \"rawbayerS\")){                     \n"
"             gint i;                                                          \n"
"             for (i=0;i<width*height*3;i++)                                   \n"
"               {                                                              \n"
"                guchar tmp = buf[i*2];                                        \n"
"                buf[i*2] = buf[i*2+1];                                        \n"
"                buf[i*2+1] = tmp;                                             \n"
"               }                                                              \n"
"           }                                                                  \n"
"           gegl_buffer_set (GEGL_BUFFER (op_raw_load->user_data),             \n"
"                            NULL,                                             \n"
"                            0,                                                \n"
"                            babl_format_new (                                 \n"
"                                 babl_model (\"RGB\"),                        \n"
"                                 babl_type (\"u16\"),                         \n"
"                                 babl_component (\"R\"),                      \n"
"                                 babl_component (\"G\"),                      \n"
"                                 babl_component (\"B\"),                      \n"
"                                 NULL),                                       \n"
"                            buf,                                              \n"
"                            GEGL_AUTO_ROWSTRIDE);                             \n"
"           g_free (buf);                                                      \n"
"         }                                                                    \n"
"       fclose (pfp);                                                          \n"
"    }                                                                         \n"
"}                                                                             \n"
"                                                                              \n"
"static GeglRectangle                                                          \n"
"get_bounding_box (GeglOperation *operation)                                   \n"
"{                                                                             \n"
"  GeglProperties   *o = GEGL_PROPERTIES (operation);                          \n"
"  GeglRectangle result = {0,0,0,0};                                           \n"
"                                                                              \n"
"  load_buffer (o);                                                            \n"
"                                                                              \n"
"  result.width  = gegl_buffer_get_width (GEGL_BUFFER (o->user_data));         \n"
"  result.height = gegl_buffer_get_height (GEGL_BUFFER (o->user_data));        \n"
"  return result;                                                              \n"
"}                                                                             \n"
"                                                                              \n"
"static gboolean                                                               \n"
"process (GeglOperation        *operation,                                     \n"
"         GeglOperationContext *context,                                       \n"
"         const gchar          *output_pad,                                    \n"
"         const GeglRectangle  *result,                                        \n"
"         gint                  level)                                         \n"
"{                                                                             \n"
"  GeglProperties *o = GEGL_PROPERTIES (operation);                            \n"
"#if 1                                                                         \n"
"  g_assert (o->user_data);                                                    \n"
"  gegl_operation_context_take_object (context, \"output\", G_OBJECT (o->user_data));\n"
"                                                                              \n"
"  o->user_data = NULL;                                                        \n"
"#else                                                                         \n"
"  if (o->user_data)                                                           \n"
"    {                                                                         \n"
"      g_object_ref (o->user_data); /* Add an extra reference, since gegl_operation_set_data\n"
"                                      is stealing one.                        \n"
"                                    */                                        \n"
"                                                                              \n"
"      /* override core behaviour, by resetting the buffer in the operation_context */\n"
"      gegl_operation_context_take_object (context, \"output\", G_OBJECT (o->user_data));\n"
"    }                                                                         \n"
"#endif                                                                        \n"
"  return TRUE;                                                                \n"
"}                                                                             \n"
"                                                                              \n"
"                                                                              \n"
"static void                                                                   \n"
"gegl_op_class_init (GeglOpClass *klass)                                       \n"
"{                                                                             \n"
"  GeglOperationClass       *operation_class;                                  \n"
"                                                                              \n"
"  operation_class = GEGL_OPERATION_CLASS (klass);                             \n"
"                                                                              \n"
"  operation_class->process = process;                                         \n"
"  operation_class->get_bounding_box = get_bounding_box;                       \n"
"                                                                              \n"
"  gegl_operation_class_set_keys (operation_class,                             \n"
"  \"name\"        , \"gegl:rawbayer-load\",                                   \n"
"  \"categories\"  , \"hidden\",                                               \n"
"  \"description\" ,                                                           \n"
"        _(\"Raw image loader, wrapping dcraw with pipes, provides the raw bayer\"\n"
"          \" grid as grayscale, if the fileformat is .rawbayer it will use this\"\n"
"          \" loader instead of the normal dcraw loader, if the fileformat is\"\n"
"          \" .rawbayerS it will swap the returned 16bit numbers (the pnm loader\"\n"
"          \" is apparently buggy)\"),                                         \n"
"        NULL);                                                                \n"
"                                                                              \n"
"  gegl_extension_handler_register (\".rawbayer\", \"gegl:rawbayer-load\");    \n"
"  gegl_extension_handler_register (\".rawbayerS\", \"gegl:rawbayer-load\");   \n"
"}                                                                             \n"
"                                                                              \n"
"#endif                                                                        \n"
;
