package appplatform

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/azure"
	"github.com/Azure/go-autorest/tracing"
	"net/http"
)

// BuildServiceClient is the REST API for Azure Spring Cloud
type BuildServiceClient struct {
	BaseClient
}

// NewBuildServiceClient creates an instance of the BuildServiceClient client.
func NewBuildServiceClient(subscriptionID string) BuildServiceClient {
	return NewBuildServiceClientWithBaseURI(DefaultBaseURI, subscriptionID)
}

// NewBuildServiceClientWithBaseURI creates an instance of the BuildServiceClient client using a custom endpoint.  Use
// this when interacting with an Azure cloud that uses a non-standard base URI (sovereign clouds, Azure stack).
func NewBuildServiceClientWithBaseURI(baseURI string, subscriptionID string) BuildServiceClient {
	return BuildServiceClient{NewWithBaseURI(baseURI, subscriptionID)}
}

// CreateOrUpdateBuild create or update a KPack build.
// Parameters:
// resourceGroupName - the name of the resource group that contains the resource. You can obtain this value
// from the Azure Resource Manager API or the portal.
// serviceName - the name of the Service resource.
// buildServiceName - the name of the build service resource.
// buildName - the name of the build resource.
// buildParameter - parameters for the create or update operation
func (client BuildServiceClient) CreateOrUpdateBuild(ctx context.Context, resourceGroupName string, serviceName string, buildServiceName string, buildName string, buildParameter Build) (result Build, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/BuildServiceClient.CreateOrUpdateBuild")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.CreateOrUpdateBuildPreparer(ctx, resourceGroupName, serviceName, buildServiceName, buildName, buildParameter)
	if err != nil {
		err = autorest.NewErrorWithError(err, "appplatform.BuildServiceClient", "CreateOrUpdateBuild", nil, "Failure preparing request")
		return
	}

	resp, err := client.CreateOrUpdateBuildSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "appplatform.BuildServiceClient", "CreateOrUpdateBuild", resp, "Failure sending request")
		return
	}

	result, err = client.CreateOrUpdateBuildResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "appplatform.BuildServiceClient", "CreateOrUpdateBuild", resp, "Failure responding to request")
		return
	}

	return
}

// CreateOrUpdateBuildPreparer prepares the CreateOrUpdateBuild request.
func (client BuildServiceClient) CreateOrUpdateBuildPreparer(ctx context.Context, resourceGroupName string, serviceName string, buildServiceName string, buildName string, buildParameter Build) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"buildName":         autorest.Encode("path", buildName),
		"buildServiceName":  autorest.Encode("path", buildServiceName),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"serviceName":       autorest.Encode("path", serviceName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2022-01-01-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPut(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AppPlatform/Spring/{serviceName}/buildServices/{buildServiceName}/builds/{buildName}", pathParameters),
		autorest.WithJSON(buildParameter),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// CreateOrUpdateBuildSender sends the CreateOrUpdateBuild request. The method will close the
// http.Response Body if it receives an error.
func (client BuildServiceClient) CreateOrUpdateBuildSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// CreateOrUpdateBuildResponder handles the response to the CreateOrUpdateBuild request. The method always
// closes the http.Response Body.
func (client BuildServiceClient) CreateOrUpdateBuildResponder(resp *http.Response) (result Build, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusCreated),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetBuild get a KPack build.
// Parameters:
// resourceGroupName - the name of the resource group that contains the resource. You can obtain this value
// from the Azure Resource Manager API or the portal.
// serviceName - the name of the Service resource.
// buildServiceName - the name of the build service resource.
// buildName - the name of the build resource.
func (client BuildServiceClient) GetBuild(ctx context.Context, resourceGroupName string, serviceName string, buildServiceName string, buildName string) (result Build, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/BuildServiceClient.GetBuild")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.GetBuildPreparer(ctx, resourceGroupName, serviceName, buildServiceName, buildName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "appplatform.BuildServiceClient", "GetBuild", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetBuildSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "appplatform.BuildServiceClient", "GetBuild", resp, "Failure sending request")
		return
	}

	result, err = client.GetBuildResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "appplatform.BuildServiceClient", "GetBuild", resp, "Failure responding to request")
		return
	}

	return
}

// GetBuildPreparer prepares the GetBuild request.
func (client BuildServiceClient) GetBuildPreparer(ctx context.Context, resourceGroupName string, serviceName string, buildServiceName string, buildName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"buildName":         autorest.Encode("path", buildName),
		"buildServiceName":  autorest.Encode("path", buildServiceName),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"serviceName":       autorest.Encode("path", serviceName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2022-01-01-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AppPlatform/Spring/{serviceName}/buildServices/{buildServiceName}/builds/{buildName}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetBuildSender sends the GetBuild request. The method will close the
// http.Response Body if it receives an error.
func (client BuildServiceClient) GetBuildSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// GetBuildResponder handles the response to the GetBuild request. The method always
// closes the http.Response Body.
func (client BuildServiceClient) GetBuildResponder(resp *http.Response) (result Build, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetBuildResult get a KPack build result.
// Parameters:
// resourceGroupName - the name of the resource group that contains the resource. You can obtain this value
// from the Azure Resource Manager API or the portal.
// serviceName - the name of the Service resource.
// buildServiceName - the name of the build service resource.
// buildName - the name of the build resource.
// buildResultName - the name of the build result resource.
func (client BuildServiceClient) GetBuildResult(ctx context.Context, resourceGroupName string, serviceName string, buildServiceName string, buildName string, buildResultName string) (result BuildResult, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/BuildServiceClient.GetBuildResult")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.GetBuildResultPreparer(ctx, resourceGroupName, serviceName, buildServiceName, buildName, buildResultName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "appplatform.BuildServiceClient", "GetBuildResult", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetBuildResultSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "appplatform.BuildServiceClient", "GetBuildResult", resp, "Failure sending request")
		return
	}

	result, err = client.GetBuildResultResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "appplatform.BuildServiceClient", "GetBuildResult", resp, "Failure responding to request")
		return
	}

	return
}

// GetBuildResultPreparer prepares the GetBuildResult request.
func (client BuildServiceClient) GetBuildResultPreparer(ctx context.Context, resourceGroupName string, serviceName string, buildServiceName string, buildName string, buildResultName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"buildName":         autorest.Encode("path", buildName),
		"buildResultName":   autorest.Encode("path", buildResultName),
		"buildServiceName":  autorest.Encode("path", buildServiceName),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"serviceName":       autorest.Encode("path", serviceName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2022-01-01-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AppPlatform/Spring/{serviceName}/buildServices/{buildServiceName}/builds/{buildName}/results/{buildResultName}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetBuildResultSender sends the GetBuildResult request. The method will close the
// http.Response Body if it receives an error.
func (client BuildServiceClient) GetBuildResultSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// GetBuildResultResponder handles the response to the GetBuildResult request. The method always
// closes the http.Response Body.
func (client BuildServiceClient) GetBuildResultResponder(resp *http.Response) (result BuildResult, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetBuildResultLog get a KPack build result log download URL.
// Parameters:
// resourceGroupName - the name of the resource group that contains the resource. You can obtain this value
// from the Azure Resource Manager API or the portal.
// serviceName - the name of the Service resource.
// buildServiceName - the name of the build service resource.
// buildName - the name of the build resource.
// buildResultName - the name of the build result resource.
func (client BuildServiceClient) GetBuildResultLog(ctx context.Context, resourceGroupName string, serviceName string, buildServiceName string, buildName string, buildResultName string) (result BuildResultLog, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/BuildServiceClient.GetBuildResultLog")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.GetBuildResultLogPreparer(ctx, resourceGroupName, serviceName, buildServiceName, buildName, buildResultName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "appplatform.BuildServiceClient", "GetBuildResultLog", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetBuildResultLogSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "appplatform.BuildServiceClient", "GetBuildResultLog", resp, "Failure sending request")
		return
	}

	result, err = client.GetBuildResultLogResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "appplatform.BuildServiceClient", "GetBuildResultLog", resp, "Failure responding to request")
		return
	}

	return
}

// GetBuildResultLogPreparer prepares the GetBuildResultLog request.
func (client BuildServiceClient) GetBuildResultLogPreparer(ctx context.Context, resourceGroupName string, serviceName string, buildServiceName string, buildName string, buildResultName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"buildName":         autorest.Encode("path", buildName),
		"buildResultName":   autorest.Encode("path", buildResultName),
		"buildServiceName":  autorest.Encode("path", buildServiceName),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"serviceName":       autorest.Encode("path", serviceName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2022-01-01-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AppPlatform/Spring/{serviceName}/buildServices/{buildServiceName}/builds/{buildName}/results/{buildResultName}/getLogFileUrl", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetBuildResultLogSender sends the GetBuildResultLog request. The method will close the
// http.Response Body if it receives an error.
func (client BuildServiceClient) GetBuildResultLogSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// GetBuildResultLogResponder handles the response to the GetBuildResultLog request. The method always
// closes the http.Response Body.
func (client BuildServiceClient) GetBuildResultLogResponder(resp *http.Response) (result BuildResultLog, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetBuildService get a build service resource.
// Parameters:
// resourceGroupName - the name of the resource group that contains the resource. You can obtain this value
// from the Azure Resource Manager API or the portal.
// serviceName - the name of the Service resource.
// buildServiceName - the name of the build service resource.
func (client BuildServiceClient) GetBuildService(ctx context.Context, resourceGroupName string, serviceName string, buildServiceName string) (result BuildService, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/BuildServiceClient.GetBuildService")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.GetBuildServicePreparer(ctx, resourceGroupName, serviceName, buildServiceName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "appplatform.BuildServiceClient", "GetBuildService", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetBuildServiceSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "appplatform.BuildServiceClient", "GetBuildService", resp, "Failure sending request")
		return
	}

	result, err = client.GetBuildServiceResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "appplatform.BuildServiceClient", "GetBuildService", resp, "Failure responding to request")
		return
	}

	return
}

// GetBuildServicePreparer prepares the GetBuildService request.
func (client BuildServiceClient) GetBuildServicePreparer(ctx context.Context, resourceGroupName string, serviceName string, buildServiceName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"buildServiceName":  autorest.Encode("path", buildServiceName),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"serviceName":       autorest.Encode("path", serviceName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2022-01-01-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AppPlatform/Spring/{serviceName}/buildServices/{buildServiceName}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetBuildServiceSender sends the GetBuildService request. The method will close the
// http.Response Body if it receives an error.
func (client BuildServiceClient) GetBuildServiceSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// GetBuildServiceResponder handles the response to the GetBuildService request. The method always
// closes the http.Response Body.
func (client BuildServiceClient) GetBuildServiceResponder(resp *http.Response) (result BuildService, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetResourceUploadURL get an resource upload URL for build service, which may be artifacts or source archive.
// Parameters:
// resourceGroupName - the name of the resource group that contains the resource. You can obtain this value
// from the Azure Resource Manager API or the portal.
// serviceName - the name of the Service resource.
// buildServiceName - the name of the build service resource.
func (client BuildServiceClient) GetResourceUploadURL(ctx context.Context, resourceGroupName string, serviceName string, buildServiceName string) (result ResourceUploadDefinition, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/BuildServiceClient.GetResourceUploadURL")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.GetResourceUploadURLPreparer(ctx, resourceGroupName, serviceName, buildServiceName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "appplatform.BuildServiceClient", "GetResourceUploadURL", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetResourceUploadURLSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "appplatform.BuildServiceClient", "GetResourceUploadURL", resp, "Failure sending request")
		return
	}

	result, err = client.GetResourceUploadURLResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "appplatform.BuildServiceClient", "GetResourceUploadURL", resp, "Failure responding to request")
		return
	}

	return
}

// GetResourceUploadURLPreparer prepares the GetResourceUploadURL request.
func (client BuildServiceClient) GetResourceUploadURLPreparer(ctx context.Context, resourceGroupName string, serviceName string, buildServiceName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"buildServiceName":  autorest.Encode("path", buildServiceName),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"serviceName":       autorest.Encode("path", serviceName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2022-01-01-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AppPlatform/Spring/{serviceName}/buildServices/{buildServiceName}/getResourceUploadUrl", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetResourceUploadURLSender sends the GetResourceUploadURL request. The method will close the
// http.Response Body if it receives an error.
func (client BuildServiceClient) GetResourceUploadURLSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// GetResourceUploadURLResponder handles the response to the GetResourceUploadURL request. The method always
// closes the http.Response Body.
func (client BuildServiceClient) GetResourceUploadURLResponder(resp *http.Response) (result ResourceUploadDefinition, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetSupportedBuildpack get the supported buildpack resource.
// Parameters:
// resourceGroupName - the name of the resource group that contains the resource. You can obtain this value
// from the Azure Resource Manager API or the portal.
// serviceName - the name of the Service resource.
// buildServiceName - the name of the build service resource.
// buildpackName - the name of the buildpack resource.
func (client BuildServiceClient) GetSupportedBuildpack(ctx context.Context, resourceGroupName string, serviceName string, buildServiceName string, buildpackName string) (result SupportedBuildpackResource, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/BuildServiceClient.GetSupportedBuildpack")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.GetSupportedBuildpackPreparer(ctx, resourceGroupName, serviceName, buildServiceName, buildpackName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "appplatform.BuildServiceClient", "GetSupportedBuildpack", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetSupportedBuildpackSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "appplatform.BuildServiceClient", "GetSupportedBuildpack", resp, "Failure sending request")
		return
	}

	result, err = client.GetSupportedBuildpackResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "appplatform.BuildServiceClient", "GetSupportedBuildpack", resp, "Failure responding to request")
		return
	}

	return
}

// GetSupportedBuildpackPreparer prepares the GetSupportedBuildpack request.
func (client BuildServiceClient) GetSupportedBuildpackPreparer(ctx context.Context, resourceGroupName string, serviceName string, buildServiceName string, buildpackName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"buildpackName":     autorest.Encode("path", buildpackName),
		"buildServiceName":  autorest.Encode("path", buildServiceName),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"serviceName":       autorest.Encode("path", serviceName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2022-01-01-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AppPlatform/Spring/{serviceName}/buildServices/{buildServiceName}/supportedBuildpacks/{buildpackName}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetSupportedBuildpackSender sends the GetSupportedBuildpack request. The method will close the
// http.Response Body if it receives an error.
func (client BuildServiceClient) GetSupportedBuildpackSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// GetSupportedBuildpackResponder handles the response to the GetSupportedBuildpack request. The method always
// closes the http.Response Body.
func (client BuildServiceClient) GetSupportedBuildpackResponder(resp *http.Response) (result SupportedBuildpackResource, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetSupportedStack get the supported stack resource.
// Parameters:
// resourceGroupName - the name of the resource group that contains the resource. You can obtain this value
// from the Azure Resource Manager API or the portal.
// serviceName - the name of the Service resource.
// buildServiceName - the name of the build service resource.
// stackName - the name of the stack resource.
func (client BuildServiceClient) GetSupportedStack(ctx context.Context, resourceGroupName string, serviceName string, buildServiceName string, stackName string) (result SupportedStackResource, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/BuildServiceClient.GetSupportedStack")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.GetSupportedStackPreparer(ctx, resourceGroupName, serviceName, buildServiceName, stackName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "appplatform.BuildServiceClient", "GetSupportedStack", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetSupportedStackSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "appplatform.BuildServiceClient", "GetSupportedStack", resp, "Failure sending request")
		return
	}

	result, err = client.GetSupportedStackResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "appplatform.BuildServiceClient", "GetSupportedStack", resp, "Failure responding to request")
		return
	}

	return
}

// GetSupportedStackPreparer prepares the GetSupportedStack request.
func (client BuildServiceClient) GetSupportedStackPreparer(ctx context.Context, resourceGroupName string, serviceName string, buildServiceName string, stackName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"buildServiceName":  autorest.Encode("path", buildServiceName),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"serviceName":       autorest.Encode("path", serviceName),
		"stackName":         autorest.Encode("path", stackName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2022-01-01-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AppPlatform/Spring/{serviceName}/buildServices/{buildServiceName}/supportedStacks/{stackName}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetSupportedStackSender sends the GetSupportedStack request. The method will close the
// http.Response Body if it receives an error.
func (client BuildServiceClient) GetSupportedStackSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// GetSupportedStackResponder handles the response to the GetSupportedStack request. The method always
// closes the http.Response Body.
func (client BuildServiceClient) GetSupportedStackResponder(resp *http.Response) (result SupportedStackResource, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// ListBuildResults list KPack build results.
// Parameters:
// resourceGroupName - the name of the resource group that contains the resource. You can obtain this value
// from the Azure Resource Manager API or the portal.
// serviceName - the name of the Service resource.
// buildServiceName - the name of the build service resource.
// buildName - the name of the build resource.
func (client BuildServiceClient) ListBuildResults(ctx context.Context, resourceGroupName string, serviceName string, buildServiceName string, buildName string) (result BuildResultCollectionPage, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/BuildServiceClient.ListBuildResults")
		defer func() {
			sc := -1
			if result.brc.Response.Response != nil {
				sc = result.brc.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.fn = client.listBuildResultsNextResults
	req, err := client.ListBuildResultsPreparer(ctx, resourceGroupName, serviceName, buildServiceName, buildName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "appplatform.BuildServiceClient", "ListBuildResults", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListBuildResultsSender(req)
	if err != nil {
		result.brc.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "appplatform.BuildServiceClient", "ListBuildResults", resp, "Failure sending request")
		return
	}

	result.brc, err = client.ListBuildResultsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "appplatform.BuildServiceClient", "ListBuildResults", resp, "Failure responding to request")
		return
	}
	if result.brc.hasNextLink() && result.brc.IsEmpty() {
		err = result.NextWithContext(ctx)
		return
	}

	return
}

// ListBuildResultsPreparer prepares the ListBuildResults request.
func (client BuildServiceClient) ListBuildResultsPreparer(ctx context.Context, resourceGroupName string, serviceName string, buildServiceName string, buildName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"buildName":         autorest.Encode("path", buildName),
		"buildServiceName":  autorest.Encode("path", buildServiceName),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"serviceName":       autorest.Encode("path", serviceName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2022-01-01-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AppPlatform/Spring/{serviceName}/buildServices/{buildServiceName}/builds/{buildName}/results", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListBuildResultsSender sends the ListBuildResults request. The method will close the
// http.Response Body if it receives an error.
func (client BuildServiceClient) ListBuildResultsSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// ListBuildResultsResponder handles the response to the ListBuildResults request. The method always
// closes the http.Response Body.
func (client BuildServiceClient) ListBuildResultsResponder(resp *http.Response) (result BuildResultCollection, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// listBuildResultsNextResults retrieves the next set of results, if any.
func (client BuildServiceClient) listBuildResultsNextResults(ctx context.Context, lastResults BuildResultCollection) (result BuildResultCollection, err error) {
	req, err := lastResults.buildResultCollectionPreparer(ctx)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "appplatform.BuildServiceClient", "listBuildResultsNextResults", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}
	resp, err := client.ListBuildResultsSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "appplatform.BuildServiceClient", "listBuildResultsNextResults", resp, "Failure sending next results request")
	}
	result, err = client.ListBuildResultsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "appplatform.BuildServiceClient", "listBuildResultsNextResults", resp, "Failure responding to next results request")
	}
	return
}

// ListBuildResultsComplete enumerates all values, automatically crossing page boundaries as required.
func (client BuildServiceClient) ListBuildResultsComplete(ctx context.Context, resourceGroupName string, serviceName string, buildServiceName string, buildName string) (result BuildResultCollectionIterator, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/BuildServiceClient.ListBuildResults")
		defer func() {
			sc := -1
			if result.Response().Response.Response != nil {
				sc = result.page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.page, err = client.ListBuildResults(ctx, resourceGroupName, serviceName, buildServiceName, buildName)
	return
}

// ListBuilds list KPack builds.
// Parameters:
// resourceGroupName - the name of the resource group that contains the resource. You can obtain this value
// from the Azure Resource Manager API or the portal.
// serviceName - the name of the Service resource.
// buildServiceName - the name of the build service resource.
func (client BuildServiceClient) ListBuilds(ctx context.Context, resourceGroupName string, serviceName string, buildServiceName string) (result BuildCollectionPage, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/BuildServiceClient.ListBuilds")
		defer func() {
			sc := -1
			if result.bc.Response.Response != nil {
				sc = result.bc.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.fn = client.listBuildsNextResults
	req, err := client.ListBuildsPreparer(ctx, resourceGroupName, serviceName, buildServiceName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "appplatform.BuildServiceClient", "ListBuilds", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListBuildsSender(req)
	if err != nil {
		result.bc.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "appplatform.BuildServiceClient", "ListBuilds", resp, "Failure sending request")
		return
	}

	result.bc, err = client.ListBuildsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "appplatform.BuildServiceClient", "ListBuilds", resp, "Failure responding to request")
		return
	}
	if result.bc.hasNextLink() && result.bc.IsEmpty() {
		err = result.NextWithContext(ctx)
		return
	}

	return
}

// ListBuildsPreparer prepares the ListBuilds request.
func (client BuildServiceClient) ListBuildsPreparer(ctx context.Context, resourceGroupName string, serviceName string, buildServiceName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"buildServiceName":  autorest.Encode("path", buildServiceName),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"serviceName":       autorest.Encode("path", serviceName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2022-01-01-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AppPlatform/Spring/{serviceName}/buildServices/{buildServiceName}/builds", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListBuildsSender sends the ListBuilds request. The method will close the
// http.Response Body if it receives an error.
func (client BuildServiceClient) ListBuildsSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// ListBuildsResponder handles the response to the ListBuilds request. The method always
// closes the http.Response Body.
func (client BuildServiceClient) ListBuildsResponder(resp *http.Response) (result BuildCollection, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// listBuildsNextResults retrieves the next set of results, if any.
func (client BuildServiceClient) listBuildsNextResults(ctx context.Context, lastResults BuildCollection) (result BuildCollection, err error) {
	req, err := lastResults.buildCollectionPreparer(ctx)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "appplatform.BuildServiceClient", "listBuildsNextResults", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}
	resp, err := client.ListBuildsSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "appplatform.BuildServiceClient", "listBuildsNextResults", resp, "Failure sending next results request")
	}
	result, err = client.ListBuildsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "appplatform.BuildServiceClient", "listBuildsNextResults", resp, "Failure responding to next results request")
	}
	return
}

// ListBuildsComplete enumerates all values, automatically crossing page boundaries as required.
func (client BuildServiceClient) ListBuildsComplete(ctx context.Context, resourceGroupName string, serviceName string, buildServiceName string) (result BuildCollectionIterator, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/BuildServiceClient.ListBuilds")
		defer func() {
			sc := -1
			if result.Response().Response.Response != nil {
				sc = result.page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.page, err = client.ListBuilds(ctx, resourceGroupName, serviceName, buildServiceName)
	return
}

// ListBuildServices list build services resource.
// Parameters:
// resourceGroupName - the name of the resource group that contains the resource. You can obtain this value
// from the Azure Resource Manager API or the portal.
// serviceName - the name of the Service resource.
func (client BuildServiceClient) ListBuildServices(ctx context.Context, resourceGroupName string, serviceName string) (result BuildServiceCollectionPage, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/BuildServiceClient.ListBuildServices")
		defer func() {
			sc := -1
			if result.bsc.Response.Response != nil {
				sc = result.bsc.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.fn = client.listBuildServicesNextResults
	req, err := client.ListBuildServicesPreparer(ctx, resourceGroupName, serviceName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "appplatform.BuildServiceClient", "ListBuildServices", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListBuildServicesSender(req)
	if err != nil {
		result.bsc.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "appplatform.BuildServiceClient", "ListBuildServices", resp, "Failure sending request")
		return
	}

	result.bsc, err = client.ListBuildServicesResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "appplatform.BuildServiceClient", "ListBuildServices", resp, "Failure responding to request")
		return
	}
	if result.bsc.hasNextLink() && result.bsc.IsEmpty() {
		err = result.NextWithContext(ctx)
		return
	}

	return
}

// ListBuildServicesPreparer prepares the ListBuildServices request.
func (client BuildServiceClient) ListBuildServicesPreparer(ctx context.Context, resourceGroupName string, serviceName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"serviceName":       autorest.Encode("path", serviceName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2022-01-01-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AppPlatform/Spring/{serviceName}/buildServices", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListBuildServicesSender sends the ListBuildServices request. The method will close the
// http.Response Body if it receives an error.
func (client BuildServiceClient) ListBuildServicesSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// ListBuildServicesResponder handles the response to the ListBuildServices request. The method always
// closes the http.Response Body.
func (client BuildServiceClient) ListBuildServicesResponder(resp *http.Response) (result BuildServiceCollection, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// listBuildServicesNextResults retrieves the next set of results, if any.
func (client BuildServiceClient) listBuildServicesNextResults(ctx context.Context, lastResults BuildServiceCollection) (result BuildServiceCollection, err error) {
	req, err := lastResults.buildServiceCollectionPreparer(ctx)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "appplatform.BuildServiceClient", "listBuildServicesNextResults", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}
	resp, err := client.ListBuildServicesSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "appplatform.BuildServiceClient", "listBuildServicesNextResults", resp, "Failure sending next results request")
	}
	result, err = client.ListBuildServicesResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "appplatform.BuildServiceClient", "listBuildServicesNextResults", resp, "Failure responding to next results request")
	}
	return
}

// ListBuildServicesComplete enumerates all values, automatically crossing page boundaries as required.
func (client BuildServiceClient) ListBuildServicesComplete(ctx context.Context, resourceGroupName string, serviceName string) (result BuildServiceCollectionIterator, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/BuildServiceClient.ListBuildServices")
		defer func() {
			sc := -1
			if result.Response().Response.Response != nil {
				sc = result.page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.page, err = client.ListBuildServices(ctx, resourceGroupName, serviceName)
	return
}

// ListSupportedBuildpacks get all supported buildpacks.
// Parameters:
// resourceGroupName - the name of the resource group that contains the resource. You can obtain this value
// from the Azure Resource Manager API or the portal.
// serviceName - the name of the Service resource.
// buildServiceName - the name of the build service resource.
func (client BuildServiceClient) ListSupportedBuildpacks(ctx context.Context, resourceGroupName string, serviceName string, buildServiceName string) (result SupportedBuildpacksCollection, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/BuildServiceClient.ListSupportedBuildpacks")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.ListSupportedBuildpacksPreparer(ctx, resourceGroupName, serviceName, buildServiceName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "appplatform.BuildServiceClient", "ListSupportedBuildpacks", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListSupportedBuildpacksSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "appplatform.BuildServiceClient", "ListSupportedBuildpacks", resp, "Failure sending request")
		return
	}

	result, err = client.ListSupportedBuildpacksResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "appplatform.BuildServiceClient", "ListSupportedBuildpacks", resp, "Failure responding to request")
		return
	}

	return
}

// ListSupportedBuildpacksPreparer prepares the ListSupportedBuildpacks request.
func (client BuildServiceClient) ListSupportedBuildpacksPreparer(ctx context.Context, resourceGroupName string, serviceName string, buildServiceName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"buildServiceName":  autorest.Encode("path", buildServiceName),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"serviceName":       autorest.Encode("path", serviceName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2022-01-01-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AppPlatform/Spring/{serviceName}/buildServices/{buildServiceName}/supportedBuildpacks", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListSupportedBuildpacksSender sends the ListSupportedBuildpacks request. The method will close the
// http.Response Body if it receives an error.
func (client BuildServiceClient) ListSupportedBuildpacksSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// ListSupportedBuildpacksResponder handles the response to the ListSupportedBuildpacks request. The method always
// closes the http.Response Body.
func (client BuildServiceClient) ListSupportedBuildpacksResponder(resp *http.Response) (result SupportedBuildpacksCollection, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// ListSupportedStacks get all supported stacks.
// Parameters:
// resourceGroupName - the name of the resource group that contains the resource. You can obtain this value
// from the Azure Resource Manager API or the portal.
// serviceName - the name of the Service resource.
// buildServiceName - the name of the build service resource.
func (client BuildServiceClient) ListSupportedStacks(ctx context.Context, resourceGroupName string, serviceName string, buildServiceName string) (result SupportedStacksCollection, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/BuildServiceClient.ListSupportedStacks")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.ListSupportedStacksPreparer(ctx, resourceGroupName, serviceName, buildServiceName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "appplatform.BuildServiceClient", "ListSupportedStacks", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListSupportedStacksSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "appplatform.BuildServiceClient", "ListSupportedStacks", resp, "Failure sending request")
		return
	}

	result, err = client.ListSupportedStacksResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "appplatform.BuildServiceClient", "ListSupportedStacks", resp, "Failure responding to request")
		return
	}

	return
}

// ListSupportedStacksPreparer prepares the ListSupportedStacks request.
func (client BuildServiceClient) ListSupportedStacksPreparer(ctx context.Context, resourceGroupName string, serviceName string, buildServiceName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"buildServiceName":  autorest.Encode("path", buildServiceName),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"serviceName":       autorest.Encode("path", serviceName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2022-01-01-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AppPlatform/Spring/{serviceName}/buildServices/{buildServiceName}/supportedStacks", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListSupportedStacksSender sends the ListSupportedStacks request. The method will close the
// http.Response Body if it receives an error.
func (client BuildServiceClient) ListSupportedStacksSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// ListSupportedStacksResponder handles the response to the ListSupportedStacks request. The method always
// closes the http.Response Body.
func (client BuildServiceClient) ListSupportedStacksResponder(resp *http.Response) (result SupportedStacksCollection, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}
