--------------------------------------------------------------------------------
-- |
-- Module      :  Graphics.Rendering.OpenGL.Raw.Compatibility45
-- Copyright   :  (c) Sven Panne 2015
-- License     :  BSD3
--
-- Maintainer  :  Sven Panne <svenpanne@gmail.com>
-- Stability   :  stable
-- Portability :  portable
--
--------------------------------------------------------------------------------

module Graphics.Rendering.OpenGL.Raw.Compatibility45 (
  -- * Types
  GLDEBUGPROC,
  GLDEBUGPROCFunc,
  GLbitfield,
  GLboolean,
  GLbyte,
  GLchar,
  GLclampd,
  GLclampf,
  GLdouble,
  GLenum,
  GLfloat,
  GLhalf,
  GLint,
  GLint64,
  GLintptr,
  GLshort,
  GLsizei,
  GLsizeiptr,
  GLsync,
  GLubyte,
  GLuint,
  GLuint64,
  GLushort,
  GLvoid,
  makeGLDEBUGPROC,
  -- * Enums
  gl_2D,
  gl_2_BYTES,
  gl_3D,
  gl_3D_COLOR,
  gl_3D_COLOR_TEXTURE,
  gl_3_BYTES,
  gl_4D_COLOR_TEXTURE,
  gl_4_BYTES,
  gl_ACCUM,
  gl_ACCUM_ALPHA_BITS,
  gl_ACCUM_BLUE_BITS,
  gl_ACCUM_BUFFER_BIT,
  gl_ACCUM_CLEAR_VALUE,
  gl_ACCUM_GREEN_BITS,
  gl_ACCUM_RED_BITS,
  gl_ACTIVE_ATOMIC_COUNTER_BUFFERS,
  gl_ACTIVE_ATTRIBUTES,
  gl_ACTIVE_ATTRIBUTE_MAX_LENGTH,
  gl_ACTIVE_PROGRAM,
  gl_ACTIVE_RESOURCES,
  gl_ACTIVE_SUBROUTINES,
  gl_ACTIVE_SUBROUTINE_MAX_LENGTH,
  gl_ACTIVE_SUBROUTINE_UNIFORMS,
  gl_ACTIVE_SUBROUTINE_UNIFORM_LOCATIONS,
  gl_ACTIVE_SUBROUTINE_UNIFORM_MAX_LENGTH,
  gl_ACTIVE_TEXTURE,
  gl_ACTIVE_UNIFORMS,
  gl_ACTIVE_UNIFORM_BLOCKS,
  gl_ACTIVE_UNIFORM_BLOCK_MAX_NAME_LENGTH,
  gl_ACTIVE_UNIFORM_MAX_LENGTH,
  gl_ACTIVE_VARIABLES,
  gl_ADD,
  gl_ADD_SIGNED,
  gl_ALIASED_LINE_WIDTH_RANGE,
  gl_ALIASED_POINT_SIZE_RANGE,
  gl_ALL_ATTRIB_BITS,
  gl_ALL_BARRIER_BITS,
  gl_ALL_SHADER_BITS,
  gl_ALPHA,
  gl_ALPHA12,
  gl_ALPHA16,
  gl_ALPHA4,
  gl_ALPHA8,
  gl_ALPHA_BIAS,
  gl_ALPHA_BITS,
  gl_ALPHA_INTEGER,
  gl_ALPHA_SCALE,
  gl_ALPHA_TEST,
  gl_ALPHA_TEST_FUNC,
  gl_ALPHA_TEST_REF,
  gl_ALREADY_SIGNALED,
  gl_ALWAYS,
  gl_AMBIENT,
  gl_AMBIENT_AND_DIFFUSE,
  gl_AND,
  gl_AND_INVERTED,
  gl_AND_REVERSE,
  gl_ANY_SAMPLES_PASSED,
  gl_ANY_SAMPLES_PASSED_CONSERVATIVE,
  gl_ARRAY_BUFFER,
  gl_ARRAY_BUFFER_BINDING,
  gl_ARRAY_SIZE,
  gl_ARRAY_STRIDE,
  gl_ATOMIC_COUNTER_BARRIER_BIT,
  gl_ATOMIC_COUNTER_BUFFER,
  gl_ATOMIC_COUNTER_BUFFER_ACTIVE_ATOMIC_COUNTERS,
  gl_ATOMIC_COUNTER_BUFFER_ACTIVE_ATOMIC_COUNTER_INDICES,
  gl_ATOMIC_COUNTER_BUFFER_BINDING,
  gl_ATOMIC_COUNTER_BUFFER_DATA_SIZE,
  gl_ATOMIC_COUNTER_BUFFER_INDEX,
  gl_ATOMIC_COUNTER_BUFFER_REFERENCED_BY_COMPUTE_SHADER,
  gl_ATOMIC_COUNTER_BUFFER_REFERENCED_BY_FRAGMENT_SHADER,
  gl_ATOMIC_COUNTER_BUFFER_REFERENCED_BY_GEOMETRY_SHADER,
  gl_ATOMIC_COUNTER_BUFFER_REFERENCED_BY_TESS_CONTROL_SHADER,
  gl_ATOMIC_COUNTER_BUFFER_REFERENCED_BY_TESS_EVALUATION_SHADER,
  gl_ATOMIC_COUNTER_BUFFER_REFERENCED_BY_VERTEX_SHADER,
  gl_ATOMIC_COUNTER_BUFFER_SIZE,
  gl_ATOMIC_COUNTER_BUFFER_START,
  gl_ATTACHED_SHADERS,
  gl_ATTRIB_STACK_DEPTH,
  gl_AUTO_GENERATE_MIPMAP,
  gl_AUTO_NORMAL,
  gl_AUX0,
  gl_AUX1,
  gl_AUX2,
  gl_AUX3,
  gl_AUX_BUFFERS,
  gl_BACK,
  gl_BACK_LEFT,
  gl_BACK_RIGHT,
  gl_BGR,
  gl_BGRA,
  gl_BGRA_INTEGER,
  gl_BGR_INTEGER,
  gl_BITMAP,
  gl_BITMAP_TOKEN,
  gl_BLEND,
  gl_BLEND_DST,
  gl_BLEND_DST_ALPHA,
  gl_BLEND_DST_RGB,
  gl_BLEND_EQUATION_ALPHA,
  gl_BLEND_EQUATION_RGB,
  gl_BLEND_SRC,
  gl_BLEND_SRC_ALPHA,
  gl_BLEND_SRC_RGB,
  gl_BLOCK_INDEX,
  gl_BLUE,
  gl_BLUE_BIAS,
  gl_BLUE_BITS,
  gl_BLUE_INTEGER,
  gl_BLUE_SCALE,
  gl_BOOL,
  gl_BOOL_VEC2,
  gl_BOOL_VEC3,
  gl_BOOL_VEC4,
  gl_BUFFER,
  gl_BUFFER_ACCESS,
  gl_BUFFER_ACCESS_FLAGS,
  gl_BUFFER_BINDING,
  gl_BUFFER_DATA_SIZE,
  gl_BUFFER_IMMUTABLE_STORAGE,
  gl_BUFFER_MAPPED,
  gl_BUFFER_MAP_LENGTH,
  gl_BUFFER_MAP_OFFSET,
  gl_BUFFER_MAP_POINTER,
  gl_BUFFER_SIZE,
  gl_BUFFER_STORAGE_FLAGS,
  gl_BUFFER_UPDATE_BARRIER_BIT,
  gl_BUFFER_USAGE,
  gl_BUFFER_VARIABLE,
  gl_BYTE,
  gl_C3F_V3F,
  gl_C4F_N3F_V3F,
  gl_C4UB_V2F,
  gl_C4UB_V3F,
  gl_CAVEAT_SUPPORT,
  gl_CCW,
  gl_CLAMP,
  gl_CLAMP_FRAGMENT_COLOR,
  gl_CLAMP_READ_COLOR,
  gl_CLAMP_TO_BORDER,
  gl_CLAMP_TO_EDGE,
  gl_CLAMP_VERTEX_COLOR,
  gl_CLEAR,
  gl_CLEAR_BUFFER,
  gl_CLEAR_TEXTURE,
  gl_CLIENT_ACTIVE_TEXTURE,
  gl_CLIENT_ALL_ATTRIB_BITS,
  gl_CLIENT_ATTRIB_STACK_DEPTH,
  gl_CLIENT_MAPPED_BUFFER_BARRIER_BIT,
  gl_CLIENT_PIXEL_STORE_BIT,
  gl_CLIENT_STORAGE_BIT,
  gl_CLIENT_VERTEX_ARRAY_BIT,
  gl_CLIP_DEPTH_MODE,
  gl_CLIP_DISTANCE0,
  gl_CLIP_DISTANCE1,
  gl_CLIP_DISTANCE2,
  gl_CLIP_DISTANCE3,
  gl_CLIP_DISTANCE4,
  gl_CLIP_DISTANCE5,
  gl_CLIP_DISTANCE6,
  gl_CLIP_DISTANCE7,
  gl_CLIP_ORIGIN,
  gl_CLIP_PLANE0,
  gl_CLIP_PLANE1,
  gl_CLIP_PLANE2,
  gl_CLIP_PLANE3,
  gl_CLIP_PLANE4,
  gl_CLIP_PLANE5,
  gl_COEFF,
  gl_COLOR,
  gl_COLOR_ARRAY,
  gl_COLOR_ARRAY_BUFFER_BINDING,
  gl_COLOR_ARRAY_POINTER,
  gl_COLOR_ARRAY_SIZE,
  gl_COLOR_ARRAY_STRIDE,
  gl_COLOR_ARRAY_TYPE,
  gl_COLOR_ATTACHMENT0,
  gl_COLOR_ATTACHMENT1,
  gl_COLOR_ATTACHMENT10,
  gl_COLOR_ATTACHMENT11,
  gl_COLOR_ATTACHMENT12,
  gl_COLOR_ATTACHMENT13,
  gl_COLOR_ATTACHMENT14,
  gl_COLOR_ATTACHMENT15,
  gl_COLOR_ATTACHMENT2,
  gl_COLOR_ATTACHMENT3,
  gl_COLOR_ATTACHMENT4,
  gl_COLOR_ATTACHMENT5,
  gl_COLOR_ATTACHMENT6,
  gl_COLOR_ATTACHMENT7,
  gl_COLOR_ATTACHMENT8,
  gl_COLOR_ATTACHMENT9,
  gl_COLOR_BUFFER_BIT,
  gl_COLOR_CLEAR_VALUE,
  gl_COLOR_COMPONENTS,
  gl_COLOR_ENCODING,
  gl_COLOR_INDEX,
  gl_COLOR_INDEXES,
  gl_COLOR_LOGIC_OP,
  gl_COLOR_MATERIAL,
  gl_COLOR_MATERIAL_FACE,
  gl_COLOR_MATERIAL_PARAMETER,
  gl_COLOR_RENDERABLE,
  gl_COLOR_SUM,
  gl_COLOR_WRITEMASK,
  gl_COMBINE,
  gl_COMBINE_ALPHA,
  gl_COMBINE_RGB,
  gl_COMMAND_BARRIER_BIT,
  gl_COMPARE_REF_TO_TEXTURE,
  gl_COMPARE_R_TO_TEXTURE,
  gl_COMPATIBLE_SUBROUTINES,
  gl_COMPILE,
  gl_COMPILE_AND_EXECUTE,
  gl_COMPILE_STATUS,
  gl_COMPRESSED_ALPHA,
  gl_COMPRESSED_INTENSITY,
  gl_COMPRESSED_LUMINANCE,
  gl_COMPRESSED_LUMINANCE_ALPHA,
  gl_COMPRESSED_R11_EAC,
  gl_COMPRESSED_RED,
  gl_COMPRESSED_RED_RGTC1,
  gl_COMPRESSED_RG,
  gl_COMPRESSED_RG11_EAC,
  gl_COMPRESSED_RGB,
  gl_COMPRESSED_RGB8_ETC2,
  gl_COMPRESSED_RGB8_PUNCHTHROUGH_ALPHA1_ETC2,
  gl_COMPRESSED_RGBA,
  gl_COMPRESSED_RGBA8_ETC2_EAC,
  gl_COMPRESSED_RGBA_BPTC_UNORM,
  gl_COMPRESSED_RGB_BPTC_SIGNED_FLOAT,
  gl_COMPRESSED_RGB_BPTC_UNSIGNED_FLOAT,
  gl_COMPRESSED_RG_RGTC2,
  gl_COMPRESSED_SIGNED_R11_EAC,
  gl_COMPRESSED_SIGNED_RED_RGTC1,
  gl_COMPRESSED_SIGNED_RG11_EAC,
  gl_COMPRESSED_SIGNED_RG_RGTC2,
  gl_COMPRESSED_SLUMINANCE,
  gl_COMPRESSED_SLUMINANCE_ALPHA,
  gl_COMPRESSED_SRGB,
  gl_COMPRESSED_SRGB8_ALPHA8_ETC2_EAC,
  gl_COMPRESSED_SRGB8_ETC2,
  gl_COMPRESSED_SRGB8_PUNCHTHROUGH_ALPHA1_ETC2,
  gl_COMPRESSED_SRGB_ALPHA,
  gl_COMPRESSED_SRGB_ALPHA_BPTC_UNORM,
  gl_COMPRESSED_TEXTURE_FORMATS,
  gl_COMPUTE_SHADER,
  gl_COMPUTE_SHADER_BIT,
  gl_COMPUTE_SUBROUTINE,
  gl_COMPUTE_SUBROUTINE_UNIFORM,
  gl_COMPUTE_TEXTURE,
  gl_COMPUTE_WORK_GROUP_SIZE,
  gl_CONDITION_SATISFIED,
  gl_CONSTANT,
  gl_CONSTANT_ALPHA,
  gl_CONSTANT_ATTENUATION,
  gl_CONSTANT_COLOR,
  gl_CONTEXT_COMPATIBILITY_PROFILE_BIT,
  gl_CONTEXT_CORE_PROFILE_BIT,
  gl_CONTEXT_FLAGS,
  gl_CONTEXT_FLAG_DEBUG_BIT,
  gl_CONTEXT_FLAG_FORWARD_COMPATIBLE_BIT,
  gl_CONTEXT_FLAG_ROBUST_ACCESS_BIT,
  gl_CONTEXT_LOST,
  gl_CONTEXT_PROFILE_MASK,
  gl_CONTEXT_RELEASE_BEHAVIOR,
  gl_CONTEXT_RELEASE_BEHAVIOR_FLUSH,
  gl_COORD_REPLACE,
  gl_COPY,
  gl_COPY_INVERTED,
  gl_COPY_PIXEL_TOKEN,
  gl_COPY_READ_BUFFER,
  gl_COPY_READ_BUFFER_BINDING,
  gl_COPY_WRITE_BUFFER,
  gl_COPY_WRITE_BUFFER_BINDING,
  gl_CULL_FACE,
  gl_CULL_FACE_MODE,
  gl_CURRENT_BIT,
  gl_CURRENT_COLOR,
  gl_CURRENT_FOG_COORD,
  gl_CURRENT_FOG_COORDINATE,
  gl_CURRENT_INDEX,
  gl_CURRENT_NORMAL,
  gl_CURRENT_PROGRAM,
  gl_CURRENT_QUERY,
  gl_CURRENT_RASTER_COLOR,
  gl_CURRENT_RASTER_DISTANCE,
  gl_CURRENT_RASTER_INDEX,
  gl_CURRENT_RASTER_POSITION,
  gl_CURRENT_RASTER_POSITION_VALID,
  gl_CURRENT_RASTER_SECONDARY_COLOR,
  gl_CURRENT_RASTER_TEXTURE_COORDS,
  gl_CURRENT_SECONDARY_COLOR,
  gl_CURRENT_TEXTURE_COORDS,
  gl_CURRENT_VERTEX_ATTRIB,
  gl_CW,
  gl_DEBUG_CALLBACK_FUNCTION,
  gl_DEBUG_CALLBACK_USER_PARAM,
  gl_DEBUG_GROUP_STACK_DEPTH,
  gl_DEBUG_LOGGED_MESSAGES,
  gl_DEBUG_NEXT_LOGGED_MESSAGE_LENGTH,
  gl_DEBUG_OUTPUT,
  gl_DEBUG_OUTPUT_SYNCHRONOUS,
  gl_DEBUG_SEVERITY_HIGH,
  gl_DEBUG_SEVERITY_LOW,
  gl_DEBUG_SEVERITY_MEDIUM,
  gl_DEBUG_SEVERITY_NOTIFICATION,
  gl_DEBUG_SOURCE_API,
  gl_DEBUG_SOURCE_APPLICATION,
  gl_DEBUG_SOURCE_OTHER,
  gl_DEBUG_SOURCE_SHADER_COMPILER,
  gl_DEBUG_SOURCE_THIRD_PARTY,
  gl_DEBUG_SOURCE_WINDOW_SYSTEM,
  gl_DEBUG_TYPE_DEPRECATED_BEHAVIOR,
  gl_DEBUG_TYPE_ERROR,
  gl_DEBUG_TYPE_MARKER,
  gl_DEBUG_TYPE_OTHER,
  gl_DEBUG_TYPE_PERFORMANCE,
  gl_DEBUG_TYPE_POP_GROUP,
  gl_DEBUG_TYPE_PORTABILITY,
  gl_DEBUG_TYPE_PUSH_GROUP,
  gl_DEBUG_TYPE_UNDEFINED_BEHAVIOR,
  gl_DECAL,
  gl_DECR,
  gl_DECR_WRAP,
  gl_DELETE_STATUS,
  gl_DEPTH,
  gl_DEPTH24_STENCIL8,
  gl_DEPTH32F_STENCIL8,
  gl_DEPTH_ATTACHMENT,
  gl_DEPTH_BIAS,
  gl_DEPTH_BITS,
  gl_DEPTH_BUFFER_BIT,
  gl_DEPTH_CLAMP,
  gl_DEPTH_CLEAR_VALUE,
  gl_DEPTH_COMPONENT,
  gl_DEPTH_COMPONENT16,
  gl_DEPTH_COMPONENT24,
  gl_DEPTH_COMPONENT32,
  gl_DEPTH_COMPONENT32F,
  gl_DEPTH_COMPONENTS,
  gl_DEPTH_FUNC,
  gl_DEPTH_RANGE,
  gl_DEPTH_RENDERABLE,
  gl_DEPTH_SCALE,
  gl_DEPTH_STENCIL,
  gl_DEPTH_STENCIL_ATTACHMENT,
  gl_DEPTH_STENCIL_TEXTURE_MODE,
  gl_DEPTH_TEST,
  gl_DEPTH_TEXTURE_MODE,
  gl_DEPTH_WRITEMASK,
  gl_DIFFUSE,
  gl_DISPATCH_INDIRECT_BUFFER,
  gl_DISPATCH_INDIRECT_BUFFER_BINDING,
  gl_DISPLAY_LIST,
  gl_DITHER,
  gl_DOMAIN,
  gl_DONT_CARE,
  gl_DOT3_RGB,
  gl_DOT3_RGBA,
  gl_DOUBLE,
  gl_DOUBLEBUFFER,
  gl_DOUBLE_MAT2,
  gl_DOUBLE_MAT2x3,
  gl_DOUBLE_MAT2x4,
  gl_DOUBLE_MAT3,
  gl_DOUBLE_MAT3x2,
  gl_DOUBLE_MAT3x4,
  gl_DOUBLE_MAT4,
  gl_DOUBLE_MAT4x2,
  gl_DOUBLE_MAT4x3,
  gl_DOUBLE_VEC2,
  gl_DOUBLE_VEC3,
  gl_DOUBLE_VEC4,
  gl_DRAW_BUFFER,
  gl_DRAW_BUFFER0,
  gl_DRAW_BUFFER1,
  gl_DRAW_BUFFER10,
  gl_DRAW_BUFFER11,
  gl_DRAW_BUFFER12,
  gl_DRAW_BUFFER13,
  gl_DRAW_BUFFER14,
  gl_DRAW_BUFFER15,
  gl_DRAW_BUFFER2,
  gl_DRAW_BUFFER3,
  gl_DRAW_BUFFER4,
  gl_DRAW_BUFFER5,
  gl_DRAW_BUFFER6,
  gl_DRAW_BUFFER7,
  gl_DRAW_BUFFER8,
  gl_DRAW_BUFFER9,
  gl_DRAW_FRAMEBUFFER,
  gl_DRAW_FRAMEBUFFER_BINDING,
  gl_DRAW_INDIRECT_BUFFER,
  gl_DRAW_INDIRECT_BUFFER_BINDING,
  gl_DRAW_PIXEL_TOKEN,
  gl_DST_ALPHA,
  gl_DST_COLOR,
  gl_DYNAMIC_COPY,
  gl_DYNAMIC_DRAW,
  gl_DYNAMIC_READ,
  gl_DYNAMIC_STORAGE_BIT,
  gl_EDGE_FLAG,
  gl_EDGE_FLAG_ARRAY,
  gl_EDGE_FLAG_ARRAY_BUFFER_BINDING,
  gl_EDGE_FLAG_ARRAY_POINTER,
  gl_EDGE_FLAG_ARRAY_STRIDE,
  gl_ELEMENT_ARRAY_BARRIER_BIT,
  gl_ELEMENT_ARRAY_BUFFER,
  gl_ELEMENT_ARRAY_BUFFER_BINDING,
  gl_EMISSION,
  gl_ENABLE_BIT,
  gl_EQUAL,
  gl_EQUIV,
  gl_EVAL_BIT,
  gl_EXP,
  gl_EXP2,
  gl_EXTENSIONS,
  gl_EYE_LINEAR,
  gl_EYE_PLANE,
  gl_FALSE,
  gl_FASTEST,
  gl_FEEDBACK,
  gl_FEEDBACK_BUFFER_POINTER,
  gl_FEEDBACK_BUFFER_SIZE,
  gl_FEEDBACK_BUFFER_TYPE,
  gl_FILL,
  gl_FILTER,
  gl_FIRST_VERTEX_CONVENTION,
  gl_FIXED,
  gl_FIXED_ONLY,
  gl_FLAT,
  gl_FLOAT,
  gl_FLOAT_32_UNSIGNED_INT_24_8_REV,
  gl_FLOAT_MAT2,
  gl_FLOAT_MAT2x3,
  gl_FLOAT_MAT2x4,
  gl_FLOAT_MAT3,
  gl_FLOAT_MAT3x2,
  gl_FLOAT_MAT3x4,
  gl_FLOAT_MAT4,
  gl_FLOAT_MAT4x2,
  gl_FLOAT_MAT4x3,
  gl_FLOAT_VEC2,
  gl_FLOAT_VEC3,
  gl_FLOAT_VEC4,
  gl_FOG,
  gl_FOG_BIT,
  gl_FOG_COLOR,
  gl_FOG_COORD,
  gl_FOG_COORDINATE,
  gl_FOG_COORDINATE_ARRAY,
  gl_FOG_COORDINATE_ARRAY_BUFFER_BINDING,
  gl_FOG_COORDINATE_ARRAY_POINTER,
  gl_FOG_COORDINATE_ARRAY_STRIDE,
  gl_FOG_COORDINATE_ARRAY_TYPE,
  gl_FOG_COORDINATE_SOURCE,
  gl_FOG_COORD_ARRAY,
  gl_FOG_COORD_ARRAY_BUFFER_BINDING,
  gl_FOG_COORD_ARRAY_POINTER,
  gl_FOG_COORD_ARRAY_STRIDE,
  gl_FOG_COORD_ARRAY_TYPE,
  gl_FOG_COORD_SRC,
  gl_FOG_DENSITY,
  gl_FOG_END,
  gl_FOG_HINT,
  gl_FOG_INDEX,
  gl_FOG_MODE,
  gl_FOG_START,
  gl_FRACTIONAL_EVEN,
  gl_FRACTIONAL_ODD,
  gl_FRAGMENT_DEPTH,
  gl_FRAGMENT_INTERPOLATION_OFFSET_BITS,
  gl_FRAGMENT_SHADER,
  gl_FRAGMENT_SHADER_BIT,
  gl_FRAGMENT_SHADER_DERIVATIVE_HINT,
  gl_FRAGMENT_SUBROUTINE,
  gl_FRAGMENT_SUBROUTINE_UNIFORM,
  gl_FRAGMENT_TEXTURE,
  gl_FRAMEBUFFER,
  gl_FRAMEBUFFER_ATTACHMENT_ALPHA_SIZE,
  gl_FRAMEBUFFER_ATTACHMENT_BLUE_SIZE,
  gl_FRAMEBUFFER_ATTACHMENT_COLOR_ENCODING,
  gl_FRAMEBUFFER_ATTACHMENT_COMPONENT_TYPE,
  gl_FRAMEBUFFER_ATTACHMENT_DEPTH_SIZE,
  gl_FRAMEBUFFER_ATTACHMENT_GREEN_SIZE,
  gl_FRAMEBUFFER_ATTACHMENT_LAYERED,
  gl_FRAMEBUFFER_ATTACHMENT_OBJECT_NAME,
  gl_FRAMEBUFFER_ATTACHMENT_OBJECT_TYPE,
  gl_FRAMEBUFFER_ATTACHMENT_RED_SIZE,
  gl_FRAMEBUFFER_ATTACHMENT_STENCIL_SIZE,
  gl_FRAMEBUFFER_ATTACHMENT_TEXTURE_CUBE_MAP_FACE,
  gl_FRAMEBUFFER_ATTACHMENT_TEXTURE_LAYER,
  gl_FRAMEBUFFER_ATTACHMENT_TEXTURE_LEVEL,
  gl_FRAMEBUFFER_BARRIER_BIT,
  gl_FRAMEBUFFER_BINDING,
  gl_FRAMEBUFFER_BLEND,
  gl_FRAMEBUFFER_COMPLETE,
  gl_FRAMEBUFFER_DEFAULT,
  gl_FRAMEBUFFER_DEFAULT_FIXED_SAMPLE_LOCATIONS,
  gl_FRAMEBUFFER_DEFAULT_HEIGHT,
  gl_FRAMEBUFFER_DEFAULT_LAYERS,
  gl_FRAMEBUFFER_DEFAULT_SAMPLES,
  gl_FRAMEBUFFER_DEFAULT_WIDTH,
  gl_FRAMEBUFFER_INCOMPLETE_ATTACHMENT,
  gl_FRAMEBUFFER_INCOMPLETE_DRAW_BUFFER,
  gl_FRAMEBUFFER_INCOMPLETE_LAYER_TARGETS,
  gl_FRAMEBUFFER_INCOMPLETE_MISSING_ATTACHMENT,
  gl_FRAMEBUFFER_INCOMPLETE_MULTISAMPLE,
  gl_FRAMEBUFFER_INCOMPLETE_READ_BUFFER,
  gl_FRAMEBUFFER_RENDERABLE,
  gl_FRAMEBUFFER_RENDERABLE_LAYERED,
  gl_FRAMEBUFFER_SRGB,
  gl_FRAMEBUFFER_UNDEFINED,
  gl_FRAMEBUFFER_UNSUPPORTED,
  gl_FRONT,
  gl_FRONT_AND_BACK,
  gl_FRONT_FACE,
  gl_FRONT_LEFT,
  gl_FRONT_RIGHT,
  gl_FULL_SUPPORT,
  gl_FUNC_ADD,
  gl_FUNC_REVERSE_SUBTRACT,
  gl_FUNC_SUBTRACT,
  gl_GENERATE_MIPMAP,
  gl_GENERATE_MIPMAP_HINT,
  gl_GEOMETRY_INPUT_TYPE,
  gl_GEOMETRY_OUTPUT_TYPE,
  gl_GEOMETRY_SHADER,
  gl_GEOMETRY_SHADER_BIT,
  gl_GEOMETRY_SHADER_INVOCATIONS,
  gl_GEOMETRY_SUBROUTINE,
  gl_GEOMETRY_SUBROUTINE_UNIFORM,
  gl_GEOMETRY_TEXTURE,
  gl_GEOMETRY_VERTICES_OUT,
  gl_GEQUAL,
  gl_GET_TEXTURE_IMAGE_FORMAT,
  gl_GET_TEXTURE_IMAGE_TYPE,
  gl_GREATER,
  gl_GREEN,
  gl_GREEN_BIAS,
  gl_GREEN_BITS,
  gl_GREEN_INTEGER,
  gl_GREEN_SCALE,
  gl_GUILTY_CONTEXT_RESET,
  gl_HALF_FLOAT,
  gl_HIGH_FLOAT,
  gl_HIGH_INT,
  gl_HINT_BIT,
  gl_IMAGE_1D,
  gl_IMAGE_1D_ARRAY,
  gl_IMAGE_2D,
  gl_IMAGE_2D_ARRAY,
  gl_IMAGE_2D_MULTISAMPLE,
  gl_IMAGE_2D_MULTISAMPLE_ARRAY,
  gl_IMAGE_2D_RECT,
  gl_IMAGE_3D,
  gl_IMAGE_BINDING_ACCESS,
  gl_IMAGE_BINDING_FORMAT,
  gl_IMAGE_BINDING_LAYER,
  gl_IMAGE_BINDING_LAYERED,
  gl_IMAGE_BINDING_LEVEL,
  gl_IMAGE_BINDING_NAME,
  gl_IMAGE_BUFFER,
  gl_IMAGE_CLASS_10_10_10_2,
  gl_IMAGE_CLASS_11_11_10,
  gl_IMAGE_CLASS_1_X_16,
  gl_IMAGE_CLASS_1_X_32,
  gl_IMAGE_CLASS_1_X_8,
  gl_IMAGE_CLASS_2_X_16,
  gl_IMAGE_CLASS_2_X_32,
  gl_IMAGE_CLASS_2_X_8,
  gl_IMAGE_CLASS_4_X_16,
  gl_IMAGE_CLASS_4_X_32,
  gl_IMAGE_CLASS_4_X_8,
  gl_IMAGE_COMPATIBILITY_CLASS,
  gl_IMAGE_CUBE,
  gl_IMAGE_CUBE_MAP_ARRAY,
  gl_IMAGE_FORMAT_COMPATIBILITY_BY_CLASS,
  gl_IMAGE_FORMAT_COMPATIBILITY_BY_SIZE,
  gl_IMAGE_FORMAT_COMPATIBILITY_TYPE,
  gl_IMAGE_PIXEL_FORMAT,
  gl_IMAGE_PIXEL_TYPE,
  gl_IMAGE_TEXEL_SIZE,
  gl_IMPLEMENTATION_COLOR_READ_FORMAT,
  gl_IMPLEMENTATION_COLOR_READ_TYPE,
  gl_INCR,
  gl_INCR_WRAP,
  gl_INDEX,
  gl_INDEX_ARRAY,
  gl_INDEX_ARRAY_BUFFER_BINDING,
  gl_INDEX_ARRAY_POINTER,
  gl_INDEX_ARRAY_STRIDE,
  gl_INDEX_ARRAY_TYPE,
  gl_INDEX_BITS,
  gl_INDEX_CLEAR_VALUE,
  gl_INDEX_LOGIC_OP,
  gl_INDEX_MODE,
  gl_INDEX_OFFSET,
  gl_INDEX_SHIFT,
  gl_INDEX_WRITEMASK,
  gl_INFO_LOG_LENGTH,
  gl_INNOCENT_CONTEXT_RESET,
  gl_INT,
  gl_INTENSITY,
  gl_INTENSITY12,
  gl_INTENSITY16,
  gl_INTENSITY4,
  gl_INTENSITY8,
  gl_INTERLEAVED_ATTRIBS,
  gl_INTERNALFORMAT_ALPHA_SIZE,
  gl_INTERNALFORMAT_ALPHA_TYPE,
  gl_INTERNALFORMAT_BLUE_SIZE,
  gl_INTERNALFORMAT_BLUE_TYPE,
  gl_INTERNALFORMAT_DEPTH_SIZE,
  gl_INTERNALFORMAT_DEPTH_TYPE,
  gl_INTERNALFORMAT_GREEN_SIZE,
  gl_INTERNALFORMAT_GREEN_TYPE,
  gl_INTERNALFORMAT_PREFERRED,
  gl_INTERNALFORMAT_RED_SIZE,
  gl_INTERNALFORMAT_RED_TYPE,
  gl_INTERNALFORMAT_SHARED_SIZE,
  gl_INTERNALFORMAT_STENCIL_SIZE,
  gl_INTERNALFORMAT_STENCIL_TYPE,
  gl_INTERNALFORMAT_SUPPORTED,
  gl_INTERPOLATE,
  gl_INT_2_10_10_10_REV,
  gl_INT_IMAGE_1D,
  gl_INT_IMAGE_1D_ARRAY,
  gl_INT_IMAGE_2D,
  gl_INT_IMAGE_2D_ARRAY,
  gl_INT_IMAGE_2D_MULTISAMPLE,
  gl_INT_IMAGE_2D_MULTISAMPLE_ARRAY,
  gl_INT_IMAGE_2D_RECT,
  gl_INT_IMAGE_3D,
  gl_INT_IMAGE_BUFFER,
  gl_INT_IMAGE_CUBE,
  gl_INT_IMAGE_CUBE_MAP_ARRAY,
  gl_INT_SAMPLER_1D,
  gl_INT_SAMPLER_1D_ARRAY,
  gl_INT_SAMPLER_2D,
  gl_INT_SAMPLER_2D_ARRAY,
  gl_INT_SAMPLER_2D_MULTISAMPLE,
  gl_INT_SAMPLER_2D_MULTISAMPLE_ARRAY,
  gl_INT_SAMPLER_2D_RECT,
  gl_INT_SAMPLER_3D,
  gl_INT_SAMPLER_BUFFER,
  gl_INT_SAMPLER_CUBE,
  gl_INT_SAMPLER_CUBE_MAP_ARRAY,
  gl_INT_VEC2,
  gl_INT_VEC3,
  gl_INT_VEC4,
  gl_INVALID_ENUM,
  gl_INVALID_FRAMEBUFFER_OPERATION,
  gl_INVALID_INDEX,
  gl_INVALID_OPERATION,
  gl_INVALID_VALUE,
  gl_INVERT,
  gl_ISOLINES,
  gl_IS_PER_PATCH,
  gl_IS_ROW_MAJOR,
  gl_KEEP,
  gl_LAST_VERTEX_CONVENTION,
  gl_LAYER_PROVOKING_VERTEX,
  gl_LEFT,
  gl_LEQUAL,
  gl_LESS,
  gl_LIGHT0,
  gl_LIGHT1,
  gl_LIGHT2,
  gl_LIGHT3,
  gl_LIGHT4,
  gl_LIGHT5,
  gl_LIGHT6,
  gl_LIGHT7,
  gl_LIGHTING,
  gl_LIGHTING_BIT,
  gl_LIGHT_MODEL_AMBIENT,
  gl_LIGHT_MODEL_COLOR_CONTROL,
  gl_LIGHT_MODEL_LOCAL_VIEWER,
  gl_LIGHT_MODEL_TWO_SIDE,
  gl_LINE,
  gl_LINEAR,
  gl_LINEAR_ATTENUATION,
  gl_LINEAR_MIPMAP_LINEAR,
  gl_LINEAR_MIPMAP_NEAREST,
  gl_LINES,
  gl_LINES_ADJACENCY,
  gl_LINE_BIT,
  gl_LINE_LOOP,
  gl_LINE_RESET_TOKEN,
  gl_LINE_SMOOTH,
  gl_LINE_SMOOTH_HINT,
  gl_LINE_STIPPLE,
  gl_LINE_STIPPLE_PATTERN,
  gl_LINE_STIPPLE_REPEAT,
  gl_LINE_STRIP,
  gl_LINE_STRIP_ADJACENCY,
  gl_LINE_TOKEN,
  gl_LINE_WIDTH,
  gl_LINE_WIDTH_GRANULARITY,
  gl_LINE_WIDTH_RANGE,
  gl_LINK_STATUS,
  gl_LIST_BASE,
  gl_LIST_BIT,
  gl_LIST_INDEX,
  gl_LIST_MODE,
  gl_LOAD,
  gl_LOCATION,
  gl_LOCATION_COMPONENT,
  gl_LOCATION_INDEX,
  gl_LOGIC_OP,
  gl_LOGIC_OP_MODE,
  gl_LOSE_CONTEXT_ON_RESET,
  gl_LOWER_LEFT,
  gl_LOW_FLOAT,
  gl_LOW_INT,
  gl_LUMINANCE,
  gl_LUMINANCE12,
  gl_LUMINANCE12_ALPHA12,
  gl_LUMINANCE12_ALPHA4,
  gl_LUMINANCE16,
  gl_LUMINANCE16_ALPHA16,
  gl_LUMINANCE4,
  gl_LUMINANCE4_ALPHA4,
  gl_LUMINANCE6_ALPHA2,
  gl_LUMINANCE8,
  gl_LUMINANCE8_ALPHA8,
  gl_LUMINANCE_ALPHA,
  gl_MAJOR_VERSION,
  gl_MANUAL_GENERATE_MIPMAP,
  gl_MAP1_COLOR_4,
  gl_MAP1_GRID_DOMAIN,
  gl_MAP1_GRID_SEGMENTS,
  gl_MAP1_INDEX,
  gl_MAP1_NORMAL,
  gl_MAP1_TEXTURE_COORD_1,
  gl_MAP1_TEXTURE_COORD_2,
  gl_MAP1_TEXTURE_COORD_3,
  gl_MAP1_TEXTURE_COORD_4,
  gl_MAP1_VERTEX_3,
  gl_MAP1_VERTEX_4,
  gl_MAP2_COLOR_4,
  gl_MAP2_GRID_DOMAIN,
  gl_MAP2_GRID_SEGMENTS,
  gl_MAP2_INDEX,
  gl_MAP2_NORMAL,
  gl_MAP2_TEXTURE_COORD_1,
  gl_MAP2_TEXTURE_COORD_2,
  gl_MAP2_TEXTURE_COORD_3,
  gl_MAP2_TEXTURE_COORD_4,
  gl_MAP2_VERTEX_3,
  gl_MAP2_VERTEX_4,
  gl_MAP_COHERENT_BIT,
  gl_MAP_COLOR,
  gl_MAP_FLUSH_EXPLICIT_BIT,
  gl_MAP_INVALIDATE_BUFFER_BIT,
  gl_MAP_INVALIDATE_RANGE_BIT,
  gl_MAP_PERSISTENT_BIT,
  gl_MAP_READ_BIT,
  gl_MAP_STENCIL,
  gl_MAP_UNSYNCHRONIZED_BIT,
  gl_MAP_WRITE_BIT,
  gl_MATRIX_MODE,
  gl_MATRIX_STRIDE,
  gl_MAX,
  gl_MAX_3D_TEXTURE_SIZE,
  gl_MAX_ARRAY_TEXTURE_LAYERS,
  gl_MAX_ATOMIC_COUNTER_BUFFER_BINDINGS,
  gl_MAX_ATOMIC_COUNTER_BUFFER_SIZE,
  gl_MAX_ATTRIB_STACK_DEPTH,
  gl_MAX_CLIENT_ATTRIB_STACK_DEPTH,
  gl_MAX_CLIP_DISTANCES,
  gl_MAX_CLIP_PLANES,
  gl_MAX_COLOR_ATTACHMENTS,
  gl_MAX_COLOR_TEXTURE_SAMPLES,
  gl_MAX_COMBINED_ATOMIC_COUNTERS,
  gl_MAX_COMBINED_ATOMIC_COUNTER_BUFFERS,
  gl_MAX_COMBINED_CLIP_AND_CULL_DISTANCES,
  gl_MAX_COMBINED_COMPUTE_UNIFORM_COMPONENTS,
  gl_MAX_COMBINED_DIMENSIONS,
  gl_MAX_COMBINED_FRAGMENT_UNIFORM_COMPONENTS,
  gl_MAX_COMBINED_GEOMETRY_UNIFORM_COMPONENTS,
  gl_MAX_COMBINED_IMAGE_UNIFORMS,
  gl_MAX_COMBINED_IMAGE_UNITS_AND_FRAGMENT_OUTPUTS,
  gl_MAX_COMBINED_SHADER_OUTPUT_RESOURCES,
  gl_MAX_COMBINED_SHADER_STORAGE_BLOCKS,
  gl_MAX_COMBINED_TESS_CONTROL_UNIFORM_COMPONENTS,
  gl_MAX_COMBINED_TESS_EVALUATION_UNIFORM_COMPONENTS,
  gl_MAX_COMBINED_TEXTURE_IMAGE_UNITS,
  gl_MAX_COMBINED_UNIFORM_BLOCKS,
  gl_MAX_COMBINED_VERTEX_UNIFORM_COMPONENTS,
  gl_MAX_COMPUTE_ATOMIC_COUNTERS,
  gl_MAX_COMPUTE_ATOMIC_COUNTER_BUFFERS,
  gl_MAX_COMPUTE_IMAGE_UNIFORMS,
  gl_MAX_COMPUTE_SHADER_STORAGE_BLOCKS,
  gl_MAX_COMPUTE_SHARED_MEMORY_SIZE,
  gl_MAX_COMPUTE_TEXTURE_IMAGE_UNITS,
  gl_MAX_COMPUTE_UNIFORM_BLOCKS,
  gl_MAX_COMPUTE_UNIFORM_COMPONENTS,
  gl_MAX_COMPUTE_WORK_GROUP_COUNT,
  gl_MAX_COMPUTE_WORK_GROUP_INVOCATIONS,
  gl_MAX_COMPUTE_WORK_GROUP_SIZE,
  gl_MAX_CUBE_MAP_TEXTURE_SIZE,
  gl_MAX_CULL_DISTANCES,
  gl_MAX_DEBUG_GROUP_STACK_DEPTH,
  gl_MAX_DEBUG_LOGGED_MESSAGES,
  gl_MAX_DEBUG_MESSAGE_LENGTH,
  gl_MAX_DEPTH,
  gl_MAX_DEPTH_TEXTURE_SAMPLES,
  gl_MAX_DRAW_BUFFERS,
  gl_MAX_DUAL_SOURCE_DRAW_BUFFERS,
  gl_MAX_ELEMENTS_INDICES,
  gl_MAX_ELEMENTS_VERTICES,
  gl_MAX_ELEMENT_INDEX,
  gl_MAX_EVAL_ORDER,
  gl_MAX_FRAGMENT_ATOMIC_COUNTERS,
  gl_MAX_FRAGMENT_ATOMIC_COUNTER_BUFFERS,
  gl_MAX_FRAGMENT_IMAGE_UNIFORMS,
  gl_MAX_FRAGMENT_INPUT_COMPONENTS,
  gl_MAX_FRAGMENT_INTERPOLATION_OFFSET,
  gl_MAX_FRAGMENT_SHADER_STORAGE_BLOCKS,
  gl_MAX_FRAGMENT_UNIFORM_BLOCKS,
  gl_MAX_FRAGMENT_UNIFORM_COMPONENTS,
  gl_MAX_FRAGMENT_UNIFORM_VECTORS,
  gl_MAX_FRAMEBUFFER_HEIGHT,
  gl_MAX_FRAMEBUFFER_LAYERS,
  gl_MAX_FRAMEBUFFER_SAMPLES,
  gl_MAX_FRAMEBUFFER_WIDTH,
  gl_MAX_GEOMETRY_ATOMIC_COUNTERS,
  gl_MAX_GEOMETRY_ATOMIC_COUNTER_BUFFERS,
  gl_MAX_GEOMETRY_IMAGE_UNIFORMS,
  gl_MAX_GEOMETRY_INPUT_COMPONENTS,
  gl_MAX_GEOMETRY_OUTPUT_COMPONENTS,
  gl_MAX_GEOMETRY_OUTPUT_VERTICES,
  gl_MAX_GEOMETRY_SHADER_INVOCATIONS,
  gl_MAX_GEOMETRY_SHADER_STORAGE_BLOCKS,
  gl_MAX_GEOMETRY_TEXTURE_IMAGE_UNITS,
  gl_MAX_GEOMETRY_TOTAL_OUTPUT_COMPONENTS,
  gl_MAX_GEOMETRY_UNIFORM_BLOCKS,
  gl_MAX_GEOMETRY_UNIFORM_COMPONENTS,
  gl_MAX_HEIGHT,
  gl_MAX_IMAGE_SAMPLES,
  gl_MAX_IMAGE_UNITS,
  gl_MAX_INTEGER_SAMPLES,
  gl_MAX_LABEL_LENGTH,
  gl_MAX_LAYERS,
  gl_MAX_LIGHTS,
  gl_MAX_LIST_NESTING,
  gl_MAX_MODELVIEW_STACK_DEPTH,
  gl_MAX_NAME_LENGTH,
  gl_MAX_NAME_STACK_DEPTH,
  gl_MAX_NUM_ACTIVE_VARIABLES,
  gl_MAX_NUM_COMPATIBLE_SUBROUTINES,
  gl_MAX_PATCH_VERTICES,
  gl_MAX_PIXEL_MAP_TABLE,
  gl_MAX_PROGRAM_TEXEL_OFFSET,
  gl_MAX_PROGRAM_TEXTURE_GATHER_OFFSET,
  gl_MAX_PROJECTION_STACK_DEPTH,
  gl_MAX_RECTANGLE_TEXTURE_SIZE,
  gl_MAX_RENDERBUFFER_SIZE,
  gl_MAX_SAMPLES,
  gl_MAX_SAMPLE_MASK_WORDS,
  gl_MAX_SERVER_WAIT_TIMEOUT,
  gl_MAX_SHADER_STORAGE_BLOCK_SIZE,
  gl_MAX_SHADER_STORAGE_BUFFER_BINDINGS,
  gl_MAX_SUBROUTINES,
  gl_MAX_SUBROUTINE_UNIFORM_LOCATIONS,
  gl_MAX_TESS_CONTROL_ATOMIC_COUNTERS,
  gl_MAX_TESS_CONTROL_ATOMIC_COUNTER_BUFFERS,
  gl_MAX_TESS_CONTROL_IMAGE_UNIFORMS,
  gl_MAX_TESS_CONTROL_INPUT_COMPONENTS,
  gl_MAX_TESS_CONTROL_OUTPUT_COMPONENTS,
  gl_MAX_TESS_CONTROL_SHADER_STORAGE_BLOCKS,
  gl_MAX_TESS_CONTROL_TEXTURE_IMAGE_UNITS,
  gl_MAX_TESS_CONTROL_TOTAL_OUTPUT_COMPONENTS,
  gl_MAX_TESS_CONTROL_UNIFORM_BLOCKS,
  gl_MAX_TESS_CONTROL_UNIFORM_COMPONENTS,
  gl_MAX_TESS_EVALUATION_ATOMIC_COUNTERS,
  gl_MAX_TESS_EVALUATION_ATOMIC_COUNTER_BUFFERS,
  gl_MAX_TESS_EVALUATION_IMAGE_UNIFORMS,
  gl_MAX_TESS_EVALUATION_INPUT_COMPONENTS,
  gl_MAX_TESS_EVALUATION_OUTPUT_COMPONENTS,
  gl_MAX_TESS_EVALUATION_SHADER_STORAGE_BLOCKS,
  gl_MAX_TESS_EVALUATION_TEXTURE_IMAGE_UNITS,
  gl_MAX_TESS_EVALUATION_UNIFORM_BLOCKS,
  gl_MAX_TESS_EVALUATION_UNIFORM_COMPONENTS,
  gl_MAX_TESS_GEN_LEVEL,
  gl_MAX_TESS_PATCH_COMPONENTS,
  gl_MAX_TEXTURE_BUFFER_SIZE,
  gl_MAX_TEXTURE_COORDS,
  gl_MAX_TEXTURE_IMAGE_UNITS,
  gl_MAX_TEXTURE_LOD_BIAS,
  gl_MAX_TEXTURE_SIZE,
  gl_MAX_TEXTURE_STACK_DEPTH,
  gl_MAX_TEXTURE_UNITS,
  gl_MAX_TRANSFORM_FEEDBACK_BUFFERS,
  gl_MAX_TRANSFORM_FEEDBACK_INTERLEAVED_COMPONENTS,
  gl_MAX_TRANSFORM_FEEDBACK_SEPARATE_ATTRIBS,
  gl_MAX_TRANSFORM_FEEDBACK_SEPARATE_COMPONENTS,
  gl_MAX_UNIFORM_BLOCK_SIZE,
  gl_MAX_UNIFORM_BUFFER_BINDINGS,
  gl_MAX_UNIFORM_LOCATIONS,
  gl_MAX_VARYING_COMPONENTS,
  gl_MAX_VARYING_FLOATS,
  gl_MAX_VARYING_VECTORS,
  gl_MAX_VERTEX_ATOMIC_COUNTERS,
  gl_MAX_VERTEX_ATOMIC_COUNTER_BUFFERS,
  gl_MAX_VERTEX_ATTRIBS,
  gl_MAX_VERTEX_ATTRIB_BINDINGS,
  gl_MAX_VERTEX_ATTRIB_RELATIVE_OFFSET,
  gl_MAX_VERTEX_ATTRIB_STRIDE,
  gl_MAX_VERTEX_IMAGE_UNIFORMS,
  gl_MAX_VERTEX_OUTPUT_COMPONENTS,
  gl_MAX_VERTEX_SHADER_STORAGE_BLOCKS,
  gl_MAX_VERTEX_STREAMS,
  gl_MAX_VERTEX_TEXTURE_IMAGE_UNITS,
  gl_MAX_VERTEX_UNIFORM_BLOCKS,
  gl_MAX_VERTEX_UNIFORM_COMPONENTS,
  gl_MAX_VERTEX_UNIFORM_VECTORS,
  gl_MAX_VIEWPORTS,
  gl_MAX_VIEWPORT_DIMS,
  gl_MAX_WIDTH,
  gl_MEDIUM_FLOAT,
  gl_MEDIUM_INT,
  gl_MIN,
  gl_MINOR_VERSION,
  gl_MIN_FRAGMENT_INTERPOLATION_OFFSET,
  gl_MIN_MAP_BUFFER_ALIGNMENT,
  gl_MIN_PROGRAM_TEXEL_OFFSET,
  gl_MIN_PROGRAM_TEXTURE_GATHER_OFFSET,
  gl_MIN_SAMPLE_SHADING_VALUE,
  gl_MIPMAP,
  gl_MIRRORED_REPEAT,
  gl_MIRROR_CLAMP_TO_EDGE,
  gl_MODELVIEW,
  gl_MODELVIEW_MATRIX,
  gl_MODELVIEW_STACK_DEPTH,
  gl_MODULATE,
  gl_MULT,
  gl_MULTISAMPLE,
  gl_MULTISAMPLE_BIT,
  gl_N3F_V3F,
  gl_NAME_LENGTH,
  gl_NAME_STACK_DEPTH,
  gl_NAND,
  gl_NEAREST,
  gl_NEAREST_MIPMAP_LINEAR,
  gl_NEAREST_MIPMAP_NEAREST,
  gl_NEGATIVE_ONE_TO_ONE,
  gl_NEVER,
  gl_NICEST,
  gl_NONE,
  gl_NOOP,
  gl_NOR,
  gl_NORMALIZE,
  gl_NORMAL_ARRAY,
  gl_NORMAL_ARRAY_BUFFER_BINDING,
  gl_NORMAL_ARRAY_POINTER,
  gl_NORMAL_ARRAY_STRIDE,
  gl_NORMAL_ARRAY_TYPE,
  gl_NORMAL_MAP,
  gl_NOTEQUAL,
  gl_NO_ERROR,
  gl_NO_RESET_NOTIFICATION,
  gl_NUM_ACTIVE_VARIABLES,
  gl_NUM_COMPATIBLE_SUBROUTINES,
  gl_NUM_COMPRESSED_TEXTURE_FORMATS,
  gl_NUM_EXTENSIONS,
  gl_NUM_PROGRAM_BINARY_FORMATS,
  gl_NUM_SAMPLE_COUNTS,
  gl_NUM_SHADER_BINARY_FORMATS,
  gl_NUM_SHADING_LANGUAGE_VERSIONS,
  gl_OBJECT_LINEAR,
  gl_OBJECT_PLANE,
  gl_OBJECT_TYPE,
  gl_OFFSET,
  gl_ONE,
  gl_ONE_MINUS_CONSTANT_ALPHA,
  gl_ONE_MINUS_CONSTANT_COLOR,
  gl_ONE_MINUS_DST_ALPHA,
  gl_ONE_MINUS_DST_COLOR,
  gl_ONE_MINUS_SRC1_ALPHA,
  gl_ONE_MINUS_SRC1_COLOR,
  gl_ONE_MINUS_SRC_ALPHA,
  gl_ONE_MINUS_SRC_COLOR,
  gl_OPERAND0_ALPHA,
  gl_OPERAND0_RGB,
  gl_OPERAND1_ALPHA,
  gl_OPERAND1_RGB,
  gl_OPERAND2_ALPHA,
  gl_OPERAND2_RGB,
  gl_OR,
  gl_ORDER,
  gl_OR_INVERTED,
  gl_OR_REVERSE,
  gl_OUT_OF_MEMORY,
  gl_PACK_ALIGNMENT,
  gl_PACK_COMPRESSED_BLOCK_DEPTH,
  gl_PACK_COMPRESSED_BLOCK_HEIGHT,
  gl_PACK_COMPRESSED_BLOCK_SIZE,
  gl_PACK_COMPRESSED_BLOCK_WIDTH,
  gl_PACK_IMAGE_HEIGHT,
  gl_PACK_LSB_FIRST,
  gl_PACK_ROW_LENGTH,
  gl_PACK_SKIP_IMAGES,
  gl_PACK_SKIP_PIXELS,
  gl_PACK_SKIP_ROWS,
  gl_PACK_SWAP_BYTES,
  gl_PASS_THROUGH_TOKEN,
  gl_PATCHES,
  gl_PATCH_DEFAULT_INNER_LEVEL,
  gl_PATCH_DEFAULT_OUTER_LEVEL,
  gl_PATCH_VERTICES,
  gl_PERSPECTIVE_CORRECTION_HINT,
  gl_PIXEL_BUFFER_BARRIER_BIT,
  gl_PIXEL_MAP_A_TO_A,
  gl_PIXEL_MAP_A_TO_A_SIZE,
  gl_PIXEL_MAP_B_TO_B,
  gl_PIXEL_MAP_B_TO_B_SIZE,
  gl_PIXEL_MAP_G_TO_G,
  gl_PIXEL_MAP_G_TO_G_SIZE,
  gl_PIXEL_MAP_I_TO_A,
  gl_PIXEL_MAP_I_TO_A_SIZE,
  gl_PIXEL_MAP_I_TO_B,
  gl_PIXEL_MAP_I_TO_B_SIZE,
  gl_PIXEL_MAP_I_TO_G,
  gl_PIXEL_MAP_I_TO_G_SIZE,
  gl_PIXEL_MAP_I_TO_I,
  gl_PIXEL_MAP_I_TO_I_SIZE,
  gl_PIXEL_MAP_I_TO_R,
  gl_PIXEL_MAP_I_TO_R_SIZE,
  gl_PIXEL_MAP_R_TO_R,
  gl_PIXEL_MAP_R_TO_R_SIZE,
  gl_PIXEL_MAP_S_TO_S,
  gl_PIXEL_MAP_S_TO_S_SIZE,
  gl_PIXEL_MODE_BIT,
  gl_PIXEL_PACK_BUFFER,
  gl_PIXEL_PACK_BUFFER_BINDING,
  gl_PIXEL_UNPACK_BUFFER,
  gl_PIXEL_UNPACK_BUFFER_BINDING,
  gl_POINT,
  gl_POINTS,
  gl_POINT_BIT,
  gl_POINT_DISTANCE_ATTENUATION,
  gl_POINT_FADE_THRESHOLD_SIZE,
  gl_POINT_SIZE,
  gl_POINT_SIZE_GRANULARITY,
  gl_POINT_SIZE_MAX,
  gl_POINT_SIZE_MIN,
  gl_POINT_SIZE_RANGE,
  gl_POINT_SMOOTH,
  gl_POINT_SMOOTH_HINT,
  gl_POINT_SPRITE,
  gl_POINT_SPRITE_COORD_ORIGIN,
  gl_POINT_TOKEN,
  gl_POLYGON,
  gl_POLYGON_BIT,
  gl_POLYGON_MODE,
  gl_POLYGON_OFFSET_FACTOR,
  gl_POLYGON_OFFSET_FILL,
  gl_POLYGON_OFFSET_LINE,
  gl_POLYGON_OFFSET_POINT,
  gl_POLYGON_OFFSET_UNITS,
  gl_POLYGON_SMOOTH,
  gl_POLYGON_SMOOTH_HINT,
  gl_POLYGON_STIPPLE,
  gl_POLYGON_STIPPLE_BIT,
  gl_POLYGON_TOKEN,
  gl_POSITION,
  gl_PREVIOUS,
  gl_PRIMARY_COLOR,
  gl_PRIMITIVES_GENERATED,
  gl_PRIMITIVE_RESTART,
  gl_PRIMITIVE_RESTART_FIXED_INDEX,
  gl_PRIMITIVE_RESTART_FOR_PATCHES_SUPPORTED,
  gl_PRIMITIVE_RESTART_INDEX,
  gl_PROGRAM,
  gl_PROGRAM_BINARY_FORMATS,
  gl_PROGRAM_BINARY_LENGTH,
  gl_PROGRAM_BINARY_RETRIEVABLE_HINT,
  gl_PROGRAM_INPUT,
  gl_PROGRAM_OUTPUT,
  gl_PROGRAM_PIPELINE,
  gl_PROGRAM_PIPELINE_BINDING,
  gl_PROGRAM_POINT_SIZE,
  gl_PROGRAM_SEPARABLE,
  gl_PROJECTION,
  gl_PROJECTION_MATRIX,
  gl_PROJECTION_STACK_DEPTH,
  gl_PROVOKING_VERTEX,
  gl_PROXY_TEXTURE_1D,
  gl_PROXY_TEXTURE_1D_ARRAY,
  gl_PROXY_TEXTURE_2D,
  gl_PROXY_TEXTURE_2D_ARRAY,
  gl_PROXY_TEXTURE_2D_MULTISAMPLE,
  gl_PROXY_TEXTURE_2D_MULTISAMPLE_ARRAY,
  gl_PROXY_TEXTURE_3D,
  gl_PROXY_TEXTURE_CUBE_MAP,
  gl_PROXY_TEXTURE_CUBE_MAP_ARRAY,
  gl_PROXY_TEXTURE_RECTANGLE,
  gl_Q,
  gl_QUADRATIC_ATTENUATION,
  gl_QUADS,
  gl_QUADS_FOLLOW_PROVOKING_VERTEX_CONVENTION,
  gl_QUAD_STRIP,
  gl_QUERY,
  gl_QUERY_BUFFER,
  gl_QUERY_BUFFER_BARRIER_BIT,
  gl_QUERY_BUFFER_BINDING,
  gl_QUERY_BY_REGION_NO_WAIT,
  gl_QUERY_BY_REGION_NO_WAIT_INVERTED,
  gl_QUERY_BY_REGION_WAIT,
  gl_QUERY_BY_REGION_WAIT_INVERTED,
  gl_QUERY_COUNTER_BITS,
  gl_QUERY_NO_WAIT,
  gl_QUERY_NO_WAIT_INVERTED,
  gl_QUERY_RESULT,
  gl_QUERY_RESULT_AVAILABLE,
  gl_QUERY_RESULT_NO_WAIT,
  gl_QUERY_TARGET,
  gl_QUERY_WAIT,
  gl_QUERY_WAIT_INVERTED,
  gl_R,
  gl_R11F_G11F_B10F,
  gl_R16,
  gl_R16F,
  gl_R16I,
  gl_R16UI,
  gl_R16_SNORM,
  gl_R32F,
  gl_R32I,
  gl_R32UI,
  gl_R3_G3_B2,
  gl_R8,
  gl_R8I,
  gl_R8UI,
  gl_R8_SNORM,
  gl_RASTERIZER_DISCARD,
  gl_READ_BUFFER,
  gl_READ_FRAMEBUFFER,
  gl_READ_FRAMEBUFFER_BINDING,
  gl_READ_ONLY,
  gl_READ_PIXELS,
  gl_READ_PIXELS_FORMAT,
  gl_READ_PIXELS_TYPE,
  gl_READ_WRITE,
  gl_RED,
  gl_RED_BIAS,
  gl_RED_BITS,
  gl_RED_INTEGER,
  gl_RED_SCALE,
  gl_REFERENCED_BY_COMPUTE_SHADER,
  gl_REFERENCED_BY_FRAGMENT_SHADER,
  gl_REFERENCED_BY_GEOMETRY_SHADER,
  gl_REFERENCED_BY_TESS_CONTROL_SHADER,
  gl_REFERENCED_BY_TESS_EVALUATION_SHADER,
  gl_REFERENCED_BY_VERTEX_SHADER,
  gl_REFLECTION_MAP,
  gl_RENDER,
  gl_RENDERBUFFER,
  gl_RENDERBUFFER_ALPHA_SIZE,
  gl_RENDERBUFFER_BINDING,
  gl_RENDERBUFFER_BLUE_SIZE,
  gl_RENDERBUFFER_DEPTH_SIZE,
  gl_RENDERBUFFER_GREEN_SIZE,
  gl_RENDERBUFFER_HEIGHT,
  gl_RENDERBUFFER_INTERNAL_FORMAT,
  gl_RENDERBUFFER_RED_SIZE,
  gl_RENDERBUFFER_SAMPLES,
  gl_RENDERBUFFER_STENCIL_SIZE,
  gl_RENDERBUFFER_WIDTH,
  gl_RENDERER,
  gl_RENDER_MODE,
  gl_REPEAT,
  gl_REPLACE,
  gl_RESCALE_NORMAL,
  gl_RESET_NOTIFICATION_STRATEGY,
  gl_RETURN,
  gl_RG,
  gl_RG16,
  gl_RG16F,
  gl_RG16I,
  gl_RG16UI,
  gl_RG16_SNORM,
  gl_RG32F,
  gl_RG32I,
  gl_RG32UI,
  gl_RG8,
  gl_RG8I,
  gl_RG8UI,
  gl_RG8_SNORM,
  gl_RGB,
  gl_RGB10,
  gl_RGB10_A2,
  gl_RGB10_A2UI,
  gl_RGB12,
  gl_RGB16,
  gl_RGB16F,
  gl_RGB16I,
  gl_RGB16UI,
  gl_RGB16_SNORM,
  gl_RGB32F,
  gl_RGB32I,
  gl_RGB32UI,
  gl_RGB4,
  gl_RGB5,
  gl_RGB565,
  gl_RGB5_A1,
  gl_RGB8,
  gl_RGB8I,
  gl_RGB8UI,
  gl_RGB8_SNORM,
  gl_RGB9_E5,
  gl_RGBA,
  gl_RGBA12,
  gl_RGBA16,
  gl_RGBA16F,
  gl_RGBA16I,
  gl_RGBA16UI,
  gl_RGBA16_SNORM,
  gl_RGBA2,
  gl_RGBA32F,
  gl_RGBA32I,
  gl_RGBA32UI,
  gl_RGBA4,
  gl_RGBA8,
  gl_RGBA8I,
  gl_RGBA8UI,
  gl_RGBA8_SNORM,
  gl_RGBA_INTEGER,
  gl_RGBA_MODE,
  gl_RGB_INTEGER,
  gl_RGB_SCALE,
  gl_RG_INTEGER,
  gl_RIGHT,
  gl_S,
  gl_SAMPLER,
  gl_SAMPLER_1D,
  gl_SAMPLER_1D_ARRAY,
  gl_SAMPLER_1D_ARRAY_SHADOW,
  gl_SAMPLER_1D_SHADOW,
  gl_SAMPLER_2D,
  gl_SAMPLER_2D_ARRAY,
  gl_SAMPLER_2D_ARRAY_SHADOW,
  gl_SAMPLER_2D_MULTISAMPLE,
  gl_SAMPLER_2D_MULTISAMPLE_ARRAY,
  gl_SAMPLER_2D_RECT,
  gl_SAMPLER_2D_RECT_SHADOW,
  gl_SAMPLER_2D_SHADOW,
  gl_SAMPLER_3D,
  gl_SAMPLER_BINDING,
  gl_SAMPLER_BUFFER,
  gl_SAMPLER_CUBE,
  gl_SAMPLER_CUBE_MAP_ARRAY,
  gl_SAMPLER_CUBE_MAP_ARRAY_SHADOW,
  gl_SAMPLER_CUBE_SHADOW,
  gl_SAMPLES,
  gl_SAMPLES_PASSED,
  gl_SAMPLE_ALPHA_TO_COVERAGE,
  gl_SAMPLE_ALPHA_TO_ONE,
  gl_SAMPLE_BUFFERS,
  gl_SAMPLE_COVERAGE,
  gl_SAMPLE_COVERAGE_INVERT,
  gl_SAMPLE_COVERAGE_VALUE,
  gl_SAMPLE_MASK,
  gl_SAMPLE_MASK_VALUE,
  gl_SAMPLE_POSITION,
  gl_SAMPLE_SHADING,
  gl_SCISSOR_BIT,
  gl_SCISSOR_BOX,
  gl_SCISSOR_TEST,
  gl_SECONDARY_COLOR_ARRAY,
  gl_SECONDARY_COLOR_ARRAY_BUFFER_BINDING,
  gl_SECONDARY_COLOR_ARRAY_POINTER,
  gl_SECONDARY_COLOR_ARRAY_SIZE,
  gl_SECONDARY_COLOR_ARRAY_STRIDE,
  gl_SECONDARY_COLOR_ARRAY_TYPE,
  gl_SELECT,
  gl_SELECTION_BUFFER_POINTER,
  gl_SELECTION_BUFFER_SIZE,
  gl_SEPARATE_ATTRIBS,
  gl_SEPARATE_SPECULAR_COLOR,
  gl_SET,
  gl_SHADER,
  gl_SHADER_BINARY_FORMATS,
  gl_SHADER_COMPILER,
  gl_SHADER_IMAGE_ACCESS_BARRIER_BIT,
  gl_SHADER_IMAGE_ATOMIC,
  gl_SHADER_IMAGE_LOAD,
  gl_SHADER_IMAGE_STORE,
  gl_SHADER_SOURCE_LENGTH,
  gl_SHADER_STORAGE_BARRIER_BIT,
  gl_SHADER_STORAGE_BLOCK,
  gl_SHADER_STORAGE_BUFFER,
  gl_SHADER_STORAGE_BUFFER_BINDING,
  gl_SHADER_STORAGE_BUFFER_OFFSET_ALIGNMENT,
  gl_SHADER_STORAGE_BUFFER_SIZE,
  gl_SHADER_STORAGE_BUFFER_START,
  gl_SHADER_TYPE,
  gl_SHADE_MODEL,
  gl_SHADING_LANGUAGE_VERSION,
  gl_SHININESS,
  gl_SHORT,
  gl_SIGNALED,
  gl_SIGNED_NORMALIZED,
  gl_SIMULTANEOUS_TEXTURE_AND_DEPTH_TEST,
  gl_SIMULTANEOUS_TEXTURE_AND_DEPTH_WRITE,
  gl_SIMULTANEOUS_TEXTURE_AND_STENCIL_TEST,
  gl_SIMULTANEOUS_TEXTURE_AND_STENCIL_WRITE,
  gl_SINGLE_COLOR,
  gl_SLUMINANCE,
  gl_SLUMINANCE8,
  gl_SLUMINANCE8_ALPHA8,
  gl_SLUMINANCE_ALPHA,
  gl_SMOOTH,
  gl_SMOOTH_LINE_WIDTH_GRANULARITY,
  gl_SMOOTH_LINE_WIDTH_RANGE,
  gl_SMOOTH_POINT_SIZE_GRANULARITY,
  gl_SMOOTH_POINT_SIZE_RANGE,
  gl_SOURCE0_ALPHA,
  gl_SOURCE0_RGB,
  gl_SOURCE1_ALPHA,
  gl_SOURCE1_RGB,
  gl_SOURCE2_ALPHA,
  gl_SOURCE2_RGB,
  gl_SPECULAR,
  gl_SPHERE_MAP,
  gl_SPOT_CUTOFF,
  gl_SPOT_DIRECTION,
  gl_SPOT_EXPONENT,
  gl_SRC0_ALPHA,
  gl_SRC0_RGB,
  gl_SRC1_ALPHA,
  gl_SRC1_COLOR,
  gl_SRC1_RGB,
  gl_SRC2_ALPHA,
  gl_SRC2_RGB,
  gl_SRC_ALPHA,
  gl_SRC_ALPHA_SATURATE,
  gl_SRC_COLOR,
  gl_SRGB,
  gl_SRGB8,
  gl_SRGB8_ALPHA8,
  gl_SRGB_ALPHA,
  gl_SRGB_READ,
  gl_SRGB_WRITE,
  gl_STACK_OVERFLOW,
  gl_STACK_UNDERFLOW,
  gl_STATIC_COPY,
  gl_STATIC_DRAW,
  gl_STATIC_READ,
  gl_STENCIL,
  gl_STENCIL_ATTACHMENT,
  gl_STENCIL_BACK_FAIL,
  gl_STENCIL_BACK_FUNC,
  gl_STENCIL_BACK_PASS_DEPTH_FAIL,
  gl_STENCIL_BACK_PASS_DEPTH_PASS,
  gl_STENCIL_BACK_REF,
  gl_STENCIL_BACK_VALUE_MASK,
  gl_STENCIL_BACK_WRITEMASK,
  gl_STENCIL_BITS,
  gl_STENCIL_BUFFER_BIT,
  gl_STENCIL_CLEAR_VALUE,
  gl_STENCIL_COMPONENTS,
  gl_STENCIL_FAIL,
  gl_STENCIL_FUNC,
  gl_STENCIL_INDEX,
  gl_STENCIL_INDEX1,
  gl_STENCIL_INDEX16,
  gl_STENCIL_INDEX4,
  gl_STENCIL_INDEX8,
  gl_STENCIL_PASS_DEPTH_FAIL,
  gl_STENCIL_PASS_DEPTH_PASS,
  gl_STENCIL_REF,
  gl_STENCIL_RENDERABLE,
  gl_STENCIL_TEST,
  gl_STENCIL_VALUE_MASK,
  gl_STENCIL_WRITEMASK,
  gl_STEREO,
  gl_STREAM_COPY,
  gl_STREAM_DRAW,
  gl_STREAM_READ,
  gl_SUBPIXEL_BITS,
  gl_SUBTRACT,
  gl_SYNC_CONDITION,
  gl_SYNC_FENCE,
  gl_SYNC_FLAGS,
  gl_SYNC_FLUSH_COMMANDS_BIT,
  gl_SYNC_GPU_COMMANDS_COMPLETE,
  gl_SYNC_STATUS,
  gl_T,
  gl_T2F_C3F_V3F,
  gl_T2F_C4F_N3F_V3F,
  gl_T2F_C4UB_V3F,
  gl_T2F_N3F_V3F,
  gl_T2F_V3F,
  gl_T4F_C4F_N3F_V4F,
  gl_T4F_V4F,
  gl_TESS_CONTROL_OUTPUT_VERTICES,
  gl_TESS_CONTROL_SHADER,
  gl_TESS_CONTROL_SHADER_BIT,
  gl_TESS_CONTROL_SUBROUTINE,
  gl_TESS_CONTROL_SUBROUTINE_UNIFORM,
  gl_TESS_CONTROL_TEXTURE,
  gl_TESS_EVALUATION_SHADER,
  gl_TESS_EVALUATION_SHADER_BIT,
  gl_TESS_EVALUATION_SUBROUTINE,
  gl_TESS_EVALUATION_SUBROUTINE_UNIFORM,
  gl_TESS_EVALUATION_TEXTURE,
  gl_TESS_GEN_MODE,
  gl_TESS_GEN_POINT_MODE,
  gl_TESS_GEN_SPACING,
  gl_TESS_GEN_VERTEX_ORDER,
  gl_TEXTURE,
  gl_TEXTURE0,
  gl_TEXTURE1,
  gl_TEXTURE10,
  gl_TEXTURE11,
  gl_TEXTURE12,
  gl_TEXTURE13,
  gl_TEXTURE14,
  gl_TEXTURE15,
  gl_TEXTURE16,
  gl_TEXTURE17,
  gl_TEXTURE18,
  gl_TEXTURE19,
  gl_TEXTURE2,
  gl_TEXTURE20,
  gl_TEXTURE21,
  gl_TEXTURE22,
  gl_TEXTURE23,
  gl_TEXTURE24,
  gl_TEXTURE25,
  gl_TEXTURE26,
  gl_TEXTURE27,
  gl_TEXTURE28,
  gl_TEXTURE29,
  gl_TEXTURE3,
  gl_TEXTURE30,
  gl_TEXTURE31,
  gl_TEXTURE4,
  gl_TEXTURE5,
  gl_TEXTURE6,
  gl_TEXTURE7,
  gl_TEXTURE8,
  gl_TEXTURE9,
  gl_TEXTURE_1D,
  gl_TEXTURE_1D_ARRAY,
  gl_TEXTURE_2D,
  gl_TEXTURE_2D_ARRAY,
  gl_TEXTURE_2D_MULTISAMPLE,
  gl_TEXTURE_2D_MULTISAMPLE_ARRAY,
  gl_TEXTURE_3D,
  gl_TEXTURE_ALPHA_SIZE,
  gl_TEXTURE_ALPHA_TYPE,
  gl_TEXTURE_BASE_LEVEL,
  gl_TEXTURE_BINDING_1D,
  gl_TEXTURE_BINDING_1D_ARRAY,
  gl_TEXTURE_BINDING_2D,
  gl_TEXTURE_BINDING_2D_ARRAY,
  gl_TEXTURE_BINDING_2D_MULTISAMPLE,
  gl_TEXTURE_BINDING_2D_MULTISAMPLE_ARRAY,
  gl_TEXTURE_BINDING_3D,
  gl_TEXTURE_BINDING_BUFFER,
  gl_TEXTURE_BINDING_CUBE_MAP,
  gl_TEXTURE_BINDING_CUBE_MAP_ARRAY,
  gl_TEXTURE_BINDING_RECTANGLE,
  gl_TEXTURE_BIT,
  gl_TEXTURE_BLUE_SIZE,
  gl_TEXTURE_BLUE_TYPE,
  gl_TEXTURE_BORDER,
  gl_TEXTURE_BORDER_COLOR,
  gl_TEXTURE_BUFFER,
  gl_TEXTURE_BUFFER_BINDING,
  gl_TEXTURE_BUFFER_DATA_STORE_BINDING,
  gl_TEXTURE_BUFFER_OFFSET,
  gl_TEXTURE_BUFFER_OFFSET_ALIGNMENT,
  gl_TEXTURE_BUFFER_SIZE,
  gl_TEXTURE_COMPARE_FUNC,
  gl_TEXTURE_COMPARE_MODE,
  gl_TEXTURE_COMPONENTS,
  gl_TEXTURE_COMPRESSED,
  gl_TEXTURE_COMPRESSED_BLOCK_HEIGHT,
  gl_TEXTURE_COMPRESSED_BLOCK_SIZE,
  gl_TEXTURE_COMPRESSED_BLOCK_WIDTH,
  gl_TEXTURE_COMPRESSED_IMAGE_SIZE,
  gl_TEXTURE_COMPRESSION_HINT,
  gl_TEXTURE_COORD_ARRAY,
  gl_TEXTURE_COORD_ARRAY_BUFFER_BINDING,
  gl_TEXTURE_COORD_ARRAY_POINTER,
  gl_TEXTURE_COORD_ARRAY_SIZE,
  gl_TEXTURE_COORD_ARRAY_STRIDE,
  gl_TEXTURE_COORD_ARRAY_TYPE,
  gl_TEXTURE_CUBE_MAP,
  gl_TEXTURE_CUBE_MAP_ARRAY,
  gl_TEXTURE_CUBE_MAP_NEGATIVE_X,
  gl_TEXTURE_CUBE_MAP_NEGATIVE_Y,
  gl_TEXTURE_CUBE_MAP_NEGATIVE_Z,
  gl_TEXTURE_CUBE_MAP_POSITIVE_X,
  gl_TEXTURE_CUBE_MAP_POSITIVE_Y,
  gl_TEXTURE_CUBE_MAP_POSITIVE_Z,
  gl_TEXTURE_CUBE_MAP_SEAMLESS,
  gl_TEXTURE_DEPTH,
  gl_TEXTURE_DEPTH_SIZE,
  gl_TEXTURE_DEPTH_TYPE,
  gl_TEXTURE_ENV,
  gl_TEXTURE_ENV_COLOR,
  gl_TEXTURE_ENV_MODE,
  gl_TEXTURE_FETCH_BARRIER_BIT,
  gl_TEXTURE_FILTER_CONTROL,
  gl_TEXTURE_FIXED_SAMPLE_LOCATIONS,
  gl_TEXTURE_GATHER,
  gl_TEXTURE_GATHER_SHADOW,
  gl_TEXTURE_GEN_MODE,
  gl_TEXTURE_GEN_Q,
  gl_TEXTURE_GEN_R,
  gl_TEXTURE_GEN_S,
  gl_TEXTURE_GEN_T,
  gl_TEXTURE_GREEN_SIZE,
  gl_TEXTURE_GREEN_TYPE,
  gl_TEXTURE_HEIGHT,
  gl_TEXTURE_IMAGE_FORMAT,
  gl_TEXTURE_IMAGE_TYPE,
  gl_TEXTURE_IMMUTABLE_FORMAT,
  gl_TEXTURE_IMMUTABLE_LEVELS,
  gl_TEXTURE_INTENSITY_SIZE,
  gl_TEXTURE_INTENSITY_TYPE,
  gl_TEXTURE_INTERNAL_FORMAT,
  gl_TEXTURE_LOD_BIAS,
  gl_TEXTURE_LUMINANCE_SIZE,
  gl_TEXTURE_LUMINANCE_TYPE,
  gl_TEXTURE_MAG_FILTER,
  gl_TEXTURE_MATRIX,
  gl_TEXTURE_MAX_LEVEL,
  gl_TEXTURE_MAX_LOD,
  gl_TEXTURE_MIN_FILTER,
  gl_TEXTURE_MIN_LOD,
  gl_TEXTURE_PRIORITY,
  gl_TEXTURE_RECTANGLE,
  gl_TEXTURE_RED_SIZE,
  gl_TEXTURE_RED_TYPE,
  gl_TEXTURE_RESIDENT,
  gl_TEXTURE_SAMPLES,
  gl_TEXTURE_SHADOW,
  gl_TEXTURE_SHARED_SIZE,
  gl_TEXTURE_STACK_DEPTH,
  gl_TEXTURE_STENCIL_SIZE,
  gl_TEXTURE_SWIZZLE_A,
  gl_TEXTURE_SWIZZLE_B,
  gl_TEXTURE_SWIZZLE_G,
  gl_TEXTURE_SWIZZLE_R,
  gl_TEXTURE_SWIZZLE_RGBA,
  gl_TEXTURE_TARGET,
  gl_TEXTURE_UPDATE_BARRIER_BIT,
  gl_TEXTURE_VIEW,
  gl_TEXTURE_VIEW_MIN_LAYER,
  gl_TEXTURE_VIEW_MIN_LEVEL,
  gl_TEXTURE_VIEW_NUM_LAYERS,
  gl_TEXTURE_VIEW_NUM_LEVELS,
  gl_TEXTURE_WIDTH,
  gl_TEXTURE_WRAP_R,
  gl_TEXTURE_WRAP_S,
  gl_TEXTURE_WRAP_T,
  gl_TIMEOUT_EXPIRED,
  gl_TIMEOUT_IGNORED,
  gl_TIMESTAMP,
  gl_TIME_ELAPSED,
  gl_TOP_LEVEL_ARRAY_SIZE,
  gl_TOP_LEVEL_ARRAY_STRIDE,
  gl_TRANSFORM_BIT,
  gl_TRANSFORM_FEEDBACK,
  gl_TRANSFORM_FEEDBACK_ACTIVE,
  gl_TRANSFORM_FEEDBACK_BARRIER_BIT,
  gl_TRANSFORM_FEEDBACK_BINDING,
  gl_TRANSFORM_FEEDBACK_BUFFER,
  gl_TRANSFORM_FEEDBACK_BUFFER_ACTIVE,
  gl_TRANSFORM_FEEDBACK_BUFFER_BINDING,
  gl_TRANSFORM_FEEDBACK_BUFFER_INDEX,
  gl_TRANSFORM_FEEDBACK_BUFFER_MODE,
  gl_TRANSFORM_FEEDBACK_BUFFER_PAUSED,
  gl_TRANSFORM_FEEDBACK_BUFFER_SIZE,
  gl_TRANSFORM_FEEDBACK_BUFFER_START,
  gl_TRANSFORM_FEEDBACK_BUFFER_STRIDE,
  gl_TRANSFORM_FEEDBACK_PAUSED,
  gl_TRANSFORM_FEEDBACK_PRIMITIVES_WRITTEN,
  gl_TRANSFORM_FEEDBACK_VARYING,
  gl_TRANSFORM_FEEDBACK_VARYINGS,
  gl_TRANSFORM_FEEDBACK_VARYING_MAX_LENGTH,
  gl_TRANSPOSE_COLOR_MATRIX,
  gl_TRANSPOSE_MODELVIEW_MATRIX,
  gl_TRANSPOSE_PROJECTION_MATRIX,
  gl_TRANSPOSE_TEXTURE_MATRIX,
  gl_TRIANGLES,
  gl_TRIANGLES_ADJACENCY,
  gl_TRIANGLE_FAN,
  gl_TRIANGLE_STRIP,
  gl_TRIANGLE_STRIP_ADJACENCY,
  gl_TRUE,
  gl_TYPE,
  gl_UNDEFINED_VERTEX,
  gl_UNIFORM,
  gl_UNIFORM_ARRAY_STRIDE,
  gl_UNIFORM_ATOMIC_COUNTER_BUFFER_INDEX,
  gl_UNIFORM_BARRIER_BIT,
  gl_UNIFORM_BLOCK,
  gl_UNIFORM_BLOCK_ACTIVE_UNIFORMS,
  gl_UNIFORM_BLOCK_ACTIVE_UNIFORM_INDICES,
  gl_UNIFORM_BLOCK_BINDING,
  gl_UNIFORM_BLOCK_DATA_SIZE,
  gl_UNIFORM_BLOCK_INDEX,
  gl_UNIFORM_BLOCK_NAME_LENGTH,
  gl_UNIFORM_BLOCK_REFERENCED_BY_COMPUTE_SHADER,
  gl_UNIFORM_BLOCK_REFERENCED_BY_FRAGMENT_SHADER,
  gl_UNIFORM_BLOCK_REFERENCED_BY_GEOMETRY_SHADER,
  gl_UNIFORM_BLOCK_REFERENCED_BY_TESS_CONTROL_SHADER,
  gl_UNIFORM_BLOCK_REFERENCED_BY_TESS_EVALUATION_SHADER,
  gl_UNIFORM_BLOCK_REFERENCED_BY_VERTEX_SHADER,
  gl_UNIFORM_BUFFER,
  gl_UNIFORM_BUFFER_BINDING,
  gl_UNIFORM_BUFFER_OFFSET_ALIGNMENT,
  gl_UNIFORM_BUFFER_SIZE,
  gl_UNIFORM_BUFFER_START,
  gl_UNIFORM_IS_ROW_MAJOR,
  gl_UNIFORM_MATRIX_STRIDE,
  gl_UNIFORM_NAME_LENGTH,
  gl_UNIFORM_OFFSET,
  gl_UNIFORM_SIZE,
  gl_UNIFORM_TYPE,
  gl_UNKNOWN_CONTEXT_RESET,
  gl_UNPACK_ALIGNMENT,
  gl_UNPACK_COMPRESSED_BLOCK_DEPTH,
  gl_UNPACK_COMPRESSED_BLOCK_HEIGHT,
  gl_UNPACK_COMPRESSED_BLOCK_SIZE,
  gl_UNPACK_COMPRESSED_BLOCK_WIDTH,
  gl_UNPACK_IMAGE_HEIGHT,
  gl_UNPACK_LSB_FIRST,
  gl_UNPACK_ROW_LENGTH,
  gl_UNPACK_SKIP_IMAGES,
  gl_UNPACK_SKIP_PIXELS,
  gl_UNPACK_SKIP_ROWS,
  gl_UNPACK_SWAP_BYTES,
  gl_UNSIGNALED,
  gl_UNSIGNED_BYTE,
  gl_UNSIGNED_BYTE_2_3_3_REV,
  gl_UNSIGNED_BYTE_3_3_2,
  gl_UNSIGNED_INT,
  gl_UNSIGNED_INT_10F_11F_11F_REV,
  gl_UNSIGNED_INT_10_10_10_2,
  gl_UNSIGNED_INT_24_8,
  gl_UNSIGNED_INT_2_10_10_10_REV,
  gl_UNSIGNED_INT_5_9_9_9_REV,
  gl_UNSIGNED_INT_8_8_8_8,
  gl_UNSIGNED_INT_8_8_8_8_REV,
  gl_UNSIGNED_INT_ATOMIC_COUNTER,
  gl_UNSIGNED_INT_IMAGE_1D,
  gl_UNSIGNED_INT_IMAGE_1D_ARRAY,
  gl_UNSIGNED_INT_IMAGE_2D,
  gl_UNSIGNED_INT_IMAGE_2D_ARRAY,
  gl_UNSIGNED_INT_IMAGE_2D_MULTISAMPLE,
  gl_UNSIGNED_INT_IMAGE_2D_MULTISAMPLE_ARRAY,
  gl_UNSIGNED_INT_IMAGE_2D_RECT,
  gl_UNSIGNED_INT_IMAGE_3D,
  gl_UNSIGNED_INT_IMAGE_BUFFER,
  gl_UNSIGNED_INT_IMAGE_CUBE,
  gl_UNSIGNED_INT_IMAGE_CUBE_MAP_ARRAY,
  gl_UNSIGNED_INT_SAMPLER_1D,
  gl_UNSIGNED_INT_SAMPLER_1D_ARRAY,
  gl_UNSIGNED_INT_SAMPLER_2D,
  gl_UNSIGNED_INT_SAMPLER_2D_ARRAY,
  gl_UNSIGNED_INT_SAMPLER_2D_MULTISAMPLE,
  gl_UNSIGNED_INT_SAMPLER_2D_MULTISAMPLE_ARRAY,
  gl_UNSIGNED_INT_SAMPLER_2D_RECT,
  gl_UNSIGNED_INT_SAMPLER_3D,
  gl_UNSIGNED_INT_SAMPLER_BUFFER,
  gl_UNSIGNED_INT_SAMPLER_CUBE,
  gl_UNSIGNED_INT_SAMPLER_CUBE_MAP_ARRAY,
  gl_UNSIGNED_INT_VEC2,
  gl_UNSIGNED_INT_VEC3,
  gl_UNSIGNED_INT_VEC4,
  gl_UNSIGNED_NORMALIZED,
  gl_UNSIGNED_SHORT,
  gl_UNSIGNED_SHORT_1_5_5_5_REV,
  gl_UNSIGNED_SHORT_4_4_4_4,
  gl_UNSIGNED_SHORT_4_4_4_4_REV,
  gl_UNSIGNED_SHORT_5_5_5_1,
  gl_UNSIGNED_SHORT_5_6_5,
  gl_UNSIGNED_SHORT_5_6_5_REV,
  gl_UPPER_LEFT,
  gl_V2F,
  gl_V3F,
  gl_VALIDATE_STATUS,
  gl_VENDOR,
  gl_VERSION,
  gl_VERTEX_ARRAY,
  gl_VERTEX_ARRAY_BINDING,
  gl_VERTEX_ARRAY_BUFFER_BINDING,
  gl_VERTEX_ARRAY_POINTER,
  gl_VERTEX_ARRAY_SIZE,
  gl_VERTEX_ARRAY_STRIDE,
  gl_VERTEX_ARRAY_TYPE,
  gl_VERTEX_ATTRIB_ARRAY_BARRIER_BIT,
  gl_VERTEX_ATTRIB_ARRAY_BUFFER_BINDING,
  gl_VERTEX_ATTRIB_ARRAY_DIVISOR,
  gl_VERTEX_ATTRIB_ARRAY_ENABLED,
  gl_VERTEX_ATTRIB_ARRAY_INTEGER,
  gl_VERTEX_ATTRIB_ARRAY_LONG,
  gl_VERTEX_ATTRIB_ARRAY_NORMALIZED,
  gl_VERTEX_ATTRIB_ARRAY_POINTER,
  gl_VERTEX_ATTRIB_ARRAY_SIZE,
  gl_VERTEX_ATTRIB_ARRAY_STRIDE,
  gl_VERTEX_ATTRIB_ARRAY_TYPE,
  gl_VERTEX_ATTRIB_BINDING,
  gl_VERTEX_ATTRIB_RELATIVE_OFFSET,
  gl_VERTEX_BINDING_BUFFER,
  gl_VERTEX_BINDING_DIVISOR,
  gl_VERTEX_BINDING_OFFSET,
  gl_VERTEX_BINDING_STRIDE,
  gl_VERTEX_PROGRAM_POINT_SIZE,
  gl_VERTEX_PROGRAM_TWO_SIDE,
  gl_VERTEX_SHADER,
  gl_VERTEX_SHADER_BIT,
  gl_VERTEX_SUBROUTINE,
  gl_VERTEX_SUBROUTINE_UNIFORM,
  gl_VERTEX_TEXTURE,
  gl_VIEWPORT,
  gl_VIEWPORT_BIT,
  gl_VIEWPORT_BOUNDS_RANGE,
  gl_VIEWPORT_INDEX_PROVOKING_VERTEX,
  gl_VIEWPORT_SUBPIXEL_BITS,
  gl_VIEW_CLASS_128_BITS,
  gl_VIEW_CLASS_16_BITS,
  gl_VIEW_CLASS_24_BITS,
  gl_VIEW_CLASS_32_BITS,
  gl_VIEW_CLASS_48_BITS,
  gl_VIEW_CLASS_64_BITS,
  gl_VIEW_CLASS_8_BITS,
  gl_VIEW_CLASS_96_BITS,
  gl_VIEW_CLASS_BPTC_FLOAT,
  gl_VIEW_CLASS_BPTC_UNORM,
  gl_VIEW_CLASS_RGTC1_RED,
  gl_VIEW_CLASS_RGTC2_RG,
  gl_VIEW_CLASS_S3TC_DXT1_RGB,
  gl_VIEW_CLASS_S3TC_DXT1_RGBA,
  gl_VIEW_CLASS_S3TC_DXT3_RGBA,
  gl_VIEW_CLASS_S3TC_DXT5_RGBA,
  gl_VIEW_COMPATIBILITY_CLASS,
  gl_WAIT_FAILED,
  gl_WEIGHT_ARRAY_BUFFER_BINDING,
  gl_WRITE_ONLY,
  gl_XOR,
  gl_ZERO,
  gl_ZERO_TO_ONE,
  gl_ZOOM_X,
  gl_ZOOM_Y,
  -- * Functions
  glAccum,
  glActiveShaderProgram,
  glActiveTexture,
  glAlphaFunc,
  glAreTexturesResident,
  glArrayElement,
  glAttachShader,
  glBegin,
  glBeginConditionalRender,
  glBeginQuery,
  glBeginQueryIndexed,
  glBeginTransformFeedback,
  glBindAttribLocation,
  glBindBuffer,
  glBindBufferBase,
  glBindBufferRange,
  glBindBuffersBase,
  glBindBuffersRange,
  glBindFragDataLocation,
  glBindFragDataLocationIndexed,
  glBindFramebuffer,
  glBindImageTexture,
  glBindImageTextures,
  glBindProgramPipeline,
  glBindRenderbuffer,
  glBindSampler,
  glBindSamplers,
  glBindTexture,
  glBindTextureUnit,
  glBindTextures,
  glBindTransformFeedback,
  glBindVertexArray,
  glBindVertexBuffer,
  glBindVertexBuffers,
  glBitmap,
  glBlendColor,
  glBlendEquation,
  glBlendEquationSeparate,
  glBlendEquationSeparatei,
  glBlendEquationi,
  glBlendFunc,
  glBlendFuncSeparate,
  glBlendFuncSeparatei,
  glBlendFunci,
  glBlitFramebuffer,
  glBlitNamedFramebuffer,
  glBufferData,
  glBufferStorage,
  glBufferSubData,
  glCallList,
  glCallLists,
  glCheckFramebufferStatus,
  glCheckNamedFramebufferStatus,
  glClampColor,
  glClear,
  glClearAccum,
  glClearBufferData,
  glClearBufferSubData,
  glClearBufferfi,
  glClearBufferfv,
  glClearBufferiv,
  glClearBufferuiv,
  glClearColor,
  glClearDepth,
  glClearDepthf,
  glClearIndex,
  glClearNamedBufferData,
  glClearNamedBufferSubData,
  glClearNamedFramebufferfi,
  glClearNamedFramebufferfv,
  glClearNamedFramebufferiv,
  glClearNamedFramebufferuiv,
  glClearStencil,
  glClearTexImage,
  glClearTexSubImage,
  glClientActiveTexture,
  glClientWaitSync,
  glClipControl,
  glClipPlane,
  glColor3b,
  glColor3bv,
  glColor3d,
  glColor3dv,
  glColor3f,
  glColor3fv,
  glColor3i,
  glColor3iv,
  glColor3s,
  glColor3sv,
  glColor3ub,
  glColor3ubv,
  glColor3ui,
  glColor3uiv,
  glColor3us,
  glColor3usv,
  glColor4b,
  glColor4bv,
  glColor4d,
  glColor4dv,
  glColor4f,
  glColor4fv,
  glColor4i,
  glColor4iv,
  glColor4s,
  glColor4sv,
  glColor4ub,
  glColor4ubv,
  glColor4ui,
  glColor4uiv,
  glColor4us,
  glColor4usv,
  glColorMask,
  glColorMaski,
  glColorMaterial,
  glColorP3ui,
  glColorP3uiv,
  glColorP4ui,
  glColorP4uiv,
  glColorPointer,
  glCompileShader,
  glCompressedTexImage1D,
  glCompressedTexImage2D,
  glCompressedTexImage3D,
  glCompressedTexSubImage1D,
  glCompressedTexSubImage2D,
  glCompressedTexSubImage3D,
  glCompressedTextureSubImage1D,
  glCompressedTextureSubImage2D,
  glCompressedTextureSubImage3D,
  glCopyBufferSubData,
  glCopyImageSubData,
  glCopyNamedBufferSubData,
  glCopyPixels,
  glCopyTexImage1D,
  glCopyTexImage2D,
  glCopyTexSubImage1D,
  glCopyTexSubImage2D,
  glCopyTexSubImage3D,
  glCopyTextureSubImage1D,
  glCopyTextureSubImage2D,
  glCopyTextureSubImage3D,
  glCreateBuffers,
  glCreateFramebuffers,
  glCreateProgram,
  glCreateProgramPipelines,
  glCreateQueries,
  glCreateRenderbuffers,
  glCreateSamplers,
  glCreateShader,
  glCreateShaderProgramv,
  glCreateTextures,
  glCreateTransformFeedbacks,
  glCreateVertexArrays,
  glCullFace,
  glDebugMessageCallback,
  glDebugMessageControl,
  glDebugMessageInsert,
  glDeleteBuffers,
  glDeleteFramebuffers,
  glDeleteLists,
  glDeleteProgram,
  glDeleteProgramPipelines,
  glDeleteQueries,
  glDeleteRenderbuffers,
  glDeleteSamplers,
  glDeleteShader,
  glDeleteSync,
  glDeleteTextures,
  glDeleteTransformFeedbacks,
  glDeleteVertexArrays,
  glDepthFunc,
  glDepthMask,
  glDepthRange,
  glDepthRangeArrayv,
  glDepthRangeIndexed,
  glDepthRangef,
  glDetachShader,
  glDisable,
  glDisableClientState,
  glDisableVertexArrayAttrib,
  glDisableVertexAttribArray,
  glDisablei,
  glDispatchCompute,
  glDispatchComputeIndirect,
  glDrawArrays,
  glDrawArraysIndirect,
  glDrawArraysInstanced,
  glDrawArraysInstancedBaseInstance,
  glDrawBuffer,
  glDrawBuffers,
  glDrawElements,
  glDrawElementsBaseVertex,
  glDrawElementsIndirect,
  glDrawElementsInstanced,
  glDrawElementsInstancedBaseInstance,
  glDrawElementsInstancedBaseVertex,
  glDrawElementsInstancedBaseVertexBaseInstance,
  glDrawPixels,
  glDrawRangeElements,
  glDrawRangeElementsBaseVertex,
  glDrawTransformFeedback,
  glDrawTransformFeedbackInstanced,
  glDrawTransformFeedbackStream,
  glDrawTransformFeedbackStreamInstanced,
  glEdgeFlag,
  glEdgeFlagPointer,
  glEdgeFlagv,
  glEnable,
  glEnableClientState,
  glEnableVertexArrayAttrib,
  glEnableVertexAttribArray,
  glEnablei,
  glEnd,
  glEndConditionalRender,
  glEndList,
  glEndQuery,
  glEndQueryIndexed,
  glEndTransformFeedback,
  glEvalCoord1d,
  glEvalCoord1dv,
  glEvalCoord1f,
  glEvalCoord1fv,
  glEvalCoord2d,
  glEvalCoord2dv,
  glEvalCoord2f,
  glEvalCoord2fv,
  glEvalMesh1,
  glEvalMesh2,
  glEvalPoint1,
  glEvalPoint2,
  glFeedbackBuffer,
  glFenceSync,
  glFinish,
  glFlush,
  glFlushMappedBufferRange,
  glFlushMappedNamedBufferRange,
  glFogCoordPointer,
  glFogCoordd,
  glFogCoorddv,
  glFogCoordf,
  glFogCoordfv,
  glFogf,
  glFogfv,
  glFogi,
  glFogiv,
  glFramebufferParameteri,
  glFramebufferRenderbuffer,
  glFramebufferTexture,
  glFramebufferTexture1D,
  glFramebufferTexture2D,
  glFramebufferTexture3D,
  glFramebufferTextureLayer,
  glFrontFace,
  glFrustum,
  glGenBuffers,
  glGenFramebuffers,
  glGenLists,
  glGenProgramPipelines,
  glGenQueries,
  glGenRenderbuffers,
  glGenSamplers,
  glGenTextures,
  glGenTransformFeedbacks,
  glGenVertexArrays,
  glGenerateMipmap,
  glGenerateTextureMipmap,
  glGetActiveAtomicCounterBufferiv,
  glGetActiveAttrib,
  glGetActiveSubroutineName,
  glGetActiveSubroutineUniformName,
  glGetActiveSubroutineUniformiv,
  glGetActiveUniform,
  glGetActiveUniformBlockName,
  glGetActiveUniformBlockiv,
  glGetActiveUniformName,
  glGetActiveUniformsiv,
  glGetAttachedShaders,
  glGetAttribLocation,
  glGetBooleani_v,
  glGetBooleanv,
  glGetBufferParameteri64v,
  glGetBufferParameteriv,
  glGetBufferPointerv,
  glGetBufferSubData,
  glGetClipPlane,
  glGetCompressedTexImage,
  glGetCompressedTextureImage,
  glGetCompressedTextureSubImage,
  glGetDebugMessageLog,
  glGetDoublei_v,
  glGetDoublev,
  glGetError,
  glGetFloati_v,
  glGetFloatv,
  glGetFragDataIndex,
  glGetFragDataLocation,
  glGetFramebufferAttachmentParameteriv,
  glGetFramebufferParameteriv,
  glGetGraphicsResetStatus,
  glGetInteger64i_v,
  glGetInteger64v,
  glGetIntegeri_v,
  glGetIntegerv,
  glGetInternalformati64v,
  glGetInternalformativ,
  glGetLightfv,
  glGetLightiv,
  glGetMapdv,
  glGetMapfv,
  glGetMapiv,
  glGetMaterialfv,
  glGetMaterialiv,
  glGetMultisamplefv,
  glGetNamedBufferParameteri64v,
  glGetNamedBufferParameteriv,
  glGetNamedBufferPointerv,
  glGetNamedBufferSubData,
  glGetNamedFramebufferAttachmentParameteriv,
  glGetNamedFramebufferParameteriv,
  glGetNamedRenderbufferParameteriv,
  glGetObjectLabel,
  glGetObjectPtrLabel,
  glGetPixelMapfv,
  glGetPixelMapuiv,
  glGetPixelMapusv,
  glGetPointerv,
  glGetPolygonStipple,
  glGetProgramBinary,
  glGetProgramInfoLog,
  glGetProgramInterfaceiv,
  glGetProgramPipelineInfoLog,
  glGetProgramPipelineiv,
  glGetProgramResourceIndex,
  glGetProgramResourceLocation,
  glGetProgramResourceLocationIndex,
  glGetProgramResourceName,
  glGetProgramResourceiv,
  glGetProgramStageiv,
  glGetProgramiv,
  glGetQueryBufferObjecti64v,
  glGetQueryBufferObjectiv,
  glGetQueryBufferObjectui64v,
  glGetQueryBufferObjectuiv,
  glGetQueryIndexediv,
  glGetQueryObjecti64v,
  glGetQueryObjectiv,
  glGetQueryObjectui64v,
  glGetQueryObjectuiv,
  glGetQueryiv,
  glGetRenderbufferParameteriv,
  glGetSamplerParameterIiv,
  glGetSamplerParameterIuiv,
  glGetSamplerParameterfv,
  glGetSamplerParameteriv,
  glGetShaderInfoLog,
  glGetShaderPrecisionFormat,
  glGetShaderSource,
  glGetShaderiv,
  glGetString,
  glGetStringi,
  glGetSubroutineIndex,
  glGetSubroutineUniformLocation,
  glGetSynciv,
  glGetTexEnvfv,
  glGetTexEnviv,
  glGetTexGendv,
  glGetTexGenfv,
  glGetTexGeniv,
  glGetTexImage,
  glGetTexLevelParameterfv,
  glGetTexLevelParameteriv,
  glGetTexParameterIiv,
  glGetTexParameterIuiv,
  glGetTexParameterfv,
  glGetTexParameteriv,
  glGetTextureImage,
  glGetTextureLevelParameterfv,
  glGetTextureLevelParameteriv,
  glGetTextureParameterIiv,
  glGetTextureParameterIuiv,
  glGetTextureParameterfv,
  glGetTextureParameteriv,
  glGetTextureSubImage,
  glGetTransformFeedbackVarying,
  glGetTransformFeedbacki64_v,
  glGetTransformFeedbacki_v,
  glGetTransformFeedbackiv,
  glGetUniformBlockIndex,
  glGetUniformIndices,
  glGetUniformLocation,
  glGetUniformSubroutineuiv,
  glGetUniformdv,
  glGetUniformfv,
  glGetUniformiv,
  glGetUniformuiv,
  glGetVertexArrayIndexed64iv,
  glGetVertexArrayIndexediv,
  glGetVertexArrayiv,
  glGetVertexAttribIiv,
  glGetVertexAttribIuiv,
  glGetVertexAttribLdv,
  glGetVertexAttribPointerv,
  glGetVertexAttribdv,
  glGetVertexAttribfv,
  glGetVertexAttribiv,
  glGetnColorTable,
  glGetnCompressedTexImage,
  glGetnConvolutionFilter,
  glGetnHistogram,
  glGetnMapdv,
  glGetnMapfv,
  glGetnMapiv,
  glGetnMinmax,
  glGetnPixelMapfv,
  glGetnPixelMapuiv,
  glGetnPixelMapusv,
  glGetnPolygonStipple,
  glGetnSeparableFilter,
  glGetnTexImage,
  glGetnUniformdv,
  glGetnUniformfv,
  glGetnUniformiv,
  glGetnUniformuiv,
  glHint,
  glIndexMask,
  glIndexPointer,
  glIndexd,
  glIndexdv,
  glIndexf,
  glIndexfv,
  glIndexi,
  glIndexiv,
  glIndexs,
  glIndexsv,
  glIndexub,
  glIndexubv,
  glInitNames,
  glInterleavedArrays,
  glInvalidateBufferData,
  glInvalidateBufferSubData,
  glInvalidateFramebuffer,
  glInvalidateNamedFramebufferData,
  glInvalidateNamedFramebufferSubData,
  glInvalidateSubFramebuffer,
  glInvalidateTexImage,
  glInvalidateTexSubImage,
  glIsBuffer,
  glIsEnabled,
  glIsEnabledi,
  glIsFramebuffer,
  glIsList,
  glIsProgram,
  glIsProgramPipeline,
  glIsQuery,
  glIsRenderbuffer,
  glIsSampler,
  glIsShader,
  glIsSync,
  glIsTexture,
  glIsTransformFeedback,
  glIsVertexArray,
  glLightModelf,
  glLightModelfv,
  glLightModeli,
  glLightModeliv,
  glLightf,
  glLightfv,
  glLighti,
  glLightiv,
  glLineStipple,
  glLineWidth,
  glLinkProgram,
  glListBase,
  glLoadIdentity,
  glLoadMatrixd,
  glLoadMatrixf,
  glLoadName,
  glLoadTransposeMatrixd,
  glLoadTransposeMatrixf,
  glLogicOp,
  glMap1d,
  glMap1f,
  glMap2d,
  glMap2f,
  glMapBuffer,
  glMapBufferRange,
  glMapGrid1d,
  glMapGrid1f,
  glMapGrid2d,
  glMapGrid2f,
  glMapNamedBuffer,
  glMapNamedBufferRange,
  glMaterialf,
  glMaterialfv,
  glMateriali,
  glMaterialiv,
  glMatrixMode,
  glMemoryBarrier,
  glMemoryBarrierByRegion,
  glMinSampleShading,
  glMultMatrixd,
  glMultMatrixf,
  glMultTransposeMatrixd,
  glMultTransposeMatrixf,
  glMultiDrawArrays,
  glMultiDrawArraysIndirect,
  glMultiDrawElements,
  glMultiDrawElementsBaseVertex,
  glMultiDrawElementsIndirect,
  glMultiTexCoord1d,
  glMultiTexCoord1dv,
  glMultiTexCoord1f,
  glMultiTexCoord1fv,
  glMultiTexCoord1i,
  glMultiTexCoord1iv,
  glMultiTexCoord1s,
  glMultiTexCoord1sv,
  glMultiTexCoord2d,
  glMultiTexCoord2dv,
  glMultiTexCoord2f,
  glMultiTexCoord2fv,
  glMultiTexCoord2i,
  glMultiTexCoord2iv,
  glMultiTexCoord2s,
  glMultiTexCoord2sv,
  glMultiTexCoord3d,
  glMultiTexCoord3dv,
  glMultiTexCoord3f,
  glMultiTexCoord3fv,
  glMultiTexCoord3i,
  glMultiTexCoord3iv,
  glMultiTexCoord3s,
  glMultiTexCoord3sv,
  glMultiTexCoord4d,
  glMultiTexCoord4dv,
  glMultiTexCoord4f,
  glMultiTexCoord4fv,
  glMultiTexCoord4i,
  glMultiTexCoord4iv,
  glMultiTexCoord4s,
  glMultiTexCoord4sv,
  glMultiTexCoordP1ui,
  glMultiTexCoordP1uiv,
  glMultiTexCoordP2ui,
  glMultiTexCoordP2uiv,
  glMultiTexCoordP3ui,
  glMultiTexCoordP3uiv,
  glMultiTexCoordP4ui,
  glMultiTexCoordP4uiv,
  glNamedBufferData,
  glNamedBufferStorage,
  glNamedBufferSubData,
  glNamedFramebufferDrawBuffer,
  glNamedFramebufferDrawBuffers,
  glNamedFramebufferParameteri,
  glNamedFramebufferReadBuffer,
  glNamedFramebufferRenderbuffer,
  glNamedFramebufferTexture,
  glNamedFramebufferTextureLayer,
  glNamedRenderbufferStorage,
  glNamedRenderbufferStorageMultisample,
  glNewList,
  glNormal3b,
  glNormal3bv,
  glNormal3d,
  glNormal3dv,
  glNormal3f,
  glNormal3fv,
  glNormal3i,
  glNormal3iv,
  glNormal3s,
  glNormal3sv,
  glNormalP3ui,
  glNormalP3uiv,
  glNormalPointer,
  glObjectLabel,
  glObjectPtrLabel,
  glOrtho,
  glPassThrough,
  glPatchParameterfv,
  glPatchParameteri,
  glPauseTransformFeedback,
  glPixelMapfv,
  glPixelMapuiv,
  glPixelMapusv,
  glPixelStoref,
  glPixelStorei,
  glPixelTransferf,
  glPixelTransferi,
  glPixelZoom,
  glPointParameterf,
  glPointParameterfv,
  glPointParameteri,
  glPointParameteriv,
  glPointSize,
  glPolygonMode,
  glPolygonOffset,
  glPolygonStipple,
  glPopAttrib,
  glPopClientAttrib,
  glPopDebugGroup,
  glPopMatrix,
  glPopName,
  glPrimitiveRestartIndex,
  glPrioritizeTextures,
  glProgramBinary,
  glProgramParameteri,
  glProgramUniform1d,
  glProgramUniform1dv,
  glProgramUniform1f,
  glProgramUniform1fv,
  glProgramUniform1i,
  glProgramUniform1iv,
  glProgramUniform1ui,
  glProgramUniform1uiv,
  glProgramUniform2d,
  glProgramUniform2dv,
  glProgramUniform2f,
  glProgramUniform2fv,
  glProgramUniform2i,
  glProgramUniform2iv,
  glProgramUniform2ui,
  glProgramUniform2uiv,
  glProgramUniform3d,
  glProgramUniform3dv,
  glProgramUniform3f,
  glProgramUniform3fv,
  glProgramUniform3i,
  glProgramUniform3iv,
  glProgramUniform3ui,
  glProgramUniform3uiv,
  glProgramUniform4d,
  glProgramUniform4dv,
  glProgramUniform4f,
  glProgramUniform4fv,
  glProgramUniform4i,
  glProgramUniform4iv,
  glProgramUniform4ui,
  glProgramUniform4uiv,
  glProgramUniformMatrix2dv,
  glProgramUniformMatrix2fv,
  glProgramUniformMatrix2x3dv,
  glProgramUniformMatrix2x3fv,
  glProgramUniformMatrix2x4dv,
  glProgramUniformMatrix2x4fv,
  glProgramUniformMatrix3dv,
  glProgramUniformMatrix3fv,
  glProgramUniformMatrix3x2dv,
  glProgramUniformMatrix3x2fv,
  glProgramUniformMatrix3x4dv,
  glProgramUniformMatrix3x4fv,
  glProgramUniformMatrix4dv,
  glProgramUniformMatrix4fv,
  glProgramUniformMatrix4x2dv,
  glProgramUniformMatrix4x2fv,
  glProgramUniformMatrix4x3dv,
  glProgramUniformMatrix4x3fv,
  glProvokingVertex,
  glPushAttrib,
  glPushClientAttrib,
  glPushDebugGroup,
  glPushMatrix,
  glPushName,
  glQueryCounter,
  glRasterPos2d,
  glRasterPos2dv,
  glRasterPos2f,
  glRasterPos2fv,
  glRasterPos2i,
  glRasterPos2iv,
  glRasterPos2s,
  glRasterPos2sv,
  glRasterPos3d,
  glRasterPos3dv,
  glRasterPos3f,
  glRasterPos3fv,
  glRasterPos3i,
  glRasterPos3iv,
  glRasterPos3s,
  glRasterPos3sv,
  glRasterPos4d,
  glRasterPos4dv,
  glRasterPos4f,
  glRasterPos4fv,
  glRasterPos4i,
  glRasterPos4iv,
  glRasterPos4s,
  glRasterPos4sv,
  glReadBuffer,
  glReadPixels,
  glReadnPixels,
  glRectd,
  glRectdv,
  glRectf,
  glRectfv,
  glRecti,
  glRectiv,
  glRects,
  glRectsv,
  glReleaseShaderCompiler,
  glRenderMode,
  glRenderbufferStorage,
  glRenderbufferStorageMultisample,
  glResumeTransformFeedback,
  glRotated,
  glRotatef,
  glSampleCoverage,
  glSampleMaski,
  glSamplerParameterIiv,
  glSamplerParameterIuiv,
  glSamplerParameterf,
  glSamplerParameterfv,
  glSamplerParameteri,
  glSamplerParameteriv,
  glScaled,
  glScalef,
  glScissor,
  glScissorArrayv,
  glScissorIndexed,
  glScissorIndexedv,
  glSecondaryColor3b,
  glSecondaryColor3bv,
  glSecondaryColor3d,
  glSecondaryColor3dv,
  glSecondaryColor3f,
  glSecondaryColor3fv,
  glSecondaryColor3i,
  glSecondaryColor3iv,
  glSecondaryColor3s,
  glSecondaryColor3sv,
  glSecondaryColor3ub,
  glSecondaryColor3ubv,
  glSecondaryColor3ui,
  glSecondaryColor3uiv,
  glSecondaryColor3us,
  glSecondaryColor3usv,
  glSecondaryColorP3ui,
  glSecondaryColorP3uiv,
  glSecondaryColorPointer,
  glSelectBuffer,
  glShadeModel,
  glShaderBinary,
  glShaderSource,
  glShaderStorageBlockBinding,
  glStencilFunc,
  glStencilFuncSeparate,
  glStencilMask,
  glStencilMaskSeparate,
  glStencilOp,
  glStencilOpSeparate,
  glTexBuffer,
  glTexBufferRange,
  glTexCoord1d,
  glTexCoord1dv,
  glTexCoord1f,
  glTexCoord1fv,
  glTexCoord1i,
  glTexCoord1iv,
  glTexCoord1s,
  glTexCoord1sv,
  glTexCoord2d,
  glTexCoord2dv,
  glTexCoord2f,
  glTexCoord2fv,
  glTexCoord2i,
  glTexCoord2iv,
  glTexCoord2s,
  glTexCoord2sv,
  glTexCoord3d,
  glTexCoord3dv,
  glTexCoord3f,
  glTexCoord3fv,
  glTexCoord3i,
  glTexCoord3iv,
  glTexCoord3s,
  glTexCoord3sv,
  glTexCoord4d,
  glTexCoord4dv,
  glTexCoord4f,
  glTexCoord4fv,
  glTexCoord4i,
  glTexCoord4iv,
  glTexCoord4s,
  glTexCoord4sv,
  glTexCoordP1ui,
  glTexCoordP1uiv,
  glTexCoordP2ui,
  glTexCoordP2uiv,
  glTexCoordP3ui,
  glTexCoordP3uiv,
  glTexCoordP4ui,
  glTexCoordP4uiv,
  glTexCoordPointer,
  glTexEnvf,
  glTexEnvfv,
  glTexEnvi,
  glTexEnviv,
  glTexGend,
  glTexGendv,
  glTexGenf,
  glTexGenfv,
  glTexGeni,
  glTexGeniv,
  glTexImage1D,
  glTexImage2D,
  glTexImage2DMultisample,
  glTexImage3D,
  glTexImage3DMultisample,
  glTexParameterIiv,
  glTexParameterIuiv,
  glTexParameterf,
  glTexParameterfv,
  glTexParameteri,
  glTexParameteriv,
  glTexStorage1D,
  glTexStorage2D,
  glTexStorage2DMultisample,
  glTexStorage3D,
  glTexStorage3DMultisample,
  glTexSubImage1D,
  glTexSubImage2D,
  glTexSubImage3D,
  glTextureBarrier,
  glTextureBuffer,
  glTextureBufferRange,
  glTextureParameterIiv,
  glTextureParameterIuiv,
  glTextureParameterf,
  glTextureParameterfv,
  glTextureParameteri,
  glTextureParameteriv,
  glTextureStorage1D,
  glTextureStorage2D,
  glTextureStorage2DMultisample,
  glTextureStorage3D,
  glTextureStorage3DMultisample,
  glTextureSubImage1D,
  glTextureSubImage2D,
  glTextureSubImage3D,
  glTextureView,
  glTransformFeedbackBufferBase,
  glTransformFeedbackBufferRange,
  glTransformFeedbackVaryings,
  glTranslated,
  glTranslatef,
  glUniform1d,
  glUniform1dv,
  glUniform1f,
  glUniform1fv,
  glUniform1i,
  glUniform1iv,
  glUniform1ui,
  glUniform1uiv,
  glUniform2d,
  glUniform2dv,
  glUniform2f,
  glUniform2fv,
  glUniform2i,
  glUniform2iv,
  glUniform2ui,
  glUniform2uiv,
  glUniform3d,
  glUniform3dv,
  glUniform3f,
  glUniform3fv,
  glUniform3i,
  glUniform3iv,
  glUniform3ui,
  glUniform3uiv,
  glUniform4d,
  glUniform4dv,
  glUniform4f,
  glUniform4fv,
  glUniform4i,
  glUniform4iv,
  glUniform4ui,
  glUniform4uiv,
  glUniformBlockBinding,
  glUniformMatrix2dv,
  glUniformMatrix2fv,
  glUniformMatrix2x3dv,
  glUniformMatrix2x3fv,
  glUniformMatrix2x4dv,
  glUniformMatrix2x4fv,
  glUniformMatrix3dv,
  glUniformMatrix3fv,
  glUniformMatrix3x2dv,
  glUniformMatrix3x2fv,
  glUniformMatrix3x4dv,
  glUniformMatrix3x4fv,
  glUniformMatrix4dv,
  glUniformMatrix4fv,
  glUniformMatrix4x2dv,
  glUniformMatrix4x2fv,
  glUniformMatrix4x3dv,
  glUniformMatrix4x3fv,
  glUniformSubroutinesuiv,
  glUnmapBuffer,
  glUnmapNamedBuffer,
  glUseProgram,
  glUseProgramStages,
  glValidateProgram,
  glValidateProgramPipeline,
  glVertex2d,
  glVertex2dv,
  glVertex2f,
  glVertex2fv,
  glVertex2i,
  glVertex2iv,
  glVertex2s,
  glVertex2sv,
  glVertex3d,
  glVertex3dv,
  glVertex3f,
  glVertex3fv,
  glVertex3i,
  glVertex3iv,
  glVertex3s,
  glVertex3sv,
  glVertex4d,
  glVertex4dv,
  glVertex4f,
  glVertex4fv,
  glVertex4i,
  glVertex4iv,
  glVertex4s,
  glVertex4sv,
  glVertexArrayAttribBinding,
  glVertexArrayAttribFormat,
  glVertexArrayAttribIFormat,
  glVertexArrayAttribLFormat,
  glVertexArrayBindingDivisor,
  glVertexArrayElementBuffer,
  glVertexArrayVertexBuffer,
  glVertexArrayVertexBuffers,
  glVertexAttrib1d,
  glVertexAttrib1dv,
  glVertexAttrib1f,
  glVertexAttrib1fv,
  glVertexAttrib1s,
  glVertexAttrib1sv,
  glVertexAttrib2d,
  glVertexAttrib2dv,
  glVertexAttrib2f,
  glVertexAttrib2fv,
  glVertexAttrib2s,
  glVertexAttrib2sv,
  glVertexAttrib3d,
  glVertexAttrib3dv,
  glVertexAttrib3f,
  glVertexAttrib3fv,
  glVertexAttrib3s,
  glVertexAttrib3sv,
  glVertexAttrib4Nbv,
  glVertexAttrib4Niv,
  glVertexAttrib4Nsv,
  glVertexAttrib4Nub,
  glVertexAttrib4Nubv,
  glVertexAttrib4Nuiv,
  glVertexAttrib4Nusv,
  glVertexAttrib4bv,
  glVertexAttrib4d,
  glVertexAttrib4dv,
  glVertexAttrib4f,
  glVertexAttrib4fv,
  glVertexAttrib4iv,
  glVertexAttrib4s,
  glVertexAttrib4sv,
  glVertexAttrib4ubv,
  glVertexAttrib4uiv,
  glVertexAttrib4usv,
  glVertexAttribBinding,
  glVertexAttribDivisor,
  glVertexAttribFormat,
  glVertexAttribI1i,
  glVertexAttribI1iv,
  glVertexAttribI1ui,
  glVertexAttribI1uiv,
  glVertexAttribI2i,
  glVertexAttribI2iv,
  glVertexAttribI2ui,
  glVertexAttribI2uiv,
  glVertexAttribI3i,
  glVertexAttribI3iv,
  glVertexAttribI3ui,
  glVertexAttribI3uiv,
  glVertexAttribI4bv,
  glVertexAttribI4i,
  glVertexAttribI4iv,
  glVertexAttribI4sv,
  glVertexAttribI4ubv,
  glVertexAttribI4ui,
  glVertexAttribI4uiv,
  glVertexAttribI4usv,
  glVertexAttribIFormat,
  glVertexAttribIPointer,
  glVertexAttribL1d,
  glVertexAttribL1dv,
  glVertexAttribL2d,
  glVertexAttribL2dv,
  glVertexAttribL3d,
  glVertexAttribL3dv,
  glVertexAttribL4d,
  glVertexAttribL4dv,
  glVertexAttribLFormat,
  glVertexAttribLPointer,
  glVertexAttribP1ui,
  glVertexAttribP1uiv,
  glVertexAttribP2ui,
  glVertexAttribP2uiv,
  glVertexAttribP3ui,
  glVertexAttribP3uiv,
  glVertexAttribP4ui,
  glVertexAttribP4uiv,
  glVertexAttribPointer,
  glVertexBindingDivisor,
  glVertexP2ui,
  glVertexP2uiv,
  glVertexP3ui,
  glVertexP3uiv,
  glVertexP4ui,
  glVertexP4uiv,
  glVertexPointer,
  glViewport,
  glViewportArrayv,
  glViewportIndexedf,
  glViewportIndexedfv,
  glWaitSync,
  glWindowPos2d,
  glWindowPos2dv,
  glWindowPos2f,
  glWindowPos2fv,
  glWindowPos2i,
  glWindowPos2iv,
  glWindowPos2s,
  glWindowPos2sv,
  glWindowPos3d,
  glWindowPos3dv,
  glWindowPos3f,
  glWindowPos3fv,
  glWindowPos3i,
  glWindowPos3iv,
  glWindowPos3s,
  glWindowPos3sv
) where

import Graphics.Rendering.OpenGL.Raw.Types
import Graphics.Rendering.OpenGL.Raw.Tokens
import Graphics.Rendering.OpenGL.Raw.Functions
