* [Project Roles](#project-roles)
  - [Contributor](#contributor)
  - [Committer](#committer)
  - [Maintainer](#maintainer)
  - [Selection of Committers and Maintainers](#selection-of-committers-and-maintainers)
  - [Revocation of Committers/Maintainers status](#revocation-of-committersmaintainers-status)
  - [Steering Committee](#steering-committee)
* [Decision Making Process](#decision-making-process)

## Project Roles

The IoT.js project recognizes the following formal roles: Contributor, Committer, and Maintainer.

* [Assigned people](Assigned-people.md)

#### Contributor
A _Contributor_ is a developer who wishes to contribute to the project, at any level. Contributors who show dedication and skill are rewarded with additional rights and responsibilities. Their opinions weigh more when decisions are made, in a fully meritocratic fashion.

Contributors are granted the following rights and responsibilities:
* Right to contribute code, documentation, translations, artwork, etc.
* Right to report defects (bugs) and suggestions for enhancement.
* Right to participate in the process of reviewing contributions by others.
* Right to initiate and participate in discussions in any communication methods.
* Right to approach any member of the community with matters they believe to be important.
* Responsibility to abide by decisions, once made. They are welcome to provide new, relevant information to reopen decisions.
* Responsibility for issues and bugs introduced by one’s own contributions.
* Responsibility to respect the rules of the community.
* Responsibility to provide constructive advice whenever participating in discussions and in the review of contributions.

#### Committer
A _Committer_ is a Contributor who is also responsible for the maintenance of IoT.js source code. 

Committers have the following rights and responsibilities, in addition to those listed for Contributors:
* Right to set goals for the short and medium terms for the project being maintained, alongside the Maintainer.
* Right to exceptionally make more invasive changes to the source code, when required.
* Right to approve own contribution, after discussing with other Contributors.
* Right and responsibility to participate in the feature development process.
* Responsibility to ensure all contributions of the project have been reviewed within reasonable time.
* Responsibility to ensure the quality of the code to expected levels.
* Responsibility to monitor discussions in the community.
* Responsibility to participate in the quality verification and release process, when those happen.

#### Maintainer
A _Maintainer_ is a Contributor who is also responsible for knowing, directing and anticipating the needs of a given IoT.js source code. 

Maintainers have the following rights and responsibilities, in addition to those listed for Contributors and Committers:
* right to set the overall organization of the source code of the project
* right to participate in the decision-making of the project, in conjunction with the Committers.
* Responsibility to ensure all contributions of the project have been reviewed within reasonable time. 
  - In the reviewing, only Maintainers can give binding scores(refer to [Approval Path for PR(Pull Request)](#approval-path-for-prpull-request))

#### Selection of Committers and Maintainers

A candidate for the Committer role should be one of the Contributors who has submitted at least 10 non-trivial patches in project and has shown characteristics consistent with the requirements of the Committer role. 
A candidate for the Maintainer role should be one of the Committers. 
To be a candidate for the Committer or Maintainer, a Contributor can self-nominate with proper evidences.

The selection process should be achieved by consensus of the Contributors active in. If consensus cannot be achieved, Maintainers will make the decision by voting.

#### Revocation of Committers/Maintainers Status

A Maintainer or a Committer who intentionally abused his review privilege may have it temporarily suspended on the request of other Committers or Maintainers. Committers and Maintainers not including the person under consideration should discuss on the revocation of the person. If consensus cannot be reached, Maintainers will make the decision by voting.

#### Steering Committee

_Steering Committee_ oversees and guides the progress of IoT.js project.

The Steering Committee have the following responsibilities:

* responsibility to oversee the health of the project community.
* responsibility to oversee and facilitate the development of the IoT.js source code under the governance rules of the IoT.js Open Source project.
* responsibility to guide and direct the development towards goals.
* responsibility to sets the goals and roadmap for the project

## Decision Making Process

Decisions in the IoT.js project are made always at the lowest level possible that is applicable for the decision in question. Decision makers always need to keep in mind the rules of community and the IoT.js goals and roadmap.

* Individual Contributors are making decisions every time they submit changes in the form of deciding what to implement and how to go about it.
* Two or more Contributors also make decisions when participating in discussions in community, on bug or feature reports, in reviewing of commits. Their arguments in why a given decision should be made are part of the consensus that needs to be reached for the decision. At this level, the principle of meritocracy is important, as the opinion of those who have contributed more will be given more weight in the consensus-building.
* If those Contributors cannot agree and reach consensus on a decision, then IoT.js provides for decisions to be made by Maintainers following their own decision-making process, avoiding stalemates.