/***************************************************************************
 *   Copyright (C) 2007-2012 by Marcel Hasler                              *
 *   mahasler@gmail.com                                                    *
 *                                                                         *
 *   This file is part of KGmailNotifier.                                  *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation, either version 3 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the          *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program. If not, see <http://www.gnu.org/licenses/>.  *
 ***************************************************************************/

#ifndef TRAYICON_H
#define TRAYICON_H

#include <KStatusNotifierItem>

class TrayIcon : public QObject
{
    Q_OBJECT

public:
    enum IconType
    {
        Alert,
        NoMail,
        NewMail
    };

public:
    TrayIcon(QObject *parent);
    ~TrayIcon();

    void setActive(bool active);
    void setIcon(IconType type, unsigned int number, bool showNumber);
    void setToolTip(const QString &text);

    KMenu* contextMenu() const;

private:
    TrayIcon(const TrayIcon&);
    TrayIcon& operator=(const TrayIcon&);

private slots:
    void slotActivateRequested(bool, const QPoint&);

signals:
    void clicked();

private:
    KStatusNotifierItem m_notifierItem;
};

#endif
