#if   !defined(__MEMORY_HPP)
#define  __MEMORY_HPP

/*
  CoreLinux++ 
  Copyright (C) 1999,2000 CoreLinux Consortium
  
   The CoreLinux++ Library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public License as
   published by the Free Software Foundation; either version 2 of the
   License, or (at your option) any later version.

   The CoreLinux++ Library Library is distributed in the hope that it will 
   be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with the GNU C Library; see the file COPYING.LIB.  If not,
   write to the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.  
*/

#if !defined(__COMMON_HPP)
#include <Common.hpp>
#endif

#if   !defined(__SYNCHRONIZED_HPP)
#include <Synchronized.hpp>
#endif

#if   !defined(__SINGLETON_HPP)
#include <Singleton.hpp>
#endif

#if   !defined(__STORAGEEXCEPTION_HPP)
#include <StorageException.hpp>
#endif

#if   !defined(__MEMORYSTORAGE_HPP)
#include <MemoryStorage.hpp>
#endif

#if   !defined(__MAP_HPP)
#include <Map.hpp>
#endif



namespace corelinux
{

   CORELINUX_MAP
      ( 
       MemoryStoragePtr, CharCptr, std::less<MemoryStoragePtr>, MemoryMap
      );


   DECLARE_CLASS( Memory );

   /// Declare the memory manager as a singleton for Memory

   DECLARE_TYPE( Singleton<Memory>, MemoryManager );

   /**
   Memory is high speed transient storage managed by the operating
   system, for both itself and user processes, used to store data and
   programs.
   Upon allocation request, the operating system provides user
   processes with a memory storage region that is in addition to the
   current memory resources (stack, program, data) of the process. The
   memory can be made visible to all processes in the system, a select
   few, or just to the process that requested the storage. If made
   visible to other processes, memory provides a fast and efficient way
   to transfer information between the processes, and in this manner can
   be catagorized as high speed interprocess communication. It is up to
   the processes that share this memory area to agree on a
   synchronization protocol.
   The operating system allows a process to &quot;mark&quot; a memory
   region attribute as:<p>
   <ul>
	<LI>Read only<br>
	Memory marked with this attribute restrict processes to read only
	operations performed on the memory storage region. Attempts to write
	anything to this area will result in a system exception. 
   <p>
   <LI>Read/Write<br>
	Marked as Read/Write, processes have the ability to store and
	retrieve from the memory storage region. This is the most common
	form of access.
   <p>
	<LI>Executable<br>
	This marks a memory region in the memory storage region as
	executable. This provides a convenient way for user processes to
	load dynamic program blocks for execution. By definition, memory in
	a region marked executable is readable and writeable. 
	</ul>
   */

   class Memory : public Synchronized
   {

   public:

      //
      // Constructors and destructor
      //

                        /// Default constructor

                        Memory( void ) throw( Assertion );

                        /// Virtual Destructor

      virtual           ~Memory( void );

      //
      // Operator overloads
      //

      //
      // Accessors
      //

      //
      // Mutators
      //

      //
      // Factory Methods
      //

               /**
               Default create method, creates a private block of
               read write shared memory of size aByteSize, sharing 
               attributes default to owner.
               @param Size number of bytes to allocate
               @param Int rights specificed
               @return MemoryStorage pointer
               */

      static   MemoryStoragePtr  createStorage
                  ( 
                     Size aByteSize, 
                     Int Rights = OWNER_ALL 
                  ) throw( StorageException );

               /**
               Create method, creates or opens a specifically 
               identified block of shared memory of size aByteSize, 
               sharing attributes default to owner.
               @param MemoryIdentifier reference to identifier.
               @param Size number of bytes to allocate
               @param Int rights specificed
               @return MemoryStorage pointer
               */

      static   MemoryStoragePtr  createStorage
                  ( 
                     MemoryIdentifierCref aIdentifier,
                     Size                 aByteSize,
                     CreateDisposition    disp = CREATE_OR_REUSE,                     
                     Int                  Rights = OWNER_ALL,
                     AddressingConstraint addressing = READ_WRITE
                  );

               /**
               Create method, creates or opens a specifically 
               identified block of shared memory of size aByteSize, 
               sharing attributes default to owner.
               @param string name of shared memory storage.
               @param Size number of bytes to allocate
               @param Int rights specificed
               @return MemoryStorage pointer
               */

      static   MemoryStoragePtr  createStorage
                  ( 
                     CharCptr             aName,
                     Size                 aByteSize, 
                     CreateDisposition    disp = CREATE_OR_REUSE,                     
                     Int                  Rights = OWNER_ALL ,
                     AddressingConstraint addressing = READ_WRITE
                  );

               /**
               Destroy a previously allocated storage block
               @param MemoryStorage pointer to storage object
               */

      static   void  destroyStorage( MemoryStoragePtr );

   protected:
                        /// Copy constructor prohibited

                        Memory( MemoryCref ) throw( Assertion );

               /// Assignment operator prohibited

               MemoryRef   operator=( MemoryCref ) throw( Assertion );

               /// Equality always returns false

               bool        operator==( MemoryCref ) const;

   protected:
               /// The singleton instance of Memory for synchronization

      static   MemoryManager  theMemoryManager;

   private:

      static   MemoryMap      theMemoryStorageMap;
   };
}

#endif // if !defined(__MEMORY_HPP)

/*
   Common rcs information do not modify
   $Author: prudhomm $
   $Revision: 1.5 $
   $Date: 2000/08/31 22:52:20 $
   $Locker:  $
*/

