use strict;
# Adjust the number here!
use Test::More tests => 9;

use_ok('Encode');
use_ok('Encode::EUCJPMS');
# Add more test here!

is("\x3f\x3f\x3f\xa1\xf1\xa1\xf2\xa2\xcc\x3f\xa2\xcc\x7c",
   encode('cp51932',"\x{301C}\x{2016}\x{2212}\x{00A2}\x{00A3}\x{00AC}\x{2016}\x{00AC}\x{00A6}"));
is("\xa1\xc1\xa1\xc2\xa1\xdd\xa1\xf1\xa1\xf2\xa2\xcc\xa1\xc2\xa2\xcc\xfc\xfc",
   encode('cp51932',"\x{FF5E}\x{2225}\x{FF0D}\x{FFE0}\x{FFE1}\x{FFE2}\x{2225}\x{FFE2}\x{FFE4}"));
is("\xa1\xc1\xa1\xc2\xa1\xdd\xa1\xf1\xa1\xf2\xa2\xcc\xa1\xc2\xa2\xcc\x8f\xa2\xc3",
   encode('glibc-EUC_JP_MS-2.3.3',"\x{FF5E}\x{2225}\x{FF0D}\x{FFE0}\x{FFE1}\x{FFE2}\x{2225}\x{FFE2}\x{FFE4}"));
is("\xa1\xc1\xa1\xc2\xa1\xdd\xa1\xf1\xa1\xf2\xa2\xcc\xa1\xc2\xa2\xcc\x8f\xa2\xc3",
   encode('eucJP-ms',"\x{FF5E}\x{2225}\x{FF0D}\x{FFE0}\x{FFE1}\x{FFE2}\x{2225}\x{FFE2}\x{FFE4}"));
is("\xa1\xc1\xa1\xc2\xa1\xdd\xa1\xf1\xa1\xf2\xa2\xcc\xa1\xc2\xa2\xcc\x8f\xa2\xc3",
   encode('eucjp-win',"\x{FF5E}\x{2225}\x{FF0D}\x{FFE0}\x{FFE1}\x{FFE2}\x{2225}\x{FFE2}\x{FFE4}"));
is(pack('H*','1b2442252221412142215d21712172224c2142224c7c7c1b2842'),
   encode('CP50220',"\x{FF71}\x{FF5E}\x{2225}\x{FF0D}\x{FFE0}\x{FFE1}\x{FFE2}\x{2225}\x{FFE2}\x{FFE4}"));
is(pack('H*','1b2849311b244221412142215d21712172224c2142224c7c7c1b2842'),
   encode('CP50221',"\x{FF71}\x{FF5E}\x{2225}\x{FF0D}\x{FFE0}\x{FFE1}\x{FFE2}\x{2225}\x{FFE2}\x{FFE4}"));
