/*
 * @(#)AsmblStateUTest.java
 *
 * Copyright (C) 2002-2003 Matt Albrecht
 * groboclown@users.sourceforge.net
 * http://groboutils.sourceforge.net
 *
 *  Permission is hereby granted, free of charge, to any person obtaining a
 *  copy of this software and associated documentation files (the "Software"),
 *  to deal in the Software without restriction, including without limitation
 *  the rights to use, copy, modify, merge, publish, distribute, sublicense,
 *  and/or sell copies of the Software, and to permit persons to whom the 
 *  Software is furnished to do so, subject to the following conditions:
 *
 *  The above copyright notice and this permission notice shall be included in 
 *  all copies or substantial portions of the Software. 
 *
 *  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR 
 *  IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, 
 *  FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL 
 *  THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER 
 *  LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING 
 *  FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER 
 *  DEALINGS IN THE SOFTWARE.
 */

package net.sourceforge.groboutils.mbtf.v1.assembler;

import org.easymock.EasyMock;
import org.easymock.MockControl;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

import net.sourceforge.groboutils.mbtf.v1.IState;
import net.sourceforge.groboutils.mbtf.v1.IValidate;
import net.sourceforge.groboutils.mbtf.v1.ISystem;
import net.sourceforge.groboutils.mbtf.v1.IErrors;
import net.sourceforge.groboutils.mbtf.v1.IAction;

/**
 * Tests the AsmblState class.
 *
 * @author    Matt Albrecht <a href="mailto:groboclown@users.sourceforge.net">groboclown@users.sourceforge.net</a>
 * @version   $Date: 2003/02/10 22:52:28 $
 * @since     June 17, 2002
 */
public class AsmblStateUTest extends TestCase
{
    //-------------------------------------------------------------------------
    // Standard JUnit Class-specific declarations
    
    private static final Class THIS_CLASS = AsmblStateUTest.class;
    
    public AsmblStateUTest( String name )
    {
        super( name );
    }

    
    //-------------------------------------------------------------------------
    // setup

    /**
     * 
     * @exception Exception thrown under any exceptional condition.
     */
    protected void setUp() throws Exception
    {
        super.setUp();
        
        // set ourself up
    }


    //-------------------------------------------------------------------------
    // Tests
    
    
    public void testConstructor1()
    {
        new AsmblState();
    }
    
    
    public void testAddValidate1()
    {
        AsmblState at = new AsmblState();
        at.addValidate( null );
        IValidate[] v = at.getValidates();
        assertNotNull(
            "validates returned null.",
            v );
        assertEquals(
            "validates size not right.",
            0,
            v.length );
    }
    
    
    private static class MyValidate implements IValidate
    {
        public void validate( ISystem s, IErrors e ) {}
    }
    
    
    private static class MyAction implements IAction
    {
        public void performAction( ISystem s, IErrors e ) {}
    }
    
    
    public void testAddValidate2()
    {
        IValidate ov = new MyValidate();
        AsmblState at = new AsmblState();
        at.addValidate( ov );
        IValidate[] v = at.getValidates();
        assertNotNull(
            "validates returned null.",
            v );
        assertEquals(
            "validates size not right.",
            1,
            v.length );
        assertEquals(
            "validates inserted not returned.",
            ov,
            v[0] );
    }
    
    
    public void testAddTransitionName1()
    {
        AsmblState at = new AsmblState();
        at.addTransitionName( null );
        String[] v = at.getTransitionNames();
        assertNotNull(
            "trans names returned null.",
            v );
        assertEquals(
            "trans names size not right.",
            0,
            v.length );
    }
    
    
    public void testAddTransitionName2()
    {
        String transName = "t1";
        AsmblState at = new AsmblState();
        at.addTransitionName( transName );
        String[] v = at.getTransitionNames();
        assertNotNull(
            "trans names returned null.",
            v );
        assertEquals(
            "trans names size not right.",
            1,
            v.length );
        assertEquals(
            "not same name as passed into add.",
            transName,
            v[0] );
    }
    
    
    public void testCreateState1()
    {
        AsmblState at = new AsmblState();
        AsmblTransitionSet ats = new AsmblTransitionSet();
        
        try
        {
            IState state = at.createState( ats );
            fail("did not throw IllegalArgumentException");
        }
        catch (IllegalArgumentException iae)
        {
            // check reason
        }
    }
    
    
    public void testCreateState2()
    {
        AsmblState as = new AsmblState();
        as.setName( "state" );
        AsmblTransitionSet ats = new AsmblTransitionSet();
        
        IState state = as.createState( ats );
        assertNotNull(
            "returned null.",
            state );
        assertEquals(
            "wrong state name.",
            "state",
            as.getName() );
    }
    
    
    public void testCreateState3()
    {
        AsmblState as = new AsmblState();
        as.setName( "state" );
        as.addTransitionName( "trans" );
        AsmblTransition at = new AsmblTransition();
        at.setName( "trans" );
        at.setNextStateName( "state" );
        at.setAction( new MyAction() );
        AsmblTransitionSet ats = new AsmblTransitionSet();
        ats.addTransition( at );
        
        IState state = as.createState( ats );
        assertNotNull(
            "returned null.",
            state );
        assertEquals(
            "wrong name for state.",
            "state",
            state.getName() );
        assertEquals(
            "wrong transition length.",
            1,
            state.getTransitions().length );
        assertEquals(
            "wrong validates length.",
            0,
            state.getValidates().length );
    }
    
    
    //-------------------------------------------------------------------------
    // Helpers
    
    
    //-------------------------------------------------------------------------
    // Standard JUnit declarations
    
    
    public static Test suite()
    {
        TestSuite suite = new TestSuite( THIS_CLASS );
        
        // Test the implementation's interface conformity.
        /*
        suite.addTest( IxUTestI.suite(
            new ImplementationCreator[] {
                new ImplementationCreator() {
                    public Object createImplementedObject() {
                        // XXXXXXXXXXXXXXXXXXXXXXXX
                    }
                },
            } ) );
        */
        return suite;
    }
    
    public static void main( String[] args )
    {
        String[] name = { THIS_CLASS.getName() };
        
        // junit.textui.TestRunner.main( name );
        // junit.swingui.TestRunner.main( name );
        
        junit.textui.TestRunner.main( name );
    }
    
    
    /**
     * 
     * @exception Exception thrown under any exceptional condition.
     */
    protected void tearDown() throws Exception
    {
        // tear ourself down
        
        super.tearDown();
    }
}

