//
// System.Web.UI.WebControls.DataControlFieldCollection.cs
//
// Authors:
//	Lluis Sanchez Gual (lluis@novell.com)
//
// (C) 2004-2010 Novell, Inc (http://www.novell.com)
//
// Permission is hereby granted, free of charge, to any person obtaining
// a copy of this software and associated documentation files (the
// "Software"), to deal in the Software without restriction, including
// without limitation the rights to use, copy, modify, merge, publish,
// distribute, sublicense, and/or sell copies of the Software, and to
// permit persons to whom the Software is furnished to do so, subject to
// the following conditions:
// 
// The above copyright notice and this permission notice shall be
// included in all copies or substantial portions of the Software.
// 
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
// EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
// MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
// NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE
// LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
// OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
// WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
//
//
using System;
using System.Collections;
using System.Web.UI;
using System.ComponentModel;

namespace System.Web.UI.WebControls
{
	public sealed class DataControlFieldCollection: StateManagedCollection
	{
		static readonly object fieldsChangedEvent = new object ();
		
		static readonly Type[] fieldTypes = new Type [] {
			typeof(BoundField), typeof(HyperLinkField), typeof(ImageField),
			typeof(TemplateField), typeof(AutoGeneratedField), typeof(CheckBoxField),
			typeof(ButtonField), typeof(CommandField)
		};

		EventHandlerList events = new EventHandlerList ();
		
		public event EventHandler FieldsChanged {
			add { events.AddHandler (fieldsChangedEvent, value); }
			remove { events.RemoveHandler (fieldsChangedEvent, value); }
		}
		
		public DataControlFieldCollection CloneFields ()
		{
			DataControlFieldCollection col = new DataControlFieldCollection ();
			foreach (DataControlField field in this)
				col.Add (field.CloneField ());
			return col;
		}
		
		public void Add (DataControlField field)
		{
			((IList)this).Add (field);
		}
		
		public bool Contains (DataControlField field)
		{
			return ((IList)this).Contains (field);
		}
		
		public void CopyTo (DataControlField[] array, int index)
		{
			((IList)this).CopyTo (array, index);
		}
		
		public int IndexOf (DataControlField field)
		{
			return ((IList)this).IndexOf (field);
		}
		
		public void Insert (int index, DataControlField field)
		{
			((IList)this).Insert (index, field);
		}
		
		public void Remove (DataControlField field)
		{
			((IList)this).Remove (field);
		}
		
		public void RemoveAt (int index)
		{
			((IList)this).RemoveAt (index);
		}
		
		[Browsable (false)]
		public DataControlField this [int index] {
			get { return (DataControlField) ((IList)this) [index]; }
		}

		protected override void OnInsertComplete (int index, object value)
		{
			DataControlField field = (DataControlField) value;
			field.FieldChanged += new EventHandler (OnFieldChanged);
			OnFieldsChanged ();
		}

		protected override void OnRemoveComplete (int index, object value)
		{
			DataControlField field = (DataControlField) value;
			field.FieldChanged -= new EventHandler (OnFieldChanged);
			OnFieldsChanged ();
		}

		protected override void OnClearComplete ()
		{
			OnFieldsChanged ();
		}
		
		void OnFieldChanged (object sender, EventArgs args)
		{
			OnFieldsChanged ();
		}
		
		void OnFieldsChanged ()
		{
			EventHandler eh = events [fieldsChangedEvent] as EventHandler;
			if (eh != null)
				eh (this, EventArgs.Empty);
		}

		[MonoTODO ("Validate whatever needs to be validated here.")]
		protected override void OnValidate (object o)
		{
			base.OnValidate (o);
		}
		
		protected override void SetDirtyObject (object o)
		{
			((DataControlField)o).SetDirty ();
		}

		protected override object CreateKnownType (int index)
		{
			switch (index) {
				case 0: return new BoundField ();
				case 1: return new HyperLinkField ();
				case 2: return new ImageField ();
				case 3: return new TemplateField ();
				case 4: return new AutoGeneratedField ();
				case 5: return new CheckBoxField ();
				case 6: return new ButtonField ();
				case 7: return new CommandField ();
			}
			return null;
		}
		
		protected override Type [] GetKnownTypes ()
		{
			return fieldTypes;
		}
	}
}

