import base64
import hashlib

from future.utils import bytes_to_native_str
from hypothesis import given
from hypothesis.strategies import text

from olm import sha256
from olm._compat import to_bytes


class TestClass(object):
    @given(text(), text())
    def test_sha256(self, input1, input2):
        first_hash = sha256(input1)
        second_hash = sha256(input2)

        hashlib_hash = base64.b64encode(
            hashlib.sha256(to_bytes(input1)).digest()
        )

        hashlib_hash = bytes_to_native_str(hashlib_hash[:-1])

        if input1 == input2:
            assert first_hash == second_hash
        else:
            assert first_hash != second_hash

        assert hashlib_hash == first_hash
