/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#pragma once

#if ENABLE(SPEECH_SYNTHESIS)

#include "ActiveDOMCallback.h"
#include "JSCallbackData.h"
#include "TestCallbackInterface.h"
#include <wtf/Forward.h>

namespace WebCore {

class JSTestCallbackInterface : public TestCallbackInterface, public ActiveDOMCallback {
public:
    static Ref<JSTestCallbackInterface> create(JSC::JSObject* callback, JSDOMGlobalObject* globalObject)
    {
        return adoptRef(*new JSTestCallbackInterface(callback, globalObject));
    }

    virtual ScriptExecutionContext* scriptExecutionContext() const { return ContextDestructionObserver::scriptExecutionContext(); }

    virtual ~JSTestCallbackInterface();
    JSCallbackDataStrong* callbackData() { return m_data; }
    static JSC::JSValue getConstructor(JSC::VM&, const JSC::JSGlobalObject*);

    // Functions
    virtual bool callbackWithNoParam();
    virtual bool callbackWithArrayParam(RefPtr<Float32Array> arrayParam);
    virtual bool callbackWithSerializedScriptValueParam(RefPtr<SerializedScriptValue>&& srzParam, const String& strParam);
    virtual int32_t customCallback(Class5* class5Param, Class6* class6Param);
    virtual bool callbackWithStringList(DOMStringList* listParam);
    virtual bool callbackWithBoolean(bool boolParam);
    virtual bool callbackRequiresThisToPass(int32_t longParam, TestNode* testNodeParam);

private:
    JSTestCallbackInterface(JSC::JSObject*, JSDOMGlobalObject*);

    JSCallbackDataStrong* m_data;
};

JSC::JSValue toJS(TestCallbackInterface&);
inline JSC::JSValue toJS(TestCallbackInterface* impl) { return impl ? toJS(*impl) : JSC::jsNull(); }

} // namespace WebCore

#endif // ENABLE(SPEECH_SYNTHESIS)
