/*
 * Decompiled with CFR 0.152.
 */
package sun.plugin.dom.css;

import java.util.ArrayList;
import org.w3c.dom.DOMException;
import sun.plugin.dom.css.CSSStyleDeclaration;
import sun.plugin.dom.css.CSSValue;
import sun.plugin.dom.exception.InvalidStateException;

public final class CSSValueList
extends CSSValue
implements org.w3c.dom.css.CSSValueList {
    private ArrayList values = new ArrayList();

    protected CSSValueList(CSSStyleDeclaration cSSStyleDeclaration, String string) {
        super(cSSStyleDeclaration, string);
    }

    protected CSSValueList(CSSValue cSSValue) {
        super(cSSValue);
    }

    public short getCssValueType() {
        return 2;
    }

    public int getLength() {
        return this.values.size();
    }

    public org.w3c.dom.css.CSSValue item(int n) {
        return (CSSValue)this.values.get(n);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        int n = this.getLength();
        for (int i = 0; i < this.getLength(); ++i) {
            stringBuffer.append(this.item(i).toString());
            if (i >= n - 1) continue;
            stringBuffer.append(' ');
        }
        return stringBuffer.toString();
    }

    protected boolean isSameType(CSSValue cSSValue) {
        if (cSSValue.getCssValueType() != this.getCssValueType()) {
            return false;
        }
        CSSValueList cSSValueList = (CSSValueList)cSSValue;
        if (cSSValueList.getLength() != this.getLength()) {
            return false;
        }
        for (int i = 0; i < cSSValueList.getLength(); ++i) {
            CSSValue cSSValue2 = (CSSValue)cSSValueList.item(i);
            CSSValue cSSValue3 = (CSSValue)this.item(i);
            if (cSSValue3.isSameType(cSSValue2)) continue;
            return false;
        }
        return true;
    }

    protected void copy(CSSValue cSSValue) {
        super.copy(cSSValue);
        CSSValueList cSSValueList = (CSSValueList)cSSValue;
        this.values.clear();
        for (int i = 0; i < cSSValueList.getLength(); ++i) {
            this.addValue((CSSValue)cSSValueList.item(i));
        }
    }

    private void addValue(CSSValue cSSValue) {
        this.values.add(cSSValue);
    }

    public static CSSValueList newCSSValueList(CSSValue cSSValue, String string) throws DOMException {
        CSSValueList cSSValueList = new CSSValueList(cSSValue);
        return CSSValueList.newCSSValueList(cSSValueList, string);
    }

    public static CSSValueList newCSSValueList(CSSStyleDeclaration cSSStyleDeclaration, String string, String string2) throws DOMException {
        CSSValueList cSSValueList = new CSSValueList(cSSStyleDeclaration, string);
        return CSSValueList.newCSSValueList(cSSValueList, string2);
    }

    private static CSSValueList newCSSValueList(CSSValueList cSSValueList, String string) throws DOMException {
        int n;
        String string2 = string.trim();
        while ((n = CSSValueList.getNextCssText(string2)) > 0) {
            System.out.println("Return index: " + n);
            if (string2.charAt(n) != ' ') {
                ++n;
            }
            String string3 = string2.substring(0, n);
            System.out.println("Return cssText: " + string3);
            cSSValueList.addValue(CSSValue.newCSSValue(cSSValueList, string3));
            if (n >= string2.length()) break;
            string2 = string2.substring(n + 1);
            System.out.println("Rest cssText: " + string2);
        }
        cSSValueList.cssText = string;
        return cSSValueList;
    }

    private static int getNextCssText(String string) throws DOMException {
        int n;
        block5: for (n = 0; n < string.length(); ++n) {
            char c = string.charAt(n);
            switch (c) {
                case ' ': {
                    return n;
                }
                case '(': {
                    n = string.indexOf(")", n + 1);
                    if (n != -1) continue block5;
                    throw new InvalidStateException("Invalid cssText: " + string);
                }
                case '\"': {
                    n = string.indexOf("\"", n + 1);
                    if (n != -1) continue block5;
                    throw new InvalidStateException("Invalid cssText: " + string);
                }
            }
        }
        return n - 1;
    }
}

