# Reference
<!-- DO NOT EDIT: This document was generated by Puppet Strings -->

## Table of Contents

**Classes**

* [`gitolite`](#gitolite): This class is inherited by setup.pp and admin.pp  It's intention is to have alle the config parameters.  If you only use this class (and the 
* [`gitolite::admin`](#gitoliteadmin): This class manages the gitolite.conf file and prepares to manage the ssh keys with puppet.  do not use this class if you want to use the gito
* [`gitolite::client`](#gitoliteclient): Class to install git
* [`gitolite::ssh_key`](#gitolitessh_key): Generate an SSH authentication key  Key generation for (passwordless) authentication to a remote system.

**Defined types**

* [`gitolite::repo`](#gitoliterepo): this resources defines a git repository you also can use it to define values for a group of repositories (by using an @ in front of the group
* [`gitolite::repos`](#gitoliterepos): this resource defines a group of repos with defaults
* [`gitolite::user`](#gitoliteuser): this resources defines a git user you also can use it to define values for a group of repositories (by using an @ in front of the group name)
* [`gitolite::users`](#gitoliteusers): this resource defines a group of users with defaults

**Resource types**

* [`gitremote`](#gitremote): add a remote to a git repository

## Classes

### gitolite

This class is inherited by setup.pp and admin.pp

It's intention is to have alle the config parameters.

If you only use this class (and the setup), you can still do all admin work
(manage users, permissions etc. throug the git repository
gitolite-admin.git.)

#### Parameters

The following parameters are available in the `gitolite` class.

##### `reporoot`

Data type: `String`

path to the directory where you will store the repositories.
This does not have to be equal to the $users home directory.
defaults to $userhome

Default value: "${userhome}/repositories"

##### `user`

Data type: `String`

the user to host the git repositories
this user needs a home directory to work with gitolite.

##### `userhome`

Data type: `String`

the home directory of the user

##### `user_ensure`

Data type: `Boolean`

if true, $user will be created, if false, you have
to create the user with the homedirectory elsewhere.
defaults to true

Default value: `true`

##### `umask`

Data type: `String`

see the rc file docs for how/why you might change this
defaults to '0077' which gives perms of '0700'

Default value: '0077'

##### `git_config_keys`

Data type: `String`

look for "git-config" in the documentation
default: '.*'

Default value: '.*'

##### `log_extra`

Data type: `Boolean`

set to true for extra log details
default: false

Default value: `false`

##### `log_dest`

Data type: `Array`

array of log destinations.
available values are:
  normal: normal gitolite logs
  syslog: log to syslog
  repo-log: log just the update records to
            gl-log in the bare repo directory
defaults to ['normal']

Default value: ['normal']

##### `roles`

Data type: `Array`

Array of roles to add.
default: ['READERS', 'WRITERS']

Default value: ['READERS', 'WRITERS']

##### `site_info`

Data type: `Boolean`

the 'info' command prints this as additional info
default to false

Default value: `false`

##### `gitolite_hostname`

Data type: `String`

the hostname, to unset, set to false
defaults to $::hostname

Default value: $::hostname

##### `local_code`

Data type: `String`

suggested locations for site-local gitolite code
defaults to '', no site-local code

Default value: ''

##### `additional_gitoliterc`

Data type: `Hash`

hash of additional lines to add on gitolite.rc file
defaults to empty (beware of "' etc ...)
example:
{ 'CACHE' => '"Redis"' }

Default value: {}

##### `commands`

Data type: `Array`

Array of commands and features to enable
defaults to ['help', 'desc', 'info', 'perms' ]

Default value: [
    'help',
    'desc',
    'info',
    'perms',
    'writable',
    'ssh-authkeys',
    'git-config',
    'daemon',
    'gitweb',
  ]

##### `package_ensure`

Data type: `String`

howto ensure the packages to install

Default value: 'present'

##### `packages`

Data type: `Array`

packages to install for gitolite

Default value: []

##### `additional_packages`

Data type: `Array`

any additional packages you like to install

Default value: []

##### `admin_key_source`

Data type: `String`

provide a admin key source (default to false)

Default value: ''

##### `admin_key`

Data type: `String`

admin key (string) (default to false)

Default value: ''

##### `additional_gitoliterc_notrc`

Data type: `Hash`

hash of additional lines to add on gitolite.rc file
after the rc vars
defaults to empty (beware of "' etc ...)
example:
{ '$REF_OR_FILENAME_PATT' => 'qr(^[0-9a-zA-Z][-0-9a-zA-Z._\@/+ :%,]*$)' }

Default value: {}

##### `fetch_cron`

Data type: `Boolean`

if a cronjob should be established to fetch from remote repos
defaults to false

Default value: `false`

### gitolite::admin

This class manages the gitolite.conf file
and prepares to manage the ssh keys with puppet.

do not use this class if you want to use the
gitolite-admin.git repositoy for these tasks.
(you have been warned ! if you use it once,
there is no puppet way back, only manual work
will get you back)

#### Parameters

The following parameters are available in the `gitolite::admin` class.

##### `remove_admin_repo`

Data type: `Boolean`

if true (the default) the repository
gitoline_admin.git will be removed

Default value: `true`

##### `repos`

Data type: `Hash`

a hash of repos, to be defined

Default value: {}

##### `users`

Data type: `Hash`

a hash of users, to be defined

Default value: {}

##### `add_testing_repo`

Data type: `Boolean`

allow RW+ for all users to the testing repo
default: true

Default value: `true`

### gitolite::client

Class to install git

### gitolite::ssh_key

Generate an SSH authentication key

Key generation for (passwordless) authentication to a
remote system.

#### Parameters

The following parameters are available in the `gitolite::ssh_key` class.

##### `filename`

Data type: `String`

Filename (full path) for the key. Required.

##### `type`

Data type: `String`

Type of key, either dsa, ecdsa or rsa. Defaults to rsa.

Default value: 'rsa'

##### `length`

Data type: `Integer`

Key length. Defaults to 2048. See man ssh-keygen for restrictions
regarding non RSA keys.

Default value: 2048

##### `password`

Data type: `String`

Password for the key. Defaults to no password. This is not very secure
as the password is visible in plain text in the puppet manifest and as a
process parameters when creating the key.

Default value: ''

##### `comment`

Data type: `String`

Comment describing the Key. Defaults to "Automatic authentication key for $user on $fqdn".

Default value: 'undef'

##### `user`

Data type: `String`

User who uses this key. This user must have write access to the directory
containing the key. Defaults to "root"

Default value: 'root'

## Defined types

### gitolite::repo

this resources defines a git repository
you also can use it to define values for a group of
repositories (by using an @ in front of the group name)

#### Parameters

The following parameters are available in the `gitolite::repo` defined type.

##### `repos`

Data type: `Array`

an array of repos (or a group of repos ( @blah )
defaults to [ $title ]

Default value: [$title]

##### `comments`

Data type: `Variant[String, Array]`

an array of comments to add defaults to []

Default value: []

##### `rules`

Data type: `Hash`

an array of rules.
a rule has three elements:
permission, refex and user/group
a hash of permissions:
[{ 'RW+' => 'username'}, ... ]

Default value: {}

##### `options`

Data type: `Hash`



Default value: {}

##### `configs`

Data type: `Hash`



Default value: {}

##### `add_configs`

Data type: `Hash`

additional configs, merged with configs

Default value: {}

##### `groups`

Data type: `Array`

an array of groups to append the repos to
the group names can be prefix with an @ sign
(if they are puppet take care of)

Default value: []

##### `order`

Data type: `String`

string, to order the repos
$order will be prefixed with 60 for the grouping section
and 90 for the repo section.
defaults to ''

Default value: ''

##### `description`

Data type: `String`

a description to add to the repo

Default value: ''

##### `hooks`

Data type: `Hash`

hooks to install

Default value: {}

##### `group`

Data type: `String`



Default value: 'root'

##### `remotes`

Data type: `Hash`

Hash of remote repos to sync branches and tags from
defaults to {}
Example:
'upstream' => {
  'url' => 'https://github.com/openstack/puppet-nova'
  'fetches' => [
    'master:master',
    'refs/tags/*:refs/tags/*',
    'refs/heads/stable/*:refs/heads/stable/*',
  ]
}
will update the master branch, all tags and all branches stable/*
from the remote location mentioned in url.

To remove an upstrem you can set ensure to 'absent'
You can set more than one repo to sync from, but it's up to you
to ensure that no conflicts occur !

Default value: {}

### gitolite::repos

this resource defines a group of repos with defaults

#### Parameters

The following parameters are available in the `gitolite::repos` defined type.

##### `defaults`

Data type: `Hash`

defaults for all generated repos

Default value: {}

##### `repos`

Data type: `Hash`

repos to create see gitolite::repo for parameters

Default value: {}

### gitolite::user

this resources defines a git user
you also can use it to define values for a group of
repositories (by using an @ in front of the group name)

#### Parameters

The following parameters are available in the `gitolite::user` defined type.

##### `user`

Data type: `String`

the user name
defaults to $title

Default value: $title

##### `keys`

Data type: `Array`

array of users ssh keys

Default value: []

##### `key_source`

Data type: `String`

a puppet source to fetch key from

Default value: ''

##### `comments`

Data type: `Variant[Array, String]`

an array of comments to add to this section
defaults to []

Default value: []

##### `groups`

Data type: `Array`

an array of groups to append the user to
the group names can be prefix with an @ sign
(if they are puppet take care of)
defaults to []

Default value: []

##### `order`

Data type: `String`

string, to order the repos
$order will be prefixed with 30 for the grouping section
and 20 for the user section.
defaults to ''

Default value: ''

### gitolite::users

this resource defines a group of users with defaults

#### Parameters

The following parameters are available in the `gitolite::users` defined type.

##### `defaults`

Data type: `Hash`

defaults for all generated users

Default value: {}

##### `users`

Data type: `Hash`

users to create see gitolite::user for parameters

Default value: {}

## Resource types

### gitremote

add a remote to a git repository

#### Properties

The following properties are available in the `gitremote` type.

##### `ensure`

Valid values: present, absent

The basic property that the resource should be in.

Default value: present

##### `url`

the url of the remote repository

##### `fetches`

Array of fetch definitions

#### Parameters

The following parameters are available in the `gitremote` type.

##### `name`

namevar

the title

##### `remotename`

the name of the remote to create

##### `directory`

the the directory the repository is

##### `confowner`

the the owner of the config file

