# coding: utf-8

"""
InfluxDB OSS API Service.

The InfluxDB v2 API provides a programmatic interface for all interactions with InfluxDB. Access the InfluxDB API using the `/api/v2/` endpoint.   # noqa: E501

OpenAPI spec version: 2.0.0
Generated by: https://openapi-generator.tech
"""


from __future__ import absolute_import

import re  # noqa: F401

from influxdb_client.service._base_service import _BaseService


class RestoreService(_BaseService):
    """NOTE: This class is auto generated by OpenAPI Generator.

    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):  # noqa: E501,D401,D403
        """RestoreService - a operation defined in OpenAPI."""
        super().__init__(api_client)

    def post_restore_bucket_id(self, bucket_id, body, **kwargs):  # noqa: E501,D401,D403
        """Overwrite storage metadata for a bucket with shard info from a backup..

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.post_restore_bucket_id(bucket_id, body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str bucket_id: The bucket ID. (required)
        :param str body: Database info serialized as protobuf. (required)
        :param str zap_trace_span: OpenTracing span context
        :param str content_type:
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.post_restore_bucket_id_with_http_info(bucket_id, body, **kwargs)  # noqa: E501
        else:
            (data) = self.post_restore_bucket_id_with_http_info(bucket_id, body, **kwargs)  # noqa: E501
            return data

    def post_restore_bucket_id_with_http_info(self, bucket_id, body, **kwargs):  # noqa: E501,D401,D403
        """Overwrite storage metadata for a bucket with shard info from a backup..

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.post_restore_bucket_id_with_http_info(bucket_id, body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str bucket_id: The bucket ID. (required)
        :param str body: Database info serialized as protobuf. (required)
        :param str zap_trace_span: OpenTracing span context
        :param str content_type:
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        local_var_params, path_params, query_params, header_params, body_params = \
            self._post_restore_bucket_id_prepare(bucket_id, body, **kwargs)  # noqa: E501

        return self.api_client.call_api(
            '/api/v2/restore/bucket/{bucketID}', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=[],
            files={},
            response_type='str',  # noqa: E501
            auth_settings=[],
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats={},
            urlopen_kw=kwargs.get('urlopen_kw', None))

    async def post_restore_bucket_id_async(self, bucket_id, body, **kwargs):  # noqa: E501,D401,D403
        """Overwrite storage metadata for a bucket with shard info from a backup..

        This method makes an asynchronous HTTP request.

        :param async_req bool
        :param str bucket_id: The bucket ID. (required)
        :param str body: Database info serialized as protobuf. (required)
        :param str zap_trace_span: OpenTracing span context
        :param str content_type:
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        local_var_params, path_params, query_params, header_params, body_params = \
            self._post_restore_bucket_id_prepare(bucket_id, body, **kwargs)  # noqa: E501

        return await self.api_client.call_api(
            '/api/v2/restore/bucket/{bucketID}', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=[],
            files={},
            response_type='str',  # noqa: E501
            auth_settings=[],
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats={},
            urlopen_kw=kwargs.get('urlopen_kw', None))

    def _post_restore_bucket_id_prepare(self, bucket_id, body, **kwargs):  # noqa: E501,D401,D403
        local_var_params = locals()

        all_params = ['bucket_id', 'body', 'zap_trace_span', 'content_type']  # noqa: E501
        self._check_operation_params('post_restore_bucket_id', all_params, local_var_params)
        # verify the required parameter 'bucket_id' is set
        if ('bucket_id' not in local_var_params or
                local_var_params['bucket_id'] is None):
            raise ValueError("Missing the required parameter `bucket_id` when calling `post_restore_bucket_id`")  # noqa: E501
        # verify the required parameter 'body' is set
        if ('body' not in local_var_params or
                local_var_params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `post_restore_bucket_id`")  # noqa: E501

        path_params = {}
        if 'bucket_id' in local_var_params:
            path_params['bucketID'] = local_var_params['bucket_id']  # noqa: E501

        query_params = []

        header_params = {}
        if 'zap_trace_span' in local_var_params:
            header_params['Zap-Trace-Span'] = local_var_params['zap_trace_span']  # noqa: E501
        if 'content_type' in local_var_params:
            header_params['Content-Type'] = local_var_params['content_type']  # noqa: E501

        body_params = None
        if 'body' in local_var_params:
            body_params = local_var_params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['text/plain'])  # noqa: E501

        return local_var_params, path_params, query_params, header_params, body_params

    def post_restore_bucket_metadata(self, bucket_metadata_manifest, **kwargs):  # noqa: E501,D401,D403
        """Create a new bucket pre-seeded with shard info from a backup..

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.post_restore_bucket_metadata(bucket_metadata_manifest, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param BucketMetadataManifest bucket_metadata_manifest: Metadata manifest for a bucket. (required)
        :param str zap_trace_span: OpenTracing span context
        :return: RestoredBucketMappings
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.post_restore_bucket_metadata_with_http_info(bucket_metadata_manifest, **kwargs)  # noqa: E501
        else:
            (data) = self.post_restore_bucket_metadata_with_http_info(bucket_metadata_manifest, **kwargs)  # noqa: E501
            return data

    def post_restore_bucket_metadata_with_http_info(self, bucket_metadata_manifest, **kwargs):  # noqa: E501,D401,D403
        """Create a new bucket pre-seeded with shard info from a backup..

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.post_restore_bucket_metadata_with_http_info(bucket_metadata_manifest, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param BucketMetadataManifest bucket_metadata_manifest: Metadata manifest for a bucket. (required)
        :param str zap_trace_span: OpenTracing span context
        :return: RestoredBucketMappings
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        local_var_params, path_params, query_params, header_params, body_params = \
            self._post_restore_bucket_metadata_prepare(bucket_metadata_manifest, **kwargs)  # noqa: E501

        return self.api_client.call_api(
            '/api/v2/restore/bucketMetadata', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=[],
            files={},
            response_type='RestoredBucketMappings',  # noqa: E501
            auth_settings=[],
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats={},
            urlopen_kw=kwargs.get('urlopen_kw', None))

    async def post_restore_bucket_metadata_async(self, bucket_metadata_manifest, **kwargs):  # noqa: E501,D401,D403
        """Create a new bucket pre-seeded with shard info from a backup..

        This method makes an asynchronous HTTP request.

        :param async_req bool
        :param BucketMetadataManifest bucket_metadata_manifest: Metadata manifest for a bucket. (required)
        :param str zap_trace_span: OpenTracing span context
        :return: RestoredBucketMappings
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        local_var_params, path_params, query_params, header_params, body_params = \
            self._post_restore_bucket_metadata_prepare(bucket_metadata_manifest, **kwargs)  # noqa: E501

        return await self.api_client.call_api(
            '/api/v2/restore/bucketMetadata', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=[],
            files={},
            response_type='RestoredBucketMappings',  # noqa: E501
            auth_settings=[],
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats={},
            urlopen_kw=kwargs.get('urlopen_kw', None))

    def _post_restore_bucket_metadata_prepare(self, bucket_metadata_manifest, **kwargs):  # noqa: E501,D401,D403
        local_var_params = locals()

        all_params = ['bucket_metadata_manifest', 'zap_trace_span']  # noqa: E501
        self._check_operation_params('post_restore_bucket_metadata', all_params, local_var_params)
        # verify the required parameter 'bucket_metadata_manifest' is set
        if ('bucket_metadata_manifest' not in local_var_params or
                local_var_params['bucket_metadata_manifest'] is None):
            raise ValueError("Missing the required parameter `bucket_metadata_manifest` when calling `post_restore_bucket_metadata`")  # noqa: E501

        path_params = {}

        query_params = []

        header_params = {}
        if 'zap_trace_span' in local_var_params:
            header_params['Zap-Trace-Span'] = local_var_params['zap_trace_span']  # noqa: E501

        body_params = None
        if 'bucket_metadata_manifest' in local_var_params:
            body_params = local_var_params['bucket_metadata_manifest']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        return local_var_params, path_params, query_params, header_params, body_params

    def post_restore_kv(self, body, **kwargs):  # noqa: E501,D401,D403
        """Overwrite the embedded KV store on the server with a backed-up snapshot..

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.post_restore_kv(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param file body: Full KV snapshot. (required)
        :param str zap_trace_span: OpenTracing span context
        :param str content_encoding: The value tells InfluxDB what compression is applied to the line protocol in the request payload. To make an API request with a GZIP payload, send `Content-Encoding: gzip` as a request header.
        :param str content_type:
        :return: PostRestoreKVResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.post_restore_kv_with_http_info(body, **kwargs)  # noqa: E501
        else:
            (data) = self.post_restore_kv_with_http_info(body, **kwargs)  # noqa: E501
            return data

    def post_restore_kv_with_http_info(self, body, **kwargs):  # noqa: E501,D401,D403
        """Overwrite the embedded KV store on the server with a backed-up snapshot..

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.post_restore_kv_with_http_info(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param file body: Full KV snapshot. (required)
        :param str zap_trace_span: OpenTracing span context
        :param str content_encoding: The value tells InfluxDB what compression is applied to the line protocol in the request payload. To make an API request with a GZIP payload, send `Content-Encoding: gzip` as a request header.
        :param str content_type:
        :return: PostRestoreKVResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        local_var_params, path_params, query_params, header_params, body_params = \
            self._post_restore_kv_prepare(body, **kwargs)  # noqa: E501

        return self.api_client.call_api(
            '/api/v2/restore/kv', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=[],
            files={},
            response_type='PostRestoreKVResponse',  # noqa: E501
            auth_settings=[],
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats={},
            urlopen_kw=kwargs.get('urlopen_kw', None))

    async def post_restore_kv_async(self, body, **kwargs):  # noqa: E501,D401,D403
        """Overwrite the embedded KV store on the server with a backed-up snapshot..

        This method makes an asynchronous HTTP request.

        :param async_req bool
        :param file body: Full KV snapshot. (required)
        :param str zap_trace_span: OpenTracing span context
        :param str content_encoding: The value tells InfluxDB what compression is applied to the line protocol in the request payload. To make an API request with a GZIP payload, send `Content-Encoding: gzip` as a request header.
        :param str content_type:
        :return: PostRestoreKVResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        local_var_params, path_params, query_params, header_params, body_params = \
            self._post_restore_kv_prepare(body, **kwargs)  # noqa: E501

        return await self.api_client.call_api(
            '/api/v2/restore/kv', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=[],
            files={},
            response_type='PostRestoreKVResponse',  # noqa: E501
            auth_settings=[],
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats={},
            urlopen_kw=kwargs.get('urlopen_kw', None))

    def _post_restore_kv_prepare(self, body, **kwargs):  # noqa: E501,D401,D403
        local_var_params = locals()

        all_params = ['body', 'zap_trace_span', 'content_encoding', 'content_type']  # noqa: E501
        self._check_operation_params('post_restore_kv', all_params, local_var_params)
        # verify the required parameter 'body' is set
        if ('body' not in local_var_params or
                local_var_params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `post_restore_kv`")  # noqa: E501

        path_params = {}

        query_params = []

        header_params = {}
        if 'zap_trace_span' in local_var_params:
            header_params['Zap-Trace-Span'] = local_var_params['zap_trace_span']  # noqa: E501
        if 'content_encoding' in local_var_params:
            header_params['Content-Encoding'] = local_var_params['content_encoding']  # noqa: E501
        if 'content_type' in local_var_params:
            header_params['Content-Type'] = local_var_params['content_type']  # noqa: E501

        body_params = None
        if 'body' in local_var_params:
            body_params = local_var_params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['text/plain'])  # noqa: E501

        return local_var_params, path_params, query_params, header_params, body_params

    def post_restore_shard_id(self, shard_id, body, **kwargs):  # noqa: E501,D401,D403
        """Restore a TSM snapshot into a shard..

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.post_restore_shard_id(shard_id, body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str shard_id: The shard ID. (required)
        :param file body: TSM snapshot. (required)
        :param str zap_trace_span: OpenTracing span context
        :param str content_encoding: The value tells InfluxDB what compression is applied to the line protocol in the request payload. To make an API request with a GZIP payload, send `Content-Encoding: gzip` as a request header.
        :param str content_type:
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.post_restore_shard_id_with_http_info(shard_id, body, **kwargs)  # noqa: E501
        else:
            (data) = self.post_restore_shard_id_with_http_info(shard_id, body, **kwargs)  # noqa: E501
            return data

    def post_restore_shard_id_with_http_info(self, shard_id, body, **kwargs):  # noqa: E501,D401,D403
        """Restore a TSM snapshot into a shard..

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.post_restore_shard_id_with_http_info(shard_id, body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str shard_id: The shard ID. (required)
        :param file body: TSM snapshot. (required)
        :param str zap_trace_span: OpenTracing span context
        :param str content_encoding: The value tells InfluxDB what compression is applied to the line protocol in the request payload. To make an API request with a GZIP payload, send `Content-Encoding: gzip` as a request header.
        :param str content_type:
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        local_var_params, path_params, query_params, header_params, body_params = \
            self._post_restore_shard_id_prepare(shard_id, body, **kwargs)  # noqa: E501

        return self.api_client.call_api(
            '/api/v2/restore/shards/{shardID}', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=[],
            files={},
            response_type=None,  # noqa: E501
            auth_settings=[],
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats={},
            urlopen_kw=kwargs.get('urlopen_kw', None))

    async def post_restore_shard_id_async(self, shard_id, body, **kwargs):  # noqa: E501,D401,D403
        """Restore a TSM snapshot into a shard..

        This method makes an asynchronous HTTP request.

        :param async_req bool
        :param str shard_id: The shard ID. (required)
        :param file body: TSM snapshot. (required)
        :param str zap_trace_span: OpenTracing span context
        :param str content_encoding: The value tells InfluxDB what compression is applied to the line protocol in the request payload. To make an API request with a GZIP payload, send `Content-Encoding: gzip` as a request header.
        :param str content_type:
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        local_var_params, path_params, query_params, header_params, body_params = \
            self._post_restore_shard_id_prepare(shard_id, body, **kwargs)  # noqa: E501

        return await self.api_client.call_api(
            '/api/v2/restore/shards/{shardID}', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=[],
            files={},
            response_type=None,  # noqa: E501
            auth_settings=[],
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats={},
            urlopen_kw=kwargs.get('urlopen_kw', None))

    def _post_restore_shard_id_prepare(self, shard_id, body, **kwargs):  # noqa: E501,D401,D403
        local_var_params = locals()

        all_params = ['shard_id', 'body', 'zap_trace_span', 'content_encoding', 'content_type']  # noqa: E501
        self._check_operation_params('post_restore_shard_id', all_params, local_var_params)
        # verify the required parameter 'shard_id' is set
        if ('shard_id' not in local_var_params or
                local_var_params['shard_id'] is None):
            raise ValueError("Missing the required parameter `shard_id` when calling `post_restore_shard_id`")  # noqa: E501
        # verify the required parameter 'body' is set
        if ('body' not in local_var_params or
                local_var_params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `post_restore_shard_id`")  # noqa: E501

        path_params = {}
        if 'shard_id' in local_var_params:
            path_params['shardID'] = local_var_params['shard_id']  # noqa: E501

        query_params = []

        header_params = {}
        if 'zap_trace_span' in local_var_params:
            header_params['Zap-Trace-Span'] = local_var_params['zap_trace_span']  # noqa: E501
        if 'content_encoding' in local_var_params:
            header_params['Content-Encoding'] = local_var_params['content_encoding']  # noqa: E501
        if 'content_type' in local_var_params:
            header_params['Content-Type'] = local_var_params['content_type']  # noqa: E501

        body_params = None
        if 'body' in local_var_params:
            body_params = local_var_params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['text/plain'])  # noqa: E501

        return local_var_params, path_params, query_params, header_params, body_params

    def post_restore_sql(self, body, **kwargs):  # noqa: E501,D401,D403
        """Overwrite the embedded SQL store on the server with a backed-up snapshot..

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.post_restore_sql(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param file body: Full SQL snapshot. (required)
        :param str zap_trace_span: OpenTracing span context
        :param str content_encoding: The value tells InfluxDB what compression is applied to the line protocol in the request payload. To make an API request with a GZIP payload, send `Content-Encoding: gzip` as a request header.
        :param str content_type:
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.post_restore_sql_with_http_info(body, **kwargs)  # noqa: E501
        else:
            (data) = self.post_restore_sql_with_http_info(body, **kwargs)  # noqa: E501
            return data

    def post_restore_sql_with_http_info(self, body, **kwargs):  # noqa: E501,D401,D403
        """Overwrite the embedded SQL store on the server with a backed-up snapshot..

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.post_restore_sql_with_http_info(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param file body: Full SQL snapshot. (required)
        :param str zap_trace_span: OpenTracing span context
        :param str content_encoding: The value tells InfluxDB what compression is applied to the line protocol in the request payload. To make an API request with a GZIP payload, send `Content-Encoding: gzip` as a request header.
        :param str content_type:
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        local_var_params, path_params, query_params, header_params, body_params = \
            self._post_restore_sql_prepare(body, **kwargs)  # noqa: E501

        return self.api_client.call_api(
            '/api/v2/restore/sql', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=[],
            files={},
            response_type=None,  # noqa: E501
            auth_settings=[],
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats={},
            urlopen_kw=kwargs.get('urlopen_kw', None))

    async def post_restore_sql_async(self, body, **kwargs):  # noqa: E501,D401,D403
        """Overwrite the embedded SQL store on the server with a backed-up snapshot..

        This method makes an asynchronous HTTP request.

        :param async_req bool
        :param file body: Full SQL snapshot. (required)
        :param str zap_trace_span: OpenTracing span context
        :param str content_encoding: The value tells InfluxDB what compression is applied to the line protocol in the request payload. To make an API request with a GZIP payload, send `Content-Encoding: gzip` as a request header.
        :param str content_type:
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        local_var_params, path_params, query_params, header_params, body_params = \
            self._post_restore_sql_prepare(body, **kwargs)  # noqa: E501

        return await self.api_client.call_api(
            '/api/v2/restore/sql', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=[],
            files={},
            response_type=None,  # noqa: E501
            auth_settings=[],
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats={},
            urlopen_kw=kwargs.get('urlopen_kw', None))

    def _post_restore_sql_prepare(self, body, **kwargs):  # noqa: E501,D401,D403
        local_var_params = locals()

        all_params = ['body', 'zap_trace_span', 'content_encoding', 'content_type']  # noqa: E501
        self._check_operation_params('post_restore_sql', all_params, local_var_params)
        # verify the required parameter 'body' is set
        if ('body' not in local_var_params or
                local_var_params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `post_restore_sql`")  # noqa: E501

        path_params = {}

        query_params = []

        header_params = {}
        if 'zap_trace_span' in local_var_params:
            header_params['Zap-Trace-Span'] = local_var_params['zap_trace_span']  # noqa: E501
        if 'content_encoding' in local_var_params:
            header_params['Content-Encoding'] = local_var_params['content_encoding']  # noqa: E501
        if 'content_type' in local_var_params:
            header_params['Content-Type'] = local_var_params['content_type']  # noqa: E501

        body_params = None
        if 'body' in local_var_params:
            body_params = local_var_params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['text/plain'])  # noqa: E501

        return local_var_params, path_params, query_params, header_params, body_params
