/***************************************************************************
 *   Copyright (C) 2007 by Anistratov Oleg                                 *
 *   ower86@gmail.com                                                      *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License version 2        *
 *   as published by the Free Software Foundation;                         *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 ***************************************************************************/
#ifndef LOGIN2SERVERDLG_H
#define LOGIN2SERVERDLG_H

#include <QDialog>
#include <QLabel>
#include <QLineEdit>
#include <QPushButton>
#include <QEvent>
#include <QHostAddress>
#include <QComboBox>

#include "qchatsettings.h"

/**
	@author Anistratov Oleg <ower86@gmail.com>
*/
class Login2ServerDlg : public QDialog
{
  Q_OBJECT
  private:
//     QLineEdit*   m_ipEdit;
//     QLineEdit*   m_loginEdit;

    QComboBox*   m_ipCmbx;
    QComboBox*   m_loginCmbx;

    QPushButton* m_loginBtn;
    QPushButton* m_abortBtn;
    QLabel*      m_ipLab;
    QLabel*      m_loginLab;
    QStringList* m_lastServers;
    QStringList* m_lastLogins;
    QLabel*      m_descriptionLab;

    bool         m_finished;

  public:
    Login2ServerDlg(QStringList*, QStringList*, QWidget *parent = 0, const QString& = "", const QString& = "");
    ~Login2ServerDlg();

    void retranslate();

  protected:
    void changeEvent(QEvent *ev)
    {
      if(ev->type() == QEvent::LanguageChange)
        retranslate();
      else
        QWidget::changeEvent(ev);
    }

  public slots:
    void slot_login();
    void abort();
    void loginRejected(const QString&);
    void loginAccepted(const QString&);
    void loginFinished(int, const QString&);

  signals:
    void wantLogin(const QHostAddress&, const QString&);
    void wantAbort();
    void loginSuccessful();

};

#endif
