% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plots.R
\name{plotInfReps}
\alias{plotInfReps}
\title{Plot inferential replicates for a gene or transcript}
\usage{
plotInfReps(
  y,
  idx,
  x,
  cov = NULL,
  colsDrk = c("dodgerblue", "goldenrod4", "royalblue4", "red3", "purple4", "darkgreen"),
  colsLgt = c("lightblue1", "goldenrod1", "royalblue1", "salmon1", "orchid1",
    "limegreen"),
  xaxis,
  xlab,
  ylim,
  main,
  mainCol,
  legend = FALSE,
  legendPos = "topleft",
  legendTitle = FALSE,
  legendCex = 1,
  useMean = TRUE,
  q = qnorm(0.975),
  applySF = FALSE,
  reorder,
  thin
)
}
\arguments{
\item{y}{a SummarizedExperiment (see \code{swish})}

\item{idx}{the name or row number of the gene or transcript}

\item{x}{the name of the condition variable for splitting
and coloring the samples or cells. Also can be a numeric,
e.g. pseudotime, in which case, \code{cov} can be used
to designate groups for coloring}

\item{cov}{the name of the covariate for adjustment}

\item{colsDrk}{dark colors for the lines of the boxes}

\item{colsLgt}{light colors for the inside of the boxes}

\item{xaxis}{logical, whether to label the sample numbers.
default is \code{TRUE} if there are less than 30 samples}

\item{xlab}{the x-axis label}

\item{ylim}{y limits}

\item{main}{title}

\item{mainCol}{name of metadata column to use for title
(instead of rowname)}

\item{legend}{logical, show simple legend (default FALSE)}

\item{legendPos}{character, position of the legend (default "topleft")}

\item{legendTitle}{logical, whether to add the name of the
grouping variable as a title on the legend (default FALSE)}

\item{legendCex}{numeric, size of the legend (default 1)}

\item{useMean}{logical, when inferential replicates
are not present or when \code{x} is continuous,
whether to use the \code{mean} assay or the
\code{counts} assay for plotting}

\item{q}{numeric, the quantile to use when plotting
the intervals when inferential replicates are not
present or when \code{x} is continuous. Default
is \code{qnorm(.975) ~= 1.96} corresponding to 95%
intervals}

\item{applySF}{logical, when inferential replicates are
not present, should \code{y$sizeFactor} be divided out
from the mean and interval plots (default FALSE)}

\item{reorder}{logical, should points within a group
defined by condition and covariate be re-ordered by
their count value (default is FALSE, except for alevin data)}

\item{thin}{integer, should the mean and interval lines
be drawn thin (the default switches from 0 [not thin]
to 1 [thinner] at n=150 cells, and from 1 [thinner]
to 2 [thinnest] at n=400 cells)}
}
\value{
nothing, a plot is displayed
}
\description{
For datasets with inferential replicates, boxplots are
drawn for the two groups and potentially grouped by
covariates. For datasets with only mean and variance,
points and intervals (95% intervals using Normal
approximation) are drawn. Additionally, for numeric
\code{x} values, points and intervals will be drawn
and \code{\link{computeInfRV}} should be run first
in order to add the mean and variance statistics.
}
\examples{

y <- makeSimSwishData()
plotInfReps(y, 3, "condition")

y <- makeSimSwishData(n=40)
y$batch <- factor(rep(c(1,2,3,1,2,3),c(5,10,5,5,10,5)))
plotInfReps(y, 3, "condition", "batch")

}
