% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/704-calcProtSeqSim.R
\name{calcParProtSeqSim}
\alias{calcParProtSeqSim}
\title{Parallellized Protein Sequence Similarity Calculation based on Sequence Alignment}
\usage{
calcParProtSeqSim(protlist, cores = 2, type = "local",
  submat = "BLOSUM62")
}
\arguments{
\item{protlist}{A length \code{n} list containing \code{n} protein sequences,
each component of the list is a character string,
storing one protein sequence. Unknown sequences should be represented as
\code{''}.}

\item{cores}{Integer. The number of CPU cores to use for parallel execution,
default is \code{2}. Users could use the \code{detectCores()} function
in the \code{parallel} package to see how many cores they could use.}

\item{type}{Type of alignment, default is \code{'local'},
could be \code{'global'} or \code{'local'},
where \code{'global'} represents Needleman-Wunsch global alignment;
\code{'local'} represents Smith-Waterman local alignment.}

\item{submat}{Substitution matrix, default is \code{'BLOSUM62'},
could be one of \code{'BLOSUM45'}, \code{'BLOSUM50'}, \code{'BLOSUM62'},
\code{'BLOSUM80'}, \code{'BLOSUM100'}, \code{'PAM30'}, \code{'PAM40'},
\code{'PAM70'}, \code{'PAM120'}, \code{'PAM250'}.}
}
\value{
A \code{n} x \code{n} similarity matrix.
}
\description{
Parallellized Protein Sequence Similarity Calculation based on Sequence Alignment
}
\details{
This function implemented the parallellized version for calculating
protein sequence similarity based on sequence alignment.
}
\examples{
s1 = readFASTA(system.file('protseq/P00750.fasta', package = 'Rcpi'))[[1]]
s2 = readFASTA(system.file('protseq/P08218.fasta', package = 'Rcpi'))[[1]]
s3 = readFASTA(system.file('protseq/P10323.fasta', package = 'Rcpi'))[[1]]
s4 = readFASTA(system.file('protseq/P20160.fasta', package = 'Rcpi'))[[1]]
s5 = readFASTA(system.file('protseq/Q9NZP8.fasta', package = 'Rcpi'))[[1]]
plist = list(s1, s2, s3, s4, s5)
\donttest{
psimmat = calcParProtSeqSim(plist, cores = 2, type = 'local',
                            submat = 'BLOSUM62')
print(psimmat)}
}
\seealso{
See \code{calcTwoProtSeqSim} for protein sequence alignment
for two protein sequences. See \code{\link{calcParProtGOSim}} for
protein similarity calculation based on
Gene Ontology (GO) semantic similarity.
}
\author{
Nan Xiao <\url{https://nanx.me}>
}
\keyword{Needleman-Wunsch}
\keyword{Smith-Waterman}
\keyword{alignment}
\keyword{calcParProtSeqSim}
\keyword{global}
\keyword{local}
\keyword{parallel}
\keyword{sequence}
\keyword{similarity}
