% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/checkDisjunct.R
\name{checkDisjunct}
\alias{checkDisjunct}
\alias{check_disjunct}
\alias{assertDisjunct}
\alias{assert_disjunct}
\alias{testDisjunct}
\alias{test_disjunct}
\alias{expect_disjunct}
\title{Check if an argument is disjunct from a given set}
\usage{
checkDisjunct(x, y, fmatch = FALSE)

check_disjunct(x, y, fmatch = FALSE)

assertDisjunct(x, y, fmatch = FALSE, .var.name = vname(x), add = NULL)

assert_disjunct(x, y, fmatch = FALSE, .var.name = vname(x), add = NULL)

testDisjunct(x, y, fmatch = FALSE)

test_disjunct(x, y, fmatch = FALSE)

expect_disjunct(x, y, fmatch = FALSE, info = NULL, label = vname(x))
}
\arguments{
\item{x}{[any]\cr
Object to check.}

\item{y}{[\code{atomic}]\cr
Other Set.}

\item{fmatch}{[\code{logical(1)}]\cr
Use the set operations implemented in \code{\link[fastmatch]{fmatch}} in package \pkg{fastmatch}.
If \pkg{fastmatch} is not installed, this silently falls back to \code{\link[base]{match}}.
\code{\link[fastmatch]{fmatch}} modifies \code{y} by reference:
A hash table is added as attribute which is used in subsequent calls.}

\item{.var.name}{[\code{character(1)}]\cr
Name of the checked object to print in assertions. Defaults to
the heuristic implemented in \code{\link{vname}}.}

\item{add}{[\code{AssertCollection}]\cr
Collection to store assertion messages. See \code{\link{AssertCollection}}.}

\item{info}{[character(1)]\cr
Extra information to be included in the message for the testthat reporter.
See \code{\link[testthat]{expect_that}}.}

\item{label}{[\code{character(1)}]\cr
Name of the checked object to print in messages. Defaults to
the heuristic implemented in \code{\link{vname}}.}
}
\value{
Depending on the function prefix:
 If the check is successful, the functions 
 \code{assertDisjunct}/\code{assert_disjunct} return 
 \code{x} invisibly, whereas
 \code{checkDisjunct}/\code{check_disjunct} and 
 \code{testDisjunct}/\code{test_disjunct} return 
 \code{TRUE}.
 If the check is not successful, 
 \code{assertDisjunct}/\code{assert_disjunct}
 throws an error message, 
 \code{testDisjunct}/\code{test_disjunct}
 returns \code{FALSE},
 and \code{checkDisjunct} returns a string with the error message.
 The function \code{expect_disjunct} always returns an
 \code{\link[testthat]{expectation}}.
}
\description{
Check if an argument is disjunct from a given set
}
\note{
The object \code{x} must be of the same type as the set w.r.t. \code{\link[base]{typeof}}.
Integers and doubles are both treated as numeric.
}
\examples{
testDisjunct(1L, letters)
testDisjunct(c("a", "z"), letters)

# x is not converted before the comparison (except for numerics)
testDisjunct(factor("a"), "a")
testDisjunct(1, "1")
testDisjunct(1, as.integer(1))
}
\seealso{
Other set: 
\code{\link{checkChoice}()},
\code{\link{checkSetEqual}()},
\code{\link{checkSubset}()}
}
\concept{set}
