% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dplyr.r
\docType{package}
\name{dplyr-package}
\alias{dplyr}
\alias{dplyr-package}
\title{dplyr: a grammar of data manipulation}
\description{
dplyr provides a flexible grammar of data manipulation. It's the next
iteration of plyr, focused on tools for working with data frames (hence the
\emph{d} in the name).
}
\details{
It has three main goals:

\itemize{
\item Identify the most important data manipulation verbs and make them
easy to use from R.
\item Provide blazing fast performance for in-memory data by writing key
pieces in C++ (using Rcpp)
\item Use the same interface to work with data no matter where it's stored,
whether in a data frame, a data table or database.
}

To learn more about dplyr, start with the vignettes:
\code{browseVignettes(package = "dplyr")}
}
\section{Package options}{

\describe{
\item{\code{dplyr.show_progress}}{Should lengthy operations such as \code{do()}
show a progress bar? Default: \code{TRUE}}
}
}

\section{Package configurations}{

These can be set on a package-by-package basis, or for the global environment.
See \code{\link[pkgconfig:set_config]{pkgconfig::set_config()}} for usage.
\describe{
\item{\code{dplyr::na_matches}}{Should \code{NA} values be matched in data frame joins
by default? Default: \code{"na"} (for compatibility with dplyr v0.5.0 and earlier,
subject to change), alternative value: \code{"never"} (the default
for database backends, see \code{\link[=join.tbl_df]{join.tbl_df()}}).}
}
}

\seealso{
Useful links:
\itemize{
  \item \url{http://dplyr.tidyverse.org}
  \item \url{https://github.com/tidyverse/dplyr}
  \item Report bugs at \url{https://github.com/tidyverse/dplyr/issues}
}

}
\author{
\strong{Maintainer}: Hadley Wickham \email{hadley@rstudio.com}

Authors:
\itemize{
  \item Romain Francois \email{romain@r-enthusiasts.com}
  \item Lionel Henry
  \item Kirill Müller
}

Other contributors:
\itemize{
  \item RStudio [copyright holder, funder]
}

}
