% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/limits.r
\name{lims}
\alias{lims}
\alias{xlim}
\alias{ylim}
\title{Set scale limits}
\usage{
lims(...)

xlim(...)

ylim(...)
}
\arguments{
\item{...}{A name-value pair. The name must be an aesthetic, and the value
must be either a length-2 numeric, a character, a factor, or a date/time.

A numeric value will create a continuous scale. If the larger value
comes first, the scale will be reversed. You can leave one value as
\code{NA} to compute from the range of the data.

A character or factor value will create a discrete scale.

A date-time value will create a continuous date/time scale.}
}
\description{
This is a shortcut for supplying the \code{limits} argument to the
individual scales. Note that, by default, any values outside the limits
will be replaced with \code{NA}.
}
\examples{
# Zoom into a specified area
ggplot(mtcars, aes(mpg, wt)) +
  geom_point() +
  xlim(15, 20)

# reverse scale
ggplot(mtcars, aes(mpg, wt)) +
  geom_point() +
  xlim(20, 15)

# with automatic lower limit
ggplot(mtcars, aes(mpg, wt)) +
  geom_point() +
  xlim(NA, 20)

# You can also supply limits that are larger than the data.
# This is useful if you want to match scales across different plots
small <- subset(mtcars, cyl == 4)
big <- subset(mtcars, cyl > 4)

ggplot(small, aes(mpg, wt, colour = factor(cyl))) +
  geom_point() +
  lims(colour = c("4", "6", "8"))

ggplot(big, aes(mpg, wt, colour = factor(cyl))) +
  geom_point() +
  lims(colour = c("4", "6", "8"))
}
\seealso{
For changing x or y axis limits \strong{without} dropping data
observations, see \code{\link[=coord_cartesian]{coord_cartesian()}}. To expand the range of
a plot to always include certain values, see \code{\link[=expand_limits]{expand_limits()}}.
}
