% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/regression.R
\name{rmsle}
\alias{rmsle}
\title{Root Mean Squared Log Error}
\usage{
rmsle(actual, predicted)
}
\arguments{
\item{actual}{The ground truth non-negative vector}

\item{predicted}{The predicted non-negative vector, where each element in the vector
is a prediction for the corresponding element in \code{actual}.}
}
\description{
\code{rmsle} computes the root mean squared log error between two numeric vectors.
}
\details{
\code{rmsle} adds one to both \code{actual} and \code{predicted} before taking
the natural logarithm to avoid taking the natural log of zero. As a result,
the function can be used if \code{actual} or \code{predicted} have zero-valued
elements. But this function is not appropriate if either are negative valued.
}
\examples{
actual <- c(1.1, 1.9, 3.0, 4.4, 5.0, 5.6)
predicted <- c(0.9, 1.8, 2.5, 4.5, 5.0, 6.2)
rmsle(actual, predicted)
}
\seealso{
\code{\link{msle}} \code{\link{sle}}
}
