% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compare.R
\name{vec_compare}
\alias{vec_compare}
\title{Compare two vectors}
\usage{
vec_compare(x, y, na_equal = FALSE, .ptype = NULL)
}
\arguments{
\item{x, y}{Vectors with compatible types and lengths.}

\item{na_equal}{Should \code{NA} values be considered equal?}

\item{.ptype}{Override to optionally specify common type}
}
\value{
An integer vector with values -1 for \code{x < y}, 0 if \code{x == y},
and 1 if \code{x > y}. If \code{na_equal} is \code{FALSE}, the result will be \code{NA}
if either \code{x} or \code{y} is \code{NA}.
}
\description{
Compare two vectors
}
\section{S3 dispatch}{

\code{vec_compare()} is not generic for performance; instead it uses
\code{\link[=vec_proxy_compare]{vec_proxy_compare()}} to
}

\examples{
vec_compare(c(TRUE, FALSE, NA), FALSE)
vec_compare(c(TRUE, FALSE, NA), FALSE, na_equal = TRUE)

vec_compare(1:10, 5)
vec_compare(runif(10), 0.5)
vec_compare(letters[1:10], "d")

df <- data.frame(x = c(1, 1, 1, 2), y = c(0, 1, 2, 1))
vec_compare(df, data.frame(x = 1, y = 1))
}
