#!/bin/bash
#
# apache_nettemp.sh
#
# Setup a network template and RC role and type for apache networking control
#

net_temp new_template 2000 "HTTP Local"
net_temp set_address_family 2000 INET
net_temp set_type 2000 STREAM
net_temp set_address 2000 0.0.0.0
net_temp set_valid_len 2000 0
net_temp set_protocol 2000 TCP
net_temp set_netdev 2000 ""
net_temp set_min_port 2000 80
net_temp set_max_port 2000 80

rc_set_item TYPE 4 type_netobj_name "HTTP local"

rc_set_item ROLE 5 name "Webserver"
rc_set_item -b ROLE 5 type_comp_fd 0 0000000000000001110100000011011010010111111110110100
rc_set_item -b ROLE 5 type_comp_dev 0 0000000000000000110000000000011010000000000010000100
rc_set_item -b ROLE 5 type_comp_ipc 0 0000000000000000110000000000011010010001101110011110
rc_set_item -b ROLE 5 type_comp_scd 5 1111000000000001011000111000100101111001100000000001
rc_set_item -b ROLE 5 type_comp_scd 12 0000000000000000000000000000000000000001000000000000
rc_set_item -b ROLE 5 type_comp_process 0 0000000000000000000011000100000000000000000101011000
rc_set_item -b ROLE 5 type_comp_netdev 0 0000000000000010000000000000000000000001000000000000
rc_set_item -b ROLE 5 type_comp_netobj 0 0000000001111000010000000000000010000000000100000000
rc_set_item -b ROLE 5 type_comp_netobj 4 0000000010000110000000000000000000000000000110000000
rc_set_item ROLE 5 def_fd_create_type 4294967294
rc_set_item ROLE 5 def_process_create_type 4294967294
rc_set_item ROLE 5 def_process_chown_type 4294967291
rc_set_item ROLE 5 def_process_execute_type 4294967295
rc_set_item ROLE 5 def_ipc_create_type 0

attr_set_net NETTEMP rc_type 4 2000

attr_set_file_dir FILE /usr/sbin/httpd rc_force_role 5
