#
# SchoolTool - common information systems platform for school administration
# Copyright (c) 2013 Shuttleworth Foundation
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.
#
"""
Evolve database to generation 9.

Sets cache for URIObjects.
"""

from zope.app.generations.utility import getRootFolder
from zope.component.hooks import getSite, setSite

from schooltool.app.interfaces import ISchoolToolApplication

from schooltool.intervention.intervention import URIAtOneTime
from schooltool.intervention.intervention import URIContact
from schooltool.intervention.intervention import URICreator
from schooltool.intervention.intervention import URIGoal
from schooltool.intervention.intervention import URIMessage
from schooltool.intervention.intervention import URIResponsible


def requireURICache(app):
    cache = app['schooltool.relationship.uri']
    standard_uris = [
        URIAtOneTime,
        URIContact,
        URICreator,
        URIGoal,
        URIMessage,
        URIResponsible,
        ]
    for uri in standard_uris:
        cache.cache(uri)


def evolve(context):
    root = getRootFolder(context)
    old_site = getSite()

    assert ISchoolToolApplication.providedBy(root)
    setSite(root)

    requireURICache(root)
    setSite(old_site)
