9.1 Fundamentos de Live Coding 

# Live Coding

Ya sabemos lo suficiente para comenzar a divertirnos en serio. En esta
sección te mostraré cómo comenzar a crear composiciones musicales en vivo
y convertirlas en ejecuciones. Para ello necesitamos 3 ingredientes:

* Habilidad para escribir código que haga sonidos - CHECK!
* Habilidad de escribir funciones - CHECK!
* Hbilidad de usar hilos (nominales) - CHECK!

¡Muy bien, comencemos! Hagamos nuestros primeros sonidos de códigos en vivo
Primero necesitamos una función conteniendo el código que necesitamos tocar
Comencemos con algo simple. También necesitamos llamadas en bucle a esa 
función en un hilo:
```
define :my_loop do
  play 50
  sleep 1
end

in_thread(name: :looper) do
  loop do
    my_loop
  end
end
```

Si te parece complicado, vuelve a leer las secciones de funciones e hilos.
No es tan complicado una vez entiendes bien esos conceptos.

Lo que tenemos es una función que toca la nota 50 y duerme por un pulso. 
Después definimos un hilo llamado `:looper` que bucle llamando `my_loop` 
repetidamente.

Si corres este código, escucharás la nota 50 una y otra vez...

## ¡Cambiandolo al vuelo!

Aquí es donde comienza la diversión. Mientras el código *aún corre*
cambia 50 a otro número, digamos 55, y presiona Run otra vez. ¡Woah!
¡cambió en vivo!

No añadió una nueva capa porque usamos hilos nombrados, los que sólo 
permiten un hilo por cada nombre. El sonido cambió porque *redefinimos*
la función. LE dimos a `:my_loop`una nueva definición. CUando el hilo
`:looper` bucleó, simplemente llamó la nueva definición.

Sigue cambiándolo, cambia la nora, el tiempo de pausa. ¿qué tal añadir un
`use_synth`? Por ejemplo, esto:

```
define :my_loop do
  use_synth :tb303
  play 50, release: 0.3
  sleep 0.25
end
```
Ahora suena interesante, pero podemos mejorarlo, aún. En vez de tocar la
misma nota, hagámoslo con un acorde:

```
define :my_loop do
  use_synth :tb303
  play chord(:e3, :minor), release: 0.3
  sleep 0.5
end
```

¿tocamos notas del acorde al azar?:

```
define :my_loop do
  use_synth :tb303
  play choose(chord(:e3, :minor)), release: 0.3
  sleep 0.25
end
```

o usando un valor de corte al azar:

```
define :my_loop do
  use_synth :tb303
  play choose(chord(:e3, :minor)), release: 0.2, cutoff: rrand(60, 130)
  sleep 0.25
end
```

Al final, añadamos un poco de batería:

```
define :my_loop do
  use_synth :tb303
  sample :drum_bass_hard, rate: rrand(0.5, 2)
  play choose(chord(:e3, :minor)), release: 0.2, cutoff: rrand(60, 130)
  sleep 0.25
end
```

¡Ahora está volviéndose excitante! 

Sin embargo, antes de saltar y comenzar a Live Coding con funciones e 
hilos, lee la próxima sección sobre `live_loop` que cambiará la manera 
en la que codifiques con Sonic Pi para siempre...
