5.1 Bloki kodu

# Bloki kodu

Struktura, którą będzie Ci dane zobaczyć w Sonic Pi niezwykle często 
to blok kodu. Bloki pozwalają nam na robienie wielu przydatnych rzeczy 
z dużymi kawałkami kodu. Na przykład, w przypadku parametrów syntezatorów 
i sampli byliśmy w stanie zmieniać coś co działo się w obrębie jednej linii. 
Jednakże, czasami chcielibyśmy zrobić coś znaczącego dla kilku linii kodu. 
Na przykład, chcielibyśmy zapętlić coś, potem nałożyć na to efekt reverb, 
tak, żeby uruchomił się tylko przy 1-wszym przebiegu pętli z wszystkich 
5-ciu, itd. Przyjrzyj się poniższemu kawałkowi kodu:

```
play 50
sleep 0.5
sample :elec_plip
sleep 0.5
play 62
```

Abyśmy mogli zrobić coś z kawałkiem kodu, musimy powiedzieć Sonic Pi gdzie 
*zaczyna się* i *kończy* dany blok kodu. Aby określić początek takiego bloku 
używamy polecenia *do*, natomiast polecenie *end* służy do określenia gdzie 
dany blok się kończy. Na przykład:
`do`

```
do
  play 50
  sleep 0.5
  sample :elec_plip
  sleep 0.5
  play 62
end
```

Jednakże, nie jest to jeszcze całość i nie zadziała (spróbuj uruchomić 
powyższy kod a zobaczysz błąd) poneważ nie powiedzieliśmy jeszcze Sonic Pi 
co chcielibyśmy zrobić z naszym *blokiem* zawartym pomiędzy poleceniami 
*do/end*. Aby powiedzieć Sonic Pi co chcemy zrobić z tym kawałkiem musimy 
napisać kawałek specjalnego kodu przed poleceniem `do`. Zobaczysz jeszcze 
wiele takich różnych specjalnych kawałków kodu w kolejnych sekcjach tego 
samouczka. Na razie, najważniejsze jest abyś wiedział, że umieszczenie twojego 
kodu pomiędzy polecenia `do` i `end` mówi Sonic Pi, że chciałbyś zrobić 
z tym kawałkiem kodu coś specjalnego.
