/* ====================================================================
 * Copyright (c) 2006, 2008  Martin Hauner
 *                           http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */

#ifndef _SC_LOGDATA_H
#define _SC_LOGDATA_H

// sc
#include "util/String.h"
class Cancel;

// boost
#include <boost/shared_ptr.hpp>


namespace Log
{
  enum Type
  {
    Started    = 0x001, //< cmd started
    Running    = 0x002,
    Stopped    = 0x004,  // obsolete
    Canceled   = 0x008,  //< cmd canceled
    Time       = 0x010,
    Error      = 0x020,  //< cmd error
    Failed     = 0x040,
    Cancelable = 0x080,
    Finished   = 0x100
  };
};

class LogData
{
public:
  // obsolete
  LogData( unsigned long id, unsigned long type, const sc::String& cmd,
    const sc::String& state, const sc::String& message )
    : _id(id), _type(type), _cmd(cmd), _state(state), _message(message),
    _cancel(NULL)
  {
  }

  LogData( unsigned long id, unsigned long type, const sc::String& cmd,
    const sc::String& state, const sc::String& message, Cancel* ccb )
    : _id(id), _type(type), _cmd(cmd), _state(state), _message(message),
    _cancel(ccb)
  {
  }

  unsigned long getId() const
  {
    return _id;
  }

  unsigned long getType() const
  {
    return _type;
  }

  const sc::String& getAction() const
  {
    return _cmd;
  }

  const sc::String& getCmd() const
  {
    return _cmd;
  }
  
  const sc::String& getState() const
  {
    return _state;
  }

  const sc::String& getMsg() const
  {
    return _message;
  }

  Cancel* getCancel() const
  {
    return _cancel;
  }

  bool isStarted() const
  {
    return (_type & Log::Started) == Log::Started;
  }

  // obsolete
  bool isStart() const
  {
    return (_type & Log::Started) == Log::Started;
  }

  bool isFinished() const
  {
    return (_type & Log::Finished) == Log::Finished;
  }

  // obsolete
  bool isStop() const
  {
    return (_type & Log::Stopped) == Log::Stopped;
  }

  bool isRunning() const
  {
    return (_type & Log::Running) == Log::Running;
  }

  bool isTime() const
  {
    return (_type & Log::Time) == Log::Time;
  }

  bool isError() const
  {
    return (_type & Log::Error) == Log::Error;
  }

  bool isFailed() const
  {
    return (_type & Log::Failed) == Log::Failed;
  }

  bool isCancelable() const
  {
    return (_type & Log::Cancelable) == Log::Cancelable;
  }

private:
  unsigned long _id;
  unsigned long _type;
  sc::String    _cmd;
  sc::String    _state;
  sc::String    _message;
  Cancel*       _cancel;
};

typedef boost::shared_ptr<const LogData>  LogDataPtr;

#endif // _SC_LOGDATA_H
