/* ====================================================================
 * Copyright (c) 2007-2008  Martin Hauner
 *                          http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */

#ifndef _SC_RPSELECTION_H
#define _SC_RPSELECTION_H

// sc
#include "svn/ClientTypes.h"
#include "svn/DirEntryTypes.h"

class RpSelection
{
public:
  RpSelection();
  RpSelection( const RpSelection& sel );
  RpSelection( const svn::DirEntries& entries );

  bool isDir() const;
  bool isFile() const;

#if 0
  // \todo make all methods check all selected items and let the
  // caller check isSingle...
  bool isDiffable();          // single
  bool isVersioned();         // single
  bool isVersionedFile();     // single
  bool isVersionedAll();      // multi
  bool isUnversionedAll();    // multi
  bool isMoveable();          // single
  bool isAddable();           // multi
  bool isConflicted();        // single
  bool isPropConflicted();    // single
  bool isRemoveable();        // multi
  bool isRevertable();        // multi
  bool isCommitable();        // multi
#endif

  /** anything selected? */
  bool isEmpty() const;
  /** only one item selected? */
  bool isSingle() const;
  /** multiple items selected? */
  bool isMulti() const;

  /** get all selected status objects */
  const svn::DirEntries& get() const;
  /** get single selected status object */
  svn::DirEntryPtr getSingle() const;

  /** get number of selected items */
  long size() const;

  /** get selection names */
  void getNames( svn::Paths& paths );

private:
  svn::DirEntries _entries;
};


#endif // _SC_RPSELECTION_H
