/*
 *   Copyright (C) 2008, 2009 Nicolas Vion <nico@yojik.eu>
 *
 *   This file is part of Swac-scan.
 * 
 *   Swac-scan is free software: you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation, either version 3 of the License, or
 *   (at your option) any later version.
 *   
 *   Swac-scan is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *   
 *   You should have received a copy of the GNU General Public License
 *   along with Swac-scan.  If not, see <http://www.gnu.org/licenses/>.
 */

#include "stringutils.hh"
#include <sstream>

int StringUtils::to_int(string const input) {
	std::stringstream oss(input);
	int rv;
	oss >> rv;
	return rv;
}

float StringUtils::to_float(string const input) {
	std::stringstream oss(input);
	float rv;
	oss >> rv;
	return rv;
}

string StringUtils::to_string(int const input) {
	std::stringstream oss;
	oss << input;
	return oss.str();
}

string StringUtils::to_string(const float input) {
	std::stringstream oss;
	oss << input;
	return oss.str();
}

void StringUtils::split(const std::string str, const char separator, std::list<std::string> &result) {
	std::string buf("");
	int size = str.size();
	char c;
	result.clear();
	for (int i = 0; i < size; i++) {
		if ((c = str[i]) == separator) {
			result.push_back(buf);
			buf = "";
		}
		else
			buf += c;
	}
	result.push_back(buf);
}

string StringUtils::strip_slashes(string const str) {
	stringstream result;
	for (unsigned int i = 0; i < str.length(); i++) {
		char c = str[i];
		if (c == '\"') {
			result << "&quot;";
		}
		else if (c == '&') {
			result << "&amp;";
		}
		else if (c == '<') {
			result << "&lt;";
		}
		else {
			result << c;
		}
	}
	return (result.str());
}

string StringUtils::chomp(string const str) {
	int i = str.length();
	while (i > 0 and (str[i - 1] == '\n' or str[i - 1] == '\r'))
		i--;
	return str.substr(0, i);
}

string StringUtils::upper(string const str) {
	string result = str;
	for (unsigned i = 0; i < str.size(); i++) {
		result[i] = toupper(str[i]);
	}
	return result;
}

string StringUtils::lower(string const str) {
	string result = str;
	for (unsigned i = 0; i < str.size(); i++) {
		result[i] = tolower(str[i]);
	}
	return result;
}

