csphinxtools.librarydescription
Library
q )q}q(X   nameqX   wx.lib-4.2.1qX   kindqK X   docsqX    qX   commentsqhX   is_redundantq	X   childrenq
]q(csphinxtools.librarydescription
Module
q)q
}q(hX
   wx.lib.agwqhKhX  This is the Advanced Generic Widgets package (AGW). It provides many
custom-drawn wxPython controls: some of them can be used as a replacement
of the platform native controls, others are simply an addition to the
already rich wxPython widgets set.


Description:

AGW contains many different modules, listed below. Items labelled with
an asterisk were already present in :mod:`lib` before:

- AdvancedSplash: reproduces the behaviour of :class:`~adv.SplashScreen`, with more
  advanced features like custom shapes and text animations;
- AquaButton: this is another custom-drawn button class which
  *approximately* mimics the behaviour of Aqua buttons on the Mac;
- AUI: a pure-Python implementation of :mod:`~wx.lib.agw.aui`, with many bug fixes and
  new features like HUD docking and :class:`~wx.lib.agw.aui.auibook.AuiNotebook` tab arts;
- BalloonTip: allows you to display tooltips in a balloon style window
  (actually a frame), similarly to the Windows XP balloon help;
- ButtonPanel (*): a panel with gradient background shading with the
  possibility to add buttons and controls still respecting the gradient
  background;
- CubeColourDialog: an alternative implementation of :class:`wx.ColourDialog`, it
  offers different functionalities like colour wheel and RGB cube;
- CustomTreeCtrl (*): mimics the behaviour of :class:`TreeCtrl`, with almost the
  same base functionalities plus a bunch of enhancements and goodies;
- FlatMenu: as the name implies, it is a generic menu implementation,
  offering the same :class:`wx.MenuBar` / :class:`wx.Menu` / :class:`ToolBar` capabilities and much more;
- FlatNotebook (*): a full implementation of the :class:`Notebook`, and designed
  to be a drop-in replacement for :class:`Notebook` with enhanced capabilities;
- FloatSpin: this class implements a floating point spinctrl, cabable (in
  theory) of handling infinite-precision floating point numbers;
- FoldPanelBar (*): a control that contains multiple panels that can be
  expanded or collapsed a la Windows Explorer/Outlook command bars;
- FourWaySplitter: this is a layout manager which manages four children like
  four panes in a window, similar to many CAD software interfaces;
- GenericMessageDialog: it is a possible replacement for the standard
  :class:`MessageDialog`, with a fancier look and extended functionalities;
- GradientButton: another custom-drawn button class which mimics Windows CE
  mobile gradient buttons, using a tri-vertex blended gradient background;
- HyperLinkCtrl (*): this widget acts line an hyper link in a typical browser;
- HyperTreeList: a class that mimics the behaviour of :class:`wx.adv.TreeListCtrl`,
  with almost the same base functionalities plus some more enhancements;
- InfoBar: a transient window shown at top or bottom of its parent window to display
  non-critical information to the user;
- KnobCtrl: a widget which lets the user select a numerical value by
  rotating it, like a slider with a wheel shape;
- LabelBook and FlatImageBook: these are a quasi-full implementations of
  :class:`Listbook`, with additional features;
- MultiDirDialog: it represents a possible replacement for :class:`DirDialog`,
  with the additional ability of selecting multiple folders at once and a
  fancier look;
- PeakMeter: this widget mimics the behaviour of LED equalizers that are
  usually found in stereos and MP3 players;
- PersistentControls: widgets which automatically save their state
  when they are destroyed and restore it when they are recreated, even during
  another program invocation;
- PieCtrl and ProgressPie: these are simple classes that reproduce the
  behavior of a pie chart, in a static or progress-gauge-like way;
- PyBusyInfo: constructs a busy info window and displays a message in it:
  it is similar to :class:`BusyInfo`;
- PyCollapsiblePane: a pure Python implementation of the original wxWidgets
  C++ code of :class:`CollapsiblePane`, with customizable buttons;
- PyGauge: a generic :class:`Gauge` implementation, it supports the determinate
  mode functions as :class:`Gauge`;
- PyProgress: it is similar to :class:`ProgressDialog` in indeterminated mode, but
  with a different gauge appearance and a different spinning behavior;
- RibbonBar: the RibbonBar library is a set of classes for writing a ribbon
  user interface, similar to the user interface present in recent versions
  of Microsoft Office;
- RulerCtrl: it implements a ruler window that can be placed on top, bottom,
  left or right to any wxPython widget. It is somewhat similar to the rulers
  you can find in text editors software;
- ShapedButton: this class tries to fill the lack of "custom shaped" controls
  in wxPython. It can be used to build round buttons or elliptic buttons;
- ShortcutEditor: a widget that allows the user to customize and change
  keyboard shortcuts via a dialog;
- SpeedMeter: this widget tries to reproduce the behavior of some car
  controls (but not only), by creating an "angular" control;
- SuperToolTip: a class that mimics the behaviour of :class:`TipWindow` and
  generic tooltips, with many features and highly customizable;
- ThumbnailCtrl: a widget that can be used to display a series of images
  in a "thumbnail" format; it mimics, for example, the Windows Explorer
  behavior when you select the "view thumbnails" option;
- ToasterBox: a cross-platform widget to make the creation of MSN-style
  "toaster" popups easier;
- UltimateListCtrl: mimics the behaviour of :class:`ListCtrl`, with almost the same
  base functionalities plus some more enhancements;
- XLSGrid: a class based on :class:`grid.Grid` that can be used to faithfully
  reproduce the appearance of a Microsoft Excel spreadsheets;
- ZoomBar: a class that *appoximatively* mimics the behaviour of the Mac Dock,
  inside a :class:`Panel`.


Bugs and Limitations: many, patches and fixes welcome :-D

See the demos for an example of what AGW can do, and on how to use it.

Copyright: Andrea Gavana

License: Same as the version of wxPython you are using it with.

SVN for latest code:
http://svn.wxwidgets.org/viewvc/wx/wxPython/3rdParty/AGW/

Mailing List:
wxpython-users@lists.wxwidgets.org

My personal web page:
http://xoomer.alice.it/infinity77

Please let me know if you are using AGW!

You can contact me at:

andrea.gavana@gmail.com
andrea.gavana@maerskoil.com

AGW version: 0.9.7

Last updated: 09 January 2014, 23.00 GMTqhhh	h
]q(h)q}q(hX   wx.lib.agw.auiqhKhX
>  AUI is an Advanced User Interface library that aims to implement "cutting-edge"
interface usability and design features so developers can quickly and easily create
beautiful and usable application interfaces.


Vision and Design Principles
============================

AUI attempts to encapsulate the following aspects of the user interface:

* **Frame Management**: Frame management provides the means to open, move and hide common
  controls that are needed to interact with the document, and allow these configurations
  to be saved into different perspectives and loaded at a later time.

* **Toolbars**: Toolbars are a specialized subset of the frame management system and should
  behave similarly to other docked components. However, they also require additional
  functionality, such as "spring-loaded" rebar support, "chevron" buttons and end-user
  customizability.

* **Modeless Controls**: Modeless controls expose a tool palette or set of options that
  float above the application content while allowing it to be accessed. Usually accessed
  by the toolbar, these controls disappear when an option is selected, but may also be
  "torn off" the toolbar into a floating frame of their own.

* **Look and Feel**: Look and feel encompasses the way controls are drawn, both when shown
  statically as well as when they are being moved. This aspect of user interface design
  incorporates "special effects" such as transparent window dragging as well as frame animation.

AUI adheres to the following principles:

- Use native floating frames to obtain a native look and feel for all platforms;
- Use existing wxPython code where possible, such as sizer implementation for frame management;
- Use standard wxPython coding conventions.


Usage
=====

The following example shows a simple implementation that uses :class:`framemanager.AuiManager` to manage
three text controls in a frame window::

    import wx
    import wx.lib.agw.aui as aui

    class MyFrame(wx.Frame):

        def __init__(self, parent, id=-1, title="AUI Test", pos=wx.DefaultPosition,
                     size=(800, 600), style=wx.DEFAULT_FRAME_STYLE):

            wx.Frame.__init__(self, parent, id, title, pos, size, style)

            self._mgr = aui.AuiManager()

            # notify AUI which frame to use
            self._mgr.SetManagedWindow(self)

            # create several text controls
            text1 = wx.TextCtrl(self, -1, "Pane 1 - sample text",
                                wx.DefaultPosition, wx.Size(200,150),
                                wx.NO_BORDER | wx.TE_MULTILINE)

            text2 = wx.TextCtrl(self, -1, "Pane 2 - sample text",
                                wx.DefaultPosition, wx.Size(200,150),
                                wx.NO_BORDER | wx.TE_MULTILINE)

            text3 = wx.TextCtrl(self, -1, "Main content window",
                                wx.DefaultPosition, wx.Size(200,150),
                                wx.NO_BORDER | wx.TE_MULTILINE)

            # add the panes to the manager
            self._mgr.AddPane(text1, aui.AuiPaneInfo().Left().Caption("Pane Number One"))
            self._mgr.AddPane(text2, aui.AuiPaneInfo().Bottom().Caption("Pane Number Two"))
            self._mgr.AddPane(text3, aui.AuiPaneInfo().CenterPane())

            # tell the manager to "commit" all the changes just made
            self._mgr.Update()

            self.Bind(wx.EVT_CLOSE, self.OnClose)


        def OnClose(self, event):
            # deinitialize the frame manager
            self._mgr.UnInit()
            event.Skip()


    # our normal wxApp-derived class, as usual

    app = wx.App(0)

    frame = MyFrame(None)
    app.SetTopWindow(frame)
    frame.Show()

    app.MainLoop()


What's New
==========

Current wxAUI Version Tracked: wxWidgets 2.9.5 (SVN HEAD)

The wxPython AUI version fixes the following bugs or implement the following
missing features (the list is not exhaustive):

- Visual Studio 2005 style docking: http://www.kirix.com/forums/viewtopic.php?f=16&t=596
- Dock and Pane Resizing: http://www.kirix.com/forums/viewtopic.php?f=16&t=582
- Patch concerning dock resizing: http://www.kirix.com/forums/viewtopic.php?f=16&t=610
- Patch to effect wxAuiToolBar orientation switch: http://www.kirix.com/forums/viewtopic.php?f=16&t=641
- AUI: Core dump when loading a perspective in wxGTK (MSW OK): http://www.kirix.com/forums/viewtopic.php?f=15&t=627
- wxAuiNotebook reordered AdvanceSelection(): http://www.kirix.com/forums/viewtopic.php?f=16&t=617
- Vertical Toolbar Docking Issue: http://www.kirix.com/forums/viewtopic.php?f=16&t=181
- Patch to show the resize hint on mouse-down in aui: http://trac.wxwidgets.org/ticket/9612
- The Left/Right and Top/Bottom Docks over draw each other: http://trac.wxwidgets.org/ticket/3516
- MinSize() not honoured: http://trac.wxwidgets.org/ticket/3562
- Layout problem with wxAUI: http://trac.wxwidgets.org/ticket/3597
- Resizing children ignores current window size: http://trac.wxwidgets.org/ticket/3908
- Resizing panes under Vista does not repaint background: http://trac.wxwidgets.org/ticket/4325
- Resize sash resizes in response to click: http://trac.wxwidgets.org/ticket/4547
- "Illegal" resizing of the AuiPane? (wxPython): http://trac.wxwidgets.org/ticket/4599
- Floating wxAUIPane Resize Event doesn't update its position: http://trac.wxwidgets.org/ticket/9773
- Don't hide floating panels when we maximize some other panel: http://trac.wxwidgets.org/ticket/4066
- wxAUINotebook incorrect ALLOW_ACTIVE_PANE handling: http://trac.wxwidgets.org/ticket/4361
- Page changing veto doesn't work, (patch supplied): http://trac.wxwidgets.org/ticket/4518
- Show and DoShow are mixed around in wxAuiMDIChildFrame: http://trac.wxwidgets.org/ticket/4567
- wxAuiManager & wxToolBar - ToolBar Of Size Zero: http://trac.wxwidgets.org/ticket/9724
- wxAuiNotebook doesn't behave properly like a container as far as...: http://trac.wxwidgets.org/ticket/9911
- Serious layout bugs in wxAUI: http://trac.wxwidgets.org/ticket/10620
- wAuiDefaultTabArt::Clone() should just use copy constructor: http://trac.wxwidgets.org/ticket/11388
- Drop down button for check tool on wxAuiToolbar: http://trac.wxwidgets.org/ticket/11139

Plus the following features:

- AuiManager:

  (a) Implementation of a simple minimize pane system: Clicking on this minimize button causes a new
      AuiToolBar to be created and added to the frame manager, (currently the implementation is such
      that panes at West will have a toolbar at the right, panes at South will have toolbars at the
      bottom etc...) and the pane is hidden in the manager.
      Clicking on the restore button on the newly created toolbar will result in the toolbar being
      removed and the original pane being restored;
  (b) Panes can be docked on top of each other to form `AuiNotebooks`; `AuiNotebooks` tabs can be torn
      off to create floating panes;
  (c) On Windows XP, use the nice sash drawing provided by XP while dragging the sash;
  (d) Possibility to set an icon on docked panes;
  (e) Possibility to draw a sash visual grip, for enhanced visualization of sashes;
  (f) Implementation of a native docking art (`ModernDockArt`). Windows XP only, **requires** Mark Hammond's
      pywin32 package (winxptheme);
  (g) Possibility to set a transparency for floating panes (a la Paint .NET);
  (h) Snapping the main frame to the screen in any positin specified by horizontal and vertical
      alignments;
  (i) Snapping floating panes on left/right/top/bottom or any combination of directions, a la Winamp;
  (j) "Fly-out" floating panes, i.e. panes which show themselves only when the mouse hover them;
  (k) Ability to set custom bitmaps for pane buttons (close, maximize, etc...);
  (l) Implementation of the style ``AUI_MGR_ANIMATE_FRAMES``, which fade-out floating panes when
      they are closed (all platforms which support frames transparency) and show a moving rectangle
      when they are docked and minimized (Windows < Vista and GTK only);
  (m) A pane switcher dialog is available to cycle through existing AUI panes;
  (n) Some flags which allow to choose the orientation and the position of the minimized panes;
  (o) The functions [Get]MinimizeMode() in `AuiPaneInfo` which allow to set/get the flags described above;
  (p) Events like ``EVT_AUI_PANE_DOCKING``, ``EVT_AUI_PANE_DOCKED``, ``EVT_AUI_PANE_FLOATING`` and ``EVT_AUI_PANE_FLOATED`` are
      available for all panes *except* toolbar panes;
  (q) Implementation of the RequestUserAttention method for panes;
  (r) Ability to show the caption bar of docked panes on the left instead of on the top (with caption
      text rotated by 90 degrees then). This is similar to what `wxDockIt` did. To enable this feature on any
      given pane, simply call `CaptionVisible(True, left=True)`;
  (s) New Aero-style docking guides: you can enable them by using the `AuiManager` style ``AUI_MGR_AERO_DOCKING_GUIDES``;
  (t) A slide-in/slide-out preview of minimized panes can be seen by enabling the `AuiManager` style
      ``AUI_MGR_PREVIEW_MINIMIZED_PANES`` and by hovering with the mouse on the minimized pane toolbar tool;
  (u) New Whidbey-style docking guides: you can enable them by using the `AuiManager` style ``AUI_MGR_WHIDBEY_DOCKING_GUIDES``;
  (v) Native of custom-drawn mini frames can be used as floating panes, depending on the ``AUI_MGR_USE_NATIVE_MINIFRAMES`` style;
  (w) A "smooth docking effect" can be obtained by using the ``AUI_MGR_SMOOTH_DOCKING`` style (similar to PyQT docking style);
  (x) Implementation of "Movable" panes, i.e. a pane that is set as `Movable()` but not `Floatable()` can be dragged and docked
      into a new location but will not form a floating window in between.


- AuiNotebook:

  (a) Implementation of the style ``AUI_NB_HIDE_ON_SINGLE_TAB``, a la :mod:`lib.agw.flatnotebook`;
  (b) Implementation of the style ``AUI_NB_SMART_TABS``, a la :mod:`lib.agw.flatnotebook`;
  (c) Implementation of the style ``AUI_NB_USE_IMAGES_DROPDOWN``, which allows to show tab images
      on the tab dropdown menu instead of bare check menu items (a la :mod:`lib.agw.flatnotebook`);
  (d) 6 different tab arts are available, namely:

      (1) Default "glossy" theme (as in :class:`~auibook.AuiNotebook`)
      (2) Simple theme (as in :class:`~auibook.AuiNotebook`)
      (3) Firefox 2 theme
      (4) Visual Studio 2003 theme (VC71)
      (5) Visual Studio 2005 theme (VC81)
      (6) Google Chrome theme

  (e) Enabling/disabling tabs;
  (f) Setting the colour of the tab's text;
  (g) Implementation of the style ``AUI_NB_CLOSE_ON_TAB_LEFT``, which draws the tab close button on
      the left instead of on the right (a la Camino browser);
  (h) Ability to save and load perspectives in `AuiNotebook` (experimental);
  (i) Possibility to add custom buttons in the `AuiNotebook` tab area;
  (j) Implementation of the style ``AUI_NB_TAB_FLOAT``, which allows the floating of single tabs.
      Known limitation: when the notebook is more or less full screen, tabs cannot be dragged far
      enough outside of the notebook to become floating pages;
  (k) Implementation of the style ``AUI_NB_DRAW_DND_TAB`` (on by default), which draws an image
      representation of a tab while dragging;
  (l) Implementation of the `AuiNotebook` unsplit functionality, which unsplit a splitted AuiNotebook
      when double-clicking on a sash;
  (m) Possibility to hide all the tabs by calling `HideAllTAbs`;
  (n) wxPython controls can now be added inside page tabs by calling `AddControlToPage`, and they can be
      removed by calling `RemoveControlFromPage`;
  (o) Possibility to preview all the pages in a `AuiNotebook` (as thumbnails) by using the `NotebookPreview`
      method of `AuiNotebook`;
  (p) Tab labels can be edited by calling the `SetRenamable` method on a `AuiNotebook` page;
  (q) Support for multi-lines tab labels in `AuiNotebook`;
  (r) Support for setting minimum and maximum tab widths for fixed width tabs;
  (s) Implementation of the style ``AUI_NB_ORDER_BY_ACCESS``, which orders the tabs by last access time
      inside the Tab Navigator dialog;
  (t) Implementation of the style ``AUI_NB_NO_TAB_FOCUS``, allowing the developer not to draw the tab
      focus rectangle on tne `AuiNotebook` tabs.

|

- AuiToolBar:

  (a) ``AUI_TB_PLAIN_BACKGROUND`` style that allows to easy setup a plain background to the AUI toolbar,
      without the need to override drawing methods. This style contrasts with the default behaviour
      of the :class:`~auibar.AuiToolBar` that draws a background gradient and this break the window design when
      putting it within a control that has margin between the borders and the toolbar (example: put
      :class:`~auibar.AuiToolBar` within a :class:`StaticBoxSizer` that has a plain background);
  (b) `AuiToolBar` allow item alignment: http://trac.wxwidgets.org/ticket/10174;
  (c) `AUIToolBar` `DrawButton()` improvement: http://trac.wxwidgets.org/ticket/10303;
  (d) `AuiToolBar` automatically assign new id for tools: http://trac.wxwidgets.org/ticket/10173;
  (e) `AuiToolBar` Allow right-click on any kind of button: http://trac.wxwidgets.org/ticket/10079;
  (f) `AuiToolBar` idle update only when visible: http://trac.wxwidgets.org/ticket/10075;
  (g) Ability of creating `AuiToolBar` tools with [counter]clockwise rotation. This allows to propose a
      variant of the minimizing functionality with a rotated button which keeps the caption of the pane
      as label;
  (h) Allow setting the alignment of all tools in a toolbar that is expanded;
  (i) Implementation of the ``AUI_MINIMIZE_POS_TOOLBAR`` flag, which allows to minimize a pane inside
      an existing toolbar. Limitation: if the minimized icon in the toolbar ends up in the overflowing
      items (i.e., a menu is needed to show the icon), this style will not work.



TODOs
=====

- Documentation, documentation and documentation;
- Fix `tabmdi.AuiMDIParentFrame` and friends, they do not work correctly at present;
- Allow specification of `CaptionLeft()` to `AuiPaneInfo` to show the caption bar of docked panes
  on the left instead of on the top (with caption text rotated by 90 degrees then). This is
  similar to what `wxDockIt` did - DONE;
- Make developer-created `AuiNotebooks` and automatic (framemanager-created) `AuiNotebooks` behave
  the same way (undocking of tabs) - DONE, to some extent;
- Find a way to dock panes in already floating panes (`AuiFloatingFrames`), as they already have
  their own `AuiManager`;
- Add more gripper styles (see, i.e., PlusDock 4.0);
- Add an "AutoHide" feature to docked panes, similar to fly-out floating panes (see, i.e., PlusDock 4.0);
- Add events for panes when they are about to float or to be docked (something like
  ``EVT_AUI_PANE_FLOATING/ED`` and ``EVT_AUI_PANE_DOCKING/ED``) - DONE, to some extent;
- Implement the 4-ways splitter behaviour for horizontal and vertical sashes if they intersect;
- Extend `tabart.py` with more aui tab arts;
- Implement ``AUI_NB_LEFT`` and ``AUI_NB_RIGHT`` tab locations in `AuiNotebook`;
- Move `AuiDefaultToolBarArt` into a separate module (as with `tabart.py` and `dockart.py`) and
  provide more arts for toolbars (maybe from :mod:`lib.agw.flatmenu`?)
- Support multiple-rows/multiple columns toolbars;
- Integrate as much as possible with :mod:`lib.agw.flatmenu`, from dropdown menus in `AuiNotebook` to
  toolbars and menu positioning;
- Possibly handle minimization of panes in a different way (or provide an option to switch to
  another way of minimizing panes);
- Clean up/speed up the code, especially time-consuming for-loops;
- Possibly integrate `wxPyRibbon` (still on development), at least on Windows.


License And Version
===================

AUI library is distributed under the wxPython license.

Latest Revision: Andrea Gavana @ 09 Jan 2014, 22.00 GMT

Version 1.3.qhhh	h
]q(h)q}q(hX   wx.lib.agw.aui.aui_constantsqhKhX   This module contains all the constants used by wxPython-AUI.

Especially important and meaningful are constants for AuiManager, AuiDockArt and
AuiNotebook.qhX  # -*- coding: utf-8 -*-
#----------------------------------------------------------------------------
# Name:         aui_constants.py
# Purpose:
#
# Author:       Andrea Gavana <andrea.gavana@gmail.com>
#
# Created:
# Version:
# Date:         31 March 2009
# Licence:      wxWindows license
# Tags:         phoenix-port, unittest, documented, py3-port
#----------------------------------------------------------------------------
qh	h
]q(csphinxtools.librarydescription
Class
q)q}q(hX,   wx.lib.agw.aui.aui_constants.PyEmbeddedImageq hKhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.q!hhh	h
]q"(csphinxtools.librarydescription
Method
q#)q$}q%(hX5   wx.lib.agw.aui.aui_constants.PyEmbeddedImage.__init__q&hKX   orderq'KhX>   Initialize self.  See help(type(self)) for accurate signature.q(hhh	X	   argumentsq)]q*(X   dataq+hhq,X   isBase64q-X   Trueq.X   Trueq/q0eX	   signatureq1X#   __init__(self, data, isBase64=True)q2X   obj_typeq3X   Method/Functionq4X   number_linesq5X   4q6X   parentq7hubh#)q8}q9(hX6   wx.lib.agw.aui.aui_constants.PyEmbeddedImage.GetBitmapq:hKh'Khhhhh	h)]q;h1X   GetBitmap(self)q<h3h4h5X   3q=h7hubh#)q>}q?(hX4   wx.lib.agw.aui.aui_constants.PyEmbeddedImage.GetDataq@hKh'Khhhhh	h)]qAh1X
   GetData(self)qBh3h4h5X   6qCh7hubh#)qD}qE(hX4   wx.lib.agw.aui.aui_constants.PyEmbeddedImage.GetIconqFhKh'Khhhhh	h)]qGh1X
   GetIcon(self)qHh3h4h5X   5qIh7hubh#)qJ}qK(hX5   wx.lib.agw.aui.aui_constants.PyEmbeddedImage.GetImageqLhKh'Khhhhh	h)]qMh1X   GetImage(self)qNh3h4h5h6h7hubcsphinxtools.librarydescription
Property
qO)qP}qQ(hX3   wx.lib.agw.aui.aui_constants.PyEmbeddedImage.BitmapqRhKh'Khhhhh	X   getterqSX	   GetBitmapqTX   setterqUhX   deleterqVhh3X   PropertyqWh7hubhO)qX}qY(hX1   wx.lib.agw.aui.aui_constants.PyEmbeddedImage.DataqZhKh'Khhhhh	hSX   GetDataq[hUhhVhh3hWh7hubhO)q\}q](hX1   wx.lib.agw.aui.aui_constants.PyEmbeddedImage.Iconq^hKh'Khhhhh	hSX   GetIconq_hUhhVhh3hWh7hubhO)q`}qa(hX2   wx.lib.agw.aui.aui_constants.PyEmbeddedImage.ImageqbhKh'Khhhhh	hSX   GetImageqchUhhVhh3hWh7hubeX
   class_treeqd]qe(]qfX   objectqga]qh]qiX   PyEmbeddedImageqjaaeX
   subClassesqk]qlX   superClassesqm]qnh1X   PyEmbeddedImage(object)qoX   inheritance_diagramqpNh'Kh3X   ClassqqX   sphinx_fileqrX_   /home/wxpy/bb2/dist-src-py37/build/docs/sphinx/wx.lib.agw.aui.aui_constants.PyEmbeddedImage.txtqsh7hh5X   52qtubcsphinxtools.librarydescription
Attribute
qu)qv}qw(hX'   wx.lib.agw.aui.aui_constants.__author__qxhKh'KhX  str(object='') -> str
str(bytes_or_buffer[, encoding[, errors]]) -> str

Create a new string object from the given object. If encoding or
errors is specified, then the object must expose a data buffer
that will be decoded using the given encoding and error handler.
Otherwise, returns the result of object.__str__() (if defined)
or repr(object).
encoding defaults to sys.getdefaultencoding().
errors defaults to 'strict'.qyhhh	X   valueqzX)   'Andrea Gavana <andrea.gavana@gmail.com>'q{X   specsq|X   strq}h3X	   Attributeq~h7hubhu)q}q(hX%   wx.lib.agw.aui.aui_constants.__date__qhKh'KhX  str(object='') -> str
str(bytes_or_buffer[, encoding[, errors]]) -> str

Create a new string object from the given object. If encoding or
errors is specified, then the object must expose a data buffer
that will be decoded using the given encoding and error handler.
Otherwise, returns the result of object.__str__() (if defined)
or repr(object).
encoding defaults to sys.getdefaultencoding().
errors defaults to 'strict'.qhhh	hzX   '31 March 2009'qh|X   strqh3h~h7hubhu)q}q(hX.   wx.lib.agw.aui.aui_constants.actionClickButtonqhKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4qhhh	hzX   2qh|X   intqh3h~h7hubhu)q}q(hX/   wx.lib.agw.aui.aui_constants.actionClickCaptionqhKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4qhhh	hzX   3qh|X   intqh3h~h7hubhu)q}q(hX3   wx.lib.agw.aui.aui_constants.actionDragFloatingPaneqhKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4qhhh	hzX   5qh|X   intqh3h~h7hubhu)q}q(hX2   wx.lib.agw.aui.aui_constants.actionDragMovablePaneqhKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4qhhh	hzX   6qh|X   intqh3h~h7hubhu)q}q(hX2   wx.lib.agw.aui.aui_constants.actionDragToolbarPaneqhKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4qhhh	hzX   4qh|X   intqh3h~h7hubhu)q}q(hX'   wx.lib.agw.aui.aui_constants.actionNoneqhKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4qhhh	hzX   0qh|X   intqh3h~h7hubhu)q}q(hX)   wx.lib.agw.aui.aui_constants.actionResizeqhKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4qhhh	hzX   1qh|X   intqh3h~h7hubhu)q}q(hX(   wx.lib.agw.aui.aui_constants.aero_deniedqhKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.qhhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f7afe726e10>qh|X$   wx.lib.embeddedimage.PyEmbeddedImageqh3h~h7hubhu)q}q(hX+   wx.lib.agw.aui.aui_constants.aero_dock_paneqhKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.qhhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f7afe726790>qh|X$   wx.lib.embeddedimage.PyEmbeddedImageqh3h~h7hubhu)q}q(hX2   wx.lib.agw.aui.aui_constants.aero_dock_pane_bottomqhKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.qhhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f7afe726910>qh|X$   wx.lib.embeddedimage.PyEmbeddedImageqh3h~h7hubhu)q}q(hX2   wx.lib.agw.aui.aui_constants.aero_dock_pane_centerqhKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.qhhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f7afe726950>qh|X$   wx.lib.embeddedimage.PyEmbeddedImageqh3h~h7hubhu)q}q(hX2   wx.lib.agw.aui.aui_constants.aero_dock_pane_deniedqhKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.qhhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f7afe7268d0>qh|X$   wx.lib.embeddedimage.PyEmbeddedImageqh3h~h7hubhu)q}q(hX0   wx.lib.agw.aui.aui_constants.aero_dock_pane_leftqhKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.qhhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f7afe726990>qh|X$   wx.lib.embeddedimage.PyEmbeddedImageqh3h~h7hubhu)q}q(hX1   wx.lib.agw.aui.aui_constants.aero_dock_pane_rightqhKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.qhhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f7afe7269d0>qh|X$   wx.lib.embeddedimage.PyEmbeddedImageqh3h~h7hubhu)q}q(hX/   wx.lib.agw.aui.aui_constants.aero_dock_pane_topqhKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.qhhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f7afe726a10>qh|X$   wx.lib.embeddedimage.PyEmbeddedImageqh3h~h7hubhu)q}q(hX&   wx.lib.agw.aui.aui_constants.aero_downqhKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.qhhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f7afe726a50>qh|X$   wx.lib.embeddedimage.PyEmbeddedImageqh3h~h7hubhu)q}q(hX,   wx.lib.agw.aui.aui_constants.aero_down_focusqhKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.qhhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f7afe726a90>qh|X$   wx.lib.embeddedimage.PyEmbeddedImageqh3h~h7hubhu)q}q(hX3   wx.lib.agw.aui.aui_constants.aero_down_focus_singleqhKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.qhhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f7afe726a90>qh|X$   wx.lib.embeddedimage.PyEmbeddedImageqh3h~h7hubhu)q}q(hX-   wx.lib.agw.aui.aui_constants.aero_down_singleqhKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.qhhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f7afe726ad0>qh|X$   wx.lib.embeddedimage.PyEmbeddedImageqh3h~h7hubhu)q}q(hX&   wx.lib.agw.aui.aui_constants.aero_leftqhKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.qhhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f7afe726b10>qh|X$   wx.lib.embeddedimage.PyEmbeddedImageqh3h~h7hubhu)q}q(hX,   wx.lib.agw.aui.aui_constants.aero_left_focusqhKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.r   hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f7afe726b50>r  h|X$   wx.lib.embeddedimage.PyEmbeddedImager  h3h~h7hubhu)r  }r  (hX3   wx.lib.agw.aui.aui_constants.aero_left_focus_singler  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.r  hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f7afe726b50>r  h|X$   wx.lib.embeddedimage.PyEmbeddedImager  h3h~h7hubhu)r	  }r
  (hX-   wx.lib.agw.aui.aui_constants.aero_left_singler  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.r  hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f7afe726b90>r
  h|X$   wx.lib.embeddedimage.PyEmbeddedImager  h3h~h7hubhu)r  }r  (hX'   wx.lib.agw.aui.aui_constants.aero_rightr  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.r  hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f7afe726bd0>r  h|X$   wx.lib.embeddedimage.PyEmbeddedImager  h3h~h7hubhu)r  }r  (hX-   wx.lib.agw.aui.aui_constants.aero_right_focusr  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.r  hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f7afe726c10>r  h|X$   wx.lib.embeddedimage.PyEmbeddedImager  h3h~h7hubhu)r  }r  (hX4   wx.lib.agw.aui.aui_constants.aero_right_focus_singler  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.r  hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f7afe726c10>r  h|X$   wx.lib.embeddedimage.PyEmbeddedImager   h3h~h7hubhu)r!  }r"  (hX.   wx.lib.agw.aui.aui_constants.aero_right_singler#  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.r$  hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f7afe726c50>r%  h|X$   wx.lib.embeddedimage.PyEmbeddedImager&  h3h~h7hubhu)r'  }r(  (hX%   wx.lib.agw.aui.aui_constants.aero_tabr)  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.r*  hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f7afe726c90>r+  h|X$   wx.lib.embeddedimage.PyEmbeddedImager,  h3h~h7hubhu)r-  }r.  (hX+   wx.lib.agw.aui.aui_constants.aero_tab_focusr/  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.r0  hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f7afe726cd0>r1  h|X$   wx.lib.embeddedimage.PyEmbeddedImager2  h3h~h7hubhu)r3  }r4  (hX2   wx.lib.agw.aui.aui_constants.aero_tab_focus_singler5  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.r6  hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f7afe726cd0>r7  h|X$   wx.lib.embeddedimage.PyEmbeddedImager8  h3h~h7hubhu)r9  }r:  (hX,   wx.lib.agw.aui.aui_constants.aero_tab_singler;  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.r<  hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f7afe726d10>r=  h|X$   wx.lib.embeddedimage.PyEmbeddedImager>  h3h~h7hubhu)r?  }r@  (hX$   wx.lib.agw.aui.aui_constants.aero_uprA  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.rB  hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f7afe726d50>rC  h|X$   wx.lib.embeddedimage.PyEmbeddedImagerD  h3h~h7hubhu)rE  }rF  (hX*   wx.lib.agw.aui.aui_constants.aero_up_focusrG  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.rH  hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f7afe726d90>rI  h|X$   wx.lib.embeddedimage.PyEmbeddedImagerJ  h3h~h7hubhu)rK  }rL  (hX1   wx.lib.agw.aui.aui_constants.aero_up_focus_singlerM  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.rN  hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f7afe726d90>rO  h|X$   wx.lib.embeddedimage.PyEmbeddedImagerP  h3h~h7hubhu)rQ  }rR  (hX+   wx.lib.agw.aui.aui_constants.aero_up_singlerS  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.rT  hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f7afe726dd0>rU  h|X$   wx.lib.embeddedimage.PyEmbeddedImagerV  h3h~h7hubhu)rW  }rX  (hX+   wx.lib.agw.aui.aui_constants.aeroguideSizeXrY  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4rZ  hhh	hzX   31r[  h|X   intr\  h3h~h7hubhu)r]  }r^  (hX+   wx.lib.agw.aui.aui_constants.aeroguideSizeYr_  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r`  hhh	hzX   32ra  h|X   intrb  h3h~h7hubhu)rc  }rd  (hX-   wx.lib.agw.aui.aui_constants.AUI_BUTTON_CLOSEre  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4rf  hhh	hzX   101rg  h|X   intrh  h3h~h7hubhu)ri  }rj  (hX/   wx.lib.agw.aui.aui_constants.AUI_BUTTON_CUSTOM1rk  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4rl  hhh	hzX   201rm  h|X   intrn  h3h~h7hubhu)ro  }rp  (hX/   wx.lib.agw.aui.aui_constants.AUI_BUTTON_CUSTOM2rq  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4rr  hhh	hzX   202rs  h|X   intrt  h3h~h7hubhu)ru  }rv  (hX/   wx.lib.agw.aui.aui_constants.AUI_BUTTON_CUSTOM3rw  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4rx  hhh	hzX   203ry  h|X   intrz  h3h~h7hubhu)r{  }r|  (hX/   wx.lib.agw.aui.aui_constants.AUI_BUTTON_CUSTOM4r}  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r~  hhh	hzX   204r  h|X   intr  h3h~h7hubhu)r  }r  (hX/   wx.lib.agw.aui.aui_constants.AUI_BUTTON_CUSTOM5r  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   205r  h|X   intr  h3h~h7hubhu)r  }r  (hX/   wx.lib.agw.aui.aui_constants.AUI_BUTTON_CUSTOM6r  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   206r  h|X   intr  h3h~h7hubhu)r  }r  (hX/   wx.lib.agw.aui.aui_constants.AUI_BUTTON_CUSTOM7r  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   207r  h|X   intr  h3h~h7hubhu)r  }r  (hX/   wx.lib.agw.aui.aui_constants.AUI_BUTTON_CUSTOM8r  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   208r  h|X   intr  h3h~h7hubhu)r  }r  (hX/   wx.lib.agw.aui.aui_constants.AUI_BUTTON_CUSTOM9r  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   209r  h|X   intr  h3h~h7hubhu)r  }r  (hX,   wx.lib.agw.aui.aui_constants.AUI_BUTTON_DOWNr  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   110r  h|X   intr  h3h~h7hubhu)r  }r  (hX,   wx.lib.agw.aui.aui_constants.AUI_BUTTON_LEFTr  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   107r  h|X   intr  h3h~h7hubhu)r  }r  (hX8   wx.lib.agw.aui.aui_constants.AUI_BUTTON_MAXIMIZE_RESTOREr  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   102r  h|X   intr  h3h~h7hubhu)r  }r  (hX0   wx.lib.agw.aui.aui_constants.AUI_BUTTON_MINIMIZEr  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   103r  h|X   intr  h3h~h7hubhu)r  }r  (hX/   wx.lib.agw.aui.aui_constants.AUI_BUTTON_OPTIONSr  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   105r  h|X   intr  h3h~h7hubhu)r  }r  (hX+   wx.lib.agw.aui.aui_constants.AUI_BUTTON_PINr  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   104r  h|X   intr  h3h~h7hubhu)r  }r  (hX-   wx.lib.agw.aui.aui_constants.AUI_BUTTON_RIGHTr  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   108r  h|X   intr  h3h~h7hubhu)r  }r  (hX5   wx.lib.agw.aui.aui_constants.AUI_BUTTON_STATE_CHECKEDr  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   32r  h|X   intr  h3h~h7hubhu)r  }r  (hX6   wx.lib.agw.aui.aui_constants.AUI_BUTTON_STATE_DISABLEDr  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   8r  h|X   intr  h3h~h7hubhu)r  }r  (hX4   wx.lib.agw.aui.aui_constants.AUI_BUTTON_STATE_HIDDENr  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   16r  h|X   intr  h3h~h7hubhu)r  }r  (hX3   wx.lib.agw.aui.aui_constants.AUI_BUTTON_STATE_HOVERr  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   2r  h|X   intr  h3h~h7hubhu)r  }r  (hX4   wx.lib.agw.aui.aui_constants.AUI_BUTTON_STATE_NORMALr  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   0r  h|X   intr  h3h~h7hubhu)r  }r  (hX5   wx.lib.agw.aui.aui_constants.AUI_BUTTON_STATE_PRESSEDr  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   4r  h|X   intr  h3h~h7hubhu)r  }r  (hX*   wx.lib.agw.aui.aui_constants.AUI_BUTTON_UPr  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   109r  h|X   intr  h3h~h7hubhu)r  }r  (hX2   wx.lib.agw.aui.aui_constants.AUI_BUTTON_WINDOWLISTr  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   106r  h|X   intr  h3h~h7hubhu)r  }r  (hX,   wx.lib.agw.aui.aui_constants.AUI_DOCK_BOTTOMr  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   3r  h|X   intr  h3h~h7hubhu)r  }r   (hX,   wx.lib.agw.aui.aui_constants.AUI_DOCK_CENTERr  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   5r  h|X   intr  h3h~h7hubhu)r  }r  (hX,   wx.lib.agw.aui.aui_constants.AUI_DOCK_CENTREr  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   5r	  h|X   intr
  h3h~h7hubhu)r  }r  (hX*   wx.lib.agw.aui.aui_constants.AUI_DOCK_LEFTr
  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   4r  h|X   intr  h3h~h7hubhu)r  }r  (hX*   wx.lib.agw.aui.aui_constants.AUI_DOCK_NONEr  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   0r  h|X   intr  h3h~h7hubhu)r  }r  (hX3   wx.lib.agw.aui.aui_constants.AUI_DOCK_NOTEBOOK_PAGEr  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   6r  h|X   intr  h3h~h7hubhu)r  }r  (hX+   wx.lib.agw.aui.aui_constants.AUI_DOCK_RIGHTr  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r   hhh	hzX   2r!  h|X   intr"  h3h~h7hubhu)r#  }r$  (hX)   wx.lib.agw.aui.aui_constants.AUI_DOCK_TOPr%  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r&  hhh	hzX   1r'  h|X   intr(  h3h~h7hubhu)r)  }r*  (hX>   wx.lib.agw.aui.aui_constants.AUI_DOCKART_ACTIVE_CAPTION_COLOURr+  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r,  hhh	hzX   8r-  h|X   intr.  h3h~h7hubhu)r/  }r0  (hXG   wx.lib.agw.aui.aui_constants.AUI_DOCKART_ACTIVE_CAPTION_GRADIENT_COLOURr1  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r2  hhh	hzX   9r3  h|X   intr4  h3h~h7hubhu)r5  }r6  (hXC   wx.lib.agw.aui.aui_constants.AUI_DOCKART_ACTIVE_CAPTION_TEXT_COLOURr7  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r8  hhh	hzX   12r9  h|X   intr:  h3h~h7hubhu)r;  }r<  (hX:   wx.lib.agw.aui.aui_constants.AUI_DOCKART_BACKGROUND_COLOURr=  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r>  hhh	hzX   5r?  h|X   intr@  h3h~h7hubhu)rA  }rB  (hXC   wx.lib.agw.aui.aui_constants.AUI_DOCKART_BACKGROUND_GRADIENT_COLOURrC  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4rD  hhh	hzX   6rE  h|X   intrF  h3h~h7hubhu)rG  }rH  (hX6   wx.lib.agw.aui.aui_constants.AUI_DOCKART_BORDER_COLOURrI  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4rJ  hhh	hzX   14rK  h|X   intrL  h3h~h7hubhu)rM  }rN  (hX5   wx.lib.agw.aui.aui_constants.AUI_DOCKART_CAPTION_FONTrO  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4rP  hhh	hzX   16rQ  h|X   intrR  h3h~h7hubhu)rS  }rT  (hX5   wx.lib.agw.aui.aui_constants.AUI_DOCKART_CAPTION_SIZErU  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4rV  hhh	hzX   1rW  h|X   intrX  h3h~h7hubhu)rY  }rZ  (hX7   wx.lib.agw.aui.aui_constants.AUI_DOCKART_DRAW_SASH_GRIPr[  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r\  hhh	hzX   18r]  h|X   intr^  h3h~h7hubhu)r_  }r`  (hX6   wx.lib.agw.aui.aui_constants.AUI_DOCKART_GRADIENT_TYPEra  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4rb  hhh	hzX   17rc  h|X   intrd  h3h~h7hubhu)re  }rf  (hX7   wx.lib.agw.aui.aui_constants.AUI_DOCKART_GRIPPER_COLOURrg  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4rh  hhh	hzX   15ri  h|X   intrj  h3h~h7hubhu)rk  }rl  (hX5   wx.lib.agw.aui.aui_constants.AUI_DOCKART_GRIPPER_SIZErm  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4rn  hhh	hzX   2ro  h|X   intrp  h3h~h7hubhu)rq  }rr  (hXB   wx.lib.agw.aui.aui_constants.AUI_DOCKART_HINT_WINDOW_BORDER_COLOURrs  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4rt  hhh	hzX   20ru  h|X   intrv  h3h~h7hubhu)rw  }rx  (hX;   wx.lib.agw.aui.aui_constants.AUI_DOCKART_HINT_WINDOW_COLOURry  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4rz  hhh	hzX   19r{  h|X   intr|  h3h~h7hubhu)r}  }r~  (hX@   wx.lib.agw.aui.aui_constants.AUI_DOCKART_INACTIVE_CAPTION_COLOURr  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   10r  h|X   intr  h3h~h7hubhu)r  }r  (hXI   wx.lib.agw.aui.aui_constants.AUI_DOCKART_INACTIVE_CAPTION_GRADIENT_COLOURr  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   11r  h|X   intr  h3h~h7hubhu)r  }r  (hXE   wx.lib.agw.aui.aui_constants.AUI_DOCKART_INACTIVE_CAPTION_TEXT_COLOURr  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   13r  h|X   intr  h3h~h7hubhu)r  }r  (hX9   wx.lib.agw.aui.aui_constants.AUI_DOCKART_PANE_BORDER_SIZEr  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   3r  h|X   intr  h3h~h7hubhu)r  }r  (hX9   wx.lib.agw.aui.aui_constants.AUI_DOCKART_PANE_BUTTON_SIZEr  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   4r  h|X   intr  h3h~h7hubhu)r  }r  (hX4   wx.lib.agw.aui.aui_constants.AUI_DOCKART_SASH_COLOURr  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   7r  h|X   intr  h3h~h7hubhu)r  }r  (hX2   wx.lib.agw.aui.aui_constants.AUI_DOCKART_SASH_SIZEr  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   0r  h|X   intr  h3h~h7hubhu)r  }r  (hX4   wx.lib.agw.aui.aui_constants.AUI_GRADIENT_HORIZONTALr  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   2r  h|X   intr  h3h~h7hubhu)r  }r  (hX.   wx.lib.agw.aui.aui_constants.AUI_GRADIENT_NONEr  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   0r  h|X   intr  h3h~h7hubhu)r  }r  (hX2   wx.lib.agw.aui.aui_constants.AUI_GRADIENT_VERTICALr  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   1r  h|X   intr  h3h~h7hubhu)r  }r  (hX,   wx.lib.agw.aui.aui_constants.AUI_INSERT_DOCKr  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   2r  h|X   intr  h3h~h7hubhu)r  }r  (hX,   wx.lib.agw.aui.aui_constants.AUI_INSERT_PANEr  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   0r  h|X   intr  h3h~h7hubhu)r  }r  (hX+   wx.lib.agw.aui.aui_constants.AUI_INSERT_ROWr  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   1r  h|X   intr  h3h~h7hubhu)r  }r  (hX8   wx.lib.agw.aui.aui_constants.AUI_MGR_AERO_DOCKING_GUIDESr  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   1024r  h|X   intr  h3h~h7hubhu)r  }r  (hX6   wx.lib.agw.aui.aui_constants.AUI_MGR_ALLOW_ACTIVE_PANEr  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   2r  h|X   intr  h3h~h7hubhu)r  }r  (hX3   wx.lib.agw.aui.aui_constants.AUI_MGR_ALLOW_FLOATINGr  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   1r  h|X   intr  h3h~h7hubhu)r  }r  (hX3   wx.lib.agw.aui.aui_constants.AUI_MGR_ANIMATE_FRAMESr  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   512r  h|X   intr  h3h~h7hubhu)r  }r  (hX6   wx.lib.agw.aui.aui_constants.AUI_MGR_AUTONB_NO_CAPTIONr  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   32768r  h|X   intr  h3h~h7hubhu)r  }r  (hX,   wx.lib.agw.aui.aui_constants.AUI_MGR_DEFAULTr  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   201r  h|X   intr  h3h~h7hubhu)r  }r  (hX.   wx.lib.agw.aui.aui_constants.AUI_MGR_HINT_FADEr  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   64r  h|X   intr  h3h~h7hubhu)r  }r  (hX0   wx.lib.agw.aui.aui_constants.AUI_MGR_LIVE_RESIZEr  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   256r  h|X   intr  h3h~h7hubhu)r  }r  (hX<   wx.lib.agw.aui.aui_constants.AUI_MGR_NO_VENETIAN_BLINDS_FADEr  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   128r  h|X   intr   h3h~h7hubhu)r  }r  (hX<   wx.lib.agw.aui.aui_constants.AUI_MGR_PREVIEW_MINIMIZED_PANESr  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   2048r  h|X   intr  h3h~h7hubhu)r  }r  (hX3   wx.lib.agw.aui.aui_constants.AUI_MGR_RECTANGLE_HINTr	  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r
  hhh	hzX   32r  h|X   intr  h3h~h7hubhu)r
  }r  (hX3   wx.lib.agw.aui.aui_constants.AUI_MGR_SMOOTH_DOCKINGr  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   8192r  h|X   intr  h3h~h7hubhu)r  }r  (hX5   wx.lib.agw.aui.aui_constants.AUI_MGR_TRANSPARENT_DRAGr  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   4r  h|X   intr  h3h~h7hubhu)r  }r  (hX5   wx.lib.agw.aui.aui_constants.AUI_MGR_TRANSPARENT_HINTr  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   8r  h|X   intr  h3h~h7hubhu)r  }r   (hX:   wx.lib.agw.aui.aui_constants.AUI_MGR_USE_NATIVE_MINIFRAMESr!  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r"  hhh	hzX   16384r#  h|X   intr$  h3h~h7hubhu)r%  }r&  (hX9   wx.lib.agw.aui.aui_constants.AUI_MGR_VENETIAN_BLINDS_HINTr'  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r(  hhh	hzX   16r)  h|X   intr*  h3h~h7hubhu)r+  }r,  (hX;   wx.lib.agw.aui.aui_constants.AUI_MGR_WHIDBEY_DOCKING_GUIDESr-  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r.  hhh	hzX   4096r/  h|X   intr0  h3h~h7hubhu)r1  }r2  (hX3   wx.lib.agw.aui.aui_constants.AUI_MINIMIZE_CAPT_HIDEr3  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r4  hhh	hzX   0r5  h|X   intr6  h3h~h7hubhu)r7  }r8  (hX3   wx.lib.agw.aui.aui_constants.AUI_MINIMIZE_CAPT_HORZr9  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r:  hhh	hzX   16r;  h|X   intr<  h3h~h7hubhu)r=  }r>  (hX3   wx.lib.agw.aui.aui_constants.AUI_MINIMIZE_CAPT_MASKr?  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r@  hhh	hzX   24rA  h|X   intrB  h3h~h7hubhu)rC  }rD  (hX4   wx.lib.agw.aui.aui_constants.AUI_MINIMIZE_CAPT_SMARTrE  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4rF  hhh	hzX   8rG  h|X   intrH  h3h~h7hubhu)rI  }rJ  (hX4   wx.lib.agw.aui.aui_constants.AUI_MINIMIZE_POS_BOTTOMrK  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4rL  hhh	hzX   5rM  h|X   intrN  h3h~h7hubhu)rO  }rP  (hX2   wx.lib.agw.aui.aui_constants.AUI_MINIMIZE_POS_LEFTrQ  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4rR  hhh	hzX   3rS  h|X   intrT  h3h~h7hubhu)rU  }rV  (hX2   wx.lib.agw.aui.aui_constants.AUI_MINIMIZE_POS_MASKrW  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4rX  hhh	hzX   23rY  h|X   intrZ  h3h~h7hubhu)r[  }r\  (hX3   wx.lib.agw.aui.aui_constants.AUI_MINIMIZE_POS_RIGHTr]  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r^  hhh	hzX   4r_  h|X   intr`  h3h~h7hubhu)ra  }rb  (hX3   wx.lib.agw.aui.aui_constants.AUI_MINIMIZE_POS_SMARTrc  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4rd  hhh	hzX   1re  h|X   intrf  h3h~h7hubhu)rg  }rh  (hX5   wx.lib.agw.aui.aui_constants.AUI_MINIMIZE_POS_TOOLBARri  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4rj  hhh	hzX   6rk  h|X   intrl  h3h~h7hubhu)rm  }rn  (hX1   wx.lib.agw.aui.aui_constants.AUI_MINIMIZE_POS_TOPro  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4rp  hhh	hzX   2rq  h|X   intrr  h3h~h7hubhu)rs  }rt  (hX*   wx.lib.agw.aui.aui_constants.AUI_NB_BOTTOMru  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4rv  hhh	hzX   8rw  h|X   intrx  h3h~h7hubhu)ry  }rz  (hX0   wx.lib.agw.aui.aui_constants.AUI_NB_CLOSE_BUTTONr{  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r|  hhh	hzX   1024r}  h|X   intr~  h3h~h7hubhu)r  }r  (hX7   wx.lib.agw.aui.aui_constants.AUI_NB_CLOSE_ON_ACTIVE_TABr  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   2048r  h|X   intr  h3h~h7hubhu)r  }r  (hX5   wx.lib.agw.aui.aui_constants.AUI_NB_CLOSE_ON_ALL_TABSr  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   4096r  h|X   intr  h3h~h7hubhu)r  }r  (hX5   wx.lib.agw.aui.aui_constants.AUI_NB_CLOSE_ON_TAB_LEFTr  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   262144r  h|X   intr  h3h~h7hubhu)r  }r  (hX1   wx.lib.agw.aui.aui_constants.AUI_NB_DEFAULT_STYLEr  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   1059121r  h|X   intr  h3h~h7hubhu)r  }r  (hX0   wx.lib.agw.aui.aui_constants.AUI_NB_DRAW_DND_TABr  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   1048576r  h|X   intr  h3h~h7hubhu)r  }r  (hX6   wx.lib.agw.aui.aui_constants.AUI_NB_HIDE_ON_SINGLE_TABr  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   32768r  h|X   intr  h3h~h7hubhu)r  }r  (hX(   wx.lib.agw.aui.aui_constants.AUI_NB_LEFTr  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   2r  h|X   intr  h3h~h7hubhu)r  }r  (hX6   wx.lib.agw.aui.aui_constants.AUI_NB_MIDDLE_CLICK_CLOSEr  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   8192r  h|X   intr  h3h~h7hubhu)r  }r  (hX0   wx.lib.agw.aui.aui_constants.AUI_NB_NO_TAB_FOCUSr  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   4194304r  h|X   intr  h3h~h7hubhu)r  }r  (hX3   wx.lib.agw.aui.aui_constants.AUI_NB_ORDER_BY_ACCESSr  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   2097152r  h|X   intr  h3h~h7hubhu)r  }r  (hX)   wx.lib.agw.aui.aui_constants.AUI_NB_RIGHTr  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   4r  h|X   intr  h3h~h7hubhu)r  }r  (hX2   wx.lib.agw.aui.aui_constants.AUI_NB_SCROLL_BUTTONSr  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   256r  h|X   intr  h3h~h7hubhu)r  }r  (hX.   wx.lib.agw.aui.aui_constants.AUI_NB_SMART_TABSr  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   65536r  h|X   intr  h3h~h7hubhu)r  }r  (hX0   wx.lib.agw.aui.aui_constants.AUI_NB_SUB_NOTEBOOKr  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   16384r  h|X   intr  h3h~h7hubhu)r  }r  (hX5   wx.lib.agw.aui.aui_constants.AUI_NB_TAB_EXTERNAL_MOVEr  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   64r  h|X   intr  h3h~h7hubhu)r  }r  (hX3   wx.lib.agw.aui.aui_constants.AUI_NB_TAB_FIXED_WIDTHr  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   128r  h|X   intr  h3h~h7hubhu)r  }r  (hX-   wx.lib.agw.aui.aui_constants.AUI_NB_TAB_FLOATr  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   524288r  h|X   intr  h3h~h7hubhu)r  }r  (hX,   wx.lib.agw.aui.aui_constants.AUI_NB_TAB_MOVEr  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   32r  h|X   intr  h3h~h7hubhu)r  }r  (hX-   wx.lib.agw.aui.aui_constants.AUI_NB_TAB_SPLITr  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   16r  h|X   intr  h3h~h7hubhu)r  }r  (hX'   wx.lib.agw.aui.aui_constants.AUI_NB_TOPr  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   1r  h|X   intr  h3h~h7hubhu)r  }r  (hX7   wx.lib.agw.aui.aui_constants.AUI_NB_USE_IMAGES_DROPDOWNr  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   131072r  h|X   intr  h3h~h7hubhu)r  }r  (hX5   wx.lib.agw.aui.aui_constants.AUI_NB_WINDOWLIST_BUTTONr  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r   hhh	hzX   512r  h|X   intr  h3h~h7hubhu)r  }r  (hX-   wx.lib.agw.aui.aui_constants.AUI_TB_CLOCKWISEr  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   256r  h|X   intr  h3h~h7hubhu)r	  }r
  (hX4   wx.lib.agw.aui.aui_constants.AUI_TB_COUNTERCLOCKWISEr  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   512r
  h|X   intr  h3h~h7hubhu)r  }r  (hX1   wx.lib.agw.aui.aui_constants.AUI_TB_DEFAULT_STYLEr  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   0r  h|X   intr  h3h~h7hubhu)r  }r  (hX+   wx.lib.agw.aui.aui_constants.AUI_TB_GRIPPERr  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   8r  h|X   intr  h3h~h7hubhu)r  }r  (hX/   wx.lib.agw.aui.aui_constants.AUI_TB_HORZ_LAYOUTr  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   64r  h|X   intr   h3h~h7hubhu)r!  }r"  (hX-   wx.lib.agw.aui.aui_constants.AUI_TB_HORZ_TEXTr#  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r$  hhh	hzX   65r%  h|X   intr&  h3h~h7hubhu)r'  }r(  (hX1   wx.lib.agw.aui.aui_constants.AUI_TB_NO_AUTORESIZEr)  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r*  hhh	hzX   4r+  h|X   intr,  h3h~h7hubhu)r-  }r.  (hX/   wx.lib.agw.aui.aui_constants.AUI_TB_NO_TOOLTIPSr/  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r0  hhh	hzX   2r1  h|X   intr2  h3h~h7hubhu)r3  }r4  (hX,   wx.lib.agw.aui.aui_constants.AUI_TB_OVERFLOWr5  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r6  hhh	hzX   16r7  h|X   intr8  h3h~h7hubhu)r9  }r:  (hX4   wx.lib.agw.aui.aui_constants.AUI_TB_PLAIN_BACKGROUNDr;  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r<  hhh	hzX   128r=  h|X   intr>  h3h~h7hubhu)r?  }r@  (hX(   wx.lib.agw.aui.aui_constants.AUI_TB_TEXTrA  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4rB  hhh	hzX   1rC  h|X   intrD  h3h~h7hubhu)rE  }rF  (hX-   wx.lib.agw.aui.aui_constants.AUI_TB_VERT_TEXTrG  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4rH  hhh	hzX   289rI  h|X   intrJ  h3h~h7hubhu)rK  }rL  (hX,   wx.lib.agw.aui.aui_constants.AUI_TB_VERTICALrM  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4rN  hhh	hzX   32rO  h|X   intrP  h3h~h7hubhu)rQ  }rR  (hX3   wx.lib.agw.aui.aui_constants.AUI_TBART_GRIPPER_SIZErS  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4rT  hhh	hzX   1rU  h|X   intrV  h3h~h7hubhu)rW  }rX  (hX4   wx.lib.agw.aui.aui_constants.AUI_TBART_OVERFLOW_SIZErY  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4rZ  hhh	hzX   2r[  h|X   intr\  h3h~h7hubhu)r]  }r^  (hX5   wx.lib.agw.aui.aui_constants.AUI_TBART_SEPARATOR_SIZEr_  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r`  hhh	hzX   0ra  h|X   intrb  h3h~h7hubhu)rc  }rd  (hX2   wx.lib.agw.aui.aui_constants.AUI_TBTOOL_HORIZONTALre  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4rf  hhh	hzX   0rg  h|X   intrh  h3h~h7hubhu)ri  }rj  (hX3   wx.lib.agw.aui.aui_constants.AUI_TBTOOL_TEXT_BOTTOMrk  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4rl  hhh	hzX   3rm  h|X   intrn  h3h~h7hubhu)ro  }rp  (hX1   wx.lib.agw.aui.aui_constants.AUI_TBTOOL_TEXT_LEFTrq  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4rr  hhh	hzX   0rs  h|X   intrt  h3h~h7hubhu)ru  }rv  (hX2   wx.lib.agw.aui.aui_constants.AUI_TBTOOL_TEXT_RIGHTrw  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4rx  hhh	hzX   1ry  h|X   intrz  h3h~h7hubhu)r{  }r|  (hX0   wx.lib.agw.aui.aui_constants.AUI_TBTOOL_TEXT_TOPr}  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r~  hhh	hzX   2r  h|X   intr  h3h~h7hubhu)r  }r  (hX6   wx.lib.agw.aui.aui_constants.AUI_TBTOOL_VERT_CLOCKWISEr  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   1r  h|X   intr  h3h~h7hubhu)r  }r  (hX=   wx.lib.agw.aui.aui_constants.AUI_TBTOOL_VERT_COUNTERCLOCKWISEr  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   2r  h|X   intr  h3h~h7hubhu)r  }r  (hX-   wx.lib.agw.aui.aui_constants.AuiBaseTabCtrlIdr  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   5380r  h|X   intr  h3h~h7hubhu)r  }r  (hX/   wx.lib.agw.aui.aui_constants.auiInsertRowPixelsr  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   10r  h|X   intr  h3h~h7hubhu)r  }r  (hX1   wx.lib.agw.aui.aui_constants.auiLayerInsertOffsetr  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   5r  h|X   intr  h3h~h7hubhu)r  }r  (hX1   wx.lib.agw.aui.aui_constants.auiLayerInsertPixelsr  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   40r  h|X   intr  h3h~h7hubhu)r  }r  (hX,   wx.lib.agw.aui.aui_constants.auiNewRowPixelsr  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   40r  h|X   intr  h3h~h7hubhu)r  }r  (hX0   wx.lib.agw.aui.aui_constants.auinotebook_previewr  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.r  hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f7afe726e50>r  h|X$   wx.lib.embeddedimage.PyEmbeddedImager  h3h~h7hubhu)r  }r  (hX,   wx.lib.agw.aui.aui_constants.auiToolBarLayerr  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   10r  h|X   intr  h3h~h7hubhu)r  }r  (hX2   wx.lib.agw.aui.aui_constants.BUTTON_DROPDOWN_WIDTHr  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   10r  h|X   intr  h3h~h7hubhu)r  }r  (hX'   wx.lib.agw.aui.aui_constants.close_bitsr  hKh'KhX  bytes(iterable_of_ints) -> bytes
bytes(string, encoding[, errors]) -> bytes
bytes(bytes_or_buffer) -> immutable copy of bytes_or_buffer
bytes(int) -> bytes object of size given by the parameter initialized with null bytes
bytes() -> empty bytes object

Construct an immutable array of bytes from:
  - an iterable yielding integers in range(256)
  - a text string encoded using the specified encoding
  - any object implementing the buffer API.
  - an integerr  hhh	hzX   b'\xff\xff\xff\xff\x07\xf0\xfb\xef\xdb\xed\x8b\xe8\x1b\xec;\xee\x1b\xec\x8b\xe8\xdb\xed\xfb\xef\x07\xf0\xff\xff\xff\xff\xff\xff'r  h|X   bytesr  h3h~h7hubhu)r  }r  (hX1   wx.lib.agw.aui.aui_constants.colourHintBackgroundr  hKh'KhX   Colour()
Colour(red, green, blue, alpha=ALPHA_OPAQUE)
Colour(colRGB)
Colour(colour)

A colour is an object representing a combination of Red, Green, and
Blue (RGB) intensity values and an Alpha value, and is used to
determine drawing colours.r  hhh	hzX   wx.Colour(0, 64, 255, 255)r  h|X   wx._core.Colourr  h3h~h7hubhu)r  }r  (hX-   wx.lib.agw.aui.aui_constants.colourHintBorderr  hKh'KhX   Colour()
Colour(red, green, blue, alpha=ALPHA_OPAQUE)
Colour(colRGB)
Colour(colour)

A colour is an object representing a combination of Red, Green, and
Blue (RGB) intensity values and an Alpha value, and is used to
determine drawing colours.r  hhh	hzX   wx.Colour(60, 60, 60, 255)r  h|X   wx._core.Colourr  h3h~h7hubhu)r  }r  (hX,   wx.lib.agw.aui.aui_constants.colourIconArrowr  hKh'KhX   Colour()
Colour(red, green, blue, alpha=ALPHA_OPAQUE)
Colour(colRGB)
Colour(colour)

A colour is an object representing a combination of Red, Green, and
Blue (RGB) intensity values and an Alpha value, and is used to
determine drawing colours.r  hhh	hzX   wx.Colour(77, 79, 170, 255)r  h|X   wx._core.Colourr  h3h~h7hubhu)r  }r  (hX1   wx.lib.agw.aui.aui_constants.colourIconBackgroundr  hKh'KhX   Colour()
Colour(red, green, blue, alpha=ALPHA_OPAQUE)
Colour(colRGB)
Colour(colour)

A colour is an object representing a combination of Red, Green, and
Blue (RGB) intensity values and an Alpha value, and is used to
determine drawing colours.r  hhh	hzX   wx.Colour(-1, -1, -1, 255)r  h|X   wx._core.Colourr  h3h~h7hubhu)r  }r  (hX-   wx.lib.agw.aui.aui_constants.colourIconBorderr  hKh'KhX   Colour()
Colour(red, green, blue, alpha=ALPHA_OPAQUE)
Colour(colRGB)
Colour(colour)

A colour is an object representing a combination of Red, Green, and
Blue (RGB) intensity values and an Alpha value, and is used to
determine drawing colours.r  hhh	hzX   wx.Colour(82, 65, 156, 255)r  h|X   wx._core.Colourr  h3h~h7hubhu)r  }r  (hX3   wx.lib.agw.aui.aui_constants.colourIconDockingPart1r  hKh'KhX   Colour()
Colour(red, green, blue, alpha=ALPHA_OPAQUE)
Colour(colRGB)
Colour(colour)

A colour is an object representing a combination of Red, Green, and
Blue (RGB) intensity values and an Alpha value, and is used to
determine drawing colours.r  hhh	hzX   wx.Colour(215, 228, 243, 255)r  h|X   wx._core.Colourr  h3h~h7hubhu)r  }r  (hX3   wx.lib.agw.aui.aui_constants.colourIconDockingPart2r  hKh'KhX   Colour()
Colour(red, green, blue, alpha=ALPHA_OPAQUE)
Colour(colRGB)
Colour(colour)

A colour is an object representing a combination of Red, Green, and
Blue (RGB) intensity values and an Alpha value, and is used to
determine drawing colours.r  hhh	hzX   wx.Colour(180, 201, 225, 255)r  h|X   wx._core.Colourr  h3h~h7hubhu)r  }r  (hX-   wx.lib.agw.aui.aui_constants.colourIconShadowr  hKh'KhX   Colour()
Colour(red, green, blue, alpha=ALPHA_OPAQUE)
Colour(colRGB)
Colour(colour)

A colour is an object representing a combination of Red, Green, and
Blue (RGB) intensity values and an Alpha value, and is used to
determine drawing colours.r  hhh	hzX   wx.Colour(198, 198, 198, 255)r  h|X   wx._core.Colourr  h3h~h7hubhu)r  }r  (hX3   wx.lib.agw.aui.aui_constants.colourTargetBackgroundr  hKh'KhX   Colour()
Colour(red, green, blue, alpha=ALPHA_OPAQUE)
Colour(colRGB)
Colour(colour)

A colour is an object representing a combination of Red, Green, and
Blue (RGB) intensity values and an Alpha value, and is used to
determine drawing colours.r  hhh	hzX   wx.Colour(224, 224, 224, 255)r  h|X   wx._core.Colourr  h3h~h7hubhu)r  }r  (hX/   wx.lib.agw.aui.aui_constants.colourTargetBorderr  hKh'KhX   Colour()
Colour(red, green, blue, alpha=ALPHA_OPAQUE)
Colour(colRGB)
Colour(colour)

A colour is an object representing a combination of Red, Green, and
Blue (RGB) intensity values and an Alpha value, and is used to
determine drawing colours.r  hhh	hzX   wx.Colour(180, 180, 180, 255)r  h|X   wx._core.Colourr  h3h~h7hubhu)r  }r   (hX.   wx.lib.agw.aui.aui_constants.colourTargetShader  hKh'KhX   Colour()
Colour(red, green, blue, alpha=ALPHA_OPAQUE)
Colour(colRGB)
Colour(colour)

A colour is an object representing a combination of Red, Green, and
Blue (RGB) intensity values and an Alpha value, and is used to
determine drawing colours.r  hhh	hzX   wx.Colour(206, 206, 206, 255)r  h|X   wx._core.Colourr  h3h~h7hubhu)r  }r  (hX1   wx.lib.agw.aui.aui_constants.DISABLED_TEXT_COLOURr  hKh'KhX   Colour()
Colour(red, green, blue, alpha=ALPHA_OPAQUE)
Colour(colRGB)
Colour(colour)

A colour is an object representing a combination of Red, Green, and
Blue (RGB) intensity values and an Alpha value, and is used to
determine drawing colours.r  hhh	hzX   wx.Colour(153, 153, 153, 255)r	  h|X   wx._core.Colourr
  h3h~h7hubhu)r  }r  (hX3   wx.lib.agw.aui.aui_constants.DISABLED_TEXT_GREY_HUEr
  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   153r  h|X   intr  h3h~h7hubhu)r  }r  (hX!   wx.lib.agw.aui.aui_constants.downr  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.r  hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f7afe726590>r  h|X$   wx.lib.embeddedimage.PyEmbeddedImager  h3h~h7hubhu)r  }r  (hX'   wx.lib.agw.aui.aui_constants.down_focusr  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.r  hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f7afe7265d0>r  h|X$   wx.lib.embeddedimage.PyEmbeddedImager  h3h~h7hubhu)r  }r  (hX.   wx.lib.agw.aui.aui_constants.down_focus_singler  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.r   hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f7afe726250>r!  h|X$   wx.lib.embeddedimage.PyEmbeddedImager"  h3h~h7hubhu)r#  }r$  (hX(   wx.lib.agw.aui.aui_constants.down_singler%  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.r&  hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f7afe726290>r'  h|X$   wx.lib.embeddedimage.PyEmbeddedImager(  h3h~h7hubhu)r)  }r*  (hX'   wx.lib.agw.aui.aui_constants.guideSizeXr+  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r,  hhh	hzX   29r-  h|X   intr.  h3h~h7hubhu)r/  }r0  (hX'   wx.lib.agw.aui.aui_constants.guideSizeYr1  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r2  hhh	hzX   32r3  h|X   intr4  h3h~h7hubhu)r5  }r6  (hX-   wx.lib.agw.aui.aui_constants.ID_RESTORE_FRAMEr7  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r8  hhh	hzX   15999r9  h|X   intr:  h3h~h7hubhu)r;  }r<  (hX'   wx.lib.agw.aui.aui_constants.ITEM_CHECKr=  hKh'Khhhhh	hzX   1r>  h|X   wx._core.ItemKindr?  h3h~h7hubhu)r@  }rA  (hX)   wx.lib.agw.aui.aui_constants.ITEM_CONTROLrB  hKh'Khhhhh	hzX   4rC  h|X   wx._core.ItemKindrD  h3h~h7hubhu)rE  }rF  (hX'   wx.lib.agw.aui.aui_constants.ITEM_LABELrG  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4rH  hhh	hzX   5rI  h|X   intrJ  h3h~h7hubhu)rK  }rL  (hX(   wx.lib.agw.aui.aui_constants.ITEM_NORMALrM  hKh'Khhhhh	hzX   0rN  h|X   wx._core.ItemKindrO  h3h~h7hubhu)rP  }rQ  (hX'   wx.lib.agw.aui.aui_constants.ITEM_RADIOrR  hKh'Khhhhh	hzX   2rS  h|X   wx._core.ItemKindrT  h3h~h7hubhu)rU  }rV  (hX+   wx.lib.agw.aui.aui_constants.ITEM_SEPARATORrW  hKh'Khhhhh	hzX   -1rX  h|X   wx._core.ItemKindrY  h3h~h7hubhu)rZ  }r[  (hX(   wx.lib.agw.aui.aui_constants.ITEM_SPACERr\  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r]  hhh	hzX   6r^  h|X   intr_  h3h~h7hubhu)r`  }ra  (hX!   wx.lib.agw.aui.aui_constants.leftrb  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.rc  hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f7afe726610>rd  h|X$   wx.lib.embeddedimage.PyEmbeddedImagere  h3h~h7hubhu)rf  }rg  (hX'   wx.lib.agw.aui.aui_constants.left_focusrh  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.ri  hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f7afe726650>rj  h|X$   wx.lib.embeddedimage.PyEmbeddedImagerk  h3h~h7hubhu)rl  }rm  (hX.   wx.lib.agw.aui.aui_constants.left_focus_singlern  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.ro  hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f7afe7262d0>rp  h|X$   wx.lib.embeddedimage.PyEmbeddedImagerq  h3h~h7hubhu)rr  }rs  (hX(   wx.lib.agw.aui.aui_constants.left_singlert  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.ru  hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f7afe726310>rv  h|X$   wx.lib.embeddedimage.PyEmbeddedImagerw  h3h~h7hubhu)rx  }ry  (hX%   wx.lib.agw.aui.aui_constants.max_bitsrz  hKh'KhX  bytes(iterable_of_ints) -> bytes
bytes(string, encoding[, errors]) -> bytes
bytes(bytes_or_buffer) -> immutable copy of bytes_or_buffer
bytes(int) -> bytes object of size given by the parameter initialized with null bytes
bytes() -> empty bytes object

Construct an immutable array of bytes from:
  - an iterable yielding integers in range(256)
  - a text string encoded using the specified encoding
  - any object implementing the buffer API.
  - an integerr{  hhh	hzX   b'\xff\xff\xff\xff\xff\xff\x07\xf0\xf7\xf7\x07\xf0\xf7\xf7\xf7\xf7\xf7\xf7\xf7\xf7\xf7\xf7\x07\xf0\xff\xff\xff\xff\xff\xff\xff\xff'r|  h|X   bytesr}  h3h~h7hubhu)r~  }r  (hX*   wx.lib.agw.aui.aui_constants.minimize_bitsr  hKh'KhX  bytes(iterable_of_ints) -> bytes
bytes(string, encoding[, errors]) -> bytes
bytes(bytes_or_buffer) -> immutable copy of bytes_or_buffer
bytes(int) -> bytes object of size given by the parameter initialized with null bytes
bytes() -> empty bytes object

Construct an immutable array of bytes from:
  - an iterable yielding integers in range(256)
  - a text string encoded using the specified encoding
  - any object implementing the buffer API.
  - an integerr  hhh	hzX   b'\xff\xff\xff\xff\xff\xff\x07\xf0\xf7\xf7\x07\xf0\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff'r  h|X   bytesr  h3h~h7hubhu)r  }r  (hX%   wx.lib.agw.aui.aui_constants.Mondrianr  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.r  hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f7afe726210>r  h|X$   wx.lib.embeddedimage.PyEmbeddedImager  h3h~h7hubhu)r  }r  (hX*   wx.lib.agw.aui.aui_constants.nb_close_bitsr  hKh'KhX  bytes(iterable_of_ints) -> bytes
bytes(string, encoding[, errors]) -> bytes
bytes(bytes_or_buffer) -> immutable copy of bytes_or_buffer
bytes(int) -> bytes object of size given by the parameter initialized with null bytes
bytes() -> empty bytes object

Construct an immutable array of bytes from:
  - an iterable yielding integers in range(256)
  - a text string encoded using the specified encoding
  - any object implementing the buffer API.
  - an integerr  hhh	hzX   b'\xff\xff\xff\xff\x07\xf0\xfb\xef\xdb\xed\x8b\xe8\x1b\xec;\xee\x1b\xec\x8b\xe8\xdb\xed\xfb\xef\x07\xf0\xff\xff\xff\xff\xff\xff'r  h|X   bytesr  h3h~h7hubhu)r  }r  (hX)   wx.lib.agw.aui.aui_constants.nb_left_bitsr  hKh'KhX  bytes(iterable_of_ints) -> bytes
bytes(string, encoding[, errors]) -> bytes
bytes(bytes_or_buffer) -> immutable copy of bytes_or_buffer
bytes(int) -> bytes object of size given by the parameter initialized with null bytes
bytes() -> empty bytes object

Construct an immutable array of bytes from:
  - an iterable yielding integers in range(256)
  - a text string encoded using the specified encoding
  - any object implementing the buffer API.
  - an integerr  hhh	hzX}   b'\xff\xff\xff\xff\xff\xff\xff\xfe\x7f\xfe?\xfe\x1f\xfe\x0f\xfe\x1f\xfe?\xfe\x7f\xfe\xff\xfe\xff\xff\xff\xff\xff\xff\xff\xff'r  h|X   bytesr  h3h~h7hubhu)r  }r  (hX)   wx.lib.agw.aui.aui_constants.nb_list_bitsr  hKh'KhX  bytes(iterable_of_ints) -> bytes
bytes(string, encoding[, errors]) -> bytes
bytes(bytes_or_buffer) -> immutable copy of bytes_or_buffer
bytes(int) -> bytes object of size given by the parameter initialized with null bytes
bytes() -> empty bytes object

Construct an immutable array of bytes from:
  - an iterable yielding integers in range(256)
  - a text string encoded using the specified encoding
  - any object implementing the buffer API.
  - an integerr  hhh	hzX   b'\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x0f\xf8\xff\xff\x0f\xf8\x1f\xfc?\xfe\x7f\xff\xff\xff\xff\xff\xff\xff\xff\xff'r  h|X   bytesr  h3h~h7hubhu)r  }r  (hX*   wx.lib.agw.aui.aui_constants.nb_right_bitsr  hKh'KhX  bytes(iterable_of_ints) -> bytes
bytes(string, encoding[, errors]) -> bytes
bytes(bytes_or_buffer) -> immutable copy of bytes_or_buffer
bytes(int) -> bytes object of size given by the parameter initialized with null bytes
bytes() -> empty bytes object

Construct an immutable array of bytes from:
  - an iterable yielding integers in range(256)
  - a text string encoded using the specified encoding
  - any object implementing the buffer API.
  - an integerr  hhh	hzX   b'\xff\xff\xff\xff\xff\xff\xdf\xff\x9f\xff\x1f\xff\x1f\xfe\x1f\xfc\x1f\xfe\x1f\xff\x9f\xff\xdf\xff\xff\xff\xff\xff\xff\xff\xff\xff'r  h|X   bytesr  h3h~h7hubhu)r  }r  (hX%   wx.lib.agw.aui.aui_constants.pin_bitsr  hKh'KhX  bytes(iterable_of_ints) -> bytes
bytes(string, encoding[, errors]) -> bytes
bytes(bytes_or_buffer) -> immutable copy of bytes_or_buffer
bytes(int) -> bytes object of size given by the parameter initialized with null bytes
bytes() -> empty bytes object

Construct an immutable array of bytes from:
  - an iterable yielding integers in range(256)
  - a text string encoded using the specified encoding
  - any object implementing the buffer API.
  - an integerr  hhh	hzX   b'\xff\xff\xff\xff\xff\xff\x1f\xfc\xdf\xfc\xdf\xfc\xdf\xfc\xdf\xfc\xdf\xfc\x0f\xf8\x7f\xff\x7f\xff\x7f\xff\xff\xff\xff\xff\xff\xff'r  h|X   bytesr  h3h~h7hubhu)r  }r  (hX)   wx.lib.agw.aui.aui_constants.restore_bitsr  hKh'KhX  bytes(iterable_of_ints) -> bytes
bytes(string, encoding[, errors]) -> bytes
bytes(bytes_or_buffer) -> immutable copy of bytes_or_buffer
bytes(int) -> bytes object of size given by the parameter initialized with null bytes
bytes() -> empty bytes object

Construct an immutable array of bytes from:
  - an iterable yielding integers in range(256)
  - a text string encoded using the specified encoding
  - any object implementing the buffer API.
  - an integerr  hhh	hzX   b'\xff\xff\xff\xff\xff\xff\x1f\xf0\x1f\xf0\xdf\xf7\x07\xf4\x07\xf4\xf7\xf5\xf7\xf1\xf7\xfd\xf7\xfd\x07\xfc\xff\xff\xff\xff\xff\xff'r  h|X   bytesr  h3h~h7hubhu)r  }r  (hX(   wx.lib.agw.aui.aui_constants.restore_xpmr  hKh'KhX   Built-in mutable sequence.

If no argument is given, the constructor creates a new empty list.
The argument must be an iterable if specified.r  hhh	hzX  [b'16 15 3 1', b'       c None', b'.      c #000000', b'+      c #FFFFFF', b'                ', b'     .......... ', b'     .++++++++. ', b'     .......... ', b'     .++++++++. ', b' ..........+++. ', b' .++++++++.+++. ', b' ..........+++. ', b' .++++++++..... ', b' .++++++++.     ', b' .++++++++.     ', b' .++++++++.     ', b' .++++++++.     ', b' ..........     ', b'                ']r  h|X   listr  h3h~h7hubhu)r  }r  (hX"   wx.lib.agw.aui.aui_constants.rightr  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.r  hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f7afe726710>r  h|X$   wx.lib.embeddedimage.PyEmbeddedImager  h3h~h7hubhu)r  }r  (hX(   wx.lib.agw.aui.aui_constants.right_focusr  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.r  hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f7afe726750>r  h|X$   wx.lib.embeddedimage.PyEmbeddedImager  h3h~h7hubhu)r  }r  (hX/   wx.lib.agw.aui.aui_constants.right_focus_singler  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.r  hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f7afe726350>r  h|X$   wx.lib.embeddedimage.PyEmbeddedImager  h3h~h7hubhu)r  }r  (hX)   wx.lib.agw.aui.aui_constants.right_singler  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.r  hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f7afe726390>r  h|X$   wx.lib.embeddedimage.PyEmbeddedImager  h3h~h7hubhu)r  }r  (hX3   wx.lib.agw.aui.aui_constants.SWITCHER_TEXT_MARGIN_Xr  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   4r  h|X   intr  h3h~h7hubhu)r  }r  (hX3   wx.lib.agw.aui.aui_constants.SWITCHER_TEXT_MARGIN_Yr  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   1r  h|X   intr  h3h~h7hubhu)r  }r  (hX    wx.lib.agw.aui.aui_constants.tabr  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.r  hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f7afe7267d0>r  h|X$   wx.lib.embeddedimage.PyEmbeddedImager  h3h~h7hubhu)r  }r  (hX.   wx.lib.agw.aui.aui_constants.tab_active_centerr  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.r  hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f7afe73f4d0>r  h|X$   wx.lib.embeddedimage.PyEmbeddedImager  h3h~h7hubhu)r  }r  (hX,   wx.lib.agw.aui.aui_constants.tab_active_leftr  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.r  hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f7afe73f550>r  h|X$   wx.lib.embeddedimage.PyEmbeddedImager  h3h~h7hubhu)r  }r  (hX-   wx.lib.agw.aui.aui_constants.tab_active_rightr  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.r  hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f7afe73f810>r  h|X$   wx.lib.embeddedimage.PyEmbeddedImager  h3h~h7hubhu)r  }r  (hX&   wx.lib.agw.aui.aui_constants.tab_closer  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.r  hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f7afe73f9d0>r  h|X$   wx.lib.embeddedimage.PyEmbeddedImager  h3h~h7hubhu)r  }r  (hX(   wx.lib.agw.aui.aui_constants.tab_close_hr  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.r  hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f7afe7260d0>r  h|X$   wx.lib.embeddedimage.PyEmbeddedImager  h3h~h7hubhu)r  }r  (hX(   wx.lib.agw.aui.aui_constants.tab_close_pr  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.r  hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f7afe726110>r   h|X$   wx.lib.embeddedimage.PyEmbeddedImager  h3h~h7hubhu)r  }r  (hX&   wx.lib.agw.aui.aui_constants.tab_focusr  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.r  hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f7afe726810>r  h|X$   wx.lib.embeddedimage.PyEmbeddedImager  h3h~h7hubhu)r  }r	  (hX-   wx.lib.agw.aui.aui_constants.tab_focus_singler
  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.r  hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f7afe726490>r  h|X$   wx.lib.embeddedimage.PyEmbeddedImager
  h3h~h7hubhu)r  }r  (hX0   wx.lib.agw.aui.aui_constants.tab_inactive_centerr  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.r  hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f7afe726150>r  h|X$   wx.lib.embeddedimage.PyEmbeddedImager  h3h~h7hubhu)r  }r  (hX.   wx.lib.agw.aui.aui_constants.tab_inactive_leftr  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.r  hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f7afe726190>r  h|X$   wx.lib.embeddedimage.PyEmbeddedImager  h3h~h7hubhu)r  }r  (hX/   wx.lib.agw.aui.aui_constants.tab_inactive_rightr  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.r  hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f7afe7261d0>r  h|X$   wx.lib.embeddedimage.PyEmbeddedImager  h3h~h7hubhu)r   }r!  (hX'   wx.lib.agw.aui.aui_constants.tab_singler"  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.r#  hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f7afe7264d0>r$  h|X$   wx.lib.embeddedimage.PyEmbeddedImager%  h3h~h7hubhu)r&  }r'  (hX   wx.lib.agw.aui.aui_constants.upr(  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.r)  hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f7afe726850>r*  h|X$   wx.lib.embeddedimage.PyEmbeddedImager+  h3h~h7hubhu)r,  }r-  (hX%   wx.lib.agw.aui.aui_constants.up_focusr.  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.r/  hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f7afe726890>r0  h|X$   wx.lib.embeddedimage.PyEmbeddedImager1  h3h~h7hubhu)r2  }r3  (hX,   wx.lib.agw.aui.aui_constants.up_focus_singler4  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.r5  hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f7afe726510>r6  h|X$   wx.lib.embeddedimage.PyEmbeddedImager7  h3h~h7hubhu)r8  }r9  (hX&   wx.lib.agw.aui.aui_constants.up_singler:  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.r;  hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f7afe726550>r<  h|X$   wx.lib.embeddedimage.PyEmbeddedImager=  h3h~h7hubhu)r>  }r?  (hX4   wx.lib.agw.aui.aui_constants.vertical_border_paddingr@  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4rA  hhh	hzX   4rB  h|X   intrC  h3h~h7hubhu)rD  }rE  (hX+   wx.lib.agw.aui.aui_constants.whidbey_deniedrF  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.rG  hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f7afe726e10>rH  h|X$   wx.lib.embeddedimage.PyEmbeddedImagerI  h3h~h7hubhu)rJ  }rK  (hX.   wx.lib.agw.aui.aui_constants.whidbey_dock_panerL  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.rM  hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f7afe726f10>rN  h|X$   wx.lib.embeddedimage.PyEmbeddedImagerO  h3h~h7hubhu)rP  }rQ  (hX5   wx.lib.agw.aui.aui_constants.whidbey_dock_pane_bottomrR  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.rS  hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f7afe726f50>rT  h|X$   wx.lib.embeddedimage.PyEmbeddedImagerU  h3h~h7hubhu)rV  }rW  (hX5   wx.lib.agw.aui.aui_constants.whidbey_dock_pane_centerrX  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.rY  hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f7afe726f90>rZ  h|X$   wx.lib.embeddedimage.PyEmbeddedImager[  h3h~h7hubhu)r\  }r]  (hX3   wx.lib.agw.aui.aui_constants.whidbey_dock_pane_leftr^  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.r_  hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f7afe726fd0>r`  h|X$   wx.lib.embeddedimage.PyEmbeddedImagera  h3h~h7hubhu)rb  }rc  (hX4   wx.lib.agw.aui.aui_constants.whidbey_dock_pane_rightrd  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.re  hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f7aef7a5790>rf  h|X$   wx.lib.embeddedimage.PyEmbeddedImagerg  h3h~h7hubhu)rh  }ri  (hX2   wx.lib.agw.aui.aui_constants.whidbey_dock_pane_toprj  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.rk  hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f7aef7a5990>rl  h|X$   wx.lib.embeddedimage.PyEmbeddedImagerm  h3h~h7hubhu)rn  }ro  (hX)   wx.lib.agw.aui.aui_constants.whidbey_downrp  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.rq  hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f7afe726e90>rr  h|X$   wx.lib.embeddedimage.PyEmbeddedImagers  h3h~h7hubhu)rt  }ru  (hX/   wx.lib.agw.aui.aui_constants.whidbey_down_focusrv  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.rw  hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f7afe726ed0>rx  h|X$   wx.lib.embeddedimage.PyEmbeddedImagery  h3h~h7hubhu)rz  }r{  (hX6   wx.lib.agw.aui.aui_constants.whidbey_down_focus_singler|  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.r}  hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f7afe726ed0>r~  h|X$   wx.lib.embeddedimage.PyEmbeddedImager  h3h~h7hubhu)r  }r  (hX0   wx.lib.agw.aui.aui_constants.whidbey_down_singler  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.r  hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f7afe726e90>r  h|X$   wx.lib.embeddedimage.PyEmbeddedImager  h3h~h7hubhu)r  }r  (hX)   wx.lib.agw.aui.aui_constants.whidbey_leftr  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.r  hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f7aef7a5090>r  h|X$   wx.lib.embeddedimage.PyEmbeddedImager  h3h~h7hubhu)r  }r  (hX/   wx.lib.agw.aui.aui_constants.whidbey_left_focusr  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.r  hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f7aef7a50d0>r  h|X$   wx.lib.embeddedimage.PyEmbeddedImager  h3h~h7hubhu)r  }r  (hX6   wx.lib.agw.aui.aui_constants.whidbey_left_focus_singler  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.r  hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f7aef7a50d0>r  h|X$   wx.lib.embeddedimage.PyEmbeddedImager  h3h~h7hubhu)r  }r  (hX0   wx.lib.agw.aui.aui_constants.whidbey_left_singler  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.r  hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f7aef7a5090>r  h|X$   wx.lib.embeddedimage.PyEmbeddedImager  h3h~h7hubhu)r  }r  (hX*   wx.lib.agw.aui.aui_constants.whidbey_rightr  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.r  hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f7aef7a5050>r  h|X$   wx.lib.embeddedimage.PyEmbeddedImager  h3h~h7hubhu)r  }r  (hX0   wx.lib.agw.aui.aui_constants.whidbey_right_focusr  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.r  hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f7aef7a5110>r  h|X$   wx.lib.embeddedimage.PyEmbeddedImager  h3h~h7hubhu)r  }r  (hX7   wx.lib.agw.aui.aui_constants.whidbey_right_focus_singler  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.r  hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f7aef7a5110>r  h|X$   wx.lib.embeddedimage.PyEmbeddedImager  h3h~h7hubhu)r  }r  (hX1   wx.lib.agw.aui.aui_constants.whidbey_right_singler  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.r  hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f7aef7a5050>r  h|X$   wx.lib.embeddedimage.PyEmbeddedImager  h3h~h7hubhu)r  }r  (hX'   wx.lib.agw.aui.aui_constants.whidbey_upr  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.r  hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f7aef7a5150>r  h|X$   wx.lib.embeddedimage.PyEmbeddedImager  h3h~h7hubhu)r  }r  (hX-   wx.lib.agw.aui.aui_constants.whidbey_up_focusr  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.r  hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f7aef7a5190>r  h|X$   wx.lib.embeddedimage.PyEmbeddedImager  h3h~h7hubhu)r  }r  (hX4   wx.lib.agw.aui.aui_constants.whidbey_up_focus_singler  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.r  hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f7aef7a5190>r  h|X$   wx.lib.embeddedimage.PyEmbeddedImager  h3h~h7hubhu)r  }r  (hX.   wx.lib.agw.aui.aui_constants.whidbey_up_singler  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.r  hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f7aef7a5150>r  h|X$   wx.lib.embeddedimage.PyEmbeddedImager  h3h~h7hubhu)r  }r  (hX)   wx.lib.agw.aui.aui_constants.whidbeySizeXr  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   43r  h|X   intr  h3h~h7hubhu)r  }r  (hX)   wx.lib.agw.aui.aui_constants.whidbeySizeYr  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   30r  h|X   intr  h3h~h7hubhu)r  }r  (hX*   wx.lib.agw.aui.aui_constants.wxWINDOWCLOSEr  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   4001r  h|X   intr  h3h~h7hubhu)r  }r  (hX-   wx.lib.agw.aui.aui_constants.wxWINDOWCLOSEALLr  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   4002r  h|X   intr  h3h~h7hubhu)r  }r  (hX)   wx.lib.agw.aui.aui_constants.wxWINDOWNEXTr  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   4003r  h|X   intr  h3h~h7hubhu)r  }r  (hX)   wx.lib.agw.aui.aui_constants.wxWINDOWPREVr  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   4004r  h|X   intr  h3h~h7hubeX   filenamer  XB   /home/wxpy/bb2/dist-src-py37/build/wx/lib/agw/aui/aui_constants.pyr  hrXO   /home/wxpy/bb2/dist-src-py37/build/docs/sphinx/wx.lib.agw.aui.aui_constants.txtr  h'Kh3X	   Py_Moduler  hpNh7hubh)r  }r  (hX!   wx.lib.agw.aui.aui_switcherdialogr  hKhX  Description
===========

The idea of `SwitcherDialog` is to make it easier to implement keyboard
navigation in AUI and other applications that have multiple panes and
tabs.

A key combination with a modifier (such as ``Ctrl`` + ``Tab``) shows the
dialog, and the user holds down the modifier whilst navigating with
``Tab`` and arrow keys before releasing the modifier to dismiss the dialog
and activate the selected pane.

The switcher dialog is a multi-column menu with no scrolling, implemented
by the :class:`MultiColumnListCtrl` class. You can have headings for your items
for logical grouping, and you can force a column break if you need to.

The modifier used for invoking and dismissing the dialog can be customised,
as can the colours, number of rows, and the key used for cycling through
the items. So you can use different keys on different platforms if
required (especially since ``Ctrl`` + ``Tab`` is reserved on some platforms).

Items are shown as names and optional 16x16 images.


Base Functionalities
====================

To use the dialog, you set up the items in a `SwitcherItems` object,
before passing this to the `SwitcherDialog` instance.

Call :meth:`SwitcherItems.AddItem` and optionally :meth:`SwitcherItems.AddGroup`
to add items and headings. These functions take a label (to be displayed to the user),
an identifying name, an integer id, and a bitmap. The name and id are purely for
application-defined identification. You may also set a description to be displayed
when each item is selected; and you can set a window pointer for convenience when
activating the desired window after the dialog returns.

Have created the dialog, you call :meth:`~Dialog.ShowModal`, and if the return value is
``wx.ID_OK``, retrieve the selection from the dialog and activate the pane.

The sample code below shows a generic method of finding panes and notebook
tabs within the current :class:`~wx.lib.agw.aui.framemanager.AuiManager`, and using the pane name or notebook
tab position to display the pane.

The only other code to add is a menu item with the desired accelerator,
whose modifier matches the one you pass to :meth:`SwitcherDialog.SetModifierKey`
(the default being ``wx.WXK_CONTROL``).


Usage
=====

Menu item::

    if wx.Platform == "__WXMAC__":
        switcherAccel = "Alt+Tab"
    elif wx.Platform == "__WXGTK__":
        switcherAccel = "Ctrl+/"
    else:
        switcherAccel = "Ctrl+Tab"

    view_menu.Append(ID_SwitchPane, _("S&witch Window...") + "  " + switcherAccel)


Event handler::

    def OnSwitchPane(self, event):

        items = SwitcherItems()
        items.SetRowCount(12)

        # Add the main windows and toolbars, in two separate columns
        # We'll use the item 'id' to store the notebook selection, or -1 if not a page

        for k in range(2):
            if k == 0:
                items.AddGroup(_("Main Windows"), "mainwindows")
            else:
                items.AddGroup(_("Toolbars"), "toolbars").BreakColumn()

            for pane in self._mgr.GetAllPanes():
                name = pane.name
                caption = pane.caption

                toolbar = isinstance(info.window, wx.ToolBar) or isinstance(info.window, aui.AuiToolBar)
                if caption and (toolBar  and k == 1) or (not toolBar and k == 0):
                    items.AddItem(caption, name, -1).SetWindow(pane.window)

        # Now add the wxAuiNotebook pages

        items.AddGroup(_("Notebook Pages"), "pages").BreakColumn()

        for pane in self._mgr.GetAllPanes():
            nb = pane.window
            if isinstance(nb, aui.AuiNotebook):
                for j in range(nb.GetPageCount()):

                    name = nb.GetPageText(j)
                    win = nb.GetPage(j)

                    items.AddItem(name, name, j, nb.GetPageBitmap(j)).SetWindow(win)

        # Select the focused window

        idx = items.GetIndexForFocus()
        if idx != wx.NOT_FOUND:
            items.SetSelection(idx)

        if wx.Platform == "__WXMAC__":
            items.SetBackgroundColour(wx.WHITE)

        # Show the switcher dialog

        dlg = SwitcherDialog(items, wx.GetApp().GetTopWindow())

        # In GTK+ we can't use Ctrl+Tab; we use Ctrl+/ instead and tell the switcher
        # to treat / in the same was as tab (i.e. cycle through the names)

        if wx.Platform == "__WXGTK__":
            dlg.SetExtraNavigationKey(wxT('/'))

        if wx.Platform == "__WXMAC__":
            dlg.SetBackgroundColour(wx.WHITE)
            dlg.SetModifierKey(wx.WXK_ALT)

        ans = dlg.ShowModal()

        if ans == wx.ID_OK and dlg.GetSelection() != -1:
            item = items.GetItem(dlg.GetSelection())

            if item.GetId() == -1:
                info = self._mgr.GetPane(item.GetName())
                info.Show()
                self._mgr.Update()
                info.window.SetFocus()

            else:
                nb = item.GetWindow().GetParent()
                win = item.GetWindow();
                if isinstance(nb, aui.AuiNotebook):
                    nb.SetSelection(item.GetId())
                    win.SetFocus()r  hXf  # -*- coding: utf-8 -*-
#----------------------------------------------------------------------------
# Name:         aui_switcherdialog.py
# Purpose:
#
# Author:
#
# Created:
# Version:
# Date:
# Licence:      wxWindows license
# Tags:         phoenix-port, documented, py3-port
#----------------------------------------------------------------------------
r  h	h
]r  (h)r  }r  (hX5   wx.lib.agw.aui.aui_switcherdialog.MultiColumnListCtrlr  hKhX;   A control for displaying several columns (not scrollable). r  hhh	h
]r   (h#)r  }r  (hX>   wx.lib.agw.aui.aui_switcherdialog.MultiColumnListCtrl.__init__r  hKh'KhX>   Initialize self.  See help(type(self)) for accurate signature.r  hhh	h)]r  (X   parentr  hhr  X   aui_managerr  hhr	  X   idr
  X	   wx.ID_ANYr  X   -1r  r
  X   posr  X   wx.DefaultPositionr  X   (-1, -1)r  r  X   sizer  X   wx.DefaultSizer  X   (-1, -1)r  r  X   styler  X   0r  X   0r  r  X	   validatorr  X   wx.DefaultValidatorr  X-   <wx._core.Validator object at 0x7f7afe99a870>r  r  X   namer  X   "MultiColumnListCtrl"r  X   MultiColumnListCtrlr   r!  eh1X   __init__(self, parent, aui_manager, id=wx.ID_ANY, pos=wx.DefaultPosition, size=wx.DefaultSize, style=0, validator=wx.DefaultValidator, name="MultiColumnListCtrl")r"  h3h4h5X   20r#  h7j  ubh#)r$  }r%  (hXQ   wx.lib.agw.aui.aui_switcherdialog.MultiColumnListCtrl.AdvanceToNextSelectableItemr&  hKh'Khhhhh	h)]r'  X	   directionr(  hhr)  ah1X,   AdvanceToNextSelectableItem(self, direction)r*  h3h4h5X   50r+  h7j  ubh#)r,  }r-  (hXE   wx.lib.agw.aui.aui_switcherdialog.MultiColumnListCtrl.CalculateLayoutr.  hKh'Khhhhh	h)]r/  X   dcr0  X   Noner1  X   Noner2  r3  ah1X   CalculateLayout(self, dc=None)r4  h3h4h5X   74r5  h7j  ubh#)r6  }r7  (hXC   wx.lib.agw.aui.aui_switcherdialog.MultiColumnListCtrl.DoGetBestSizer8  hKh'KhX   DoGetBestSize(self) -> Sizer9  hhh	h)]r:  h1X   DoGetBestSize(self)r;  h3h4h5h6h7j  ubh#)r<  }r=  (hXL   wx.lib.agw.aui.aui_switcherdialog.MultiColumnListCtrl.GenerateSelectionEventr>  hKh'Khhhhh	h)]r?  h1X   GenerateSelectionEvent(self)r@  h3h4h5X   7rA  h7j  ubh#)rB  }rC  (hXK   wx.lib.agw.aui.aui_switcherdialog.MultiColumnListCtrl.GetExtraNavigationKeyrD  hKh'Khhhhh	h)]rE  h1X   GetExtraNavigationKey(self)rF  h3h4h5h6h7j  ubh#)rG  }rH  (hX>   wx.lib.agw.aui.aui_switcherdialog.MultiColumnListCtrl.GetItemsrI  hKh'Khhhhh	h)]rJ  h1X   GetItems(self)rK  h3h4h5h6h7j  ubh#)rL  }rM  (hXD   wx.lib.agw.aui.aui_switcherdialog.MultiColumnListCtrl.GetModifierKeyrN  hKh'Khhhhh	h)]rO  h1X   GetModifierKey(self)rP  h3h4h5h6h7j  ubh#)rQ  }rR  (hX<   wx.lib.agw.aui.aui_switcherdialog.MultiColumnListCtrl.OnCharrS  hKh'Khhhhh	h)]rT  X   eventrU  hhrV  ah1X   OnChar(self, event)rW  h3h4h5h6h7j  ubh#)rX  }rY  (hXG   wx.lib.agw.aui.aui_switcherdialog.MultiColumnListCtrl.OnEraseBackgroundrZ  hKh'Khhhhh	h)]r[  X   eventr\  hhr]  ah1X   OnEraseBackground(self, event)r^  h3h4h5h6h7j  ubh#)r_  }r`  (hX;   wx.lib.agw.aui.aui_switcherdialog.MultiColumnListCtrl.OnKeyra  hKh'Khhhhh	h)]rb  X   eventrc  hhrd  ah1X   OnKey(self, event)re  h3h4h5X   120rf  h7j  ubh#)rg  }rh  (hXB   wx.lib.agw.aui.aui_switcherdialog.MultiColumnListCtrl.OnMouseEventri  hKh'Khhhhh	h)]rj  X   eventrk  hhrl  ah1X   OnMouseEvent(self, event)rm  h3h4h5hIh7j  ubh#)rn  }ro  (hX=   wx.lib.agw.aui.aui_switcherdialog.MultiColumnListCtrl.OnPaintrp  hKh'Khhhhh	h)]rq  X   eventrr  hhrs  ah1X   OnPaint(self, event)rt  h3h4h5X   13ru  h7j  ubh#)rv  }rw  (hXK   wx.lib.agw.aui.aui_switcherdialog.MultiColumnListCtrl.SetExtraNavigationKeyrx  hKh'KhXo   Set an extra key that can be used to cycle through items,
in case not using the ``Ctrl`` + ``Tab`` combination.ry  hhh	h)]rz  X   keyCoder{  hhr|  ah1X$   SetExtraNavigationKey(self, keyCode)r}  h3h4h5X   8r~  h7j  ubh#)r  }r  (hX>   wx.lib.agw.aui.aui_switcherdialog.MultiColumnListCtrl.SetItemsr  hKh'Khhhhh	h)]r  X   itemsr  hhr  ah1X   SetItems(self, items)r  h3h4h5h6h7j  ubh#)r  }r  (hXD   wx.lib.agw.aui.aui_switcherdialog.MultiColumnListCtrl.SetModifierKeyr  hKh'KhXN   Set the modifier used to invoke the dialog, and therefore to test for release.r  hhh	h)]r  X   modifierKeyr  hhr  ah1X!   SetModifierKey(self, modifierKey)r  h3h4h5jA  h7j  ubh#)r  }r  (hXE   wx.lib.agw.aui.aui_switcherdialog.MultiColumnListCtrl.SetTransparencyr  hKh'Khhhhh	h)]r  X	   selectionr  X   Noner  X   Noner  r  ah1X%   SetTransparency(self, selection=None)r  h3h4h5X   14r  h7j  ubehd]r  (]r  X   objectr  a]r  (]r  X
   simplewrapperr  a]r  (]r  X   wrapperr  a]r  (]r  X   Objectr  a]r  (]r  X
   EvtHandlerr  a]r  (]r  X
   WindowBaser  a]r  (]r  X   Windowr  a]r  (]r  X   Controlr  a]r  ]r  j   aaeeee]r  X	   Trackabler  a]r  (]r  j  a]r  (]r  j  a]r  (]r  j  a]r  (]r  j  a]r  ]r  j   aaeeeeeeeehk]r  hm]r  X
   wx.Controlr  ah1X   MultiColumnListCtrl(wx.Control)r  hpcsphinxtools.inheritance
InheritanceDiagram
r  )r  }r  (X
   class_infor  ]r  (X5   wx.lib.agw.aui.aui_switcherdialog.MultiColumnListCtrlr  ]r  X
   wx.Controlr  ar  X
   wx.Controlr  ]r  X	   wx.Windowr  ar  X	   wx.Windowr  ]r  X
   wx.WindowBaser  ar  X
   wx.WindowBaser  ]r  X
   wx.EvtHandlerr  ar  X
   wx.EvtHandlerr  ]r  (X	   wx.Objectr  X   wx.Trackabler  er  X	   wx.Objectr  ]r  r  X   wx.Trackabler  ]r  r  eX   specialsr  ]r  X5   wx.lib.agw.aui.aui_switcherdialog.MultiColumnListCtrlr  aX
   main_classr  j  ubh'Kh3hqhrXh   /home/wxpy/bb2/dist-src-py37/build/docs/sphinx/wx.lib.agw.aui.aui_switcherdialog.MultiColumnListCtrl.txtr  h7j  h5X   370r  X   method_listr  ]r  (X   __init__r  X   AdvanceToNextSelectableItemr  X   CalculateLayoutr  X
   DoGetBestSizer  X   GenerateSelectionEventr  X   GetExtraNavigationKeyr  X   GetItemsr  X   GetModifierKeyr  X   OnCharr  X   OnEraseBackgroundr  X   OnKeyr  X   OnMouseEventr  X   OnPaintr  X   SetExtraNavigationKeyr  X   SetItemsr  X   SetModifierKeyr  X   SetTransparencyr  eX   basesr  j  ubh)r  }r  (hX0   wx.lib.agw.aui.aui_switcherdialog.SwitcherDialogr  hKhX   SwitcherDialog shows a :class:`Dialog` with a list of panes and tabs for the user to choose.
``Ctrl`` + ``Tab`` cycles through them.r  hhh	h
]r   (h#)r  }r  (hX9   wx.lib.agw.aui.aui_switcherdialog.SwitcherDialog.__init__r  hKh'KhX   Default class constructor. r  hhh	h)]r  (X   itemsr  hhr  X   parentr  hhr	  X   aui_managerr
  hhr  X   idr  X	   wx.ID_ANYr
  X   -1r  r  X   titler  X   _("Pane Switcher")r  X
   Pane Switcherr  r  X   posr  X   wx.DefaultPositionr  X   (-1, -1)r  r  X   sizer  X   wx.DefaultSizer  X   (-1, -1)r  r  X   styler  X3   wx.STAY_ON_TOP|wx.DIALOG_NO_PARENT|wx.BORDER_SIMPLEr  X   33587232r  r  eh1X   __init__(self, items, parent, aui_manager, id=wx.ID_ANY, title=_("Pane Switcher"), pos=wx.DefaultPosition, size=wx.DefaultSize, style=wx.STAY_ON_TOP|wx.DIALOG_NO_PARENT|wx.BORDER_SIMPLE)r   h3h4h5X   56r!  h7j  ubh#)r"  }r#  (hXB   wx.lib.agw.aui.aui_switcherdialog.SwitcherDialog.ColourToHexStringr$  hKh'Khhhhh	h)]r%  X   colr&  hhr'  ah1X   ColourToHexString(self, col)r(  h3h4h5hIh7j  ubh#)r)  }r*  (hXF   wx.lib.agw.aui.aui_switcherdialog.SwitcherDialog.GetExtraNavigationKeyr+  hKh'Khhhhh	h)]r,  h1X   GetExtraNavigationKey(self)r-  h3h4h5h6h7j  ubh#)r.  }r/  (hX?   wx.lib.agw.aui.aui_switcherdialog.SwitcherDialog.GetModifierKeyr0  hKh'Khhhhh	h)]r1  h1X   GetModifierKey(self)r2  h3h4h5h6h7j  ubh#)r3  }r4  (hX=   wx.lib.agw.aui.aui_switcherdialog.SwitcherDialog.GetSelectionr5  hKh'Khhhhh	h)]r6  h1X   GetSelection(self)r7  h3h4h5h6h7j  ubh#)r8  }r9  (hX;   wx.lib.agw.aui.aui_switcherdialog.SwitcherDialog.OnActivater:  hKh'Khhhhh	h)]r;  X   eventr<  hhr=  ah1X   OnActivate(self, event)r>  h3h4h5jA  h7j  ubh#)r?  }r@  (hX>   wx.lib.agw.aui.aui_switcherdialog.SwitcherDialog.OnCloseWindowrA  hKh'Khhhhh	h)]rB  X   eventrC  hhrD  ah1X   OnCloseWindow(self, event)rE  h3h4h5X   15rF  h7j  ubh#)rG  }rH  (hX8   wx.lib.agw.aui.aui_switcherdialog.SwitcherDialog.OnPaintrI  hKh'Khhhhh	h)]rJ  X   eventrK  hhrL  ah1X   OnPaint(self, event)rM  h3h4h5X   17rN  h7j  ubh#)rO  }rP  (hX=   wx.lib.agw.aui.aui_switcherdialog.SwitcherDialog.OnSelectItemrQ  hKh'Khhhhh	h)]rR  X   eventrS  hhrT  ah1X   OnSelectItem(self, event)rU  h3h4h5h6h7j  ubh#)rV  }rW  (hX@   wx.lib.agw.aui.aui_switcherdialog.SwitcherDialog.SetBorderColourrX  hKh'Khhhhh	h)]rY  X   colourrZ  hhr[  ah1X   SetBorderColour(self, colour)r\  h3h4h5h6h7j  ubh#)r]  }r^  (hXF   wx.lib.agw.aui.aui_switcherdialog.SwitcherDialog.SetExtraNavigationKeyr_  hKh'Khhhhh	h)]r`  X   keyCodera  hhrb  ah1X$   SetExtraNavigationKey(self, keyCode)rc  h3h4h5hCh7j  ubh#)rd  }re  (hX?   wx.lib.agw.aui.aui_switcherdialog.SwitcherDialog.SetModifierKeyrf  hKh'Khhhhh	h)]rg  X   modifierKeyrh  hhri  ah1X!   SetModifierKey(self, modifierKey)rj  h3h4h5hCh7j  ubh#)rk  }rl  (hX@   wx.lib.agw.aui.aui_switcherdialog.SwitcherDialog.ShowDescriptionrm  hKh'Khhhhh	h)]rn  X   iro  hhrp  ah1X   ShowDescription(self, i)rq  h3h4h5X   18rr  h7j  ubehd]rs  (]rt  X   objectru  a]rv  (]rw  X
   simplewrapperrx  a]ry  (]rz  X   wrapperr{  a]r|  (]r}  j  a]r~  (]r  j  a]r  (]r  j  a]r  (]r  j  a]r  (]r  X   NonOwnedWindowr  a]r  (]r  X   TopLevelWindowr  a]r  (]r  X   Dialogr  a]r  ]r  X   SwitcherDialogr  aaeeeeee]r  j  a]r  (]r  j  a]r  (]r  j  a]r  (]r  j  a]r  (]r  j  a]r  (]r  j  a]r  (]r  j  a]r  ]r  j  aaeeeeeeeeeehk]r  hm]r  X	   wx.Dialogr  ah1X   SwitcherDialog(wx.Dialog)r  hpj  )r  }r  (j  ]r  (X0   wx.lib.agw.aui.aui_switcherdialog.SwitcherDialogr  ]r  X	   wx.Dialogr  ar  X	   wx.Dialogr  ]r  X   wx.TopLevelWindowr  ar  X   wx.TopLevelWindowr  ]r  X   wx.NonOwnedWindowr  ar  X   wx.NonOwnedWindowr  ]r  X	   wx.Windowr  ar  X	   wx.Windowr  ]r  X
   wx.WindowBaser  ar  X
   wx.WindowBaser  ]r  X
   wx.EvtHandlerr  ar  X
   wx.EvtHandlerr  ]r  (X	   wx.Objectr  X   wx.Trackabler  er  X	   wx.Objectr  ]r  r  X   wx.Trackabler  ]r  r  ej  ]r  X0   wx.lib.agw.aui.aui_switcherdialog.SwitcherDialogr  aj  j  ubh'Kh3hqhrXc   /home/wxpy/bb2/dist-src-py37/build/docs/sphinx/wx.lib.agw.aui.aui_switcherdialog.SwitcherDialog.txtr  h7j  h5X   169r  j  ]r  (X   __init__r  X   ColourToHexStringr  X   GetExtraNavigationKeyr  X   GetModifierKeyr  X   GetSelectionr  X
   OnActivater  X
   OnCloseWindowr  X   OnPaintr  X   OnSelectItemr  X   SetBorderColourr  X   SetExtraNavigationKeyr  X   SetModifierKeyr  X   ShowDescriptionr  ej  j  ubh)r  }r  (hX.   wx.lib.agw.aui.aui_switcherdialog.SwitcherItemr  hKhX1   An object containing information about one item. r  hhh	h
]r  (h#)r  }r  (hX7   wx.lib.agw.aui.aui_switcherdialog.SwitcherItem.__init__r  hKh'KhX   Default class constructor. r  hhh	h)]r  X   itemr  X   Noner  X   Noner  r  ah1X   __init__(self, item=None)r  h3h4h5X   18r  h7j  ubh#)r  }r  (hX:   wx.lib.agw.aui.aui_switcherdialog.SwitcherItem.BreakColumnr  hKh'Khhhhh	h)]r  X   breakColr  X   Truer  h/r  ah1X    BreakColumn(self, breakCol=True)r  h3h4h5hIh7j  ubh#)r  }r  (hX3   wx.lib.agw.aui.aui_switcherdialog.SwitcherItem.Copyr  hKh'KhXs   Copy operator between 2 :class:`SwitcherItem` instances.

:param `item`: another instance of :class:`SwitcherItem`.r  hhh	h)]r  X   itemr  hhr  ah1X   Copy(self, item)r  h3h4h5X   21r  h7j  ubh#)r  }r  (hX8   wx.lib.agw.aui.aui_switcherdialog.SwitcherItem.GetBitmapr  hKh'Khhhhh	h)]r  h1X   GetBitmap(self)r 	  h3h4h5h6h7j  ubh#)r	  }r	  (hX=   wx.lib.agw.aui.aui_switcherdialog.SwitcherItem.GetBreakColumnr	  hKh'Khhhhh	h)]r	  h1X   GetBreakColumn(self)r	  h3h4h5h6h7j  ubh#)r	  }r	  (hX8   wx.lib.agw.aui.aui_switcherdialog.SwitcherItem.GetColPosr	  hKh'Khhhhh	h)]r		  h1X   GetColPos(self)r
	  h3h4h5h6h7j  ubh#)r	  }r	  (hX=   wx.lib.agw.aui.aui_switcherdialog.SwitcherItem.GetDescriptionr
	  hKh'Khhhhh	h)]r	  h1X   GetDescription(self)r	  h3h4h5h6h7j  ubh#)r	  }r	  (hX6   wx.lib.agw.aui.aui_switcherdialog.SwitcherItem.GetFontr	  hKh'Khhhhh	h)]r	  h1X
   GetFont(self)r	  h3h4h5h6h7j  ubh#)r	  }r	  (hX4   wx.lib.agw.aui.aui_switcherdialog.SwitcherItem.GetIdr	  hKh'Khhhhh	h)]r	  h1X   GetId(self)r	  h3h4h5h6h7j  ubh#)r	  }r	  (hX9   wx.lib.agw.aui.aui_switcherdialog.SwitcherItem.GetIsGroupr	  hKh'Khhhhh	h)]r	  h1X   GetIsGroup(self)r	  h3h4h5h6h7j  ubh#)r	  }r 	  (hX6   wx.lib.agw.aui.aui_switcherdialog.SwitcherItem.GetNamer!	  hKh'Khhhhh	h)]r"	  h1X
   GetName(self)r#	  h3h4h5h6h7j  ubh#)r$	  }r%	  (hX6   wx.lib.agw.aui.aui_switcherdialog.SwitcherItem.GetRectr&	  hKh'Khhhhh	h)]r'	  h1X
   GetRect(self)r(	  h3h4h5h6h7j  ubh#)r)	  }r*	  (hX8   wx.lib.agw.aui.aui_switcherdialog.SwitcherItem.GetRowPosr+	  hKh'Khhhhh	h)]r,	  h1X   GetRowPos(self)r-	  h3h4h5h6h7j  ubh#)r.	  }r/	  (hX<   wx.lib.agw.aui.aui_switcherdialog.SwitcherItem.GetTextColourr0	  hKh'Khhhhh	h)]r1	  h1X   GetTextColour(self)r2	  h3h4h5h6h7j  ubh#)r3	  }r4	  (hX7   wx.lib.agw.aui.aui_switcherdialog.SwitcherItem.GetTitler5	  hKh'Khhhhh	h)]r6	  h1X   GetTitle(self)r7	  h3h4h5h6h7j  ubh#)r8	  }r9	  (hX8   wx.lib.agw.aui.aui_switcherdialog.SwitcherItem.GetWindowr:	  hKh'Khhhhh	h)]r;	  h1X   GetWindow(self)r<	  h3h4h5h6h7j  ubh#)r=	  }r>	  (hX8   wx.lib.agw.aui.aui_switcherdialog.SwitcherItem.SetBitmapr?	  hKh'Khhhhh	h)]r@	  X   bitmaprA	  hhrB	  ah1X   SetBitmap(self, bitmap)rC	  h3h4h5hIh7j  ubh#)rD	  }rE	  (hX8   wx.lib.agw.aui.aui_switcherdialog.SwitcherItem.SetColPosrF	  hKh'Khhhhh	h)]rG	  X   posrH	  hhrI	  ah1X   SetColPos(self, pos)rJ	  h3h4h5hIh7j  ubh#)rK	  }rL	  (hX=   wx.lib.agw.aui.aui_switcherdialog.SwitcherItem.SetDescriptionrM	  hKh'Khhhhh	h)]rN	  X   descrrO	  hhrP	  ah1X   SetDescription(self, descr)rQ	  h3h4h5hIh7j  ubh#)rR	  }rS	  (hX6   wx.lib.agw.aui.aui_switcherdialog.SwitcherItem.SetFontrT	  hKh'Khhhhh	h)]rU	  X   fontrV	  hhrW	  ah1X   SetFont(self, font)rX	  h3h4h5hIh7j  ubh#)rY	  }rZ	  (hX4   wx.lib.agw.aui.aui_switcherdialog.SwitcherItem.SetIdr[	  hKh'Khhhhh	h)]r\	  X   idr]	  hhr^	  ah1X   SetId(self, id)r_	  h3h4h5hIh7j  ubh#)r`	  }ra	  (hX9   wx.lib.agw.aui.aui_switcherdialog.SwitcherItem.SetIsGrouprb	  hKh'Khhhhh	h)]rc	  X   isGrouprd	  hhre	  ah1X   SetIsGroup(self, isGroup)rf	  h3h4h5hIh7j  ubh#)rg	  }rh	  (hX6   wx.lib.agw.aui.aui_switcherdialog.SwitcherItem.SetNameri	  hKh'Khhhhh	h)]rj	  X   namerk	  hhrl	  ah1X   SetName(self, name)rm	  h3h4h5hIh7j  ubh#)rn	  }ro	  (hX6   wx.lib.agw.aui.aui_switcherdialog.SwitcherItem.SetRectrp	  hKh'Khhhhh	h)]rq	  X   rectrr	  hhrs	  ah1X   SetRect(self, rect)rt	  h3h4h5hIh7j  ubh#)ru	  }rv	  (hX8   wx.lib.agw.aui.aui_switcherdialog.SwitcherItem.SetRowPosrw	  hKh'Khhhhh	h)]rx	  X   posry	  hhrz	  ah1X   SetRowPos(self, pos)r{	  h3h4h5hIh7j  ubh#)r|	  }r}	  (hX<   wx.lib.agw.aui.aui_switcherdialog.SwitcherItem.SetTextColourr~	  hKh'Khhhhh	h)]r	  X   colourr	  hhr	  ah1X   SetTextColour(self, colour)r	  h3h4h5hIh7j  ubh#)r	  }r	  (hX7   wx.lib.agw.aui.aui_switcherdialog.SwitcherItem.SetTitler	  hKh'Khhhhh	h)]r	  X   titler	  hhr	  ah1X   SetTitle(self, title)r	  h3h4h5hIh7j  ubh#)r	  }r	  (hX8   wx.lib.agw.aui.aui_switcherdialog.SwitcherItem.SetWindowr	  hKh'Khhhhh	h)]r	  X   winr	  hhr	  ah1X   SetWindow(self, win)r	  h3h4h5hIh7j  ubehd]r	  (]r	  X   objectr	  a]r	  ]r	  X   SwitcherItemr	  aaehk]r	  hm]r	  h1X   SwitcherItem(object)r	  hpj  )r	  }r	  (j  ]r	  X.   wx.lib.agw.aui.aui_switcherdialog.SwitcherItemr	  ]r	  r	  aj  ]r	  X.   wx.lib.agw.aui.aui_switcherdialog.SwitcherItemr	  aj  j  ubh'Kh3hqhrXa   /home/wxpy/bb2/dist-src-py37/build/docs/sphinx/wx.lib.agw.aui.aui_switcherdialog.SwitcherItem.txtr	  h7j  h5X   186r	  j  ]r	  (X   __init__r	  X   BreakColumnr	  X   Copyr	  X	   GetBitmapr	  X   GetBreakColumnr	  X	   GetColPosr	  X   GetDescriptionr	  X   GetFontr	  X   GetIdr	  X
   GetIsGroupr	  X   GetNamer	  X   GetRectr	  X	   GetRowPosr	  X
   GetTextColourr	  X   GetTitler	  X	   GetWindowr	  X	   SetBitmapr	  X	   SetColPosr	  X   SetDescriptionr	  X   SetFontr	  X   SetIdr	  X
   SetIsGroupr	  X   SetNamer	  X   SetRectr	  X	   SetRowPosr	  X
   SetTextColourr	  X   SetTitler	  X	   SetWindowr	  ej  j	  ubh)r	  }r	  (hX/   wx.lib.agw.aui.aui_switcherdialog.SwitcherItemsr	  hKhX%   An object containing switcher items. r	  hhh	h
]r	  (h#)r	  }r	  (hX8   wx.lib.agw.aui.aui_switcherdialog.SwitcherItems.__init__r	  hKh'KhX   Default class constructor. r	  hhh	h)]r	  X   itemsr	  X   Noner	  X   Noner	  r	  ah1X   __init__(self, items=None)r	  h3h4h5X   23r	  h7j	  ubh#)r	  }r	  (hX8   wx.lib.agw.aui.aui_switcherdialog.SwitcherItems.AddGroupr	  hKh'Khhhhh	h)]r	  (X   titler	  hhr	  X   namer	  hhr	  X   idr	  j  X   0r	  r	  X   bitmapr	  X
   wx.NullBitmapr	  X*   <wx._core.Bitmap object at 0x7f7afe99ac30>r	  r	  eh1X7   AddGroup(self, title, name, id=0, bitmap=wx.NullBitmap)r	  h3h4h5jA  h7j	  ubh#)r	  }r	  (hX7   wx.lib.agw.aui.aui_switcherdialog.SwitcherItems.AddItemr	  hKh'Khhhhh	h)]r	  (X   titleOrItemr	  hhr	  X   namer	  X   Noner	  X   Noner	  r	  X   idr	  j  X   0r	  r	  X   bitmapr	  X
   wx.NullBitmapr	  X*   <wx._core.Bitmap object at 0x7f7afe99ac30>r	  r	  eh1XA   AddItem(self, titleOrItem, name=None, id=0, bitmap=wx.NullBitmap)r	  h3h4h5X   15r	  h7j	  ubh#)r	  }r	  (hXA   wx.lib.agw.aui.aui_switcherdialog.SwitcherItems.CalculateItemSizer	  hKh'Khhhhh	h)]r	  X   dcr	  hhr	  ah1X   CalculateItemSize(self, dc)r	  h3h4h5X   41r	  h7j	  ubh#)r	  }r	  (hX5   wx.lib.agw.aui.aui_switcherdialog.SwitcherItems.Clearr	  hKh'Khhhhh	h)]r	  h1X   Clear(self)r 
  h3h4h5h6h7j	  ubh#)r
  }r
  (hX4   wx.lib.agw.aui.aui_switcherdialog.SwitcherItems.Copyr
  hKh'KhXl   Copy operator between 2 :class:`SwitcherItems`.

:param `items`: another instance of :class:`SwitcherItems`.r
  hhh	h)]r
  X   itemsr
  hhr
  ah1X   Copy(self, items)r
  h3h4h5X   22r	
  h7j	  ubh#)r

  }r
  (hX<   wx.lib.agw.aui.aui_switcherdialog.SwitcherItems.FindItemByIdr
  hKh'Khhhhh	h)]r
  X   idr
  hhr
  ah1X   FindItemById(self, id)r
  h3h4h5j~  h7j	  ubh#)r
  }r
  (hX>   wx.lib.agw.aui.aui_switcherdialog.SwitcherItems.FindItemByNamer
  hKh'Khhhhh	h)]r
  X   namer
  hhr
  ah1X   FindItemByName(self, name)r
  h3h4h5j~  h7j	  ubh#)r
  }r
  (hXC   wx.lib.agw.aui.aui_switcherdialog.SwitcherItems.GetBackgroundColourr
  hKh'Khhhhh	h)]r
  h1X   GetBackgroundColour(self)r
  h3h4h5h6h7j	  ubh#)r
  }r
  (hX>   wx.lib.agw.aui.aui_switcherdialog.SwitcherItems.GetColumnCountr
  hKh'Khhhhh	h)]r 
  h1X   GetColumnCount(self)r!
  h3h4h5h6h7j	  ubh#)r"
  }r#
  (hX@   wx.lib.agw.aui.aui_switcherdialog.SwitcherItems.GetIndexForFocusr$
  hKh'Khhhhh	h)]r%
  h1X   GetIndexForFocus(self)r&
  h3h4h5X   10r'
  h7j	  ubh#)r(
  }r)
  (hX7   wx.lib.agw.aui.aui_switcherdialog.SwitcherItems.GetItemr*
  hKh'Khhhhh	h)]r+
  jo  hhr,
  ah1X   GetItem(self, i)r-
  h3h4h5h6h7j	  ubh#)r.
  }r/
  (hX<   wx.lib.agw.aui.aui_switcherdialog.SwitcherItems.GetItemCountr0
  hKh'Khhhhh	h)]r1
  h1X   GetItemCount(self)r2
  h3h4h5h6h7j	  ubh#)r3
  }r4
  (hX;   wx.lib.agw.aui.aui_switcherdialog.SwitcherItems.GetItemFontr5
  hKh'Khhhhh	h)]r6
  h1X   GetItemFont(self)r7
  h3h4h5h6h7j	  ubh#)r8
  }r9
  (hX;   wx.lib.agw.aui.aui_switcherdialog.SwitcherItems.GetRowCountr:
  hKh'Khhhhh	h)]r;
  h1X   GetRowCount(self)r<
  h3h4h5h6h7j	  ubh#)r=
  }r>
  (hX<   wx.lib.agw.aui.aui_switcherdialog.SwitcherItems.GetSelectionr?
  hKh'Khhhhh	h)]r@
  h1X   GetSelection(self)rA
  h3h4h5h6h7j	  ubh#)rB
  }rC
  (hXB   wx.lib.agw.aui.aui_switcherdialog.SwitcherItems.GetSelectionColourrD
  hKh'Khhhhh	h)]rE
  h1X   GetSelectionColour(self)rF
  h3h4h5h6h7j	  ubh#)rG
  }rH
  (hXI   wx.lib.agw.aui.aui_switcherdialog.SwitcherItems.GetSelectionOutlineColourrI
  hKh'Khhhhh	h)]rJ
  h1X   GetSelectionOutlineColour(self)rK
  h3h4h5h6h7j	  ubh#)rL
  }rM
  (hX=   wx.lib.agw.aui.aui_switcherdialog.SwitcherItems.GetTextColourrN
  hKh'Khhhhh	h)]rO
  h1X   GetTextColour(self)rP
  h3h4h5h6h7j	  ubh#)rQ
  }rR
  (hX:   wx.lib.agw.aui.aui_switcherdialog.SwitcherItems.PaintItemsrS
  hKh'Khhhhh	h)]rT
  (X   dcrU
  hhrV
  X   winrW
  hhrX
  eh1X   PaintItems(self, dc, win)rY
  h3h4h5X   80rZ
  h7j	  ubh#)r[
  }r\
  (hXC   wx.lib.agw.aui.aui_switcherdialog.SwitcherItems.SetBackgroundColourr]
  hKh'Khhhhh	h)]r^
  X   colourr_
  hhr`
  ah1X!   SetBackgroundColour(self, colour)ra
  h3h4h5h6h7j	  ubh#)rb
  }rc
  (hX>   wx.lib.agw.aui.aui_switcherdialog.SwitcherItems.SetColumnCountrd
  hKh'Khhhhh	h)]re
  X   colsrf
  hhrg
  ah1X   SetColumnCount(self, cols)rh
  h3h4h5h6h7j	  ubh#)ri
  }rj
  (hX;   wx.lib.agw.aui.aui_switcherdialog.SwitcherItems.SetItemFontrk
  hKh'Khhhhh	h)]rl
  X   fontrm
  hhrn
  ah1X   SetItemFont(self, font)ro
  h3h4h5h6h7j	  ubh#)rp
  }rq
  (hX;   wx.lib.agw.aui.aui_switcherdialog.SwitcherItems.SetRowCountrr
  hKh'Khhhhh	h)]rs
  X   rowsrt
  hhru
  ah1X   SetRowCount(self, rows)rv
  h3h4h5h6h7j	  ubh#)rw
  }rx
  (hX<   wx.lib.agw.aui.aui_switcherdialog.SwitcherItems.SetSelectionry
  hKh'Khhhhh	h)]rz
  X   selr{
  hhr|
  ah1X   SetSelection(self, sel)r}
  h3h4h5h6h7j	  ubh#)r~
  }r
  (hXB   wx.lib.agw.aui.aui_switcherdialog.SwitcherItems.SetSelectionByNamer
  hKh'Khhhhh	h)]r
  X   namer
  hhr
  ah1X   SetSelectionByName(self, name)r
  h3h4h5hCh7j	  ubh#)r
  }r
  (hXB   wx.lib.agw.aui.aui_switcherdialog.SwitcherItems.SetSelectionColourr
  hKh'Khhhhh	h)]r
  X   colourr
  hhr
  ah1X    SetSelectionColour(self, colour)r
  h3h4h5h6h7j	  ubh#)r
  }r
  (hXI   wx.lib.agw.aui.aui_switcherdialog.SwitcherItems.SetSelectionOutlineColourr
  hKh'Khhhhh	h)]r
  X   colourr
  hhr
  ah1X'   SetSelectionOutlineColour(self, colour)r
  h3h4h5h6h7j	  ubh#)r
  }r
  (hX=   wx.lib.agw.aui.aui_switcherdialog.SwitcherItems.SetTextColourr
  hKh'Khhhhh	h)]r
  X   colourr
  hhr
  ah1X   SetTextColour(self, colour)r
  h3h4h5h6h7j	  ubehd]r
  (]r
  X   objectr
  a]r
  ]r
  X
   SwitcherItemsr
  aaehk]r
  hm]r
  h1X   SwitcherItems(object)r
  hpj  )r
  }r
  (j  ]r
  X/   wx.lib.agw.aui.aui_switcherdialog.SwitcherItemsr
  ]r
  r
  aj  ]r
  X/   wx.lib.agw.aui.aui_switcherdialog.SwitcherItemsr
  aj  j	  ubh'Kh3hqhrXb   /home/wxpy/bb2/dist-src-py37/build/docs/sphinx/wx.lib.agw.aui.aui_switcherdialog.SwitcherItems.txtr
  h7j  h5X   327r
  j  ]r
  (X   __init__r
  X   AddGroupr
  X   AddItemr
  X   CalculateItemSizer
  X   Clearr
  X   Copyr
  X   FindItemByIdr
  X   FindItemByNamer
  X   GetBackgroundColourr
  X   GetColumnCountr
  X   GetIndexForFocusr
  X   GetItemr
  X   GetItemCountr
  X   GetItemFontr
  X   GetRowCountr
  X   GetSelectionr
  X   GetSelectionColourr
  X   GetSelectionOutlineColourr
  X
   GetTextColourr
  X
   PaintItemsr
  X   SetBackgroundColourr
  X   SetColumnCountr
  X   SetItemFontr
  X   SetRowCountr
  X   SetSelectionr
  X   SetSelectionByNamer
  X   SetSelectionColourr
  X   SetSelectionOutlineColourr
  X
   SetTextColourr
  ej  j
  ubh#)r
  }r
  (hX5   wx.lib.agw.aui.aui_switcherdialog.FindFocusDescendantr
  hKh'KhX   Find a window with the focus, that is also a descendant of the given window.
This is used to determine the window to initially send commands to.

:param wx.Window `ancestor`: the window to check for ancestry.r
  hhh	h)]r
  X   ancestorr
  hhr
  ah1X   FindFocusDescendant(ancestor)r
  h3h4h5X   25r
  X   firstlinenor
  X   349r
  h7j  ubhu)r
  }r
  (hX8   wx.lib.agw.aui.aui_switcherdialog.SWITCHER_TEXT_MARGIN_Xr
  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r
  hhh	hzX   4r
  h|X   intr
  h3h~h7j  ubhu)r
  }r
  (hX8   wx.lib.agw.aui.aui_switcherdialog.SWITCHER_TEXT_MARGIN_Yr
  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r
  hhh	hzX   1r
  h|X   intr
  h3h~h7j  ubej  XG   /home/wxpy/bb2/dist-src-py37/build/wx/lib/agw/aui/aui_switcherdialog.pyr
  hrXT   /home/wxpy/bb2/dist-src-py37/build/docs/sphinx/wx.lib.agw.aui.aui_switcherdialog.txtr
  h'Kh3j  hpj  )r
  }r
  (j  ]r
  (X5   wx.lib.agw.aui.aui_switcherdialog.MultiColumnListCtrlr
  ]r
  X
   wx.Controlr
  ar
  X
   wx.Controlr
  ]r
  X	   wx.Windowr
  ar
  X	   wx.Windowr
  ]r
  X
   wx.WindowBaser
  ar
  X
   wx.WindowBaser
  ]r
  X
   wx.EvtHandlerr
  ar
  X
   wx.EvtHandlerr
  ]r
  (X	   wx.Objectr
  X   wx.Trackabler
  er
  X	   wx.Objectr
  ]r
  r
  X   wx.Trackabler
  ]r   r  X0   wx.lib.agw.aui.aui_switcherdialog.SwitcherDialogr  ]r  X	   wx.Dialogr  ar  X	   wx.Dialogr  ]r  X   wx.TopLevelWindowr  ar	  X   wx.TopLevelWindowr
  ]r  X   wx.NonOwnedWindowr  ar
  X   wx.NonOwnedWindowr  ]r  X	   wx.Windowr  ar  X.   wx.lib.agw.aui.aui_switcherdialog.SwitcherItemr  ]r  r  X/   wx.lib.agw.aui.aui_switcherdialog.SwitcherItemsr  ]r  r  ej  ]r  (X5   wx.lib.agw.aui.aui_switcherdialog.MultiColumnListCtrlr  X0   wx.lib.agw.aui.aui_switcherdialog.SwitcherDialogr  X.   wx.lib.agw.aui.aui_switcherdialog.SwitcherItemr  X/   wx.lib.agw.aui.aui_switcherdialog.SwitcherItemsr  ej  j  ubh7hubh)r  }r  (hX   wx.lib.agw.aui.aui_utilitiesr  hKhX   This module contains some common functions used by :mod:`lib.agw.aui` to
manipulate colours, bitmaps, text, gradient shadings and custom dragging images
for :class:`~wx.lib.agw.aui.auibook.AuiNotebook` tabs.r   hX  # -*- coding: utf-8 -*-
#----------------------------------------------------------------------------
# Name:         aui_utilities.py
# Purpose:
#
# Author:       Andrea Gavana <andrea.gavana@gmail.com>
#
# Created:
# Version:
# Date:         31 March 2009
# Licence:      wxWindows license
# Tags:         phoenix-port, unittest, documented, py3-port
#----------------------------------------------------------------------------
r!  h	h
]r"  (h)r#  }r$  (hX,   wx.lib.agw.aui.aui_utilities.PyEmbeddedImager%  hKhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.r&  hhh	h
]r'  (h#)r(  }r)  (hX5   wx.lib.agw.aui.aui_utilities.PyEmbeddedImage.__init__r*  hKh'KhX>   Initialize self.  See help(type(self)) for accurate signature.r+  hhh	h)]r,  (X   datar-  hhr.  X   isBase64r/  X   Truer0  h/r1  eh1X#   __init__(self, data, isBase64=True)r2  h3h4h5h6h7j#  ubh#)r3  }r4  (hX6   wx.lib.agw.aui.aui_utilities.PyEmbeddedImage.GetBitmapr5  hKh'Khhhhh	h)]r6  h1X   GetBitmap(self)r7  h3h4h5h=h7j#  ubh#)r8  }r9  (hX4   wx.lib.agw.aui.aui_utilities.PyEmbeddedImage.GetDatar:  hKh'Khhhhh	h)]r;  h1X
   GetData(self)r<  h3h4h5hCh7j#  ubh#)r=  }r>  (hX4   wx.lib.agw.aui.aui_utilities.PyEmbeddedImage.GetIconr?  hKh'Khhhhh	h)]r@  h1X
   GetIcon(self)rA  h3h4h5hIh7j#  ubh#)rB  }rC  (hX5   wx.lib.agw.aui.aui_utilities.PyEmbeddedImage.GetImagerD  hKh'Khhhhh	h)]rE  h1X   GetImage(self)rF  h3h4h5h6h7j#  ubhO)rG  }rH  (hX3   wx.lib.agw.aui.aui_utilities.PyEmbeddedImage.BitmaprI  hKh'Khhhhh	hShThUhhVhh3hWh7j#  ubhO)rJ  }rK  (hX1   wx.lib.agw.aui.aui_utilities.PyEmbeddedImage.DatarL  hKh'Khhhhh	hSh[hUhhVhh3hWh7j#  ubhO)rM  }rN  (hX1   wx.lib.agw.aui.aui_utilities.PyEmbeddedImage.IconrO  hKh'Khhhhh	hSh_hUhhVhh3hWh7j#  ubhO)rP  }rQ  (hX2   wx.lib.agw.aui.aui_utilities.PyEmbeddedImage.ImagerR  hKh'Khhhhh	hShchUhhVhh3hWh7j#  ubehd]rS  (]rT  X   objectrU  a]rV  ]rW  hjaaehk]rX  hm]rY  h1X   PyEmbeddedImage(object)rZ  hpNh'Kh3hqhrX_   /home/wxpy/bb2/dist-src-py37/build/docs/sphinx/wx.lib.agw.aui.aui_utilities.PyEmbeddedImage.txtr[  h7j  h5X   52r\  ubh)r]  }r^  (hX)   wx.lib.agw.aui.aui_utilities.TabDragImager_  hKhX]   This class handles the creation of a custom image in case of drag and drop of a notebook tab.r`  hhh	h
]ra  (h#)rb  }rc  (hX2   wx.lib.agw.aui.aui_utilities.TabDragImage.__init__rd  hKh'KhX  Default class constructor.

For internal use: do not call it in your code!

:param `notebook`: an instance of :class:`~wx.lib.agw.aui.auibook.AuiNotebook`;
:param `page`: the dragged :class:`~wx.lib.agw.aui.auibook.AuiNotebookPage` page;
:param integer `button_state`: the state of the close button on the tab;
:param `tabArt`: an instance of :class:`~wx.lib.agw.aui.tabart.AuiDefaultTabArt` or one of its derivations.re  hhh	h)]rf  (X   notebookrg  hhrh  X   pageri  hhrj  X   button_staterk  hhrl  X   tabArtrm  hhrn  eh1X4   __init__(self, notebook, page, button_state, tabArt)ro  h3h4h5X   16rp  h7j]  ubh#)rq  }rr  (hX6   wx.lib.agw.aui.aui_utilities.TabDragImage.CreateBitmaprs  hKh'KhX  Actually creates the drag and drop bitmap.

:param `notebook`: an instance of :class:`~wx.lib.agw.aui.auibook.AuiNotebook`;
:param `page`: the dragged :class:`~wx.lib.agw.aui.auibook.AuiNotebookPage` page;
:param integer `button_state`: the state of the close button on the tab;
:param `tabArt`: an instance of :class:`~wx.lib.agw.aui.tabart.AuiDefaultTabArt` or one of its derivations.rt  hhh	h)]ru  (X   notebookrv  hhrw  X   pagerx  hhry  X   button_staterz  hhr{  X   tabArtr|  hhr}  eh1X8   CreateBitmap(self, notebook, page, button_state, tabArt)r~  h3h4h5X   67r  h7j]  ubehd]r  (]r  X   objectr  a]r  (]r  X
   simplewrapperr  a]r  (]r  X   wrapperr  a]r  (]r  j  a]r  (]r  X	   DragImager  a]r  ]r  X   TabDragImager  aaeeeeehk]r  hm]r  X   wx.DragImager  ah1X   TabDragImage(wx.DragImage)r  hpj  )r  }r  (j  ]r  (X)   wx.lib.agw.aui.aui_utilities.TabDragImager  ]r  X   wx.DragImager  ar  X   wx.DragImager  ]r  X	   wx.Objectr  ar  X	   wx.Objectr  ]r  r  ej  ]r  X)   wx.lib.agw.aui.aui_utilities.TabDragImager  aj  j]  ubh'Kh3hqhrX\   /home/wxpy/bb2/dist-src-py37/build/docs/sphinx/wx.lib.agw.aui.aui_utilities.TabDragImage.txtr  h7j  h5X   89r  j  ]r  (X   __init__r  X   CreateBitmapr  ej  j  ubh#)r  }r  (hX+   wx.lib.agw.aui.aui_utilities.BitmapFromBitsr  hKh'KhX)  A utility function that creates a masked bitmap from raw bits (XBM format).

:param string `bits`: the raw bits of the bitmap;
:param integer `w`: the bitmap width;
:param integer `h`: the bitmap height;
:param wx.Colour `colour`: the colour which will replace all white pixels in the
 raw bitmap.r  hhh	h)]r  (X   bitsr  hhr  X   wr  hhr  X   hr  hhr  X   colourr  hhr  eh1X"   BitmapFromBits(bits, w, h, colour)r  h3h4h5X   17r  j
  X   147r  h7j  ubh#)r  }r  (hX(   wx.lib.agw.aui.aui_utilities.BlendColourr  hKh'KhX
  Blends the two colour component `fg` and `bg` into one colour component, adding
an optional alpha channel.

:param wx.Colour `fg`: the first colour component;
:param wx.Colour `bg`: the second colour component;
:param integer `alpha`: an optional transparency value.r  hhh	h)]r  (X   fgr  hhr  X   bgr  hhr  X   alphar  hhr  eh1X   BlendColour(fg, bg, alpha)r  h3h4h5X   19r  j
  X   38r  h7j  ubh#)r  }r  (hX%   wx.lib.agw.aui.aui_utilities.ChopTextr  hKh'KhX  Chops the input `text` if its size does not fit in `max_size`, by cutting the
text and adding ellipsis at the end.

:param `dc`: a :class:`wx.DC` device context;
:param string `text`: the text to chop;
:param integer `max_size`: the maximum size in which the text should fit.r  hhh	h)]r  (X   dcr  hhr  X   textr  hhr  X   max_sizer  hhr  eh1X   ChopText(dc, text, max_size)r  h3h4h5X   32r  j
  X   114r  h7j  ubh#)r  }r  (hX!   wx.lib.agw.aui.aui_utilities.Clipr  hKh'KhX   Clips the value in `a` based on the extremes `b` and `c`.

:param `a`: the value to analyze;
:param `b`: a minimum value;
:param `c`: a maximum value.r  hhh	h)]r  (X   ar  hhr  X   br  hhr  X   cr  hhr  eh1X
   Clip(a, b, c)r  h3h4h5X   11r  j
  X   220r  h7j  ubh#)r  }r  (hX+   wx.lib.agw.aui.aui_utilities.CopyAttributesr  hKh'KhX   Copies pens, brushes, colours and fonts from the old tab art to the new one.

:param `newArt`: the new instance of :class:`~wx.lib.agw.aui.tabart.AuiDefaultTabArt`;
:param `oldArt`: the old instance of :class:`~wx.lib.agw.aui.tabart.AuiDefaultTabArt`.r  hhh	h)]r  (X   newArtr  hhr  X   oldArtr  hhr  eh1X   CopyAttributes(newArt, oldArt)r  h3h4h5X   18r  j
  X   652r  h7j  ubh#)r  }r  (hX)   wx.lib.agw.aui.aui_utilities.DarkenBitmapr  hKh'KhX   Darkens the input bitmap on wxMAC using the input colour.

:param wx.Bitmap `bmp`: the bitmap to be manipulated;
:param wx.Colour `caption_colour`: the colour of the pane caption;
:param wx.Colour `new_colour`: the colour used to darken the bitmap.r  hhh	h)]r  (X   bmpr  hhr  X   caption_colourr  hhr  X
   new_colourr  hhr  eh1X-   DarkenBitmap(bmp, caption_colour, new_colour)r  h3h4h5X   16r  j
  X   315r  h7j  ubh#)r  }r  (hX2   wx.lib.agw.aui.aui_utilities.DrawGradientRectangler   hKh'KhXg  Draws a gradient-shaded rectangle.

:param `dc`: a :class:`wx.DC` device context;
:param wx.Rect `rect`: the rectangle in which to draw the gradient;
:param wx.Colour `start_colour`: the first colour of the gradient;
:param wx.Colour `end_colour`: the second colour of the gradient;
:param integer `direction`: the gradient direction (horizontal or vertical).r  hhh	h)]r  (X   dcr  hhr  X   rectr  hhr  X   start_colourr  hhr  X
   end_colourr	  hhr
  X	   directionr  hhr  X   offsetr
  j  X   0r  r  X   lengthr  j  X   0r  r  eh1XX   DrawGradientRectangle(dc, rect, start_colour, end_colour, direction, offset=0, length=0)r  h3h4h5X   16r  j
  X   332r  h7j  ubh#)r  }r  (hX/   wx.lib.agw.aui.aui_utilities.DrawMACCloseButtonr  hKh'KhX   Draws the wxMAC tab close button using :class:`GraphicsContext`.

:param wx.Colour `colour`: the colour to use to draw the circle;
:param wx.Colour `backColour`: the optional background colour for the circle.r  hhh	h)]r  (X   colourr  hhr  X
   backColourr  X   Noner  X   Noner  r   eh1X+   DrawMACCloseButton(colour, backColour=None)r!  h3h4h5X   38r"  j
  X   276r#  h7j  ubh#)r$  }r%  (hX0   wx.lib.agw.aui.aui_utilities.FindFocusDescendantr&  hKh'KhX   Find a window with the focus, that is also a descendant of the given window.
This is used to determine the window to initially send commands to.

:param wx.Window `ancestor`: the window to check for ancestry.r'  hhh	h)]r(  X   ancestorr)  hhr*  ah1X   FindFocusDescendant(ancestor)r+  h3h4h5X   25r,  j
  X   349r-  h7j  ubh#)r.  }r/  (hX*   wx.lib.agw.aui.aui_utilities.GetBaseColourr0  hKh'KhXv   Returns the face shading colour on push buttons/backgrounds,
mimicking as closely as possible the platform UI colours.r1  hhh	h)]r2  h1X   GetBaseColour()r3  h3h4h5X   29r4  j
  X   180r5  h7j  ubh#)r6  }r7  (hX,   wx.lib.agw.aui.aui_utilities.GetDockingImager8  hKh'KhX9  Returns the correct name of the docking bitmap depending on the input parameters.

:param bool `useAero`: whether :class:`~wx.lib.agw.aui.framemanager.AuiManager` is using
 Aero-style or Whidbey-style docking images or not;
:param bool `center`: whether we are looking for the center diamond-shaped bitmap or not.r9  hhh	h)]r:  (X	   directionr;  hhr<  X   useAeror=  hhr>  X   centerr?  hhr@  eh1X+   GetDockingImage(direction, useAero, center)rA  h3h4h5X   36rB  j
  X   495rC  h7j  ubh#)rD  }rE  (hX)   wx.lib.agw.aui.aui_utilities.GetLabelSizerF  hKh'KhX   Returns the :class:`~wx.lib.agw.aui.auibar.AuiToolBar` item label size.

:param string `label`: the toolbar tool label;
:param bool `vertical`: whether the toolbar tool orientation is vertical or not.rG  hhh	h)]rH  (X   dcrI  hhrJ  X   labelrK  hhrL  X   verticalrM  hhrN  eh1X!   GetLabelSize(dc, label, vertical)rO  h3h4h5X   23rP  j
  X   375rQ  h7j  ubh#)rR  }rS  (hX-   wx.lib.agw.aui.aui_utilities.GetSlidingPointsrT  hKh'KhX  Returns the point at which the sliding in and out of a minimized pane begins.

:param wx.Rect `rect`: the :class:`~wx.lib.agw.aui.auibar.AuiToolBar` tool screen rectangle;
:param wx.Size `size`: the pane window size;
:param integer `direction`: the pane docking direction.rU  hhh	h)]rV  (X   rectrW  hhrX  X   sizerY  hhrZ  X	   directionr[  hhr\  eh1X'   GetSlidingPoints(rect, size, direction)r]  h3h4h5X   29r^  j
  X   622r_  h7j  ubh#)r`  }ra  (hX0   wx.lib.agw.aui.aui_utilities.IndentPressedBitmaprb  hKh'KhX   Indents the input rectangle `rect` based on the value of `button_state`.

:param wx.Rect `rect`: the button bitmap rectangle;
:param integer `button_state`: the button state.rc  hhh	h)]rd  (X   rectre  hhrf  X   button_staterg  hhrh  eh1X'   IndentPressedBitmap(rect, button_state)ri  h3h4h5X   14rj  j
  X   165rk  h7j  ubh#)rl  }rm  (hX(   wx.lib.agw.aui.aui_utilities.LightColourrn  hKh'KhX   Brighten input `colour` by `percent`.

:param wx.Colour `colour`: the colour to be brightened;
:param integer `percent`: brightening percentage.ro  hhh	h)]rp  (X   colourrq  hhrr  X   percentrs  hhrt  eh1X   LightColour(colour, percent)ru  h3h4h5X   24rv  j
  X   232rw  h7j  ubh#)rx  }ry  (hX0   wx.lib.agw.aui.aui_utilities.LightContrastColourrz  hKh'KhXp   Creates a new, lighter colour based on the input colour `c`.

:param wx.Colour `c`: the input colour to analyze.r{  hhh	h)]r|  j  hhr}  ah1X   LightContrastColour(c)r~  h3h4h5X   16r  j
  X   97r  h7j  ubh#)r  }r  (hX/   wx.lib.agw.aui.aui_utilities.MakeDisabledBitmapr  hKh'KhX   Convert the given image (in place) to a grayed-out version, appropriate for a 'disabled' appearance.

:param wx.Bitmap `bitmap`: the bitmap to gray-out.r  hhh	h)]r  X   bitmapr  hhr  ah1X   MakeDisabledBitmap(bitmap)r  h3h4h5X   9r  j
  X   210r  h7j  ubh#)r  }r  (hX4   wx.lib.agw.aui.aui_utilities.PaneCreateStippleBitmapr  hKh'KhXd   Creates a stipple bitmap to be used in a :class:`wx.Brush`.

This is used to draw sash resize hints.r  hhh	h)]r  h1X   PaneCreateStippleBitmap()r  h3h4h5X   18r  j
  X   257r  h7j  ubh#)r  }r  (hX.   wx.lib.agw.aui.aui_utilities.RescaleScreenShotr  hKh'KhX   Rescales a bitmap to be `thumbnail_size` pixels wide (or tall) at maximum.

:param wx.Bitmap `bmp`: the bitmap to rescale;
:param integer `thumbnail_size`: the maximum size of every page thumbnail.r  hhh	h)]r  (X   bmpr  hhr  X   thumbnail_sizer  X   200r  X   200r  r  eh1X*   RescaleScreenShot(bmp, thumbnail_size=200)r  h3h4h5X   49r  j
  X   572r  h7j  ubh#)r  }r  (hX'   wx.lib.agw.aui.aui_utilities.StepColourr  hKh'KhX   Darken/lighten the input colour `c`.

:param wx.Colour `c`: a colour to darken/lighten;
:param integer `ialpha`: a transparency value.r  hhh	h)]r  (j  hhr  X   ialphar  hhr  eh1X   StepColour(c, ialpha)r  h3h4h5X   38r  j
  X   58r  h7j  ubh#)r  }r  (hX+   wx.lib.agw.aui.aui_utilities.TakeScreenShotr  hKh'KhX   Takes a screenshot of the screen at given position and size (`rect`).

:param wx.Rect `rect`: the screen rectangle for which we want to take a screenshot.r  hhh	h)]r  X   rectr  hhr  ah1X   TakeScreenShot(rect)r  h3h4h5X   39r  j
  X   532r  h7j  ubhu)r  }r  (hX'   wx.lib.agw.aui.aui_utilities.__author__r  hKh'KhX  str(object='') -> str
str(bytes_or_buffer[, encoding[, errors]]) -> str

Create a new string object from the given object. If encoding or
errors is specified, then the object must expose a data buffer
that will be decoded using the given encoding and error handler.
Otherwise, returns the result of object.__str__() (if defined)
or repr(object).
encoding defaults to sys.getdefaultencoding().
errors defaults to 'strict'.r  hhh	hzX)   'Andrea Gavana <andrea.gavana@gmail.com>'r  h|X   strr  h3h~h7j  ubhu)r  }r  (hX%   wx.lib.agw.aui.aui_utilities.__date__r  hKh'KhX  str(object='') -> str
str(bytes_or_buffer[, encoding[, errors]]) -> str

Create a new string object from the given object. If encoding or
errors is specified, then the object must expose a data buffer
that will be decoded using the given encoding and error handler.
Otherwise, returns the result of object.__str__() (if defined)
or repr(object).
encoding defaults to sys.getdefaultencoding().
errors defaults to 'strict'.r  hhh	hzX   '31 March 2009'r  h|X   strr  h3h~h7j  ubhu)r  }r  (hX.   wx.lib.agw.aui.aui_utilities.actionClickButtonr  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   2r  h|X   intr  h3h~h7j  ubhu)r  }r  (hX/   wx.lib.agw.aui.aui_utilities.actionClickCaptionr  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   3r  h|X   intr  h3h~h7j  ubhu)r  }r  (hX3   wx.lib.agw.aui.aui_utilities.actionDragFloatingPaner  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   5r  h|X   intr  h3h~h7j  ubhu)r  }r  (hX2   wx.lib.agw.aui.aui_utilities.actionDragMovablePaner  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   6r  h|X   intr  h3h~h7j  ubhu)r  }r  (hX2   wx.lib.agw.aui.aui_utilities.actionDragToolbarPaner  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   4r  h|X   intr  h3h~h7j  ubhu)r  }r  (hX'   wx.lib.agw.aui.aui_utilities.actionNoner  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   0r  h|X   intr  h3h~h7j  ubhu)r  }r  (hX)   wx.lib.agw.aui.aui_utilities.actionResizer  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   1r  h|X   intr  h3h~h7j  ubhu)r  }r  (hX(   wx.lib.agw.aui.aui_utilities.aero_deniedr  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.r  hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f7afe726e10>r  h|X$   wx.lib.embeddedimage.PyEmbeddedImager  h3h~h7j  ubhu)r  }r  (hX+   wx.lib.agw.aui.aui_utilities.aero_dock_paner  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.r  hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f7afe726790>r  h|X$   wx.lib.embeddedimage.PyEmbeddedImager  h3h~h7j  ubhu)r  }r  (hX2   wx.lib.agw.aui.aui_utilities.aero_dock_pane_bottomr  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.r  hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f7afe726910>r  h|X$   wx.lib.embeddedimage.PyEmbeddedImager  h3h~h7j  ubhu)r  }r  (hX2   wx.lib.agw.aui.aui_utilities.aero_dock_pane_centerr 
  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.r
  hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f7afe726950>r
  h|X$   wx.lib.embeddedimage.PyEmbeddedImager
  h3h~h7j  ubhu)r
  }r
  (hX2   wx.lib.agw.aui.aui_utilities.aero_dock_pane_deniedr
  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.r
  hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f7afe7268d0>r
  h|X$   wx.lib.embeddedimage.PyEmbeddedImager	
  h3h~h7j  ubhu)r

  }r
  (hX0   wx.lib.agw.aui.aui_utilities.aero_dock_pane_leftr
  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.r

  hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f7afe726990>r
  h|X$   wx.lib.embeddedimage.PyEmbeddedImager
  h3h~h7j  ubhu)r
  }r
  (hX1   wx.lib.agw.aui.aui_utilities.aero_dock_pane_rightr
  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.r
  hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f7afe7269d0>r
  h|X$   wx.lib.embeddedimage.PyEmbeddedImager
  h3h~h7j  ubhu)r
  }r
  (hX/   wx.lib.agw.aui.aui_utilities.aero_dock_pane_topr
  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.r
  hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f7afe726a10>r
  h|X$   wx.lib.embeddedimage.PyEmbeddedImager
  h3h~h7j  ubhu)r
  }r
  (hX&   wx.lib.agw.aui.aui_utilities.aero_downr
  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.r
  hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f7afe726a50>r 
  h|X$   wx.lib.embeddedimage.PyEmbeddedImager!
  h3h~h7j  ubhu)r"
  }r#
  (hX,   wx.lib.agw.aui.aui_utilities.aero_down_focusr$
  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.r%
  hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f7afe726a90>r&
  h|X$   wx.lib.embeddedimage.PyEmbeddedImager'
  h3h~h7j  ubhu)r(
  }r)
  (hX3   wx.lib.agw.aui.aui_utilities.aero_down_focus_singler*
  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.r+
  hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f7afe726a90>r,
  h|X$   wx.lib.embeddedimage.PyEmbeddedImager-
  h3h~h7j  ubhu)r.
  }r/
  (hX-   wx.lib.agw.aui.aui_utilities.aero_down_singler0
  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.r1
  hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f7afe726ad0>r2
  h|X$   wx.lib.embeddedimage.PyEmbeddedImager3
  h3h~h7j  ubhu)r4
  }r5
  (hX&   wx.lib.agw.aui.aui_utilities.aero_leftr6
  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.r7
  hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f7afe726b10>r8
  h|X$   wx.lib.embeddedimage.PyEmbeddedImager9
  h3h~h7j  ubhu)r:
  }r;
  (hX,   wx.lib.agw.aui.aui_utilities.aero_left_focusr<
  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.r=
  hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f7afe726b50>r>
  h|X$   wx.lib.embeddedimage.PyEmbeddedImager?
  h3h~h7j  ubhu)r@
  }rA
  (hX3   wx.lib.agw.aui.aui_utilities.aero_left_focus_singlerB
  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.rC
  hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f7afe726b50>rD
  h|X$   wx.lib.embeddedimage.PyEmbeddedImagerE
  h3h~h7j  ubhu)rF
  }rG
  (hX-   wx.lib.agw.aui.aui_utilities.aero_left_singlerH
  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.rI
  hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f7afe726b90>rJ
  h|X$   wx.lib.embeddedimage.PyEmbeddedImagerK
  h3h~h7j  ubhu)rL
  }rM
  (hX'   wx.lib.agw.aui.aui_utilities.aero_rightrN
  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.rO
  hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f7afe726bd0>rP
  h|X$   wx.lib.embeddedimage.PyEmbeddedImagerQ
  h3h~h7j  ubhu)rR
  }rS
  (hX-   wx.lib.agw.aui.aui_utilities.aero_right_focusrT
  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.rU
  hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f7afe726c10>rV
  h|X$   wx.lib.embeddedimage.PyEmbeddedImagerW
  h3h~h7j  ubhu)rX
  }rY
  (hX4   wx.lib.agw.aui.aui_utilities.aero_right_focus_singlerZ
  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.r[
  hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f7afe726c10>r\
  h|X$   wx.lib.embeddedimage.PyEmbeddedImager]
  h3h~h7j  ubhu)r^
  }r_
  (hX.   wx.lib.agw.aui.aui_utilities.aero_right_singler`
  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.ra
  hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f7afe726c50>rb
  h|X$   wx.lib.embeddedimage.PyEmbeddedImagerc
  h3h~h7j  ubhu)rd
  }re
  (hX%   wx.lib.agw.aui.aui_utilities.aero_tabrf
  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.rg
  hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f7afe726c90>rh
  h|X$   wx.lib.embeddedimage.PyEmbeddedImageri
  h3h~h7j  ubhu)rj
  }rk
  (hX+   wx.lib.agw.aui.aui_utilities.aero_tab_focusrl
  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.rm
  hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f7afe726cd0>rn
  h|X$   wx.lib.embeddedimage.PyEmbeddedImagero
  h3h~h7j  ubhu)rp
  }rq
  (hX2   wx.lib.agw.aui.aui_utilities.aero_tab_focus_singlerr
  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.rs
  hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f7afe726cd0>rt
  h|X$   wx.lib.embeddedimage.PyEmbeddedImageru
  h3h~h7j  ubhu)rv
  }rw
  (hX,   wx.lib.agw.aui.aui_utilities.aero_tab_singlerx
  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.ry
  hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f7afe726d10>rz
  h|X$   wx.lib.embeddedimage.PyEmbeddedImager{
  h3h~h7j  ubhu)r|
  }r}
  (hX$   wx.lib.agw.aui.aui_utilities.aero_upr~
  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.r
  hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f7afe726d50>r
  h|X$   wx.lib.embeddedimage.PyEmbeddedImager
  h3h~h7j  ubhu)r
  }r
  (hX*   wx.lib.agw.aui.aui_utilities.aero_up_focusr
  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.r
  hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f7afe726d90>r
  h|X$   wx.lib.embeddedimage.PyEmbeddedImager
  h3h~h7j  ubhu)r
  }r
  (hX1   wx.lib.agw.aui.aui_utilities.aero_up_focus_singler
  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.r
  hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f7afe726d90>r
  h|X$   wx.lib.embeddedimage.PyEmbeddedImager
  h3h~h7j  ubhu)r
  }r
  (hX+   wx.lib.agw.aui.aui_utilities.aero_up_singler
  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.r
  hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f7afe726dd0>r
  h|X$   wx.lib.embeddedimage.PyEmbeddedImager
  h3h~h7j  ubhu)r
  }r
  (hX+   wx.lib.agw.aui.aui_utilities.aeroguideSizeXr
  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r
  hhh	hzX   31r
  h|X   intr
  h3h~h7j  ubhu)r
  }r
  (hX+   wx.lib.agw.aui.aui_utilities.aeroguideSizeYr
  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r
  hhh	hzX   32r
  h|X   intr
  h3h~h7j  ubhu)r
  }r
  (hX-   wx.lib.agw.aui.aui_utilities.AUI_BUTTON_CLOSEr
  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r
  hhh	hzX   101r
  h|X   intr
  h3h~h7j  ubhu)r
  }r
  (hX/   wx.lib.agw.aui.aui_utilities.AUI_BUTTON_CUSTOM1r
  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r
  hhh	hzX   201r
  h|X   intr
  h3h~h7j  ubhu)r
  }r
  (hX/   wx.lib.agw.aui.aui_utilities.AUI_BUTTON_CUSTOM2r
  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r
  hhh	hzX   202r
  h|X   intr
  h3h~h7j  ubhu)r
  }r
  (hX/   wx.lib.agw.aui.aui_utilities.AUI_BUTTON_CUSTOM3r
  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r
  hhh	hzX   203r
  h|X   intr
  h3h~h7j  ubhu)r
  }r
  (hX/   wx.lib.agw.aui.aui_utilities.AUI_BUTTON_CUSTOM4r
  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r
  hhh	hzX   204r
  h|X   intr
  h3h~h7j  ubhu)r
  }r
  (hX/   wx.lib.agw.aui.aui_utilities.AUI_BUTTON_CUSTOM5r
  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r
  hhh	hzX   205r
  h|X   intr
  h3h~h7j  ubhu)r
  }r
  (hX/   wx.lib.agw.aui.aui_utilities.AUI_BUTTON_CUSTOM6r
  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r
  hhh	hzX   206r
  h|X   intr
  h3h~h7j  ubhu)r
  }r
  (hX/   wx.lib.agw.aui.aui_utilities.AUI_BUTTON_CUSTOM7r
  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r
  hhh	hzX   207r
  h|X   intr
  h3h~h7j  ubhu)r
  }r
  (hX/   wx.lib.agw.aui.aui_utilities.AUI_BUTTON_CUSTOM8r
  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r
  hhh	hzX   208r
  h|X   intr
  h3h~h7j  ubhu)r
  }r
  (hX/   wx.lib.agw.aui.aui_utilities.AUI_BUTTON_CUSTOM9r
  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r
  hhh	hzX   209r
  h|X   intr
  h3h~h7j  ubhu)r
  }r
  (hX,   wx.lib.agw.aui.aui_utilities.AUI_BUTTON_DOWNr
  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r
  hhh	hzX   110r
  h|X   intr
  h3h~h7j  ubhu)r
  }r
  (hX,   wx.lib.agw.aui.aui_utilities.AUI_BUTTON_LEFTr
  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r
  hhh	hzX   107r
  h|X   intr
  h3h~h7j  ubhu)r
  }r
  (hX8   wx.lib.agw.aui.aui_utilities.AUI_BUTTON_MAXIMIZE_RESTOREr
  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r
  hhh	hzX   102r
  h|X   intr
  h3h~h7j  ubhu)r
  }r
  (hX0   wx.lib.agw.aui.aui_utilities.AUI_BUTTON_MINIMIZEr
  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r
  hhh	hzX   103r
  h|X   intr
  h3h~h7j  ubhu)r
  }r
  (hX/   wx.lib.agw.aui.aui_utilities.AUI_BUTTON_OPTIONSr
  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r
  hhh	hzX   105r
  h|X   intr
  h3h~h7j  ubhu)r
  }r
  (hX+   wx.lib.agw.aui.aui_utilities.AUI_BUTTON_PINr
  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r
  hhh	hzX   104r
  h|X   intr
  h3h~h7j  ubhu)r   }r  (hX-   wx.lib.agw.aui.aui_utilities.AUI_BUTTON_RIGHTr  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   108r  h|X   intr  h3h~h7j  ubhu)r  }r  (hX5   wx.lib.agw.aui.aui_utilities.AUI_BUTTON_STATE_CHECKEDr  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r	  hhh	hzX   32r
  h|X   intr  h3h~h7j  ubhu)r  }r
  (hX6   wx.lib.agw.aui.aui_utilities.AUI_BUTTON_STATE_DISABLEDr  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   8r  h|X   intr  h3h~h7j  ubhu)r  }r  (hX4   wx.lib.agw.aui.aui_utilities.AUI_BUTTON_STATE_HIDDENr  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   16r  h|X   intr  h3h~h7j  ubhu)r  }r  (hX3   wx.lib.agw.aui.aui_utilities.AUI_BUTTON_STATE_HOVERr  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   2r  h|X   intr  h3h~h7j  ubhu)r  }r  (hX4   wx.lib.agw.aui.aui_utilities.AUI_BUTTON_STATE_NORMALr   hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r!  hhh	hzX   0r"  h|X   intr#  h3h~h7j  ubhu)r$  }r%  (hX5   wx.lib.agw.aui.aui_utilities.AUI_BUTTON_STATE_PRESSEDr&  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r'  hhh	hzX   4r(  h|X   intr)  h3h~h7j  ubhu)r*  }r+  (hX*   wx.lib.agw.aui.aui_utilities.AUI_BUTTON_UPr,  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r-  hhh	hzX   109r.  h|X   intr/  h3h~h7j  ubhu)r0  }r1  (hX2   wx.lib.agw.aui.aui_utilities.AUI_BUTTON_WINDOWLISTr2  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r3  hhh	hzX   106r4  h|X   intr5  h3h~h7j  ubhu)r6  }r7  (hX,   wx.lib.agw.aui.aui_utilities.AUI_DOCK_BOTTOMr8  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r9  hhh	hzX   3r:  h|X   intr;  h3h~h7j  ubhu)r<  }r=  (hX,   wx.lib.agw.aui.aui_utilities.AUI_DOCK_CENTERr>  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r?  hhh	hzX   5r@  h|X   intrA  h3h~h7j  ubhu)rB  }rC  (hX,   wx.lib.agw.aui.aui_utilities.AUI_DOCK_CENTRErD  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4rE  hhh	hzX   5rF  h|X   intrG  h3h~h7j  ubhu)rH  }rI  (hX*   wx.lib.agw.aui.aui_utilities.AUI_DOCK_LEFTrJ  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4rK  hhh	hzX   4rL  h|X   intrM  h3h~h7j  ubhu)rN  }rO  (hX*   wx.lib.agw.aui.aui_utilities.AUI_DOCK_NONErP  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4rQ  hhh	hzX   0rR  h|X   intrS  h3h~h7j  ubhu)rT  }rU  (hX3   wx.lib.agw.aui.aui_utilities.AUI_DOCK_NOTEBOOK_PAGErV  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4rW  hhh	hzX   6rX  h|X   intrY  h3h~h7j  ubhu)rZ  }r[  (hX+   wx.lib.agw.aui.aui_utilities.AUI_DOCK_RIGHTr\  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r]  hhh	hzX   2r^  h|X   intr_  h3h~h7j  ubhu)r`  }ra  (hX)   wx.lib.agw.aui.aui_utilities.AUI_DOCK_TOPrb  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4rc  hhh	hzX   1rd  h|X   intre  h3h~h7j  ubhu)rf  }rg  (hX>   wx.lib.agw.aui.aui_utilities.AUI_DOCKART_ACTIVE_CAPTION_COLOURrh  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4ri  hhh	hzX   8rj  h|X   intrk  h3h~h7j  ubhu)rl  }rm  (hXG   wx.lib.agw.aui.aui_utilities.AUI_DOCKART_ACTIVE_CAPTION_GRADIENT_COLOURrn  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4ro  hhh	hzX   9rp  h|X   intrq  h3h~h7j  ubhu)rr  }rs  (hXC   wx.lib.agw.aui.aui_utilities.AUI_DOCKART_ACTIVE_CAPTION_TEXT_COLOURrt  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4ru  hhh	hzX   12rv  h|X   intrw  h3h~h7j  ubhu)rx  }ry  (hX:   wx.lib.agw.aui.aui_utilities.AUI_DOCKART_BACKGROUND_COLOURrz  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r{  hhh	hzX   5r|  h|X   intr}  h3h~h7j  ubhu)r~  }r  (hXC   wx.lib.agw.aui.aui_utilities.AUI_DOCKART_BACKGROUND_GRADIENT_COLOURr  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   6r  h|X   intr  h3h~h7j  ubhu)r  }r  (hX6   wx.lib.agw.aui.aui_utilities.AUI_DOCKART_BORDER_COLOURr  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   14r  h|X   intr  h3h~h7j  ubhu)r  }r  (hX5   wx.lib.agw.aui.aui_utilities.AUI_DOCKART_CAPTION_FONTr  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   16r  h|X   intr  h3h~h7j  ubhu)r  }r  (hX5   wx.lib.agw.aui.aui_utilities.AUI_DOCKART_CAPTION_SIZEr  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   1r  h|X   intr  h3h~h7j  ubhu)r  }r  (hX7   wx.lib.agw.aui.aui_utilities.AUI_DOCKART_DRAW_SASH_GRIPr  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   18r  h|X   intr  h3h~h7j  ubhu)r  }r  (hX6   wx.lib.agw.aui.aui_utilities.AUI_DOCKART_GRADIENT_TYPEr  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   17r  h|X   intr  h3h~h7j  ubhu)r  }r  (hX7   wx.lib.agw.aui.aui_utilities.AUI_DOCKART_GRIPPER_COLOURr  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   15r  h|X   intr  h3h~h7j  ubhu)r  }r  (hX5   wx.lib.agw.aui.aui_utilities.AUI_DOCKART_GRIPPER_SIZEr  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   2r  h|X   intr  h3h~h7j  ubhu)r  }r  (hXB   wx.lib.agw.aui.aui_utilities.AUI_DOCKART_HINT_WINDOW_BORDER_COLOURr  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   20r  h|X   intr  h3h~h7j  ubhu)r  }r  (hX;   wx.lib.agw.aui.aui_utilities.AUI_DOCKART_HINT_WINDOW_COLOURr  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   19r  h|X   intr  h3h~h7j  ubhu)r  }r  (hX@   wx.lib.agw.aui.aui_utilities.AUI_DOCKART_INACTIVE_CAPTION_COLOURr  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   10r  h|X   intr  h3h~h7j  ubhu)r  }r  (hXI   wx.lib.agw.aui.aui_utilities.AUI_DOCKART_INACTIVE_CAPTION_GRADIENT_COLOURr  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   11r  h|X   intr  h3h~h7j  ubhu)r  }r  (hXE   wx.lib.agw.aui.aui_utilities.AUI_DOCKART_INACTIVE_CAPTION_TEXT_COLOURr  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   13r  h|X   intr  h3h~h7j  ubhu)r  }r  (hX9   wx.lib.agw.aui.aui_utilities.AUI_DOCKART_PANE_BORDER_SIZEr  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   3r  h|X   intr  h3h~h7j  ubhu)r  }r  (hX9   wx.lib.agw.aui.aui_utilities.AUI_DOCKART_PANE_BUTTON_SIZEr  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   4r  h|X   intr  h3h~h7j  ubhu)r  }r  (hX4   wx.lib.agw.aui.aui_utilities.AUI_DOCKART_SASH_COLOURr  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   7r  h|X   intr  h3h~h7j  ubhu)r  }r  (hX2   wx.lib.agw.aui.aui_utilities.AUI_DOCKART_SASH_SIZEr  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   0r  h|X   intr  h3h~h7j  ubhu)r  }r  (hX4   wx.lib.agw.aui.aui_utilities.AUI_GRADIENT_HORIZONTALr  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   2r  h|X   intr  h3h~h7j  ubhu)r  }r  (hX.   wx.lib.agw.aui.aui_utilities.AUI_GRADIENT_NONEr  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   0r  h|X   intr  h3h~h7j  ubhu)r  }r  (hX2   wx.lib.agw.aui.aui_utilities.AUI_GRADIENT_VERTICALr  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   1r  h|X   intr  h3h~h7j  ubhu)r  }r  (hX,   wx.lib.agw.aui.aui_utilities.AUI_INSERT_DOCKr  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   2r  h|X   intr  h3h~h7j  ubhu)r  }r  (hX,   wx.lib.agw.aui.aui_utilities.AUI_INSERT_PANEr  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   0r   h|X   intr  h3h~h7j  ubhu)r  }r  (hX+   wx.lib.agw.aui.aui_utilities.AUI_INSERT_ROWr  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   1r  h|X   intr  h3h~h7j  ubhu)r  }r	  (hX8   wx.lib.agw.aui.aui_utilities.AUI_MGR_AERO_DOCKING_GUIDESr
  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   1024r  h|X   intr
  h3h~h7j  ubhu)r  }r  (hX6   wx.lib.agw.aui.aui_utilities.AUI_MGR_ALLOW_ACTIVE_PANEr  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   2r  h|X   intr  h3h~h7j  ubhu)r  }r  (hX3   wx.lib.agw.aui.aui_utilities.AUI_MGR_ALLOW_FLOATINGr  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   1r  h|X   intr  h3h~h7j  ubhu)r  }r  (hX3   wx.lib.agw.aui.aui_utilities.AUI_MGR_ANIMATE_FRAMESr  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   512r  h|X   intr  h3h~h7j  ubhu)r   }r!  (hX6   wx.lib.agw.aui.aui_utilities.AUI_MGR_AUTONB_NO_CAPTIONr"  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r#  hhh	hzX   32768r$  h|X   intr%  h3h~h7j  ubhu)r&  }r'  (hX,   wx.lib.agw.aui.aui_utilities.AUI_MGR_DEFAULTr(  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r)  hhh	hzX   201r*  h|X   intr+  h3h~h7j  ubhu)r,  }r-  (hX.   wx.lib.agw.aui.aui_utilities.AUI_MGR_HINT_FADEr.  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r/  hhh	hzX   64r0  h|X   intr1  h3h~h7j  ubhu)r2  }r3  (hX0   wx.lib.agw.aui.aui_utilities.AUI_MGR_LIVE_RESIZEr4  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r5  hhh	hzX   256r6  h|X   intr7  h3h~h7j  ubhu)r8  }r9  (hX<   wx.lib.agw.aui.aui_utilities.AUI_MGR_NO_VENETIAN_BLINDS_FADEr:  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r;  hhh	hzX   128r<  h|X   intr=  h3h~h7j  ubhu)r>  }r?  (hX<   wx.lib.agw.aui.aui_utilities.AUI_MGR_PREVIEW_MINIMIZED_PANESr@  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4rA  hhh	hzX   2048rB  h|X   intrC  h3h~h7j  ubhu)rD  }rE  (hX3   wx.lib.agw.aui.aui_utilities.AUI_MGR_RECTANGLE_HINTrF  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4rG  hhh	hzX   32rH  h|X   intrI  h3h~h7j  ubhu)rJ  }rK  (hX3   wx.lib.agw.aui.aui_utilities.AUI_MGR_SMOOTH_DOCKINGrL  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4rM  hhh	hzX   8192rN  h|X   intrO  h3h~h7j  ubhu)rP  }rQ  (hX5   wx.lib.agw.aui.aui_utilities.AUI_MGR_TRANSPARENT_DRAGrR  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4rS  hhh	hzX   4rT  h|X   intrU  h3h~h7j  ubhu)rV  }rW  (hX5   wx.lib.agw.aui.aui_utilities.AUI_MGR_TRANSPARENT_HINTrX  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4rY  hhh	hzX   8rZ  h|X   intr[  h3h~h7j  ubhu)r\  }r]  (hX:   wx.lib.agw.aui.aui_utilities.AUI_MGR_USE_NATIVE_MINIFRAMESr^  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r_  hhh	hzX   16384r`  h|X   intra  h3h~h7j  ubhu)rb  }rc  (hX9   wx.lib.agw.aui.aui_utilities.AUI_MGR_VENETIAN_BLINDS_HINTrd  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4re  hhh	hzX   16rf  h|X   intrg  h3h~h7j  ubhu)rh  }ri  (hX;   wx.lib.agw.aui.aui_utilities.AUI_MGR_WHIDBEY_DOCKING_GUIDESrj  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4rk  hhh	hzX   4096rl  h|X   intrm  h3h~h7j  ubhu)rn  }ro  (hX3   wx.lib.agw.aui.aui_utilities.AUI_MINIMIZE_CAPT_HIDErp  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4rq  hhh	hzX   0rr  h|X   intrs  h3h~h7j  ubhu)rt  }ru  (hX3   wx.lib.agw.aui.aui_utilities.AUI_MINIMIZE_CAPT_HORZrv  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4rw  hhh	hzX   16rx  h|X   intry  h3h~h7j  ubhu)rz  }r{  (hX3   wx.lib.agw.aui.aui_utilities.AUI_MINIMIZE_CAPT_MASKr|  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r}  hhh	hzX   24r~  h|X   intr  h3h~h7j  ubhu)r  }r  (hX4   wx.lib.agw.aui.aui_utilities.AUI_MINIMIZE_CAPT_SMARTr  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   8r  h|X   intr  h3h~h7j  ubhu)r  }r  (hX4   wx.lib.agw.aui.aui_utilities.AUI_MINIMIZE_POS_BOTTOMr  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   5r  h|X   intr  h3h~h7j  ubhu)r  }r  (hX2   wx.lib.agw.aui.aui_utilities.AUI_MINIMIZE_POS_LEFTr  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   3r  h|X   intr  h3h~h7j  ubhu)r  }r  (hX2   wx.lib.agw.aui.aui_utilities.AUI_MINIMIZE_POS_MASKr  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   23r  h|X   intr  h3h~h7j  ubhu)r  }r  (hX3   wx.lib.agw.aui.aui_utilities.AUI_MINIMIZE_POS_RIGHTr  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   4r  h|X   intr  h3h~h7j  ubhu)r  }r  (hX3   wx.lib.agw.aui.aui_utilities.AUI_MINIMIZE_POS_SMARTr  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   1r  h|X   intr  h3h~h7j  ubhu)r  }r  (hX5   wx.lib.agw.aui.aui_utilities.AUI_MINIMIZE_POS_TOOLBARr  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   6r  h|X   intr  h3h~h7j  ubhu)r  }r  (hX1   wx.lib.agw.aui.aui_utilities.AUI_MINIMIZE_POS_TOPr  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   2r  h|X   intr  h3h~h7j  ubhu)r  }r  (hX*   wx.lib.agw.aui.aui_utilities.AUI_NB_BOTTOMr  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   8r  h|X   intr  h3h~h7j  ubhu)r  }r  (hX0   wx.lib.agw.aui.aui_utilities.AUI_NB_CLOSE_BUTTONr  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   1024r  h|X   intr  h3h~h7j  ubhu)r  }r  (hX7   wx.lib.agw.aui.aui_utilities.AUI_NB_CLOSE_ON_ACTIVE_TABr  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   2048r  h|X   intr  h3h~h7j  ubhu)r  }r  (hX5   wx.lib.agw.aui.aui_utilities.AUI_NB_CLOSE_ON_ALL_TABSr  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   4096r  h|X   intr  h3h~h7j  ubhu)r  }r  (hX5   wx.lib.agw.aui.aui_utilities.AUI_NB_CLOSE_ON_TAB_LEFTr  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   262144r  h|X   intr  h3h~h7j  ubhu)r  }r  (hX1   wx.lib.agw.aui.aui_utilities.AUI_NB_DEFAULT_STYLEr  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   1059121r  h|X   intr  h3h~h7j  ubhu)r  }r  (hX0   wx.lib.agw.aui.aui_utilities.AUI_NB_DRAW_DND_TABr  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   1048576r  h|X   intr  h3h~h7j  ubhu)r  }r  (hX6   wx.lib.agw.aui.aui_utilities.AUI_NB_HIDE_ON_SINGLE_TABr  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   32768r  h|X   intr  h3h~h7j  ubhu)r  }r  (hX(   wx.lib.agw.aui.aui_utilities.AUI_NB_LEFTr  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   2r  h|X   intr  h3h~h7j  ubhu)r  }r  (hX6   wx.lib.agw.aui.aui_utilities.AUI_NB_MIDDLE_CLICK_CLOSEr  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   8192r  h|X   intr  h3h~h7j  ubhu)r  }r  (hX0   wx.lib.agw.aui.aui_utilities.AUI_NB_NO_TAB_FOCUSr  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   4194304r  h|X   intr  h3h~h7j  ubhu)r  }r  (hX3   wx.lib.agw.aui.aui_utilities.AUI_NB_ORDER_BY_ACCESSr  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   2097152r  h|X   intr  h3h~h7j  ubhu)r  }r  (hX)   wx.lib.agw.aui.aui_utilities.AUI_NB_RIGHTr  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   4r  h|X   intr  h3h~h7j  ubhu)r  }r  (hX2   wx.lib.agw.aui.aui_utilities.AUI_NB_SCROLL_BUTTONSr   hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   256r  h|X   intr  h3h~h7j  ubhu)r  }r  (hX.   wx.lib.agw.aui.aui_utilities.AUI_NB_SMART_TABSr  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   65536r  h|X   intr	  h3h~h7j  ubhu)r
  }r  (hX0   wx.lib.agw.aui.aui_utilities.AUI_NB_SUB_NOTEBOOKr  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r
  hhh	hzX   16384r  h|X   intr  h3h~h7j  ubhu)r  }r  (hX5   wx.lib.agw.aui.aui_utilities.AUI_NB_TAB_EXTERNAL_MOVEr  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   64r  h|X   intr  h3h~h7j  ubhu)r  }r  (hX3   wx.lib.agw.aui.aui_utilities.AUI_NB_TAB_FIXED_WIDTHr  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   128r  h|X   intr  h3h~h7j  ubhu)r  }r  (hX-   wx.lib.agw.aui.aui_utilities.AUI_NB_TAB_FLOATr  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   524288r   h|X   intr!  h3h~h7j  ubhu)r"  }r#  (hX,   wx.lib.agw.aui.aui_utilities.AUI_NB_TAB_MOVEr$  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r%  hhh	hzX   32r&  h|X   intr'  h3h~h7j  ubhu)r(  }r)  (hX-   wx.lib.agw.aui.aui_utilities.AUI_NB_TAB_SPLITr*  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r+  hhh	hzX   16r,  h|X   intr-  h3h~h7j  ubhu)r.  }r/  (hX'   wx.lib.agw.aui.aui_utilities.AUI_NB_TOPr0  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r1  hhh	hzX   1r2  h|X   intr3  h3h~h7j  ubhu)r4  }r5  (hX7   wx.lib.agw.aui.aui_utilities.AUI_NB_USE_IMAGES_DROPDOWNr6  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r7  hhh	hzX   131072r8  h|X   intr9  h3h~h7j  ubhu)r:  }r;  (hX5   wx.lib.agw.aui.aui_utilities.AUI_NB_WINDOWLIST_BUTTONr<  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r=  hhh	hzX   512r>  h|X   intr?  h3h~h7j  ubhu)r@  }rA  (hX-   wx.lib.agw.aui.aui_utilities.AUI_TB_CLOCKWISErB  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4rC  hhh	hzX   256rD  h|X   intrE  h3h~h7j  ubhu)rF  }rG  (hX4   wx.lib.agw.aui.aui_utilities.AUI_TB_COUNTERCLOCKWISErH  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4rI  hhh	hzX   512rJ  h|X   intrK  h3h~h7j  ubhu)rL  }rM  (hX1   wx.lib.agw.aui.aui_utilities.AUI_TB_DEFAULT_STYLErN  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4rO  hhh	hzX   0rP  h|X   intrQ  h3h~h7j  ubhu)rR  }rS  (hX+   wx.lib.agw.aui.aui_utilities.AUI_TB_GRIPPERrT  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4rU  hhh	hzX   8rV  h|X   intrW  h3h~h7j  ubhu)rX  }rY  (hX/   wx.lib.agw.aui.aui_utilities.AUI_TB_HORZ_LAYOUTrZ  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r[  hhh	hzX   64r\  h|X   intr]  h3h~h7j  ubhu)r^  }r_  (hX-   wx.lib.agw.aui.aui_utilities.AUI_TB_HORZ_TEXTr`  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4ra  hhh	hzX   65rb  h|X   intrc  h3h~h7j  ubhu)rd  }re  (hX1   wx.lib.agw.aui.aui_utilities.AUI_TB_NO_AUTORESIZErf  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4rg  hhh	hzX   4rh  h|X   intri  h3h~h7j  ubhu)rj  }rk  (hX/   wx.lib.agw.aui.aui_utilities.AUI_TB_NO_TOOLTIPSrl  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4rm  hhh	hzX   2rn  h|X   intro  h3h~h7j  ubhu)rp  }rq  (hX,   wx.lib.agw.aui.aui_utilities.AUI_TB_OVERFLOWrr  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4rs  hhh	hzX   16rt  h|X   intru  h3h~h7j  ubhu)rv  }rw  (hX4   wx.lib.agw.aui.aui_utilities.AUI_TB_PLAIN_BACKGROUNDrx  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4ry  hhh	hzX   128rz  h|X   intr{  h3h~h7j  ubhu)r|  }r}  (hX(   wx.lib.agw.aui.aui_utilities.AUI_TB_TEXTr~  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   1r  h|X   intr  h3h~h7j  ubhu)r  }r  (hX-   wx.lib.agw.aui.aui_utilities.AUI_TB_VERT_TEXTr  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   289r  h|X   intr  h3h~h7j  ubhu)r  }r  (hX,   wx.lib.agw.aui.aui_utilities.AUI_TB_VERTICALr  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   32r  h|X   intr  h3h~h7j  ubhu)r  }r  (hX3   wx.lib.agw.aui.aui_utilities.AUI_TBART_GRIPPER_SIZEr  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   1r  h|X   intr  h3h~h7j  ubhu)r  }r  (hX4   wx.lib.agw.aui.aui_utilities.AUI_TBART_OVERFLOW_SIZEr  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   2r  h|X   intr  h3h~h7j  ubhu)r  }r  (hX5   wx.lib.agw.aui.aui_utilities.AUI_TBART_SEPARATOR_SIZEr  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   0r  h|X   intr  h3h~h7j  ubhu)r  }r  (hX2   wx.lib.agw.aui.aui_utilities.AUI_TBTOOL_HORIZONTALr  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   0r  h|X   intr  h3h~h7j  ubhu)r  }r  (hX3   wx.lib.agw.aui.aui_utilities.AUI_TBTOOL_TEXT_BOTTOMr  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   3r  h|X   intr  h3h~h7j  ubhu)r  }r  (hX1   wx.lib.agw.aui.aui_utilities.AUI_TBTOOL_TEXT_LEFTr  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   0r  h|X   intr  h3h~h7j  ubhu)r  }r  (hX2   wx.lib.agw.aui.aui_utilities.AUI_TBTOOL_TEXT_RIGHTr  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   1r  h|X   intr  h3h~h7j  ubhu)r  }r  (hX0   wx.lib.agw.aui.aui_utilities.AUI_TBTOOL_TEXT_TOPr  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   2r  h|X   intr  h3h~h7j  ubhu)r  }r  (hX6   wx.lib.agw.aui.aui_utilities.AUI_TBTOOL_VERT_CLOCKWISEr  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   1r  h|X   intr  h3h~h7j  ubhu)r  }r  (hX=   wx.lib.agw.aui.aui_utilities.AUI_TBTOOL_VERT_COUNTERCLOCKWISEr  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   2r  h|X   intr  h3h~h7j  ubhu)r  }r  (hX-   wx.lib.agw.aui.aui_utilities.AuiBaseTabCtrlIdr  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   5380r  h|X   intr  h3h~h7j  ubhu)r  }r  (hX/   wx.lib.agw.aui.aui_utilities.auiInsertRowPixelsr  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   10r  h|X   intr  h3h~h7j  ubhu)r  }r  (hX1   wx.lib.agw.aui.aui_utilities.auiLayerInsertOffsetr  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   5r  h|X   intr  h3h~h7j  ubhu)r  }r  (hX1   wx.lib.agw.aui.aui_utilities.auiLayerInsertPixelsr  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   40r  h|X   intr  h3h~h7j  ubhu)r  }r  (hX,   wx.lib.agw.aui.aui_utilities.auiNewRowPixelsr  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   40r  h|X   intr  h3h~h7j  ubhu)r  }r  (hX0   wx.lib.agw.aui.aui_utilities.auinotebook_previewr  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.r  hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f7afe726e50>r  h|X$   wx.lib.embeddedimage.PyEmbeddedImager  h3h~h7j  ubhu)r  }r  (hX,   wx.lib.agw.aui.aui_utilities.auiToolBarLayerr  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   10r  h|X   intr  h3h~h7j  ubhu)r  }r  (hX2   wx.lib.agw.aui.aui_utilities.BUTTON_DROPDOWN_WIDTHr  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   10r  h|X   intr  h3h~h7j  ubhu)r  }r  (hX'   wx.lib.agw.aui.aui_utilities.close_bitsr  hKh'KhX  bytes(iterable_of_ints) -> bytes
bytes(string, encoding[, errors]) -> bytes
bytes(bytes_or_buffer) -> immutable copy of bytes_or_buffer
bytes(int) -> bytes object of size given by the parameter initialized with null bytes
bytes() -> empty bytes object

Construct an immutable array of bytes from:
  - an iterable yielding integers in range(256)
  - a text string encoded using the specified encoding
  - any object implementing the buffer API.
  - an integerr  hhh	hzX   b'\xff\xff\xff\xff\x07\xf0\xfb\xef\xdb\xed\x8b\xe8\x1b\xec;\xee\x1b\xec\x8b\xe8\xdb\xed\xfb\xef\x07\xf0\xff\xff\xff\xff\xff\xff'r  h|X   bytesr  h3h~h7j  ubhu)r   }r  (hX1   wx.lib.agw.aui.aui_utilities.colourHintBackgroundr  hKh'KhX   Colour()
Colour(red, green, blue, alpha=ALPHA_OPAQUE)
Colour(colRGB)
Colour(colour)

A colour is an object representing a combination of Red, Green, and
Blue (RGB) intensity values and an Alpha value, and is used to
determine drawing colours.r  hhh	hzX   wx.Colour(0, 64, 255, 255)r  h|X   wx._core.Colourr  h3h~h7j  ubhu)r  }r  (hX-   wx.lib.agw.aui.aui_utilities.colourHintBorderr  hKh'KhX   Colour()
Colour(red, green, blue, alpha=ALPHA_OPAQUE)
Colour(colRGB)
Colour(colour)

A colour is an object representing a combination of Red, Green, and
Blue (RGB) intensity values and an Alpha value, and is used to
determine drawing colours.r	  hhh	hzX   wx.Colour(60, 60, 60, 255)r
  h|X   wx._core.Colourr  h3h~h7j  ubhu)r  }r
  (hX,   wx.lib.agw.aui.aui_utilities.colourIconArrowr  hKh'KhX   Colour()
Colour(red, green, blue, alpha=ALPHA_OPAQUE)
Colour(colRGB)
Colour(colour)

A colour is an object representing a combination of Red, Green, and
Blue (RGB) intensity values and an Alpha value, and is used to
determine drawing colours.r  hhh	hzX   wx.Colour(77, 79, 170, 255)r  h|X   wx._core.Colourr  h3h~h7j  ubhu)r  }r  (hX1   wx.lib.agw.aui.aui_utilities.colourIconBackgroundr  hKh'KhX   Colour()
Colour(red, green, blue, alpha=ALPHA_OPAQUE)
Colour(colRGB)
Colour(colour)

A colour is an object representing a combination of Red, Green, and
Blue (RGB) intensity values and an Alpha value, and is used to
determine drawing colours.r  hhh	hzX   wx.Colour(-1, -1, -1, 255)r  h|X   wx._core.Colourr  h3h~h7j  ubhu)r  }r  (hX-   wx.lib.agw.aui.aui_utilities.colourIconBorderr  hKh'KhX   Colour()
Colour(red, green, blue, alpha=ALPHA_OPAQUE)
Colour(colRGB)
Colour(colour)

A colour is an object representing a combination of Red, Green, and
Blue (RGB) intensity values and an Alpha value, and is used to
determine drawing colours.r  hhh	hzX   wx.Colour(82, 65, 156, 255)r  h|X   wx._core.Colourr  h3h~h7j  ubhu)r  }r  (hX3   wx.lib.agw.aui.aui_utilities.colourIconDockingPart1r   hKh'KhX   Colour()
Colour(red, green, blue, alpha=ALPHA_OPAQUE)
Colour(colRGB)
Colour(colour)

A colour is an object representing a combination of Red, Green, and
Blue (RGB) intensity values and an Alpha value, and is used to
determine drawing colours.r!  hhh	hzX   wx.Colour(215, 228, 243, 255)r"  h|X   wx._core.Colourr#  h3h~h7j  ubhu)r$  }r%  (hX3   wx.lib.agw.aui.aui_utilities.colourIconDockingPart2r&  hKh'KhX   Colour()
Colour(red, green, blue, alpha=ALPHA_OPAQUE)
Colour(colRGB)
Colour(colour)

A colour is an object representing a combination of Red, Green, and
Blue (RGB) intensity values and an Alpha value, and is used to
determine drawing colours.r'  hhh	hzX   wx.Colour(180, 201, 225, 255)r(  h|X   wx._core.Colourr)  h3h~h7j  ubhu)r*  }r+  (hX-   wx.lib.agw.aui.aui_utilities.colourIconShadowr,  hKh'KhX   Colour()
Colour(red, green, blue, alpha=ALPHA_OPAQUE)
Colour(colRGB)
Colour(colour)

A colour is an object representing a combination of Red, Green, and
Blue (RGB) intensity values and an Alpha value, and is used to
determine drawing colours.r-  hhh	hzX   wx.Colour(198, 198, 198, 255)r.  h|X   wx._core.Colourr/  h3h~h7j  ubhu)r0  }r1  (hX3   wx.lib.agw.aui.aui_utilities.colourTargetBackgroundr2  hKh'KhX   Colour()
Colour(red, green, blue, alpha=ALPHA_OPAQUE)
Colour(colRGB)
Colour(colour)

A colour is an object representing a combination of Red, Green, and
Blue (RGB) intensity values and an Alpha value, and is used to
determine drawing colours.r3  hhh	hzX   wx.Colour(224, 224, 224, 255)r4  h|X   wx._core.Colourr5  h3h~h7j  ubhu)r6  }r7  (hX/   wx.lib.agw.aui.aui_utilities.colourTargetBorderr8  hKh'KhX   Colour()
Colour(red, green, blue, alpha=ALPHA_OPAQUE)
Colour(colRGB)
Colour(colour)

A colour is an object representing a combination of Red, Green, and
Blue (RGB) intensity values and an Alpha value, and is used to
determine drawing colours.r9  hhh	hzX   wx.Colour(180, 180, 180, 255)r:  h|X   wx._core.Colourr;  h3h~h7j  ubhu)r<  }r=  (hX.   wx.lib.agw.aui.aui_utilities.colourTargetShader>  hKh'KhX   Colour()
Colour(red, green, blue, alpha=ALPHA_OPAQUE)
Colour(colRGB)
Colour(colour)

A colour is an object representing a combination of Red, Green, and
Blue (RGB) intensity values and an Alpha value, and is used to
determine drawing colours.r?  hhh	hzX   wx.Colour(206, 206, 206, 255)r@  h|X   wx._core.ColourrA  h3h~h7j  ubhu)rB  }rC  (hX1   wx.lib.agw.aui.aui_utilities.DISABLED_TEXT_COLOURrD  hKh'KhX   Colour()
Colour(red, green, blue, alpha=ALPHA_OPAQUE)
Colour(colRGB)
Colour(colour)

A colour is an object representing a combination of Red, Green, and
Blue (RGB) intensity values and an Alpha value, and is used to
determine drawing colours.rE  hhh	hzX   wx.Colour(153, 153, 153, 255)rF  h|X   wx._core.ColourrG  h3h~h7j  ubhu)rH  }rI  (hX3   wx.lib.agw.aui.aui_utilities.DISABLED_TEXT_GREY_HUErJ  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4rK  hhh	hzX   153rL  h|X   intrM  h3h~h7j  ubhu)rN  }rO  (hX!   wx.lib.agw.aui.aui_utilities.downrP  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.rQ  hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f7afe726590>rR  h|X$   wx.lib.embeddedimage.PyEmbeddedImagerS  h3h~h7j  ubhu)rT  }rU  (hX'   wx.lib.agw.aui.aui_utilities.down_focusrV  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.rW  hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f7afe7265d0>rX  h|X$   wx.lib.embeddedimage.PyEmbeddedImagerY  h3h~h7j  ubhu)rZ  }r[  (hX.   wx.lib.agw.aui.aui_utilities.down_focus_singler\  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.r]  hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f7afe726250>r^  h|X$   wx.lib.embeddedimage.PyEmbeddedImager_  h3h~h7j  ubhu)r`  }ra  (hX(   wx.lib.agw.aui.aui_utilities.down_singlerb  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.rc  hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f7afe726290>rd  h|X$   wx.lib.embeddedimage.PyEmbeddedImagere  h3h~h7j  ubhu)rf  }rg  (hX'   wx.lib.agw.aui.aui_utilities.guideSizeXrh  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4ri  hhh	hzX   29rj  h|X   intrk  h3h~h7j  ubhu)rl  }rm  (hX'   wx.lib.agw.aui.aui_utilities.guideSizeYrn  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4ro  hhh	hzX   32rp  h|X   intrq  h3h~h7j  ubhu)rr  }rs  (hX-   wx.lib.agw.aui.aui_utilities.ID_RESTORE_FRAMErt  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4ru  hhh	hzX   15999rv  h|X   intrw  h3h~h7j  ubhu)rx  }ry  (hX'   wx.lib.agw.aui.aui_utilities.ITEM_CHECKrz  hKh'Khhhhh	hzX   1r{  h|X   wx._core.ItemKindr|  h3h~h7j  ubhu)r}  }r~  (hX)   wx.lib.agw.aui.aui_utilities.ITEM_CONTROLr  hKh'Khhhhh	hzX   4r  h|X   wx._core.ItemKindr  h3h~h7j  ubhu)r  }r  (hX'   wx.lib.agw.aui.aui_utilities.ITEM_LABELr  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   5r  h|X   intr  h3h~h7j  ubhu)r  }r  (hX(   wx.lib.agw.aui.aui_utilities.ITEM_NORMALr  hKh'Khhhhh	hzX   0r  h|X   wx._core.ItemKindr  h3h~h7j  ubhu)r  }r  (hX'   wx.lib.agw.aui.aui_utilities.ITEM_RADIOr  hKh'Khhhhh	hzX   2r  h|X   wx._core.ItemKindr  h3h~h7j  ubhu)r  }r  (hX+   wx.lib.agw.aui.aui_utilities.ITEM_SEPARATORr  hKh'Khhhhh	hzX   -1r  h|X   wx._core.ItemKindr  h3h~h7j  ubhu)r  }r  (hX(   wx.lib.agw.aui.aui_utilities.ITEM_SPACERr  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   6r  h|X   intr  h3h~h7j  ubhu)r  }r  (hX!   wx.lib.agw.aui.aui_utilities.leftr  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.r  hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f7afe726610>r  h|X$   wx.lib.embeddedimage.PyEmbeddedImager  h3h~h7j  ubhu)r  }r  (hX'   wx.lib.agw.aui.aui_utilities.left_focusr  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.r  hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f7afe726650>r  h|X$   wx.lib.embeddedimage.PyEmbeddedImager  h3h~h7j  ubhu)r  }r  (hX.   wx.lib.agw.aui.aui_utilities.left_focus_singler  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.r  hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f7afe7262d0>r  h|X$   wx.lib.embeddedimage.PyEmbeddedImager  h3h~h7j  ubhu)r  }r  (hX(   wx.lib.agw.aui.aui_utilities.left_singler  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.r  hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f7afe726310>r  h|X$   wx.lib.embeddedimage.PyEmbeddedImager  h3h~h7j  ubhu)r  }r  (hX%   wx.lib.agw.aui.aui_utilities.max_bitsr  hKh'KhX  bytes(iterable_of_ints) -> bytes
bytes(string, encoding[, errors]) -> bytes
bytes(bytes_or_buffer) -> immutable copy of bytes_or_buffer
bytes(int) -> bytes object of size given by the parameter initialized with null bytes
bytes() -> empty bytes object

Construct an immutable array of bytes from:
  - an iterable yielding integers in range(256)
  - a text string encoded using the specified encoding
  - any object implementing the buffer API.
  - an integerr  hhh	hzX   b'\xff\xff\xff\xff\xff\xff\x07\xf0\xf7\xf7\x07\xf0\xf7\xf7\xf7\xf7\xf7\xf7\xf7\xf7\xf7\xf7\x07\xf0\xff\xff\xff\xff\xff\xff\xff\xff'r  h|X   bytesr  h3h~h7j  ubhu)r  }r  (hX*   wx.lib.agw.aui.aui_utilities.minimize_bitsr  hKh'KhX  bytes(iterable_of_ints) -> bytes
bytes(string, encoding[, errors]) -> bytes
bytes(bytes_or_buffer) -> immutable copy of bytes_or_buffer
bytes(int) -> bytes object of size given by the parameter initialized with null bytes
bytes() -> empty bytes object

Construct an immutable array of bytes from:
  - an iterable yielding integers in range(256)
  - a text string encoded using the specified encoding
  - any object implementing the buffer API.
  - an integerr  hhh	hzX   b'\xff\xff\xff\xff\xff\xff\x07\xf0\xf7\xf7\x07\xf0\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff'r  h|X   bytesr  h3h~h7j  ubhu)r  }r  (hX%   wx.lib.agw.aui.aui_utilities.Mondrianr  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.r  hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f7afe726210>r  h|X$   wx.lib.embeddedimage.PyEmbeddedImager  h3h~h7j  ubhu)r  }r  (hX*   wx.lib.agw.aui.aui_utilities.nb_close_bitsr  hKh'KhX  bytes(iterable_of_ints) -> bytes
bytes(string, encoding[, errors]) -> bytes
bytes(bytes_or_buffer) -> immutable copy of bytes_or_buffer
bytes(int) -> bytes object of size given by the parameter initialized with null bytes
bytes() -> empty bytes object

Construct an immutable array of bytes from:
  - an iterable yielding integers in range(256)
  - a text string encoded using the specified encoding
  - any object implementing the buffer API.
  - an integerr  hhh	hzX   b'\xff\xff\xff\xff\x07\xf0\xfb\xef\xdb\xed\x8b\xe8\x1b\xec;\xee\x1b\xec\x8b\xe8\xdb\xed\xfb\xef\x07\xf0\xff\xff\xff\xff\xff\xff'r  h|X   bytesr  h3h~h7j  ubhu)r  }r  (hX)   wx.lib.agw.aui.aui_utilities.nb_left_bitsr  hKh'KhX  bytes(iterable_of_ints) -> bytes
bytes(string, encoding[, errors]) -> bytes
bytes(bytes_or_buffer) -> immutable copy of bytes_or_buffer
bytes(int) -> bytes object of size given by the parameter initialized with null bytes
bytes() -> empty bytes object

Construct an immutable array of bytes from:
  - an iterable yielding integers in range(256)
  - a text string encoded using the specified encoding
  - any object implementing the buffer API.
  - an integerr  hhh	hzX}   b'\xff\xff\xff\xff\xff\xff\xff\xfe\x7f\xfe?\xfe\x1f\xfe\x0f\xfe\x1f\xfe?\xfe\x7f\xfe\xff\xfe\xff\xff\xff\xff\xff\xff\xff\xff'r  h|X   bytesr  h3h~h7j  ubhu)r  }r  (hX)   wx.lib.agw.aui.aui_utilities.nb_list_bitsr  hKh'KhX  bytes(iterable_of_ints) -> bytes
bytes(string, encoding[, errors]) -> bytes
bytes(bytes_or_buffer) -> immutable copy of bytes_or_buffer
bytes(int) -> bytes object of size given by the parameter initialized with null bytes
bytes() -> empty bytes object

Construct an immutable array of bytes from:
  - an iterable yielding integers in range(256)
  - a text string encoded using the specified encoding
  - any object implementing the buffer API.
  - an integerr  hhh	hzX   b'\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x0f\xf8\xff\xff\x0f\xf8\x1f\xfc?\xfe\x7f\xff\xff\xff\xff\xff\xff\xff\xff\xff'r  h|X   bytesr  h3h~h7j  ubhu)r  }r  (hX*   wx.lib.agw.aui.aui_utilities.nb_right_bitsr  hKh'KhX  bytes(iterable_of_ints) -> bytes
bytes(string, encoding[, errors]) -> bytes
bytes(bytes_or_buffer) -> immutable copy of bytes_or_buffer
bytes(int) -> bytes object of size given by the parameter initialized with null bytes
bytes() -> empty bytes object

Construct an immutable array of bytes from:
  - an iterable yielding integers in range(256)
  - a text string encoded using the specified encoding
  - any object implementing the buffer API.
  - an integerr  hhh	hzX   b'\xff\xff\xff\xff\xff\xff\xdf\xff\x9f\xff\x1f\xff\x1f\xfe\x1f\xfc\x1f\xfe\x1f\xff\x9f\xff\xdf\xff\xff\xff\xff\xff\xff\xff\xff\xff'r  h|X   bytesr  h3h~h7j  ubhu)r  }r  (hX%   wx.lib.agw.aui.aui_utilities.pin_bitsr  hKh'KhX  bytes(iterable_of_ints) -> bytes
bytes(string, encoding[, errors]) -> bytes
bytes(bytes_or_buffer) -> immutable copy of bytes_or_buffer
bytes(int) -> bytes object of size given by the parameter initialized with null bytes
bytes() -> empty bytes object

Construct an immutable array of bytes from:
  - an iterable yielding integers in range(256)
  - a text string encoded using the specified encoding
  - any object implementing the buffer API.
  - an integerr  hhh	hzX   b'\xff\xff\xff\xff\xff\xff\x1f\xfc\xdf\xfc\xdf\xfc\xdf\xfc\xdf\xfc\xdf\xfc\x0f\xf8\x7f\xff\x7f\xff\x7f\xff\xff\xff\xff\xff\xff\xff'r  h|X   bytesr  h3h~h7j  ubhu)r  }r  (hX)   wx.lib.agw.aui.aui_utilities.restore_bitsr  hKh'KhX  bytes(iterable_of_ints) -> bytes
bytes(string, encoding[, errors]) -> bytes
bytes(bytes_or_buffer) -> immutable copy of bytes_or_buffer
bytes(int) -> bytes object of size given by the parameter initialized with null bytes
bytes() -> empty bytes object

Construct an immutable array of bytes from:
  - an iterable yielding integers in range(256)
  - a text string encoded using the specified encoding
  - any object implementing the buffer API.
  - an integerr  hhh	hzX   b'\xff\xff\xff\xff\xff\xff\x1f\xf0\x1f\xf0\xdf\xf7\x07\xf4\x07\xf4\xf7\xf5\xf7\xf1\xf7\xfd\xf7\xfd\x07\xfc\xff\xff\xff\xff\xff\xff'r  h|X   bytesr  h3h~h7j  ubhu)r  }r  (hX(   wx.lib.agw.aui.aui_utilities.restore_xpmr  hKh'KhX   Built-in mutable sequence.

If no argument is given, the constructor creates a new empty list.
The argument must be an iterable if specified.r  hhh	hzX  [b'16 15 3 1', b'       c None', b'.      c #000000', b'+      c #FFFFFF', b'                ', b'     .......... ', b'     .++++++++. ', b'     .......... ', b'     .++++++++. ', b' ..........+++. ', b' .++++++++.+++. ', b' ..........+++. ', b' .++++++++..... ', b' .++++++++.     ', b' .++++++++.     ', b' .++++++++.     ', b' .++++++++.     ', b' ..........     ', b'                ']r  h|X   listr  h3h~h7j  ubhu)r  }r  (hX"   wx.lib.agw.aui.aui_utilities.rightr  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.r  hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f7afe726710>r  h|X$   wx.lib.embeddedimage.PyEmbeddedImager  h3h~h7j  ubhu)r  }r  (hX(   wx.lib.agw.aui.aui_utilities.right_focusr  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.r  hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f7afe726750>r  h|X$   wx.lib.embeddedimage.PyEmbeddedImager  h3h~h7j  ubhu)r  }r  (hX/   wx.lib.agw.aui.aui_utilities.right_focus_singler  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.r   hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f7afe726350>r  h|X$   wx.lib.embeddedimage.PyEmbeddedImager  h3h~h7j  ubhu)r  }r  (hX)   wx.lib.agw.aui.aui_utilities.right_singler  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.r  hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f7afe726390>r  h|X$   wx.lib.embeddedimage.PyEmbeddedImager  h3h~h7j  ubhu)r	  }r
  (hX3   wx.lib.agw.aui.aui_utilities.SWITCHER_TEXT_MARGIN_Xr  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   4r
  h|X   intr  h3h~h7j  ubhu)r  }r  (hX3   wx.lib.agw.aui.aui_utilities.SWITCHER_TEXT_MARGIN_Yr  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   1r  h|X   intr  h3h~h7j  ubhu)r  }r  (hX    wx.lib.agw.aui.aui_utilities.tabr  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.r  hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f7afe7267d0>r  h|X$   wx.lib.embeddedimage.PyEmbeddedImager  h3h~h7j  ubhu)r  }r  (hX.   wx.lib.agw.aui.aui_utilities.tab_active_centerr  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.r  hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f7afe73f4d0>r  h|X$   wx.lib.embeddedimage.PyEmbeddedImager   h3h~h7j  ubhu)r!  }r"  (hX,   wx.lib.agw.aui.aui_utilities.tab_active_leftr#  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.r$  hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f7afe73f550>r%  h|X$   wx.lib.embeddedimage.PyEmbeddedImager&  h3h~h7j  ubhu)r'  }r(  (hX-   wx.lib.agw.aui.aui_utilities.tab_active_rightr)  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.r*  hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f7afe73f810>r+  h|X$   wx.lib.embeddedimage.PyEmbeddedImager,  h3h~h7j  ubhu)r-  }r.  (hX&   wx.lib.agw.aui.aui_utilities.tab_closer/  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.r0  hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f7afe73f9d0>r1  h|X$   wx.lib.embeddedimage.PyEmbeddedImager2  h3h~h7j  ubhu)r3  }r4  (hX(   wx.lib.agw.aui.aui_utilities.tab_close_hr5  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.r6  hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f7afe7260d0>r7  h|X$   wx.lib.embeddedimage.PyEmbeddedImager8  h3h~h7j  ubhu)r9  }r:  (hX(   wx.lib.agw.aui.aui_utilities.tab_close_pr;  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.r<  hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f7afe726110>r=  h|X$   wx.lib.embeddedimage.PyEmbeddedImager>  h3h~h7j  ubhu)r?  }r@  (hX&   wx.lib.agw.aui.aui_utilities.tab_focusrA  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.rB  hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f7afe726810>rC  h|X$   wx.lib.embeddedimage.PyEmbeddedImagerD  h3h~h7j  ubhu)rE  }rF  (hX-   wx.lib.agw.aui.aui_utilities.tab_focus_singlerG  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.rH  hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f7afe726490>rI  h|X$   wx.lib.embeddedimage.PyEmbeddedImagerJ  h3h~h7j  ubhu)rK  }rL  (hX0   wx.lib.agw.aui.aui_utilities.tab_inactive_centerrM  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.rN  hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f7afe726150>rO  h|X$   wx.lib.embeddedimage.PyEmbeddedImagerP  h3h~h7j  ubhu)rQ  }rR  (hX.   wx.lib.agw.aui.aui_utilities.tab_inactive_leftrS  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.rT  hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f7afe726190>rU  h|X$   wx.lib.embeddedimage.PyEmbeddedImagerV  h3h~h7j  ubhu)rW  }rX  (hX/   wx.lib.agw.aui.aui_utilities.tab_inactive_rightrY  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.rZ  hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f7afe7261d0>r[  h|X$   wx.lib.embeddedimage.PyEmbeddedImager\  h3h~h7j  ubhu)r]  }r^  (hX'   wx.lib.agw.aui.aui_utilities.tab_singler_  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.r`  hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f7afe7264d0>ra  h|X$   wx.lib.embeddedimage.PyEmbeddedImagerb  h3h~h7j  ubhu)rc  }rd  (hX   wx.lib.agw.aui.aui_utilities.upre  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.rf  hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f7afe726850>rg  h|X$   wx.lib.embeddedimage.PyEmbeddedImagerh  h3h~h7j  ubhu)ri  }rj  (hX%   wx.lib.agw.aui.aui_utilities.up_focusrk  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.rl  hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f7afe726890>rm  h|X$   wx.lib.embeddedimage.PyEmbeddedImagern  h3h~h7j  ubhu)ro  }rp  (hX,   wx.lib.agw.aui.aui_utilities.up_focus_singlerq  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.rr  hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f7afe726510>rs  h|X$   wx.lib.embeddedimage.PyEmbeddedImagert  h3h~h7j  ubhu)ru  }rv  (hX&   wx.lib.agw.aui.aui_utilities.up_singlerw  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.rx  hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f7afe726550>ry  h|X$   wx.lib.embeddedimage.PyEmbeddedImagerz  h3h~h7j  ubhu)r{  }r|  (hX4   wx.lib.agw.aui.aui_utilities.vertical_border_paddingr}  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r~  hhh	hzX   4r  h|X   intr  h3h~h7j  ubhu)r  }r  (hX+   wx.lib.agw.aui.aui_utilities.whidbey_deniedr  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.r  hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f7afe726e10>r  h|X$   wx.lib.embeddedimage.PyEmbeddedImager  h3h~h7j  ubhu)r  }r  (hX.   wx.lib.agw.aui.aui_utilities.whidbey_dock_paner  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.r  hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f7afe726f10>r  h|X$   wx.lib.embeddedimage.PyEmbeddedImager  h3h~h7j  ubhu)r  }r  (hX5   wx.lib.agw.aui.aui_utilities.whidbey_dock_pane_bottomr  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.r  hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f7afe726f50>r  h|X$   wx.lib.embeddedimage.PyEmbeddedImager  h3h~h7j  ubhu)r  }r  (hX5   wx.lib.agw.aui.aui_utilities.whidbey_dock_pane_centerr  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.r  hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f7afe726f90>r  h|X$   wx.lib.embeddedimage.PyEmbeddedImager  h3h~h7j  ubhu)r  }r  (hX3   wx.lib.agw.aui.aui_utilities.whidbey_dock_pane_leftr  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.r  hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f7afe726fd0>r  h|X$   wx.lib.embeddedimage.PyEmbeddedImager  h3h~h7j  ubhu)r  }r  (hX4   wx.lib.agw.aui.aui_utilities.whidbey_dock_pane_rightr  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.r  hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f7aef7a5790>r  h|X$   wx.lib.embeddedimage.PyEmbeddedImager  h3h~h7j  ubhu)r  }r  (hX2   wx.lib.agw.aui.aui_utilities.whidbey_dock_pane_topr  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.r  hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f7aef7a5990>r  h|X$   wx.lib.embeddedimage.PyEmbeddedImager  h3h~h7j  ubhu)r  }r  (hX)   wx.lib.agw.aui.aui_utilities.whidbey_downr  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.r  hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f7afe726e90>r  h|X$   wx.lib.embeddedimage.PyEmbeddedImager  h3h~h7j  ubhu)r  }r  (hX/   wx.lib.agw.aui.aui_utilities.whidbey_down_focusr  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.r  hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f7afe726ed0>r  h|X$   wx.lib.embeddedimage.PyEmbeddedImager  h3h~h7j  ubhu)r  }r  (hX6   wx.lib.agw.aui.aui_utilities.whidbey_down_focus_singler  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.r  hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f7afe726ed0>r  h|X$   wx.lib.embeddedimage.PyEmbeddedImager  h3h~h7j  ubhu)r  }r  (hX0   wx.lib.agw.aui.aui_utilities.whidbey_down_singler  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.r  hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f7afe726e90>r  h|X$   wx.lib.embeddedimage.PyEmbeddedImager  h3h~h7j  ubhu)r  }r  (hX)   wx.lib.agw.aui.aui_utilities.whidbey_leftr  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.r  hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f7aef7a5090>r  h|X$   wx.lib.embeddedimage.PyEmbeddedImager  h3h~h7j  ubhu)r  }r  (hX/   wx.lib.agw.aui.aui_utilities.whidbey_left_focusr  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.r  hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f7aef7a50d0>r  h|X$   wx.lib.embeddedimage.PyEmbeddedImager  h3h~h7j  ubhu)r  }r  (hX6   wx.lib.agw.aui.aui_utilities.whidbey_left_focus_singler  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.r  hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f7aef7a50d0>r  h|X$   wx.lib.embeddedimage.PyEmbeddedImager  h3h~h7j  ubhu)r  }r  (hX0   wx.lib.agw.aui.aui_utilities.whidbey_left_singler  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.r  hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f7aef7a5090>r  h|X$   wx.lib.embeddedimage.PyEmbeddedImager  h3h~h7j  ubhu)r  }r  (hX*   wx.lib.agw.aui.aui_utilities.whidbey_rightr  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.r  hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f7aef7a5050>r  h|X$   wx.lib.embeddedimage.PyEmbeddedImager  h3h~h7j  ubhu)r  }r  (hX0   wx.lib.agw.aui.aui_utilities.whidbey_right_focusr  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.r  hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f7aef7a5110>r  h|X$   wx.lib.embeddedimage.PyEmbeddedImager  h3h~h7j  ubhu)r  }r  (hX7   wx.lib.agw.aui.aui_utilities.whidbey_right_focus_singler  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.r  hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f7aef7a5110>r  h|X$   wx.lib.embeddedimage.PyEmbeddedImager  h3h~h7j  ubhu)r  }r  (hX1   wx.lib.agw.aui.aui_utilities.whidbey_right_singler  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.r  hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f7aef7a5050>r  h|X$   wx.lib.embeddedimage.PyEmbeddedImager  h3h~h7j  ubhu)r  }r  (hX'   wx.lib.agw.aui.aui_utilities.whidbey_upr  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.r  hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f7aef7a5150>r  h|X$   wx.lib.embeddedimage.PyEmbeddedImager  h3h~h7j  ubhu)r  }r  (hX-   wx.lib.agw.aui.aui_utilities.whidbey_up_focusr  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.r  hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f7aef7a5190>r  h|X$   wx.lib.embeddedimage.PyEmbeddedImager  h3h~h7j  ubhu)r  }r   (hX4   wx.lib.agw.aui.aui_utilities.whidbey_up_focus_singler  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.r  hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f7aef7a5190>r  h|X$   wx.lib.embeddedimage.PyEmbeddedImager  h3h~h7j  ubhu)r  }r  (hX.   wx.lib.agw.aui.aui_utilities.whidbey_up_singler  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.r  hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f7aef7a5150>r	  h|X$   wx.lib.embeddedimage.PyEmbeddedImager
  h3h~h7j  ubhu)r  }r  (hX)   wx.lib.agw.aui.aui_utilities.whidbeySizeXr
  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   43r  h|X   intr  h3h~h7j  ubhu)r  }r  (hX)   wx.lib.agw.aui.aui_utilities.whidbeySizeYr  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   30r  h|X   intr  h3h~h7j  ubhu)r  }r  (hX*   wx.lib.agw.aui.aui_utilities.wxWINDOWCLOSEr  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   4001r  h|X   intr  h3h~h7j  ubhu)r  }r  (hX-   wx.lib.agw.aui.aui_utilities.wxWINDOWCLOSEALLr  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r   hhh	hzX   4002r!  h|X   intr"  h3h~h7j  ubhu)r#  }r$  (hX)   wx.lib.agw.aui.aui_utilities.wxWINDOWNEXTr%  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r&  hhh	hzX   4003r'  h|X   intr(  h3h~h7j  ubhu)r)  }r*  (hX)   wx.lib.agw.aui.aui_utilities.wxWINDOWPREVr+  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r,  hhh	hzX   4004r-  h|X   intr.  h3h~h7j  ubej  XB   /home/wxpy/bb2/dist-src-py37/build/wx/lib/agw/aui/aui_utilities.pyr/  hrXO   /home/wxpy/bb2/dist-src-py37/build/docs/sphinx/wx.lib.agw.aui.aui_utilities.txtr0  h'Kh3j  hpj  )r1  }r2  (j  ]r3  (X)   wx.lib.agw.aui.aui_utilities.TabDragImager4  ]r5  X   wx.DragImager6  ar7  X   wx.DragImager8  ]r9  X	   wx.Objectr:  ar;  X	   wx.Objectr<  ]r=  r>  ej  ]r?  X)   wx.lib.agw.aui.aui_utilities.TabDragImager@  aj  j  ubh7hubh)rA  }rB  (hX   wx.lib.agw.aui.auibarrC  hKhX  `auibar.py` contains an implementation of
:class:`~wx.lib.agw.aui.auibar.AuiToolBar`, which is a completely owner-drawn
toolbar perfectly integrated with the AUI layout system. This allows drag and
drop of toolbars, docking/floating behaviour and the possibility to define
"overflow" items in the toolbar itself.

The default theme that is used is :class:`AuiToolBar`, which provides a modern,
glossy look and feel. The theme can be changed by calling
:meth:`AuiToolBar.SetArtProvider`.rD  hX  # -*- coding: utf-8 -*-
#----------------------------------------------------------------------------
# Name:         auibar.py
# Purpose:
#
# Author:       Andrea Gavana <andrea.gavana@gmail.com>
#
# Created:
# Version:
# Date:         31 March 2009
# Licence:      wxWindows license
# Tags:         phoenix-port, unittest, documented, py3-port
#----------------------------------------------------------------------------
rE  h	h
]rF  (h)rG  }rH  (hX*   wx.lib.agw.aui.auibar.AuiDefaultToolBarArtrI  hKhX  Toolbar art provider code - a tab provider provides all drawing functionality to the :class:`AuiToolBar`.
This allows the :class:`AuiToolBar` to have a pluggable look-and-feel.

By default, a :class:`AuiToolBar` uses an instance of this class called :class:`AuiDefaultToolBarArt`
which provides bitmap art and a colour scheme that is adapted to the major platforms'
look. You can either derive from that class to alter its behaviour or write a
completely new tab art class. Call :meth:`AuiToolBar.SetArtProvider` to make use this new tab art.rJ  hhh	h
]rK  (h#)rL  }rM  (hX3   wx.lib.agw.aui.auibar.AuiDefaultToolBarArt.__init__rN  hKh'KhX   Default class constructor. rO  hhh	h)]rP  h1X   __init__(self)rQ  h3h4h5X   25rR  h7jG  ubh#)rS  }rT  (hX0   wx.lib.agw.aui.auibar.AuiDefaultToolBarArt.ClonerU  hKh'KhX.   Clones the :class:`AuiDefaultToolBarArt` art. rV  hhh	h)]rW  h1X   Clone(self)rX  h3h4h5hIh7jG  ubh#)rY  }rZ  (hX9   wx.lib.agw.aui.auibar.AuiDefaultToolBarArt.DrawBackgroundr[  hKh'KhX2  Draws a toolbar background with a gradient shading.

:param `dc`: a :class:`wx.DC` device context;
:param `wnd`: a :class:`wx.Window` derived window;
:param wx.Rect `_rect`: the :class:`AuiToolBarItem` rectangle;
:param bool `horizontal`: ``True`` if the toolbar is horizontal, ``False`` if it is vertical.r\  hhh	h)]r]  (X   dcr^  hhr_  X   wndr`  hhra  X   _rectrb  hhrc  X
   horizontalrd  X   Truere  h/rf  eh1X5   DrawBackground(self, dc, wnd, _rect, horizontal=True)rg  h3h4h5X   30rh  h7jG  ubh#)ri  }rj  (hX5   wx.lib.agw.aui.auibar.AuiDefaultToolBarArt.DrawButtonrk  hKh'KhX   Draws a toolbar item button.

:param `dc`: a :class:`wx.DC` device context;
:param `wnd`: a :class:`wx.Window` derived window;
:param `item`: an instance of :class:`AuiToolBarItem`;
:param wx.Rect `rect`: the :class:`AuiToolBarItem` rectangle.rl  hhh	h)]rm  (X   dcrn  hhro  X   wndrp  hhrq  X   itemrr  hhrs  X   rectrt  hhru  eh1X%   DrawButton(self, dc, wnd, item, rect)rv  h3h4h5X   61rw  h7jG  ubh#)rx  }ry  (hX;   wx.lib.agw.aui.auibar.AuiDefaultToolBarArt.DrawControlLabelrz  hKh'KhX   Draws a label for a toolbar control.

:param `dc`: a :class:`wx.DC` device context;
:param `wnd`: a :class:`wx.Window` derived window;
:param `item`: an instance of :class:`AuiToolBarItem`;
:param wx.Rect `rect`: the :class:`AuiToolBarItem` rectangle.r{  hhh	h)]r|  (X   dcr}  hhr~  X   wndr  hhr  X   itemr  hhr  X   rectr  hhr  eh1X+   DrawControlLabel(self, dc, wnd, item, rect)r  h3h4h5X   35r  h7jG  ubh#)r  }r  (hX=   wx.lib.agw.aui.auibar.AuiDefaultToolBarArt.DrawDropDownButtonr  hKh'KhX   Draws a toolbar dropdown button.

:param `dc`: a :class:`wx.DC` device context;
:param `wnd`: a :class:`wx.Window` derived window;
:param `item`: an instance of :class:`AuiToolBarItem`;
:param wx.Rect `rect`: the :class:`AuiToolBarItem` rectangle.r  hhh	h)]r  (X   dcr  hhr  X   wndr  hhr  X   itemr  hhr  X   rectr  hhr  eh1X-   DrawDropDownButton(self, dc, wnd, item, rect)r  h3h4h5X   86r  h7jG  ubh#)r  }r  (hX6   wx.lib.agw.aui.auibar.AuiDefaultToolBarArt.DrawGripperr  hKh'KhX   Draws the toolbar gripper.

:param `dc`: a :class:`wx.DC` device context;
:param `wnd`: a :class:`wx.Window` derived window;
:param wx.Rect `rect`: the :class:`AuiToolBarItem` rectangle.r  hhh	h)]r  (X   dcr  hhr  X   wndr  hhr  X   rectr  hhr  eh1X    DrawGripper(self, dc, wnd, rect)r  h3h4h5X   44r  h7jG  ubh#)r  }r  (hX4   wx.lib.agw.aui.auibar.AuiDefaultToolBarArt.DrawLabelr  hKh'KhX   Draws a toolbar item label.

:param `dc`: a :class:`wx.DC` device context;
:param `wnd`: a :class:`wx.Window` derived window;
:param `item`: an instance of :class:`AuiToolBarItem`;
:param wx.Rect `rect`: the :class:`AuiToolBarItem` rectangle.r  hhh	h)]r  (X   dcr  hhr  X   wndr  hhr  X   itemr  hhr  X   rectr  hhr  eh1X$   DrawLabel(self, dc, wnd, item, rect)r  h3h4h5X   41r  h7jG  ubh#)r  }r  (hX=   wx.lib.agw.aui.auibar.AuiDefaultToolBarArt.DrawOverflowButtonr  hKh'KhX	  Draws the overflow button for the :class:`AuiToolBar`.

:param `dc`: a :class:`wx.DC` device context;
:param `wnd`: a :class:`wx.Window` derived window;
:param wx.Rect `rect`: the :class:`AuiToolBarItem` rectangle;
:param integer `state`: the overflow button state.r  hhh	h)]r  (X   dcr  hhr  X   wndr  hhr  X   rectr  hhr  X   stater  hhr  eh1X.   DrawOverflowButton(self, dc, wnd, rect, state)r  h3h4h5X   35r  h7jG  ubh#)r  }r  (hX>   wx.lib.agw.aui.auibar.AuiDefaultToolBarArt.DrawPlainBackgroundr  hKh'KhX  Draws a toolbar background with a plain colour.

This method contrasts with the default behaviour of the :class:`AuiToolBar` that
draws a background gradient and this break the window design when putting
it within a control that has margin between the borders and the toolbar
(example: put :class:`AuiToolBar` within a :class:`StaticBoxSizer` that has a plain background).

:param `dc`: a :class:`wx.DC` device context;
:param `wnd`: a :class:`wx.Window` derived window;
:param wx.Rect `_rect`: the :class:`AuiToolBarItem` rectangle.r  hhh	h)]r  (X   dcr  hhr  X   wndr  hhr  X   _rectr  hhr  eh1X)   DrawPlainBackground(self, dc, wnd, _rect)r  h3h4h5X   20r  h7jG  ubh#)r  }r  (hX8   wx.lib.agw.aui.auibar.AuiDefaultToolBarArt.DrawSeparatorr  hKh'KhX   Draws a toolbar separator.

:param `dc`: a :class:`wx.DC` device context;
:param `wnd`: a :class:`wx.Window` derived window;
:param wx.Rect `_rect`: the :class:`AuiToolBarItem` rectangle.r  hhh	h)]r  (X   dcr  hhr  X   wndr  hhr  X   _rectr  hhr  eh1X#   DrawSeparator(self, dc, wnd, _rect)r  h3h4h5X   35r  h7jG  ubh#)r  }r  (hX6   wx.lib.agw.aui.auibar.AuiDefaultToolBarArt.GetAGWFlagsr  hKh'KhXs   Returns the :class:`AuiDefaultToolBarArt` flags.

:see: :meth:`~AuiDefaultToolBarArt.SetAGWFlags` for more details.r  hhh	h)]r  h1X   GetAGWFlags(self)r  h3h4h5j  h7jG  ubh#)r  }r  (hX9   wx.lib.agw.aui.auibar.AuiDefaultToolBarArt.GetElementSizer  hKh'KhXm  Returns the size of a UI element in the :class:`AuiToolBar`.

:param integer `element_id`: can be one of the following:

 ==================================== ==================================
 Element Identifier                   Description
 ==================================== ==================================
 ``AUI_TBART_SEPARATOR_SIZE``         Separator size in :class:`AuiToolBar`
 ``AUI_TBART_GRIPPER_SIZE``           Gripper size in :class:`AuiToolBar`
 ``AUI_TBART_OVERFLOW_SIZE``          Overflow button size in :class:`AuiToolBar`
 ==================================== ==================================r  hhh	h)]r  X
   element_idr  hhr  ah1X    GetElementSize(self, element_id)r  h3h4h5X   24r  h7jG  ubh#)r  }r  (hX2   wx.lib.agw.aui.auibar.AuiDefaultToolBarArt.GetFontr  hKh'KhX0   Returns the :class:`AuiDefaultToolBarArt` font. r  hhh	h)]r  h1X
   GetFont(self)r  h3h4h5hIh7jG  ubh#)r  }r  (hX7   wx.lib.agw.aui.auibar.AuiDefaultToolBarArt.GetLabelSizer  hKh'KhX   Returns the label size for a toolbar item.

:param `dc`: a :class:`wx.DC` device context;
:param `wnd`: a :class:`wx.Window` derived window;
:param `item`: an instance of :class:`AuiToolBarItem`.r  hhh	h)]r  (X   dcr  hhr  X   wndr  hhr  X   itemr  hhr  eh1X!   GetLabelSize(self, dc, wnd, item)r  h3h4h5X   14r  h7jG  ubh#)r  }r  (hX9   wx.lib.agw.aui.auibar.AuiDefaultToolBarArt.GetOrientationr  hKh'KhX!   Returns the toolbar orientation. r   hhh	h)]r  h1X   GetOrientation(self)r  h3h4h5hIh7jG  ubh#)r  }r  (hX=   wx.lib.agw.aui.auibar.AuiDefaultToolBarArt.GetTextOrientationr  hKh'KhX   Returns the :class:`AuiDefaultToolBarArt` text orientation.

:see: :meth:`~AuiDefaultToolBarArt.SetTextOrientation` for more details.r  hhh	h)]r  h1X   GetTextOrientation(self)r  h3h4h5j  h7jG  ubh#)r	  }r
  (hX6   wx.lib.agw.aui.auibar.AuiDefaultToolBarArt.GetToolSizer  hKh'KhX   Returns the toolbar item size.

:param `dc`: a :class:`wx.DC` device context;
:param `wnd`: a :class:`wx.Window` derived window;
:param `item`: an instance of :class:`AuiToolBarItem`.r  hhh	h)]r
  (X   dcr  hhr  X   wndr  hhr  X   itemr  hhr  eh1X    GetToolSize(self, dc, wnd, item)r  h3h4h5X   53r  h7jG  ubh#)r  }r  (hX;   wx.lib.agw.aui.auibar.AuiDefaultToolBarArt.GetToolsPositionr  hKh'KhX   Returns the bitmap and text rectangles for a toolbar item.

:param `dc`: a :class:`wx.DC` device context;
:param `item`: an instance of :class:`AuiToolBarItem`;
:param wx.Rect `rect`: the tool rectangle.r  hhh	h)]r  (X   dcr  hhr  X   itemr  hhr  X   rectr  hhr   eh1X&   GetToolsPosition(self, dc, item, rect)r!  h3h4h5X   47r"  h7jG  ubh#)r#  }r$  (hX6   wx.lib.agw.aui.auibar.AuiDefaultToolBarArt.SetAGWFlagsr%  hKh'KhX  Sets the toolbar art flags.

:param integer `agwFlags`: a combination of the following values:

 ==================================== ==================================
 Flag name                            Description
 ==================================== ==================================
 ``AUI_TB_TEXT``                      Shows the text in the toolbar buttons; by default only icons are shown
 ``AUI_TB_NO_TOOLTIPS``               Don't show tooltips on :class:`AuiToolBar` items
 ``AUI_TB_NO_AUTORESIZE``             Do not auto-resize the :class:`AuiToolBar`
 ``AUI_TB_GRIPPER``                   Shows a gripper on the :class:`AuiToolBar`
 ``AUI_TB_OVERFLOW``                  The :class:`AuiToolBar` can contain overflow items
 ``AUI_TB_VERTICAL``                  The :class:`AuiToolBar` is vertical
 ``AUI_TB_HORZ_LAYOUT``               Shows the text and the icons alongside, not vertically stacked. This style
                                      must be used with ``AUI_TB_TEXT``
 ``AUI_TB_PLAIN_BACKGROUND``          Don't draw a gradient background on the toolbar
 ``AUI_TB_HORZ_TEXT``                 Combination of ``AUI_TB_HORZ_LAYOUT`` and ``AUI_TB_TEXT``
 ==================================== ==================================r&  hhh	h)]r'  X   agwFlagsr(  hhr)  ah1X   SetAGWFlags(self, agwFlags)r*  h3h4h5X   25r+  h7jG  ubh#)r,  }r-  (hX<   wx.lib.agw.aui.auibar.AuiDefaultToolBarArt.SetDefaultColoursr.  hKh'KhX   Sets the default colours, which are calculated from the given base colour.

:param `base_colour`: an instance of :class:`wx.Colour`. If defaulted to ``None``, a colour
 is generated accordingly to the platform and theme.r/  hhh	h)]r0  X   base_colourr1  X   Noner2  X   Noner3  r4  ah1X)   SetDefaultColours(self, base_colour=None)r5  h3h4h5X   20r6  h7jG  ubh#)r7  }r8  (hX9   wx.lib.agw.aui.auibar.AuiDefaultToolBarArt.SetElementSizer9  hKh'KhX  Sets the size of a UI element in the :class:`AuiToolBar`.

:param integer `element_id`: can be one of the following:

 ==================================== ==================================
 Element Identifier                   Description
 ==================================== ==================================
 ``AUI_TBART_SEPARATOR_SIZE``         Separator size in :class:`AuiToolBar`
 ``AUI_TBART_GRIPPER_SIZE``           Gripper size in :class:`AuiToolBar`
 ``AUI_TBART_OVERFLOW_SIZE``          Overflow button size in :class:`AuiToolBar`
 ==================================== ==================================

:param integer `size`: the new size of the UI element.r:  hhh	h)]r;  (X
   element_idr<  hhr=  X   sizer>  hhr?  eh1X&   SetElementSize(self, element_id, size)r@  h3h4h5X   24rA  h7jG  ubh#)rB  }rC  (hX2   wx.lib.agw.aui.auibar.AuiDefaultToolBarArt.SetFontrD  hKh'KhXv   Sets the :class:`AuiDefaultToolBarArt` font.

:param wx.Font `font`: the font used for displaying toolbar item labels.rE  hhh	h)]rF  X   fontrG  hhrH  ah1X   SetFont(self, font)rI  h3h4h5j  h7jG  ubh#)rJ  }rK  (hX9   wx.lib.agw.aui.auibar.AuiDefaultToolBarArt.SetOrientationrL  hKh'KhX   Sets the toolbar tool orientation.

:param integer `orientation`: one of ``AUI_TBTOOL_HORIZONTAL``, ``AUI_TBTOOL_VERT_CLOCKWISE`` or
 ``AUI_TBTOOL_VERT_COUNTERCLOCKWISE``.rM  hhh	h)]rN  X   orientationrO  hhrP  ah1X!   SetOrientation(self, orientation)rQ  h3h4h5X   10rR  h7jG  ubh#)rS  }rT  (hX=   wx.lib.agw.aui.auibar.AuiDefaultToolBarArt.SetTextOrientationrU  hKh'KhX  Sets the text orientation.

:param integer `orientation`: can be one of the following constants:

 ==================================== ==================================
 Orientation Switches                 Description
 ==================================== ==================================
 ``AUI_TBTOOL_TEXT_LEFT``             Text in :class:`AuiToolBar` items is aligned left
 ``AUI_TBTOOL_TEXT_RIGHT``            Text in :class:`AuiToolBar` items is aligned right
 ``AUI_TBTOOL_TEXT_TOP``              Text in :class:`AuiToolBar` items is aligned top
 ``AUI_TBTOOL_TEXT_BOTTOM``           Text in :class:`AuiToolBar` items is aligned bottom
 ==================================== ==================================rV  hhh	h)]rW  X   orientationrX  hhrY  ah1X%   SetTextOrientation(self, orientation)rZ  h3h4h5X   19r[  h7jG  ubh#)r\  }r]  (hX7   wx.lib.agw.aui.auibar.AuiDefaultToolBarArt.ShowDropDownr^  hKh'KhX   Shows the drop down window menu for overflow items.

:param `wnd`: an instance of :class:`wx.Window`;
:param list `items`: a list of the overflow toolbar items.r_  hhh	h)]r`  (X   wndra  hhrb  X   itemsrc  hhrd  eh1X   ShowDropDown(self, wnd, items)re  h3h4h5X   52rf  h7jG  ubehd]rg  (]rh  X   objectri  a]rj  ]rk  X   AuiDefaultToolBarArtrl  aaehk]rm  hm]rn  h1X   AuiDefaultToolBarArt(object)ro  hpj  )rp  }rq  (j  ]rr  X*   wx.lib.agw.aui.auibar.AuiDefaultToolBarArtrs  ]rt  ru  aj  ]rv  X*   wx.lib.agw.aui.auibar.AuiDefaultToolBarArtrw  aj  jG  ubh'Kh3hqhrX]   /home/wxpy/bb2/dist-src-py37/build/docs/sphinx/wx.lib.agw.aui.auibar.AuiDefaultToolBarArt.txtrx  h7jA  h5X   778ry  j  ]rz  (X   __init__r{  X   Cloner|  X   DrawBackgroundr}  X
   DrawButtonr~  X   DrawControlLabelr  X   DrawDropDownButtonr  X   DrawGripperr  X	   DrawLabelr  X   DrawOverflowButtonr  X   DrawPlainBackgroundr  X
   DrawSeparatorr  X   GetAGWFlagsr  X   GetElementSizer  X   GetFontr  X   GetLabelSizer  X   GetOrientationr  X   GetTextOrientationr  X   GetToolSizer  X   GetToolsPositionr  X   SetAGWFlagsr  X   SetDefaultColoursr  X   SetElementSizer  X   SetFontr  X   SetOrientationr  X   SetTextOrientationr  X   ShowDropDownr  ej  jn  ubh)r  }r  (hX    wx.lib.agw.aui.auibar.AuiToolBarr  hKhX  AuiToolBar is a completely owner-drawn toolbar perfectly integrated with the AUI layout system.
This allows drag and drop of toolbars, docking/floating behaviour and the possibility to define
"overflow" items in the toolbar itself.

The default theme that is used is :class:`AuiDefaultToolBarArt`, which provides a modern,
glossy look and feel. The theme can be changed by calling :meth:`AuiToolBar.SetArtProvider`.r  hhh	h
]r  (h#)r  }r  (hX)   wx.lib.agw.aui.auibar.AuiToolBar.__init__r  hKh'KhXh  Default class constructor.

:param wx.Window `parent`: the :class:`AuiToolBar` parent;
:param integer `id`: an identifier for the control: a value of -1 is taken to mean a default;
:param wx.Point `pos`: the control position. A value of (-1, -1) indicates a default position,
 chosen by either the windowing system or wxPython, depending on platform;
:param wx.Size `size`: the control size. A value of (-1, -1) indicates a default size,
 chosen by either the windowing system or wxPython, depending on platform;
:param integer `style`: the control window style;
:param integer `agwStyle`: the AGW-specific window style. This can be a combination of the
 following bits:

 ==================================== ==================================
 Flag name                            Description
 ==================================== ==================================
 ``AUI_TB_TEXT``                      Shows the text in the toolbar buttons; by default only icons are shown
 ``AUI_TB_NO_TOOLTIPS``               Don't show tooltips on :class:`AuiToolBar` items
 ``AUI_TB_NO_AUTORESIZE``             Do not auto-resize the :class:`AuiToolBar`
 ``AUI_TB_GRIPPER``                   Shows a gripper on the :class:`AuiToolBar`
 ``AUI_TB_OVERFLOW``                  The :class:`AuiToolBar` can contain overflow items
 ``AUI_TB_VERTICAL``                  The :class:`AuiToolBar` is vertical
 ``AUI_TB_HORZ_LAYOUT``               Shows the text and the icons alongside, not vertically stacked.
                                      This style must be used with ``AUI_TB_TEXT``
 ``AUI_TB_PLAIN_BACKGROUND``          Don't draw a gradient background on the toolbar
 ``AUI_TB_HORZ_TEXT``                 Combination of ``AUI_TB_HORZ_LAYOUT`` and ``AUI_TB_TEXT``
 ==================================== ==================================

 The default value for `agwStyle` is: ``AUI_TB_DEFAULT_STYLE`` = 0r  hhh	h)]r  (X   parentr  hhr  X   idr  X	   wx.ID_ANYr  X   -1r  r  X   posr  X   wx.DefaultPositionr  X   (-1, -1)r  r  X   sizer  X   wx.DefaultSizer  X   (-1, -1)r  r  X   styler  j  X   0r  r  X   agwStyler  X   AUI_TB_DEFAULT_STYLEr  X   0r  r  eh1Xy   __init__(self, parent, id=wx.ID_ANY, pos=wx.DefaultPosition, size=wx.DefaultSize, style=0, agwStyle=AUI_TB_DEFAULT_STYLE)r  h3h4h5X   96r  h7j  ubh#)r  }r  (hX-   wx.lib.agw.aui.auibar.AuiToolBar.AddCheckToolr  hKh'KhX   Adds a new check (or toggle) tool to the :class:`AuiToolBar`.

:see: :meth:`AddTool` for an explanation of the input parameters.r  hhh	h)]r  (X   tool_idr  hhr  X   labelr  hhr  X   bitmapr  hhr  X   disabled_bitmapr  hhr  X   short_help_stringr  X   ""r  hr  X   long_help_stringr  X   ""r  hr  X   client_datar  X   Noner  X   Noner  r  eh1Xx   AddCheckTool(self, tool_id, label, bitmap, disabled_bitmap, short_help_string="", long_help_string="", client_data=None)r  h3h4h5j  h7j  ubh#)r  }r  (hX+   wx.lib.agw.aui.auibar.AuiToolBar.AddControlr  hKh'KhX   Adds any control to the toolbar, typically e.g. a :class:`ComboBox`.

:param wx.Window `control`: the control to be added;
:param string `label`: the label which appears if the control goes into the
 overflow items in the toolbar.r  hhh	h)]r  (X   controlr  hhr  X   labelr  X   ""r  hr  eh1X#   AddControl(self, control, label="")r  h3h4h5X   30r  h7j  ubh#)r  }r  (hX)   wx.lib.agw.aui.auibar.AuiToolBar.AddLabelr  hKh'KhX   Adds a label tool to the :class:`AuiToolBar`.

:param integer `tool_id`: an integer by which the tool may be identified in subsequent operations;
:param string `label`: the toolbar tool label;
:param integer `width`: the tool width.r  hhh	h)]r  (X   tool_idr  hhr  X   labelr  X   ""r  hr  X   widthr  j  X   0r  r  eh1X*   AddLabel(self, tool_id, label="", width=0)r  h3h4h5X   39r  h7j  ubh#)r  }r  (hX-   wx.lib.agw.aui.auibar.AuiToolBar.AddRadioToolr  hKh'KhX%  Adds a new radio tool to the toolbar.

Consecutive radio tools form a radio group such that exactly one button
in the group is pressed at any moment, in other words whenever a button
in the group is pressed the previously pressed button is automatically
released. You should avoid having the radio groups of only one element
as it would be impossible for the user to use such button.

:note: By default, the first button in the radio group is initially pressed,
 the others are not.

:see: :meth:`AddTool` for an explanation of the input parameters.r  hhh	h)]r  (X   tool_idr  hhr  X   labelr  hhr  X   bitmapr  hhr  X   disabled_bitmapr  hhr  X   short_help_stringr  X   ""r  hr  X   long_help_stringr  X   ""r  hr  X   client_datar  X   Noner  X   Noner  r  eh1Xx   AddRadioTool(self, tool_id, label, bitmap, disabled_bitmap, short_help_string="", long_help_string="", client_data=None)r   h3h4h5X   18r  h7j  ubh#)r  }r  (hX-   wx.lib.agw.aui.auibar.AuiToolBar.AddSeparatorr  hKh'KhX.   Adds a separator for spacing groups of tools. r  hhh	h)]r  h1X   AddSeparator(self)r  h3h4h5X   23r  h7j  ubh#)r	  }r
  (hX.   wx.lib.agw.aui.auibar.AuiToolBar.AddSimpleToolr  hKh'KhXo  Adds a tool to the toolbar. This is the simplest method you can use to
add an item to the :class:`AuiToolBar`.

:param integer `tool_id`: an integer by which the tool may be identified in subsequent operations;
:param string `label`: the toolbar tool label;
:param wx.Bitmap `bitmap`: the primary tool bitmap;
:param string `short_help_string`: this string is used for the tools tooltip;
:param integer `kind`: the item kind. Can be one of the following:

 ========================  =============================
 Item Kind                 Description
 ========================  =============================
 ``ITEM_CONTROL``          The item in the :class:`AuiToolBar` is a control
 ``ITEM_LABEL``            The item in the :class:`AuiToolBar` is a text label
 ``ITEM_SPACER``           The item in the :class:`AuiToolBar` is a spacer
 ``ITEM_SEPARATOR``        The item in the :class:`AuiToolBar` is a separator
 ``ITEM_CHECK``            The item in the :class:`AuiToolBar` is a toolbar check item
 ``ITEM_NORMAL``           The item in the :class:`AuiToolBar` is a standard toolbar item
 ``ITEM_RADIO``            The item in the :class:`AuiToolBar` is a toolbar radio item
 ========================  =============================

:param `target`: a custom string indicating that an instance of :class:`~wx.lib.agw.aui.framemanager.AuiPaneInfo`
 has been minimized into this toolbar.r  hhh	h)]r
  (X   tool_idr  hhr  X   labelr  hhr  X   bitmapr  hhr  X   short_help_stringr  X   ""r  hr  X   kindr  X   ITEM_NORMALr  X   0r  r  X   targetr  X   Noner  X   Noner  r  eh1X`   AddSimpleTool(self, tool_id, label, bitmap, short_help_string="", kind=ITEM_NORMAL, target=None)r  h3h4h5X   29r   h7j  ubh#)r!  }r"  (hX*   wx.lib.agw.aui.auibar.AuiToolBar.AddSpacerr#  hKh'KhX]   Adds a spacer for spacing groups of tools.

:param integer `pixels`: the width of the spacer.r$  hhh	h)]r%  X   pixelsr&  hhr'  ah1X   AddSpacer(self, pixels)r(  h3h4h5X   28r)  h7j  ubh#)r*  }r+  (hX1   wx.lib.agw.aui.auibar.AuiToolBar.AddStretchSpacerr,  hKh'KhXw   Adds a stretchable spacer for spacing groups of tools.

:param integer `proportion`: the stretchable spacer proportion.r-  hhh	h)]r.  X
   proportionr/  X   1r0  X   1r1  r2  ah1X$   AddStretchSpacer(self, proportion=1)r3  h3h4h5X   28r4  h7j  ubh#)r5  }r6  (hX.   wx.lib.agw.aui.auibar.AuiToolBar.AddToggleToolr7  hKh'KhX  Adds a toggle tool to the toolbar.

:param integer `tool_id`: an integer by which the tool may be identified in subsequent operations;
:param wx.Bitmap `bitmap`: the primary tool bitmap;
:param wx.Bitmap `disabled_bitmap`: the bitmap to use when the tool is disabled. If it is equal to
 :class:`NullBitmap`, the disabled bitmap is automatically generated by greing the normal one;
:param PyObject `client_data`: whatever Python object to associate with the toolbar item;
:param string `short_help_string`: this string is used for the tools tooltip;
:param string `long_help_string`: this string is shown in the statusbar (if any) of the parent
 frame when the mouse pointer is inside the tool.r8  hhh	h)]r9  (X   tool_idr:  hhr;  X   bitmapr<  hhr=  X   disabled_bitmapr>  hhr?  X   toggler@  X   FalserA  X   FalserB  rC  X   client_datarD  X   NonerE  X   NonerF  rG  X   short_help_stringrH  X   ""rI  hrJ  X   long_help_stringrK  X   ""rL  hrM  eh1X   AddToggleTool(self, tool_id, bitmap, disabled_bitmap, toggle=False, client_data=None, short_help_string="", long_help_string="")rN  h3h4h5X   17rO  h7j  ubh#)rP  }rQ  (hX(   wx.lib.agw.aui.auibar.AuiToolBar.AddToolrR  hKh'KhX  Adds a tool to the toolbar. This is the full feature version of :meth:`AddTool`.

:param integer `tool_id`: an integer by which the tool may be identified in subsequent operations;
:param string `label`: the toolbar tool label;
:param wx.Bitmap `bitmap`: the primary tool bitmap;
:param wx.Bitmap `disabled_bitmap`: the bitmap to use when the tool is disabled. If it is equal to
 :class:`NullBitmap`, the disabled bitmap is automatically generated by greing the normal one;
:param integer `kind`: the item kind. Can be one of the following:

 ========================  =============================
 Item Kind                 Description
 ========================  =============================
 ``ITEM_CONTROL``          The item in the :class:`AuiToolBar` is a control
 ``ITEM_LABEL``            The item in the :class:`AuiToolBar` is a text label
 ``ITEM_SPACER``           The item in the :class:`AuiToolBar` is a spacer
 ``ITEM_SEPARATOR``        The item in the :class:`AuiToolBar` is a separator
 ``ITEM_CHECK``            The item in the :class:`AuiToolBar` is a toolbar check item
 ``ITEM_NORMAL``           The item in the :class:`AuiToolBar` is a standard toolbar item
 ``ITEM_RADIO``            The item in the :class:`AuiToolBar` is a toolbar radio item
 ========================  =============================

:param string `short_help_string`: this string is used for the tools tooltip;
:param string `long_help_string`: this string is shown in the statusbar (if any) of the parent
 frame when the mouse pointer is inside the tool.
:param PyObject `client_data`: whatever Python object to associate with the toolbar item.
:param `target`: a custom string indicating that an instance of :class:`~wx.lib.agw.aui.framemanager.AuiPaneInfo`
 has been minimized into this toolbar.rS  hhh	h)]rT  (X   tool_idrU  hhrV  X   labelrW  hhrX  X   bitmaprY  hhrZ  X   disabled_bitmapr[  hhr\  X   kindr]  hhr^  X   short_help_stringr_  X   ''r`  hra  X   long_help_stringrb  X   ''rc  hrd  X   client_datare  X   Nonerf  X   Nonerg  rh  X   targetri  X   Nonerj  X   Nonerk  rl  eh1X   AddTool(self, tool_id, label, bitmap, disabled_bitmap, kind, short_help_string='', long_help_string='', client_data=None, target=None)rm  h3h4h5X   64rn  h7j  ubh#)ro  }rp  (hX&   wx.lib.agw.aui.auibar.AuiToolBar.Clearrq  hKh'KhX2   Deletes all the tools in the :class:`AuiToolBar`. rr  hhh	h)]rs  h1X   Clear(self)rt  h3h4h5hCh7j  ubh#)ru  }rv  (hX+   wx.lib.agw.aui.auibar.AuiToolBar.ClearToolsrw  hKh'KhX2   Deletes all the tools in the :class:`AuiToolBar`. rx  hhh	h)]ry  h1X   ClearTools(self)rz  h3h4h5hIh7j  ubh#)r{  }r|  (hX+   wx.lib.agw.aui.auibar.AuiToolBar.DeleteToolr}  hKh'KhX7  Removes the specified tool from the toolbar and deletes it.

:param integer `tool_id`: the :class:`AuiToolBarItem` identifier.

:returns: ``True`` if the tool was deleted, ``False`` otherwise.

:note: Note that it is unnecessary to call :meth:`Realize` for the change to
 take place, it will happen immediately.r~  hhh	h)]r  X   tool_idr  hhr  ah1X   DeleteTool(self, tool_id)r  h3h4h5X   21r  h7j  ubh#)r  }r  (hX0   wx.lib.agw.aui.auibar.AuiToolBar.DeleteToolByPosr  hKh'KhX   This function behaves like :meth:`DeleteTool` but it deletes the tool at the specified position and not the one with the given id.

:param integer `pos`: the tool position.

:see: :meth:`~AuiToolBar.DeleteTool`r  hhh	h)]r  X   posr  hhr  ah1X   DeleteToolByPos(self, pos)r  h3h4h5X   17r  h7j  ubh#)r  }r  (hX.   wx.lib.agw.aui.auibar.AuiToolBar.DoGetBestSizer  hKh'KhX   Gets the size which best suits the window: for a control, it would be the
minimal size which doesn't truncate the control, for a panel - the same
size as it would have after a call to `Fit()`.

:note: Overridden from :class:`wx.Control`.r  hhh	h)]r  h1X   DoGetBestSize(self)r  h3h4h5X   11r  h7j  ubh#)r  }r  (hX-   wx.lib.agw.aui.auibar.AuiToolBar.DoIdleUpdater  hKh'KhX'   Updates the toolbar during idle times. r  hhh	h)]r  h1X   DoIdleUpdate(self)r  h3h4h5X   63r  h7j  ubh#)r  }r  (hX*   wx.lib.agw.aui.auibar.AuiToolBar.DoSetSizer  hKh'KhX  Sets the position and size of the window in pixels. The `sizeFlags`
parameter indicates the interpretation of the other params if they are
equal to -1.

:param integer `x`: the window `x` position;
:param integer `y`: the window `y` position;
:param integer `width`: the window width;
:param integer `height`: the window height;
:param integer `sizeFlags`: may have one of this bit set:

 ===================================  ======================================
 Size Flags                           Description
 ===================================  ======================================
 ``wx.SIZE_AUTO``                     A -1 indicates that a class-specific default should be used.
 ``wx.SIZE_AUTO_WIDTH``               A -1 indicates that a class-specific default should be used for the width.
 ``wx.SIZE_AUTO_HEIGHT``              A -1 indicates that a class-specific default should be used for the height.
 ``wx.SIZE_USE_EXISTING``             Existing dimensions should be used if -1 values are supplied.
 ``wx.SIZE_ALLOW_MINUS_ONE``          Allow dimensions of -1 and less to be interpreted as real dimensions, not default values.
 ``wx.SIZE_FORCE``                    Normally, if the position and the size of the window are already the same as the
                                      parameters of this function, nothing is done. but with this flag a window resize may
                                      be forced even in this case (supported in wx 2.6.2 and later and only implemented
                                      for MSW and ignored elsewhere currently)
 ===================================  ======================================

:note: Overridden from :class:`wx.Control`.r  hhh	h)]r  (X   xr  hhr  X   yr  hhr  X   widthr  hhr  X   heightr  hhr  X	   sizeFlagsr  X   wx.SIZE_AUTOr  X   3r  r  eh1X<   DoSetSize(self, x, y, width, height, sizeFlags=wx.SIZE_AUTO)r  h3h4h5X   37r  h7j  ubh#)r  }r  (hX+   wx.lib.agw.aui.auibar.AuiToolBar.EnableToolr  hKh'KhX   Enables or disables the tool.

:param integer `tool_id`: identifier for the tool to enable or disable.
:param bool `state`: if ``True``, enables the tool, otherwise disables it.r  hhh	h)]r  (X   tool_idr  hhr  X   stater  hhr  eh1X    EnableTool(self, tool_id, state)r  h3h4h5X   17r  h7j  ubh#)r  }r  (hX,   wx.lib.agw.aui.auibar.AuiToolBar.FindControlr  hKh'KhX   Returns a pointer to the control identified by `id` or ``None`` if no corresponding control is found.

:param integer `id`: the control identifier.r  hhh	h)]r  X   idr  hhr  ah1X   FindControl(self, id)r  h3h4h5X   10r  h7j  ubh#)r  }r  (hX)   wx.lib.agw.aui.auibar.AuiToolBar.FindToolr  hKh'KhXf   Finds a tool for the given tool id.

:param integer `tool_id`: the :class:`AuiToolBarItem` identifier.r  hhh	h)]r  X   tool_idr  hhr  ah1X   FindTool(self, tool_id)r  h3h4h5X   13r  h7j  ubh#)r  }r  (hX0   wx.lib.agw.aui.auibar.AuiToolBar.FindToolByIndexr  hKh'KhX   Finds a tool for the given tool position in the :class:`AuiToolBar`.

:param integer `pos`: the tool position in the toolbar.

:returns: a pointer to a :class:`AuiToolBarItem` if a tool is found, or ``None`` otherwise.r  hhh	h)]r  X   posr  hhr  ah1X   FindToolByIndex(self, pos)r  h3h4h5X   14r  h7j  ubh#)r  }r  (hX0   wx.lib.agw.aui.auibar.AuiToolBar.FindToolByLabelr  hKh'KhX\   Finds a tool for the given label.

:param string `label`: the :class:`AuiToolBarItem` label.r  hhh	h)]r  X   labelr  hhr  ah1X   FindToolByLabel(self, label)r  h3h4h5X   13r  h7j  ubh#)r  }r  (hX4   wx.lib.agw.aui.auibar.AuiToolBar.FindToolForPositionr  hKh'KhX   Finds a tool for the given mouse position.

:param integer `x`: mouse `x` position;
:param integer `y`: mouse `y` position.

:returns: a pointer to a :class:`AuiToolBarItem` if a tool is found, or ``None`` otherwise.r  hhh	h)]r  (j  hhr  j  hhr  eh1X   FindToolForPosition(self, x, y)r  h3h4h5X   25r  h7j  ubh#)r  }r  (hX?   wx.lib.agw.aui.auibar.AuiToolBar.FindToolForPositionWithPackingr  hKh'KhX  Finds a tool for the given mouse position, taking into account also the tool packing.

:param integer `x`: mouse `x` position;
:param integer `y`: mouse `y` position.

:returns: a pointer to a :class:`AuiToolBarItem` if a tool is found, or ``None`` otherwise.r  hhh	h)]r  (j  hhr  j  hhr  eh1X*   FindToolForPositionWithPacking(self, x, y)r  h3h4h5X   32r  h7j  ubh#)r  }r  (hX6   wx.lib.agw.aui.auibar.AuiToolBar.GetAGWWindowStyleFlagr  hKh'KhX   Returns the AGW-specific window style flag.

:see: :meth:`SetAGWWindowStyleFlag` for an explanation of various AGW-specific style.r  hhh	h)]r  h1X   GetAGWWindowStyleFlag(self)r  h3h4h5j  h7j  ubh#)r  }r  (hX/   wx.lib.agw.aui.auibar.AuiToolBar.GetArtProviderr  hKh'KhX-   Returns the current art provider being used. r  hhh	h)]r  h1X   GetArtProvider(self)r  h3h4h5hIh7j  ubh#)r  }r  (hX.   wx.lib.agw.aui.auibar.AuiToolBar.GetAuiManagerr  hKh'KhXX   Returns the :class:`~wx.lib.agw.aui.framemanager.AuiManager` which manages the toolbar. r  hhh	h)]r  h1X   GetAuiManager(self)r   h3h4h5j~  h7j  ubh#)r  }r  (hX2   wx.lib.agw.aui.auibar.AuiToolBar.GetGripperVisibler  hKh'KhX7   Returns whether the toolbar gripper is visible or not. r  hhh	h)]r  h1X   GetGripperVisible(self)r  h3h4h5hIh7j  ubh#)r  }r  (hX-   wx.lib.agw.aui.auibar.AuiToolBar.GetLabelSizer	  hKh'KhXR   Returns the standard size of a toolbar item.

:param string `label`: a test label.r
  hhh	h)]r  X   labelr  hhr
  ah1X   GetLabelSize(self, label)r  h3h4h5X   12r  h7j  ubh#)r  }r  (hX0   wx.lib.agw.aui.auibar.AuiToolBar.GetOverflowRectr  hKh'KhX.   Returns the rectangle of the overflow button. r  hhh	h)]r  h1X   GetOverflowRect(self)r  h3h4h5X   23r  h7j  ubh#)r  }r  (hX1   wx.lib.agw.aui.auibar.AuiToolBar.GetOverflowStater  hKh'KhX*   Returns the state of the overflow button. r  hhh	h)]r  h1X   GetOverflowState(self)r  h3h4h5hIh7j  ubh#)r  }r  (hX3   wx.lib.agw.aui.auibar.AuiToolBar.GetOverflowVisibler  hKh'KhX7   Returns whether the overflow button is visible or not. r   hhh	h)]r!  h1X   GetOverflowVisible(self)r"  h3h4h5hIh7j  ubh#)r#  }r$  (hX/   wx.lib.agw.aui.auibar.AuiToolBar.GetToolBarFitsr%  hKh'KhXG   Returns whether the :class:`AuiToolBar` size fits in a specified size. r&  hhh	h)]r'  h1X   GetToolBarFits(self)r(  h3h4h5X   10r)  h7j  ubh#)r*  }r+  (hX.   wx.lib.agw.aui.auibar.AuiToolBar.GetToolBitmapr,  hKh'KhXm   Returns the tool bitmap for the tool identified by `tool_id`.

:param integer `tool_id`: the tool identifier.r-  hhh	h)]r.  X   tool_idr/  hhr0  ah1X   GetToolBitmap(self, tool_id)r1  h3h4h5X   13r2  h7j  ubh#)r3  }r4  (hX2   wx.lib.agw.aui.auibar.AuiToolBar.GetToolBitmapSizer5  hKh'KhX;  Returns the size of bitmap that the toolbar expects to have. The default bitmap size is 16 by 15 pixels.

:note: Note that this is the size of the bitmap you pass to :meth:`AddTool`,
 and not the eventual size of the tool button.

.. todo::

   Add :class:`ToolBar` compatibility, actually implementing this method.r6  hhh	h)]r7  h1X   GetToolBitmapSize(self)r8  h3h4h5X   16r9  h7j  ubh#)r:  }r;  (hX5   wx.lib.agw.aui.auibar.AuiToolBar.GetToolBorderPaddingr<  hKh'KhXF   Returns the padding between the tool border and the label, in pixels. r=  hhh	h)]r>  h1X   GetToolBorderPadding(self)r?  h3h4h5hIh7j  ubh#)r@  }rA  (hX-   wx.lib.agw.aui.auibar.AuiToolBar.GetToolCountrB  hKh'KhX8   Returns the number of tools in the :class:`AuiToolBar`. rC  hhh	h)]rD  h1X   GetToolCount(self)rE  h3h4h5hIh7j  ubh#)rF  }rG  (hX0   wx.lib.agw.aui.auibar.AuiToolBar.GetToolDropDownrH  hKh'KhX   Returns whether the toolbar item identified by `tool_id` has an associated drop down window menu or not.

:param integer `tool_id`: the :class:`AuiToolBarItem` identifier.rI  hhh	h)]rJ  X   tool_idrK  hhrL  ah1X   GetToolDropDown(self, tool_id)rM  h3h4h5X   13rN  h7j  ubh#)rO  }rP  (hX/   wx.lib.agw.aui.auibar.AuiToolBar.GetToolEnabledrQ  hKh'KhXs   Returns whether the tool identified by `tool_id` is enabled or not.

:param integer `tool_id`: the tool identifier.rR  hhh	h)]rS  X   tool_idrT  hhrU  ah1X   GetToolEnabled(self, tool_id)rV  h3h4h5X   14rW  h7j  ubh#)rX  }rY  (hX,   wx.lib.agw.aui.auibar.AuiToolBar.GetToolFitsrZ  hKh'KhX   Returns whether the tool identified by `tool_id` fits into the toolbar or not.

:param integer `tool_id`: the toolbar item identifier.r[  hhh	h)]r\  X   tool_idr]  hhr^  ah1X   GetToolFits(self, tool_id)r_  h3h4h5j  h7j  ubh#)r`  }ra  (hX3   wx.lib.agw.aui.auibar.AuiToolBar.GetToolFitsByIndexrb  hKh'KhX   Returns whether the tool identified by `tool_id` fits into the toolbar or not.

:param integer `tool_id`: the toolbar item identifier.rc  hhh	h)]rd  X   tool_idre  hhrf  ah1X!   GetToolFitsByIndex(self, tool_id)rg  h3h4h5X   36rh  h7j  ubh#)ri  }rj  (hX-   wx.lib.agw.aui.auibar.AuiToolBar.GetToolIndexrk  hKh'KhX}   Returns the position of the tool in the toolbar given its identifier.

:param integer `tool_id`: the toolbar item identifier.rl  hhh	h)]rm  X   tool_idrn  hhro  ah1X   GetToolIndex(self, tool_id)rp  h3h4h5X   18rq  h7j  ubh#)rr  }rs  (hX-   wx.lib.agw.aui.auibar.AuiToolBar.GetToolLabelrt  hKh'KhXl   Returns the tool label for the tool identified by `tool_id`.

:param integer `tool_id`: the tool identifier.ru  hhh	h)]rv  X   tool_idrw  hhrx  ah1X   GetToolLabel(self, tool_id)ry  h3h4h5X   13rz  h7j  ubh#)r{  }r|  (hX0   wx.lib.agw.aui.auibar.AuiToolBar.GetToolLongHelpr}  hKh'KhXY   Returns the long help for the given tool.

:param integer `tool_id`: the tool identifier.r~  hhh	h)]r  X   tool_idr  hhr  ah1X   GetToolLongHelp(self, tool_id)r  h3h4h5X   13r  h7j  ubh#)r  }r  (hX3   wx.lib.agw.aui.auibar.AuiToolBar.GetToolOrientationr  hKh'KhX/   Returns the orientation for the toolbar items. r  hhh	h)]r  h1X   GetToolOrientation(self)r  h3h4h5hIh7j  ubh#)r  }r  (hX/   wx.lib.agw.aui.auibar.AuiToolBar.GetToolPackingr  hKh'KhXH   Returns the value used for spacing tools. The default value is 1 pixel. r  hhh	h)]r  h1X   GetToolPacking(self)r  h3h4h5hIh7j  ubh#)r  }r  (hX+   wx.lib.agw.aui.auibar.AuiToolBar.GetToolPosr  hKh'KhX}   Returns the position of the tool in the toolbar given its identifier.

:param integer `tool_id`: the toolbar item identifier.r  hhh	h)]r  X   tool_idr  hhr  ah1X   GetToolPos(self, tool_id)r  h3h4h5j  h7j  ubh#)r  }r  (hX2   wx.lib.agw.aui.auibar.AuiToolBar.GetToolProportionr  hKh'KhXn   Returns the tool proportion in the toolbar.

:param integer `tool_id`: the :class:`AuiToolBarItem` identifier.r  hhh	h)]r  X   tool_idr  hhr  ah1X    GetToolProportion(self, tool_id)r  h3h4h5X   13r  h7j  ubh#)r  }r  (hX,   wx.lib.agw.aui.auibar.AuiToolBar.GetToolRectr  hKh'KhXZ   Returns the toolbar item rectangle

:param integer `tool_id`: the toolbar item identifier.r  hhh	h)]r  X   tool_idr  hhr  ah1X   GetToolRect(self, tool_id)r  h3h4h5X   13r  h7j  ubh#)r  }r  (hX2   wx.lib.agw.aui.auibar.AuiToolBar.GetToolSeparationr  hKh'KhX7   Returns the separator size for the toolbar, in pixels. r  hhh	h)]r  h1X   GetToolSeparation(self)r  h3h4h5j~  h7j  ubh#)r  }r  (hX1   wx.lib.agw.aui.auibar.AuiToolBar.GetToolShortHelpr  hKh'KhXZ   Returns the short help for the given tool.

:param integer `tool_id`: the tool identifier.r  hhh	h)]r  X   tool_idr  hhr  ah1X   GetToolShortHelp(self, tool_id)r  h3h4h5X   13r  h7j  ubh#)r  }r  (hX.   wx.lib.agw.aui.auibar.AuiToolBar.GetToolStickyr  hKh'KhX   Returns whether the toolbar item identified by `tool_id` has a sticky behaviour or not.

:param integer `tool_id`: the :class:`AuiToolBarItem` identifier.r  hhh	h)]r  X   tool_idr  hhr  ah1X   GetToolSticky(self, tool_id)r  h3h4h5X   13r  h7j  ubh#)r  }r  (hX7   wx.lib.agw.aui.auibar.AuiToolBar.GetToolTextOrientationr  hKh'KhX5   Returns the label orientation for the toolbar items. r  hhh	h)]r  h1X   GetToolTextOrientation(self)r  h3h4h5hIh7j  ubh#)r  }r  (hX/   wx.lib.agw.aui.auibar.AuiToolBar.GetToolToggledr  hKh'KhX   Returns whether a tool is toggled or not.

:param integer `tool_id`: the toolbar item identifier.

:note: This only applies to a tool that has been specified as a toggle tool.r  hhh	h)]r  X   tool_idr  hhr  ah1X   GetToolToggled(self, tool_id)r  h3h4h5X   19r  h7j  ubh#)r  }r  (hX(   wx.lib.agw.aui.auibar.AuiToolBar.HitTestr  hKh'KhXL  Finds a tool for the given mouse position.

:param integer `x`: mouse `x` screen position;
:param integer `y`: mouse `y` screen position.

:returns: a pointer to a :class:`AuiToolBarItem` if a tool is found, or ``None`` otherwise.

:note: This method is similar to :meth:`FindToolForPosition` but it works with absolute coordinates.r  hhh	h)]r  (j  hhr  j  hhr  eh1X   HitTest(self, x, y)r  h3h4h5X   14r  h7j  ubh#)r  }r  (hX0   wx.lib.agw.aui.auibar.AuiToolBar.IsPaneMinimizedr  hKh'KhXI   Returns whether this :class:`AuiToolBar` contains a minimized pane tool. r  hhh	h)]r  h1X   IsPaneMinimized(self)r  h3h4h5X   19r  h7j  ubh#)r  }r  (hX/   wx.lib.agw.aui.auibar.AuiToolBar.OnCustomRenderr  hKh'KhX  Handles custom render for single :class:`AuiToolBar` items.

:param `dc`: a :class:`wx.DC` device context;
:param `item`: an instance of :class:`AuiToolBarItem`;
:param wx.Rect `rect`: the toolbar item rect.

:note: This method must be overridden to provide custom rendering of items.r  hhh	h)]r  (X   dcr  hhr  X   itemr  hhr  X   rectr  hhr  eh1X$   OnCustomRender(self, dc, item, rect)r  h3h4h5X   13r  h7j  ubh#)r  }r  (hX2   wx.lib.agw.aui.auibar.AuiToolBar.OnEraseBackgroundr  hKh'KhX   Handles the ``wx.EVT_ERASE_BACKGROUND`` event for :class:`AuiToolBar`.

:param `event`: a :class:`EraseEvent` event to be processed.

:note: This is intentionally empty, to reduce flicker.r  hhh	h)]r  X   eventr  hhr  ah1X   OnEraseBackground(self, event)r  h3h4h5X   11r  h7j  ubh#)r  }r  (hX'   wx.lib.agw.aui.auibar.AuiToolBar.OnIdler  hKh'KhXw   Handles the ``wx.EVT_IDLE`` event for :class:`AuiToolBar`.

:param `event`: a :class:`IdleEvent` event to be processed.r  hhh	h)]r  X   eventr  hhr  ah1X   OnIdle(self, event)r  h3h4h5X   10r  h7j  ubh#)r   }r  (hX.   wx.lib.agw.aui.auibar.AuiToolBar.OnLeaveWindowr  hKh'KhX   Handles the ``wx.EVT_LEAVE_WINDOW`` event for :class:`AuiToolBar`.

:param `event`: a :class:`MouseEvent` event to be processed.r  hhh	h)]r  X   eventr  hhr  ah1X   OnLeaveWindow(self, event)r  h3h4h5X   14r  h7j  ubh#)r	  }r
  (hX+   wx.lib.agw.aui.auibar.AuiToolBar.OnLeftDownr  hKh'KhX}   Handles the ``wx.EVT_LEFT_DOWN`` event for :class:`AuiToolBar`.

:param `event`: a :class:`MouseEvent` event to be processed.r  hhh	h)]r
  X   eventr  hhr  ah1X   OnLeftDown(self, event)r  h3h4h5X   117r  h7j  ubh#)r  }r  (hX)   wx.lib.agw.aui.auibar.AuiToolBar.OnLeftUpr  hKh'KhX{   Handles the ``wx.EVT_LEFT_UP`` event for :class:`AuiToolBar`.

:param `event`: a :class:`MouseEvent` event to be processed.r  hhh	h)]r  X   eventr  hhr  ah1X   OnLeftUp(self, event)r  h3h4h5X   77r  h7j  ubh#)r  }r  (hX-   wx.lib.agw.aui.auibar.AuiToolBar.OnMiddleDownr  hKh'KhX   Handles the ``wx.EVT_MIDDLE_DOWN`` event for :class:`AuiToolBar`.

:param `event`: a :class:`MouseEvent` event to be processed.r  hhh	h)]r  X   eventr   hhr!  ah1X   OnMiddleDown(self, event)r"  h3h4h5X   32r#  h7j  ubh#)r$  }r%  (hX+   wx.lib.agw.aui.auibar.AuiToolBar.OnMiddleUpr&  hKh'KhX}   Handles the ``wx.EVT_MIDDLE_UP`` event for :class:`AuiToolBar`.

:param `event`: a :class:`MouseEvent` event to be processed.r'  hhh	h)]r(  X   eventr)  hhr*  ah1X   OnMiddleUp(self, event)r+  h3h4h5X   23r,  h7j  ubh#)r-  }r.  (hX)   wx.lib.agw.aui.auibar.AuiToolBar.OnMotionr/  hKh'KhXz   Handles the ``wx.EVT_MOTION`` event for :class:`AuiToolBar`.

:param `event`: a :class:`MouseEvent` event to be processed.r0  hhh	h)]r1  X   eventr2  hhr3  ah1X   OnMotion(self, event)r4  h3h4h5X   66r5  h7j  ubh#)r6  }r7  (hX(   wx.lib.agw.aui.auibar.AuiToolBar.OnPaintr8  hKh'KhXy   Handles the ``wx.EVT_PAINT`` event for :class:`AuiToolBar`.

:param `event`: a :class:`PaintEvent` event to be processed.r9  hhh	h)]r:  X   eventr;  hhr<  ah1X   OnPaint(self, event)r=  h3h4h5X   98r>  h7j  ubh#)r?  }r@  (hX,   wx.lib.agw.aui.auibar.AuiToolBar.OnRightDownrA  hKh'KhX~   Handles the ``wx.EVT_RIGHT_DOWN`` event for :class:`AuiToolBar`.

:param `event`: a :class:`MouseEvent` event to be processed.rB  hhh	h)]rC  X   eventrD  hhrE  ah1X   OnRightDown(self, event)rF  h3h4h5X   31rG  h7j  ubh#)rH  }rI  (hX*   wx.lib.agw.aui.auibar.AuiToolBar.OnRightUprJ  hKh'KhX|   Handles the ``wx.EVT_RIGHT_UP`` event for :class:`AuiToolBar`.

:param `event`: a :class:`MouseEvent` event to be processed.rK  hhh	h)]rL  X   eventrM  hhrN  ah1X   OnRightUp(self, event)rO  h3h4h5X   32rP  h7j  ubh#)rQ  }rR  (hX,   wx.lib.agw.aui.auibar.AuiToolBar.OnSetCursorrS  hKh'KhX   Handles the ``wx.EVT_SET_CURSOR`` event for :class:`AuiToolBar`.

:param `event`: a :class:`SetCursorEvent` event to be processed.rT  hhh	h)]rU  X   eventrV  hhrW  ah1X   OnSetCursor(self, event)rX  h3h4h5X   17rY  h7j  ubh#)rZ  }r[  (hX'   wx.lib.agw.aui.auibar.AuiToolBar.OnSizer\  hKh'KhXz   Handles the ``wx.EVT_SIZE`` event for :class:`AuiToolBar`.

:param `event`: a :class:`wx.SizeEvent` event to be processed.r]  hhh	h)]r^  X   eventr_  hhr`  ah1X   OnSize(self, event)ra  h3h4h5X   68rb  h7j  ubh#)rc  }rd  (hX(   wx.lib.agw.aui.auibar.AuiToolBar.Realizere  hKh'KhXQ   Realizes the toolbar. This function should be called after you have added tools. rf  hhh	h)]rg  h1X
   Realize(self)rh  h3h4h5X   215ri  h7j  ubh#)rj  }rk  (hX5   wx.lib.agw.aui.auibar.AuiToolBar.RefreshOverflowStaterl  hKh'KhX   Refreshes the overflow button. rm  hhh	h)]rn  h1X   RefreshOverflowState(self)ro  h3h4h5X   29rp  h7j  ubh#)rq  }rr  (hX6   wx.lib.agw.aui.auibar.AuiToolBar.SetAGWWindowStyleFlagrs  hKh'KhX  Sets the AGW-specific style of the window.

:param integer `agwStyle`: the new window style. This can be a combination of the
 following bits:

 ==================================== ==================================
 Flag name                            Description
 ==================================== ==================================
 ``AUI_TB_TEXT``                      Shows the text in the toolbar buttons; by default only icons are shown
 ``AUI_TB_NO_TOOLTIPS``               Don't show tooltips on :class:`AuiToolBar` items
 ``AUI_TB_NO_AUTORESIZE``             Do not auto-resize the :class:`AuiToolBar`
 ``AUI_TB_GRIPPER``                   Shows a gripper on the :class:`AuiToolBar`
 ``AUI_TB_OVERFLOW``                  The :class:`AuiToolBar` can contain overflow items
 ``AUI_TB_VERTICAL``                  The :class:`AuiToolBar` is vertical
 ``AUI_TB_HORZ_LAYOUT``               Shows the text and the icons alongside, not vertically stacked.
                                      This style must be used with ``AUI_TB_TEXT``
 ``AUI_TB_PLAIN_BACKGROUND``          Don't draw a gradient background on the toolbar
 ``AUI_TB_HORZ_TEXT``                 Combination of ``AUI_TB_HORZ_LAYOUT`` and ``AUI_TB_TEXT``
 ==================================== ==================================

:note: Please note that some styles cannot be changed after the window
 creation and that `Refresh` might need to be be called after changing the
 others for the change to take place immediately.rt  hhh	h)]ru  X   agwStylerv  hhrw  ah1X%   SetAGWWindowStyleFlag(self, agwStyle)rx  h3h4h5X   53ry  h7j  ubh#)rz  }r{  (hX/   wx.lib.agw.aui.auibar.AuiToolBar.SetArtProviderr|  hKh'KhX
  Instructs :class:`AuiToolBar` to use art provider specified by parameter `art`
for all drawing calls. This allows pluggable look-and-feel features.

:param `art`: an art provider.

:note: The previous art provider object, if any, will be deleted by :class:`AuiToolBar`.r}  hhh	h)]r~  X   artr  hhr  ah1X   SetArtProvider(self, art)r  h3h4h5X   18r  h7j  ubh#)r  }r  (hX.   wx.lib.agw.aui.auibar.AuiToolBar.SetAuiManagerr  hKh'KhXU   Sets the :class:`~wx.lib.agw.aui.framemanager.AuiManager` which manages the toolbar. r  hhh	h)]r  X
   auiManagerr  hhr  ah1X   SetAuiManager(self, auiManager)r  h3h4h5hIh7j  ubh#)r  }r  (hX7   wx.lib.agw.aui.auibar.AuiToolBar.SetCustomOverflowItemsr  hKh'KhX   Sets the two lists `prepend` and `append` as custom overflow items.

:param list `prepend`: a list of :class:`AuiToolBarItem` to be prepended;
:param list `append`: a list of :class:`AuiToolBarItem` to be appended.r  hhh	h)]r  (X   prependr  hhr  X   appendr  hhr  eh1X-   SetCustomOverflowItems(self, prepend, append)r  h3h4h5X   11r  h7j  ubh#)r  }r  (hX(   wx.lib.agw.aui.auibar.AuiToolBar.SetFontr  hKh'KhX}   Sets the :class:`AuiToolBar` font.

:param wx.Font `font`: the new toolbar font.

:note: Overridden from :class:`wx.Control`.r  hhh	h)]r  X   fontr  hhr  ah1X   SetFont(self, font)r  h3h4h5X   16r  h7j  ubh#)r  }r  (hX2   wx.lib.agw.aui.auibar.AuiToolBar.SetGripperVisibler  hKh'KhX   Sets whether the toolbar gripper is visible or not.

:param bool `visible`: ``True`` for a visible gripper, ``False`` otherwise.r  hhh	h)]r  X   visibler  hhr  ah1X    SetGripperVisible(self, visible)r  h3h4h5X   16r  h7j  ubh#)r  }r  (hX-   wx.lib.agw.aui.auibar.AuiToolBar.SetHoverItemr  hKh'KhXr   Sets a toolbar item to be currently hovered by the mouse.

:param `pitem`: an instance of :class:`AuiToolBarItem`.r  hhh	h)]r  X   pitemr  hhr  ah1X   SetHoverItem(self, pitem)r  h3h4h5X   23r  h7j  ubh#)r  }r  (hX+   wx.lib.agw.aui.auibar.AuiToolBar.SetMarginsr  hKh'KhX   Set the values to be used as margins for the toolbar.

:param integer `left`: the left toolbar margin;
:param integer `right`: the right toolbar margin;
:param integer `top`: the top toolbar margin;
:param integer `bottom`: the bottom toolbar margin.r  hhh	h)]r  (X   leftr  X   -1r  X   -1r  r  X   rightr  X   -1r  X   -1r  r  X   topr  X   -1r  X   -1r  r  X   bottomr  X   -1r  X   -1r  r  eh1X6   SetMargins(self, left=-1, right=-1, top=-1, bottom=-1)r  h3h4h5X   19r  h7j  ubh#)r  }r  (hX/   wx.lib.agw.aui.auibar.AuiToolBar.SetMarginsSizer  hKh'KhX   Set the values to be used as margins for the toolbar.

:param wx.Size `size`: the margin size (an instance of :class:`wx.Size`).r  hhh	h)]r  X   sizer  hhr  ah1X   SetMarginsSize(self, size)r  h3h4h5j  h7j  ubh#)r  }r  (hX-   wx.lib.agw.aui.auibar.AuiToolBar.SetMarginsXYr  hKh'KhX   Set the values to be used as margins for the toolbar.

:param integer `x`: left margin, right margin and inter-tool separation value;
:param integer `y`: top margin, bottom margin and inter-tool separation value.r  hhh	h)]r  (j  hhr  j  hhr  eh1X   SetMarginsXY(self, x, y)r  h3h4h5X   10r  h7j  ubh#)r  }r  (hX/   wx.lib.agw.aui.auibar.AuiToolBar.SetOrientationr  hKh'KhX   Sets the toolbar orientation.

:param integer `orientation`: either ``wx.VERTICAL`` or ``wx.HORIZONTAL``.

:note: This can be temporarily overridden by :class:`~wx.lib.agw.aui.framemanager.AuiManager` when floating and
 docking a :class:`AuiToolBar`.r  hhh	h)]r  X   orientationr  hhr  ah1X!   SetOrientation(self, orientation)r  h3h4h5X   12r  h7j  ubh#)r  }r  (hX3   wx.lib.agw.aui.auibar.AuiToolBar.SetOverflowVisibler  hKh'KhX   Sets whether the overflow button is visible or not.

:param bool `visible`: ``True`` for a visible overflow button, ``False`` otherwise.r  hhh	h)]r  X   visibler  hhr  ah1X!   SetOverflowVisible(self, visible)r  h3h4h5X   15r  h7j  ubh#)r  }r  (hX/   wx.lib.agw.aui.auibar.AuiToolBar.SetPressedItemr  hKh'KhXr   Sets a toolbar item to be currently in a "pressed" state.

:param `pitem`: an instance of :class:`AuiToolBarItem`.r  hhh	h)]r  X   pitemr  hhr  ah1X   SetPressedItem(self, pitem)r  h3h4h5X   24r  h7j  ubh#)r  }r  (hX1   wx.lib.agw.aui.auibar.AuiToolBar.SetToolAlignmentr  hKh'KhX   This sets the alignment for all of the tools within the toolbar
(only has an effect when the toolbar is expanded).

:param integer `alignment`: :class:`wx.Sizer` alignment value
 (``wx.ALIGN_CENTER_HORIZONTAL`` or ``wx.ALIGN_CENTER_VERTICAL``).r  hhh	h)]r  X	   alignmentr  X	   wx.EXPANDr  X   8192r  r  ah1X+   SetToolAlignment(self, alignment=wx.EXPAND)r  h3h4h5X   11r  h7j  ubh#)r  }r   (hX.   wx.lib.agw.aui.auibar.AuiToolBar.SetToolBitmapr  hKh'KhX   Sets the tool bitmap for the tool identified by `tool_id`.

:param integer `tool_id`: the tool identifier;
:param wx.Bitmap `bitmap`: the new bitmap for the toolbar item.r  hhh	h)]r  (X   tool_idr  hhr  X   bitmapr  hhr  eh1X$   SetToolBitmap(self, tool_id, bitmap)r  h3h4h5X   12r	  h7j  ubh#)r
  }r  (hX2   wx.lib.agw.aui.auibar.AuiToolBar.SetToolBitmapSizer  hKh'KhX  Sets the default size of each tool bitmap. The default bitmap size is 16 by 15 pixels.

:param wx.Size `size`: the size of the bitmaps in the toolbar.

:note: This should be called to tell the toolbar what the tool bitmap
 size is. Call it before you add tools.

:note: Note that this is the size of the bitmap you pass to :meth:`AddTool`,
 and not the eventual size of the tool button.

.. todo::

   Add :class:`ToolBar` compatibility, actually implementing this method.r
  hhh	h)]r  X   sizer  hhr  ah1X   SetToolBitmapSize(self, size)r  h3h4h5X   21r  h7j  ubh#)r  }r  (hX5   wx.lib.agw.aui.auibar.AuiToolBar.SetToolBorderPaddingr  hKh'KhXi   Sets the padding between the tool border and the label.

:param integer `padding`: the padding in pixels.r  hhh	h)]r  X   paddingr  hhr  ah1X#   SetToolBorderPadding(self, padding)r  h3h4h5j  h7j  ubh#)r  }r  (hX6   wx.lib.agw.aui.auibar.AuiToolBar.SetToolDisabledBitmapr  hKh'KhX   Sets the tool disabled bitmap for the tool identified by `tool_id`.

:param integer `tool_id`: the tool identifier;
:param wx.Bitmap `bitmap`: the new disabled bitmap for the toolbar item.r  hhh	h)]r  (X   tool_idr   hhr!  X   bitmapr"  hhr#  eh1X,   SetToolDisabledBitmap(self, tool_id, bitmap)r$  h3h4h5X   12r%  h7j  ubh#)r&  }r'  (hX0   wx.lib.agw.aui.auibar.AuiToolBar.SetToolDropDownr(  hKh'KhX   Assigns a drop down window menu to the toolbar item.

:param integer `tool_id`: the :class:`AuiToolBarItem` identifier;
:param bool `dropdown`: whether to assign a drop down menu or not.r)  hhh	h)]r*  (X   tool_idr+  hhr,  X   dropdownr-  hhr.  eh1X(   SetToolDropDown(self, tool_id, dropdown)r/  h3h4h5X   14r0  h7j  ubh#)r1  }r2  (hX-   wx.lib.agw.aui.auibar.AuiToolBar.SetToolLabelr3  hKh'KhX   Sets the tool label for the tool identified by `tool_id`.

:param integer `tool_id`: the tool identifier;
:param string `label`: the new toolbar item label.r4  hhh	h)]r5  (X   tool_idr6  hhr7  X   labelr8  hhr9  eh1X"   SetToolLabel(self, tool_id, label)r:  h3h4h5X   12r;  h7j  ubh#)r<  }r=  (hX0   wx.lib.agw.aui.auibar.AuiToolBar.SetToolLongHelpr>  hKh'KhX   Sets the long help for the given tool.

:param integer `tool_id`: the tool identifier;
:param string `help_string`: the string for the long help.r?  hhh	h)]r@  (X   tool_idrA  hhrB  X   help_stringrC  hhrD  eh1X+   SetToolLongHelp(self, tool_id, help_string)rE  h3h4h5X   12rF  h7j  ubh#)rG  }rH  (hX4   wx.lib.agw.aui.auibar.AuiToolBar.SetToolNormalBitmaprI  hKh'KhX   Sets the tool bitmap for the tool identified by `tool_id`.

:param integer `tool_id`: the tool identifier;
:param wx.Bitmap `bitmap`: the new bitmap for the toolbar item.rJ  hhh	h)]rK  (X   tool_idrL  hhrM  X   bitmaprN  hhrO  eh1X*   SetToolNormalBitmap(self, tool_id, bitmap)rP  h3h4h5X   10rQ  h7j  ubh#)rR  }rS  (hX3   wx.lib.agw.aui.auibar.AuiToolBar.SetToolOrientationrT  hKh'KhXx   Sets the tool orientation for the toolbar items.

:param integer `orientation`: the :class:`AuiToolBarItem` orientation.rU  hhh	h)]rV  X   orientationrW  hhrX  ah1X%   SetToolOrientation(self, orientation)rY  h3h4h5X   11rZ  h7j  ubh#)r[  }r\  (hX/   wx.lib.agw.aui.auibar.AuiToolBar.SetToolPackingr]  hKh'KhXv   Sets the value used for spacing tools. The default value is 1 pixel.

:param integer `packing`: the value for packing.r^  hhh	h)]r_  X   packingr`  hhra  ah1X   SetToolPacking(self, packing)rb  h3h4h5j  h7j  ubh#)rc  }rd  (hX2   wx.lib.agw.aui.auibar.AuiToolBar.SetToolProportionre  hKh'KhX   Sets the tool proportion in the toolbar.

:param integer `tool_id`: the :class:`AuiToolBarItem` identifier;
:param integer `proportion`: the tool proportion in the toolbar.rf  hhh	h)]rg  (X   tool_idrh  hhri  X
   proportionrj  hhrk  eh1X,   SetToolProportion(self, tool_id, proportion)rl  h3h4h5X   14rm  h7j  ubh#)rn  }ro  (hX2   wx.lib.agw.aui.auibar.AuiToolBar.SetToolSeparationrp  hKh'KhXd   Sets the separator size for the toolbar.

:param integer `separation`: the separator size in pixels.rq  hhh	h)]rr  X
   separationrs  hhrt  ah1X#   SetToolSeparation(self, separation)ru  h3h4h5X   10rv  h7j  ubh#)rw  }rx  (hX1   wx.lib.agw.aui.auibar.AuiToolBar.SetToolShortHelpry  hKh'KhX   Sets the short help for the given tool.

:param integer `tool_id`: the tool identifier;
:param string `help_string`: the string for the short help.rz  hhh	h)]r{  (X   tool_idr|  hhr}  X   help_stringr~  hhr  eh1X,   SetToolShortHelp(self, tool_id, help_string)r  h3h4h5X   12r  h7j  ubh#)r  }r  (hX.   wx.lib.agw.aui.auibar.AuiToolBar.SetToolStickyr  hKh'KhX   Sets the toolbar item as sticky or non-sticky.

:param integer `tool_id`: the :class:`AuiToolBarItem` identifier;
:param bool `sticky`: whether the tool should be sticky or not.r  hhh	h)]r  (X   tool_idr  hhr  X   stickyr  hhr  eh1X$   SetToolSticky(self, tool_id, sticky)r  h3h4h5X   24r  h7j  ubh#)r  }r  (hX7   wx.lib.agw.aui.auibar.AuiToolBar.SetToolTextOrientationr  hKh'KhX   Sets the label orientation for the toolbar items.

:param integer `orientation`: the :class:`AuiToolBarItem` label orientation.r  hhh	h)]r  X   orientationr  hhr  ah1X)   SetToolTextOrientation(self, orientation)r  h3h4h5X   12r  h7j  ubh#)r  }r  (hX3   wx.lib.agw.aui.auibar.AuiToolBar.SetWindowStyleFlagr  hKh'KhX>  Sets the style of the window.

:param integer `style`: the new window style.

:note: Please note that some styles cannot be changed after the window
 creation and that `Refresh` might need to be be called after changing the
 others for the change to take place immediately.

:note: Overridden from :class:`wx.Control`.r  hhh	h)]r  X   styler  hhr  ah1X   SetWindowStyleFlag(self, style)r  h3h4h5X   15r  h7j  ubh#)r  }r  (hX2   wx.lib.agw.aui.auibar.AuiToolBar.StartPreviewTimerr  hKh'KhXm   Starts a timer in :class:`~wx.lib.agw.aui.framemanager.AuiManager` to slide-in/slide-out the minimized pane. r  hhh	h)]r  h1X   StartPreviewTimer(self)r  h3h4h5X   10r  h7j  ubh#)r  }r  (hX1   wx.lib.agw.aui.auibar.AuiToolBar.StopPreviewTimerr  hKh'KhXl   Stops a timer in :class:`~wx.lib.agw.aui.framemanager.AuiManager` to slide-in/slide-out the minimized pane. r  hhh	h)]r  h1X   StopPreviewTimer(self)r  h3h4h5X   10r  h7j  ubh#)r  }r  (hX+   wx.lib.agw.aui.auibar.AuiToolBar.ToggleToolr  hKh'KhX  Toggles a tool on or off. This does not cause any event to get emitted.

:param integer `tool_id`: tool in question.
:param bool `state`: if ``True``, toggles the tool on, otherwise toggles it off.

:note: This only applies to a tool that has been specified as a toggle tool.r  hhh	h)]r  (X   tool_idr  hhr  X   stater  hhr  eh1X    ToggleTool(self, tool_id, state)r  h3h4h5X   39r  h7j  ubehd]r  (]r  X   objectr  a]r  (]r  X
   simplewrapperr  a]r  (]r  X   wrapperr  a]r  (]r  j  a]r  (]r  j  a]r  (]r  j  a]r  (]r  j  a]r  (]r  j  a]r  ]r  X
   AuiToolBarr  aaeeee]r  j  a]r  (]r  j  a]r  (]r  j  a]r  (]r  j  a]r  (]r  j  a]r  ]r  j  aaeeeeeeeehk]r  hm]r  X
   wx.Controlr  ah1X   AuiToolBar(wx.Control)r  hpj  )r  }r  (j  ]r  (X    wx.lib.agw.aui.auibar.AuiToolBarr  ]r  X
   wx.Controlr  ar  X
   wx.Controlr  ]r  X	   wx.Windowr  ar  X	   wx.Windowr  ]r  X
   wx.WindowBaser  ar  X
   wx.WindowBaser  ]r  X
   wx.EvtHandlerr  ar  X
   wx.EvtHandlerr  ]r  (X	   wx.Objectr  X   wx.Trackabler  er  X	   wx.Objectr  ]r  r  X   wx.Trackabler  ]r  r  ej  ]r  X    wx.lib.agw.aui.auibar.AuiToolBarr  aj  j  ubh'Kh3hqhrXS   /home/wxpy/bb2/dist-src-py37/build/docs/sphinx/wx.lib.agw.aui.auibar.AuiToolBar.txtr  h7jA  h5X   2517r  j  ]r  (X   __init__r   X   AddCheckToolr  X
   AddControlr  X   AddLabelr  X   AddRadioToolr  X   AddSeparatorr  X
   AddSimpleToolr  X	   AddSpacerr  X   AddStretchSpacerr  X
   AddToggleToolr	  X   AddToolr
  X   Clearr  X
   ClearToolsr  X
   DeleteToolr
  X   DeleteToolByPosr  X
   DoGetBestSizer  X   DoIdleUpdater  X	   DoSetSizer  X
   EnableToolr  X   FindControlr  X   FindToolr  X   FindToolByIndexr  X   FindToolByLabelr  X   FindToolForPositionr  X   FindToolForPositionWithPackingr  X   GetAGWWindowStyleFlagr  X   GetArtProviderr  X
   GetAuiManagerr  X   GetGripperVisibler  X   GetLabelSizer  X   GetOverflowRectr  X   GetOverflowStater  X   GetOverflowVisibler   X   GetToolBarFitsr!  X
   GetToolBitmapr"  X   GetToolBitmapSizer#  X   GetToolBorderPaddingr$  X   GetToolCountr%  X   GetToolDropDownr&  X   GetToolEnabledr'  X   GetToolFitsr(  X   GetToolFitsByIndexr)  X   GetToolIndexr*  X   GetToolLabelr+  X   GetToolLongHelpr,  X   GetToolOrientationr-  X   GetToolPackingr.  X
   GetToolPosr/  X   GetToolProportionr0  X   GetToolRectr1  X   GetToolSeparationr2  X   GetToolShortHelpr3  X
   GetToolStickyr4  X   GetToolTextOrientationr5  X   GetToolToggledr6  X   HitTestr7  X   IsPaneMinimizedr8  X   OnCustomRenderr9  X   OnEraseBackgroundr:  X   OnIdler;  X
   OnLeaveWindowr<  X
   OnLeftDownr=  X   OnLeftUpr>  X   OnMiddleDownr?  X
   OnMiddleUpr@  X   OnMotionrA  X   OnPaintrB  X   OnRightDownrC  X	   OnRightUprD  X   OnSetCursorrE  X   OnSizerF  X   RealizerG  X   RefreshOverflowStaterH  X   SetAGWWindowStyleFlagrI  X   SetArtProviderrJ  X
   SetAuiManagerrK  X   SetCustomOverflowItemsrL  X   SetFontrM  X   SetGripperVisiblerN  X   SetHoverItemrO  X
   SetMarginsrP  X   SetMarginsSizerQ  X   SetMarginsXYrR  X   SetOrientationrS  X   SetOverflowVisiblerT  X   SetPressedItemrU  X   SetToolAlignmentrV  X
   SetToolBitmaprW  X   SetToolBitmapSizerX  X   SetToolBorderPaddingrY  X   SetToolDisabledBitmaprZ  X   SetToolDropDownr[  X   SetToolLabelr\  X   SetToolLongHelpr]  X   SetToolNormalBitmapr^  X   SetToolOrientationr_  X   SetToolPackingr`  X   SetToolProportionra  X   SetToolSeparationrb  X   SetToolShortHelprc  X
   SetToolStickyrd  X   SetToolTextOrientationre  X   SetWindowStyleFlagrf  X   StartPreviewTimerrg  X   StopPreviewTimerrh  X
   ToggleToolri  ej  j  ubh)rj  }rk  (hX%   wx.lib.agw.aui.auibar.AuiToolBarEventrl  hKhXJ   A specialized command event class for events sent by :class:`AuiToolBar`. rm  hhh	h
]rn  (h#)ro  }rp  (hX.   wx.lib.agw.aui.auibar.AuiToolBarEvent.__init__rq  hKh'KhX   Default class constructor.

:param `command_type`: the event kind or an instance of :class:`PyCommandEvent`.
:param integer `win_id`: the window identification number.rr  hhh	h)]rs  (X   command_typert  X   Noneru  X   Nonerv  rw  X   win_idrx  j  X   0ry  rz  eh1X+   __init__(self, command_type=None, win_id=0)r{  h3h4h5X   15r|  h7jj  ubh#)r}  }r~  (hX+   wx.lib.agw.aui.auibar.AuiToolBarEvent.Allowr  hKh'KhX  This is the opposite of :meth:`Veto`: it explicitly allows the event to be
processed. For most events it is not necessary to call this method as the
events are allowed anyhow but some are forbidden by default (this will
be mentioned in the corresponding event description).r  hhh	h)]r  h1X   Allow(self)r  h3h4h5X   10r  h7jj  ubh#)r  }r  (hX4   wx.lib.agw.aui.auibar.AuiToolBarEvent.GetNotifyEventr  hKh'KhX)   Returns the actual :class:`NotifyEvent`. r  hhh	h)]r  h1X   GetNotifyEvent(self)r  h3h4h5hIh7jj  ubh#)r  }r  (hX/   wx.lib.agw.aui.auibar.AuiToolBarEvent.IsAllowedr  hKh'KhX-   Returns whether the event is allowed or not. r  hhh	h)]r  h1X   IsAllowed(self)r  h3h4h5hIh7jj  ubh#)r  }r  (hX*   wx.lib.agw.aui.auibar.AuiToolBarEvent.Vetor  hKh'KhX  Prevents the change announced by this event from happening.

It is in general a good idea to notify the user about the reasons for
vetoing the change because otherwise the applications behaviour (which
just refuses to do what the user wants) might be quite surprising.r  hhh	h)]r  h1X
   Veto(self)r  h3h4h5X   11r  h7jj  ubehd]r  (]r  X   objectr  a]r  (]r  X
   simplewrapperr  a]r  (]r  X   wrapperr  a]r  (]r  j  a]r  (]r  X   Eventr  a]r  (]r  X   CommandEventr  a]r  (]r  X   PyCommandEventr  a]r  (]r  X   CommandToolBarEventr  a]r  ]r  X   AuiToolBarEventr  aaeeeeeeeehk]r  hm]r  X)   wx.lib.agw.aui.auibar.CommandToolBarEventr  ah1X$   AuiToolBarEvent(CommandToolBarEvent)r  hpj  )r  }r  (j  ]r  (X%   wx.lib.agw.aui.auibar.AuiToolBarEventr  ]r  X)   wx.lib.agw.aui.auibar.CommandToolBarEventr  ar  X)   wx.lib.agw.aui.auibar.CommandToolBarEventr  ]r  X   wx.PyCommandEventr  ar  X   wx.PyCommandEventr  ]r  X   wx.CommandEventr  ar  X   wx.CommandEventr  ]r  X   wx.Eventr  ar  X   wx.Eventr  ]r  X	   wx.Objectr  ar  X	   wx.Objectr  ]r  r  ej  ]r  X%   wx.lib.agw.aui.auibar.AuiToolBarEventr  aj  jj  ubh'Kh3hqhrXX   /home/wxpy/bb2/dist-src-py37/build/docs/sphinx/wx.lib.agw.aui.auibar.AuiToolBarEvent.txtr  h7jA  h5X   53r  j  ]r  (X   __init__r  X   Allowr  X   GetNotifyEventr  X	   IsAllowedr  X   Vetor  ej  j  ubh)r  }r  (hX$   wx.lib.agw.aui.auibar.AuiToolBarItemr  hKhX  AuiToolBarItem is a toolbar element.

It has a unique id (except for the separators which always have id = -1), the
style (telling whether it is a normal button, separator or a control), the
state (toggled or not, enabled or not) and short and long help strings. The
default implementations use the short help string for the tooltip text which
is popped up when the mouse pointer enters the tool and the long help string
for the applications status bar.r  hhh	h
]r  (h#)r  }r  (hX-   wx.lib.agw.aui.auibar.AuiToolBarItem.__init__r  hKh'KhXW   Default class constructor.

:param `item`: another instance of :class:`AuiToolBarItem`.r  hhh	h)]r  X   itemr  X   Noner  X   Noner  r  ah1X   __init__(self, item=None)r  h3h4h5X   38r  h7j  ubh#)r  }r  (hX+   wx.lib.agw.aui.auibar.AuiToolBarItem.Assignr  hKh'KhX~   Assigns the properties of the :class:`AuiToolBarItem` `c` to `self`.

:param `c`: another instance of :class:`AuiToolBarItem`.r  hhh	h)]r  j  hhr  ah1X   Assign(self, c)r  h3h4h5X   29r  h7j  ubh#)r  }r  (hX1   wx.lib.agw.aui.auibar.AuiToolBarItem.GetAlignmentr  hKh'KhX$   Returns the toolbar item alignment. r  hhh	h)]r  h1X   GetAlignment(self)r  h3h4h5hIh7j  ubh#)r  }r  (hX.   wx.lib.agw.aui.auibar.AuiToolBarItem.GetBitmapr  hKh'KhX!   Returns the toolbar item bitmap. r  hhh	h)]r  h1X   GetBitmap(self)r  h3h4h5hIh7j  ubh#)r  }r  (hX6   wx.lib.agw.aui.auibar.AuiToolBarItem.GetDisabledBitmapr  hKh'KhX*   Returns the toolbar item disabled bitmap. r   hhh	h)]r  h1X   GetDisabledBitmap(self)r  h3h4h5hIh7j  ubh#)r  }r  (hX3   wx.lib.agw.aui.auibar.AuiToolBarItem.GetHoverBitmapr  hKh'KhX'   Returns the toolbar item hover bitmap. r  hhh	h)]r  h1X   GetHoverBitmap(self)r  h3h4h5hIh7j  ubh#)r	  }r
  (hX*   wx.lib.agw.aui.auibar.AuiToolBarItem.GetIdr  hKh'KhX%   Returns the toolbar item identifier. r  hhh	h)]r
  h1X   GetId(self)r  h3h4h5hIh7j  ubh#)r  }r  (hX,   wx.lib.agw.aui.auibar.AuiToolBarItem.GetKindr  hKh'KhXE   Returns the toolbar item kind.

See :meth:`SetKind` for more details.r  hhh	h)]r  h1X
   GetKind(self)r  h3h4h5j  h7j  ubh#)r  }r  (hX-   wx.lib.agw.aui.auibar.AuiToolBarItem.GetLabelr  hKh'KhX    Returns the toolbar item label. r  hhh	h)]r  h1X   GetLabel(self)r  h3h4h5hIh7j  ubh#)r  }r  (hX0   wx.lib.agw.aui.auibar.AuiToolBarItem.GetLongHelpr  hKh'KhX>   Returns the long help string for the :class:`AuiToolBarItem`. r  hhh	h)]r  h1X   GetLongHelp(self)r   h3h4h5hIh7j  ubh#)r!  }r"  (hX/   wx.lib.agw.aui.auibar.AuiToolBarItem.GetMinSizer#  hKh'KhX'   Returns the toolbar item minimum size. r$  hhh	h)]r%  h1X   GetMinSize(self)r&  h3h4h5hIh7j  ubh#)r'  }r(  (hX3   wx.lib.agw.aui.auibar.AuiToolBarItem.GetOrientationr)  hKh'KhX&   Returns the toolbar tool orientation. r*  hhh	h)]r+  h1X   GetOrientation(self)r,  h3h4h5hIh7j  ubh#)r-  }r.  (hX2   wx.lib.agw.aui.auibar.AuiToolBarItem.GetProportionr/  hKh'KhX?   Returns the :class:`AuiToolBarItem` proportion in the toolbar. r0  hhh	h)]r1  h1X   GetProportion(self)r2  h3h4h5hIh7j  ubh#)r3  }r4  (hX5   wx.lib.agw.aui.auibar.AuiToolBarItem.GetRotatedBitmapr5  hKh'KhX   Returns the correct bitmap depending on the tool orientation.

:param bool `disabled`: whether to return the disabled bitmap or not.r6  hhh	h)]r7  X   disabledr8  hhr9  ah1X    GetRotatedBitmap(self, disabled)r:  h3h4h5X   25r;  h7j  ubh#)r<  }r=  (hX1   wx.lib.agw.aui.auibar.AuiToolBarItem.GetShortHelpr>  hKh'KhX?   Returns the short help string for the :class:`AuiToolBarItem`. r?  hhh	h)]r@  h1X   GetShortHelp(self)rA  h3h4h5hIh7j  ubh#)rB  }rC  (hX1   wx.lib.agw.aui.auibar.AuiToolBarItem.GetSizerItemrD  hKh'KhX#   Returns the associated sizer item. rE  hhh	h)]rF  h1X   GetSizerItem(self)rG  h3h4h5hIh7j  ubh#)rH  }rI  (hX4   wx.lib.agw.aui.auibar.AuiToolBarItem.GetSpacerPixelsrJ  hKh'KhXP   Returns the number of pixels for a toolbar item with kind = ``ITEM_SEPARATOR``. rK  hhh	h)]rL  h1X   GetSpacerPixels(self)rM  h3h4h5hIh7j  ubh#)rN  }rO  (hX-   wx.lib.agw.aui.auibar.AuiToolBarItem.GetStaterP  hKh'KhXI   Returns the toolbar item state.

:see: :meth:`SetState` for more details.rQ  hhh	h)]rR  h1X   GetState(self)rS  h3h4h5j  h7j  ubh#)rT  }rU  (hX0   wx.lib.agw.aui.auibar.AuiToolBarItem.GetUserDatarV  hKh'KhX"   Returns the associated user data. rW  hhh	h)]rX  h1X   GetUserData(self)rY  h3h4h5hIh7j  ubh#)rZ  }r[  (hX.   wx.lib.agw.aui.auibar.AuiToolBarItem.GetWindowr\  hKh'KhX/   Returns window associated to the toolbar item. r]  hhh	h)]r^  h1X   GetWindow(self)r_  h3h4h5hIh7j  ubh#)r`  }ra  (hX0   wx.lib.agw.aui.auibar.AuiToolBarItem.HasDropDownrb  hKh'KhXI   Returns whether the toolbar item has an associated dropdown menu or not. rc  hhh	h)]rd  h1X   HasDropDown(self)re  h3h4h5hIh7j  ubh#)rf  }rg  (hX-   wx.lib.agw.aui.auibar.AuiToolBarItem.IsActiverh  hKh'KhX3   Returns whether the toolbar item is active or not. ri  hhh	h)]rj  h1X   IsActive(self)rk  h3h4h5hIh7j  ubh#)rl  }rm  (hX-   wx.lib.agw.aui.auibar.AuiToolBarItem.IsStickyrn  hKh'KhX@   Returns whether the toolbar item has a sticky behaviour or not. ro  hhh	h)]rp  h1X   IsSticky(self)rq  h3h4h5hIh7j  ubh#)rr  }rs  (hX.   wx.lib.agw.aui.auibar.AuiToolBarItem.SetActivert  hKh'KhXt   Activates/deactivates the toolbar item.

:param bool `b`: ``True`` to activate the item, ``False`` to deactivate it.ru  hhh	h)]rv  j  hhrw  ah1X   SetActive(self, b)rx  h3h4h5j  h7j  ubh#)ry  }rz  (hX1   wx.lib.agw.aui.auibar.AuiToolBarItem.SetAlignmentr{  hKh'KhX   Sets the toolbar item alignment.

:param integer `align`: the item alignment, which can be one of the available :class:`wx.Sizer`
 alignments.r|  hhh	h)]r}  X   alignr~  hhr  ah1X   SetAlignment(self, align)r  h3h4h5X   10r  h7j  ubh#)r  }r  (hX.   wx.lib.agw.aui.auibar.AuiToolBarItem.SetBitmapr  hKh'KhXn   Sets the toolbar item bitmap.

:param wx.Bitmap `bmp`: the image associated with this :class:`AuiToolBarItem`.r  hhh	h)]r  X   bmpr  hhr  ah1X   SetBitmap(self, bmp)r  h3h4h5j  h7j  ubh#)r  }r  (hX6   wx.lib.agw.aui.auibar.AuiToolBarItem.SetDisabledBitmapr  hKh'KhX   Sets the toolbar item disabled bitmap.

:param wx.Bitmap `bmp`: the disabled image associated with this :class:`AuiToolBarItem`.r  hhh	h)]r  X   bmpr  hhr  ah1X   SetDisabledBitmap(self, bmp)r  h3h4h5j  h7j  ubh#)r  }r  (hX3   wx.lib.agw.aui.auibar.AuiToolBarItem.SetHasDropDownr  hKh'KhX   Sets whether the toolbar item has an associated dropdown menu.

:param bool `b`: ``True`` to set a dropdown menu, ``False`` otherwise.r  hhh	h)]r  j  hhr  ah1X   SetHasDropDown(self, b)r  h3h4h5j  h7j  ubh#)r  }r  (hX3   wx.lib.agw.aui.auibar.AuiToolBarItem.SetHoverBitmapr  hKh'KhXz   Sets the toolbar item hover bitmap.

:param wx.Bitmap `bmp`: the hover image associated with this :class:`AuiToolBarItem`.r  hhh	h)]r  X   bmpr  hhr  ah1X   SetHoverBitmap(self, bmp)r  h3h4h5j  h7j  ubh#)r  }r  (hX*   wx.lib.agw.aui.auibar.AuiToolBarItem.SetIdr  hKh'KhXL   Sets the toolbar item identifier.

:param integer `new_id`: the new tool id.r  hhh	h)]r  X   new_idr  hhr  ah1X   SetId(self, new_id)r  h3h4h5j  h7j  ubh#)r  }r  (hX,   wx.lib.agw.aui.auibar.AuiToolBarItem.SetKindr  hKh'KhXt  Sets the :class:`AuiToolBarItem` kind.

:param integer `new_kind`: can be one of the following items:

 ========================  =============================
 Item Kind                 Description
 ========================  =============================
 ``ITEM_CONTROL``          The item in the :class:`AuiToolBar` is a control
 ``ITEM_LABEL``            The item in the :class:`AuiToolBar` is a text label
 ``ITEM_SPACER``           The item in the :class:`AuiToolBar` is a spacer
 ``ITEM_SEPARATOR``        The item in the :class:`AuiToolBar` is a separator
 ``ITEM_CHECK``            The item in the :class:`AuiToolBar` is a toolbar check item
 ``ITEM_NORMAL``           The item in the :class:`AuiToolBar` is a standard toolbar item
 ``ITEM_RADIO``            The item in the :class:`AuiToolBar` is a toolbar radio item
 ========================  =============================r  hhh	h)]r  X   new_kindr  hhr  ah1X   SetKind(self, new_kind)r  h3h4h5X   21r  h7j  ubh#)r  }r  (hX-   wx.lib.agw.aui.auibar.AuiToolBarItem.SetLabelr  hKh'KhXH   Sets the toolbar item label.

:param string `s`: the toolbar item label.r  hhh	h)]r  X   sr  hhr  ah1X   SetLabel(self, s)r  h3h4h5j  h7j  ubh#)r  }r  (hX0   wx.lib.agw.aui.auibar.AuiToolBarItem.SetLongHelpr  hKh'KhX   Sets the long help string for the toolbar item. This string is shown in the
statusbar (if any) of the parent frame when the mouse pointer is inside the
tool.

:param string `s`: the tool long help string.r  hhh	h)]r  j  hhr  ah1X   SetLongHelp(self, s)r  h3h4h5X   11r  h7j  ubh#)r  }r  (hX/   wx.lib.agw.aui.auibar.AuiToolBarItem.SetMinSizer  hKh'KhXW   Sets the toolbar item minimum size.

:param wx.Size `s`: the toolbar item minimum size.r  hhh	h)]r  j  hhr  ah1X   SetMinSize(self, s)r  h3h4h5j  h7j  ubh#)r  }r  (hX3   wx.lib.agw.aui.auibar.AuiToolBarItem.SetOrientationr  hKh'KhX   Sets the toolbar tool orientation.

:param integer `a`: one of ``AUI_TBTOOL_HORIZONTAL``, ``AUI_TBTOOL_VERT_CLOCKWISE`` or
 ``AUI_TBTOOL_VERT_COUNTERCLOCKWISE``.r  hhh	h)]r  j  hhr  ah1X   SetOrientation(self, a)r  h3h4h5X   10r  h7j  ubh#)r  }r  (hX2   wx.lib.agw.aui.auibar.AuiToolBarItem.SetProportionr  hKh'KhXe   Sets the :class:`AuiToolBarItem` proportion in the toolbar.

:param integer `p`: the item proportion.r  hhh	h)]r  X   pr  hhr  ah1X   SetProportion(self, p)r  h3h4h5j  h7j  ubh#)r  }r  (hX1   wx.lib.agw.aui.auibar.AuiToolBarItem.SetShortHelpr  hKh'KhX   Sets the short help string for the :class:`AuiToolBarItem`, to be displayed in a
:class:`ToolTip` when the mouse hover over the toolbar item.

:param string `s`: the tool short help string.r  hhh	h)]r  j  hhr  ah1X   SetShortHelp(self, s)r  h3h4h5X   10r  h7j  ubh#)r  }r  (hX1   wx.lib.agw.aui.auibar.AuiToolBarItem.SetSizerItemr  hKh'KhX`   Associates a sizer item to this toolbar item.

:param `s`: an instance of :class:`wx.SizerItem`.r  hhh	h)]r  j  hhr  ah1X   SetSizerItem(self, s)r  h3h4h5j  h7j  ubh#)r  }r  (hX4   wx.lib.agw.aui.auibar.AuiToolBarItem.SetSpacerPixelsr  hKh'KhXs   Sets the number of pixels for a toolbar item with kind = ``ITEM_SEPARATOR``.

:param integer `s`: number of pixels.r  hhh	h)]r  j  hhr  ah1X   SetSpacerPixels(self, s)r  h3h4h5j  h7j  ubh#)r  }r  (hX-   wx.lib.agw.aui.auibar.AuiToolBarItem.SetStater  hKh'KhX*  Sets the toolbar item state.

:param `new_state`: can be one of the following states:

 ============================================  ======================================
 Button State Constant                         Description
 ============================================  ======================================
 ``AUI_BUTTON_STATE_NORMAL``                   Normal button state
 ``AUI_BUTTON_STATE_HOVER``                    Hovered button state
 ``AUI_BUTTON_STATE_PRESSED``                  Pressed button state
 ``AUI_BUTTON_STATE_DISABLED``                 Disabled button state
 ``AUI_BUTTON_STATE_HIDDEN``                   Hidden button state
 ``AUI_BUTTON_STATE_CHECKED``                  Checked button state
 ============================================  ======================================r  hhh	h)]r  X	   new_stater  hhr  ah1X   SetState(self, new_state)r  h3h4h5X   21r  h7j  ubh#)r  }r  (hX.   wx.lib.agw.aui.auibar.AuiToolBarItem.SetStickyr  hKh'KhX   Sets whether the toolbar item is sticky (permanent highlight after mouse enter)
or not.

:param bool `b`: ``True`` to set the item as sticky, ``False`` otherwise.r  hhh	h)]r  j  hhr  ah1X   SetSticky(self, b)r  h3h4h5X   10r  h7j  ubh#)r   }r  (hX0   wx.lib.agw.aui.auibar.AuiToolBarItem.SetUserDatar  hKh'KhX   Associates some kind of user data to the toolbar item.

:param PyObject `data`: a Python object.

:note: The user data can be any Python object.r  hhh	h)]r  X   datar  hhr  ah1X   SetUserData(self, data)r  h3h4h5X   11r  h7j  ubh#)r	  }r
  (hX.   wx.lib.agw.aui.auibar.AuiToolBarItem.SetWindowr  hKh'KhXv   Assigns a window to the toolbar item.

:param wx.Window `w`: associate this window `w` to the :class:`AuiToolBarItem`.r  hhh	h)]r
  j  hhr  ah1X   SetWindow(self, w)r  h3h4h5j  h7j  ubehd]r  (]r  X   objectr  a]r  ]r  X   AuiToolBarItemr  aaehk]r  hm]r  h1X   AuiToolBarItem(object)r  hpj  )r  }r  (j  ]r  X$   wx.lib.agw.aui.auibar.AuiToolBarItemr  ]r  r  aj  ]r  X$   wx.lib.agw.aui.auibar.AuiToolBarItemr   aj  j  ubh'Kh3hqhrXW   /home/wxpy/bb2/dist-src-py37/build/docs/sphinx/wx.lib.agw.aui.auibar.AuiToolBarItem.txtr!  h7jA  h5X   466r"  j  ]r#  (X   __init__r$  X   Assignr%  X   GetAlignmentr&  X	   GetBitmapr'  X   GetDisabledBitmapr(  X   GetHoverBitmapr)  X   GetIdr*  X   GetKindr+  X   GetLabelr,  X   GetLongHelpr-  X
   GetMinSizer.  X   GetOrientationr/  X
   GetProportionr0  X   GetRotatedBitmapr1  X   GetShortHelpr2  X   GetSizerItemr3  X   GetSpacerPixelsr4  X   GetStater5  X   GetUserDatar6  X	   GetWindowr7  X   HasDropDownr8  X   IsActiver9  X   IsStickyr:  X	   SetActiver;  X   SetAlignmentr<  X	   SetBitmapr=  X   SetDisabledBitmapr>  X   SetHasDropDownr?  X   SetHoverBitmapr@  X   SetIdrA  X   SetKindrB  X   SetLabelrC  X   SetLongHelprD  X
   SetMinSizerE  X   SetOrientationrF  X
   SetProportionrG  X   SetShortHelprH  X   SetSizerItemrI  X   SetSpacerPixelsrJ  X   SetStaterK  X	   SetStickyrL  X   SetUserDatarM  X	   SetWindowrN  ej  j  ubh)rO  }rP  (hX)   wx.lib.agw.aui.auibar.CommandToolBarEventrQ  hKhXJ   A specialized command event class for events sent by :class:`AuiToolBar`. rR  hhh	h
]rS  (h#)rT  }rU  (hX2   wx.lib.agw.aui.auibar.CommandToolBarEvent.__init__rV  hKh'KhX   Default class constructor.

:param `command_type`: the event kind or an instance of :class:`PyCommandEvent`.
:param integer `win_id`: the window identification number.rW  hhh	h)]rX  (X   command_typerY  hhrZ  X   win_idr[  hhr\  eh1X$   __init__(self, command_type, win_id)r]  h3h4h5X   18r^  h7jO  ubh#)r_  }r`  (hX7   wx.lib.agw.aui.auibar.CommandToolBarEvent.GetClickPointra  hKh'KhX9   Returns the point where the user clicked with the mouse. rb  hhh	h)]rc  h1X   GetClickPoint(self)rd  h3h4h5hIh7jO  ubh#)re  }rf  (hX5   wx.lib.agw.aui.auibar.CommandToolBarEvent.GetItemRectrg  hKh'KhX/   Returns the :class:`AuiToolBarItem` rectangle. rh  hhh	h)]ri  h1X   GetItemRect(self)rj  h3h4h5hIh7jO  ubh#)rk  }rl  (hX3   wx.lib.agw.aui.auibar.CommandToolBarEvent.GetToolIdrm  hKh'KhX0   Returns the :class:`AuiToolBarItem` identifier. rn  hhh	h)]ro  h1X   GetToolId(self)rp  h3h4h5hIh7jO  ubh#)rq  }rr  (hX;   wx.lib.agw.aui.auibar.CommandToolBarEvent.IsDropDownClickedrs  hKh'KhX5   Returns whether the drop down menu has been clicked. rt  hhh	h)]ru  h1X   IsDropDownClicked(self)rv  h3h4h5hIh7jO  ubh#)rw  }rx  (hX7   wx.lib.agw.aui.auibar.CommandToolBarEvent.SetClickPointry  hKh'KhXO   Sets the clicking point.

:param wx.Point `p`: the location of the mouse click.rz  hhh	h)]r{  j  hhr|  ah1X   SetClickPoint(self, p)r}  h3h4h5j  h7jO  ubh#)r~  }r  (hX<   wx.lib.agw.aui.auibar.CommandToolBarEvent.SetDropDownClickedr  hKh'KhX   Sets whether the drop down menu has been clicked.

:param bool `c`: ``True`` to set the drop down as clicked, ``False`` otherwise.r  hhh	h)]r  j  hhr  ah1X   SetDropDownClicked(self, c)r  h3h4h5j  h7jO  ubh#)r  }r  (hX5   wx.lib.agw.aui.auibar.CommandToolBarEvent.SetItemRectr  hKh'KhX\   Sets the :class:`AuiToolBarItem` rectangle.

:param wx.Rect `r`: the toolbar item rectangle.r  hhh	h)]r  X   rr  hhr  ah1X   SetItemRect(self, r)r  h3h4h5j  h7jO  ubh#)r  }r  (hX3   wx.lib.agw.aui.auibar.CommandToolBarEvent.SetToolIdr  hKh'KhX_   Sets the :class:`AuiToolBarItem` identifier.

:param integer `id`: the toolbar item identifier.r  hhh	h)]r  X   idr  hhr  ah1X   SetToolId(self, id)r  h3h4h5j  h7jO  ubehd]r  (]r  X   objectr  a]r  (]r  X
   simplewrapperr  a]r  (]r  X   wrapperr  a]r  (]r  j  a]r  (]r  j  a]r  (]r  j  a]r  (]r  j  a]r  ]r  j  aaeeeeeeehk]r  X%   wx.lib.agw.aui.auibar.AuiToolBarEventr  ahm]r  X   wx.PyCommandEventr  ah1X&   CommandToolBarEvent(wx.PyCommandEvent)r  hpj  )r  }r  (j  ]r  (X)   wx.lib.agw.aui.auibar.CommandToolBarEventr  ]r  X   wx.PyCommandEventr  ar  X   wx.PyCommandEventr  ]r  X   wx.CommandEventr  ar  X   wx.CommandEventr  ]r  X   wx.Eventr  ar  X   wx.Eventr  ]r  X	   wx.Objectr  ar  X	   wx.Objectr  ]r  r  ej  ]r  X)   wx.lib.agw.aui.auibar.CommandToolBarEventr  aj  jO  ubh'Kh3hqhrX\   /home/wxpy/bb2/dist-src-py37/build/docs/sphinx/wx.lib.agw.aui.auibar.CommandToolBarEvent.txtr  h7jA  h5X   85r  j  ]r  (X   __init__r  X
   GetClickPointr  X   GetItemRectr  X	   GetToolIdr  X   IsDropDownClickedr  X
   SetClickPointr  X   SetDropDownClickedr  X   SetItemRectr  X	   SetToolIdr  ej  j  ubh)r  }r  (hX%   wx.lib.agw.aui.auibar.PyEmbeddedImager  hKhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.r  hhh	h
]r  (h#)r  }r  (hX.   wx.lib.agw.aui.auibar.PyEmbeddedImage.__init__r  hKh'KhX>   Initialize self.  See help(type(self)) for accurate signature.r  hhh	h)]r  (X   datar  hhr  X   isBase64r  X   Truer  h/r  eh1X#   __init__(self, data, isBase64=True)r  h3h4h5h6h7j  ubh#)r  }r  (hX/   wx.lib.agw.aui.auibar.PyEmbeddedImage.GetBitmapr  hKh'Khhhhh	h)]r  h1X   GetBitmap(self)r  h3h4h5h=h7j  ubh#)r  }r  (hX-   wx.lib.agw.aui.auibar.PyEmbeddedImage.GetDatar  hKh'Khhhhh	h)]r  h1X
   GetData(self)r  h3h4h5hCh7j  ubh#)r  }r  (hX-   wx.lib.agw.aui.auibar.PyEmbeddedImage.GetIconr  hKh'Khhhhh	h)]r  h1X
   GetIcon(self)r  h3h4h5hIh7j  ubh#)r  }r  (hX.   wx.lib.agw.aui.auibar.PyEmbeddedImage.GetImager  hKh'Khhhhh	h)]r  h1X   GetImage(self)r  h3h4h5h6h7j  ubhO)r  }r  (hX,   wx.lib.agw.aui.auibar.PyEmbeddedImage.Bitmapr  hKh'Khhhhh	hShThUhhVhh3hWh7j  ubhO)r  }r  (hX*   wx.lib.agw.aui.auibar.PyEmbeddedImage.Datar  hKh'Khhhhh	hSh[hUhhVhh3hWh7j  ubhO)r  }r  (hX*   wx.lib.agw.aui.auibar.PyEmbeddedImage.Iconr  hKh'Khhhhh	hSh_hUhhVhh3hWh7j  ubhO)r  }r  (hX+   wx.lib.agw.aui.auibar.PyEmbeddedImage.Imager   hKh'Khhhhh	hShchUhhVhh3hWh7j  ubehd]r  (]r  X   objectr  a]r  ]r  hjaaehk]r  hm]r  h1X   PyEmbeddedImage(object)r  hpNh'Kh3hqhrXX   /home/wxpy/bb2/dist-src-py37/build/docs/sphinx/wx.lib.agw.aui.auibar.PyEmbeddedImage.txtr	  h7jA  h5X   52r
  ubh)r  }r  (hX+   wx.lib.agw.aui.auibar.ToolbarCommandCapturer
  hKhX,   A class to handle the dropdown window menu. r  hhh	h
]r  (h#)r  }r  (hX4   wx.lib.agw.aui.auibar.ToolbarCommandCapture.__init__r  hKh'KhX   Default class constructor. r  hhh	h)]r  h1X   __init__(self)r  h3h4h5hCh7j  ubh#)r  }r  (hX8   wx.lib.agw.aui.auibar.ToolbarCommandCapture.GetCommandIdr  hKh'KhX&   Returns the event command identifier. r  hhh	h)]r  h1X   GetCommandId(self)r  h3h4h5hIh7j  ubh#)r  }r  (hX8   wx.lib.agw.aui.auibar.ToolbarCommandCapture.ProcessEventr  hKh'KhX  Processes an event, searching event tables and calling zero or more suitable
event handler function(s).

:param `event`: the event to process.

:note: Normally, your application would not call this function: it is called
 in the wxPython implementation to dispatch incoming user interface events
 to the framework (and application).
 However, you might need to call it if implementing new functionality (such as
 a new control) where you define new event types, as opposed to allowing the
 user to override functions.

 An instance where you might actually override the :meth:`ProcessEvent` function is where
 you want to direct event processing to event handlers not normally noticed by
 wxPython. For example, in the document/view architecture, documents and views
 are potential event handlers. When an event reaches a frame, :meth:`ProcessEvent` will
 need to be called on the associated document and view in case event handler
 functions are associated with these objects.

 The normal order of event table searching is as follows:

 1. If the object is disabled (via a call to :meth:`~EvtHandler.SetEvtHandlerEnabled`) the function
    skips to step (6).
 2. If the object is a :class:`wx.Window`, :meth:`ProcessEvent` is recursively called on the window's
    :class:`wx.Validator`. If this returns ``True``, the function exits.
 3. wxWidgets `SearchEventTable` is called for this event handler. If this fails, the
    base class table is tried, and so on until no more tables exist or an appropriate
    function was found, in which case the function exits.
 4. The search is applied down the entire chain of event handlers (usually the chain
    has a length of one). If this succeeds, the function exits.
 5. If the object is a :class:`wx.Window` and the event is a :class:`CommandEvent`, :meth:`ProcessEvent` is
    recursively applied to the parent window's event handler. If this returns ``True``,
    the function exits.
 6. Finally, :meth:`ProcessEvent` is called on the :class:`App` object.r  hhh	h)]r   X   eventr!  hhr"  ah1X   ProcessEvent(self, event)r#  h3h4h5X   47r$  h7j  ubehd]r%  (]r&  X   objectr'  a]r(  (]r)  X
   simplewrapperr*  a]r+  (]r,  X   wrapperr-  a]r.  (]r/  j  a]r0  (]r1  j  a]r2  ]r3  X   ToolbarCommandCapturer4  aae]r5  j  a]r6  (]r7  j  a]r8  ]r9  j4  aaeeeeehk]r:  hm]r;  X
   wx.EvtHandlerr<  ah1X$   ToolbarCommandCapture(wx.EvtHandler)r=  hpj  )r>  }r?  (j  ]r@  (X+   wx.lib.agw.aui.auibar.ToolbarCommandCapturerA  ]rB  X
   wx.EvtHandlerrC  arD  X
   wx.EvtHandlerrE  ]rF  (X	   wx.ObjectrG  X   wx.TrackablerH  erI  X	   wx.ObjectrJ  ]rK  rL  X   wx.TrackablerM  ]rN  rO  ej  ]rP  X+   wx.lib.agw.aui.auibar.ToolbarCommandCapturerQ  aj  j  ubh'Kh3hqhrX^   /home/wxpy/bb2/dist-src-py37/build/docs/sphinx/wx.lib.agw.aui.auibar.ToolbarCommandCapture.txtrR  h7jA  h5X   63rS  j  ]rT  (X   __init__rU  X   GetCommandIdrV  X   ProcessEventrW  ej  j;  ubh#)rX  }rY  (hX$   wx.lib.agw.aui.auibar.BitmapFromBitsrZ  hKh'KhX)  A utility function that creates a masked bitmap from raw bits (XBM format).

:param string `bits`: the raw bits of the bitmap;
:param integer `w`: the bitmap width;
:param integer `h`: the bitmap height;
:param wx.Colour `colour`: the colour which will replace all white pixels in the
 raw bitmap.r[  hhh	h)]r\  (X   bitsr]  hhr^  j  hhr_  j  hhr`  X   colourra  hhrb  eh1X"   BitmapFromBits(bits, w, h, colour)rc  h3h4h5X   17rd  j
  X   147re  h7jA  ubh#)rf  }rg  (hX#   wx.lib.agw.aui.auibar.GetBaseColourrh  hKh'KhXv   Returns the face shading colour on push buttons/backgrounds,
mimicking as closely as possible the platform UI colours.ri  hhh	h)]rj  h1X   GetBaseColour()rk  h3h4h5X   29rl  j
  X   180rm  h7jA  ubh#)rn  }ro  (hX"   wx.lib.agw.aui.auibar.GetLabelSizerp  hKh'KhX   Returns the :class:`~wx.lib.agw.aui.auibar.AuiToolBar` item label size.

:param string `label`: the toolbar tool label;
:param bool `vertical`: whether the toolbar tool orientation is vertical or not.rq  hhh	h)]rr  (X   dcrs  hhrt  X   labelru  hhrv  X   verticalrw  hhrx  eh1X!   GetLabelSize(dc, label, vertical)ry  h3h4h5X   23rz  j
  X   375r{  h7jA  ubh#)r|  }r}  (hX(   wx.lib.agw.aui.auibar.MakeDisabledBitmapr~  hKh'KhX   Convert the given image (in place) to a grayed-out version, appropriate for a 'disabled' appearance.

:param wx.Bitmap `bitmap`: the bitmap to gray-out.r  hhh	h)]r  X   bitmapr  hhr  ah1X   MakeDisabledBitmap(bitmap)r  h3h4h5j  j
  X   210r  h7jA  ubh#)r  }r  (hX    wx.lib.agw.aui.auibar.StepColourr  hKh'KhX   Darken/lighten the input colour `c`.

:param wx.Colour `c`: a colour to darken/lighten;
:param integer `ialpha`: a transparency value.r  hhh	h)]r  (j  hhr  X   ialphar  hhr  eh1X   StepColour(c, ialpha)r  h3h4h5X   38r  j
  X   58r  h7jA  ubhu)r  }r  (hX    wx.lib.agw.aui.auibar.__author__r  hKh'KhX  str(object='') -> str
str(bytes_or_buffer[, encoding[, errors]]) -> str

Create a new string object from the given object. If encoding or
errors is specified, then the object must expose a data buffer
that will be decoded using the given encoding and error handler.
Otherwise, returns the result of object.__str__() (if defined)
or repr(object).
encoding defaults to sys.getdefaultencoding().
errors defaults to 'strict'.r  hhh	hzX)   'Andrea Gavana <andrea.gavana@gmail.com>'r  h|X   strr  h3h~h7jA  ubhu)r  }r  (hX   wx.lib.agw.aui.auibar.__date__r  hKh'KhX  str(object='') -> str
str(bytes_or_buffer[, encoding[, errors]]) -> str

Create a new string object from the given object. If encoding or
errors is specified, then the object must expose a data buffer
that will be decoded using the given encoding and error handler.
Otherwise, returns the result of object.__str__() (if defined)
or repr(object).
encoding defaults to sys.getdefaultencoding().
errors defaults to 'strict'.r  hhh	hzX   '31 March 2009'r  h|X   strr  h3h~h7jA  ubhu)r  }r  (hX'   wx.lib.agw.aui.auibar.actionClickButtonr  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   2r  h|X   intr  h3h~h7jA  ubhu)r  }r  (hX(   wx.lib.agw.aui.auibar.actionClickCaptionr  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   3r  h|X   intr  h3h~h7jA  ubhu)r  }r  (hX,   wx.lib.agw.aui.auibar.actionDragFloatingPaner  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   5r  h|X   intr  h3h~h7jA  ubhu)r  }r  (hX+   wx.lib.agw.aui.auibar.actionDragMovablePaner  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   6r  h|X   intr  h3h~h7jA  ubhu)r  }r  (hX+   wx.lib.agw.aui.auibar.actionDragToolbarPaner  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   4r  h|X   intr  h3h~h7jA  ubhu)r  }r  (hX    wx.lib.agw.aui.auibar.actionNoner  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   0r  h|X   intr  h3h~h7jA  ubhu)r  }r  (hX"   wx.lib.agw.aui.auibar.actionResizer  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   1r  h|X   intr  h3h~h7jA  ubhu)r  }r  (hX!   wx.lib.agw.aui.auibar.aero_deniedr  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.r  hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f7afe726e10>r  h|X$   wx.lib.embeddedimage.PyEmbeddedImager  h3h~h7jA  ubhu)r  }r  (hX$   wx.lib.agw.aui.auibar.aero_dock_paner  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.r  hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f7afe726790>r  h|X$   wx.lib.embeddedimage.PyEmbeddedImager  h3h~h7jA  ubhu)r  }r  (hX+   wx.lib.agw.aui.auibar.aero_dock_pane_bottomr  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.r  hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f7afe726910>r  h|X$   wx.lib.embeddedimage.PyEmbeddedImager  h3h~h7jA  ubhu)r  }r  (hX+   wx.lib.agw.aui.auibar.aero_dock_pane_centerr  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.r  hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f7afe726950>r  h|X$   wx.lib.embeddedimage.PyEmbeddedImager  h3h~h7jA  ubhu)r  }r  (hX+   wx.lib.agw.aui.auibar.aero_dock_pane_deniedr  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.r  hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f7afe7268d0>r  h|X$   wx.lib.embeddedimage.PyEmbeddedImager  h3h~h7jA  ubhu)r  }r  (hX)   wx.lib.agw.aui.auibar.aero_dock_pane_leftr  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.r  hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f7afe726990>r  h|X$   wx.lib.embeddedimage.PyEmbeddedImager  h3h~h7jA  ubhu)r  }r  (hX*   wx.lib.agw.aui.auibar.aero_dock_pane_rightr  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.r  hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f7afe7269d0>r  h|X$   wx.lib.embeddedimage.PyEmbeddedImager  h3h~h7jA  ubhu)r  }r  (hX(   wx.lib.agw.aui.auibar.aero_dock_pane_topr  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.r  hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f7afe726a10>r  h|X$   wx.lib.embeddedimage.PyEmbeddedImager  h3h~h7jA  ubhu)r  }r  (hX   wx.lib.agw.aui.auibar.aero_downr  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.r  hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f7afe726a50>r  h|X$   wx.lib.embeddedimage.PyEmbeddedImager  h3h~h7jA  ubhu)r  }r  (hX%   wx.lib.agw.aui.auibar.aero_down_focusr  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.r  hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f7afe726a90>r   h|X$   wx.lib.embeddedimage.PyEmbeddedImager  h3h~h7jA  ubhu)r  }r  (hX,   wx.lib.agw.aui.auibar.aero_down_focus_singler  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.r  hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f7afe726a90>r  h|X$   wx.lib.embeddedimage.PyEmbeddedImager  h3h~h7jA  ubhu)r  }r	  (hX&   wx.lib.agw.aui.auibar.aero_down_singler
  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.r  hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f7afe726ad0>r  h|X$   wx.lib.embeddedimage.PyEmbeddedImager
  h3h~h7jA  ubhu)r  }r  (hX   wx.lib.agw.aui.auibar.aero_leftr  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.r  hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f7afe726b10>r  h|X$   wx.lib.embeddedimage.PyEmbeddedImager  h3h~h7jA  ubhu)r  }r  (hX%   wx.lib.agw.aui.auibar.aero_left_focusr  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.r  hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f7afe726b50>r  h|X$   wx.lib.embeddedimage.PyEmbeddedImager  h3h~h7jA  ubhu)r  }r  (hX,   wx.lib.agw.aui.auibar.aero_left_focus_singler  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.r  hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f7afe726b50>r  h|X$   wx.lib.embeddedimage.PyEmbeddedImager  h3h~h7jA  ubhu)r   }r!  (hX&   wx.lib.agw.aui.auibar.aero_left_singler"  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.r#  hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f7afe726b90>r$  h|X$   wx.lib.embeddedimage.PyEmbeddedImager%  h3h~h7jA  ubhu)r&  }r'  (hX    wx.lib.agw.aui.auibar.aero_rightr(  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.r)  hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f7afe726bd0>r*  h|X$   wx.lib.embeddedimage.PyEmbeddedImager+  h3h~h7jA  ubhu)r,  }r-  (hX&   wx.lib.agw.aui.auibar.aero_right_focusr.  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.r/  hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f7afe726c10>r0  h|X$   wx.lib.embeddedimage.PyEmbeddedImager1  h3h~h7jA  ubhu)r2  }r3  (hX-   wx.lib.agw.aui.auibar.aero_right_focus_singler4  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.r5  hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f7afe726c10>r6  h|X$   wx.lib.embeddedimage.PyEmbeddedImager7  h3h~h7jA  ubhu)r8  }r9  (hX'   wx.lib.agw.aui.auibar.aero_right_singler:  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.r;  hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f7afe726c50>r<  h|X$   wx.lib.embeddedimage.PyEmbeddedImager=  h3h~h7jA  ubhu)r>  }r?  (hX   wx.lib.agw.aui.auibar.aero_tabr@  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.rA  hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f7afe726c90>rB  h|X$   wx.lib.embeddedimage.PyEmbeddedImagerC  h3h~h7jA  ubhu)rD  }rE  (hX$   wx.lib.agw.aui.auibar.aero_tab_focusrF  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.rG  hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f7afe726cd0>rH  h|X$   wx.lib.embeddedimage.PyEmbeddedImagerI  h3h~h7jA  ubhu)rJ  }rK  (hX+   wx.lib.agw.aui.auibar.aero_tab_focus_singlerL  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.rM  hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f7afe726cd0>rN  h|X$   wx.lib.embeddedimage.PyEmbeddedImagerO  h3h~h7jA  ubhu)rP  }rQ  (hX%   wx.lib.agw.aui.auibar.aero_tab_singlerR  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.rS  hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f7afe726d10>rT  h|X$   wx.lib.embeddedimage.PyEmbeddedImagerU  h3h~h7jA  ubhu)rV  }rW  (hX   wx.lib.agw.aui.auibar.aero_uprX  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.rY  hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f7afe726d50>rZ  h|X$   wx.lib.embeddedimage.PyEmbeddedImager[  h3h~h7jA  ubhu)r\  }r]  (hX#   wx.lib.agw.aui.auibar.aero_up_focusr^  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.r_  hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f7afe726d90>r`  h|X$   wx.lib.embeddedimage.PyEmbeddedImagera  h3h~h7jA  ubhu)rb  }rc  (hX*   wx.lib.agw.aui.auibar.aero_up_focus_singlerd  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.re  hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f7afe726d90>rf  h|X$   wx.lib.embeddedimage.PyEmbeddedImagerg  h3h~h7jA  ubhu)rh  }ri  (hX$   wx.lib.agw.aui.auibar.aero_up_singlerj  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.rk  hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f7afe726dd0>rl  h|X$   wx.lib.embeddedimage.PyEmbeddedImagerm  h3h~h7jA  ubhu)rn  }ro  (hX$   wx.lib.agw.aui.auibar.aeroguideSizeXrp  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4rq  hhh	hzX   31rr  h|X   intrs  h3h~h7jA  ubhu)rt  }ru  (hX$   wx.lib.agw.aui.auibar.aeroguideSizeYrv  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4rw  hhh	hzX   32rx  h|X   intry  h3h~h7jA  ubhu)rz  }r{  (hX&   wx.lib.agw.aui.auibar.AUI_BUTTON_CLOSEr|  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r}  hhh	hzX   101r~  h|X   intr  h3h~h7jA  ubhu)r  }r  (hX(   wx.lib.agw.aui.auibar.AUI_BUTTON_CUSTOM1r  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   201r  h|X   intr  h3h~h7jA  ubhu)r  }r  (hX(   wx.lib.agw.aui.auibar.AUI_BUTTON_CUSTOM2r  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   202r  h|X   intr  h3h~h7jA  ubhu)r  }r  (hX(   wx.lib.agw.aui.auibar.AUI_BUTTON_CUSTOM3r  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   203r  h|X   intr  h3h~h7jA  ubhu)r  }r  (hX(   wx.lib.agw.aui.auibar.AUI_BUTTON_CUSTOM4r  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   204r  h|X   intr  h3h~h7jA  ubhu)r  }r  (hX(   wx.lib.agw.aui.auibar.AUI_BUTTON_CUSTOM5r  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   205r  h|X   intr  h3h~h7jA  ubhu)r  }r  (hX(   wx.lib.agw.aui.auibar.AUI_BUTTON_CUSTOM6r  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   206r  h|X   intr  h3h~h7jA  ubhu)r  }r  (hX(   wx.lib.agw.aui.auibar.AUI_BUTTON_CUSTOM7r  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   207r  h|X   intr  h3h~h7jA  ubhu)r  }r  (hX(   wx.lib.agw.aui.auibar.AUI_BUTTON_CUSTOM8r  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   208r  h|X   intr  h3h~h7jA  ubhu)r  }r  (hX(   wx.lib.agw.aui.auibar.AUI_BUTTON_CUSTOM9r  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   209r  h|X   intr  h3h~h7jA  ubhu)r  }r  (hX%   wx.lib.agw.aui.auibar.AUI_BUTTON_DOWNr  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   110r  h|X   intr  h3h~h7jA  ubhu)r  }r  (hX%   wx.lib.agw.aui.auibar.AUI_BUTTON_LEFTr  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   107r  h|X   intr  h3h~h7jA  ubhu)r  }r  (hX1   wx.lib.agw.aui.auibar.AUI_BUTTON_MAXIMIZE_RESTOREr  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   102r  h|X   intr  h3h~h7jA  ubhu)r  }r  (hX)   wx.lib.agw.aui.auibar.AUI_BUTTON_MINIMIZEr  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   103r  h|X   intr  h3h~h7jA  ubhu)r  }r  (hX(   wx.lib.agw.aui.auibar.AUI_BUTTON_OPTIONSr  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   105r  h|X   intr  h3h~h7jA  ubhu)r  }r  (hX$   wx.lib.agw.aui.auibar.AUI_BUTTON_PINr  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   104r  h|X   intr  h3h~h7jA  ubhu)r  }r  (hX&   wx.lib.agw.aui.auibar.AUI_BUTTON_RIGHTr  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   108r  h|X   intr  h3h~h7jA  ubhu)r  }r  (hX.   wx.lib.agw.aui.auibar.AUI_BUTTON_STATE_CHECKEDr  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   32r  h|X   intr  h3h~h7jA  ubhu)r  }r  (hX/   wx.lib.agw.aui.auibar.AUI_BUTTON_STATE_DISABLEDr  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   8r  h|X   intr  h3h~h7jA  ubhu)r  }r  (hX-   wx.lib.agw.aui.auibar.AUI_BUTTON_STATE_HIDDENr  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   16r  h|X   intr  h3h~h7jA  ubhu)r  }r  (hX,   wx.lib.agw.aui.auibar.AUI_BUTTON_STATE_HOVERr  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   2r  h|X   intr  h3h~h7jA  ubhu)r  }r  (hX-   wx.lib.agw.aui.auibar.AUI_BUTTON_STATE_NORMALr  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   0r  h|X   intr  h3h~h7jA  ubhu)r  }r  (hX.   wx.lib.agw.aui.auibar.AUI_BUTTON_STATE_PRESSEDr   hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   4r  h|X   intr  h3h~h7jA  ubhu)r  }r  (hX#   wx.lib.agw.aui.auibar.AUI_BUTTON_UPr  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   109r  h|X   intr	  h3h~h7jA  ubhu)r
  }r  (hX+   wx.lib.agw.aui.auibar.AUI_BUTTON_WINDOWLISTr  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r
  hhh	hzX   106r  h|X   intr  h3h~h7jA  ubhu)r  }r  (hX%   wx.lib.agw.aui.auibar.AUI_DOCK_BOTTOMr  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   3r  h|X   intr  h3h~h7jA  ubhu)r  }r  (hX%   wx.lib.agw.aui.auibar.AUI_DOCK_CENTERr  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   5r  h|X   intr  h3h~h7jA  ubhu)r  }r  (hX%   wx.lib.agw.aui.auibar.AUI_DOCK_CENTREr  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   5r   h|X   intr!  h3h~h7jA  ubhu)r"  }r#  (hX#   wx.lib.agw.aui.auibar.AUI_DOCK_LEFTr$  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r%  hhh	hzX   4r&  h|X   intr'  h3h~h7jA  ubhu)r(  }r)  (hX#   wx.lib.agw.aui.auibar.AUI_DOCK_NONEr*  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r+  hhh	hzX   0r,  h|X   intr-  h3h~h7jA  ubhu)r.  }r/  (hX,   wx.lib.agw.aui.auibar.AUI_DOCK_NOTEBOOK_PAGEr0  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r1  hhh	hzX   6r2  h|X   intr3  h3h~h7jA  ubhu)r4  }r5  (hX$   wx.lib.agw.aui.auibar.AUI_DOCK_RIGHTr6  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r7  hhh	hzX   2r8  h|X   intr9  h3h~h7jA  ubhu)r:  }r;  (hX"   wx.lib.agw.aui.auibar.AUI_DOCK_TOPr<  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r=  hhh	hzX   1r>  h|X   intr?  h3h~h7jA  ubhu)r@  }rA  (hX7   wx.lib.agw.aui.auibar.AUI_DOCKART_ACTIVE_CAPTION_COLOURrB  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4rC  hhh	hzX   8rD  h|X   intrE  h3h~h7jA  ubhu)rF  }rG  (hX@   wx.lib.agw.aui.auibar.AUI_DOCKART_ACTIVE_CAPTION_GRADIENT_COLOURrH  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4rI  hhh	hzX   9rJ  h|X   intrK  h3h~h7jA  ubhu)rL  }rM  (hX<   wx.lib.agw.aui.auibar.AUI_DOCKART_ACTIVE_CAPTION_TEXT_COLOURrN  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4rO  hhh	hzX   12rP  h|X   intrQ  h3h~h7jA  ubhu)rR  }rS  (hX3   wx.lib.agw.aui.auibar.AUI_DOCKART_BACKGROUND_COLOURrT  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4rU  hhh	hzX   5rV  h|X   intrW  h3h~h7jA  ubhu)rX  }rY  (hX<   wx.lib.agw.aui.auibar.AUI_DOCKART_BACKGROUND_GRADIENT_COLOURrZ  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r[  hhh	hzX   6r\  h|X   intr]  h3h~h7jA  ubhu)r^  }r_  (hX/   wx.lib.agw.aui.auibar.AUI_DOCKART_BORDER_COLOURr`  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4ra  hhh	hzX   14rb  h|X   intrc  h3h~h7jA  ubhu)rd  }re  (hX.   wx.lib.agw.aui.auibar.AUI_DOCKART_CAPTION_FONTrf  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4rg  hhh	hzX   16rh  h|X   intri  h3h~h7jA  ubhu)rj  }rk  (hX.   wx.lib.agw.aui.auibar.AUI_DOCKART_CAPTION_SIZErl  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4rm  hhh	hzX   1rn  h|X   intro  h3h~h7jA  ubhu)rp  }rq  (hX0   wx.lib.agw.aui.auibar.AUI_DOCKART_DRAW_SASH_GRIPrr  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4rs  hhh	hzX   18rt  h|X   intru  h3h~h7jA  ubhu)rv  }rw  (hX/   wx.lib.agw.aui.auibar.AUI_DOCKART_GRADIENT_TYPErx  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4ry  hhh	hzX   17rz  h|X   intr{  h3h~h7jA  ubhu)r|  }r}  (hX0   wx.lib.agw.aui.auibar.AUI_DOCKART_GRIPPER_COLOURr~  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   15r  h|X   intr  h3h~h7jA  ubhu)r  }r  (hX.   wx.lib.agw.aui.auibar.AUI_DOCKART_GRIPPER_SIZEr  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   2r  h|X   intr  h3h~h7jA  ubhu)r  }r  (hX;   wx.lib.agw.aui.auibar.AUI_DOCKART_HINT_WINDOW_BORDER_COLOURr  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   20r  h|X   intr  h3h~h7jA  ubhu)r  }r  (hX4   wx.lib.agw.aui.auibar.AUI_DOCKART_HINT_WINDOW_COLOURr  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   19r  h|X   intr  h3h~h7jA  ubhu)r  }r  (hX9   wx.lib.agw.aui.auibar.AUI_DOCKART_INACTIVE_CAPTION_COLOURr  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   10r  h|X   intr  h3h~h7jA  ubhu)r  }r  (hXB   wx.lib.agw.aui.auibar.AUI_DOCKART_INACTIVE_CAPTION_GRADIENT_COLOURr  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   11r  h|X   intr  h3h~h7jA  ubhu)r  }r  (hX>   wx.lib.agw.aui.auibar.AUI_DOCKART_INACTIVE_CAPTION_TEXT_COLOURr  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   13r  h|X   intr  h3h~h7jA  ubhu)r  }r  (hX2   wx.lib.agw.aui.auibar.AUI_DOCKART_PANE_BORDER_SIZEr  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   3r  h|X   intr  h3h~h7jA  ubhu)r  }r  (hX2   wx.lib.agw.aui.auibar.AUI_DOCKART_PANE_BUTTON_SIZEr  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   4r  h|X   intr  h3h~h7jA  ubhu)r  }r  (hX-   wx.lib.agw.aui.auibar.AUI_DOCKART_SASH_COLOURr  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   7r  h|X   intr  h3h~h7jA  ubhu)r  }r  (hX+   wx.lib.agw.aui.auibar.AUI_DOCKART_SASH_SIZEr  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   0r  h|X   intr  h3h~h7jA  ubhu)r  }r  (hX-   wx.lib.agw.aui.auibar.AUI_GRADIENT_HORIZONTALr  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   2r  h|X   intr  h3h~h7jA  ubhu)r  }r  (hX'   wx.lib.agw.aui.auibar.AUI_GRADIENT_NONEr  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   0r  h|X   intr  h3h~h7jA  ubhu)r  }r  (hX+   wx.lib.agw.aui.auibar.AUI_GRADIENT_VERTICALr  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   1r  h|X   intr  h3h~h7jA  ubhu)r  }r  (hX%   wx.lib.agw.aui.auibar.AUI_INSERT_DOCKr  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   2r  h|X   intr  h3h~h7jA  ubhu)r  }r  (hX%   wx.lib.agw.aui.auibar.AUI_INSERT_PANEr  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   0r  h|X   intr  h3h~h7jA  ubhu)r  }r  (hX$   wx.lib.agw.aui.auibar.AUI_INSERT_ROWr  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   1r  h|X   intr  h3h~h7jA  ubhu)r  }r  (hX1   wx.lib.agw.aui.auibar.AUI_MGR_AERO_DOCKING_GUIDESr  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   1024r  h|X   intr  h3h~h7jA  ubhu)r  }r  (hX/   wx.lib.agw.aui.auibar.AUI_MGR_ALLOW_ACTIVE_PANEr  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   2r  h|X   intr  h3h~h7jA  ubhu)r  }r  (hX,   wx.lib.agw.aui.auibar.AUI_MGR_ALLOW_FLOATINGr  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   1r  h|X   intr  h3h~h7jA  ubhu)r  }r  (hX,   wx.lib.agw.aui.auibar.AUI_MGR_ANIMATE_FRAMESr  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   512r  h|X   intr  h3h~h7jA  ubhu)r  }r  (hX/   wx.lib.agw.aui.auibar.AUI_MGR_AUTONB_NO_CAPTIONr  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   32768r  h|X   intr  h3h~h7jA  ubhu)r   }r  (hX%   wx.lib.agw.aui.auibar.AUI_MGR_DEFAULTr  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   201r  h|X   intr  h3h~h7jA  ubhu)r  }r  (hX'   wx.lib.agw.aui.auibar.AUI_MGR_HINT_FADEr  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r	  hhh	hzX   64r
  h|X   intr  h3h~h7jA  ubhu)r  }r
  (hX)   wx.lib.agw.aui.auibar.AUI_MGR_LIVE_RESIZEr  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   256r  h|X   intr  h3h~h7jA  ubhu)r  }r  (hX5   wx.lib.agw.aui.auibar.AUI_MGR_NO_VENETIAN_BLINDS_FADEr  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   128r  h|X   intr  h3h~h7jA  ubhu)r  }r  (hX5   wx.lib.agw.aui.auibar.AUI_MGR_PREVIEW_MINIMIZED_PANESr  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   2048r  h|X   intr  h3h~h7jA  ubhu)r  }r  (hX,   wx.lib.agw.aui.auibar.AUI_MGR_RECTANGLE_HINTr   hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r!  hhh	hzX   32r"  h|X   intr#  h3h~h7jA  ubhu)r$  }r%  (hX,   wx.lib.agw.aui.auibar.AUI_MGR_SMOOTH_DOCKINGr&  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r'  hhh	hzX   8192r(  h|X   intr)  h3h~h7jA  ubhu)r*  }r+  (hX.   wx.lib.agw.aui.auibar.AUI_MGR_TRANSPARENT_DRAGr,  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r-  hhh	hzX   4r.  h|X   intr/  h3h~h7jA  ubhu)r0  }r1  (hX.   wx.lib.agw.aui.auibar.AUI_MGR_TRANSPARENT_HINTr2  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r3  hhh	hzX   8r4  h|X   intr5  h3h~h7jA  ubhu)r6  }r7  (hX3   wx.lib.agw.aui.auibar.AUI_MGR_USE_NATIVE_MINIFRAMESr8  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r9  hhh	hzX   16384r:  h|X   intr;  h3h~h7jA  ubhu)r<  }r=  (hX2   wx.lib.agw.aui.auibar.AUI_MGR_VENETIAN_BLINDS_HINTr>  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r?  hhh	hzX   16r@  h|X   intrA  h3h~h7jA  ubhu)rB  }rC  (hX4   wx.lib.agw.aui.auibar.AUI_MGR_WHIDBEY_DOCKING_GUIDESrD  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4rE  hhh	hzX   4096rF  h|X   intrG  h3h~h7jA  ubhu)rH  }rI  (hX,   wx.lib.agw.aui.auibar.AUI_MINIMIZE_CAPT_HIDErJ  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4rK  hhh	hzX   0rL  h|X   intrM  h3h~h7jA  ubhu)rN  }rO  (hX,   wx.lib.agw.aui.auibar.AUI_MINIMIZE_CAPT_HORZrP  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4rQ  hhh	hzX   16rR  h|X   intrS  h3h~h7jA  ubhu)rT  }rU  (hX,   wx.lib.agw.aui.auibar.AUI_MINIMIZE_CAPT_MASKrV  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4rW  hhh	hzX   24rX  h|X   intrY  h3h~h7jA  ubhu)rZ  }r[  (hX-   wx.lib.agw.aui.auibar.AUI_MINIMIZE_CAPT_SMARTr\  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r]  hhh	hzX   8r^  h|X   intr_  h3h~h7jA  ubhu)r`  }ra  (hX-   wx.lib.agw.aui.auibar.AUI_MINIMIZE_POS_BOTTOMrb  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4rc  hhh	hzX   5rd  h|X   intre  h3h~h7jA  ubhu)rf  }rg  (hX+   wx.lib.agw.aui.auibar.AUI_MINIMIZE_POS_LEFTrh  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4ri  hhh	hzX   3rj  h|X   intrk  h3h~h7jA  ubhu)rl  }rm  (hX+   wx.lib.agw.aui.auibar.AUI_MINIMIZE_POS_MASKrn  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4ro  hhh	hzX   23rp  h|X   intrq  h3h~h7jA  ubhu)rr  }rs  (hX,   wx.lib.agw.aui.auibar.AUI_MINIMIZE_POS_RIGHTrt  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4ru  hhh	hzX   4rv  h|X   intrw  h3h~h7jA  ubhu)rx  }ry  (hX,   wx.lib.agw.aui.auibar.AUI_MINIMIZE_POS_SMARTrz  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r{  hhh	hzX   1r|  h|X   intr}  h3h~h7jA  ubhu)r~  }r  (hX.   wx.lib.agw.aui.auibar.AUI_MINIMIZE_POS_TOOLBARr  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   6r  h|X   intr  h3h~h7jA  ubhu)r  }r  (hX*   wx.lib.agw.aui.auibar.AUI_MINIMIZE_POS_TOPr  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   2r  h|X   intr  h3h~h7jA  ubhu)r  }r  (hX#   wx.lib.agw.aui.auibar.AUI_NB_BOTTOMr  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   8r  h|X   intr  h3h~h7jA  ubhu)r  }r  (hX)   wx.lib.agw.aui.auibar.AUI_NB_CLOSE_BUTTONr  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   1024r  h|X   intr  h3h~h7jA  ubhu)r  }r  (hX0   wx.lib.agw.aui.auibar.AUI_NB_CLOSE_ON_ACTIVE_TABr  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   2048r  h|X   intr  h3h~h7jA  ubhu)r  }r  (hX.   wx.lib.agw.aui.auibar.AUI_NB_CLOSE_ON_ALL_TABSr  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   4096r  h|X   intr  h3h~h7jA  ubhu)r  }r  (hX.   wx.lib.agw.aui.auibar.AUI_NB_CLOSE_ON_TAB_LEFTr  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   262144r  h|X   intr  h3h~h7jA  ubhu)r  }r  (hX*   wx.lib.agw.aui.auibar.AUI_NB_DEFAULT_STYLEr  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   1059121r  h|X   intr  h3h~h7jA  ubhu)r  }r  (hX)   wx.lib.agw.aui.auibar.AUI_NB_DRAW_DND_TABr  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   1048576r  h|X   intr  h3h~h7jA  ubhu)r  }r  (hX/   wx.lib.agw.aui.auibar.AUI_NB_HIDE_ON_SINGLE_TABr  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   32768r  h|X   intr  h3h~h7jA  ubhu)r  }r  (hX!   wx.lib.agw.aui.auibar.AUI_NB_LEFTr  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   2r  h|X   intr  h3h~h7jA  ubhu)r  }r  (hX/   wx.lib.agw.aui.auibar.AUI_NB_MIDDLE_CLICK_CLOSEr  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   8192r  h|X   intr  h3h~h7jA  ubhu)r  }r  (hX)   wx.lib.agw.aui.auibar.AUI_NB_NO_TAB_FOCUSr  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   4194304r  h|X   intr  h3h~h7jA  ubhu)r  }r  (hX,   wx.lib.agw.aui.auibar.AUI_NB_ORDER_BY_ACCESSr  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   2097152r  h|X   intr  h3h~h7jA  ubhu)r  }r  (hX"   wx.lib.agw.aui.auibar.AUI_NB_RIGHTr  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   4r  h|X   intr  h3h~h7jA  ubhu)r  }r  (hX+   wx.lib.agw.aui.auibar.AUI_NB_SCROLL_BUTTONSr  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   256r  h|X   intr  h3h~h7jA  ubhu)r  }r  (hX'   wx.lib.agw.aui.auibar.AUI_NB_SMART_TABSr  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   65536r  h|X   intr  h3h~h7jA  ubhu)r  }r  (hX)   wx.lib.agw.aui.auibar.AUI_NB_SUB_NOTEBOOKr  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   16384r  h|X   intr  h3h~h7jA  ubhu)r  }r  (hX.   wx.lib.agw.aui.auibar.AUI_NB_TAB_EXTERNAL_MOVEr  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   64r  h|X   intr  h3h~h7jA  ubhu)r  }r  (hX,   wx.lib.agw.aui.auibar.AUI_NB_TAB_FIXED_WIDTHr  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   128r  h|X   intr  h3h~h7jA  ubhu)r  }r  (hX&   wx.lib.agw.aui.auibar.AUI_NB_TAB_FLOATr  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   524288r  h|X   intr  h3h~h7jA  ubhu)r  }r  (hX%   wx.lib.agw.aui.auibar.AUI_NB_TAB_MOVEr  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r  hhh	hzX   32r    h|X   intr   h3h~h7jA  ubhu)r   }r   (hX&   wx.lib.agw.aui.auibar.AUI_NB_TAB_SPLITr   hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r   hhh	hzX   16r   h|X   intr   h3h~h7jA  ubhu)r   }r	   (hX    wx.lib.agw.aui.auibar.AUI_NB_TOPr
   hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r   hhh	hzX   1r   h|X   intr
   h3h~h7jA  ubhu)r   }r   (hX0   wx.lib.agw.aui.auibar.AUI_NB_USE_IMAGES_DROPDOWNr   hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r   hhh	hzX   131072r   h|X   intr   h3h~h7jA  ubhu)r   }r   (hX.   wx.lib.agw.aui.auibar.AUI_NB_WINDOWLIST_BUTTONr   hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r   hhh	hzX   512r   h|X   intr   h3h~h7jA  ubhu)r   }r   (hX&   wx.lib.agw.aui.auibar.AUI_TB_CLOCKWISEr   hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r   hhh	hzX   256r   h|X   intr   h3h~h7jA  ubhu)r    }r!   (hX-   wx.lib.agw.aui.auibar.AUI_TB_COUNTERCLOCKWISEr"   hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r#   hhh	hzX   512r$   h|X   intr%   h3h~h7jA  ubhu)r&   }r'   (hX*   wx.lib.agw.aui.auibar.AUI_TB_DEFAULT_STYLEr(   hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r)   hhh	hzX   0r*   h|X   intr+   h3h~h7jA  ubhu)r,   }r-   (hX$   wx.lib.agw.aui.auibar.AUI_TB_GRIPPERr.   hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r/   hhh	hzX   8r0   h|X   intr1   h3h~h7jA  ubhu)r2   }r3   (hX(   wx.lib.agw.aui.auibar.AUI_TB_HORZ_LAYOUTr4   hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r5   hhh	hzX   64r6   h|X   intr7   h3h~h7jA  ubhu)r8   }r9   (hX&   wx.lib.agw.aui.auibar.AUI_TB_HORZ_TEXTr:   hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r;   hhh	hzX   65r<   h|X   intr=   h3h~h7jA  ubhu)r>   }r?   (hX*   wx.lib.agw.aui.auibar.AUI_TB_NO_AUTORESIZEr@   hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4rA   hhh	hzX   4rB   h|X   intrC   h3h~h7jA  ubhu)rD   }rE   (hX(   wx.lib.agw.aui.auibar.AUI_TB_NO_TOOLTIPSrF   hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4rG   hhh	hzX   2rH   h|X   intrI   h3h~h7jA  ubhu)rJ   }rK   (hX%   wx.lib.agw.aui.auibar.AUI_TB_OVERFLOWrL   hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4rM   hhh	hzX   16rN   h|X   intrO   h3h~h7jA  ubhu)rP   }rQ   (hX-   wx.lib.agw.aui.auibar.AUI_TB_PLAIN_BACKGROUNDrR   hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4rS   hhh	hzX   128rT   h|X   intrU   h3h~h7jA  ubhu)rV   }rW   (hX!   wx.lib.agw.aui.auibar.AUI_TB_TEXTrX   hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4rY   hhh	hzX   1rZ   h|X   intr[   h3h~h7jA  ubhu)r\   }r]   (hX&   wx.lib.agw.aui.auibar.AUI_TB_VERT_TEXTr^   hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r_   hhh	hzX   289r`   h|X   intra   h3h~h7jA  ubhu)rb   }rc   (hX%   wx.lib.agw.aui.auibar.AUI_TB_VERTICALrd   hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4re   hhh	hzX   32rf   h|X   intrg   h3h~h7jA  ubhu)rh   }ri   (hX,   wx.lib.agw.aui.auibar.AUI_TBART_GRIPPER_SIZErj   hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4rk   hhh	hzX   1rl   h|X   intrm   h3h~h7jA  ubhu)rn   }ro   (hX-   wx.lib.agw.aui.auibar.AUI_TBART_OVERFLOW_SIZErp   hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4rq   hhh	hzX   2rr   h|X   intrs   h3h~h7jA  ubhu)rt   }ru   (hX.   wx.lib.agw.aui.auibar.AUI_TBART_SEPARATOR_SIZErv   hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4rw   hhh	hzX   0rx   h|X   intry   h3h~h7jA  ubhu)rz   }r{   (hX+   wx.lib.agw.aui.auibar.AUI_TBTOOL_HORIZONTALr|   hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r}   hhh	hzX   0r~   h|X   intr   h3h~h7jA  ubhu)r   }r   (hX,   wx.lib.agw.aui.auibar.AUI_TBTOOL_TEXT_BOTTOMr   hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r   hhh	hzX   3r   h|X   intr   h3h~h7jA  ubhu)r   }r   (hX*   wx.lib.agw.aui.auibar.AUI_TBTOOL_TEXT_LEFTr   hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r   hhh	hzX   0r   h|X   intr   h3h~h7jA  ubhu)r   }r   (hX+   wx.lib.agw.aui.auibar.AUI_TBTOOL_TEXT_RIGHTr   hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r   hhh	hzX   1r   h|X   intr   h3h~h7jA  ubhu)r   }r   (hX)   wx.lib.agw.aui.auibar.AUI_TBTOOL_TEXT_TOPr   hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r   hhh	hzX   2r   h|X   intr   h3h~h7jA  ubhu)r   }r   (hX/   wx.lib.agw.aui.auibar.AUI_TBTOOL_VERT_CLOCKWISEr   hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r   hhh	hzX   1r   h|X   intr   h3h~h7jA  ubhu)r   }r   (hX6   wx.lib.agw.aui.auibar.AUI_TBTOOL_VERT_COUNTERCLOCKWISEr   hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r   hhh	hzX   2r   h|X   intr   h3h~h7jA  ubhu)r   }r   (hX&   wx.lib.agw.aui.auibar.AuiBaseTabCtrlIdr   hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r   hhh	hzX   5380r   h|X   intr   h3h~h7jA  ubhu)r   }r   (hX(   wx.lib.agw.aui.auibar.auiInsertRowPixelsr   hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r   hhh	hzX   10r   h|X   intr   h3h~h7jA  ubhu)r   }r   (hX*   wx.lib.agw.aui.auibar.auiLayerInsertOffsetr   hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r   hhh	hzX   5r   h|X   intr   h3h~h7jA  ubhu)r   }r   (hX*   wx.lib.agw.aui.auibar.auiLayerInsertPixelsr   hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r   hhh	hzX   40r   h|X   intr   h3h~h7jA  ubhu)r   }r   (hX%   wx.lib.agw.aui.auibar.auiNewRowPixelsr   hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r   hhh	hzX   40r   h|X   intr   h3h~h7jA  ubhu)r   }r   (hX)   wx.lib.agw.aui.auibar.auinotebook_previewr   hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.r   hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f7afe726e50>r   h|X$   wx.lib.embeddedimage.PyEmbeddedImager   h3h~h7jA  ubhu)r   }r   (hX%   wx.lib.agw.aui.auibar.auiToolBarLayerr   hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r   hhh	hzX   10r   h|X   intr   h3h~h7jA  ubhu)r   }r   (hX+   wx.lib.agw.aui.auibar.BUTTON_DROPDOWN_WIDTHr   hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r   hhh	hzX   10r   h|X   intr   h3h~h7jA  ubhu)r   }r   (hX    wx.lib.agw.aui.auibar.close_bitsr   hKh'KhX  bytes(iterable_of_ints) -> bytes
bytes(string, encoding[, errors]) -> bytes
bytes(bytes_or_buffer) -> immutable copy of bytes_or_buffer
bytes(int) -> bytes object of size given by the parameter initialized with null bytes
bytes() -> empty bytes object

Construct an immutable array of bytes from:
  - an iterable yielding integers in range(256)
  - a text string encoded using the specified encoding
  - any object implementing the buffer API.
  - an integerr   hhh	hzX   b'\xff\xff\xff\xff\x07\xf0\xfb\xef\xdb\xed\x8b\xe8\x1b\xec;\xee\x1b\xec\x8b\xe8\xdb\xed\xfb\xef\x07\xf0\xff\xff\xff\xff\xff\xff'r   h|X   bytesr   h3h~h7jA  ubhu)r   }r   (hX*   wx.lib.agw.aui.auibar.colourHintBackgroundr   hKh'KhX   Colour()
Colour(red, green, blue, alpha=ALPHA_OPAQUE)
Colour(colRGB)
Colour(colour)

A colour is an object representing a combination of Red, Green, and
Blue (RGB) intensity values and an Alpha value, and is used to
determine drawing colours.r   hhh	hzX   wx.Colour(0, 64, 255, 255)r   h|X   wx._core.Colourr   h3h~h7jA  ubhu)r   }r   (hX&   wx.lib.agw.aui.auibar.colourHintBorderr   hKh'KhX   Colour()
Colour(red, green, blue, alpha=ALPHA_OPAQUE)
Colour(colRGB)
Colour(colour)

A colour is an object representing a combination of Red, Green, and
Blue (RGB) intensity values and an Alpha value, and is used to
determine drawing colours.r   hhh	hzX   wx.Colour(60, 60, 60, 255)r   h|X   wx._core.Colourr   h3h~h7jA  ubhu)r   }r   (hX%   wx.lib.agw.aui.auibar.colourIconArrowr   hKh'KhX   Colour()
Colour(red, green, blue, alpha=ALPHA_OPAQUE)
Colour(colRGB)
Colour(colour)

A colour is an object representing a combination of Red, Green, and
Blue (RGB) intensity values and an Alpha value, and is used to
determine drawing colours.r   hhh	hzX   wx.Colour(77, 79, 170, 255)r   h|X   wx._core.Colourr   h3h~h7jA  ubhu)r   }r   (hX*   wx.lib.agw.aui.auibar.colourIconBackgroundr   hKh'KhX   Colour()
Colour(red, green, blue, alpha=ALPHA_OPAQUE)
Colour(colRGB)
Colour(colour)

A colour is an object representing a combination of Red, Green, and
Blue (RGB) intensity values and an Alpha value, and is used to
determine drawing colours.r   hhh	hzX   wx.Colour(-1, -1, -1, 255)r   h|X   wx._core.Colourr   h3h~h7jA  ubhu)r   }r   (hX&   wx.lib.agw.aui.auibar.colourIconBorderr   hKh'KhX   Colour()
Colour(red, green, blue, alpha=ALPHA_OPAQUE)
Colour(colRGB)
Colour(colour)

A colour is an object representing a combination of Red, Green, and
Blue (RGB) intensity values and an Alpha value, and is used to
determine drawing colours.r   hhh	hzX   wx.Colour(82, 65, 156, 255)r   h|X   wx._core.Colourr   h3h~h7jA  ubhu)r   }r   (hX,   wx.lib.agw.aui.auibar.colourIconDockingPart1r   hKh'KhX   Colour()
Colour(red, green, blue, alpha=ALPHA_OPAQUE)
Colour(colRGB)
Colour(colour)

A colour is an object representing a combination of Red, Green, and
Blue (RGB) intensity values and an Alpha value, and is used to
determine drawing colours.r   hhh	hzX   wx.Colour(215, 228, 243, 255)r   h|X   wx._core.Colourr   h3h~h7jA  ubhu)r   }r   (hX,   wx.lib.agw.aui.auibar.colourIconDockingPart2r !  hKh'KhX   Colour()
Colour(red, green, blue, alpha=ALPHA_OPAQUE)
Colour(colRGB)
Colour(colour)

A colour is an object representing a combination of Red, Green, and
Blue (RGB) intensity values and an Alpha value, and is used to
determine drawing colours.r!  hhh	hzX   wx.Colour(180, 201, 225, 255)r!  h|X   wx._core.Colourr!  h3h~h7jA  ubhu)r!  }r!  (hX&   wx.lib.agw.aui.auibar.colourIconShadowr!  hKh'KhX   Colour()
Colour(red, green, blue, alpha=ALPHA_OPAQUE)
Colour(colRGB)
Colour(colour)

A colour is an object representing a combination of Red, Green, and
Blue (RGB) intensity values and an Alpha value, and is used to
determine drawing colours.r!  hhh	hzX   wx.Colour(198, 198, 198, 255)r!  h|X   wx._core.Colourr	!  h3h~h7jA  ubhu)r
!  }r!  (hX,   wx.lib.agw.aui.auibar.colourTargetBackgroundr!  hKh'KhX   Colour()
Colour(red, green, blue, alpha=ALPHA_OPAQUE)
Colour(colRGB)
Colour(colour)

A colour is an object representing a combination of Red, Green, and
Blue (RGB) intensity values and an Alpha value, and is used to
determine drawing colours.r
!  hhh	hzX   wx.Colour(224, 224, 224, 255)r!  h|X   wx._core.Colourr!  h3h~h7jA  ubhu)r!  }r!  (hX(   wx.lib.agw.aui.auibar.colourTargetBorderr!  hKh'KhX   Colour()
Colour(red, green, blue, alpha=ALPHA_OPAQUE)
Colour(colRGB)
Colour(colour)

A colour is an object representing a combination of Red, Green, and
Blue (RGB) intensity values and an Alpha value, and is used to
determine drawing colours.r!  hhh	hzX   wx.Colour(180, 180, 180, 255)r!  h|X   wx._core.Colourr!  h3h~h7jA  ubhu)r!  }r!  (hX'   wx.lib.agw.aui.auibar.colourTargetShader!  hKh'KhX   Colour()
Colour(red, green, blue, alpha=ALPHA_OPAQUE)
Colour(colRGB)
Colour(colour)

A colour is an object representing a combination of Red, Green, and
Blue (RGB) intensity values and an Alpha value, and is used to
determine drawing colours.r!  hhh	hzX   wx.Colour(206, 206, 206, 255)r!  h|X   wx._core.Colourr!  h3h~h7jA  ubhu)r!  }r!  (hX*   wx.lib.agw.aui.auibar.DISABLED_TEXT_COLOURr!  hKh'KhX   Colour()
Colour(red, green, blue, alpha=ALPHA_OPAQUE)
Colour(colRGB)
Colour(colour)

A colour is an object representing a combination of Red, Green, and
Blue (RGB) intensity values and an Alpha value, and is used to
determine drawing colours.r!  hhh	hzX   wx.Colour(153, 153, 153, 255)r !  h|X   wx._core.Colourr!!  h3h~h7jA  ubhu)r"!  }r#!  (hX,   wx.lib.agw.aui.auibar.DISABLED_TEXT_GREY_HUEr$!  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r%!  hhh	hzX   153r&!  h|X   intr'!  h3h~h7jA  ubhu)r(!  }r)!  (hX   wx.lib.agw.aui.auibar.downr*!  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.r+!  hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f7afe726590>r,!  h|X$   wx.lib.embeddedimage.PyEmbeddedImager-!  h3h~h7jA  ubhu)r.!  }r/!  (hX    wx.lib.agw.aui.auibar.down_focusr0!  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.r1!  hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f7afe7265d0>r2!  h|X$   wx.lib.embeddedimage.PyEmbeddedImager3!  h3h~h7jA  ubhu)r4!  }r5!  (hX'   wx.lib.agw.aui.auibar.down_focus_singler6!  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.r7!  hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f7afe726250>r8!  h|X$   wx.lib.embeddedimage.PyEmbeddedImager9!  h3h~h7jA  ubhu)r:!  }r;!  (hX!   wx.lib.agw.aui.auibar.down_singler<!  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.r=!  hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f7afe726290>r>!  h|X$   wx.lib.embeddedimage.PyEmbeddedImager?!  h3h~h7jA  ubhu)r@!  }rA!  (hX/   wx.lib.agw.aui.auibar.EVT_AUITOOLBAR_BEGIN_DRAGrB!  hKh'KhXK   Instances of this class are used to bind specific events to event handlers.rC!  hhh	hzX0   <wx.core.PyEventBinder object at 0x7f7aeea9ecd0>rD!  h|X   wx.core.PyEventBinderrE!  h3h~h7jA  ubhu)rF!  }rG!  (hX1   wx.lib.agw.aui.auibar.EVT_AUITOOLBAR_MIDDLE_CLICKrH!  hKh'KhXK   Instances of this class are used to bind specific events to event handlers.rI!  hhh	hzX0   <wx.core.PyEventBinder object at 0x7f7aeea9eed0>rJ!  h|X   wx.core.PyEventBinderrK!  h3h~h7jA  ubhu)rL!  }rM!  (hX3   wx.lib.agw.aui.auibar.EVT_AUITOOLBAR_OVERFLOW_CLICKrN!  hKh'KhXK   Instances of this class are used to bind specific events to event handlers.rO!  hhh	hzX0   <wx.core.PyEventBinder object at 0x7f7aef7ca510>rP!  h|X   wx.core.PyEventBinderrQ!  h3h~h7jA  ubhu)rR!  }rS!  (hX0   wx.lib.agw.aui.auibar.EVT_AUITOOLBAR_RIGHT_CLICKrT!  hKh'KhXK   Instances of this class are used to bind specific events to event handlers.rU!  hhh	hzX0   <wx.core.PyEventBinder object at 0x7f7aeeaa0ad0>rV!  h|X   wx.core.PyEventBinderrW!  h3h~h7jA  ubhu)rX!  }rY!  (hX2   wx.lib.agw.aui.auibar.EVT_AUITOOLBAR_TOOL_DROPDOWNrZ!  hKh'KhXK   Instances of this class are used to bind specific events to event handlers.r[!  hhh	hzX0   <wx.core.PyEventBinder object at 0x7f7aef8436d0>r\!  h|X   wx.core.PyEventBinderr]!  h3h~h7jA  ubhu)r^!  }r_!  (hX    wx.lib.agw.aui.auibar.guideSizeXr`!  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4ra!  hhh	hzX   29rb!  h|X   intrc!  h3h~h7jA  ubhu)rd!  }re!  (hX    wx.lib.agw.aui.auibar.guideSizeYrf!  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4rg!  hhh	hzX   32rh!  h|X   intri!  h3h~h7jA  ubhu)rj!  }rk!  (hX&   wx.lib.agw.aui.auibar.ID_RESTORE_FRAMErl!  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4rm!  hhh	hzX   15999rn!  h|X   intro!  h3h~h7jA  ubhu)rp!  }rq!  (hX    wx.lib.agw.aui.auibar.ITEM_CHECKrr!  hKh'Khhhhh	hzX   1rs!  h|X   wx._core.ItemKindrt!  h3h~h7jA  ubhu)ru!  }rv!  (hX"   wx.lib.agw.aui.auibar.ITEM_CONTROLrw!  hKh'Khhhhh	hzX   4rx!  h|X   wx._core.ItemKindry!  h3h~h7jA  ubhu)rz!  }r{!  (hX    wx.lib.agw.aui.auibar.ITEM_LABELr|!  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r}!  hhh	hzX   5r~!  h|X   intr!  h3h~h7jA  ubhu)r!  }r!  (hX!   wx.lib.agw.aui.auibar.ITEM_NORMALr!  hKh'Khhhhh	hzX   0r!  h|X   wx._core.ItemKindr!  h3h~h7jA  ubhu)r!  }r!  (hX    wx.lib.agw.aui.auibar.ITEM_RADIOr!  hKh'Khhhhh	hzX   2r!  h|X   wx._core.ItemKindr!  h3h~h7jA  ubhu)r!  }r!  (hX$   wx.lib.agw.aui.auibar.ITEM_SEPARATORr!  hKh'Khhhhh	hzX   -1r!  h|X   wx._core.ItemKindr!  h3h~h7jA  ubhu)r!  }r!  (hX!   wx.lib.agw.aui.auibar.ITEM_SPACERr!  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r!  hhh	hzX   6r!  h|X   intr!  h3h~h7jA  ubhu)r!  }r!  (hX   wx.lib.agw.aui.auibar.leftr!  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.r!  hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f7afe726610>r!  h|X$   wx.lib.embeddedimage.PyEmbeddedImager!  h3h~h7jA  ubhu)r!  }r!  (hX    wx.lib.agw.aui.auibar.left_focusr!  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.r!  hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f7afe726650>r!  h|X$   wx.lib.embeddedimage.PyEmbeddedImager!  h3h~h7jA  ubhu)r!  }r!  (hX'   wx.lib.agw.aui.auibar.left_focus_singler!  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.r!  hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f7afe7262d0>r!  h|X$   wx.lib.embeddedimage.PyEmbeddedImager!  h3h~h7jA  ubhu)r!  }r!  (hX!   wx.lib.agw.aui.auibar.left_singler!  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.r!  hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f7afe726310>r!  h|X$   wx.lib.embeddedimage.PyEmbeddedImager!  h3h~h7jA  ubhu)r!  }r!  (hX   wx.lib.agw.aui.auibar.max_bitsr!  hKh'KhX  bytes(iterable_of_ints) -> bytes
bytes(string, encoding[, errors]) -> bytes
bytes(bytes_or_buffer) -> immutable copy of bytes_or_buffer
bytes(int) -> bytes object of size given by the parameter initialized with null bytes
bytes() -> empty bytes object

Construct an immutable array of bytes from:
  - an iterable yielding integers in range(256)
  - a text string encoded using the specified encoding
  - any object implementing the buffer API.
  - an integerr!  hhh	hzX   b'\xff\xff\xff\xff\xff\xff\x07\xf0\xf7\xf7\x07\xf0\xf7\xf7\xf7\xf7\xf7\xf7\xf7\xf7\xf7\xf7\x07\xf0\xff\xff\xff\xff\xff\xff\xff\xff'r!  h|X   bytesr!  h3h~h7jA  ubhu)r!  }r!  (hX#   wx.lib.agw.aui.auibar.minimize_bitsr!  hKh'KhX  bytes(iterable_of_ints) -> bytes
bytes(string, encoding[, errors]) -> bytes
bytes(bytes_or_buffer) -> immutable copy of bytes_or_buffer
bytes(int) -> bytes object of size given by the parameter initialized with null bytes
bytes() -> empty bytes object

Construct an immutable array of bytes from:
  - an iterable yielding integers in range(256)
  - a text string encoded using the specified encoding
  - any object implementing the buffer API.
  - an integerr!  hhh	hzX   b'\xff\xff\xff\xff\xff\xff\x07\xf0\xf7\xf7\x07\xf0\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff'r!  h|X   bytesr!  h3h~h7jA  ubhu)r!  }r!  (hX   wx.lib.agw.aui.auibar.Mondrianr!  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.r!  hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f7afe726210>r!  h|X$   wx.lib.embeddedimage.PyEmbeddedImager!  h3h~h7jA  ubhu)r!  }r!  (hX#   wx.lib.agw.aui.auibar.nb_close_bitsr!  hKh'KhX  bytes(iterable_of_ints) -> bytes
bytes(string, encoding[, errors]) -> bytes
bytes(bytes_or_buffer) -> immutable copy of bytes_or_buffer
bytes(int) -> bytes object of size given by the parameter initialized with null bytes
bytes() -> empty bytes object

Construct an immutable array of bytes from:
  - an iterable yielding integers in range(256)
  - a text string encoded using the specified encoding
  - any object implementing the buffer API.
  - an integerr!  hhh	hzX   b'\xff\xff\xff\xff\x07\xf0\xfb\xef\xdb\xed\x8b\xe8\x1b\xec;\xee\x1b\xec\x8b\xe8\xdb\xed\xfb\xef\x07\xf0\xff\xff\xff\xff\xff\xff'r!  h|X   bytesr!  h3h~h7jA  ubhu)r!  }r!  (hX"   wx.lib.agw.aui.auibar.nb_left_bitsr!  hKh'KhX  bytes(iterable_of_ints) -> bytes
bytes(string, encoding[, errors]) -> bytes
bytes(bytes_or_buffer) -> immutable copy of bytes_or_buffer
bytes(int) -> bytes object of size given by the parameter initialized with null bytes
bytes() -> empty bytes object

Construct an immutable array of bytes from:
  - an iterable yielding integers in range(256)
  - a text string encoded using the specified encoding
  - any object implementing the buffer API.
  - an integerr!  hhh	hzX}   b'\xff\xff\xff\xff\xff\xff\xff\xfe\x7f\xfe?\xfe\x1f\xfe\x0f\xfe\x1f\xfe?\xfe\x7f\xfe\xff\xfe\xff\xff\xff\xff\xff\xff\xff\xff'r!  h|X   bytesr!  h3h~h7jA  ubhu)r!  }r!  (hX"   wx.lib.agw.aui.auibar.nb_list_bitsr!  hKh'KhX  bytes(iterable_of_ints) -> bytes
bytes(string, encoding[, errors]) -> bytes
bytes(bytes_or_buffer) -> immutable copy of bytes_or_buffer
bytes(int) -> bytes object of size given by the parameter initialized with null bytes
bytes() -> empty bytes object

Construct an immutable array of bytes from:
  - an iterable yielding integers in range(256)
  - a text string encoded using the specified encoding
  - any object implementing the buffer API.
  - an integerr!  hhh	hzX   b'\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x0f\xf8\xff\xff\x0f\xf8\x1f\xfc?\xfe\x7f\xff\xff\xff\xff\xff\xff\xff\xff\xff'r!  h|X   bytesr!  h3h~h7jA  ubhu)r!  }r!  (hX#   wx.lib.agw.aui.auibar.nb_right_bitsr!  hKh'KhX  bytes(iterable_of_ints) -> bytes
bytes(string, encoding[, errors]) -> bytes
bytes(bytes_or_buffer) -> immutable copy of bytes_or_buffer
bytes(int) -> bytes object of size given by the parameter initialized with null bytes
bytes() -> empty bytes object

Construct an immutable array of bytes from:
  - an iterable yielding integers in range(256)
  - a text string encoded using the specified encoding
  - any object implementing the buffer API.
  - an integerr!  hhh	hzX   b'\xff\xff\xff\xff\xff\xff\xdf\xff\x9f\xff\x1f\xff\x1f\xfe\x1f\xfc\x1f\xfe\x1f\xff\x9f\xff\xdf\xff\xff\xff\xff\xff\xff\xff\xff\xff'r!  h|X   bytesr!  h3h~h7jA  ubhu)r!  }r!  (hX   wx.lib.agw.aui.auibar.pin_bitsr!  hKh'KhX  bytes(iterable_of_ints) -> bytes
bytes(string, encoding[, errors]) -> bytes
bytes(bytes_or_buffer) -> immutable copy of bytes_or_buffer
bytes(int) -> bytes object of size given by the parameter initialized with null bytes
bytes() -> empty bytes object

Construct an immutable array of bytes from:
  - an iterable yielding integers in range(256)
  - a text string encoded using the specified encoding
  - any object implementing the buffer API.
  - an integerr!  hhh	hzX   b'\xff\xff\xff\xff\xff\xff\x1f\xfc\xdf\xfc\xdf\xfc\xdf\xfc\xdf\xfc\xdf\xfc\x0f\xf8\x7f\xff\x7f\xff\x7f\xff\xff\xff\xff\xff\xff\xff'r!  h|X   bytesr!  h3h~h7jA  ubhu)r!  }r!  (hX"   wx.lib.agw.aui.auibar.restore_bitsr!  hKh'KhX  bytes(iterable_of_ints) -> bytes
bytes(string, encoding[, errors]) -> bytes
bytes(bytes_or_buffer) -> immutable copy of bytes_or_buffer
bytes(int) -> bytes object of size given by the parameter initialized with null bytes
bytes() -> empty bytes object

Construct an immutable array of bytes from:
  - an iterable yielding integers in range(256)
  - a text string encoded using the specified encoding
  - any object implementing the buffer API.
  - an integerr!  hhh	hzX   b'\xff\xff\xff\xff\xff\xff\x1f\xf0\x1f\xf0\xdf\xf7\x07\xf4\x07\xf4\xf7\xf5\xf7\xf1\xf7\xfd\xf7\xfd\x07\xfc\xff\xff\xff\xff\xff\xff'r!  h|X   bytesr!  h3h~h7jA  ubhu)r!  }r!  (hX!   wx.lib.agw.aui.auibar.restore_xpmr!  hKh'KhX   Built-in mutable sequence.

If no argument is given, the constructor creates a new empty list.
The argument must be an iterable if specified.r!  hhh	hzX  [b'16 15 3 1', b'       c None', b'.      c #000000', b'+      c #FFFFFF', b'                ', b'     .......... ', b'     .++++++++. ', b'     .......... ', b'     .++++++++. ', b' ..........+++. ', b' .++++++++.+++. ', b' ..........+++. ', b' .++++++++..... ', b' .++++++++.     ', b' .++++++++.     ', b' .++++++++.     ', b' .++++++++.     ', b' ..........     ', b'                ']r!  h|X   listr!  h3h~h7jA  ubhu)r!  }r!  (hX   wx.lib.agw.aui.auibar.rightr!  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.r!  hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f7afe726710>r!  h|X$   wx.lib.embeddedimage.PyEmbeddedImager!  h3h~h7jA  ubhu)r!  }r!  (hX!   wx.lib.agw.aui.auibar.right_focusr!  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.r!  hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f7afe726750>r!  h|X$   wx.lib.embeddedimage.PyEmbeddedImager!  h3h~h7jA  ubhu)r!  }r!  (hX(   wx.lib.agw.aui.auibar.right_focus_singler!  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.r!  hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f7afe726350>r!  h|X$   wx.lib.embeddedimage.PyEmbeddedImager!  h3h~h7jA  ubhu)r!  }r!  (hX"   wx.lib.agw.aui.auibar.right_singler!  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.r!  hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f7afe726390>r!  h|X$   wx.lib.embeddedimage.PyEmbeddedImager "  h3h~h7jA  ubhu)r"  }r"  (hX,   wx.lib.agw.aui.auibar.SWITCHER_TEXT_MARGIN_Xr"  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r"  hhh	hzX   4r"  h|X   intr"  h3h~h7jA  ubhu)r"  }r"  (hX,   wx.lib.agw.aui.auibar.SWITCHER_TEXT_MARGIN_Yr	"  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r
"  hhh	hzX   1r"  h|X   intr"  h3h~h7jA  ubhu)r
"  }r"  (hX   wx.lib.agw.aui.auibar.tabr"  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.r"  hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f7afe7267d0>r"  h|X$   wx.lib.embeddedimage.PyEmbeddedImager"  h3h~h7jA  ubhu)r"  }r"  (hX'   wx.lib.agw.aui.auibar.tab_active_centerr"  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.r"  hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f7afe73f4d0>r"  h|X$   wx.lib.embeddedimage.PyEmbeddedImager"  h3h~h7jA  ubhu)r"  }r"  (hX%   wx.lib.agw.aui.auibar.tab_active_leftr"  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.r"  hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f7afe73f550>r"  h|X$   wx.lib.embeddedimage.PyEmbeddedImager"  h3h~h7jA  ubhu)r"  }r "  (hX&   wx.lib.agw.aui.auibar.tab_active_rightr!"  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.r""  hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f7afe73f810>r#"  h|X$   wx.lib.embeddedimage.PyEmbeddedImager$"  h3h~h7jA  ubhu)r%"  }r&"  (hX   wx.lib.agw.aui.auibar.tab_closer'"  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.r("  hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f7afe73f9d0>r)"  h|X$   wx.lib.embeddedimage.PyEmbeddedImager*"  h3h~h7jA  ubhu)r+"  }r,"  (hX!   wx.lib.agw.aui.auibar.tab_close_hr-"  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.r."  hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f7afe7260d0>r/"  h|X$   wx.lib.embeddedimage.PyEmbeddedImager0"  h3h~h7jA  ubhu)r1"  }r2"  (hX!   wx.lib.agw.aui.auibar.tab_close_pr3"  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.r4"  hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f7afe726110>r5"  h|X$   wx.lib.embeddedimage.PyEmbeddedImager6"  h3h~h7jA  ubhu)r7"  }r8"  (hX   wx.lib.agw.aui.auibar.tab_focusr9"  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.r:"  hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f7afe726810>r;"  h|X$   wx.lib.embeddedimage.PyEmbeddedImager<"  h3h~h7jA  ubhu)r="  }r>"  (hX&   wx.lib.agw.aui.auibar.tab_focus_singler?"  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.r@"  hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f7afe726490>rA"  h|X$   wx.lib.embeddedimage.PyEmbeddedImagerB"  h3h~h7jA  ubhu)rC"  }rD"  (hX)   wx.lib.agw.aui.auibar.tab_inactive_centerrE"  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.rF"  hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f7afe726150>rG"  h|X$   wx.lib.embeddedimage.PyEmbeddedImagerH"  h3h~h7jA  ubhu)rI"  }rJ"  (hX'   wx.lib.agw.aui.auibar.tab_inactive_leftrK"  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.rL"  hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f7afe726190>rM"  h|X$   wx.lib.embeddedimage.PyEmbeddedImagerN"  h3h~h7jA  ubhu)rO"  }rP"  (hX(   wx.lib.agw.aui.auibar.tab_inactive_rightrQ"  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.rR"  hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f7afe7261d0>rS"  h|X$   wx.lib.embeddedimage.PyEmbeddedImagerT"  h3h~h7jA  ubhu)rU"  }rV"  (hX    wx.lib.agw.aui.auibar.tab_singlerW"  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.rX"  hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f7afe7264d0>rY"  h|X$   wx.lib.embeddedimage.PyEmbeddedImagerZ"  h3h~h7jA  ubhu)r["  }r\"  (hX   wx.lib.agw.aui.auibar.upr]"  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.r^"  hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f7afe726850>r_"  h|X$   wx.lib.embeddedimage.PyEmbeddedImager`"  h3h~h7jA  ubhu)ra"  }rb"  (hX   wx.lib.agw.aui.auibar.up_focusrc"  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.rd"  hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f7afe726890>re"  h|X$   wx.lib.embeddedimage.PyEmbeddedImagerf"  h3h~h7jA  ubhu)rg"  }rh"  (hX%   wx.lib.agw.aui.auibar.up_focus_singleri"  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.rj"  hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f7afe726510>rk"  h|X$   wx.lib.embeddedimage.PyEmbeddedImagerl"  h3h~h7jA  ubhu)rm"  }rn"  (hX   wx.lib.agw.aui.auibar.up_singlero"  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.rp"  hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f7afe726550>rq"  h|X$   wx.lib.embeddedimage.PyEmbeddedImagerr"  h3h~h7jA  ubhu)rs"  }rt"  (hX-   wx.lib.agw.aui.auibar.vertical_border_paddingru"  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4rv"  hhh	hzX   4rw"  h|X   intrx"  h3h~h7jA  ubhu)ry"  }rz"  (hX$   wx.lib.agw.aui.auibar.whidbey_deniedr{"  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.r|"  hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f7afe726e10>r}"  h|X$   wx.lib.embeddedimage.PyEmbeddedImager~"  h3h~h7jA  ubhu)r"  }r"  (hX'   wx.lib.agw.aui.auibar.whidbey_dock_paner"  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.r"  hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f7afe726f10>r"  h|X$   wx.lib.embeddedimage.PyEmbeddedImager"  h3h~h7jA  ubhu)r"  }r"  (hX.   wx.lib.agw.aui.auibar.whidbey_dock_pane_bottomr"  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.r"  hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f7afe726f50>r"  h|X$   wx.lib.embeddedimage.PyEmbeddedImager"  h3h~h7jA  ubhu)r"  }r"  (hX.   wx.lib.agw.aui.auibar.whidbey_dock_pane_centerr"  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.r"  hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f7afe726f90>r"  h|X$   wx.lib.embeddedimage.PyEmbeddedImager"  h3h~h7jA  ubhu)r"  }r"  (hX,   wx.lib.agw.aui.auibar.whidbey_dock_pane_leftr"  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.r"  hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f7afe726fd0>r"  h|X$   wx.lib.embeddedimage.PyEmbeddedImager"  h3h~h7jA  ubhu)r"  }r"  (hX-   wx.lib.agw.aui.auibar.whidbey_dock_pane_rightr"  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.r"  hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f7aef7a5790>r"  h|X$   wx.lib.embeddedimage.PyEmbeddedImager"  h3h~h7jA  ubhu)r"  }r"  (hX+   wx.lib.agw.aui.auibar.whidbey_dock_pane_topr"  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.r"  hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f7aef7a5990>r"  h|X$   wx.lib.embeddedimage.PyEmbeddedImager"  h3h~h7jA  ubhu)r"  }r"  (hX"   wx.lib.agw.aui.auibar.whidbey_downr"  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.r"  hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f7afe726e90>r"  h|X$   wx.lib.embeddedimage.PyEmbeddedImager"  h3h~h7jA  ubhu)r"  }r"  (hX(   wx.lib.agw.aui.auibar.whidbey_down_focusr"  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.r"  hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f7afe726ed0>r"  h|X$   wx.lib.embeddedimage.PyEmbeddedImager"  h3h~h7jA  ubhu)r"  }r"  (hX/   wx.lib.agw.aui.auibar.whidbey_down_focus_singler"  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.r"  hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f7afe726ed0>r"  h|X$   wx.lib.embeddedimage.PyEmbeddedImager"  h3h~h7jA  ubhu)r"  }r"  (hX)   wx.lib.agw.aui.auibar.whidbey_down_singler"  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.r"  hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f7afe726e90>r"  h|X$   wx.lib.embeddedimage.PyEmbeddedImager"  h3h~h7jA  ubhu)r"  }r"  (hX"   wx.lib.agw.aui.auibar.whidbey_leftr"  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.r"  hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f7aef7a5090>r"  h|X$   wx.lib.embeddedimage.PyEmbeddedImager"  h3h~h7jA  ubhu)r"  }r"  (hX(   wx.lib.agw.aui.auibar.whidbey_left_focusr"  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.r"  hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f7aef7a50d0>r"  h|X$   wx.lib.embeddedimage.PyEmbeddedImager"  h3h~h7jA  ubhu)r"  }r"  (hX/   wx.lib.agw.aui.auibar.whidbey_left_focus_singler"  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.r"  hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f7aef7a50d0>r"  h|X$   wx.lib.embeddedimage.PyEmbeddedImager"  h3h~h7jA  ubhu)r"  }r"  (hX)   wx.lib.agw.aui.auibar.whidbey_left_singler"  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.r"  hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f7aef7a5090>r"  h|X$   wx.lib.embeddedimage.PyEmbeddedImager"  h3h~h7jA  ubhu)r"  }r"  (hX#   wx.lib.agw.aui.auibar.whidbey_rightr"  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.r"  hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f7aef7a5050>r"  h|X$   wx.lib.embeddedimage.PyEmbeddedImager"  h3h~h7jA  ubhu)r"  }r"  (hX)   wx.lib.agw.aui.auibar.whidbey_right_focusr"  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.r"  hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f7aef7a5110>r"  h|X$   wx.lib.embeddedimage.PyEmbeddedImager"  h3h~h7jA  ubhu)r"  }r"  (hX0   wx.lib.agw.aui.auibar.whidbey_right_focus_singler"  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.r"  hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f7aef7a5110>r"  h|X$   wx.lib.embeddedimage.PyEmbeddedImager"  h3h~h7jA  ubhu)r"  }r"  (hX*   wx.lib.agw.aui.auibar.whidbey_right_singler"  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.r"  hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f7aef7a5050>r"  h|X$   wx.lib.embeddedimage.PyEmbeddedImager"  h3h~h7jA  ubhu)r"  }r"  (hX    wx.lib.agw.aui.auibar.whidbey_upr"  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.r"  hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f7aef7a5150>r"  h|X$   wx.lib.embeddedimage.PyEmbeddedImager"  h3h~h7jA  ubhu)r"  }r"  (hX&   wx.lib.agw.aui.auibar.whidbey_up_focusr"  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.r"  hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f7aef7a5190>r"  h|X$   wx.lib.embeddedimage.PyEmbeddedImager"  h3h~h7jA  ubhu)r"  }r"  (hX-   wx.lib.agw.aui.auibar.whidbey_up_focus_singler"  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.r"  hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f7aef7a5190>r"  h|X$   wx.lib.embeddedimage.PyEmbeddedImager"  h3h~h7jA  ubhu)r"  }r"  (hX'   wx.lib.agw.aui.auibar.whidbey_up_singler"  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.r #  hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f7aef7a5150>r#  h|X$   wx.lib.embeddedimage.PyEmbeddedImager#  h3h~h7jA  ubhu)r#  }r#  (hX"   wx.lib.agw.aui.auibar.whidbeySizeXr#  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r#  hhh	hzX   43r#  h|X   intr#  h3h~h7jA  ubhu)r	#  }r
#  (hX"   wx.lib.agw.aui.auibar.whidbeySizeYr#  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r#  hhh	hzX   30r
#  h|X   intr#  h3h~h7jA  ubhu)r#  }r#  (hX9   wx.lib.agw.aui.auibar.wxEVT_COMMAND_AUITOOLBAR_BEGIN_DRAGr#  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r#  hhh	hzX   10328r#  h|X   intr#  h3h~h7jA  ubhu)r#  }r#  (hX;   wx.lib.agw.aui.auibar.wxEVT_COMMAND_AUITOOLBAR_MIDDLE_CLICKr#  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r#  hhh	hzX   10327r#  h|X   intr#  h3h~h7jA  ubhu)r#  }r#  (hX=   wx.lib.agw.aui.auibar.wxEVT_COMMAND_AUITOOLBAR_OVERFLOW_CLICKr#  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r#  hhh	hzX   10325r#  h|X   intr #  h3h~h7jA  ubhu)r!#  }r"#  (hX:   wx.lib.agw.aui.auibar.wxEVT_COMMAND_AUITOOLBAR_RIGHT_CLICKr##  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r$#  hhh	hzX   10326r%#  h|X   intr&#  h3h~h7jA  ubhu)r'#  }r(#  (hX<   wx.lib.agw.aui.auibar.wxEVT_COMMAND_AUITOOLBAR_TOOL_DROPDOWNr)#  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r*#  hhh	hzX   10324r+#  h|X   intr,#  h3h~h7jA  ubhu)r-#  }r.#  (hX#   wx.lib.agw.aui.auibar.wxWINDOWCLOSEr/#  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r0#  hhh	hzX   4001r1#  h|X   intr2#  h3h~h7jA  ubhu)r3#  }r4#  (hX&   wx.lib.agw.aui.auibar.wxWINDOWCLOSEALLr5#  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r6#  hhh	hzX   4002r7#  h|X   intr8#  h3h~h7jA  ubhu)r9#  }r:#  (hX"   wx.lib.agw.aui.auibar.wxWINDOWNEXTr;#  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r<#  hhh	hzX   4003r=#  h|X   intr>#  h3h~h7jA  ubhu)r?#  }r@#  (hX"   wx.lib.agw.aui.auibar.wxWINDOWPREVrA#  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4rB#  hhh	hzX   4004rC#  h|X   intrD#  h3h~h7jA  ubej  X;   /home/wxpy/bb2/dist-src-py37/build/wx/lib/agw/aui/auibar.pyrE#  hrXH   /home/wxpy/bb2/dist-src-py37/build/docs/sphinx/wx.lib.agw.aui.auibar.txtrF#  h'Kh3j  hpj  )rG#  }rH#  (j  ]rI#  (X*   wx.lib.agw.aui.auibar.AuiDefaultToolBarArtrJ#  ]rK#  rL#  X    wx.lib.agw.aui.auibar.AuiToolBarrM#  ]rN#  X
   wx.ControlrO#  arP#  X
   wx.ControlrQ#  ]rR#  X	   wx.WindowrS#  arT#  X	   wx.WindowrU#  ]rV#  X
   wx.WindowBaserW#  arX#  X
   wx.WindowBaserY#  ]rZ#  X
   wx.EvtHandlerr[#  ar\#  X
   wx.EvtHandlerr]#  ]r^#  (X	   wx.Objectr_#  X   wx.Trackabler`#  era#  X	   wx.Objectrb#  ]rc#  rd#  X   wx.Trackablere#  ]rf#  rg#  X%   wx.lib.agw.aui.auibar.AuiToolBarEventrh#  ]ri#  X)   wx.lib.agw.aui.auibar.CommandToolBarEventrj#  ark#  X)   wx.lib.agw.aui.auibar.CommandToolBarEventrl#  ]rm#  X   wx.PyCommandEventrn#  aro#  X   wx.PyCommandEventrp#  ]rq#  X   wx.CommandEventrr#  ars#  X   wx.CommandEventrt#  ]ru#  X   wx.Eventrv#  arw#  X   wx.Eventrx#  ]ry#  X	   wx.Objectrz#  ar{#  X$   wx.lib.agw.aui.auibar.AuiToolBarItemr|#  ]r}#  r~#  X+   wx.lib.agw.aui.auibar.ToolbarCommandCapturer#  ]r#  X
   wx.EvtHandlerr#  ar#  ej  ]r#  (X*   wx.lib.agw.aui.auibar.AuiDefaultToolBarArtr#  X    wx.lib.agw.aui.auibar.AuiToolBarr#  X%   wx.lib.agw.aui.auibar.AuiToolBarEventr#  X$   wx.lib.agw.aui.auibar.AuiToolBarItemr#  X)   wx.lib.agw.aui.auibar.CommandToolBarEventr#  X+   wx.lib.agw.aui.auibar.ToolbarCommandCapturer#  ej  jA  ubh7hubh)r#  }r#  (hX   wx.lib.agw.aui.auibookr#  hKhX  `auibook.py` contains a notebook control which implements many features common in
applications with dockable panes. Specifically, :class:`AuiNotebook` implements functionality
which allows the user to rearrange tab order via drag-and-drop, split the tab window
into many different splitter configurations, and toggle through different themes to
customize the control's look and feel.

An effort has been made to try to maintain an API as similar to that of :class:`Notebook`.

The default theme that is used is :class:`~wx.lib.agw.aui.tabart.AuiDefaultTabArt`, which provides a modern, glossy
look and feel. The theme can be changed by calling :meth:`AuiNotebook.SetArtProvider() <AuiNotebook.SetArtProvider>`.r#  hX  # -*- coding: utf-8 -*-
#----------------------------------------------------------------------------
# Name:         auibook.py
# Purpose:
#
# Author:       Andrea Gavana <andrea.gavana@gmail.com>
#
# Created:
# Version:
# Date:         31 March 2009
# Licence:      wxWindows license
# Tags:         phoenix-port, unittest, documented, py3-port
#----------------------------------------------------------------------------
r#  h	h
]r#  (h)r#  }r#  (hX"   wx.lib.agw.aui.auibook.AuiNotebookr#  hKhX  AuiNotebook is a notebook control which implements many features common in applications with dockable panes.
Specifically, AuiNotebook implements functionality which allows the user to rearrange tab
order via drag-and-drop, split the tab window into many different splitter configurations, and toggle
through different themes to customize the control's look and feel.

An effort has been made to try to maintain an API as similar to that of :class:`Notebook`.

The default theme that is used is :class:`~wx.lib.agw.aui.tabart.AuiDefaultTabArt`, which provides a modern, glossy
look and feel. The theme can be changed by calling :meth:`AuiNotebook.SetArtProvider`.r#  hhh	h
]r#  (h#)r#  }r#  (hX+   wx.lib.agw.aui.auibook.AuiNotebook.__init__r#  hKh'KhX~  Default class constructor.

:param wx.Window `parent`: the :class:`AuiNotebook` parent;
:param integer `id`: an identifier for the control: a value of -1 is taken to mean a default;
:param wx.Point `pos`: the control position. A value of (-1, -1) indicates a default position,
 chosen by either the windowing system or wxPython, depending on platform;
:param wx.Size `size`: the control size. A value of (-1, -1) indicates a default size,
 chosen by either the windowing system or wxPython, depending on platform;
:param integer `style`: the underlying :class:`Panel` window style;
:param integer `agwStyle`: the AGW-specific window style. This can be a combination of the following bits:

 ==================================== ==================================
 Flag name                            Description
 ==================================== ==================================
 ``AUI_NB_TOP``                       With this style, tabs are drawn along the top of the notebook
 ``AUI_NB_LEFT``                      With this style, tabs are drawn along the left of the notebook. Not implemented yet.
 ``AUI_NB_RIGHT``                     With this style, tabs are drawn along the right of the notebook. Not implemented yet.
 ``AUI_NB_BOTTOM``                    With this style, tabs are drawn along the bottom of the notebook
 ``AUI_NB_TAB_SPLIT``                 Allows the tab control to be split by dragging a tab
 ``AUI_NB_TAB_MOVE``                  Allows a tab to be moved horizontally by dragging
 ``AUI_NB_TAB_EXTERNAL_MOVE``         Allows a tab to be moved to another tab control
 ``AUI_NB_TAB_FIXED_WIDTH``           With this style, all tabs have the same width
 ``AUI_NB_SCROLL_BUTTONS``            With this style, left and right scroll buttons are displayed
 ``AUI_NB_WINDOWLIST_BUTTON``         With this style, a drop-down list of windows is available
 ``AUI_NB_CLOSE_BUTTON``              With this style, a close button is available on the tab bar
 ``AUI_NB_CLOSE_ON_ACTIVE_TAB``       With this style, a close button is available on the active tab
 ``AUI_NB_CLOSE_ON_ALL_TABS``         With this style, a close button is available on all tabs
 ``AUI_NB_MIDDLE_CLICK_CLOSE``        Allows to close :class:`AuiNotebook` tabs by mouse middle button click
 ``AUI_NB_SUB_NOTEBOOK``              This style is used by :class:`~wx.lib.agw.aui.framemanager.AuiManager` to create automatic AuiNotebooks
 ``AUI_NB_HIDE_ON_SINGLE_TAB``        Hides the tab window if only one tab is present
 ``AUI_NB_SMART_TABS``                Use Smart Tabbing, like ``Alt`` + ``Tab`` on Windows
 ``AUI_NB_USE_IMAGES_DROPDOWN``       Uses images on dropdown window list menu instead of check items
 ``AUI_NB_CLOSE_ON_TAB_LEFT``         Draws the tab close button on the left instead of on the right (a la Camino browser)
 ``AUI_NB_TAB_FLOAT``                 Allows the floating of single tabs. Known limitation: when the notebook is more or less full screen,
                                      tabs cannot be dragged far enough outside of the notebook to become floating pages
 ``AUI_NB_DRAW_DND_TAB``              Draws an image representation of a tab while dragging (on by default)
 ``AUI_NB_ORDER_BY_ACCESS``           Tab navigation order by last access time for the tabs
 ``AUI_NB_NO_TAB_FOCUS``              Don't draw tab focus rectangle
 ==================================== ==================================

 Default value for `agwStyle` is:
 ``AUI_NB_DEFAULT_STYLE`` = ``AUI_NB_TOP`` | ``AUI_NB_TAB_SPLIT`` | ``AUI_NB_TAB_MOVE`` | ``AUI_NB_SCROLL_BUTTONS`` | ``AUI_NB_CLOSE_ON_ACTIVE_TAB`` | ``AUI_NB_MIDDLE_CLICK_CLOSE`` | ``AUI_NB_DRAW_DND_TAB``

:param string `name`: the window name.r#  hhh	h)]r#  (X   parentr#  hhr#  X   idr#  X	   wx.ID_ANYr#  X   -1r#  r#  X   posr#  X   wx.DefaultPositionr#  X   (-1, -1)r#  r#  X   sizer#  X   wx.DefaultSizer#  X   (-1, -1)r#  r#  X   styler#  j  X   0r#  r#  X   agwStyler#  X   AUI_NB_DEFAULT_STYLEr#  X   1059121r#  r#  X   namer#  X
   "AuiNotebook"r#  X   AuiNotebookr#  r#  eh1X   __init__(self, parent, id=wx.ID_ANY, pos=wx.DefaultPosition, size=wx.DefaultSize, style=0, agwStyle=AUI_NB_DEFAULT_STYLE, name="AuiNotebook")r#  h3h4h5X   67r#  h7j#  ubh#)r#  }r#  (hX3   wx.lib.agw.aui.auibook.AuiNotebook.AddControlToPager#  hKh'KhX   Adds a control inside a tab (not in the tab area).

:param integer `page_idx`: the page index;
:param wx.Window `control`: almost any :class:`wx.Window` -derived instance to be located
 inside a tab.r#  hhh	h)]r#  (X   page_idxr#  hhr#  X   controlr#  hhr#  eh1X)   AddControlToPage(self, page_idx, control)r#  h3h4h5X   33r#  h7j#  ubh#)r#  }r#  (hX*   wx.lib.agw.aui.auibook.AuiNotebook.AddPager#  hKh'KhXg  Adds a page. If the `select` parameter is ``True``, calling this will generate a
page change event.

:param wx.Window `page`: the page to be added;
:param string `caption`: specifies the text for the new page;
:param bool `select`: specifies whether the page should be selected;
:param wx.Bitmap `bitmap`: the bitmap to display in the enabled tab;
:param wx.Bitmap `disabled_bitmap`: the bitmap to display in the disabled tab;
:param wx.Window `control`: almost any :class:`wx.Window` -derived instance to be located
 inside a tab;
:param string `tooltip`: the tooltip to display when the mouse hovers over the tab.r#  hhh	h)]r#  (X   pager#  hhr#  X   captionr#  hhr#  X   selectr#  X   Falser#  jB  r#  X   bitmapr#  X
   wx.NullBitmapr#  X*   <wx._core.Bitmap object at 0x7f7afe99ac30>r#  r#  X   disabled_bitmapr#  X
   wx.NullBitmapr#  X*   <wx._core.Bitmap object at 0x7f7afe99ac30>r#  r#  X   controlr#  X   Noner#  X   Noner#  r#  X   tooltipr#  X   ""r#  hr#  eh1Xy   AddPage(self, page, caption, select=False, bitmap=wx.NullBitmap, disabled_bitmap=wx.NullBitmap, control=None, tooltip="")r#  h3h4h5X   17r#  h7j#  ubh#)r#  }r#  (hX3   wx.lib.agw.aui.auibook.AuiNotebook.AddTabAreaButtonr#  hKh'KhX  Adds a button in the tab area.

:param integer `id`: the button identifier. This can be one of the following:

 ==============================  =================================
 Button Identifier               Description
 ==============================  =================================
 ``AUI_BUTTON_CLOSE``            Shows a close button on the tab area
 ``AUI_BUTTON_WINDOWLIST``       Shows a window list button on the tab area
 ``AUI_BUTTON_LEFT``             Shows a left button on the tab area
 ``AUI_BUTTON_RIGHT``            Shows a right button on the tab area
 ==============================  =================================

:param integer `location`: the button location. Can be ``wx.LEFT`` or ``wx.RIGHT``;
:param wx.Bitmap `normal_bitmap`: the bitmap for an enabled tab;
:param wx.Bitmap `disabled_bitmap`: the bitmap for a disabled tab;
:param string `name`: the button name.r#  hhh	h)]r#  (X   idr#  hhr#  X   locationr#  hhr#  X
   normal_bitmapr#  X
   wx.NullBitmapr#  X*   <wx._core.Bitmap object at 0x7f7afe99ac30>r#  r#  X   disabled_bitmapr#  X
   wx.NullBitmapr#  X*   <wx._core.Bitmap object at 0x7f7afe99ac30>r#  r#  X   namer#  X   ""r#  hr#  eh1Xi   AddTabAreaButton(self, id, location, normal_bitmap=wx.NullBitmap, disabled_bitmap=wx.NullBitmap, name="")r#  h3h4h5X   24r#  h7j#  ubh#)r#  }r#  (hX3   wx.lib.agw.aui.auibook.AuiNotebook.AdvanceSelectionr#  hKh'KhX   Cycles through the tabs.

:param bool `forward`: whether to advance forward or backward;
:param bool `wrap`: ``True`` to return to the first tab if we reach the last tab.

:note: The call to this function generates the page changing events.r#  hhh	h)]r#  (X   forwardr#  X   Truer#  h/r#  X   wrapr#  X   Truer#  h/r#  eh1X/   AdvanceSelection(self, forward=True, wrap=True)r#  h3h4h5X   60r#  h7j#  ubh#)r $  }r$  (hX2   wx.lib.agw.aui.auibook.AuiNotebook.AssignImageListr$  hKh'KhXt   Sets the image list for the :class:`AuiNotebook` control.

:param `imageList`: an instance of :class:`wx.ImageList`.r$  hhh	h)]r$  X	   imageListr$  hhr$  ah1X    AssignImageList(self, imageList)r$  h3h4h5j  h7j#  ubh#)r$  }r	$  (hX8   wx.lib.agw.aui.auibook.AuiNotebook.CalculateNewSplitSizer
$  hKh'KhX&   Calculates the size of the new split. r$  hhh	h)]r$  h1X   CalculateNewSplitSize(self)r
$  h3h4h5X   28r$  h7j#  ubh#)r$  }r$  (hX9   wx.lib.agw.aui.auibook.AuiNotebook.CalculateTabCtrlHeightr$  hKh'KhX(   Calculates the tab control area height. r$  hhh	h)]r$  h1X   CalculateTabCtrlHeight(self)r$  h3h4h5X   14r$  h7j#  ubh#)r$  }r$  (hX6   wx.lib.agw.aui.auibook.AuiNotebook.CloneTabAreaButtonsr$  hKh'KhX   Clones the tab area buttons when the :class:`AuiNotebook` is being split.

:see: :meth:`AddTabAreaButton`

:note: Standard buttons for :class:`AuiNotebook` are not cloned, only custom ones.r$  hhh	h)]r$  h1X   CloneTabAreaButtons(self)r$  h3h4h5X   14r$  h7j#  ubh#)r$  }r$  (hX-   wx.lib.agw.aui.auibook.AuiNotebook.DeletePager$  hKh'KhX  Deletes a page at the given index. Calling this method will generate a page
change event.

:param integer `page_idx`: the page index to be deleted.

:note:

 :meth:`DeletePage` removes a tab from the multi-notebook, and destroys the window as well.

:see: :meth:`RemovePage`r $  hhh	h)]r!$  X   page_idxr"$  hhr#$  ah1X   DeletePage(self, page_idx)r$$  h3h4h5X   31r%$  h7j#  ubh#)r&$  }r'$  (hX*   wx.lib.agw.aui.auibook.AuiNotebook.Destroyr($  hKh'KhX  Destroys the window safely.

Use this function instead of the ``del`` operator, since different window
classes can be destroyed differently. Frames and dialogs are not destroyed
immediately when this function is called -- they are added to a list of
windows to be deleted on idle time, when all the window's events have been
processed. This prevents problems with events being sent to non-existent windows.

:return: ``True`` if the window has either been successfully deleted, or
 it has been added to the list of windows pending real deletion.

.. note::

   This method has been added to safely un-initialize the underlying
   :class:`~wx.lib.agw.aui.framemanager.AuiManager` which manages the :class:`AuiNotebook`
   layout (i.e., tab split, re-ordering, tab floating etc...).r)$  hhh	h)]r*$  h1X
   Destroy(self)r+$  h3h4h5X   24r,$  h7j#  ubh#)r-$  }r.$  (hX+   wx.lib.agw.aui.auibook.AuiNotebook.DoSizingr/$  hKh'KhX4   Performs all sizing operations in each tab control. r0$  hhh	h)]r1$  h1X   DoSizing(self)r2$  h3h4h5X   11r3$  h7j#  ubh#)r4$  }r5$  (hX*   wx.lib.agw.aui.auibook.AuiNotebook.EditTabr6$  hKh'KhX   Starts the editing of an item label, sending a ``EVT_AUINOTEBOOK_BEGIN_LABEL_EDIT`` event.

:param integer `page_index`: the page index we want to edit.r7$  hhh	h)]r8$  X
   page_indexr9$  hhr:$  ah1X   EditTab(self, page_index)r;$  h3h4h5X   33r<$  h7j#  ubh#)r=$  }r>$  (hX,   wx.lib.agw.aui.auibook.AuiNotebook.EnableTabr?$  hKh'KhX   Enables/disables a page in the notebook.

:param integer `page_idx`: the page index;
:param bool `enable`: ``True`` to enable the page, ``False`` to disable it.r@$  hhh	h)]rA$  (X   page_idxrB$  hhrC$  X   enablerD$  X   TruerE$  h/rF$  eh1X&   EnableTab(self, page_idx, enable=True)rG$  h3h4h5X   11rH$  h7j#  ubh#)rI$  }rJ$  (hX0   wx.lib.agw.aui.auibook.AuiNotebook.EnsureVisiblerK$  hKh'KhXW   Ensures the input page index `indx` is visible.

:param integer `indx`: the page index.rL$  hhh	h)]rM$  X   indxrN$  hhrO$  ah1X   EnsureVisible(self, indx)rP$  h3h4h5j  h7j#  ubh#)rQ$  }rR$  (hX4   wx.lib.agw.aui.auibook.AuiNotebook.FindNextActiveTabrS$  hKh'KhX   Finds the next active tab (used mainly when :class:`AuiNotebook` has inactive/disabled
tabs in it).

:param integer `idx`: the index of the first (most obvious) tab to check for active status;rT$  hhh	h)]rU$  X   idxrV$  hhrW$  ah1X   FindNextActiveTab(self, idx)rX$  h3h4h5X   10rY$  h7j#  ubh#)rZ$  }r[$  (hX*   wx.lib.agw.aui.auibook.AuiNotebook.FindTabr\$  hKh'KhX   Finds the tab control that currently contains the window as well
as the index of the window in the tab control. It returns ``True`` if the
window was found, otherwise ``False``.

:param `page`: an instance of :class:`AuiNotebookPage`.r]$  hhh	h)]r^$  X   pager_$  hhr`$  ah1X   FindTab(self, page)ra$  h3h4h5X   26rb$  h7j#  ubh#)rc$  }rd$  (hX,   wx.lib.agw.aui.auibook.AuiNotebook.FloatPagere$  hKh'KhX   Float the page in `page_index` by reparenting it to a floating frame.

:param integer `page_index`: the index of the page to be floated.

.. warning::

   When the notebook is more or less full screen, tabs cannot be dragged far
   enough outside of the notebook to become floating pages.rf$  hhh	h)]rg$  X
   page_indexrh$  hhri$  ah1X   FloatPage(self, page_index)rj$  h3h4h5X   76rk$  h7j#  ubh#)rl$  }rm$  (hX3   wx.lib.agw.aui.auibook.AuiNotebook.GetActiveTabCtrlrn$  hKh'KhXe   Returns the active tab control. It is called to determine which control
gets new windows being added.ro$  hhh	h)]rp$  h1X   GetActiveTabCtrl(self)rq$  h3h4h5X   38rr$  h7j#  ubh#)rs$  }rt$  (hX8   wx.lib.agw.aui.auibook.AuiNotebook.GetAGWWindowStyleFlagru$  hKh'KhX   Returns the AGW-specific style of the window.

:see: :meth:`SetAGWWindowStyleFlag` for a list of possible AGW-specific window styles.rv$  hhh	h)]rw$  h1X   GetAGWWindowStyleFlag(self)rx$  h3h4h5j  h7j#  ubh#)ry$  }rz$  (hX1   wx.lib.agw.aui.auibook.AuiNotebook.GetArtProviderr{$  hKh'KhX%   Returns the associated art provider. r|$  hhh	h)]r}$  h1X   GetArtProvider(self)r~$  h3h4h5hIh7j#  ubh#)r$  }r$  (hX0   wx.lib.agw.aui.auibook.AuiNotebook.GetAuiManagerr$  hKh'KhXI   Returns the associated :class:`~wx.lib.agw.aui.framemanager.AuiManager`. r$  hhh	h)]r$  h1X   GetAuiManager(self)r$  h3h4h5hIh7j#  ubh#)r$  }r$  (hX1   wx.lib.agw.aui.auibook.AuiNotebook.GetCurrentPager$  hKh'KhXU   Returns the currently active page (not the index), or ``None`` if none was selected. r$  hhh	h)]r$  h1X   GetCurrentPage(self)r$  h3h4h5j~  h7j#  ubh#)r$  }r$  (hX3   wx.lib.agw.aui.auibook.AuiNotebook.GetDefaultBorderr$  hKh'KhX;   Returns the default border style for :class:`AuiNotebook`. r$  hhh	h)]r$  h1X   GetDefaultBorder(self)r$  h3h4h5hIh7j#  ubh#)r$  }r$  (hX-   wx.lib.agw.aui.auibook.AuiNotebook.GetEnabledr$  hKh'KhXr   Returns whether the page specified by the index `page_idx` is enabled.

:param integer `page_idx`: the page index.r$  hhh	h)]r$  X   page_idxr$  hhr$  ah1X   GetEnabled(self, page_idx)r$  h3h4h5j  h7j#  ubh#)r$  }r$  (hX9   wx.lib.agw.aui.auibook.AuiNotebook.GetHeightForPageHeightr$  hKh'KhXm   Gets the height of the notebook for a given page height.

:param integer `pageHeight`: the given page height.r$  hhh	h)]r$  X
   pageHeightr$  hhr$  ah1X(   GetHeightForPageHeight(self, pageHeight)r$  h3h4h5X   13r$  h7j#  ubh#)r$  }r$  (hX,   wx.lib.agw.aui.auibook.AuiNotebook.GetHiddenr$  hKh'KhXq   Returns whether the page specified by the index `page_idx` is hidden.

:param integer `page_idx`: the page index.r$  hhh	h)]r$  X   page_idxr$  hhr$  ah1X   GetHidden(self, page_idx)r$  h3h4h5j  h7j#  ubh#)r$  }r$  (hX/   wx.lib.agw.aui.auibook.AuiNotebook.GetImageListr$  hKh'KhX,   Returns the associated image list (if any). r$  hhh	h)]r$  h1X   GetImageList(self)r$  h3h4h5hIh7j#  ubh#)r$  }r$  (hX4   wx.lib.agw.aui.auibook.AuiNotebook.GetMinMaxTabWidthr$  hKh'KhX!  Returns the minimum and the maximum tab widths for :class:`AuiNotebook` when the
``AUI_NB_TAB_FIXED_WIDTH`` style is defined.

:note: Minimum and maximum tabs widths are used only when the ``AUI_NB_TAB_FIXED_WIDTH``
 style is present.

:see: :meth:`SetMinMaxTabWidth` for more information.r$  hhh	h)]r$  h1X   GetMinMaxTabWidth(self)r$  h3h4h5X   13r$  h7j#  ubh#)r$  }r$  (hX*   wx.lib.agw.aui.auibook.AuiNotebook.GetPager$  hKh'KhXZ   Returns the page specified by the given index.

:param integer `page_idx`: the page index.r$  hhh	h)]r$  X   page_idxr$  hhr$  ah1X   GetPage(self, page_idx)r$  h3h4h5X   12r$  h7j#  ubh#)r$  }r$  (hX0   wx.lib.agw.aui.auibook.AuiNotebook.GetPageBitmapr$  hKh'KhXP   Returns the tab bitmap for the page.

:param integer `page_idx`: the page index.r$  hhh	h)]r$  X   page_idxr$  hhr$  ah1X   GetPageBitmap(self, page_idx)r$  h3h4h5X   14r$  h7j#  ubh#)r$  }r$  (hX/   wx.lib.agw.aui.auibook.AuiNotebook.GetPageCountr$  hKh'KhX-   Returns the number of pages in the notebook. r$  hhh	h)]r$  h1X   GetPageCount(self)r$  h3h4h5hIh7j#  ubh#)r$  }r$  (hX/   wx.lib.agw.aui.auibook.AuiNotebook.GetPageImager$  hKh'KhXy   Returns the image index for the given page.

:param integer `page`: the given page for which to retrieve the image index.r$  hhh	h)]r$  X   pager$  hhr$  ah1X   GetPageImage(self, page)r$  h3h4h5X   21r$  h7j#  ubh#)r$  }r$  (hX/   wx.lib.agw.aui.auibook.AuiNotebook.GetPageIndexr$  hKh'KhX   Returns the page index for the specified window. If the window is not
found in the notebook, ``wx.NOT_FOUND`` is returned.

:param wx.Window `page_wnd`: the window we are looking for.r$  hhh	h)]r$  X   page_wndr$  hhr$  ah1X   GetPageIndex(self, page_wnd)r$  h3h4h5X   10r$  h7j#  ubh#)r$  }r$  (hX.   wx.lib.agw.aui.auibook.AuiNotebook.GetPageInfor$  hKh'KhX}   Returns the :class:`AuiNotebookPage` info structure specified by the given index.

:param integer `page_idx`: the page index.r$  hhh	h)]r$  X   page_idxr$  hhr$  ah1X   GetPageInfo(self, page_idx)r$  h3h4h5X   12r$  h7j#  ubh#)r$  }r$  (hX.   wx.lib.agw.aui.auibook.AuiNotebook.GetPageTextr$  hKh'KhXO   Returns the tab label for the page.

:param integer `page_idx`: the page index.r$  hhh	h)]r$  X   page_idxr$  hhr$  ah1X   GetPageText(self, page_idx)r$  h3h4h5X   14r$  h7j#  ubh#)r$  }r$  (hX4   wx.lib.agw.aui.auibook.AuiNotebook.GetPageTextColourr$  hKh'KhXU   Returns the tab text colour for the page.

:param integer `page_idx`: the page index.r$  hhh	h)]r$  X   page_idxr$  hhr$  ah1X!   GetPageTextColour(self, page_idx)r$  h3h4h5X   14r$  h7j#  ubh#)r$  }r$  (hX1   wx.lib.agw.aui.auibook.AuiNotebook.GetPageTooltipr$  hKh'KhXQ   Returns the tab tooltip for the page.

:param integer `page_idx`: the page index.r$  hhh	h)]r %  X   page_idxr%  hhr%  ah1X   GetPageTooltip(self, page_idx)r%  h3h4h5X   13r%  h7j#  ubh#)r%  }r%  (hX7   wx.lib.agw.aui.auibook.AuiNotebook.GetSashDClickUnsplitr%  hKh'KhXj   Returns whether a splitted :class:`AuiNotebook` can be unsplitted by double-clicking
on the splitter sash.r%  hhh	h)]r	%  h1X   GetSashDClickUnsplit(self)r
%  h3h4h5j~  h7j#  ubh#)r%  }r%  (hX/   wx.lib.agw.aui.auibook.AuiNotebook.GetSelectionr
%  hKh'KhXL   Returns the index of the currently active page, or -1 if none was selected. r%  hhh	h)]r%  h1X   GetSelection(self)r%  h3h4h5hIh7j#  ubh#)r%  }r%  (hX4   wx.lib.agw.aui.auibook.AuiNotebook.GetShownPageCountr%  hKh'KhX3   Returns the number of pages shown in the notebook. r%  hhh	h)]r%  h1X   GetShownPageCount(self)r%  h3h4h5h6h7j#  ubh#)r%  }r%  (hX2   wx.lib.agw.aui.auibook.AuiNotebook.GetTabContainerr%  hKh'KhX2   Returns the instance of :class:`AuiTabContainer`. r%  hhh	h)]r%  h1X   GetTabContainer(self)r%  h3h4h5hIh7j#  ubh#)r%  }r%  (hX6   wx.lib.agw.aui.auibook.AuiNotebook.GetTabCtrlFromPointr%  hKh'KhXZ   Returns the tab control at the specified point.

:param wx.Point `pt`: the mouse location.r %  hhh	h)]r!%  X   ptr"%  hhr#%  ah1X   GetTabCtrlFromPoint(self, pt)r$%  h3h4h5X   20r%%  h7j#  ubh#)r&%  }r'%  (hX3   wx.lib.agw.aui.auibook.AuiNotebook.GetTabCtrlHeightr(%  hKh'KhX    Returns the tab control height. r)%  hhh	h)]r*%  h1X   GetTabCtrlHeight(self)r+%  h3h4h5hIh7j#  ubh#)r,%  }r-%  (hX9   wx.lib.agw.aui.auibook.AuiNotebook.GetTabFrameFromTabCtrlr.%  hKh'KhXl   Returns the tab frame associated with a tab control.

:param `tab_ctrl`: an instance of :class:`AuiTabCtrl`.r/%  hhh	h)]r0%  X   tab_ctrlr1%  hhr2%  ah1X&   GetTabFrameFromTabCtrl(self, tab_ctrl)r3%  h3h4h5X   20r4%  h7j#  ubh#)r5%  }r6%  (hX8   wx.lib.agw.aui.auibook.AuiNotebook.GetTabFrameFromWindowr7%  hKh'KhX   Returns the tab frame associated with a window.

:param wx.Window `wnd`: the window for which we want to locate the :class:`TabFrame`.r8%  hhh	h)]r9%  X   wndr:%  hhr;%  ah1X    GetTabFrameFromWindow(self, wnd)r<%  h3h4h5X   19r=%  h7j#  ubh#)r>%  }r?%  (hX1   wx.lib.agw.aui.auibook.AuiNotebook.HasCloseButtonr@%  hKh'KhX   Returns whether a tab displays a close button or not.

:param integer `page_idx`: the page index.

:note: This can only be called if ``AUI_NB_CLOSE_ON_ALL_TABS`` is specified.rA%  hhh	h)]rB%  X   page_idxrC%  hhrD%  ah1X   HasCloseButton(self, page_idx)rE%  h3h4h5X   15rF%  h7j#  ubh#)rG%  }rH%  (hX3   wx.lib.agw.aui.auibook.AuiNotebook.HasMultiplePagesrI%  hKh'KhX  This method should be overridden to return ``True`` if this window has multiple pages. All
standard class with multiple pages such as :class:`Notebook`, :class:`Listbook` and :class:`Treebook`
already override it to return ``True`` and user-defined classes with similar behaviour
should do it as well to allow the library to handle such windows appropriately.

:note: Overridden from :class:`Panel`.rJ%  hhh	h)]rK%  h1X   HasMultiplePages(self)rL%  h3h4h5X   12rM%  h7j#  ubh#)rN%  }rO%  (hX.   wx.lib.agw.aui.auibook.AuiNotebook.HideAllTabsrP%  hKh'KhXf   Hides all tabs on the :class:`AuiNotebook` control.

:param bool `hidden`: if ``True`` hides all tabs.rQ%  hhh	h)]rR%  X   hiddenrS%  X   TruerT%  h/rU%  ah1X   HideAllTabs(self, hidden=True)rV%  h3h4h5j  h7j#  ubh#)rW%  }rX%  (hX+   wx.lib.agw.aui.auibook.AuiNotebook.HidePagerY%  hKh'KhX   Sets whether a page is hidden.

:param integer `page_idx`: the page index;
:param bool `hidden`: ``True`` to hide the page, ``False`` to show it.rZ%  hhh	h)]r[%  (X   page_idxr\%  hhr]%  X   hiddenr^%  X   Truer_%  h/r`%  eh1X%   HidePage(self, page_idx, hidden=True)ra%  h3h4h5X   82rb%  h7j#  ubh#)rc%  }rd%  (hX/   wx.lib.agw.aui.auibook.AuiNotebook.InitNotebookre%  hKh'KhX   Contains common initialization code called by all constructors.

:param integer `agwStyle`: the notebook style.

:see: :meth:`~AuiNotebook.__init__` for a list of available `agwStyle` bits.rf%  hhh	h)]rg%  X   agwStylerh%  hhri%  ah1X   InitNotebook(self, agwStyle)rj%  h3h4h5X   64rk%  h7j#  ubh#)rl%  }rm%  (hX-   wx.lib.agw.aui.auibook.AuiNotebook.InsertPagern%  hKh'KhX  This is similar to :meth:`AddPage`, but allows the ability to specify the insert location.

:param integer `page_idx`: specifies the position for the new page;
:param wx.Window `page`: the page to be added;
:param string `caption`: specifies the text for the new page;
:param bool `select`: specifies whether the page should be selected;
:param wx.Bitmap `bitmap`: the bitmap to display in the enabled tab;
:param wx.Bitmap `disabled_bitmap`: the bitmap to display in the disabled tab;
:param wx.Window `control`: almost any :class:`wx.Window` -derived instance to be located
 inside a ;
:param string `tooltip`: the tooltip to display when the mouse hovers over the tab.ro%  hhh	h)]rp%  (X   page_idxrq%  hhrr%  X   pagers%  hhrt%  X   captionru%  hhrv%  X   selectrw%  X   Falserx%  jB  ry%  X   bitmaprz%  X
   wx.NullBitmapr{%  X*   <wx._core.Bitmap object at 0x7f7afe99ac30>r|%  r}%  X   disabled_bitmapr~%  X
   wx.NullBitmapr%  X*   <wx._core.Bitmap object at 0x7f7afe99ac30>r%  r%  X   controlr%  X   Noner%  X   Noner%  r%  X   tooltipr%  X   ""r%  hr%  eh1X   InsertPage(self, page_idx, page, caption, select=False, bitmap=wx.NullBitmap, disabled_bitmap=wx.NullBitmap, control=None, tooltip="")r%  h3h4h5X   81r%  h7j#  ubh#)r%  }r%  (hX;   wx.lib.agw.aui.auibook.AuiNotebook.IsMouseWellOutsideWindowr%  hKh'KhXU   Returns whether the mouse is well outside the :class:`AuiNotebook` screen rectangle. r%  hhh	h)]r%  h1X   IsMouseWellOutsideWindow(self)r%  h3h4h5j~  h7j#  ubh#)r%  }r%  (hX.   wx.lib.agw.aui.auibook.AuiNotebook.IsRenamabler%  hKh'KhX   Returns whether a tab can be renamed or not.

:param integer `page_idx`: the page index.

:returns: ``True`` is a page can be renamed, ``False`` otherwise.r%  hhh	h)]r%  X   page_idxr%  hhr%  ah1X   IsRenamable(self, page_idx)r%  h3h4h5X   15r%  h7j#  ubh#)r%  }r%  (hX2   wx.lib.agw.aui.auibook.AuiNotebook.LoadPerspectiver%  hKh'KhX   Loads a layout which was saved with :meth:`SavePerspective`.

:param string `layout`: a string which contains a saved :class:`AuiNotebook` layout.r%  hhh	h)]r%  X   layoutr%  hhr%  ah1X   LoadPerspective(self, layout)r%  h3h4h5X   115r%  h7j#  ubh#)r%  }r%  (hX2   wx.lib.agw.aui.auibook.AuiNotebook.NotebookPreviewr%  hKh'KhX   Generates a preview of all the pages in the notebook (MSW and GTK only).

:param integer `thumbnail_size`: the maximum size of every page thumbnail
 (default=200 pixels).

:note: this functionality is currently unavailable on wxMAC.r%  hhh	h)]r%  X   thumbnail_sizer%  X   200r%  X   200r%  r%  ah1X)   NotebookPreview(self, thumbnail_size=200)r%  h3h4h5X   56r%  h7j#  ubh#)r%  }r%  (hX7   wx.lib.agw.aui.auibook.AuiNotebook.OnChildFocusNotebookr%  hKh'KhX   Handles the ``wx.EVT_CHILD_FOCUS`` event for :class:`AuiNotebook`.

:param `event`: a :class:`ChildFocusEvent` event to be processed.r%  hhh	h)]r%  X   eventr%  hhr%  ah1X!   OnChildFocusNotebook(self, event)r%  h3h4h5X   23r%  h7j#  ubh#)r%  }r%  (hX6   wx.lib.agw.aui.auibook.AuiNotebook.OnCloseFloatingPager%  hKh'KhX   Handles the ``wx.EVT_CLOSE`` event for a floating page in :class:`AuiNotebook`.

:param `event`: a :class:`CloseEvent` event to be processed.r%  hhh	h)]r%  X   eventr%  hhr%  ah1X    OnCloseFloatingPage(self, event)r%  h3h4h5X   32r%  h7j#  ubh#)r%  }r%  (hX:   wx.lib.agw.aui.auibook.AuiNotebook.OnNavigationKeyNotebookr%  hKh'KhX   Handles the ``wx.EVT_NAVIGATION_KEY`` event for :class:`AuiNotebook`.

:param `event`: a :class:`NavigationKeyEvent` event to be processed.r%  hhh	h)]r%  X   eventr%  hhr%  ah1X$   OnNavigationKeyNotebook(self, event)r%  h3h4h5X   85r%  h7j#  ubh#)r%  }r%  (hX1   wx.lib.agw.aui.auibook.AuiNotebook.OnRenameAcceptr%  hKh'KhX   Called by :class:`TabTextCtrl`, to accept the changes and to send the
``EVT_AUINOTEBOOK_END_LABEL_EDIT`` event.

:param integer `page_index`: the page index in the notebook;
:param string `value`: the new label for the tab.r%  hhh	h)]r%  (X
   page_indexr%  hhr%  X   valuer%  hhr%  eh1X'   OnRenameAccept(self, page_index, value)r%  h3h4h5X   17r%  h7j#  ubh#)r%  }r%  (hX4   wx.lib.agw.aui.auibook.AuiNotebook.OnRenameCancelledr%  hKh'KhX   Called by :class:`TabTextCtrl`, to cancel the changes and to send the
``EVT_AUINOTEBOOK_END_LABEL_EDIT`` event.

:param integer `page_index`: the page index in the notebook.r%  hhh	h)]r%  X
   page_indexr%  hhr%  ah1X#   OnRenameCancelled(self, page_index)r%  h3h4h5X   17r%  h7j#  ubh#)r%  }r%  (hX)   wx.lib.agw.aui.auibook.AuiNotebook.OnSizer%  hKh'KhX{   Handles the ``wx.EVT_SIZE`` event for :class:`AuiNotebook`.

:param `event`: a :class:`wx.SizeEvent` event to be processed.r%  hhh	h)]r%  X   eventr%  hhr%  ah1X   OnSize(self, event)r%  h3h4h5X   10r%  h7j#  ubh#)r%  }r%  (hX1   wx.lib.agw.aui.auibook.AuiNotebook.OnTabBeginDragr%  hKh'KhX   Handles the ``EVT_AUINOTEBOOK_BEGIN_DRAG`` event for :class:`AuiNotebook`.

:param `event`: a :class:`AuiNotebookEvent` event to be processed.r%  hhh	h)]r%  X   eventr%  hhr%  ah1X   OnTabBeginDrag(self, event)r%  h3h4h5X   13r%  h7j#  ubh#)r%  }r%  (hX0   wx.lib.agw.aui.auibook.AuiNotebook.OnTabBgDClickr%  hKh'KhX   Handles the ``EVT_AUINOTEBOOK_BG_DCLICK`` event for :class:`AuiNotebook`.

:param `event`: a :class:`AuiNotebookEvent` event to be processed.r%  hhh	h)]r%  X   eventr%  hhr%  ah1X   OnTabBgDClick(self, event)r%  h3h4h5X   15r%  h7j#  ubh#)r%  }r%  (hX.   wx.lib.agw.aui.auibook.AuiNotebook.OnTabButtonr%  hKh'KhX   Handles the ``EVT_AUINOTEBOOK_BUTTON`` event for :class:`AuiNotebook`.

:param `event`: a :class:`AuiNotebookEvent` event to be processed.r%  hhh	h)]r%  X   eventr%  hhr%  ah1X   OnTabButton(self, event)r%  h3h4h5X   86r &  h7j#  ubh#)r&  }r&  (hX2   wx.lib.agw.aui.auibook.AuiNotebook.OnTabCancelDragr&  hKh'KhX   Handles the ``EVT_AUINOTEBOOK_CANCEL_DRAG`` event for :class:`AuiNotebook`.

:param `event`: a :class:`AuiNotebookEvent` event to be processed.r&  hhh	h)]r&  X   eventr&  hhr&  ah1X   OnTabCancelDrag(self, event)r&  h3h4h5X   17r	&  h7j#  ubh#)r
&  }r&  (hX/   wx.lib.agw.aui.auibook.AuiNotebook.OnTabClickedr&  hKh'KhX   Handles the ``EVT_AUINOTEBOOK_PAGE_CHANGING`` event for :class:`AuiNotebook`.

:param `event`: a :class:`AuiNotebookEvent` event to be processed.r
&  hhh	h)]r&  X   eventr&  hhr&  ah1X   OnTabClicked(self, event)r&  h3h4h5X   18r&  h7j#  ubh#)r&  }r&  (hX.   wx.lib.agw.aui.auibook.AuiNotebook.OnTabDClickr&  hKh'KhX   Handles the ``EVT_AUINOTEBOOK_TAB_DCLICK`` event for :class:`AuiNotebook`.

:param `event`: a :class:`AuiNotebookEvent` event to be processed.r&  hhh	h)]r&  X   eventr&  hhr&  ah1X   OnTabDClick(self, event)r&  h3h4h5X   21r&  h7j#  ubh#)r&  }r&  (hX2   wx.lib.agw.aui.auibook.AuiNotebook.OnTabDragMotionr&  hKh'KhX   Handles the ``EVT_AUINOTEBOOK_DRAG_MOTION`` event for :class:`AuiNotebook`.

:param `event`: a :class:`AuiNotebookEvent` event to be processed.r&  hhh	h)]r &  X   eventr!&  hhr"&  ah1X   OnTabDragMotion(self, event)r#&  h3h4h5X   142r$&  h7j#  ubh#)r%&  }r&&  (hX/   wx.lib.agw.aui.auibook.AuiNotebook.OnTabEndDragr'&  hKh'KhX   Handles the ``EVT_AUINOTEBOOK_END_DRAG`` event for :class:`AuiNotebook`.

:param `event`: a :class:`AuiNotebookEvent` event to be processed.r(&  hhh	h)]r)&  X   eventr*&  hhr+&  ah1X   OnTabEndDrag(self, event)r,&  h3h4h5X   224r-&  h7j#  ubh#)r.&  }r/&  (hX2   wx.lib.agw.aui.auibook.AuiNotebook.OnTabMiddleDownr0&  hKh'KhX   Handles the ``EVT_AUINOTEBOOK_TAB_MIDDLE_DOWN`` event for :class:`AuiNotebook`.

:param `event`: a :class:`AuiNotebookEvent` event to be processed.r1&  hhh	h)]r2&  X   eventr3&  hhr4&  ah1X   OnTabMiddleDown(self, event)r5&  h3h4h5X   19r6&  h7j#  ubh#)r7&  }r8&  (hX0   wx.lib.agw.aui.auibook.AuiNotebook.OnTabMiddleUpr9&  hKh'KhX   Handles the ``EVT_AUINOTEBOOK_TAB_MIDDLE_UP`` event for :class:`AuiNotebook`.

:param `event`: a :class:`AuiNotebookEvent` event to be processed.r:&  hhh	h)]r;&  X   eventr<&  hhr=&  ah1X   OnTabMiddleUp(self, event)r>&  h3h4h5X   34r?&  h7j#  ubh#)r@&  }rA&  (hX1   wx.lib.agw.aui.auibook.AuiNotebook.OnTabRightDownrB&  hKh'KhX   Handles the ``EVT_AUINOTEBOOK_TAB_RIGHT_DOWN`` event for :class:`AuiNotebook`.

:param `event`: a :class:`AuiNotebookEvent` event to be processed.rC&  hhh	h)]rD&  X   eventrE&  hhrF&  ah1X   OnTabRightDown(self, event)rG&  h3h4h5X   19rH&  h7j#  ubh#)rI&  }rJ&  (hX/   wx.lib.agw.aui.auibook.AuiNotebook.OnTabRightUprK&  hKh'KhX   Handles the ``EVT_AUINOTEBOOK_TAB_RIGHT_UP`` event for :class:`AuiNotebook`.

:param `event`: a :class:`AuiNotebookEvent` event to be processed.rL&  hhh	h)]rM&  X   eventrN&  hhrO&  ah1X   OnTabRightUp(self, event)rP&  h3h4h5X   19rQ&  h7j#  ubh#)rR&  }rS&  (hX-   wx.lib.agw.aui.auibook.AuiNotebook.ReDockPagerT&  hKh'KhX   Re-docks a floating :class:`AuiNotebook` tab in the original position, when possible.

:param `pane`: an instance of :class:`~wx.lib.agw.aui.framemanager.AuiPaneInfo`.rU&  hhh	h)]rV&  X   panerW&  hhrX&  ah1X   ReDockPage(self, pane)rY&  h3h4h5X   27rZ&  h7j#  ubh#)r[&  }r\&  (hX8   wx.lib.agw.aui.auibook.AuiNotebook.RemoveControlFromPager]&  hKh'KhXa   Removes a control from a tab (not from the tab area).

:param integer `page_idx`: the page index.r^&  hhh	h)]r_&  X   page_idxr`&  hhra&  ah1X%   RemoveControlFromPage(self, page_idx)rb&  h3h4h5X   32rc&  h7j#  ubh#)rd&  }re&  (hX7   wx.lib.agw.aui.auibook.AuiNotebook.RemoveEmptyTabFramesrf&  hKh'KhX"   Removes all the empty tab frames. rg&  hhh	h)]rh&  h1X   RemoveEmptyTabFrames(self)ri&  h3h4h5X   40rj&  h7j#  ubh#)rk&  }rl&  (hX-   wx.lib.agw.aui.auibook.AuiNotebook.RemovePagerm&  hKh'KhX   Removes a page, without deleting the window pointer.

:param integer `page_idx`: the page index to be removed.

:note:

 :meth:`RemovePage` removes a tab from the multi-notebook, but does not destroy the window.

:see: :meth:`DeletePage`rn&  hhh	h)]ro&  X   page_idxrp&  hhrq&  ah1X   RemovePage(self, page_idx)rr&  h3h4h5X   49rs&  h7j#  ubh#)rt&  }ru&  (hX6   wx.lib.agw.aui.auibook.AuiNotebook.RemoveTabAreaButtonrv&  hKh'KhX   Removes a button from the tab area.

:param integer `id`: the button identifier.

:see: :meth:`AddTabAreaButton` for a list of button identifiers.rw&  hhh	h)]rx&  X   idry&  hhrz&  ah1X   RemoveTabAreaButton(self, id)r{&  h3h4h5X   12r|&  h7j#  ubh#)r}&  }r~&  (hX2   wx.lib.agw.aui.auibook.AuiNotebook.ReparentControlr&  hKh'KhX   Reparents a control added inside a tab.

:param wx.Window `control`: almost any :class:`wx.Window` -derived instance to be located
 inside a tab;
:param `dest_tabs`: the destination :class:`AuiTabCtrl`.r&  hhh	h)]r&  (X   controlr&  hhr&  X	   dest_tabsr&  hhr&  eh1X)   ReparentControl(self, control, dest_tabs)r&  h3h4h5X   12r&  h7j#  ubh#)r&  }r&  (hX3   wx.lib.agw.aui.auibook.AuiNotebook.ResetTextControlr&  hKh'KhXB   Called by :class:`TabTextCtrl` when it marks itself for deletion. r&  hhh	h)]r&  h1X   ResetTextControl(self)r&  h3h4h5X   12r&  h7j#  ubh#)r&  }r&  (hX2   wx.lib.agw.aui.auibook.AuiNotebook.SavePerspectiver&  hKh'KhX1  Saves the entire user interface layout into an encoded string, which can then
be stored by the application (probably using :class:`Config <ConfigBase>`). When a perspective
is restored using :meth:`LoadPerspective`, the entire user interface will return
to the state it was when the perspective was saved.r&  hhh	h)]r&  h1X   SavePerspective(self)r&  h3h4h5X   49r&  h7j#  ubh#)r&  }r&  (hX8   wx.lib.agw.aui.auibook.AuiNotebook.SetAGWWindowStyleFlagr&  hKh'KhXO  Sets the AGW-specific style of the window.

:param integer `agwStyle`: the new window style. This can be a combination of the following bits:

 ==================================== ==================================
 Flag name                            Description
 ==================================== ==================================
 ``AUI_NB_TOP``                       With this style, tabs are drawn along the top of the notebook
 ``AUI_NB_LEFT``                      With this style, tabs are drawn along the left of the notebook. Not implemented yet.
 ``AUI_NB_RIGHT``                     With this style, tabs are drawn along the right of the notebook. Not implemented yet.
 ``AUI_NB_BOTTOM``                    With this style, tabs are drawn along the bottom of the notebook
 ``AUI_NB_TAB_SPLIT``                 Allows the tab control to be split by dragging a tab
 ``AUI_NB_TAB_MOVE``                  Allows a tab to be moved horizontally by dragging
 ``AUI_NB_TAB_EXTERNAL_MOVE``         Allows a tab to be moved to another tab control
 ``AUI_NB_TAB_FIXED_WIDTH``           With this style, all tabs have the same width
 ``AUI_NB_SCROLL_BUTTONS``            With this style, left and right scroll buttons are displayed
 ``AUI_NB_WINDOWLIST_BUTTON``         With this style, a drop-down list of windows is available
 ``AUI_NB_CLOSE_BUTTON``              With this style, a close button is available on the tab bar
 ``AUI_NB_CLOSE_ON_ACTIVE_TAB``       With this style, a close button is available on the active tab
 ``AUI_NB_CLOSE_ON_ALL_TABS``         With this style, a close button is available on all tabs
 ``AUI_NB_MIDDLE_CLICK_CLOSE``        Allows to close :class:`AuiNotebook` tabs by mouse middle button click
 ``AUI_NB_SUB_NOTEBOOK``              This style is used by :class:`~wx.lib.agw.aui.framemanager.AuiManager` to create automatic AuiNotebooks
 ``AUI_NB_HIDE_ON_SINGLE_TAB``        Hides the tab window if only one tab is present
 ``AUI_NB_SMART_TABS``                Use Smart Tabbing, like ``Alt`` + ``Tab`` on Windows
 ``AUI_NB_USE_IMAGES_DROPDOWN``       Uses images on dropdown window list menu instead of check items
 ``AUI_NB_CLOSE_ON_TAB_LEFT``         Draws the tab close button on the left instead of on the right (a la Camino browser)
 ``AUI_NB_TAB_FLOAT``                 Allows the floating of single tabs. Known limitation: when the notebook is more or less full screen,
                                      tabs cannot be dragged far enough outside of the notebook to become floating pages
 ``AUI_NB_DRAW_DND_TAB``              Draws an image representation of a tab while dragging (on by default)
 ``AUI_NB_ORDER_BY_ACCESS``           Tab navigation order by last access time for the tabs
 ``AUI_NB_NO_TAB_FOCUS``              Don't draw tab focus rectangle
 ==================================== ==================================

:note: Please note that some styles cannot be changed after the window
 creation and that `Refresh` might need to be be called after changing the
 others for the change to take place immediately.

.. todo:: Implementation of flags ``AUI_NB_RIGHT`` and ``AUI_NB_LEFT``.r&  hhh	h)]r&  X   agwStyler&  hhr&  ah1X%   SetAGWWindowStyleFlag(self, agwStyle)r&  h3h4h5X   61r&  h7j#  ubh#)r&  }r&  (hX1   wx.lib.agw.aui.auibook.AuiNotebook.SetArtProviderr&  hKh'KhXQ   Sets the art provider to be used by the notebook.

:param `art`: an art provider.r&  hhh	h)]r&  X   artr&  hhr&  ah1X   SetArtProvider(self, art)r&  h3h4h5X   10r&  h7j#  ubh#)r&  }r&  (hX1   wx.lib.agw.aui.auibook.AuiNotebook.SetCloseButtonr&  hKh'KhX   Sets whether a tab should display a close button or not.

:param integer `page_idx`: the page index;
:param bool `hasCloseButton`: ``True`` if the page displays a close button.

:note: This can only be called if ``AUI_NB_CLOSE_ON_ALL_TABS`` is specified.r&  hhh	h)]r&  (X   page_idxr&  hhr&  X   hasCloseButtonr&  hhr&  eh1X.   SetCloseButton(self, page_idx, hasCloseButton)r&  h3h4h5X   32r&  h7j#  ubh#)r&  }r&  (hX*   wx.lib.agw.aui.auibook.AuiNotebook.SetFontr&  hKh'KhX   Sets the tab font.

:param wx.Font `font`: the new font to use to draw tab labels in their normal, un-selected state.

:note: Overridden from :class:`Panel`.r&  hhh	h)]r&  X   fontr&  hhr&  ah1X   SetFont(self, font)r&  h3h4h5X   25r&  h7j#  ubh#)r&  }r&  (hX/   wx.lib.agw.aui.auibook.AuiNotebook.SetImageListr&  hKh'KhX   Sets the image list for the :class:`AuiNotebook` control.

:param wx.ImageList `imageList`: the bitmap image list to associate to :class:`AuiNotebook`.r&  hhh	h)]r&  X	   imageListr&  hhr&  ah1X   SetImageList(self, imageList)r&  h3h4h5j  h7j#  ubh#)r&  }r&  (hX3   wx.lib.agw.aui.auibook.AuiNotebook.SetMeasuringFontr&  hKh'KhX   Sets the font for calculating text measurements.

:param wx.Font `font`: the new font to use to measure tab label text extents.r&  hhh	h)]r&  X   fontr&  hhr&  ah1X   SetMeasuringFont(self, font)r&  h3h4h5j  h7j#  ubh#)r&  }r&  (hX4   wx.lib.agw.aui.auibook.AuiNotebook.SetMinMaxTabWidthr&  hKh'KhX  Sets the minimum and/or the maximum tab widths for :class:`AuiNotebook` when the
``AUI_NB_TAB_FIXED_WIDTH`` style is defined.

Pass -1 to either `minTabWidth` or `maxTabWidth` to reset to the default tab
width behaviour for :class:`AuiNotebook`.

:param integer `minTabWidth`: the minimum allowed tab width, in pixels;
:param integer `maxTabWidth`: the maximum allowed tab width, in pixels.

:note: Minimum and maximum tabs widths are used only when the ``AUI_NB_TAB_FIXED_WIDTH``
 style is present.r&  hhh	h)]r&  (X   minTabWidthr&  hhr&  X   maxTabWidthr&  hhr&  eh1X1   SetMinMaxTabWidth(self, minTabWidth, maxTabWidth)r&  h3h4h5X   21r&  h7j#  ubh#)r&  }r&  (hX3   wx.lib.agw.aui.auibook.AuiNotebook.SetNavigatorIconr&  hKh'KhX   Sets the icon used by the :class:`TabNavigatorWindow`.

:param wx.Bitmap `bmp`: the new bitmap for the :class:`TabNavigatorWindow`.r&  hhh	h)]r&  X   bmpr&  hhr&  ah1X   SetNavigatorIcon(self, bmp)r&  h3h4h5X   12r&  h7j#  ubh#)r&  }r&  (hX0   wx.lib.agw.aui.auibook.AuiNotebook.SetNormalFontr&  hKh'KhX   Sets the normal font for drawing tab labels.

:param wx.Font `font`: the new font to use to draw tab labels in their normal, un-selected state.r&  hhh	h)]r&  X   fontr&  hhr&  ah1X   SetNormalFont(self, font)r&  h3h4h5X   10r&  h7j#  ubh#)r&  }r&  (hX0   wx.lib.agw.aui.auibook.AuiNotebook.SetPageBitmapr&  hKh'KhX   Sets the tab bitmap for the page.

:param integer `page_idx`: the page index;
:param wx.Bitmap `bitmap`: the bitmap to display on the page tab.r&  hhh	h)]r&  (X   page_idxr&  hhr&  X   bitmapr&  hhr&  eh1X%   SetPageBitmap(self, page_idx, bitmap)r&  h3h4h5X   36r&  h7j#  ubh#)r&  }r&  (hX/   wx.lib.agw.aui.auibook.AuiNotebook.SetPageImager&  hKh'KhX   Sets the image index for the given page.

:param integer `page`: the page index;
:param integer `image`: an index into the image list which was set with :meth:`SetImageList`.r&  hhh	h)]r&  (X   pager&  hhr&  X   imager&  hhr&  eh1X   SetPageImage(self, page, image)r&  h3h4h5X   30r&  h7j#  ubh#)r&  }r '  (hX.   wx.lib.agw.aui.auibook.AuiNotebook.SetPageTextr'  hKh'KhXu   Sets the tab label for the page.

:param integer `page_idx`: the page index;
:param string `text`: the new tab label.r'  hhh	h)]r'  (X   page_idxr'  hhr'  X   textr'  hhr'  eh1X!   SetPageText(self, page_idx, text)r'  h3h4h5X   33r	'  h7j#  ubh#)r
'  }r'  (hX4   wx.lib.agw.aui.auibook.AuiNotebook.SetPageTextColourr'  hKh'KhX   Sets the tab text colour for the page.

:param integer `page_idx`: the page index;
:param wx.Colour `colour`: the new tab label text colour.r
'  hhh	h)]r'  (X   page_idxr'  hhr'  X   colourr'  hhr'  eh1X)   SetPageTextColour(self, page_idx, colour)r'  h3h4h5X   31r'  h7j#  ubh#)r'  }r'  (hX1   wx.lib.agw.aui.auibook.AuiNotebook.SetPageTooltipr'  hKh'KhX   Sets the tab tooltip for the page.

:param integer `page_idx`: the page index;
:param string `tooltip`: the new tooltip.

:returns: ``True`` if the page tooltip has been set, ``False`` otherwise
 (for example when the input `page_idx` is greater than the number of
 pages in the notebook.r'  hhh	h)]r'  (X   page_idxr'  hhr'  X   tooltipr'  hhr'  eh1X'   SetPageTooltip(self, page_idx, tooltip)r'  h3h4h5X   20r'  h7j#  ubh#)r '  }r!'  (hX/   wx.lib.agw.aui.auibook.AuiNotebook.SetRenamabler"'  hKh'KhX   Sets whether a tab can be renamed via a left double-click or not.

:param integer `page_idx`: the page index;
:param bool `renamable`: ``True`` if the page can be renamed.r#'  hhh	h)]r$'  (X   page_idxr%'  hhr&'  X	   renamabler''  hhr('  eh1X'   SetRenamable(self, page_idx, renamable)r)'  h3h4h5X   25r*'  h7j#  ubh#)r+'  }r,'  (hX7   wx.lib.agw.aui.auibook.AuiNotebook.SetSashDClickUnsplitr-'  hKh'KhX   Sets whether to unsplit a splitted :class:`AuiNotebook` when double-clicking on a sash.

:param bool `unsplit`: ``True`` to unsplit on sash double-clicking, ``False`` otherwise.r.'  hhh	h)]r/'  X   unsplitr0'  X   Truer1'  h/r2'  ah1X(   SetSashDClickUnsplit(self, unsplit=True)r3'  h3h4h5j  h7j#  ubh#)r4'  }r5'  (hX2   wx.lib.agw.aui.auibook.AuiNotebook.SetSelectedFontr6'  hKh'KhX   Sets the selected tab font for drawing tab labels.

:param wx.Font `font`: the new font to use to draw tab labels in their selected state.r7'  hhh	h)]r8'  X   fontr9'  hhr:'  ah1X   SetSelectedFont(self, font)r;'  h3h4h5X   10r<'  h7j#  ubh#)r='  }r>'  (hX/   wx.lib.agw.aui.auibook.AuiNotebook.SetSelectionr?'  hKh'KhX   Sets the page selection. Calling this method will generate a page change event.

:param integer `new_page`: the index of the new selection;
:param bool `force`: whether to force the selection or not.r@'  hhh	h)]rA'  (X   new_pagerB'  hhrC'  X   forcerD'  X   FalserE'  jB  rF'  eh1X)   SetSelection(self, new_page, force=False)rG'  h3h4h5X   74rH'  h7j#  ubh#)rI'  }rJ'  (hX5   wx.lib.agw.aui.auibook.AuiNotebook.SetSelectionToPagerK'  hKh'KhXd   Sets the selection based on the input page.

:param `page`: an instance of :class:`AuiNotebookPage`.rL'  hhh	h)]rM'  X   pagerN'  hhrO'  ah1X   SetSelectionToPage(self, page)rP'  h3h4h5j  h7j#  ubh#)rQ'  }rR'  (hX7   wx.lib.agw.aui.auibook.AuiNotebook.SetSelectionToWindowrS'  hKh'KhXg   Sets the selection based on the input window `win`.

:param `win`: a :class:`wx.Window` derived window.rT'  hhh	h)]rU'  X   winrV'  hhrW'  ah1X   SetSelectionToWindow(self, win)rX'  h3h4h5X   28rY'  h7j#  ubh#)rZ'  }r['  (hX3   wx.lib.agw.aui.auibook.AuiNotebook.SetTabCtrlHeightr\'  hKh'KhX  Sets the tab height.

By default, the tab control height is calculated by measuring the text
height and bitmap sizes on the tab captions.

Calling this method will override that calculation and set the tab control
to the specified height parameter. A call to this method will override
any call to :meth:`SetUniformBitmapSize`. Specifying -1 as the height will
return the control to its default auto-sizing behaviour.

:param integer `height`: the tab control area height.r]'  hhh	h)]r^'  X   heightr_'  hhr`'  ah1X   SetTabCtrlHeight(self, height)ra'  h3h4h5X   21rb'  h7j#  ubh#)rc'  }rd'  (hX7   wx.lib.agw.aui.auibook.AuiNotebook.SetUniformBitmapSizere'  hKh'KhX  Ensures that all tabs will have the same height, even if some tabs don't have bitmaps.
Passing ``wx.DefaultSize`` to this method will instruct the control to use dynamic tab
height, which is the default behaviour. Under the default behaviour, when a tab with a
large bitmap is added, the tab control's height will automatically increase to accommodate
the larger bitmap.

:param wx.Size `size`: the tab bitmap size.rf'  hhh	h)]rg'  X   sizerh'  hhri'  ah1X    SetUniformBitmapSize(self, size)rj'  h3h4h5X   17rk'  h7j#  ubh#)rl'  }rm'  (hX1   wx.lib.agw.aui.auibook.AuiNotebook.ShowWindowMenurn'  hKh'KhX}   Shows the window menu for the active tab control associated with this
notebook, and returns ``True`` if a selection was made.ro'  hhh	h)]rp'  h1X   ShowWindowMenu(self)rq'  h3h4h5X   25rr'  h7j#  ubh#)rs'  }rt'  (hX(   wx.lib.agw.aui.auibook.AuiNotebook.Splitru'  hKh'KhXI  Performs a split operation programmatically.

:param integer `page`: indicates the page that will be split off. This page will also become
 the active page after the split.
:param integer `direction`: specifies where the pane should go, it should be one of the
 following: ``wx.TOP``, ``wx.BOTTOM``, ``wx.LEFT``, or ``wx.RIGHT``.rv'  hhh	h)]rw'  (X   pagerx'  hhry'  X	   directionrz'  hhr{'  eh1X   Split(self, page, direction)r|'  h3h4h5X   121r}'  h7j#  ubh#)r~'  }r'  (hX*   wx.lib.agw.aui.auibook.AuiNotebook.UnSplitr'  hKh'KhX*   Restores original view after a tab split. r'  hhh	h)]r'  h1X
   UnSplit(self)r'  h3h4h5X   26r'  h7j#  ubh#)r'  }r'  (hX0   wx.lib.agw.aui.auibook.AuiNotebook.UnsplitDClickr'  hKh'KhXf  Unsplit the :class:`AuiNotebook` on sash double-click.

:param `part`: an UI part representing the sash;
:param integer `sash_size`: the sash size;
:param wx.Point `pos`: the double-click mouse position.

.. warning::

   Due to a bug on MSW, for disabled pages :func:`FindWindowAtPoint`
   returns the wrong window. See http://trac.wxwidgets.org/ticket/2942r'  hhh	h)]r'  (X   partr'  hhr'  X	   sash_sizer'  hhr'  X   posr'  hhr'  eh1X)   UnsplitDClick(self, part, sash_size, pos)r'  h3h4h5X   104r'  h7j#  ubh#)r'  }r'  (hX7   wx.lib.agw.aui.auibook.AuiNotebook.UpdateHintWindowSizer'  hKh'KhXO   Updates the :class:`~wx.lib.agw.aui.framemanager.AuiManager` hint window size. r'  hhh	h)]r'  h1X   UpdateHintWindowSize(self)r'  h3h4h5X   13r'  h7j#  ubh#)r'  }r'  (hX6   wx.lib.agw.aui.auibook.AuiNotebook.UpdateTabCtrlHeightr'  hKh'KhX   :meth:`UpdateTabCtrlHeight` does the actual tab resizing. It's meant
to be used internally.

:param bool `force`: ``True`` to force the tab art to repaint.r'  hhh	h)]r'  X   forcer'  X   Falser'  jB  r'  ah1X&   UpdateTabCtrlHeight(self, force=False)r'  h3h4h5X   34r'  h7j#  ubhO)r'  }r'  (hX1   wx.lib.agw.aui.auibook.AuiNotebook.NavigatorPropsr'  hKh'Khhhhh	hSX   <lambda>r'  hUhhVhh3hWh7j#  ubehd]r'  (]r'  X   objectr'  a]r'  (]r'  X
   simplewrapperr'  a]r'  (]r'  X   wrapperr'  a]r'  (]r'  j  a]r'  (]r'  j  a]r'  (]r'  j  a]r'  (]r'  j  a]r'  (]r'  X   Panelr'  a]r'  ]r'  j#  aaeeee]r'  j  a]r'  (]r'  j  a]r'  (]r'  j  a]r'  (]r'  j  a]r'  (]r'  j'  a]r'  ]r'  j#  aaeeeeeeeehk]r'  X(   wx.lib.agw.aui.tabmdi.AuiMDIClientWindowr'  ahm]r'  X   wx.Panelr'  ah1X   AuiNotebook(wx.Panel)r'  hpj  )r'  }r'  (j  ]r'  (X"   wx.lib.agw.aui.auibook.AuiNotebookr'  ]r'  X   wx.Panelr'  ar'  X   wx.Panelr'  ]r'  X	   wx.Windowr'  ar'  X	   wx.Windowr'  ]r'  X
   wx.WindowBaser'  ar'  X
   wx.WindowBaser'  ]r'  X
   wx.EvtHandlerr'  ar'  X
   wx.EvtHandlerr'  ]r'  (X	   wx.Objectr'  X   wx.Trackabler'  er'  X	   wx.Objectr'  ]r'  r'  X   wx.Trackabler'  ]r'  r'  ej  ]r'  X"   wx.lib.agw.aui.auibook.AuiNotebookr'  aj  j#  ubh'Kh3hqhrXU   /home/wxpy/bb2/dist-src-py37/build/docs/sphinx/wx.lib.agw.aui.auibook.AuiNotebook.txtr'  h7j#  h5X   3320r'  j  ]r'  (X   __init__r'  X   AddControlToPager'  X   AddPager'  X   AddTabAreaButtonr'  X   AdvanceSelectionr'  X   AssignImageListr'  X   CalculateNewSplitSizer'  X   CalculateTabCtrlHeightr'  X   CloneTabAreaButtonsr'  X
   DeletePager'  X   Destroyr'  X   DoSizingr'  X   EditTabr'  X	   EnableTabr'  X
   EnsureVisibler'  X   FindNextActiveTabr'  X   FindTabr (  X	   FloatPager(  X   GetActiveTabCtrlr(  X   GetAGWWindowStyleFlagr(  X   GetArtProviderr(  X
   GetAuiManagerr(  X   GetCurrentPager(  X   GetDefaultBorderr(  X
   GetEnabledr(  X   GetHeightForPageHeightr	(  X	   GetHiddenr
(  X   GetImageListr(  X   GetMinMaxTabWidthr(  X   GetPager
(  X
   GetPageBitmapr(  X   GetPageCountr(  X   GetPageImager(  X   GetPageIndexr(  X   GetPageInfor(  X   GetPageTextr(  X   GetPageTextColourr(  X   GetPageTooltipr(  X   GetSashDClickUnsplitr(  X   GetSelectionr(  X   GetShownPageCountr(  X   GetTabContainerr(  X   GetTabCtrlFromPointr(  X   GetTabCtrlHeightr(  X   GetTabFrameFromTabCtrlr(  X   GetTabFrameFromWindowr(  X   HasCloseButtonr(  X   HasMultiplePagesr(  X   HideAllTabsr (  X   HidePager!(  X   InitNotebookr"(  X
   InsertPager#(  X   IsMouseWellOutsideWindowr$(  X   IsRenamabler%(  X   LoadPerspectiver&(  X   NotebookPreviewr'(  X   OnChildFocusNotebookr((  X   OnCloseFloatingPager)(  X   OnNavigationKeyNotebookr*(  X   OnRenameAcceptr+(  X   OnRenameCancelledr,(  X   OnSizer-(  X   OnTabBeginDragr.(  X
   OnTabBgDClickr/(  X   OnTabButtonr0(  X   OnTabCancelDragr1(  X   OnTabClickedr2(  X   OnTabDClickr3(  X   OnTabDragMotionr4(  X   OnTabEndDragr5(  X   OnTabMiddleDownr6(  X
   OnTabMiddleUpr7(  X   OnTabRightDownr8(  X   OnTabRightUpr9(  X
   ReDockPager:(  X   RemoveControlFromPager;(  X   RemoveEmptyTabFramesr<(  X
   RemovePager=(  X   RemoveTabAreaButtonr>(  X   ReparentControlr?(  X   ResetTextControlr@(  X   SavePerspectiverA(  X   SetAGWWindowStyleFlagrB(  X   SetArtProviderrC(  X   SetCloseButtonrD(  X   SetFontrE(  X   SetImageListrF(  X   SetMeasuringFontrG(  X   SetMinMaxTabWidthrH(  X   SetNavigatorIconrI(  X
   SetNormalFontrJ(  X
   SetPageBitmaprK(  X   SetPageImagerL(  X   SetPageTextrM(  X   SetPageTextColourrN(  X   SetPageTooltiprO(  X   SetRenamablerP(  X   SetSashDClickUnsplitrQ(  X   SetSelectedFontrR(  X   SetSelectionrS(  X   SetSelectionToPagerT(  X   SetSelectionToWindowrU(  X   SetTabCtrlHeightrV(  X   SetUniformBitmapSizerW(  X   ShowWindowMenurX(  X   SplitrY(  X   UnSplitrZ(  X
   UnsplitDClickr[(  X   UpdateHintWindowSizer\(  X   UpdateTabCtrlHeightr](  ej  j'  ubh)r^(  }r_(  (hX'   wx.lib.agw.aui.auibook.AuiNotebookEventr`(  hKhXK   A specialized command event class for events sent by :class:`AuiNotebook`. ra(  hhh	h
]rb(  (h#)rc(  }rd(  (hX0   wx.lib.agw.aui.auibook.AuiNotebookEvent.__init__re(  hKh'KhX   Default class constructor.

:param `command_type`: the event kind or an instance of :class:`PyCommandEvent`.
:param integer `win_id`: the window identification number.rf(  hhh	h)]rg(  (X   command_typerh(  X   Noneri(  X   Nonerj(  rk(  X   win_idrl(  j  X   0rm(  rn(  eh1X+   __init__(self, command_type=None, win_id=0)ro(  h3h4h5X   15rp(  h7j^(  ubh#)rq(  }rr(  (hX-   wx.lib.agw.aui.auibook.AuiNotebookEvent.Allowrs(  hKh'KhX  This is the opposite of :meth:`Veto`: it explicitly allows the event to be
processed. For most events it is not necessary to call this method as the
events are allowed anyhow but some are forbidden by default (this will
be mentioned in the corresponding event description).rt(  hhh	h)]ru(  h1X   Allow(self)rv(  h3h4h5X   10rw(  h7j^(  ubh#)rx(  }ry(  (hX6   wx.lib.agw.aui.auibook.AuiNotebookEvent.GetNotifyEventrz(  hKh'KhX)   Returns the actual :class:`NotifyEvent`. r{(  hhh	h)]r|(  h1X   GetNotifyEvent(self)r}(  h3h4h5hIh7j^(  ubh#)r~(  }r(  (hX1   wx.lib.agw.aui.auibook.AuiNotebookEvent.IsAllowedr(  hKh'KhX-   Returns whether the event is allowed or not. r(  hhh	h)]r(  h1X   IsAllowed(self)r(  h3h4h5hIh7j^(  ubh#)r(  }r(  (hX,   wx.lib.agw.aui.auibook.AuiNotebookEvent.Vetor(  hKh'KhX  Prevents the change announced by this event from happening.

It is in general a good idea to notify the user about the reasons for
vetoing the change because otherwise the applications behaviour (which
just refuses to do what the user wants) might be quite surprising.r(  hhh	h)]r(  h1X
   Veto(self)r(  h3h4h5X   11r(  h7j^(  ubehd]r(  (]r(  X   objectr(  a]r(  (]r(  X
   simplewrapperr(  a]r(  (]r(  X   wrapperr(  a]r(  (]r(  j  a]r(  (]r(  j  a]r(  (]r(  j  a]r(  (]r(  j  a]r(  (]r(  X   CommandNotebookEventr(  a]r(  ]r(  X   AuiNotebookEventr(  aaeeeeeeeehk]r(  hm]r(  X+   wx.lib.agw.aui.auibook.CommandNotebookEventr(  ah1X&   AuiNotebookEvent(CommandNotebookEvent)r(  hpj  )r(  }r(  (j  ]r(  (X'   wx.lib.agw.aui.auibook.AuiNotebookEventr(  ]r(  X+   wx.lib.agw.aui.auibook.CommandNotebookEventr(  ar(  X+   wx.lib.agw.aui.auibook.CommandNotebookEventr(  ]r(  X   wx.PyCommandEventr(  ar(  X   wx.PyCommandEventr(  ]r(  X   wx.CommandEventr(  ar(  X   wx.CommandEventr(  ]r(  X   wx.Eventr(  ar(  X   wx.Eventr(  ]r(  X	   wx.Objectr(  ar(  X	   wx.Objectr(  ]r(  r(  ej  ]r(  X'   wx.lib.agw.aui.auibook.AuiNotebookEventr(  aj  j^(  ubh'Kh3hqhrXZ   /home/wxpy/bb2/dist-src-py37/build/docs/sphinx/wx.lib.agw.aui.auibook.AuiNotebookEvent.txtr(  h7j#  h5X   53r(  j  ]r(  (X   __init__r(  X   Allowr(  X   GetNotifyEventr(  X	   IsAllowedr(  X   Vetor(  ej  j(  ubh)r(  }r(  (hX&   wx.lib.agw.aui.auibook.AuiNotebookPager(  hKhXO   A simple class which holds information about tab captions, bitmaps and
colours.r(  hhh	h
]r(  (h#)r(  }r(  (hX/   wx.lib.agw.aui.auibook.AuiNotebookPage.__init__r(  hKh'KhXH   Default class constructor.
Used internally, do not call it in your code!r(  hhh	h)]r(  h1X   __init__(self)r(  h3h4h5X   24r(  h7j(  ubh#)r(  }r(  (hX2   wx.lib.agw.aui.auibook.AuiNotebookPage.IsMultiliner(  hKh'KhX1   Returns whether the tab contains multiline text. r(  hhh	h)]r(  h1X   IsMultiline(self)r(  h3h4h5hIh7j(  ubehd]r(  (]r(  X   objectr(  a]r(  ]r(  X   AuiNotebookPager(  aaehk]r(  hm]r(  h1X   AuiNotebookPage(object)r(  hpj  )r(  }r(  (j  ]r(  X&   wx.lib.agw.aui.auibook.AuiNotebookPager(  ]r(  r(  aj  ]r(  X&   wx.lib.agw.aui.auibook.AuiNotebookPager(  aj  j(  ubh'Kh3hqhrXY   /home/wxpy/bb2/dist-src-py37/build/docs/sphinx/wx.lib.agw.aui.auibook.AuiNotebookPage.txtr(  h7j#  h5X   36r(  j  ]r(  (X   __init__r(  X   IsMultiliner(  ej  j(  ubh)r(  }r(  (hX&   wx.lib.agw.aui.auibook.AuiTabContainerr(  hKhX  AuiTabContainer is a class which contains information about each tab.
It also can render an entire tab control to a specified DC.
It's not a window class itself, because this code will be used by
the :class:`AuiNotebook`, where it is disadvantageous to have separate
windows for each tab control in the case of "docked tabs".

A derived class, :class:`AuiTabCtrl`, is an actual :class:`wx.Window` - derived window
which can be used as a tab control in the normal sense.r(  hhh	h
]r(  (h#)r(  }r(  (hX/   wx.lib.agw.aui.auibook.AuiTabContainer.__init__r(  hKh'KhX   Default class constructor.
Used internally, do not call it in your code!

:param `auiNotebook`: the parent :class:`AuiNotebook` window.r(  hhh	h)]r(  X   auiNotebookr(  hhr(  ah1X   __init__(self, auiNotebook)r(  h3h4h5X   25r(  h7j(  ubh#)r )  }r)  (hX0   wx.lib.agw.aui.auibook.AuiTabContainer.AddButtonr)  hKh'KhX  Adds a button in the tab area.

:param integer `id`: the button identifier. This can be one of the following:

 ==============================  =================================
 Button Identifier               Description
 ==============================  =================================
 ``AUI_BUTTON_CLOSE``            Shows a close button on the tab area
 ``AUI_BUTTON_WINDOWLIST``       Shows a window list button on the tab area
 ``AUI_BUTTON_LEFT``             Shows a left button on the tab area
 ``AUI_BUTTON_RIGHT``            Shows a right button on the tab area
 ==============================  =================================

:param integer `location`: the button location. Can be ``wx.LEFT`` or ``wx.RIGHT``;
:param wx.Bitmap `normal_bitmap`: the bitmap for an enabled tab;
:param wx.Bitmap `disabled_bitmap`: the bitmap for a disabled tab;
:param string `name`: the button name.r)  hhh	h)]r)  (X   idr)  hhr)  X   locationr)  hhr)  X
   normal_bitmapr	)  X
   wx.NullBitmapr
)  X*   <wx._core.Bitmap object at 0x7f7afe99ac30>r)  r)  X   disabled_bitmapr
)  X
   wx.NullBitmapr)  X*   <wx._core.Bitmap object at 0x7f7afe99ac30>r)  r)  X   namer)  X   ""r)  hr)  eh1Xb   AddButton(self, id, location, normal_bitmap=wx.NullBitmap, disabled_bitmap=wx.NullBitmap, name="")r)  h3h4h5X   31r)  h7j(  ubh#)r)  }r)  (hX.   wx.lib.agw.aui.auibook.AuiTabContainer.AddPager)  hKh'KhX   Adds a page to the tab control.

:param wx.Window `page`: the window associated with this tab;
:param `info`: an instance of :class:`AuiNotebookPage`.r)  hhh	h)]r)  (X   pager)  hhr)  X   infor)  hhr)  eh1X   AddPage(self, page, info)r)  h3h4h5X   20r )  h7j(  ubh#)r!)  }r")  (hX4   wx.lib.agw.aui.auibook.AuiTabContainer.ButtonHitTestr#)  hKh'KhX)  Tests if a button was hit.

:param integer `x`: the mouse `x` position;
:param integer `y`: the mouse `y` position;
:param integer `state_flags`: the current button state (hidden, disabled, etc...).

:returns: and instance of :class:`AuiTabContainerButton` if a button was hit, ``None`` otherwise.r$)  hhh	h)]r%)  (j  hhr&)  j  hhr')  X   state_flagsr()  X1   AUI_BUTTON_STATE_HIDDEN|AUI_BUTTON_STATE_DISABLEDr))  X   24r*)  r+)  eh1XX   ButtonHitTest(self, x, y, state_flags=AUI_BUTTON_STATE_HIDDEN|AUI_BUTTON_STATE_DISABLED)r,)  h3h4h5X   26r-)  h7j(  ubh#)r.)  }r/)  (hX3   wx.lib.agw.aui.auibook.AuiTabContainer.CloneButtonsr0)  hKh'KhX   Clones the tab area buttons when the :class:`AuiNotebook` is being split.

:see: :meth:`AddButton`

:note: Standard buttons for :class:`AuiNotebook` are not cloned, only custom ones.r1)  hhh	h)]r2)  h1X   CloneButtons(self)r3)  h3h4h5X   23r4)  h7j(  ubh#)r5)  }r6)  (hX1   wx.lib.agw.aui.auibook.AuiTabContainer.DoShowHider7)  hKh'KhX[   This function shows the active window, then hides all of the other windows
(in that order).r8)  hhh	h)]r9)  h1X   DoShowHide(self)r:)  h3h4h5X   19r;)  h7j(  ubh#)r<)  }r=)  (hX0   wx.lib.agw.aui.auibook.AuiTabContainer.EnableTabr>)  hKh'KhX   Enables/disables a tab in the :class:`AuiTabContainer`.

:param integer `idx`: the tab index;
:param bool `enable`: ``True`` to enable a tab, ``False`` to disable it.r?)  hhh	h)]r@)  (X   idxrA)  hhrB)  X   enablerC)  X   TruerD)  h/rE)  eh1X!   EnableTab(self, idx, enable=True)rF)  h3h4h5X   15rG)  h7j(  ubh#)rH)  }rI)  (hX8   wx.lib.agw.aui.auibook.AuiTabContainer.FindNextActiveTabrJ)  hKh'KhX   Finds the next active tab in the :class:`AuiTabContainer`.

:param integer `idx`: the index of the first (most obvious) tab to check for active status;rK)  hhh	h)]rL)  X   idxrM)  hhrN)  ah1X   FindNextActiveTab(self, idx)rO)  h3h4h5X   20rP)  h7j(  ubh#)rQ)  }rR)  (hX4   wx.lib.agw.aui.auibook.AuiTabContainer.GetActivePagerS)  hKh'KhXJ   Returns the current selected tab or ``wx.NOT_FOUND`` if none is selected. rT)  hhh	h)]rU)  h1X   GetActivePage(self)rV)  h3h4h5j  h7j(  ubh#)rW)  }rX)  (hX2   wx.lib.agw.aui.auibook.AuiTabContainer.GetAGWFlagsrY)  hKh'KhXb   Returns the tab art flags.

.. seealso:: :meth:`SetAGWFlags` for a list of possible return values.rZ)  hhh	h)]r[)  h1X   GetAGWFlags(self)r\)  h3h4h5j  h7j(  ubh#)r])  }r^)  (hX5   wx.lib.agw.aui.auibook.AuiTabContainer.GetArtProviderr_)  hKh'KhX-   Returns the current art provider being used. r`)  hhh	h)]ra)  h1X   GetArtProvider(self)rb)  h3h4h5hIh7j(  ubh#)rc)  }rd)  (hX1   wx.lib.agw.aui.auibook.AuiTabContainer.GetEnabledre)  hKh'KhXN   Returns whether a tab is enabled or not.

:param integer `idx`: the tab index.rf)  hhh	h)]rg)  X   idxrh)  hhri)  ah1X   GetEnabled(self, idx)rj)  h3h4h5X   12rk)  h7j(  ubh#)rl)  }rm)  (hX0   wx.lib.agw.aui.auibook.AuiTabContainer.GetHiddenrn)  hKh'KhXM   Returns whether a tab is hidden or not.

:param integer `idx`: the tab index.ro)  hhh	h)]rp)  X   idxrq)  hhrr)  ah1X   GetHidden(self, idx)rs)  h3h4h5X   12rt)  h7j(  ubh#)ru)  }rv)  (hX7   wx.lib.agw.aui.auibook.AuiTabContainer.GetIdxFromWindowrw)  hKh'KhXu   Returns the tab index based on the window `wnd` associated with it.

:param `wnd`: an instance of :class:`wx.Window`.rx)  hhh	h)]ry)  X   wndrz)  hhr{)  ah1X   GetIdxFromWindow(self, wnd)r|)  h3h4h5X   13r})  h7j(  ubh#)r~)  }r)  (hX.   wx.lib.agw.aui.auibook.AuiTabContainer.GetPager)  hKh'KhXT   Returns the page specified by the given index.

:param integer `idx`: the tab index.r)  hhh	h)]r)  X   idxr)  hhr)  ah1X   GetPage(self, idx)r)  h3h4h5X   12r)  h7j(  ubh#)r)  }r)  (hX3   wx.lib.agw.aui.auibook.AuiTabContainer.GetPageCountr)  hKh'KhX=   Returns the number of pages in the :class:`AuiTabContainer`. r)  hhh	h)]r)  h1X   GetPageCount(self)r)  h3h4h5hIh7j(  ubh#)r)  }r)  (hX/   wx.lib.agw.aui.auibook.AuiTabContainer.GetPagesr)  hKh'KhXB   Returns a list of all the pages in this :class:`AuiTabContainer`. r)  hhh	h)]r)  h1X   GetPages(self)r)  h3h4h5hIh7j(  ubh#)r)  }r)  (hX8   wx.lib.agw.aui.auibook.AuiTabContainer.GetShownPageCountr)  hKh'KhXC   Returns the number of pages shown in the :class:`AuiTabContainer`. r)  hhh	h)]r)  h1X   GetShownPageCount(self)r)  h3h4h5j~  h7j(  ubh#)r)  }r)  (hX3   wx.lib.agw.aui.auibook.AuiTabContainer.GetTabOffsetr)  hKh'KhX   Returns the tab offset. r)  hhh	h)]r)  h1X   GetTabOffset(self)r)  h3h4h5hIh7j(  ubh#)r)  }r)  (hX7   wx.lib.agw.aui.auibook.AuiTabContainer.GetWindowFromIdxr)  hKh'KhXb   Returns the window associated with the tab with index `idx`.

:param integer `idx`: the tab index.r)  hhh	h)]r)  X   idxr)  hhr)  ah1X   GetWindowFromIdx(self, idx)r)  h3h4h5X   12r)  h7j(  ubh#)r)  }r)  (hX.   wx.lib.agw.aui.auibook.AuiTabContainer.HideTabr)  hKh'KhX   hides/shows a tab in the :class:`AuiTabContainer`.

:param integer `idx`: the tab index;
:param bool `hidden`: ``True`` to hide a tab, ``False`` to show it.r)  hhh	h)]r)  (X   idxr)  hhr)  X   hiddenr)  X   Truer)  h/r)  eh1X   HideTab(self, idx, hidden=True)r)  h3h4h5X   16r)  h7j(  ubh#)r)  }r)  (hX1   wx.lib.agw.aui.auibook.AuiTabContainer.InsertPager)  hKh'KhX   Inserts a page in the tab control in the position specified by `idx`.

:param wx.Window `page`: the window associated with this tab;
:param `info`: an instance of :class:`AuiNotebookPage`;
:param integer `idx`: the page insertion index.r)  hhh	h)]r)  (X   pager)  hhr)  X   infor)  hhr)  X   idxr)  hhr)  eh1X!   InsertPage(self, page, info, idx)r)  h3h4h5X   24r)  h7j(  ubh#)r)  }r)  (hX3   wx.lib.agw.aui.auibook.AuiTabContainer.IsTabVisibler)  hKh'KhX   Returns whether a tab is visible or not.

:param integer `tabPage`: the tab index;
:param integer `tabOffset`: the tab offset;
:param `dc`: a :class:`wx.DC` device context;
:param `wnd`: an instance of :class:`wx.Window` derived window.r)  hhh	h)]r)  (X   tabPager)  hhr)  X	   tabOffsetr)  hhr)  X   dcr)  hhr)  X   wndr)  hhr)  eh1X/   IsTabVisible(self, tabPage, tabOffset, dc, wnd)r)  h3h4h5X   112r)  h7j(  ubh#)r)  }r)  (hX5   wx.lib.agw.aui.auibook.AuiTabContainer.MakeTabVisibler)  hKh'KhX   Make the tab visible if it wasn't already.

:param integer `tabPage`: the tab index;
:param `win`: an instance of :class:`wx.Window` derived window.r)  hhh	h)]r)  (X   tabPager)  hhr)  X   winr)  hhr)  eh1X"   MakeTabVisible(self, tabPage, win)r)  h3h4h5X   17r)  h7j(  ubh#)r)  }r)  (hX/   wx.lib.agw.aui.auibook.AuiTabContainer.MovePager)  hKh'KhX   Moves a page in a new position specified by `new_idx`.

:param wx.Window `page`: the window associated with this tab;
:param integer `new_idx`: the new page position.r)  hhh	h)]r)  (X   pager)  hhr)  X   new_idxr)  hhr)  eh1X   MovePage(self, page, new_idx)r)  h3h4h5X   23r)  h7j(  ubh#)r)  }r)  (hX3   wx.lib.agw.aui.auibook.AuiTabContainer.RemoveButtonr)  hKh'KhX   Removes a button from the tab area.

:param integer `id`: the button identifier. See :meth:`AddButton` for a list of button identifiers.

:see: :meth:`AddButton`r)  hhh	h)]r)  X   idr)  hhr)  ah1X   RemoveButton(self, id)r)  h3h4h5X   14r)  h7j(  ubh#)r)  }r)  (hX1   wx.lib.agw.aui.auibook.AuiTabContainer.RemovePager)  hKh'KhXy   Removes a page from the tab control.

:param `wnd`: an instance of :class:`wx.Window`, a window associated with this tab.r)  hhh	h)]r)  X   wndr)  hhr)  ah1X   RemovePage(self, wnd)r)  h3h4h5X   22r)  h7j(  ubh#)r)  }r)  (hX-   wx.lib.agw.aui.auibook.AuiTabContainer.Renderr)  hKh'KhX   Renders the tab catalog to the specified :class:`wx.DC`.

It is a virtual function and can be overridden to provide custom drawing
capabilities.

:param `raw_dc`: a :class:`wx.DC` device context;
:param `wnd`: an instance of :class:`wx.Window`.r)  hhh	h)]r)  (X   raw_dcr)  hhr)  X   wndr)  hhr *  eh1X   Render(self, raw_dc, wnd)r*  h3h4h5X   275r*  h7j(  ubh#)r*  }r*  (hX4   wx.lib.agw.aui.auibook.AuiTabContainer.SetActivePager*  hKh'KhX   Sets the :class:`AuiNotebook` active page.

:param `wndOrInt`: an instance of :class:`wx.Window` or an integer specifying a tab index.r*  hhh	h)]r*  X   wndOrIntr*  hhr	*  ah1X   SetActivePage(self, wndOrInt)r
*  h3h4h5X   31r*  h7j(  ubh#)r*  }r
*  (hX2   wx.lib.agw.aui.auibook.AuiTabContainer.SetAGWFlagsr*  hKh'KhXU  Sets the tab art flags.

:param integer `agwFlags`: a combination of the following values:

 ==================================== ==================================
 Flag name                            Description
 ==================================== ==================================
 ``AUI_NB_TOP``                       With this style, tabs are drawn along the top of the notebook
 ``AUI_NB_LEFT``                      With this style, tabs are drawn along the left of the notebook. Not implemented yet
 ``AUI_NB_RIGHT``                     With this style, tabs are drawn along the right of the notebook. Not implemented yet
 ``AUI_NB_BOTTOM``                    With this style, tabs are drawn along the bottom of the notebook
 ``AUI_NB_TAB_SPLIT``                 Allows the tab control to be split by dragging a tab
 ``AUI_NB_TAB_MOVE``                  Allows a tab to be moved horizontally by dragging
 ``AUI_NB_TAB_EXTERNAL_MOVE``         Allows a tab to be moved to another tab control
 ``AUI_NB_TAB_FIXED_WIDTH``           With this style, all tabs have the same width
 ``AUI_NB_SCROLL_BUTTONS``            With this style, left and right scroll buttons are displayed
 ``AUI_NB_WINDOWLIST_BUTTON``         With this style, a drop-down list of windows is available
 ``AUI_NB_CLOSE_BUTTON``              With this style, a close button is available on the tab bar
 ``AUI_NB_CLOSE_ON_ACTIVE_TAB``       With this style, a close button is available on the active tab
 ``AUI_NB_CLOSE_ON_ALL_TABS``         With this style, a close button is available on all tabs
 ``AUI_NB_MIDDLE_CLICK_CLOSE``        Allows to close :class:`AuiNotebook` tabs by mouse middle button click
 ``AUI_NB_SUB_NOTEBOOK``              This style is used by :class:`~wx.lib.agw.aui.framemanager.AuiManager` to create automatic AuiNotebooks
 ``AUI_NB_HIDE_ON_SINGLE_TAB``        Hides the tab window if only one tab is present
 ``AUI_NB_SMART_TABS``                Use Smart Tabbing, like ``Alt`` + ``Tab`` on Windows
 ``AUI_NB_USE_IMAGES_DROPDOWN``       Uses images on dropdown window list menu instead of check items
 ``AUI_NB_CLOSE_ON_TAB_LEFT``         Draws the tab close button on the left instead of on the right (a la Camino browser)
 ``AUI_NB_TAB_FLOAT``                 Allows the floating of single tabs. Known limitation: when the notebook is more or less full screen,
                                      tabs cannot be dragged far enough outside of the notebook to become floating pages
 ``AUI_NB_DRAW_DND_TAB``              Draws an image representation of a tab while dragging (on by default)
 ``AUI_NB_ORDER_BY_ACCESS``           Tab navigation order by last access time for the tabs
 ``AUI_NB_NO_TAB_FOCUS``              Don't draw tab focus rectangle
 ==================================== ==================================

.. todo:: Implementation of flags ``AUI_NB_RIGHT`` and ``AUI_NB_LEFT``.r*  hhh	h)]r*  X   agwFlagsr*  hhr*  ah1X   SetAGWFlags(self, agwFlags)r*  h3h4h5X   60r*  h7j(  ubh#)r*  }r*  (hX5   wx.lib.agw.aui.auibook.AuiTabContainer.SetArtProviderr*  hKh'KhX  Instructs :class:`AuiTabContainer` to use art provider specified by parameter `art`
for all drawing calls. This allows pluggable look-and-feel features.

:param `art`: an art provider.

:note: The previous art provider object, if any, will be deleted by :class:`AuiTabContainer`.r*  hhh	h)]r*  X   artr*  hhr*  ah1X   SetArtProvider(self, art)r*  h3h4h5X   16r*  h7j(  ubh#)r*  }r*  (hX7   wx.lib.agw.aui.auibook.AuiTabContainer.SetMeasuringFontr *  hKh'KhX   Sets the font for calculating text measurements.

:param wx.Font `font`: the new font to use to measure tab label text extents.r!*  hhh	h)]r"*  X   fontr#*  hhr$*  ah1X   SetMeasuringFont(self, font)r%*  h3h4h5j  h7j(  ubh#)r&*  }r'*  (hX4   wx.lib.agw.aui.auibook.AuiTabContainer.SetNoneActiver(*  hKh'KhX.   Sets all the tabs as inactive (non-selected). r)*  hhh	h)]r**  h1X   SetNoneActive(self)r+*  h3h4h5hCh7j(  ubh#)r,*  }r-*  (hX4   wx.lib.agw.aui.auibook.AuiTabContainer.SetNormalFontr.*  hKh'KhX   Sets the normal font for drawing tab labels.

:param wx.Font `font`: the new font to use to draw tab labels in their normal, un-selected state.r/*  hhh	h)]r0*  X   fontr1*  hhr2*  ah1X   SetNormalFont(self, font)r3*  h3h4h5j  h7j(  ubh#)r4*  }r5*  (hX6   wx.lib.agw.aui.auibook.AuiTabContainer.SetSelectedFontr6*  hKh'KhX   Sets the selected tab font for drawing tab labels.

:param wx.Font `font`: the new font to use to draw tab labels in their selected state.r7*  hhh	h)]r8*  X   fontr9*  hhr:*  ah1X   SetSelectedFont(self, font)r;*  h3h4h5j  h7j(  ubh#)r<*  }r=*  (hX3   wx.lib.agw.aui.auibook.AuiTabContainer.SetTabOffsetr>*  hKh'KhX>   Sets the tab offset.

:param integer `offset`: the tab offset.r?*  hhh	h)]r@*  X   offsetrA*  hhrB*  ah1X   SetTabOffset(self, offset)rC*  h3h4h5j  h7j(  ubh#)rD*  }rE*  (hX1   wx.lib.agw.aui.auibook.AuiTabContainer.SetTabRectrF*  hKh'KhXe   Sets the tab area rectangle.

:param wx.Rect `rect`: the available area for :class:`AuiTabContainer`.rG*  hhh	h)]rH*  X   rectrI*  hhrJ*  ah1X   SetTabRect(self, rect)rK*  h3h4h5X   13rL*  h7j(  ubh#)rM*  }rN*  (hX1   wx.lib.agw.aui.auibook.AuiTabContainer.TabHitTestrO*  hKh'KhX   TabHitTest() tests if a tab was hit, passing the window pointer
back if that condition was fulfilled.

:param integer `x`: the mouse `x` position;
:param integer `y`: the mouse `y` position.rP*  hhh	h)]rQ*  (j  hhrR*  j  hhrS*  eh1X   TabHitTest(self, x, y)rT*  h3h4h5X   28rU*  h7j(  ubehd]rV*  (]rW*  X   objectrX*  a]rY*  ]rZ*  X   AuiTabContainerr[*  aaehk]r\*  X!   wx.lib.agw.aui.auibook.AuiTabCtrlr]*  ahm]r^*  h1X   AuiTabContainer(object)r_*  hpj  )r`*  }ra*  (j  ]rb*  X&   wx.lib.agw.aui.auibook.AuiTabContainerrc*  ]rd*  re*  aj  ]rf*  X&   wx.lib.agw.aui.auibook.AuiTabContainerrg*  aj  j(  ubh'Kh3hqhrXY   /home/wxpy/bb2/dist-src-py37/build/docs/sphinx/wx.lib.agw.aui.auibook.AuiTabContainer.txtrh*  h7j#  h5X   1022ri*  j  ]rj*  (X   __init__rk*  X	   AddButtonrl*  X   AddPagerm*  X
   ButtonHitTestrn*  X   CloneButtonsro*  X
   DoShowHiderp*  X	   EnableTabrq*  X   FindNextActiveTabrr*  X
   GetActivePagers*  X   GetAGWFlagsrt*  X   GetArtProviderru*  X
   GetEnabledrv*  X	   GetHiddenrw*  X   GetIdxFromWindowrx*  X   GetPagery*  X   GetPageCountrz*  X   GetPagesr{*  X   GetShownPageCountr|*  X   GetTabOffsetr}*  X   GetWindowFromIdxr~*  X   HideTabr*  X
   InsertPager*  X   IsTabVisibler*  X   MakeTabVisibler*  X   MovePager*  X   RemoveButtonr*  X
   RemovePager*  X   Renderr*  X
   SetActivePager*  X   SetAGWFlagsr*  X   SetArtProviderr*  X   SetMeasuringFontr*  X
   SetNoneActiver*  X
   SetNormalFontr*  X   SetSelectedFontr*  X   SetTabOffsetr*  X
   SetTabRectr*  X
   TabHitTestr*  ej  j^*  ubh)r*  }r*  (hX,   wx.lib.agw.aui.auibook.AuiTabContainerButtonr*  hKhXI   A simple class which holds information about tab buttons and their state.r*  hhh	h
]r*  h#)r*  }r*  (hX5   wx.lib.agw.aui.auibook.AuiTabContainerButton.__init__r*  hKh'KhXH   Default class constructor.
Used internally, do not call it in your code!r*  hhh	h)]r*  h1X   __init__(self)r*  h3h4h5X   14r*  h7j*  ubahd]r*  (]r*  X   objectr*  a]r*  ]r*  X   AuiTabContainerButtonr*  aaehk]r*  hm]r*  h1X   AuiTabContainerButton(object)r*  hpj  )r*  }r*  (j  ]r*  X,   wx.lib.agw.aui.auibook.AuiTabContainerButtonr*  ]r*  r*  aj  ]r*  X,   wx.lib.agw.aui.auibook.AuiTabContainerButtonr*  aj  j*  ubh'Kh3hqhrX_   /home/wxpy/bb2/dist-src-py37/build/docs/sphinx/wx.lib.agw.aui.auibook.AuiTabContainerButton.txtr*  h7j#  h5X   19r*  j  ]r*  X   __init__r*  aj  j*  ubh)r*  }r*  (hX!   wx.lib.agw.aui.auibook.AuiTabCtrlr*  hKhXm   This is an actual :class:`wx.Window` - derived window which can be used as a tab control in the normal sense.r*  hhh	h
]r*  (h#)r*  }r*  (hX*   wx.lib.agw.aui.auibook.AuiTabCtrl.__init__r*  hKh'KhXO  Default class constructor.
Used internally, do not call it in your code!

:param `parent`: the :class:`AuiNotebook` parent;
:param integer `id`: an identifier for the control: a value of -1 is taken to mean a default;
:param wx.Point `pos`: the control position. A value of (-1, -1) indicates a default position,
 chosen by either the windowing system or wxPython, depending on platform;
:param wx.Size `size`: the control size. A value of (-1, -1) indicates a default size,
 chosen by either the windowing system or wxPython, depending on platform;
:param integer `style`: the window style.r*  hhh	h)]r*  (X   parentr*  hhr*  X   idr*  X	   wx.ID_ANYr*  X   -1r*  r*  X   posr*  X   wx.DefaultPositionr*  X   (-1, -1)r*  r*  X   sizer*  X   wx.DefaultSizer*  X   (-1, -1)r*  r*  X   styler*  X,   wx.NO_BORDER|wx.WANTS_CHARS|wx.TAB_TRAVERSALr*  X   2883584r*  r*  eh1X   __init__(self, parent, id=wx.ID_ANY, pos=wx.DefaultPosition, size=wx.DefaultSize, style=wx.NO_BORDER|wx.WANTS_CHARS|wx.TAB_TRAVERSAL)r*  h3h4h5X   47r*  h7j*  ubh#)r*  }r*  (hX/   wx.lib.agw.aui.auibook.AuiTabCtrl.DoGetBestSizer*  hKh'KhX   Gets the size which best suits the window: for a control, it would be the
minimal size which doesn't truncate the control, for a panel - the same
size as it would have after a call to `Fit()`.

:note: Overridden from :class:`wx.Control`.r*  hhh	h)]r*  h1X   DoGetBestSize(self)r*  h3h4h5X   11r*  h7j*  ubh#)r*  }r*  (hX2   wx.lib.agw.aui.auibook.AuiTabCtrl.GetDefaultBorderr*  hKh'KhX:   Returns the default border style for :class:`AuiTabCtrl`. r*  hhh	h)]r*  h1X   GetDefaultBorder(self)r*  h3h4h5hIh7j*  ubh#)r*  }r*  (hX1   wx.lib.agw.aui.auibook.AuiTabCtrl.GetPointedToTabr*  hKh'KhXV   Returns the page at which the mouse is pointing (if any).

:rtype: :class:`wx.Window`.r*  hhh	h)]r*  h1X   GetPointedToTab(self)r*  h3h4h5X   11r*  h7j*  ubh#)r*  }r*  (hX,   wx.lib.agw.aui.auibook.AuiTabCtrl.IsDraggingr*  hKh'KhXB   Returns whether the user is dragging a tab with the mouse or not. r*  hhh	h)]r*  h1X   IsDragging(self)r*  h3h4h5hIh7j*  ubh#)r*  }r*  (hX*   wx.lib.agw.aui.auibook.AuiTabCtrl.OnButtonr*  hKh'KhX   Handles the ``EVT_AUINOTEBOOK_BUTTON`` event for :class:`AuiTabCtrl`.

:param `event`: a :class:`AuiNotebookEvent` event to be processed.r*  hhh	h)]r*  X   eventr*  hhr*  ah1X   OnButton(self, event)r*  h3h4h5X   41r*  h7j*  ubh#)r*  }r*  (hX/   wx.lib.agw.aui.auibook.AuiTabCtrl.OnCaptureLostr*  hKh'KhX   Handles the ``wx.EVT_MOUSE_CAPTURE_LOST`` event for :class:`AuiTabCtrl`.

:param `event`: a :class:`MouseCaptureLostEvent` event to be processed.r*  hhh	h)]r*  X   eventr*  hhr*  ah1X   OnCaptureLost(self, event)r*  h3h4h5X   35r*  h7j*  ubh#)r*  }r*  (hX/   wx.lib.agw.aui.auibook.AuiTabCtrl.OnEnterWindowr*  hKh'KhX   Handles the ``wx.EVT_ENTER_WINDOW`` event fof :class:`AuiTabCtrl`.

:param `event`: a :class:`MouseEvent` event to be processed.r*  hhh	h)]r +  X   eventr+  hhr+  ah1X   OnEnterWindow(self, event)r+  h3h4h5j  h7j*  ubh#)r+  }r+  (hX3   wx.lib.agw.aui.auibook.AuiTabCtrl.OnEraseBackgroundr+  hKh'KhX   Handles the ``wx.EVT_ERASE_BACKGROUND`` event for :class:`AuiTabCtrl`.

:param `event`: a :class:`EraseEvent` event to be processed.

:note: This is intentionally empty, to reduce flicker.r+  hhh	h)]r+  X   eventr	+  hhr
+  ah1X   OnEraseBackground(self, event)r+  h3h4h5X   11r+  h7j*  ubh#)r
+  }r+  (hX+   wx.lib.agw.aui.auibook.AuiTabCtrl.OnKeyDownr+  hKh'KhXz   Handles the ``wx.EVT_KEY_DOWN`` event for :class:`AuiTabCtrl`.

:param `event`: a :class:`KeyEvent` event to be processed.r+  hhh	h)]r+  X   eventr+  hhr+  ah1X   OnKeyDown(self, event)r+  h3h4h5X   64r+  h7j*  ubh#)r+  }r+  (hX,   wx.lib.agw.aui.auibook.AuiTabCtrl.OnKeyDown2r+  hKh'KhX   Handles the ``wx.EVT_KEY_DOWN`` event for :class:`AuiTabCtrl`.

:param `event`: a :class:`KeyEvent` event to be processed.

.. deprecated:: 0.6
   This implementation is now deprecated. Refer to :meth:`OnKeyDown` for the correct one.r+  hhh	h)]r+  X   eventr+  hhr+  ah1X   OnKeyDown2(self, event)r+  h3h4h5X   107r+  h7j*  ubh#)r+  }r +  (hX-   wx.lib.agw.aui.auibook.AuiTabCtrl.OnKillFocusr!+  hKh'KhX~   Handles the ``wx.EVT_KILL_FOCUS`` event for :class:`AuiTabCtrl`.

:param `event`: a :class:`FocusEvent` event to be processed.r"+  hhh	h)]r#+  X   eventr$+  hhr%+  ah1X   OnKillFocus(self, event)r&+  h3h4h5j  h7j*  ubh#)r'+  }r(+  (hX/   wx.lib.agw.aui.auibook.AuiTabCtrl.OnLeaveWindowr)+  hKh'KhX   Handles the ``wx.EVT_LEAVE_WINDOW`` event for :class:`AuiTabCtrl`.

:param `event`: a :class:`MouseEvent` event to be processed.r*+  hhh	h)]r++  X   eventr,+  hhr-+  ah1X   OnLeaveWindow(self, event)r.+  h3h4h5X   15r/+  h7j*  ubh#)r0+  }r1+  (hX.   wx.lib.agw.aui.auibook.AuiTabCtrl.OnLeftDClickr2+  hKh'KhX   Handles the ``wx.EVT_LEFT_DCLICK`` event for :class:`AuiTabCtrl`.

:param `event`: a :class:`MouseEvent` event to be processed.r3+  hhh	h)]r4+  X   eventr5+  hhr6+  ah1X   OnLeftDClick(self, event)r7+  h3h4h5X   21r8+  h7j*  ubh#)r9+  }r:+  (hX,   wx.lib.agw.aui.auibook.AuiTabCtrl.OnLeftDownr;+  hKh'KhX}   Handles the ``wx.EVT_LEFT_DOWN`` event for :class:`AuiTabCtrl`.

:param `event`: a :class:`MouseEvent` event to be processed.r<+  hhh	h)]r=+  X   eventr>+  hhr?+  ah1X   OnLeftDown(self, event)r@+  h3h4h5X   53rA+  h7j*  ubh#)rB+  }rC+  (hX*   wx.lib.agw.aui.auibook.AuiTabCtrl.OnLeftUprD+  hKh'KhX{   Handles the ``wx.EVT_LEFT_UP`` event for :class:`AuiTabCtrl`.

:param `event`: a :class:`MouseEvent` event to be processed.rE+  hhh	h)]rF+  X   eventrG+  hhrH+  ah1X   OnLeftUp(self, event)rI+  h3h4h5X   80rJ+  h7j*  ubh#)rK+  }rL+  (hX.   wx.lib.agw.aui.auibook.AuiTabCtrl.OnMiddleDownrM+  hKh'KhX   Handles the ``wx.EVT_MIDDLE_DOWN`` event for :class:`AuiTabCtrl`.

:param `event`: a :class:`MouseEvent` event to be processed.rN+  hhh	h)]rO+  X   eventrP+  hhrQ+  ah1X   OnMiddleDown(self, event)rR+  h3h4h5X   28rS+  h7j*  ubh#)rT+  }rU+  (hX,   wx.lib.agw.aui.auibook.AuiTabCtrl.OnMiddleUprV+  hKh'KhX}   Handles the ``wx.EVT_MIDDLE_UP`` event for :class:`AuiTabCtrl`.

:param `event`: a :class:`MouseEvent` event to be processed.rW+  hhh	h)]rX+  X   eventrY+  hhrZ+  ah1X   OnMiddleUp(self, event)r[+  h3h4h5X   26r\+  h7j*  ubh#)r]+  }r^+  (hX*   wx.lib.agw.aui.auibook.AuiTabCtrl.OnMotionr_+  hKh'KhXz   Handles the ``wx.EVT_MOTION`` event for :class:`AuiTabCtrl`.

:param `event`: a :class:`MouseEvent` event to be processed.r`+  hhh	h)]ra+  X   eventrb+  hhrc+  ah1X   OnMotion(self, event)rd+  h3h4h5X   117re+  h7j*  ubh#)rf+  }rg+  (hX)   wx.lib.agw.aui.auibook.AuiTabCtrl.OnPaintrh+  hKh'KhXy   Handles the ``wx.EVT_PAINT`` event for :class:`AuiTabCtrl`.

:param `event`: a :class:`PaintEvent` event to be processed.ri+  hhh	h)]rj+  X   eventrk+  hhrl+  ah1X   OnPaint(self, event)rm+  h3h4h5X   13rn+  h7j*  ubh#)ro+  }rp+  (hX-   wx.lib.agw.aui.auibook.AuiTabCtrl.OnRightDownrq+  hKh'KhX~   Handles the ``wx.EVT_RIGHT_DOWN`` event for :class:`AuiTabCtrl`.

:param `event`: a :class:`MouseEvent` event to be processed.rr+  hhh	h)]rs+  X   eventrt+  hhru+  ah1X   OnRightDown(self, event)rv+  h3h4h5X   23rw+  h7j*  ubh#)rx+  }ry+  (hX+   wx.lib.agw.aui.auibook.AuiTabCtrl.OnRightUprz+  hKh'KhX|   Handles the ``wx.EVT_RIGHT_UP`` event for :class:`AuiTabCtrl`.

:param `event`: a :class:`MouseEvent` event to be processed.r{+  hhh	h)]r|+  X   eventr}+  hhr~+  ah1X   OnRightUp(self, event)r+  h3h4h5X   21r+  h7j*  ubh#)r+  }r+  (hX,   wx.lib.agw.aui.auibook.AuiTabCtrl.OnSetFocusr+  hKh'KhX}   Handles the ``wx.EVT_SET_FOCUS`` event for :class:`AuiTabCtrl`.

:param `event`: a :class:`FocusEvent` event to be processed.r+  hhh	h)]r+  X   eventr+  hhr+  ah1X   OnSetFocus(self, event)r+  h3h4h5j  h7j*  ubh#)r+  }r+  (hX(   wx.lib.agw.aui.auibook.AuiTabCtrl.OnSizer+  hKh'KhXz   Handles the ``wx.EVT_SIZE`` event for :class:`AuiTabCtrl`.

:param `event`: a :class:`wx.SizeEvent` event to be processed.r+  hhh	h)]r+  X   eventr+  hhr+  ah1X   OnSize(self, event)r+  h3h4h5X   10r+  h7j*  ubh#)r+  }r+  (hX5   wx.lib.agw.aui.auibook.AuiTabCtrl.RestartTooltipTimerr+  hKh'KhX   Starts a timer: when it fires, a tooltip will be shown on the notebook tab
the mouse is pointing at.

:param wx.Window `wnd`: the window pointed by the mouse.r+  hhh	h)]r+  X   wndr+  hhr+  ah1X   RestartTooltipTimer(self, wnd)r+  h3h4h5X   16r+  h7j*  ubh#)r+  }r+  (hX-   wx.lib.agw.aui.auibook.AuiTabCtrl.ShowTooltipr+  hKh'KhX   Shows the tooltip on the tab. r+  hhh	h)]r+  h1X   ShowTooltip(self)r+  h3h4h5X   24r+  h7j*  ubh#)r+  }r+  (hX2   wx.lib.agw.aui.auibook.AuiTabCtrl.StopTooltipTimerr+  hKh'KhXO   Stops the timer keeping track of tooltips and mouse movements on the tab area. r+  hhh	h)]r+  h1X   StopTooltipTimer(self)r+  h3h4h5jA  h7j*  ubehd]r+  (]r+  X   objectr+  a]r+  (]r+  X
   simplewrapperr+  a]r+  (]r+  X   wrapperr+  a]r+  (]r+  j  a]r+  (]r+  j  a]r+  (]r+  j  a]r+  (]r+  j  a]r+  (]r+  j  a]r+  ]r+  X
   AuiTabCtrlr+  aaeeee]r+  j  a]r+  (]r+  j  a]r+  (]r+  j  a]r+  (]r+  j  a]r+  (]r+  j  a]r+  ]r+  j+  aaeeeeee]r+  j[*  a]r+  ]r+  j+  aaeehk]r+  hm]r+  (X
   wx.Controlr+  X&   wx.lib.agw.aui.auibook.AuiTabContainerr+  eh1X'   AuiTabCtrl(wx.Control, AuiTabContainer)r+  hpj  )r+  }r+  (j  ]r+  (X!   wx.lib.agw.aui.auibook.AuiTabCtrlr+  ]r+  (X
   wx.Controlr+  X&   wx.lib.agw.aui.auibook.AuiTabContainerr+  er+  X
   wx.Controlr+  ]r+  X	   wx.Windowr+  ar+  X	   wx.Windowr+  ]r+  X
   wx.WindowBaser+  ar+  X
   wx.WindowBaser+  ]r+  X
   wx.EvtHandlerr+  ar+  X
   wx.EvtHandlerr+  ]r+  (X	   wx.Objectr+  X   wx.Trackabler+  er+  X	   wx.Objectr+  ]r+  r+  X   wx.Trackabler+  ]r+  r+  X&   wx.lib.agw.aui.auibook.AuiTabContainerr+  ]r+  r+  ej  ]r+  X!   wx.lib.agw.aui.auibook.AuiTabCtrlr+  aj  j*  ubh'Kh3hqhrXT   /home/wxpy/bb2/dist-src-py37/build/docs/sphinx/wx.lib.agw.aui.auibook.AuiTabCtrl.txtr+  h7j#  h5X   849r+  j  ]r+  (X   __init__r+  X
   DoGetBestSizer+  X   GetDefaultBorderr+  X   GetPointedToTabr+  X
   IsDraggingr+  X   OnButtonr+  X
   OnCaptureLostr+  X
   OnEnterWindowr+  X   OnEraseBackgroundr ,  X	   OnKeyDownr,  X
   OnKeyDown2r,  X   OnKillFocusr,  X
   OnLeaveWindowr,  X   OnLeftDClickr,  X
   OnLeftDownr,  X   OnLeftUpr,  X   OnMiddleDownr,  X
   OnMiddleUpr	,  X   OnMotionr
,  X   OnPaintr,  X   OnRightDownr,  X	   OnRightUpr
,  X
   OnSetFocusr,  X   OnSizer,  X   RestartTooltipTimerr,  X   ShowTooltipr,  X   StopTooltipTimerr,  ej  j+  ubh)r,  }r,  (hX+   wx.lib.agw.aui.auibook.CommandNotebookEventr,  hKhXL   A specialized command event class for events sent by :class:`AuiNotebook` . r,  hhh	h
]r,  (h#)r,  }r,  (hX4   wx.lib.agw.aui.auibook.CommandNotebookEvent.__init__r,  hKh'KhX   Default class constructor.

:param `command_type`: the event kind or an instance of :class:`PyCommandEvent`.
:param integer `win_id`: the window identification number.r,  hhh	h)]r,  (X   command_typer,  X   Noner,  X   Noner,  r ,  X   win_idr!,  j  X   0r",  r#,  eh1X+   __init__(self, command_type=None, win_id=0)r$,  h3h4h5X   21r%,  h7j,  ubh#)r&,  }r',  (hX9   wx.lib.agw.aui.auibook.CommandNotebookEvent.GetDispatchedr(,  hKh'KhXU   Returns whether the event was dispatched (used for automatic :class:`AuiNotebook` ). r),  hhh	h)]r*,  h1X   GetDispatched(self)r+,  h3h4h5hIh7j,  ubh#)r,,  }r-,  (hX9   wx.lib.agw.aui.auibook.CommandNotebookEvent.GetDragSourcer.,  hKh'KhX"   Returns the drag and drop source. r/,  hhh	h)]r0,  h1X   GetDragSource(self)r1,  h3h4h5hIh7j,  ubh#)r2,  }r3,  (hX4   wx.lib.agw.aui.auibook.CommandNotebookEvent.GetLabelr4,  hKh'KhXU   Returns the label-itemtext (for ``EVT_AUINOTEBOOK_BEGIN`` | ``END_LABEL_EDIT`` only).r5,  hhh	h)]r6,  h1X   GetLabel(self)r7,  h3h4h5hIh7j,  ubh#)r8,  }r9,  (hX;   wx.lib.agw.aui.auibook.CommandNotebookEvent.GetOldSelectionr:,  hKh'KhXQ   Returns the page that was selected before the change, or -1 if none was
selected.r;,  hhh	h)]r<,  h1X   GetOldSelection(self)r=,  h3h4h5j~  h7j,  ubh#)r>,  }r?,  (hX8   wx.lib.agw.aui.auibook.CommandNotebookEvent.GetSelectionr@,  hKh'KhXA   Returns the currently selected page, or -1 if none was selected. rA,  hhh	h)]rB,  h1X   GetSelection(self)rC,  h3h4h5hIh7j,  ubh#)rD,  }rE,  (hX;   wx.lib.agw.aui.auibook.CommandNotebookEvent.IsEditCancelledrF,  hKh'KhXW   Returns the edit cancel flag (for ``EVT_AUINOTEBOOK_BEGIN`` | ``END_LABEL_EDIT`` only).rG,  hhh	h)]rH,  h1X   IsEditCancelled(self)rI,  h3h4h5hIh7j,  ubh#)rJ,  }rK,  (hX9   wx.lib.agw.aui.auibook.CommandNotebookEvent.SetDispatchedrL,  hKh'KhX~   Sets the event as dispatched (used for automatic :class:`AuiNotebook` ).

:param `b`: whether the event was dispatched or not.rM,  hhh	h)]rN,  j  hhrO,  ah1X   SetDispatched(self, b)rP,  h3h4h5j  h7j,  ubh#)rQ,  }rR,  (hX9   wx.lib.agw.aui.auibook.CommandNotebookEvent.SetDragSourcerS,  hKh'KhX<   Sets the drag and drop source.

:param `s`: the drag source.rT,  hhh	h)]rU,  j  hhrV,  ah1X   SetDragSource(self, s)rW,  h3h4h5j  h7j,  ubh#)rX,  }rY,  (hX;   wx.lib.agw.aui.auibook.CommandNotebookEvent.SetEditCanceledrZ,  hKh'KhX   Sets the edit cancel flag (for ``EVT_AUINOTEBOOK_BEGIN`` | ``END_LABEL_EDIT`` only).

:param bool `editCancelled`: whether the editing action has been cancelled or not.r[,  hhh	h)]r\,  X
   editCancelledr],  hhr^,  ah1X$   SetEditCanceled(self, editCancelled)r_,  h3h4h5j  h7j,  ubh#)r`,  }ra,  (hX4   wx.lib.agw.aui.auibook.CommandNotebookEvent.SetLabelrb,  hKh'KhXj   Sets the label. Useful only for ``EVT_AUINOTEBOOK_END_LABEL_EDIT``.

:param string `label`: the new label.rc,  hhh	h)]rd,  X   labelre,  hhrf,  ah1X   SetLabel(self, label)rg,  h3h4h5j  h7j,  ubh#)rh,  }ri,  (hX;   wx.lib.agw.aui.auibook.CommandNotebookEvent.SetOldSelectionrj,  hKh'KhX[   Sets the id of the page selected before the change.

:param integer `s`: the old selection.rk,  hhh	h)]rl,  j  hhrm,  ah1X   SetOldSelection(self, s)rn,  h3h4h5j  h7j,  ubh#)ro,  }rp,  (hX8   wx.lib.agw.aui.auibook.CommandNotebookEvent.SetSelectionrq,  hKh'KhXK   Sets the selection member variable.

:param integer `s`: the new selection.rr,  hhh	h)]rs,  j  hhrt,  ah1X   SetSelection(self, s)ru,  h3h4h5X   10rv,  h7j,  ubhO)rw,  }rx,  (hX0   wx.lib.agw.aui.auibook.CommandNotebookEvent.Pagery,  hKh'Khhhhh	hSj'  hUj'  hVhh3hWh7j,  ubhO)rz,  }r{,  (hX5   wx.lib.agw.aui.auibook.CommandNotebookEvent.Selectionr|,  hKh'Khhhhh	hSj'  hUj'  hVhh3hWh7j,  ubehd]r},  (]r~,  X   objectr,  a]r,  (]r,  X
   simplewrapperr,  a]r,  (]r,  X   wrapperr,  a]r,  (]r,  j  a]r,  (]r,  j  a]r,  (]r,  j  a]r,  (]r,  j  a]r,  ]r,  j(  aaeeeeeeehk]r,  X'   wx.lib.agw.aui.auibook.AuiNotebookEventr,  ahm]r,  X   wx.PyCommandEventr,  ah1X'   CommandNotebookEvent(wx.PyCommandEvent)r,  hpj  )r,  }r,  (j  ]r,  (X+   wx.lib.agw.aui.auibook.CommandNotebookEventr,  ]r,  X   wx.PyCommandEventr,  ar,  X   wx.PyCommandEventr,  ]r,  X   wx.CommandEventr,  ar,  X   wx.CommandEventr,  ]r,  X   wx.Eventr,  ar,  X   wx.Eventr,  ]r,  X	   wx.Objectr,  ar,  X	   wx.Objectr,  ]r,  r,  ej  ]r,  X+   wx.lib.agw.aui.auibook.CommandNotebookEventr,  aj  j,  ubh'Kh3hqhrX^   /home/wxpy/bb2/dist-src-py37/build/docs/sphinx/wx.lib.agw.aui.auibook.CommandNotebookEvent.txtr,  h7j#  h5X   129r,  j  ]r,  (X   __init__r,  X
   GetDispatchedr,  X
   GetDragSourcer,  X   GetLabelr,  X   GetOldSelectionr,  X   GetSelectionr,  X   IsEditCancelledr,  X
   SetDispatchedr,  X
   SetDragSourcer,  X   SetEditCanceledr,  X   SetLabelr,  X   SetOldSelectionr,  X   SetSelectionr,  ej  j,  ubh)r,  }r,  (hX&   wx.lib.agw.aui.auibook.ExpandoTextCtrlr,  hKhX  The ExpandoTextCtrl is a multi-line wx.TextCtrl that will
adjust its height on the fly as needed to accommodate the number of
lines needed to display the current content of the control.  It is
assumed that the width of the control will be a fixed value and
that only the height will be adjusted automatically.  If the
control is used in a sizer then the width should be set as part of
the initial or min size of the control.

When the control resizes itself it will attempt to also make
necessary adjustments in the sizer hierarchy it is a member of (if
any) but if that is not suffiecient then the programmer can catch
the EVT_ETC_LAYOUT_NEEDED event in the container and make any
other layout adjustments that may be needed.r,  hhh	h
]r,  (h#)r,  }r,  (hX/   wx.lib.agw.aui.auibook.ExpandoTextCtrl.__init__r,  hKh'KhX  Default class constructor.

:param `parent`: parent window, must not be ``None``;
:param integer `id`: window identifier. A value of -1 indicates a default value;
:param string `value`: the control text label;
:param `pos`: the control position. A value of (-1, -1) indicates a default position,
 chosen by either the windowing system or wxPython, depending on platform;
:param `size`: the control size. A value of (-1, -1) indicates a default size,
 chosen by either the windowing system or wxPython, depending on platform;
:param integer `style`: the underlying :class:`wx.Control` style;
:param wx.Validator `validator`: the window validator;
:param string `name`: the widget name.

:type parent: :class:`wx.Window`
:type pos: tuple or :class:`wx.Point`
:type size: tuple or :class:`wx.Size`r,  hhh	h)]r,  (X   parentr,  hhr,  X   idr,  X   -1r,  X   -1r,  r,  X   valuer,  X   ""r,  hr,  X   posr,  X   wx.DefaultPositionr,  X   (-1, -1)r,  r,  X   sizer,  X   wx.DefaultSizer,  X   (-1, -1)r,  r,  X   styler,  j  X   0r,  r,  X	   validatorr,  X   wx.DefaultValidatorr,  X-   <wx._core.Validator object at 0x7f7afe99a870>r,  r,  X   namer,  X	   "expando"r,  X   expandor,  r,  eh1X   __init__(self, parent, id=-1, value="", pos=wx.DefaultPosition,  size=wx.DefaultSize, style=0, validator=wx.DefaultValidator, name="expando")r,  h3h4h5X   43r,  h7j,  ubh#)r,  }r,  (hX1   wx.lib.agw.aui.auibook.ExpandoTextCtrl.AppendTextr,  hKh'KhX   Appends the text to the end of the text control.

:param string `text`: text to write to the text control.

.. seealso:: :meth:`WriteText`r,  hhh	h)]r,  X   textr,  hhr,  ah1X   AppendText(self, text)r,  h3h4h5X   16r,  h7j,  ubh#)r,  }r,  (hX3   wx.lib.agw.aui.auibook.ExpandoTextCtrl.GetMaxHeightr,  hKh'KhXS   Returns the maximum height that the control will expand to on its own.

:rtype: intr,  hhh	h)]r,  h1X   GetMaxHeight(self)r,  h3h4h5j  h7j,  ubh#)r,  }r,  (hX7   wx.lib.agw.aui.auibook.ExpandoTextCtrl.GetNumberOfLinesr,  hKh'KhXR   GetNumberOfLines() -> int

Returns the number of lines in the text control buffer.r,  hhh	h)]r,  h1X   GetNumberOfLines(self)r,  h3h4h5X   18r,  h7j,  ubh#)r,  }r,  (hX-   wx.lib.agw.aui.auibook.ExpandoTextCtrl.OnSizer,  hKh'KhX   Handles the ``wx.EVT_SIZE`` event for :class:`ExpandoTextCtrl`.

:param `event`: a :class:`wx.SizeEvent` event to be processed.r,  hhh	h)]r,  X   evtr -  hhr-  ah1X   OnSize(self, evt)r-  h3h4h5X   11r-  h7j,  ubh#)r-  }r-  (hX4   wx.lib.agw.aui.auibook.ExpandoTextCtrl.OnTextChangedr-  hKh'KhX   Handles the ``wx.EVT_TEXT`` event for :class:`ExpandoTextCtrl`.

:param `event`: a :class:`CommandEvent` event to be processed.r-  hhh	h)]r-  X   evtr	-  hhr
-  ah1X   OnTextChanged(self, evt)r-  h3h4h5X   11r-  h7j,  ubh#)r
-  }r-  (hX.   wx.lib.agw.aui.auibook.ExpandoTextCtrl.SetFontr-  hKh'KhX0  Sets the font for the :class:`ExpandoTextCtrl`.

:param wx.Font font: font to associate with the :class:`ExpandoTextCtrl`, pass
 ``NullFont`` to reset to the default font.

:rtype: bool
:returns: ``True`` if the font was really changed, ``False`` if it was already
 set to this font and nothing was done.r-  hhh	h)]r-  X   fontr-  hhr-  ah1X   SetFont(self, font)r-  h3h4h5X   18r-  h7j,  ubh#)r-  }r-  (hX3   wx.lib.agw.aui.auibook.ExpandoTextCtrl.SetMaxHeightr-  hKh'KhX   Sets the maximum height that the control will expand to on its
own, and adjusts it down if needed.

:param integer `h`: the maximum control height, in pixels.r-  hhh	h)]r-  j  hhr-  ah1X   SetMaxHeight(self, h)r-  h3h4h5X   12r-  h7j,  ubh#)r-  }r-  (hX0   wx.lib.agw.aui.auibook.ExpandoTextCtrl.WriteTextr -  hKh'KhXd  Writes the text into the text control at the current insertion position.

:param string `text`: text to write to the text control.

.. note::

   Newlines in the text string are the only control characters allowed, and they
   will cause appropriate line breaks. See :meth:`AppendText` for more convenient
   ways of writing to the window. After the write operation, the insertion point
   will be at the end of the inserted text, so subsequent write operations will
   be appended. To append text after the user may have interacted with the control,
   call :meth:`TextCtrl.SetInsertionPointEnd` before writing.r!-  hhh	h)]r"-  X   textr#-  hhr$-  ah1X   WriteText(self, text)r%-  h3h4h5X   22r&-  h7j,  ubehd]r'-  (]r(-  X   objectr)-  a]r*-  (]r+-  X
   simplewrapperr,-  a]r--  (]r.-  X   wrapperr/-  a]r0-  (]r1-  j  a]r2-  (]r3-  j  a]r4-  (]r5-  j  a]r6-  (]r7-  j  a]r8-  (]r9-  j  a]r:-  (]r;-  X   TextCtrlr<-  a]r=-  ]r>-  X   ExpandoTextCtrlr?-  aaeeeee]r@-  X	   TextEntryrA-  a]rB-  (]rC-  j<-  a]rD-  ]rE-  j?-  aae]rF-  j  a]rG-  (]rH-  j  a]rI-  (]rJ-  j  a]rK-  (]rL-  j  a]rM-  (]rN-  j  a]rO-  (]rP-  j<-  a]rQ-  ]rR-  j?-  aaeeeeeeeeehk]rS-  X"   wx.lib.agw.aui.auibook.TabTextCtrlrT-  ahm]rU-  X   wx.TextCtrlrV-  ah1X   ExpandoTextCtrl(wx.TextCtrl)rW-  hpNh'Kh3hqhrXY   /home/wxpy/bb2/dist-src-py37/build/docs/sphinx/wx.lib.agw.aui.auibook.ExpandoTextCtrl.txtrX-  h7j#  h5X   272rY-  ubh)rZ-  }r[-  (hX&   wx.lib.agw.aui.auibook.PyEmbeddedImager\-  hKhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.r]-  hhh	h
]r^-  (h#)r_-  }r`-  (hX/   wx.lib.agw.aui.auibook.PyEmbeddedImage.__init__ra-  hKh'KhX>   Initialize self.  See help(type(self)) for accurate signature.rb-  hhh	h)]rc-  (X   datard-  hhre-  X   isBase64rf-  X   Truerg-  h/rh-  eh1X#   __init__(self, data, isBase64=True)ri-  h3h4h5h6h7jZ-  ubh#)rj-  }rk-  (hX0   wx.lib.agw.aui.auibook.PyEmbeddedImage.GetBitmaprl-  hKh'Khhhhh	h)]rm-  h1X   GetBitmap(self)rn-  h3h4h5h=h7jZ-  ubh#)ro-  }rp-  (hX.   wx.lib.agw.aui.auibook.PyEmbeddedImage.GetDatarq-  hKh'Khhhhh	h)]rr-  h1X
   GetData(self)rs-  h3h4h5hCh7jZ-  ubh#)rt-  }ru-  (hX.   wx.lib.agw.aui.auibook.PyEmbeddedImage.GetIconrv-  hKh'Khhhhh	h)]rw-  h1X
   GetIcon(self)rx-  h3h4h5hIh7jZ-  ubh#)ry-  }rz-  (hX/   wx.lib.agw.aui.auibook.PyEmbeddedImage.GetImager{-  hKh'Khhhhh	h)]r|-  h1X   GetImage(self)r}-  h3h4h5h6h7jZ-  ubhO)r~-  }r-  (hX-   wx.lib.agw.aui.auibook.PyEmbeddedImage.Bitmapr-  hKh'Khhhhh	hShThUhhVhh3hWh7jZ-  ubhO)r-  }r-  (hX+   wx.lib.agw.aui.auibook.PyEmbeddedImage.Datar-  hKh'Khhhhh	hSh[hUhhVhh3hWh7jZ-  ubhO)r-  }r-  (hX+   wx.lib.agw.aui.auibook.PyEmbeddedImage.Iconr-  hKh'Khhhhh	hSh_hUhhVhh3hWh7jZ-  ubhO)r-  }r-  (hX,   wx.lib.agw.aui.auibook.PyEmbeddedImage.Imager-  hKh'Khhhhh	hShchUhhVhh3hWh7jZ-  ubehd]r-  (]r-  X   objectr-  a]r-  ]r-  hjaaehk]r-  hm]r-  h1X   PyEmbeddedImage(object)r-  hpNh'Kh3hqhrXY   /home/wxpy/bb2/dist-src-py37/build/docs/sphinx/wx.lib.agw.aui.auibook.PyEmbeddedImage.txtr-  h7j#  h5X   52r-  ubh)r-  }r-  (hX#   wx.lib.agw.aui.auibook.TabDragImager-  hKhX]   This class handles the creation of a custom image in case of drag and drop of a notebook tab.r-  hhh	h
]r-  (h#)r-  }r-  (hX,   wx.lib.agw.aui.auibook.TabDragImage.__init__r-  hKh'KhX  Default class constructor.

For internal use: do not call it in your code!

:param `notebook`: an instance of :class:`~wx.lib.agw.aui.auibook.AuiNotebook`;
:param `page`: the dragged :class:`~wx.lib.agw.aui.auibook.AuiNotebookPage` page;
:param integer `button_state`: the state of the close button on the tab;
:param `tabArt`: an instance of :class:`~wx.lib.agw.aui.tabart.AuiDefaultTabArt` or one of its derivations.r-  hhh	h)]r-  (X   notebookr-  hhr-  X   pager-  hhr-  X   button_stater-  hhr-  X   tabArtr-  hhr-  eh1X4   __init__(self, notebook, page, button_state, tabArt)r-  h3h4h5X   16r-  h7j-  ubh#)r-  }r-  (hX0   wx.lib.agw.aui.auibook.TabDragImage.CreateBitmapr-  hKh'KhX  Actually creates the drag and drop bitmap.

:param `notebook`: an instance of :class:`~wx.lib.agw.aui.auibook.AuiNotebook`;
:param `page`: the dragged :class:`~wx.lib.agw.aui.auibook.AuiNotebookPage` page;
:param integer `button_state`: the state of the close button on the tab;
:param `tabArt`: an instance of :class:`~wx.lib.agw.aui.tabart.AuiDefaultTabArt` or one of its derivations.r-  hhh	h)]r-  (X   notebookr-  hhr-  X   pager-  hhr-  X   button_stater-  hhr-  X   tabArtr-  hhr-  eh1X8   CreateBitmap(self, notebook, page, button_state, tabArt)r-  h3h4h5X   67r-  h7j-  ubehd]r-  (]r-  X   objectr-  a]r-  (]r-  X
   simplewrapperr-  a]r-  (]r-  X   wrapperr-  a]r-  (]r-  j  a]r-  (]r-  j  a]r-  ]r-  j  aaeeeeehk]r-  hm]r-  X   wx.DragImager-  ah1X   TabDragImage(wx.DragImage)r-  hpNh'Kh3hqhrXV   /home/wxpy/bb2/dist-src-py37/build/docs/sphinx/wx.lib.agw.aui.auibook.TabDragImage.txtr-  h7j#  h5X   89r-  ubh)r-  }r-  (hX   wx.lib.agw.aui.auibook.TabFramer-  hKhX  TabFrame is an interesting case. It's important that all child pages
of the multi-notebook control are all actually children of that control
(and not grandchildren). TabFrame facilitates this. There is one
instance of TabFrame for each tab control inside the multi-notebook.

It's important to know that TabFrame is not a real window, but it merely
used to capture the dimensions/positioning of the internal tab control and
it's managed page windows.r-  hhh	h
]r-  (h#)r-  }r-  (hX(   wx.lib.agw.aui.auibook.TabFrame.__init__r-  hKh'KhXH   Default class constructor.
Used internally, do not call it in your code!r-  hhh	h)]r-  X   parentr-  hhr-  ah1X   __init__(self, parent)r-  h3h4h5X   16r-  h7j-  ubh#)r-  }r-  (hX/   wx.lib.agw.aui.auibook.TabFrame.DoGetClientSizer-  hKh'KhXL   Returns the window client size.

:note: Overridden from :class:`wx.Control`.r-  hhh	h)]r-  h1X   DoGetClientSize(self)r-  h3h4h5j  h7j-  ubh#)r-  }r-  (hX)   wx.lib.agw.aui.auibook.TabFrame.DoGetSizer-  hKh'KhXE   Returns the window size.

:note: Overridden from :class:`wx.Control`.r-  hhh	h)]r-  h1X   DoGetSize(self)r-  h3h4h5j  h7j-  ubh#)r-  }r-  (hX)   wx.lib.agw.aui.auibook.TabFrame.DoSetSizer-  hKh'KhX  Sets the position and size of the window in pixels. The `flags`
parameter indicates the interpretation of the other params if they are
equal to -1.

:param integer `x`: the window `x` position;
:param integer `y`: the window `y` position;
:param integer `width`: the window width;
:param integer `height`: the window height;
:param integer `flags`: may have one of this bit set:

 ===================================  ======================================
 Size Flags                           Description
 ===================================  ======================================
 ``wx.SIZE_AUTO``                     A -1 indicates that a class-specific default should be used.
 ``wx.SIZE_AUTO_WIDTH``               A -1 indicates that a class-specific default should be used for the width.
 ``wx.SIZE_AUTO_HEIGHT``              A -1 indicates that a class-specific default should be used for the height.
 ``wx.SIZE_USE_EXISTING``             Existing dimensions should be used if -1 values are supplied.
 ``wx.SIZE_ALLOW_MINUS_ONE``          Allow dimensions of -1 and less to be interpreted as real dimensions, not default values.
 ``wx.SIZE_FORCE``                    Normally, if the position and the size of the window are already the same as the
                                      parameters of this function, nothing is done. but with this flag a window resize
                                      may be forced even in this case (supported in wx 2.6.2 and later and only implemented
                                      for MSW and ignored elsewhere currently)
 ===================================  ======================================

:note: Overridden from :class:`wx.Control`.r-  hhh	h)]r-  (j  hhr-  j  hhr-  X   widthr-  hhr-  X   heightr-  hhr-  X   flagsr-  X   wx.SIZE_AUTOr-  X   3r-  r-  eh1X8   DoSetSize(self, x, y, width, height, flags=wx.SIZE_AUTO)r-  h3h4h5X   32r-  h7j-  ubh#)r-  }r-  (hX(   wx.lib.agw.aui.auibook.TabFrame.DoSizingr-  hKh'KhX+   Does the actual sizing of the tab control. r-  hhh	h)]r-  h1X   DoSizing(self)r-  h3h4h5X   63r-  h7j-  ubh#)r-  }r-  (hX0   wx.lib.agw.aui.auibook.TabFrame.SetTabCtrlHeightr .  hKh'KhXF   Sets the tab control height.

:param integer `h`: the tab area height.r.  hhh	h)]r.  j  hhr.  ah1X   SetTabCtrlHeight(self, h)r.  h3h4h5j  h7j-  ubh#)r.  }r.  (hX$   wx.lib.agw.aui.auibook.TabFrame.Showr.  hKh'KhX   Shows/hides the window.

:param bool `show`: ``True`` to show the window, ``False`` otherwise.

:note:

 Overridden from :class:`wx.Control`, this method always returns ``False`` as
 :class:`TabFrame` should never be phisically shown on screen.r.  hhh	h)]r	.  X   showr
.  X   Truer.  h/r.  ah1X   Show(self, show=True)r
.  h3h4h5X   14r.  h7j-  ubh#)r.  }r.  (hX&   wx.lib.agw.aui.auibook.TabFrame.Updater.  hKh'KhX  Calling this method immediately repaints the invalidated area of the window
and all of its children recursively while this would usually only happen when
the flow of control returns to the event loop.

:note: Notice that this function doesn't invalidate any area of the window so
 nothing happens if nothing has been invalidated (i.e. marked as requiring a redraw).
 Use `Refresh` first if you want to immediately redraw the window unconditionally.

:note: Overridden from :class:`wx.Control`.r.  hhh	h)]r.  h1X   Update(self)r.  h3h4h5X   16r.  h7j-  ubehd]r.  (]r.  X   objectr.  a]r.  (]r.  X
   simplewrapperr.  a]r.  (]r.  X   wrapperr.  a]r.  (]r .  j  a]r!.  (]r".  j  a]r#.  (]r$.  j  a]r%.  (]r&.  j  a]r'.  ]r(.  X   TabFramer).  aaeee]r*.  j  a]r+.  (]r,.  j  a]r-.  (]r..  j  a]r/.  (]r0.  j  a]r1.  ]r2.  j).  aaeeeeeeehk]r3.  hm]r4.  X	   wx.Windowr5.  ah1X   TabFrame(wx.Window)r6.  hpj  )r7.  }r8.  (j  ]r9.  (X   wx.lib.agw.aui.auibook.TabFramer:.  ]r;.  X	   wx.Windowr<.  ar=.  X	   wx.Windowr>.  ]r?.  X
   wx.WindowBaser@.  arA.  X
   wx.WindowBaserB.  ]rC.  X
   wx.EvtHandlerrD.  arE.  X
   wx.EvtHandlerrF.  ]rG.  (X	   wx.ObjectrH.  X   wx.TrackablerI.  erJ.  X	   wx.ObjectrK.  ]rL.  rM.  X   wx.TrackablerN.  ]rO.  rP.  ej  ]rQ.  X   wx.lib.agw.aui.auibook.TabFramerR.  aj  j-  ubh'Kh3hqhrXR   /home/wxpy/bb2/dist-src-py37/build/docs/sphinx/wx.lib.agw.aui.auibook.TabFrame.txtrS.  h7j#  h5X   187rT.  j  ]rU.  (X   __init__rV.  X   DoGetClientSizerW.  X	   DoGetSizerX.  X	   DoSetSizerY.  X   DoSizingrZ.  X   SetTabCtrlHeightr[.  X   Showr\.  X   Updater].  ej  j4.  ubh)r^.  }r_.  (hX(   wx.lib.agw.aui.auibook.TabNavigatorPropsr`.  hKhX_   Data storage class for managing and providing access to :class:`TabNavigatorWindow` properties.ra.  hhh	h
]rb.  (h#)rc.  }rd.  (hX1   wx.lib.agw.aui.auibook.TabNavigatorProps.__init__re.  hKh'KhX   Default class constructor. rf.  hhh	h)]rg.  h1X   __init__(self)rh.  h3h4h5X   10ri.  h7j^.  ubhO)rj.  }rk.  (hX-   wx.lib.agw.aui.auibook.TabNavigatorProps.Fontrl.  hKh'KhXR   Sets/Gets the font for the L{TabNavigatorWindow}, an instance of :class:`wx.Font`.rm.  hhh	hSj'  hUj'  hVhh3hWh7j^.  ubhO)rn.  }ro.  (hX-   wx.lib.agw.aui.auibook.TabNavigatorProps.Iconrp.  hKh'KhXT   Sets/Gets the icon for the L{TabNavigatorWindow}, an instance of :class:`wx.Bitmap`.rq.  hhh	hSj'  hUj'  hVhh3hWh7j^.  ubhO)rr.  }rs.  (hX0   wx.lib.agw.aui.auibook.TabNavigatorProps.MinSizert.  hKh'KhXZ   Sets/Gets the minimum size for the L{TabNavigatorWindow}, an instance of :class:`wx.Size`.ru.  hhh	hSj'  hUj'  hVhh3hWh7j^.  ubehd]rv.  (]rw.  X   objectrx.  a]ry.  ]rz.  X   TabNavigatorPropsr{.  aaehk]r|.  hm]r}.  h1X   TabNavigatorProps(object)r~.  hpj  )r.  }r.  (j  ]r.  X(   wx.lib.agw.aui.auibook.TabNavigatorPropsr.  ]r.  r.  aj  ]r.  X(   wx.lib.agw.aui.auibook.TabNavigatorPropsr.  aj  j^.  ubh'Kh3hqhrX[   /home/wxpy/bb2/dist-src-py37/build/docs/sphinx/wx.lib.agw.aui.auibook.TabNavigatorProps.txtr.  h7j#  h5X   26r.  j  ]r.  X   __init__r.  aj  j}.  ubh)r.  }r.  (hX)   wx.lib.agw.aui.auibook.TabNavigatorWindowr.  hKhX   This class is used to create a modal dialog that enables "Smart Tabbing",
similar to what you would get by hitting ``Alt`` + ``Tab`` on Windows.r.  hhh	h
]r.  (h#)r.  }r.  (hX2   wx.lib.agw.aui.auibook.TabNavigatorWindow.__init__r.  hKh'KhX   Default class constructor. Used internally.

:param `parent`: the :class:`TabNavigatorWindow` parent;
:param `props`: the :class:`TabNavigatorProps` object.
:param `centreOnMouse`: popup position of the dialog at mouse cursor. Defaults to Centre.r.  hhh	h)]r.  (X   parentr.  hhr.  X   propsr.  hhr.  X
   centreOnMouser.  X   Falser.  jB  r.  eh1X2   __init__(self, parent, props, centreOnMouse=False)r.  h3h4h5X   87r.  h7j.  ubh#)r.  }r.  (hX5   wx.lib.agw.aui.auibook.TabNavigatorWindow.CloseDialogr.  hKh'KhXZ   Closes the :class:`TabNavigatorWindow` dialog, setting selection in :class:`AuiNotebook`. r.  hhh	h)]r.  X   returnIdr.  X   wx.ID_OKr.  X   5100r.  r.  ah1X$   CloseDialog(self, returnId=wx.ID_OK)r.  h3h4h5j~  h7j.  ubh#)r.  }r.  (hX9   wx.lib.agw.aui.auibook.TabNavigatorWindow.GetSelectedPager.  hKh'KhXB   Gets the page index that was selected when the dialog was closed. r.  hhh	h)]r.  h1X   GetSelectedPage(self)r.  h3h4h5hIh7j.  ubh#)r.  }r.  (hX8   wx.lib.agw.aui.auibook.TabNavigatorWindow.OnItemSelectedr.  hKh'KhX   Handles the ``wx.EVT_LISTBOX_DCLICK`` event for the :class:`ListBox` inside :class:`TabNavigatorWindow`.

:param `event`: a :class:`ListEvent` event to be processed.r.  hhh	h)]r.  X   eventr.  hhr.  ah1X   OnItemSelected(self, event)r.  h3h4h5j  h7j.  ubh#)r.  }r.  (hX1   wx.lib.agw.aui.auibook.TabNavigatorWindow.OnKeyUpr.  hKh'KhX~   Handles the ``wx.EVT_KEY_UP`` for the :class:`TabNavigatorWindow`.

:param `event`: a :class:`KeyEvent` event to be processed.r.  hhh	h)]r.  X   eventr.  hhr.  ah1X   OnKeyUp(self, event)r.  h3h4h5X   12r.  h7j.  ubh#)r.  }r.  (hX4   wx.lib.agw.aui.auibook.TabNavigatorWindow.OnLeftDownr.  hKh'KhXu   Handles the ``wx.EVT_LEFT_DOWN`` event for self._panel.

:param `event`: a :class:`MouseEvent` event to be processed.r.  hhh	h)]r.  X   eventr.  hhr.  ah1X   OnLeftDown(self, event)r.  h3h4h5X   17r.  h7j.  ubh#)r.  }r.  (hX2   wx.lib.agw.aui.auibook.TabNavigatorWindow.OnLeftUpr.  hKh'KhXs   Handles the ``wx.EVT_LEFT_UP`` event for self._panel.

:param `event`: a :class:`MouseEvent` event to be processed.r.  hhh	h)]r.  X   eventr.  hhr.  ah1X   OnLeftUp(self, event)r.  h3h4h5X   12r.  h7j.  ubh#)r.  }r.  (hX2   wx.lib.agw.aui.auibook.TabNavigatorWindow.OnMotionr.  hKh'KhXr   Handles the ``wx.EVT_MOTION`` event for self._panel.

:param `event`: a :class:`MouseEvent` event to be processed.r.  hhh	h)]r.  X   eventr.  hhr.  ah1X   OnMotion(self, event)r.  h3h4h5X   12r.  h7j.  ubh#)r.  }r.  (hX9   wx.lib.agw.aui.auibook.TabNavigatorWindow.OnNavigationKeyr.  hKh'KhX   Handles the ``wx.EVT_NAVIGATION_KEY`` for the :class:`TabNavigatorWindow`.

:param `event`: a :class:`NavigationKeyEvent` event to be processed.r.  hhh	h)]r.  X   eventr.  hhr.  ah1X   OnNavigationKey(self, event)r.  h3h4h5X   29r.  h7j.  ubh#)r.  }r.  (hX8   wx.lib.agw.aui.auibook.TabNavigatorWindow.OnPanelEraseBgr.  hKh'KhX   Handles the ``wx.EVT_ERASE_BACKGROUND`` event for :class:`TabNavigatorWindow` top panel.

:param `event`: a :class:`EraseEvent` event to be processed.

:note: This is intentionally empty, to reduce flicker.r.  hhh	h)]r.  X   eventr.  hhr.  ah1X   OnPanelEraseBg(self, event)r.  h3h4h5X   11r.  h7j.  ubh#)r.  }r.  (hX6   wx.lib.agw.aui.auibook.TabNavigatorWindow.OnPanelPaintr.  hKh'KhX   Handles the ``wx.EVT_PAINT`` event for :class:`TabNavigatorWindow` top panel.

:param `event`: a :class:`PaintEvent` event to be processed.r.  hhh	h)]r.  X   eventr.  hhr.  ah1X   OnPanelPaint(self, event)r.  h3h4h5X   40r.  h7j.  ubh#)r.  }r.  (hX=   wx.lib.agw.aui.auibook.TabNavigatorWindow.PopulateListControlr.  hKh'KhXw   Populates the :class:`TabNavigatorWindow` listbox with a list of tabs.

:param `book`: the actual :class:`AuiNotebook`.r.  hhh	h)]r.  X   bookr.  hhr.  ah1X   PopulateListControl(self, book)r.  h3h4h5X   36r.  h7j.  ubehd]r.  (]r.  X   objectr /  a]r/  (]r/  X
   simplewrapperr/  a]r/  (]r/  X   wrapperr/  a]r/  (]r/  j  a]r	/  (]r
/  j  a]r/  (]r/  j  a]r
/  (]r/  j  a]r/  (]r/  j  a]r/  (]r/  j  a]r/  (]r/  j  a]r/  ]r/  X   TabNavigatorWindowr/  aaeeeeee]r/  j  a]r/  (]r/  j  a]r/  (]r/  j  a]r/  (]r/  j  a]r/  (]r /  j  a]r!/  (]r"/  j  a]r#/  (]r$/  j  a]r%/  ]r&/  j/  aaeeeeeeeeeehk]r'/  hm]r(/  X	   wx.Dialogr)/  ah1X   TabNavigatorWindow(wx.Dialog)r*/  hpj  )r+/  }r,/  (j  ]r-/  (X)   wx.lib.agw.aui.auibook.TabNavigatorWindowr./  ]r//  X	   wx.Dialogr0/  ar1/  X	   wx.Dialogr2/  ]r3/  X   wx.TopLevelWindowr4/  ar5/  X   wx.TopLevelWindowr6/  ]r7/  X   wx.NonOwnedWindowr8/  ar9/  X   wx.NonOwnedWindowr:/  ]r;/  X	   wx.Windowr</  ar=/  X	   wx.Windowr>/  ]r?/  X
   wx.WindowBaser@/  arA/  X
   wx.WindowBaserB/  ]rC/  X
   wx.EvtHandlerrD/  arE/  X
   wx.EvtHandlerrF/  ]rG/  (X	   wx.ObjectrH/  X   wx.TrackablerI/  erJ/  X	   wx.ObjectrK/  ]rL/  rM/  X   wx.TrackablerN/  ]rO/  rP/  ej  ]rQ/  X)   wx.lib.agw.aui.auibook.TabNavigatorWindowrR/  aj  j.  ubh'Kh3hqhrX\   /home/wxpy/bb2/dist-src-py37/build/docs/sphinx/wx.lib.agw.aui.auibook.TabNavigatorWindow.txtrS/  h7j#  h5X   294rT/  j  ]rU/  (X   __init__rV/  X   CloseDialogrW/  X   GetSelectedPagerX/  X   OnItemSelectedrY/  X   OnKeyUprZ/  X
   OnLeftDownr[/  X   OnLeftUpr\/  X   OnMotionr]/  X   OnNavigationKeyr^/  X   OnPanelEraseBgr_/  X   OnPanelPaintr`/  X   PopulateListControlra/  ej  j(/  ubh)rb/  }rc/  (hX"   wx.lib.agw.aui.auibook.TabTextCtrlrd/  hKhX    Control used for in-place edit. re/  hhh	h
]rf/  (h#)rg/  }rh/  (hX+   wx.lib.agw.aui.auibook.TabTextCtrl.__init__ri/  hKh'KhX  Default class constructor.
For internal use: do not call it in your code!

:param `owner`: the :class:`AuiNotebook` owning the tab;
:param `tab`: the actual :class:`AuiTabCtrl` tab;
:param integer `page_index`: the :class:`AuiTabContainer` page index for the tab.rj/  hhh	h)]rk/  (X   ownerrl/  hhrm/  X   tabrn/  hhro/  X
   page_indexrp/  hhrq/  eh1X&   __init__(self, owner, tab, page_index)rr/  h3h4h5X   65rs/  h7jb/  ubh#)rt/  }ru/  (hX0   wx.lib.agw.aui.auibook.TabTextCtrl.AcceptChangesrv/  hKh'KhX.   Accepts/refuses the changes made by the user. rw/  hhh	h)]rx/  h1X   AcceptChanges(self)ry/  h3h4h5X   24rz/  h7jb/  ubh#)r{/  }r|/  (hX)   wx.lib.agw.aui.auibook.TabTextCtrl.Finishr}/  hKh'KhX   Finish editing. r~/  hhh	h)]r/  h1X   Finish(self)r/  h3h4h5X   11r/  h7jb/  ubh#)r/  }r/  (hX'   wx.lib.agw.aui.auibook.TabTextCtrl.itemr/  hKh'KhX#   Returns the item currently edited. r/  hhh	h)]r/  h1X
   item(self)r/  h3h4h5hIh7jb/  ubh#)r/  }r/  (hX)   wx.lib.agw.aui.auibook.TabTextCtrl.OnCharr/  hKh'KhXw   Handles the ``wx.EVT_CHAR`` event for :class:`TabTextCtrl`.

:param `event`: a :class:`KeyEvent` event to be processed.r/  hhh	h)]r/  X   eventr/  hhr/  ah1X   OnChar(self, event)r/  h3h4h5X   27r/  h7jb/  ubh#)r/  }r/  (hX*   wx.lib.agw.aui.auibook.TabTextCtrl.OnKeyUpr/  hKh'KhXy   Handles the ``wx.EVT_KEY_UP`` event for :class:`TabTextCtrl`.

:param `event`: a :class:`KeyEvent` event to be processed.r/  hhh	h)]r/  X   eventr/  hhr/  ah1X   OnKeyUp(self, event)r/  h3h4h5X   20r/  h7jb/  ubh#)r/  }r/  (hX.   wx.lib.agw.aui.auibook.TabTextCtrl.OnKillFocusr/  hKh'KhX   Handles the ``wx.EVT_KILL_FOCUS`` event for :class:`TabTextCtrl`.

:param `event`: a :class:`FocusEvent` event to be processed.r/  hhh	h)]r/  X   eventr/  hhr/  ah1X   OnKillFocus(self, event)r/  h3h4h5X   19r/  h7jb/  ubh#)r/  }r/  (hX.   wx.lib.agw.aui.auibook.TabTextCtrl.StopEditingr/  hKh'KhX   Suddenly stops the editing. r/  hhh	h)]r/  h1X   StopEditing(self)r/  h3h4h5hCh7jb/  ubehd]r/  (]r/  X   objectr/  a]r/  (]r/  X
   simplewrapperr/  a]r/  (]r/  X   wrapperr/  a]r/  (]r/  j  a]r/  (]r/  j  a]r/  (]r/  j  a]r/  (]r/  j  a]r/  (]r/  j  a]r/  (]r/  j<-  a]r/  (]r/  j?-  a]r/  ]r/  X   TabTextCtrlr/  aaeeeeee]r/  jA-  a]r/  (]r/  j<-  a]r/  (]r/  j?-  a]r/  ]r/  j/  aaee]r/  j  a]r/  (]r/  j  a]r/  (]r/  j  a]r/  (]r/  j  a]r/  (]r/  j  a]r/  (]r/  j<-  a]r/  (]r/  j?-  a]r/  ]r/  j/  aaeeeeeeeeeehk]r/  hm]r/  X   wx.lib.expando.ExpandoTextCtrlr/  ah1X   TabTextCtrl(ExpandoTextCtrl)r/  hpj  )r/  }r/  (j  ]r/  (X"   wx.lib.agw.aui.auibook.TabTextCtrlr/  ]r/  X   wx.lib.expando.ExpandoTextCtrlr/  ar/  X   wx.lib.expando.ExpandoTextCtrlr/  ]r/  X   wx.TextCtrlr/  ar/  X   wx.TextCtrlr/  ]r/  (X
   wx.Controlr/  X   wx.TextEntryr/  er/  X
   wx.Controlr/  ]r/  X	   wx.Windowr/  ar/  X	   wx.Windowr/  ]r/  X
   wx.WindowBaser/  ar/  X
   wx.WindowBaser/  ]r/  X
   wx.EvtHandlerr/  ar/  X
   wx.EvtHandlerr/  ]r/  (X	   wx.Objectr/  X   wx.Trackabler/  er/  X	   wx.Objectr/  ]r/  r 0  X   wx.Trackabler0  ]r0  r0  X   wx.TextEntryr0  ]r0  r0  ej  ]r0  X"   wx.lib.agw.aui.auibook.TabTextCtrlr0  aj  jb/  ubh'Kh3hqhrXU   /home/wxpy/bb2/dist-src-py37/build/docs/sphinx/wx.lib.agw.aui.auibook.TabTextCtrl.txtr	0  h7j#  h5X   187r
0  j  ]r0  (X   __init__r0  X
   AcceptChangesr
0  X   Finishr0  X   itemr0  X   OnCharr0  X   OnKeyUpr0  X   OnKillFocusr0  X   StopEditingr0  ej  j/  ubh#)r0  }r0  (hX"   wx.lib.agw.aui.auibook.LightColourr0  hKh'KhX   Brighten input `colour` by `percent`.

:param wx.Colour `colour`: the colour to be brightened;
:param integer `percent`: brightening percentage.r0  hhh	h)]r0  (X   colourr0  hhr0  X   percentr0  hhr0  eh1X   LightColour(colour, percent)r0  h3h4h5X   24r0  j
  X   232r0  h7j#  ubh#)r 0  }r!0  (hX)   wx.lib.agw.aui.auibook.MakeDisabledBitmapr"0  hKh'KhX   Convert the given image (in place) to a grayed-out version, appropriate for a 'disabled' appearance.

:param wx.Bitmap `bitmap`: the bitmap to gray-out.r#0  hhh	h)]r$0  X   bitmapr%0  hhr&0  ah1X   MakeDisabledBitmap(bitmap)r'0  h3h4h5j  j
  X   210r(0  h7j#  ubh#)r)0  }r*0  (hX(   wx.lib.agw.aui.auibook.RescaleScreenShotr+0  hKh'KhX   Rescales a bitmap to be `thumbnail_size` pixels wide (or tall) at maximum.

:param wx.Bitmap `bmp`: the bitmap to rescale;
:param integer `thumbnail_size`: the maximum size of every page thumbnail.r,0  hhh	h)]r-0  (X   bmpr.0  hhr/0  X   thumbnail_sizer00  X   200r10  X   200r20  r30  eh1X*   RescaleScreenShot(bmp, thumbnail_size=200)r40  h3h4h5X   49r50  j
  X   572r60  h7j#  ubh#)r70  }r80  (hX%   wx.lib.agw.aui.auibook.TakeScreenShotr90  hKh'KhX   Takes a screenshot of the screen at given position and size (`rect`).

:param wx.Rect `rect`: the screen rectangle for which we want to take a screenshot.r:0  hhh	h)]r;0  X   rectr<0  hhr=0  ah1X   TakeScreenShot(rect)r>0  h3h4h5X   39r?0  j
  X   532r@0  h7j#  ubhu)rA0  }rB0  (hX!   wx.lib.agw.aui.auibook.__author__rC0  hKh'KhX  str(object='') -> str
str(bytes_or_buffer[, encoding[, errors]]) -> str

Create a new string object from the given object. If encoding or
errors is specified, then the object must expose a data buffer
that will be decoded using the given encoding and error handler.
Otherwise, returns the result of object.__str__() (if defined)
or repr(object).
encoding defaults to sys.getdefaultencoding().
errors defaults to 'strict'.rD0  hhh	hzX)   'Andrea Gavana <andrea.gavana@gmail.com>'rE0  h|X   strrF0  h3h~h7j#  ubhu)rG0  }rH0  (hX   wx.lib.agw.aui.auibook.__date__rI0  hKh'KhX  str(object='') -> str
str(bytes_or_buffer[, encoding[, errors]]) -> str

Create a new string object from the given object. If encoding or
errors is specified, then the object must expose a data buffer
that will be decoded using the given encoding and error handler.
Otherwise, returns the result of object.__str__() (if defined)
or repr(object).
encoding defaults to sys.getdefaultencoding().
errors defaults to 'strict'.rJ0  hhh	hzX   '31 March 2009'rK0  h|X   strrL0  h3h~h7j#  ubhu)rM0  }rN0  (hX(   wx.lib.agw.aui.auibook.actionClickButtonrO0  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4rP0  hhh	hzX   2rQ0  h|X   intrR0  h3h~h7j#  ubhu)rS0  }rT0  (hX)   wx.lib.agw.aui.auibook.actionClickCaptionrU0  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4rV0  hhh	hzX   3rW0  h|X   intrX0  h3h~h7j#  ubhu)rY0  }rZ0  (hX-   wx.lib.agw.aui.auibook.actionDragFloatingPaner[0  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r\0  hhh	hzX   5r]0  h|X   intr^0  h3h~h7j#  ubhu)r_0  }r`0  (hX,   wx.lib.agw.aui.auibook.actionDragMovablePanera0  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4rb0  hhh	hzX   6rc0  h|X   intrd0  h3h~h7j#  ubhu)re0  }rf0  (hX,   wx.lib.agw.aui.auibook.actionDragToolbarPanerg0  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4rh0  hhh	hzX   4ri0  h|X   intrj0  h3h~h7j#  ubhu)rk0  }rl0  (hX!   wx.lib.agw.aui.auibook.actionNonerm0  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4rn0  hhh	hzX   0ro0  h|X   intrp0  h3h~h7j#  ubhu)rq0  }rr0  (hX#   wx.lib.agw.aui.auibook.actionResizers0  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4rt0  hhh	hzX   1ru0  h|X   intrv0  h3h~h7j#  ubhu)rw0  }rx0  (hX"   wx.lib.agw.aui.auibook.aero_deniedry0  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.rz0  hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f7afe726e10>r{0  h|X$   wx.lib.embeddedimage.PyEmbeddedImager|0  h3h~h7j#  ubhu)r}0  }r~0  (hX%   wx.lib.agw.aui.auibook.aero_dock_paner0  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.r0  hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f7afe726790>r0  h|X$   wx.lib.embeddedimage.PyEmbeddedImager0  h3h~h7j#  ubhu)r0  }r0  (hX,   wx.lib.agw.aui.auibook.aero_dock_pane_bottomr0  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.r0  hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f7afe726910>r0  h|X$   wx.lib.embeddedimage.PyEmbeddedImager0  h3h~h7j#  ubhu)r0  }r0  (hX,   wx.lib.agw.aui.auibook.aero_dock_pane_centerr0  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.r0  hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f7afe726950>r0  h|X$   wx.lib.embeddedimage.PyEmbeddedImager0  h3h~h7j#  ubhu)r0  }r0  (hX,   wx.lib.agw.aui.auibook.aero_dock_pane_deniedr0  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.r0  hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f7afe7268d0>r0  h|X$   wx.lib.embeddedimage.PyEmbeddedImager0  h3h~h7j#  ubhu)r0  }r0  (hX*   wx.lib.agw.aui.auibook.aero_dock_pane_leftr0  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.r0  hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f7afe726990>r0  h|X$   wx.lib.embeddedimage.PyEmbeddedImager0  h3h~h7j#  ubhu)r0  }r0  (hX+   wx.lib.agw.aui.auibook.aero_dock_pane_rightr0  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.r0  hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f7afe7269d0>r0  h|X$   wx.lib.embeddedimage.PyEmbeddedImager0  h3h~h7j#  ubhu)r0  }r0  (hX)   wx.lib.agw.aui.auibook.aero_dock_pane_topr0  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.r0  hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f7afe726a10>r0  h|X$   wx.lib.embeddedimage.PyEmbeddedImager0  h3h~h7j#  ubhu)r0  }r0  (hX    wx.lib.agw.aui.auibook.aero_downr0  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.r0  hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f7afe726a50>r0  h|X$   wx.lib.embeddedimage.PyEmbeddedImager0  h3h~h7j#  ubhu)r0  }r0  (hX&   wx.lib.agw.aui.auibook.aero_down_focusr0  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.r0  hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f7afe726a90>r0  h|X$   wx.lib.embeddedimage.PyEmbeddedImager0  h3h~h7j#  ubhu)r0  }r0  (hX-   wx.lib.agw.aui.auibook.aero_down_focus_singler0  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.r0  hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f7afe726a90>r0  h|X$   wx.lib.embeddedimage.PyEmbeddedImager0  h3h~h7j#  ubhu)r0  }r0  (hX'   wx.lib.agw.aui.auibook.aero_down_singler0  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.r0  hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f7afe726ad0>r0  h|X$   wx.lib.embeddedimage.PyEmbeddedImager0  h3h~h7j#  ubhu)r0  }r0  (hX    wx.lib.agw.aui.auibook.aero_leftr0  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.r0  hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f7afe726b10>r0  h|X$   wx.lib.embeddedimage.PyEmbeddedImager0  h3h~h7j#  ubhu)r0  }r0  (hX&   wx.lib.agw.aui.auibook.aero_left_focusr0  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.r0  hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f7afe726b50>r0  h|X$   wx.lib.embeddedimage.PyEmbeddedImager0  h3h~h7j#  ubhu)r0  }r0  (hX-   wx.lib.agw.aui.auibook.aero_left_focus_singler0  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.r0  hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f7afe726b50>r0  h|X$   wx.lib.embeddedimage.PyEmbeddedImager0  h3h~h7j#  ubhu)r0  }r0  (hX'   wx.lib.agw.aui.auibook.aero_left_singler0  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.r0  hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f7afe726b90>r0  h|X$   wx.lib.embeddedimage.PyEmbeddedImager0  h3h~h7j#  ubhu)r0  }r0  (hX!   wx.lib.agw.aui.auibook.aero_rightr0  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.r0  hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f7afe726bd0>r0  h|X$   wx.lib.embeddedimage.PyEmbeddedImager0  h3h~h7j#  ubhu)r0  }r0  (hX'   wx.lib.agw.aui.auibook.aero_right_focusr0  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.r0  hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f7afe726c10>r0  h|X$   wx.lib.embeddedimage.PyEmbeddedImager0  h3h~h7j#  ubhu)r0  }r0  (hX.   wx.lib.agw.aui.auibook.aero_right_focus_singler0  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.r0  hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f7afe726c10>r0  h|X$   wx.lib.embeddedimage.PyEmbeddedImager0  h3h~h7j#  ubhu)r0  }r0  (hX(   wx.lib.agw.aui.auibook.aero_right_singler0  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.r0  hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f7afe726c50>r0  h|X$   wx.lib.embeddedimage.PyEmbeddedImager0  h3h~h7j#  ubhu)r0  }r0  (hX   wx.lib.agw.aui.auibook.aero_tabr0  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.r0  hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f7afe726c90>r0  h|X$   wx.lib.embeddedimage.PyEmbeddedImager0  h3h~h7j#  ubhu)r0  }r0  (hX%   wx.lib.agw.aui.auibook.aero_tab_focusr0  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.r0  hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f7afe726cd0>r0  h|X$   wx.lib.embeddedimage.PyEmbeddedImager0  h3h~h7j#  ubhu)r0  }r0  (hX,   wx.lib.agw.aui.auibook.aero_tab_focus_singler0  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.r0  hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f7afe726cd0>r0  h|X$   wx.lib.embeddedimage.PyEmbeddedImager 1  h3h~h7j#  ubhu)r1  }r1  (hX&   wx.lib.agw.aui.auibook.aero_tab_singler1  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.r1  hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f7afe726d10>r1  h|X$   wx.lib.embeddedimage.PyEmbeddedImager1  h3h~h7j#  ubhu)r1  }r1  (hX   wx.lib.agw.aui.auibook.aero_upr	1  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.r
1  hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f7afe726d50>r1  h|X$   wx.lib.embeddedimage.PyEmbeddedImager1  h3h~h7j#  ubhu)r
1  }r1  (hX$   wx.lib.agw.aui.auibook.aero_up_focusr1  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.r1  hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f7afe726d90>r1  h|X$   wx.lib.embeddedimage.PyEmbeddedImager1  h3h~h7j#  ubhu)r1  }r1  (hX+   wx.lib.agw.aui.auibook.aero_up_focus_singler1  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.r1  hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f7afe726d90>r1  h|X$   wx.lib.embeddedimage.PyEmbeddedImager1  h3h~h7j#  ubhu)r1  }r1  (hX%   wx.lib.agw.aui.auibook.aero_up_singler1  hKh'KhX  PyEmbeddedImage is primarily intended to be used by code generated
by img2py as a means of embedding image data in a python module so
the image can be used at runtime without needing to access the
image from an image file.  This makes distributing icons and such
that an application uses simpler since tools like py2exe will
automatically bundle modules that are imported, and the
application doesn't have to worry about how to locate the image
files on the user's filesystem.

The class can also be used for image data that may be acquired
from some other source at runtime, such as over the network or
from a database.  In this case pass False for isBase64 (unless the
data actually is base64 encoded.)  Any image type that
wx.Image can handle should be okay.r1  hhh	hzX?   <wx.lib.embeddedimage.PyEmbeddedImage object at 0x7f7afe726dd0>r1  h|X$   wx.lib.embeddedimage.PyEmbeddedImager1  h3h~h7j#  ubhu)r1  }r 1  (hX%   wx.lib.agw.aui.auibook.aeroguideSizeXr!1  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r"1  hhh	hzX   31r#1  h|X   intr$1  h3h~h7j#  ubhu)r%1  }r&1  (hX%   wx.lib.agw.aui.auibook.aeroguideSizeYr'1  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r(1  hhh	hzX   32r)1  h|X   intr*1  h3h~h7j#  ubhu)r+1  }r,1  (hX'   wx.lib.agw.aui.auibook.AUI_BUTTON_CLOSEr-1  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r.1  hhh	hzX   101r/1  h|X   intr01  h3h~h7j#  ubhu)r11  }r21  (hX)   wx.lib.agw.aui.auibook.AUI_BUTTON_CUSTOM1r31  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r41  hhh	hzX   201r51  h|X   intr61  h3h~h7j#  ubhu)r71  }r81  (hX)   wx.lib.agw.aui.auibook.AUI_BUTTON_CUSTOM2r91  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r:1  hhh	hzX   202r;1  h|X   intr<1  h3h~h7j#  ubhu)r=1  }r>1  (hX)   wx.lib.agw.aui.auibook.AUI_BUTTON_CUSTOM3r?1  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r@1  hhh	hzX   203rA1  h|X   intrB1  h3h~h7j#  ubhu)rC1  }rD1  (hX)   wx.lib.agw.aui.auibook.AUI_BUTTON_CUSTOM4rE1  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4rF1  hhh	hzX   204rG1  h|X   intrH1  h3h~h7j#  ubhu)rI1  }rJ1  (hX)   wx.lib.agw.aui.auibook.AUI_BUTTON_CUSTOM5rK1  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4rL1  hhh	hzX   205rM1  h|X   intrN1  h3h~h7j#  ubhu)rO1  }rP1  (hX)   wx.lib.agw.aui.auibook.AUI_BUTTON_CUSTOM6rQ1  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4rR1  hhh	hzX   206rS1  h|X   intrT1  h3h~h7j#  ubhu)rU1  }rV1  (hX)   wx.lib.agw.aui.auibook.AUI_BUTTON_CUSTOM7rW1  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4rX1  hhh	hzX   207rY1  h|X   intrZ1  h3h~h7j#  ubhu)r[1  }r\1  (hX)   wx.lib.agw.aui.auibook.AUI_BUTTON_CUSTOM8r]1  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r^1  hhh	hzX   208r_1  h|X   intr`1  h3h~h7j#  ubhu)ra1  }rb1  (hX)   wx.lib.agw.aui.auibook.AUI_BUTTON_CUSTOM9rc1  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4rd1  hhh	hzX   209re1  h|X   intrf1  h3h~h7j#  ubhu)rg1  }rh1  (hX&   wx.lib.agw.aui.auibook.AUI_BUTTON_DOWNri1  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4rj1  hhh	hzX   110rk1  h|X   intrl1  h3h~h7j#  ubhu)rm1  }rn1  (hX&   wx.lib.agw.aui.auibook.AUI_BUTTON_LEFTro1  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4rp1  hhh	hzX   107rq1  h|X   intrr1  h3h~h7j#  ubhu)rs1  }rt1  (hX2   wx.lib.agw.aui.auibook.AUI_BUTTON_MAXIMIZE_RESTOREru1  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4rv1  hhh	hzX   102rw1  h|X   intrx1  h3h~h7j#  ubhu)ry1  }rz1  (hX*   wx.lib.agw.aui.auibook.AUI_BUTTON_MINIMIZEr{1  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r|1  hhh	hzX   103r}1  h|X   intr~1  h3h~h7j#  ubhu)r1  }r1  (hX)   wx.lib.agw.aui.auibook.AUI_BUTTON_OPTIONSr1  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  Valid bases are 0 and 2-36.
Base 0 means to interpret the base from the string as an integer literal.
>>> int('0b100', base=0)
4r1  hhh	hzX   105r1  h|X   intr1  h3h~h7j#  ubhu)r1  }r1  (hX%   wx.lib.agw.aui.auibook.AUI_BUTTON_PINr1  hKh'KhX]  int([x]) -> integer
int(x, base=10) -> integer

Convert a number or string to an integer, or return 0 if no arguments
are given.  If x is a number, return x.__int__().  For floating point
numbers, this truncates towards zero.

If x is not a number or if base is given, then x must be a string,
bytes, or bytearray instance representing an integer literal in the
given base.  The literal can be preceded by '+' or '-' and be surrounded
by whitespace.  The base defaults to 10.  V