/* mimetype-test.c generated by valac 0.43.6.10-d9d11, the Vala compiler
 * generated from mimetype-test.vala, do not modify */

/* where-clause-test.vala
 *
 * Copyright © 2011-2012 Collabora Ltd.
 *             By Siegfried-Angel Gevatter Pujals <siegfried@gevatter.com>
 * Copyright © 2010 Canonical, Ltd.
 *             By Mikkel Kamstrup Erlandsen <mikkel.kamstrup@canonical.com>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 2.1 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include "zeitgeist-datamodel.h"

#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

gint _vala_main (gchar** args,
                 gint args_length1);
void mime_type_basic_test (void);
static void _mime_type_basic_test_gtest_func (void);
void mime_type_regex_test (void);
static void _mime_type_regex_test_gtest_func (void);
void mime_type_none_test (void);
static void _mime_type_none_test_gtest_func (void);
void mime_type_null_test (void);
static void _mime_type_null_test_gtest_func (void);
void mime_type_registration_test (void);
static void _mime_type_registration_test_gtest_func (void);
void uri_scheme_basic_test (void);
static void _uri_scheme_basic_test_gtest_func (void);
void uri_scheme_none_test (void);
static void _uri_scheme_none_test_gtest_func (void);
void uri_scheme_registration_test (void);
static void _uri_scheme_registration_test_gtest_func (void);

static void
_mime_type_basic_test_gtest_func (void)
{
#line 30 "mimetype-test.vala"
	mime_type_basic_test ();
#line 62 "mimetype-test.c"
}

static void
_mime_type_regex_test_gtest_func (void)
{
#line 31 "mimetype-test.vala"
	mime_type_regex_test ();
#line 70 "mimetype-test.c"
}

static void
_mime_type_none_test_gtest_func (void)
{
#line 32 "mimetype-test.vala"
	mime_type_none_test ();
#line 78 "mimetype-test.c"
}

static void
_mime_type_null_test_gtest_func (void)
{
#line 33 "mimetype-test.vala"
	mime_type_null_test ();
#line 86 "mimetype-test.c"
}

static void
_mime_type_registration_test_gtest_func (void)
{
#line 34 "mimetype-test.vala"
	mime_type_registration_test ();
#line 94 "mimetype-test.c"
}

static void
_uri_scheme_basic_test_gtest_func (void)
{
#line 36 "mimetype-test.vala"
	uri_scheme_basic_test ();
#line 102 "mimetype-test.c"
}

static void
_uri_scheme_none_test_gtest_func (void)
{
#line 37 "mimetype-test.vala"
	uri_scheme_none_test ();
#line 110 "mimetype-test.c"
}

static void
_uri_scheme_registration_test_gtest_func (void)
{
#line 38 "mimetype-test.vala"
	uri_scheme_registration_test ();
#line 118 "mimetype-test.c"
}

gint
_vala_main (gchar** args,
            gint args_length1)
{
	gint result = 0;
#line 28 "mimetype-test.vala"
	g_test_init ((gint*) (&args_length1), &args, NULL);
#line 30 "mimetype-test.vala"
	g_test_add_func ("/MimeType/basic", _mime_type_basic_test_gtest_func);
#line 31 "mimetype-test.vala"
	g_test_add_func ("/MimeType/regex", _mime_type_regex_test_gtest_func);
#line 32 "mimetype-test.vala"
	g_test_add_func ("/MimeType/none", _mime_type_none_test_gtest_func);
#line 33 "mimetype-test.vala"
	g_test_add_func ("/MimeType/null", _mime_type_null_test_gtest_func);
#line 34 "mimetype-test.vala"
	g_test_add_func ("/MimeType/register", _mime_type_registration_test_gtest_func);
#line 36 "mimetype-test.vala"
	g_test_add_func ("/UriScheme/basic", _uri_scheme_basic_test_gtest_func);
#line 37 "mimetype-test.vala"
	g_test_add_func ("/UriScheme/none", _uri_scheme_none_test_gtest_func);
#line 38 "mimetype-test.vala"
	g_test_add_func ("/UriScheme/register", _uri_scheme_registration_test_gtest_func);
#line 40 "mimetype-test.vala"
	result = g_test_run ();
#line 40 "mimetype-test.vala"
	return result;
#line 148 "mimetype-test.c"
}

int
main (int argc,
      char ** argv)
{
#line 26 "mimetype-test.vala"
	return _vala_main (argv, argc);
#line 157 "mimetype-test.c"
}

void
mime_type_basic_test (void)
{
	const gchar* _tmp0_;
#line 45 "mimetype-test.vala"
	_tmp0_ = zeitgeist_interpretation_for_mimetype ("text/plain");
#line 45 "mimetype-test.vala"
	g_assert_cmpstr (ZEITGEIST_NFO_TEXT_DOCUMENT, ==, _tmp0_);
#line 168 "mimetype-test.c"
}

void
mime_type_regex_test (void)
{
	const gchar* _tmp0_;
	const gchar* _tmp1_;
#line 52 "mimetype-test.vala"
	_tmp0_ = zeitgeist_interpretation_for_mimetype ("application/x-applix-FOOBAR");
#line 52 "mimetype-test.vala"
	g_assert_cmpstr (ZEITGEIST_NFO_DOCUMENT, ==, _tmp0_);
#line 56 "mimetype-test.vala"
	_tmp1_ = zeitgeist_interpretation_for_mimetype ("application/x-applix-spreadsheet");
#line 56 "mimetype-test.vala"
	g_assert_cmpstr (ZEITGEIST_NFO_SPREADSHEET, ==, _tmp1_);
#line 184 "mimetype-test.c"
}

void
mime_type_none_test (void)
{
	const gchar* _tmp0_;
#line 62 "mimetype-test.vala"
	_tmp0_ = zeitgeist_interpretation_for_mimetype ("foo/bar");
#line 62 "mimetype-test.vala"
	_vala_assert (_tmp0_ == NULL, "interpretation_for_mimetype (\"foo/bar\") == null");
#line 195 "mimetype-test.c"
}

void
mime_type_null_test (void)
{
	const gchar* _tmp0_;
#line 67 "mimetype-test.vala"
	_tmp0_ = zeitgeist_interpretation_for_mimetype (NULL);
#line 67 "mimetype-test.vala"
	_vala_assert (_tmp0_ == NULL, "interpretation_for_mimetype (null) == null");
#line 206 "mimetype-test.c"
}

void
mime_type_registration_test (void)
{
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	GError* _inner_error0_ = NULL;
#line 72 "mimetype-test.vala"
	zeitgeist_register_mimetype ("awesome/bird", "Bluebird");
#line 217 "mimetype-test.c"
	{
#line 75 "mimetype-test.vala"
		zeitgeist_register_mimetype_regex ("everything/.*", "is nothing");
#line 221 "mimetype-test.c"
	}
	goto __finally0;
	__catch0_g_regex_error:
	{
		GError* e = NULL;
#line 73 "mimetype-test.vala"
		e = _inner_error0_;
#line 73 "mimetype-test.vala"
		_inner_error0_ = NULL;
#line 77 "mimetype-test.vala"
		_vala_assert (FALSE, "false");
#line 73 "mimetype-test.vala"
		_g_error_free0 (e);
#line 235 "mimetype-test.c"
	}
	__finally0:
#line 73 "mimetype-test.vala"
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 73 "mimetype-test.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 73 "mimetype-test.vala"
		g_clear_error (&_inner_error0_);
#line 73 "mimetype-test.vala"
		return;
#line 246 "mimetype-test.c"
	}
#line 80 "mimetype-test.vala"
	mime_type_basic_test ();
#line 81 "mimetype-test.vala"
	mime_type_regex_test ();
#line 82 "mimetype-test.vala"
	mime_type_none_test ();
#line 84 "mimetype-test.vala"
	_tmp0_ = zeitgeist_interpretation_for_mimetype ("awesome/bird");
#line 84 "mimetype-test.vala"
	g_assert_cmpstr ("Bluebird", ==, _tmp0_);
#line 86 "mimetype-test.vala"
	_tmp1_ = zeitgeist_interpretation_for_mimetype ("everything/everywhere");
#line 86 "mimetype-test.vala"
	g_assert_cmpstr ("is nothing", ==, _tmp1_);
#line 262 "mimetype-test.c"
}

void
uri_scheme_basic_test (void)
{
	const gchar* _tmp0_;
	const gchar* _tmp1_;
#line 92 "mimetype-test.vala"
	_tmp0_ = zeitgeist_manifestation_for_uri ("file:///tmp/foo.txt");
#line 92 "mimetype-test.vala"
	g_assert_cmpstr (ZEITGEIST_NFO_FILE_DATA_OBJECT, ==, _tmp0_);
#line 94 "mimetype-test.vala"
	_tmp1_ = zeitgeist_manifestation_for_uri ("ftp://ftp.example.com");
#line 94 "mimetype-test.vala"
	g_assert_cmpstr (ZEITGEIST_NFO_REMOTE_DATA_OBJECT, ==, _tmp1_);
#line 278 "mimetype-test.c"
}

void
uri_scheme_none_test (void)
{
	const gchar* _tmp0_;
#line 100 "mimetype-test.vala"
	_tmp0_ = zeitgeist_manifestation_for_uri ("asdf://awesomehttp://");
#line 100 "mimetype-test.vala"
	_vala_assert (_tmp0_ == NULL, "manifestation_for_uri (\"asdf://awesomehttp://\") == null");
#line 289 "mimetype-test.c"
}

void
uri_scheme_registration_test (void)
{
	const gchar* _tmp0_;
#line 105 "mimetype-test.vala"
	zeitgeist_register_uri_scheme ("42://", "the answer");
#line 107 "mimetype-test.vala"
	uri_scheme_basic_test ();
#line 108 "mimetype-test.vala"
	uri_scheme_none_test ();
#line 110 "mimetype-test.vala"
	_tmp0_ = zeitgeist_manifestation_for_uri ("42://what is it?");
#line 110 "mimetype-test.vala"
	g_assert_cmpstr ("the answer", ==, _tmp0_);
#line 306 "mimetype-test.c"
}

