/*
 * Decompiled with CFR 0.152.
 */
class ACLEntry {
    FileManager filemgr;
    RemoteFile file;
    boolean def;
    String type;
    String owner;
    boolean read;
    boolean write;
    boolean exec;
    boolean empty_owner = false;

    ACLEntry(String string, ACLWindow aCLWindow) {
        String string2;
        this.filemgr = aCLWindow.filemgr;
        this.file = aCLWindow.file;
        StringSplitter stringSplitter = new StringSplitter(string, ':');
        this.type = stringSplitter.nextToken();
        if (this.type.equals("default")) {
            this.def = true;
            this.type = stringSplitter.nextToken();
        }
        if (!this.type.equals("mask") && !this.type.equals("other")) {
            this.owner = stringSplitter.nextToken();
            if (this.owner.length() == 0) {
                this.owner = null;
            }
        }
        if ((string2 = stringSplitter.nextToken()).length() == 0) {
            string2 = stringSplitter.nextToken();
            this.empty_owner = true;
        }
        this.read = string2.charAt(0) == 'r';
        this.write = string2.charAt(1) == 'w';
        this.exec = string2.charAt(2) == 'x';
    }

    ACLEntry(ACLWindow aCLWindow) {
        this.filemgr = aCLWindow.filemgr;
        this.file = aCLWindow.file;
    }

    String[] getRow() {
        String[] stringArray = new String[3];
        String string = this.def ? "acltype_default_" + this.type : "acltype_" + this.type;
        stringArray[0] = this.filemgr.text(string);
        stringArray[1] = this.type.equals("mask") || this.type.equals("other") || this.def && this.owner == null ? "" : (this.owner != null ? this.owner : (this.type.equals("user") ? this.filemgr.text("eacl_user", this.file.user) : this.filemgr.text("eacl_group", this.file.group)));
        stringArray[2] = "";
        if (this.read) {
            stringArray[2] = stringArray[2] + this.filemgr.text("info_read") + " ";
        }
        if (this.write) {
            stringArray[2] = stringArray[2] + this.filemgr.text("info_write") + " ";
        }
        if (this.exec) {
            stringArray[2] = stringArray[2] + this.filemgr.text("info_exec") + " ";
        }
        return stringArray;
    }

    public String toString() {
        String string = this.def ? "default:" : "";
        string = string + this.type + ":";
        if (!this.type.equals("mask") && !this.type.equals("other") || this.empty_owner) {
            string = string + (this.owner == null ? "" : this.owner) + ":";
        }
        string = string + (this.read ? (char)'r' : '-');
        string = string + (this.write ? (char)'w' : '-');
        string = string + (this.exec ? (char)'x' : '-');
        return string;
    }
}

