/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextField;

class RenameWindow
extends FixedFrame
implements CbButtonCallback {
    FileManager filemgr;
    RemoteFile file;
    TextField oldname;
    TextField newname;
    CbButton rename_b;
    CbButton cancel_b;

    RenameWindow(FileManager fileManager, RemoteFile remoteFile) {
        this.filemgr = fileManager;
        this.file = remoteFile;
        this.setLayout(new BorderLayout());
        this.setTitle(this.filemgr.text("rename_title", this.file.path));
        Panel panel = new Panel();
        Panel panel2 = new Panel();
        panel.setLayout(new GridLayout(0, 1));
        panel.add(new Label(this.filemgr.text("rename_old")));
        panel.add(new Label(this.filemgr.text("rename_new")));
        panel2.setLayout(new GridLayout(0, 1));
        this.oldname = new TextField(this.file.name, 20);
        panel2.add(this.oldname);
        this.oldname.setEditable(false);
        this.oldname.setFont(this.filemgr.fixed);
        this.newname = new TextField(this.file.name, 20);
        panel2.add(this.newname);
        this.newname.select(this.file.name.length(), this.file.name.length());
        this.newname.setFont(this.filemgr.fixed);
        this.add("West", panel);
        this.add("Center", panel2);
        Panel panel3 = new Panel();
        panel3.setLayout(new FlowLayout(1));
        this.rename_b = new CbButton(this.filemgr.get_image("save.gif"), this.filemgr.text("rename_ok"), 0, this);
        panel3.add(this.rename_b);
        this.cancel_b = new CbButton(this.filemgr.get_image("cancel.gif"), this.filemgr.text("cancel"), 0, this);
        panel3.add(this.cancel_b);
        this.add("South", panel3);
        this.pack();
        this.show();
        Util.recursiveBody(this);
    }

    public void click(CbButton cbButton) {
        if (cbButton == this.rename_b) {
            RemoteFile remoteFile;
            Object object;
            int n;
            String string;
            String string2 = this.newname.getText().trim();
            if (string2.length() == 0) {
                return;
            }
            if (string2.indexOf(47) >= 0) {
                string = string2.startsWith("/") ? string2 : this.file.directory.path + "/" + string2;
                n = string.lastIndexOf(47);
                object = n == 0 ? "/" : string.substring(0, n);
                remoteFile = this.filemgr.find_directory((String)object, false);
            } else {
                remoteFile = this.file.directory;
                n = this.file.path.lastIndexOf(47);
                string = this.file.path.substring(0, n) + "/" + string2;
            }
            n = string.lastIndexOf(47);
            string2 = string.substring(n + 1);
            object = remoteFile.find(string2);
            if (object != null) {
                new ErrorWindow(this.filemgr.text("rename_eexists", string2));
                return;
            }
            String[] stringArray = this.filemgr.get_text("rename.cgi?old=" + FileManager.urlize(this.file.path) + "&new=" + FileManager.urlize(string));
            if (stringArray[0].length() > 0) {
                new ErrorWindow(this.filemgr.text("rename_efailed", stringArray[0]));
                return;
            }
            this.file.name = string2;
            this.file.path = string;
            this.file.directory.delete(this.file);
            remoteFile.list();
            remoteFile.add(this.file);
            this.file.directory = remoteFile;
            this.file.list = null;
            FileNode fileNode = (FileNode)this.filemgr.nodemap.get(this.file.directory);
            FileNode fileNode2 = (FileNode)this.filemgr.nodemap.get(this.file);
            if (fileNode != null && fileNode2 != null) {
                fileNode2.text = this.file.name;
                fileNode.ch.removeElement(fileNode2);
                fileNode.add(fileNode2);
                this.dispose();
                this.filemgr.dirs.redraw();
            }
            this.filemgr.show_files(this.filemgr.showing_files);
            this.dispose();
        } else if (cbButton == this.cancel_b) {
            this.dispose();
        }
    }
}

